/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.util;

import com.github.pagehelper.IPage;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageException;
import com.github.pagehelper.util.ClassUtil;
import com.github.pagehelper.util.MetaObjectUtil;
import com.github.pagehelper.util.StringUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.reflection.MetaObject;

public abstract class PageObjectUtil {
    protected static Boolean hasRequest;
    protected static Class<?> requestClass;
    protected static Method getParameterMap;
    protected static Map<String, String> PARAMS;

    public static <T> Page<T> getPageFromObject(Object params, boolean required) {
        Object pageSizeZero;
        Object reasonable;
        int pageSize;
        int pageNum;
        if (params == null) {
            throw new PageException("unable to get paginated query parameters!");
        }
        if (params instanceof IPage) {
            IPage pageParams = (IPage)params;
            Page page = null;
            if (pageParams.getPageNum() != null && pageParams.getPageSize() != null) {
                page = new Page(pageParams.getPageNum(), pageParams.getPageSize());
            }
            if (StringUtil.isNotEmpty(pageParams.getOrderBy())) {
                if (page != null) {
                    page.setOrderBy(pageParams.getOrderBy());
                } else {
                    page = new Page();
                    page.setOrderBy(pageParams.getOrderBy());
                    page.setOrderByOnly(true);
                }
            }
            return page;
        }
        MetaObject paramsObject = null;
        if (hasRequest.booleanValue() && requestClass.isAssignableFrom(params.getClass())) {
            try {
                paramsObject = MetaObjectUtil.forObject(getParameterMap.invoke(params, new Object[0]));
            }
            catch (Exception exception) {}
        } else {
            paramsObject = MetaObjectUtil.forObject(params);
        }
        if (paramsObject == null) {
            throw new PageException("The pagination query parameter failed to be processed!");
        }
        Object orderBy = PageObjectUtil.getParamValue(paramsObject, "orderBy", false);
        boolean hasOrderBy = false;
        if (orderBy != null && orderBy.toString().length() > 0) {
            hasOrderBy = true;
        }
        try {
            Object _pageNum = PageObjectUtil.getParamValue(paramsObject, "pageNum", required);
            Object _pageSize = PageObjectUtil.getParamValue(paramsObject, "pageSize", required);
            if (_pageNum == null || _pageSize == null) {
                if (hasOrderBy) {
                    Page page = new Page();
                    page.setOrderBy(orderBy.toString());
                    page.setOrderByOnly(true);
                    return page;
                }
                return null;
            }
            pageNum = Integer.parseInt(String.valueOf(_pageNum));
            pageSize = Integer.parseInt(String.valueOf(_pageSize));
        }
        catch (NumberFormatException e) {
            throw new PageException("pagination parameters are not a valid number type!", e);
        }
        Page page = new Page(pageNum, pageSize);
        Object _count = PageObjectUtil.getParamValue(paramsObject, "count", false);
        if (_count != null) {
            page.setCount(Boolean.valueOf(String.valueOf(_count)));
        }
        if (hasOrderBy) {
            page.setOrderBy(orderBy.toString());
        }
        if ((reasonable = PageObjectUtil.getParamValue(paramsObject, "reasonable", false)) != null) {
            page.setReasonable(Boolean.valueOf(String.valueOf(reasonable)));
        }
        if ((pageSizeZero = PageObjectUtil.getParamValue(paramsObject, "pageSizeZero", false)) != null) {
            page.setPageSizeZero(Boolean.valueOf(String.valueOf(pageSizeZero)));
        }
        return page;
    }

    protected static Object getParamValue(MetaObject paramsObject, String paramName, boolean required) {
        Object value = null;
        if (paramsObject.hasGetter(PARAMS.get(paramName))) {
            value = paramsObject.getValue(PARAMS.get(paramName));
        }
        if (value != null && value.getClass().isArray()) {
            Object[] values = (Object[])value;
            value = values.length == 0 ? null : values[0];
        }
        if (required && value == null) {
            throw new PageException("Paginated queries are missing the necessary parameters:" + PARAMS.get(paramName));
        }
        return value;
    }

    public static void setParams(String params) {
        if (StringUtil.isNotEmpty(params)) {
            String[] ps;
            for (String s : ps = params.split("[;|,|&]")) {
                String[] ss = s.split("[=|:]");
                if (ss.length != 2) continue;
                PARAMS.put(ss[0], ss[1]);
            }
        }
    }

    static {
        PARAMS = new HashMap<String, String>(6, 1.0f);
        try {
            requestClass = ClassUtil.getServletRequestClass();
            getParameterMap = requestClass.getMethod("getParameterMap", new Class[0]);
            hasRequest = true;
        }
        catch (Throwable e) {
            hasRequest = false;
        }
        PARAMS.put("pageNum", "pageNum");
        PARAMS.put("pageSize", "pageSize");
        PARAMS.put("count", "countSql");
        PARAMS.put("orderBy", "orderBy");
        PARAMS.put("reasonable", "reasonable");
        PARAMS.put("pageSizeZero", "pageSizeZero");
    }
}

