/*-
 * #%L
 * JSQLParser library
 * %%
 * Copyright (C) 2004 - 2024 JSQLParser
 * %%
 * Dual licensed under GNU LGPL 2.1 or Apache License 2.0
 * #L%
 */
/* CCJSqlParser.java */
/* Generated By:JJTree&JavaCC: Do not edit this line. CCJSqlParser.java */
package net.sf.jsqlparser.parser;

import java.lang.reflect.Field;
import java.lang.Integer;

import net.sf.jsqlparser.parser.feature.*;
import net.sf.jsqlparser.expression.*;
import net.sf.jsqlparser.expression.operators.arithmetic.*;
import net.sf.jsqlparser.expression.operators.conditional.*;
import net.sf.jsqlparser.expression.operators.relational.*;
import net.sf.jsqlparser.schema.*;
import net.sf.jsqlparser.statement.*;
import net.sf.jsqlparser.statement.analyze.*;
import net.sf.jsqlparser.statement.alter.*;
import net.sf.jsqlparser.statement.alter.sequence.*;
import net.sf.jsqlparser.statement.comment.*;
import net.sf.jsqlparser.statement.create.function.*;
import net.sf.jsqlparser.statement.create.index.*;
import net.sf.jsqlparser.statement.create.procedure.*;
import net.sf.jsqlparser.statement.create.schema.*;
import net.sf.jsqlparser.statement.create.synonym.*;
import net.sf.jsqlparser.statement.create.sequence.*;
import net.sf.jsqlparser.statement.create.table.*;
import net.sf.jsqlparser.statement.create.view.*;
import net.sf.jsqlparser.statement.delete.*;
import net.sf.jsqlparser.statement.drop.*;
import net.sf.jsqlparser.statement.insert.*;
import net.sf.jsqlparser.statement.execute.*;
import net.sf.jsqlparser.statement.select.*;
import net.sf.jsqlparser.statement.refresh.*;
import net.sf.jsqlparser.statement.show.*;
import net.sf.jsqlparser.statement.truncate.*;
import net.sf.jsqlparser.statement.update.*;
import net.sf.jsqlparser.statement.upsert.*;
import net.sf.jsqlparser.statement.merge.*;
import net.sf.jsqlparser.statement.grant.*;
import java.util.*;
import java.util.AbstractMap.SimpleEntry;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * The parser generated by JavaCC
 */
public class CCJSqlParser extends AbstractJSqlParser<CCJSqlParser>/*@bgen(jjtree)*/implements CCJSqlParserTreeConstants, CCJSqlParserConstants {/*@bgen(jjtree)*/
  protected JJTCCJSqlParserState jjtree = new JJTCCJSqlParserState();public final static Logger LOGGER = Logger.getLogger(CCJSqlParser.class.getName());
    public int bracketsCounter = 0;
    public int caseCounter = 0;
    public boolean interrupted = false;

    public CCJSqlParser withConfiguration(FeatureConfiguration configuration) {
        token_source.configuration = configuration;
        return this;
    }

    public FeatureConfiguration getConfiguration() {
        return token_source.configuration;
    }

    public CCJSqlParser me () {
        return this;
    }

    private void linkAST(ASTNodeAccess access, SimpleNode node) {
        access.setASTNode(node);
        node.jjtSetValue(access);
    }

    public Node getASTRoot() {
        return jjtree.rootNode();
    }

    private static class ObjectNames {

        private final List<String> names;
        private final List<String> delimiters;

        public ObjectNames(List<String> names, List<String> delimiters) {
            this.names = names;
            this.delimiters = delimiters;
        }

        public List<String> getNames() {
            return names;
        }

        public List<String> getDelimiters() {
            return delimiters;
        }
    }

  final public Statement Statement() throws ParseException {/*@bgen(jjtree) Statement */
    SimpleNode jjtn000 = new SimpleNode(JJTSTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));IfElseStatement ifElseStatement = null;
    Statement stm = null;
    Statement stm2 = null;
    Expression condition;
    try {
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_IF:{
          jj_consume_token(K_IF);
          condition = Condition();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_ANALYZE:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESC:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_PURGE:
          case K_REFRESH:
          case K_RENAME:
          case K_REPLACE:
          case K_RESET:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_SHOW:
          case K_TABLE:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUE:
          case K_VALUES:
          case K_WITH:
          case 425:{
            stm = SingleStatement();
            break;
            }
          case K_BEGIN:{
            stm = Block();
            break;
            }
          default:
            jj_la1[0] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
ifElseStatement = new IfElseStatement(condition, stm);
          if (jj_2_1(2)) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case ST_SEMICOLON:{
              jj_consume_token(ST_SEMICOLON);
ifElseStatement.setUsingSemicolonForIfStatement(true);
              break;
              }
            default:
              jj_la1[1] = jj_gen;
              ;
            }
            jj_consume_token(K_ELSE);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ALTER:
            case K_ANALYZE:
            case K_CALL:
            case K_COMMIT:
            case K_COMMENT:
            case K_CREATE:
            case K_DECLARE:
            case K_DELETE:
            case K_DESC:
            case K_DESCRIBE:
            case K_DROP:
            case K_EXEC:
            case K_EXECUTE:
            case K_EXPLAIN:
            case K_GRANT:
            case K_INSERT:
            case K_MERGE:
            case K_PURGE:
            case K_REFRESH:
            case K_RENAME:
            case K_REPLACE:
            case K_RESET:
            case K_ROLLBACK:
            case K_SAVEPOINT:
            case K_SELECT:
            case K_SET:
            case K_SHOW:
            case K_TABLE:
            case K_TRUNCATE:
            case K_UPDATE:
            case K_UPSERT:
            case K_USE:
            case K_VALUE:
            case K_VALUES:
            case K_WITH:
            case 425:{
              stm2 = SingleStatement();
              break;
              }
            case K_BEGIN:{
              stm2 = Block();
              break;
              }
            default:
              jj_la1[2] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
ifElseStatement.setElseStatement(stm2);
          } else {
            ;
          }
          if (jj_2_2(2)) {
            jj_consume_token(ST_SEMICOLON);
if (stm2!=null)
                           ifElseStatement.setUsingSemicolonForElseStatement(true);
                        else if (ifElseStatement!=null)
                           ifElseStatement.setUsingSemicolonForIfStatement(true);
          } else {
            ;
          }
          break;
          }
        case K_ALTER:
        case K_ANALYZE:
        case K_BEGIN:
        case K_CALL:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_DECLARE:
        case K_DELETE:
        case K_DESC:
        case K_DESCRIBE:
        case K_DROP:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_GRANT:
        case K_INSERT:
        case K_MERGE:
        case K_PURGE:
        case K_REFRESH:
        case K_RENAME:
        case K_REPLACE:
        case K_RESET:
        case K_ROLLBACK:
        case K_SAVEPOINT:
        case K_SELECT:
        case K_SET:
        case K_SHOW:
        case K_TABLE:
        case K_TRUNCATE:
        case K_UPDATE:
        case K_UPSERT:
        case K_USE:
        case K_VALUE:
        case K_VALUES:
        case K_WITH:
        case 425:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_ANALYZE:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESC:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_PURGE:
          case K_REFRESH:
          case K_RENAME:
          case K_REPLACE:
          case K_RESET:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_SHOW:
          case K_TABLE:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUE:
          case K_VALUES:
          case K_WITH:
          case 425:{
            stm = SingleStatement();
            break;
            }
          case K_BEGIN:{
            stm = Block();
            break;
            }
          default:
            jj_la1[3] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ST_SEMICOLON:{
            jj_consume_token(ST_SEMICOLON);
            break;
            }
          case 0:{
            jj_consume_token(0);
            break;
            }
          default:
            jj_la1[4] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[5] = jj_gen;
          if (stm==null && getAsBoolean(Feature.allowUnsupportedStatements)) {
            stm = UnsupportedStatement();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } catch (ParseException ex) {
if ( getAsBoolean(Feature.allowUnsupportedStatements) ) {
                stm = new UnsupportedStatement( stm.toString(), error_skipto(ST_SEMICOLON) );
            } else if ( errorRecovery ) {
                parseErrors.add(ex);
                error_skipto(ST_SEMICOLON);
                stm = null;
            } else {
                {if (true) throw ex;}
            }
      }
jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtn000.jjtSetLastToken(getToken(0));
return ifElseStatement!=null ? ifElseStatement : stm;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Statement SingleStatement() throws ParseException {Statement stm = null;
    List<WithItem> with = null;
    if (jj_2_4(3)) {
      if (jj_2_3(2)) {
        with = WithList();
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case K_VALUE:
      case K_VALUES:
      case K_WITH:
      case 425:{
        stm = SelectWithWithItems(with);
        break;
        }
      case K_INSERT:{
        stm = Insert(with);
        break;
        }
      case K_UPDATE:{
        stm = Update(with);
        break;
        }
      case K_DELETE:{
        stm = Delete(with);
        break;
        }
      case K_MERGE:{
        stm = Merge(with);
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case K_VALUE:
      case K_VALUES:
      case K_WITH:
      case 425:{
        stm = Select();
        break;
        }
      case K_TABLE:{
        stm = TableStatement();
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        if (jj_2_5(3)) {
          stm = Upsert();
        } else if (jj_2_6(2)) {
          stm = Alter();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_RENAME:{
            // @todo: merge this into the ALTER TABLE statement
                        stm = RenameTableStatement();
            break;
            }
          case K_CREATE:{
            stm = Create();
            break;
            }
          case K_DROP:{
            stm = Drop();
            break;
            }
          case K_ANALYZE:{
            stm = Analyze();
            break;
            }
          case K_TRUNCATE:{
            stm = Truncate();
            break;
            }
          case K_CALL:
          case K_EXEC:
          case K_EXECUTE:{
            stm = Execute();
            break;
            }
          case K_SET:{
            stm = Set();
            break;
            }
          case K_RESET:{
            stm = Reset();
            break;
            }
          case K_SHOW:{
            stm = Show();
            break;
            }
          case K_REFRESH:{
            stm = RefreshMaterializedView();
            break;
            }
          case K_USE:{
            stm = Use();
            break;
            }
          case K_SAVEPOINT:{
            stm = SavepointStatement();
            break;
            }
          case K_ROLLBACK:{
            stm = RollbackStatement();
            break;
            }
          case K_COMMIT:{
            stm = Commit();
            break;
            }
          case K_COMMENT:{
            stm = Comment();
            break;
            }
          case K_DESC:
          case K_DESCRIBE:{
            stm = Describe();
            break;
            }
          case K_EXPLAIN:{
            stm = Explain();
            break;
            }
          case K_DECLARE:{
            stm = Declare();
            break;
            }
          case K_GRANT:{
            stm = Grant();
            break;
            }
          case K_PURGE:{
            stm = PurgeStatement();
            break;
            }
          default:
            jj_la1[8] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
return stm;
}

  final public Block Block() throws ParseException {/*@bgen(jjtree) Block */
    SimpleNode jjtn000 = new SimpleNode(JJTBLOCK);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Statements stmts = new Statements();
    List<Statement> list = new ArrayList<Statement>();
    Statement stm;
    Block block = new Block();
    try {
      jj_consume_token(K_BEGIN);
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ST_SEMICOLON:{
          ;
          break;
          }
        default:
          jj_la1[9] = jj_gen;
          break label_1;
        }
        jj_consume_token(ST_SEMICOLON);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ALTER:
      case K_ANALYZE:
      case K_CALL:
      case K_COMMIT:
      case K_COMMENT:
      case K_CREATE:
      case K_DECLARE:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DROP:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_GRANT:
      case K_INSERT:
      case K_MERGE:
      case K_PURGE:
      case K_REFRESH:
      case K_RENAME:
      case K_REPLACE:
      case K_RESET:
      case K_ROLLBACK:
      case K_SAVEPOINT:
      case K_SELECT:
      case K_SET:
      case K_SHOW:
      case K_TABLE:
      case K_TRUNCATE:
      case K_UPDATE:
      case K_UPSERT:
      case K_USE:
      case K_VALUE:
      case K_VALUES:
      case K_WITH:
      case 425:{
        stm = SingleStatement();
        break;
        }
      case K_BEGIN:{
        stm = Block();
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ST_SEMICOLON);
list.add(stm);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALTER:
        case K_ANALYZE:
        case K_BEGIN:
        case K_CALL:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_DECLARE:
        case K_DELETE:
        case K_DESC:
        case K_DESCRIBE:
        case K_DROP:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_GRANT:
        case K_INSERT:
        case K_MERGE:
        case K_PURGE:
        case K_REFRESH:
        case K_RENAME:
        case K_REPLACE:
        case K_RESET:
        case K_ROLLBACK:
        case K_SAVEPOINT:
        case K_SELECT:
        case K_SET:
        case K_SHOW:
        case K_TABLE:
        case K_TRUNCATE:
        case K_UPDATE:
        case K_UPSERT:
        case K_USE:
        case K_VALUE:
        case K_VALUES:
        case K_WITH:
        case 425:{
          ;
          break;
          }
        default:
          jj_la1[11] = jj_gen;
          break label_2;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALTER:
        case K_ANALYZE:
        case K_CALL:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_DECLARE:
        case K_DELETE:
        case K_DESC:
        case K_DESCRIBE:
        case K_DROP:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_GRANT:
        case K_INSERT:
        case K_MERGE:
        case K_PURGE:
        case K_REFRESH:
        case K_RENAME:
        case K_REPLACE:
        case K_RESET:
        case K_ROLLBACK:
        case K_SAVEPOINT:
        case K_SELECT:
        case K_SET:
        case K_SHOW:
        case K_TABLE:
        case K_TRUNCATE:
        case K_UPDATE:
        case K_UPSERT:
        case K_USE:
        case K_VALUE:
        case K_VALUES:
        case K_WITH:
        case 425:{
          stm = SingleStatement();
          break;
          }
        case K_BEGIN:{
          stm = Block();
          break;
          }
        default:
          jj_la1[12] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(ST_SEMICOLON);
list.add(stm);
      }
stmts.setStatements(list);
        block.setStatements(stmts);
      jj_consume_token(K_END);
      if (jj_2_7(2)) {
        jj_consume_token(ST_SEMICOLON);
block.setSemicolonAfterEnd(true);
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return block;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Statements Statements() throws ParseException {/*@bgen(jjtree) Statements */
    SimpleNode jjtn000 = new SimpleNode(JJTSTATEMENTS);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Statements stmts = new Statements();
    IfElseStatement ifElseStatement = null;
    Statement stm = null;
    Statement stm2 = null;
    Expression condition;
    try {
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALTER:
        case K_ANALYZE:
        case K_BEGIN:
        case K_CALL:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_DECLARE:
        case K_DELETE:
        case K_DESC:
        case K_DESCRIBE:
        case K_DROP:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_GRANT:
        case K_IF:
        case K_INSERT:
        case K_MERGE:
        case K_PURGE:
        case K_REFRESH:
        case K_RENAME:
        case K_REPLACE:
        case K_RESET:
        case K_ROLLBACK:
        case K_SAVEPOINT:
        case K_SELECT:
        case K_SET:
        case K_SHOW:
        case K_TABLE:
        case K_TRUNCATE:
        case K_UPDATE:
        case K_UPSERT:
        case K_USE:
        case K_VALUE:
        case K_VALUES:
        case K_WITH:
        case ST_SEMICOLON:
        case 425:{
          ;
          break;
          }
        default:
          jj_la1[13] = jj_gen;
          break label_3;
        }
        label_4:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ST_SEMICOLON:{
            ;
            break;
            }
          default:
            jj_la1[14] = jj_gen;
            break label_4;
          }
          jj_consume_token(ST_SEMICOLON);
        }
        try {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_IF:{
            jj_consume_token(K_IF);
            condition = Condition();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ALTER:
            case K_ANALYZE:
            case K_CALL:
            case K_COMMIT:
            case K_COMMENT:
            case K_CREATE:
            case K_DECLARE:
            case K_DELETE:
            case K_DESC:
            case K_DESCRIBE:
            case K_DROP:
            case K_EXEC:
            case K_EXECUTE:
            case K_EXPLAIN:
            case K_GRANT:
            case K_INSERT:
            case K_MERGE:
            case K_PURGE:
            case K_REFRESH:
            case K_RENAME:
            case K_REPLACE:
            case K_RESET:
            case K_ROLLBACK:
            case K_SAVEPOINT:
            case K_SELECT:
            case K_SET:
            case K_SHOW:
            case K_TABLE:
            case K_TRUNCATE:
            case K_UPDATE:
            case K_UPSERT:
            case K_USE:
            case K_VALUE:
            case K_VALUES:
            case K_WITH:
            case 425:{
              stm = SingleStatement();
              break;
              }
            case K_BEGIN:{
              stm = Block();
              break;
              }
            default:
              jj_la1[15] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
ifElseStatement = new IfElseStatement(condition, stm);
            if (jj_2_8(2)) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case ST_SEMICOLON:{
                jj_consume_token(ST_SEMICOLON);
ifElseStatement.setUsingSemicolonForIfStatement(true);
                break;
                }
              default:
                jj_la1[16] = jj_gen;
                ;
              }
              jj_consume_token(K_ELSE);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_ALTER:
              case K_ANALYZE:
              case K_CALL:
              case K_COMMIT:
              case K_COMMENT:
              case K_CREATE:
              case K_DECLARE:
              case K_DELETE:
              case K_DESC:
              case K_DESCRIBE:
              case K_DROP:
              case K_EXEC:
              case K_EXECUTE:
              case K_EXPLAIN:
              case K_GRANT:
              case K_INSERT:
              case K_MERGE:
              case K_PURGE:
              case K_REFRESH:
              case K_RENAME:
              case K_REPLACE:
              case K_RESET:
              case K_ROLLBACK:
              case K_SAVEPOINT:
              case K_SELECT:
              case K_SET:
              case K_SHOW:
              case K_TABLE:
              case K_TRUNCATE:
              case K_UPDATE:
              case K_UPSERT:
              case K_USE:
              case K_VALUE:
              case K_VALUES:
              case K_WITH:
              case 425:{
                stm2 = SingleStatement();
                break;
                }
              case K_BEGIN:{
                stm2 = Block();
                break;
                }
              default:
                jj_la1[17] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
ifElseStatement.setElseStatement(stm2);
            } else {
              ;
            }
stmts.add( ifElseStatement );
            if (jj_2_9(2)) {
              jj_consume_token(ST_SEMICOLON);
if (stm2!=null)
                               ifElseStatement.setUsingSemicolonForElseStatement(true);
                            else if (ifElseStatement!=null)
                               ifElseStatement.setUsingSemicolonForIfStatement(true);
            } else {
              ;
            }
            break;
            }
          case K_ALTER:
          case K_ANALYZE:
          case K_BEGIN:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESC:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_PURGE:
          case K_REFRESH:
          case K_RENAME:
          case K_REPLACE:
          case K_RESET:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_SHOW:
          case K_TABLE:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUE:
          case K_VALUES:
          case K_WITH:
          case 425:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ALTER:
            case K_ANALYZE:
            case K_CALL:
            case K_COMMIT:
            case K_COMMENT:
            case K_CREATE:
            case K_DECLARE:
            case K_DELETE:
            case K_DESC:
            case K_DESCRIBE:
            case K_DROP:
            case K_EXEC:
            case K_EXECUTE:
            case K_EXPLAIN:
            case K_GRANT:
            case K_INSERT:
            case K_MERGE:
            case K_PURGE:
            case K_REFRESH:
            case K_RENAME:
            case K_REPLACE:
            case K_RESET:
            case K_ROLLBACK:
            case K_SAVEPOINT:
            case K_SELECT:
            case K_SET:
            case K_SHOW:
            case K_TABLE:
            case K_TRUNCATE:
            case K_UPDATE:
            case K_UPSERT:
            case K_USE:
            case K_VALUE:
            case K_VALUES:
            case K_WITH:
            case 425:{
              stm = SingleStatement();
              break;
              }
            case K_BEGIN:{
              stm = Block();
              break;
              }
            default:
              jj_la1[18] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case ST_SEMICOLON:{
              jj_consume_token(ST_SEMICOLON);
              break;
              }
            case 0:{
              jj_consume_token(0);
              break;
              }
            default:
              jj_la1[19] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
stmts.add(stm); stm=null;
            break;
            }
          default:
            jj_la1[20] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        } catch (ParseException ex) {
if ( getAsBoolean(Feature.allowUnsupportedStatements) ) {
                    UnsupportedStatement unsupportedStatement = new UnsupportedStatement( stm!=null ? stm.toString() : "", error_skipto(ST_SEMICOLON) );
                    if (!unsupportedStatement.isEmpty()) {
                        stmts.add( unsupportedStatement );
                    }
                } else if ( errorRecovery ) {
                    parseErrors.add(ex);
                    error_skipto(ST_SEMICOLON);
                    stmts.add( null );
                } else {
                    {if (true) throw ex;}
                }
        }
        label_5:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_ANALYZE:
          case K_BEGIN:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESC:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_IF:
          case K_INSERT:
          case K_MERGE:
          case K_PURGE:
          case K_REFRESH:
          case K_RENAME:
          case K_REPLACE:
          case K_RESET:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_SHOW:
          case K_TABLE:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUE:
          case K_VALUES:
          case K_WITH:
          case ST_SEMICOLON:
          case 425:{
            ;
            break;
            }
          default:
            jj_la1[21] = jj_gen;
            break label_5;
          }
          label_6:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case ST_SEMICOLON:{
              ;
              break;
              }
            default:
              jj_la1[22] = jj_gen;
              break label_6;
            }
            jj_consume_token(ST_SEMICOLON);
          }
          try {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_IF:{
              jj_consume_token(K_IF);
              condition = Condition();
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_ALTER:
              case K_ANALYZE:
              case K_CALL:
              case K_COMMIT:
              case K_COMMENT:
              case K_CREATE:
              case K_DECLARE:
              case K_DELETE:
              case K_DESC:
              case K_DESCRIBE:
              case K_DROP:
              case K_EXEC:
              case K_EXECUTE:
              case K_EXPLAIN:
              case K_GRANT:
              case K_INSERT:
              case K_MERGE:
              case K_PURGE:
              case K_REFRESH:
              case K_RENAME:
              case K_REPLACE:
              case K_RESET:
              case K_ROLLBACK:
              case K_SAVEPOINT:
              case K_SELECT:
              case K_SET:
              case K_SHOW:
              case K_TABLE:
              case K_TRUNCATE:
              case K_UPDATE:
              case K_UPSERT:
              case K_USE:
              case K_VALUE:
              case K_VALUES:
              case K_WITH:
              case 425:{
                stm = SingleStatement();
                break;
                }
              case K_BEGIN:{
                stm = Block();
                break;
                }
              default:
                jj_la1[23] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
ifElseStatement = new IfElseStatement(condition, stm);
              if (jj_2_10(2)) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case ST_SEMICOLON:{
                  jj_consume_token(ST_SEMICOLON);
ifElseStatement.setUsingSemicolonForIfStatement(true);
                  break;
                  }
                default:
                  jj_la1[24] = jj_gen;
                  ;
                }
                jj_consume_token(K_ELSE);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_ALTER:
                case K_ANALYZE:
                case K_CALL:
                case K_COMMIT:
                case K_COMMENT:
                case K_CREATE:
                case K_DECLARE:
                case K_DELETE:
                case K_DESC:
                case K_DESCRIBE:
                case K_DROP:
                case K_EXEC:
                case K_EXECUTE:
                case K_EXPLAIN:
                case K_GRANT:
                case K_INSERT:
                case K_MERGE:
                case K_PURGE:
                case K_REFRESH:
                case K_RENAME:
                case K_REPLACE:
                case K_RESET:
                case K_ROLLBACK:
                case K_SAVEPOINT:
                case K_SELECT:
                case K_SET:
                case K_SHOW:
                case K_TABLE:
                case K_TRUNCATE:
                case K_UPDATE:
                case K_UPSERT:
                case K_USE:
                case K_VALUE:
                case K_VALUES:
                case K_WITH:
                case 425:{
                  stm2 = SingleStatement();
                  break;
                  }
                case K_BEGIN:{
                  stm2 = Block();
                  break;
                  }
                default:
                  jj_la1[25] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
ifElseStatement.setElseStatement(stm2);
              } else {
                ;
              }
stmts.add( ifElseStatement );
              break;
              }
            case K_ALTER:
            case K_ANALYZE:
            case K_BEGIN:
            case K_CALL:
            case K_COMMIT:
            case K_COMMENT:
            case K_CREATE:
            case K_DECLARE:
            case K_DELETE:
            case K_DESC:
            case K_DESCRIBE:
            case K_DROP:
            case K_EXEC:
            case K_EXECUTE:
            case K_EXPLAIN:
            case K_GRANT:
            case K_INSERT:
            case K_MERGE:
            case K_PURGE:
            case K_REFRESH:
            case K_RENAME:
            case K_REPLACE:
            case K_RESET:
            case K_ROLLBACK:
            case K_SAVEPOINT:
            case K_SELECT:
            case K_SET:
            case K_SHOW:
            case K_TABLE:
            case K_TRUNCATE:
            case K_UPDATE:
            case K_UPSERT:
            case K_USE:
            case K_VALUE:
            case K_VALUES:
            case K_WITH:
            case 425:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_ALTER:
              case K_ANALYZE:
              case K_CALL:
              case K_COMMIT:
              case K_COMMENT:
              case K_CREATE:
              case K_DECLARE:
              case K_DELETE:
              case K_DESC:
              case K_DESCRIBE:
              case K_DROP:
              case K_EXEC:
              case K_EXECUTE:
              case K_EXPLAIN:
              case K_GRANT:
              case K_INSERT:
              case K_MERGE:
              case K_PURGE:
              case K_REFRESH:
              case K_RENAME:
              case K_REPLACE:
              case K_RESET:
              case K_ROLLBACK:
              case K_SAVEPOINT:
              case K_SELECT:
              case K_SET:
              case K_SHOW:
              case K_TABLE:
              case K_TRUNCATE:
              case K_UPDATE:
              case K_UPSERT:
              case K_USE:
              case K_VALUE:
              case K_VALUES:
              case K_WITH:
              case 425:{
                stm = SingleStatement();
                break;
                }
              case K_BEGIN:{
                stm = Block();
                break;
                }
              default:
                jj_la1[26] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
stmts.add(stm); stm=null;
              break;
              }
            default:
              jj_la1[27] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          } catch (ParseException ex) {
if ( getAsBoolean(Feature.allowUnsupportedStatements) ) {
                   UnsupportedStatement unsupportedStatement = new UnsupportedStatement( stm!=null ? stm.toString() : "" , error_skipto(ST_SEMICOLON) );
                   if (!unsupportedStatement.isEmpty()) {
                       stmts.add( unsupportedStatement );
                   }
               } else if ( errorRecovery ) {
                   parseErrors.add(ex);
                   error_skipto(ST_SEMICOLON);
                   stmts.add( null );
               } else {
                   {if (true) throw ex;}
               }
          }
          label_7:
          while (true) {
            if (jj_2_11(2)) {
              ;
            } else {
              break label_7;
            }
            jj_consume_token(ST_SEMICOLON);
if (stm2!=null)
                             ifElseStatement.setUsingSemicolonForElseStatement(true);
                          else if (ifElseStatement!=null)
                             ifElseStatement.setUsingSemicolonForIfStatement(true);
          }
        }
        if (getAsBoolean(Feature.allowUnsupportedStatements)) {
          stm = UnsupportedStatement();
if (!( (UnsupportedStatement) stm).isEmpty()) {
                    stmts.add( stm );
                }
        } else {
          ;
        }
      }
      jj_consume_token(0);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return stmts;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  List<String> error_skipto(int kind) throws ParseException {ArrayList<String> tokenImages = new ArrayList<String>();
  ParseException e = generateParseException();
  Token t;
  do {
    t = getNextToken();
    if (t.kind != kind && t.kind != EOF) {
        tokenImages.add(t.image);
    }
  } while (t.kind != kind && t.kind != EOF);
  return tokenImages;
  }

  final public DeclareStatement Declare() throws ParseException {UserVariable userVariable;
    ColDataType colDataType;
    Expression defaultExpr = null;
    DeclareStatement stmt = new DeclareStatement();
    String typeName;
    String columnName;
    ColumnDefinition colDef;
    jj_consume_token(K_DECLARE);
    userVariable = UserVariable();
    if (jj_2_12(2)) {
      jj_consume_token(K_TABLE);
      jj_consume_token(425);
      colDef = ColumnDefinition();
stmt.withUserVariable(userVariable)
            .withDeclareType(DeclareType.TABLE)
            .addColumnDefinition(colDef);
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[28] = jj_gen;
          break label_8;
        }
        jj_consume_token(K_COMMA);
        colDef = ColumnDefinition();
stmt.addColumnDefinition(colDef);
      }
      jj_consume_token(426);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AS:{
        jj_consume_token(K_AS);
        typeName = RelObjectName();
stmt.withUserVariable(userVariable)
                      .withDeclareType(DeclareType.AS)
                      .withTypeName(typeName);
        break;
        }
      case K_ARRAY_LITERAL:
      case K_BINARY:
      case K_BIT:
      case K_BYTES:
      case K_CHARACTER:
      case K_CHAR:
      case K_DATA:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_INTERVAL:
      case K_JSON:
      case K_PUBLIC:
      case K_SET:
      case K_STRING:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_XML:
      case DT_ZONE:
      case DATA_TYPE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        colDataType = ColDataType();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 427:{
          jj_consume_token(427);
          defaultExpr = Expression();
          break;
          }
        default:
          jj_la1[29] = jj_gen;
          ;
        }
stmt.withDeclareType(DeclareType.TYPE)
                  .addType(userVariable, colDataType, defaultExpr);
        label_9:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[30] = jj_gen;
            break label_9;
          }
          jj_consume_token(K_COMMA);
          userVariable = UserVariable();
          colDataType = ColDataType();
defaultExpr = null;
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 427:{
            jj_consume_token(427);
            defaultExpr = Expression();
            break;
            }
          default:
            jj_la1[31] = jj_gen;
            ;
          }
stmt.addType(userVariable, colDataType, defaultExpr);
        }
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return stmt;
}

  final public SetStatement Set() throws ParseException {String namePart;
    Object name;
    ExpressionList expList;
    boolean useEqual = false;
    SetStatement set;
    Expression exp = null;
    Token tk = null;
    String effectParameter = null;
    jj_consume_token(K_SET);
    if (jj_2_13(3)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LOCAL:{
        tk = jj_consume_token(K_LOCAL);
        break;
        }
      case K_SESSION:{
        tk = jj_consume_token(K_SESSION);
        break;
        }
      default:
        jj_la1[33] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
effectParameter = tk.image;
    } else {
      ;
    }
    if (jj_2_14(2)) {
      jj_consume_token(K_DATETIMELITERAL);
      jj_consume_token(K_ZONE);
name = "Time Zone"; useEqual=false;
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 445:
      case 476:{
        name = UserVariable();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 427:{
          jj_consume_token(427);
useEqual=true;
          break;
          }
        default:
          jj_la1[34] = jj_gen;
          ;
        }
        break;
        }
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALL:
      case K_ALTER:
      case K_ANALYZE:
      case K_ANY:
      case K_APPLY:
      case K_APPROXIMATE:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BASE64:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONNECT:
      case K_CONSTRAINTS:
      case K_CONVERT:
      case K_COSTS:
      case K_CREATE:
      case K_CURRENT:
      case K_CYCLE:
      case K_DATABASE:
      case K_DATA:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FROM:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GLOBAL:
      case K_GRANT:
      case K_GROUP:
      case K_GROUPING:
      case K_GUARD:
      case K_HASH:
      case K_HISTORY:
      case K_HOPPING:
      case K_IF:
      case K_IIF:
      case K_IGNORE:
      case K_IN:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_INTERVAL:
      case K_INVALIDATE:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_LOOP:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAX:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MIN:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NEXTVAL:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OVERLAPS:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_PURGE:
      case K_QUALIFY:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_RECURSIVE:
      case K_REFERENCES:
      case K_REFRESH:
      case K_REGEXP:
      case K_RESPECT:
      case K_RLIKE:
      case K_REGISTER:
      case K_REMOTE:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_RETURN:
      case K_RIGHT:
      case K_ROLLBACK:
      case K_ROLLUP:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SECURE:
      case K_SEED:
      case K_SELECT:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SHARE:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_SOME:
      case K_START:
      case K_STORED:
      case K_STRING:
      case K_STRUCT:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VERBOSE:
      case K_VIEW:
      case K_VOLATILE:
      case K_CONCURRENTLY:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case DATA_TYPE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 429:
      case 430:
      case 431:
      case 432:
      case 433:
      case 434:
      case 435:
      case 436:{
        name = IdentifierChain();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 427:{
          jj_consume_token(427);
useEqual=true;
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    exp = Expression();
expList = new ExpressionList();
        expList.add(exp);
        set = new SetStatement(name, expList)
            .withUseEqual(useEqual)
            .withEffectParameter(effectParameter);
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        break label_10;
      }
useEqual=false;
      jj_consume_token(K_COMMA);
      if (jj_2_16(3)) {
        if (jj_2_15(2)) {
          jj_consume_token(K_DATETIMELITERAL);
          jj_consume_token(K_ZONE);
name = "Time Zone"; useEqual=false;
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ACTIVE:
          case K_ADD:
          case K_ADVANCE:
          case K_ADVISE:
          case K_AGAINST:
          case K_ALGORITHM:
          case K_ALL:
          case K_ALTER:
          case K_ANALYZE:
          case K_ANY:
          case K_APPLY:
          case K_APPROXIMATE:
          case K_ARCHIVE:
          case K_ARRAY_LITERAL:
          case K_AT:
          case K_ASC:
          case K_AUTHORIZATION:
          case K_AUTO:
          case K_BASE64:
          case K_BEGIN:
          case K_BERNOULLI:
          case K_BINARY:
          case K_BIT:
          case K_BLOCK:
          case K_BROWSE:
          case K_BY:
          case K_BYTES:
          case K_CACHE:
          case K_BUFFERS:
          case K_BYTE:
          case K_CALL:
          case K_CASCADE:
          case K_CASE:
          case K_CASEWHEN:
          case K_CAST:
          case K_CHARACTER:
          case K_CHANGE:
          case K_CHANGES:
          case K_CHECKPOINT:
          case K_CHAR:
          case K_CLOSE:
          case K_COLLATE:
          case K_COLUMN:
          case K_COLUMNS:
          case K_COMMIT:
          case K_COMMENT:
          case K_CONFLICT:
          case K_CONNECT:
          case K_CONSTRAINTS:
          case K_CONVERT:
          case K_COSTS:
          case K_CREATE:
          case K_CYCLE:
          case K_DATABASE:
          case K_DATA:
          case K_DECLARE:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_DEFAULT:
          case K_DEFERRABLE:
          case K_DELAYED:
          case K_DELETE:
          case K_DESC:
          case K_DESCRIBE:
          case K_DISABLE:
          case K_DISCONNECT:
          case K_DIV:
          case K_DDL:
          case K_DML:
          case K_DO:
          case K_DOMAIN:
          case K_DROP:
          case K_DUMP:
          case K_DUPLICATE:
          case K_ELEMENTS:
          case K_EMIT:
          case K_ENABLE:
          case K_END:
          case K_ESCAPE:
          case K_EXCLUDE:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_EXPLICIT:
          case K_EXTENDED:
          case K_EXTRACT:
          case K_ISOLATION:
          case K_FILTER:
          case K_FIRST:
          case K_FALSE:
          case K_FLUSH:
          case K_FOLLOWING:
          case K_FORMAT:
          case K_FULLTEXT:
          case K_FUNCTION:
          case K_GLOBAL:
          case K_GRANT:
          case K_GROUP:
          case K_GROUPING:
          case K_GUARD:
          case K_HASH:
          case K_HISTORY:
          case K_HOPPING:
          case K_IF:
          case K_IIF:
          case K_IGNORE:
          case K_IN:
          case K_INCLUDE:
          case K_INCREMENT:
          case K_INDEX:
          case K_INSERT:
          case K_INTERLEAVE:
          case K_INTERPRET:
          case K_INTERVAL:
          case K_INVALIDATE:
          case K_ISNULL:
          case K_JSON:
          case K_KEEP:
          case K_KEY:
          case K_KEYS:
          case K_FN:
          case K_LAST:
          case K_LEADING:
          case K_LEFT:
          case K_LIMIT:
          case K_LOCAL:
          case K_LOCKED:
          case K_LINK:
          case K_LOG:
          case K_LOOP:
          case K_MATCH:
          case K_MATCHED:
          case K_MATERIALIZED:
          case K_MAX:
          case K_MAXVALUE:
          case K_MEMBER:
          case K_MERGE:
          case K_MIN:
          case K_MINVALUE:
          case K_MODIFY:
          case K_MOVEMENT:
          case K_NEXT:
          case K_NEXTVAL:
          case K_NO:
          case K_NOCACHE:
          case K_NOKEEP:
          case K_NOLOCK:
          case K_NOMAXVALUE:
          case K_NOMINVALUE:
          case K_NOORDER:
          case K_NOTHING:
          case K_NOTNULL:
          case K_NOVALIDATE:
          case K_NULLS:
          case K_NOWAIT:
          case K_OF:
          case K_OFF:
          case K_OFFSET:
          case K_ON:
          case K_OPEN:
          case K_ORDER:
          case K_OVER:
          case K_OVERLAPS:
          case K_OPTIMIZE:
          case K_PARALLEL:
          case K_PARENT:
          case K_PARTITION:
          case K_PATH:
          case K_PERCENT:
          case K_PLACING:
          case K_PRECEDING:
          case K_PRIMARY:
          case K_PRIOR:
          case K_PROCEDURE:
          case K_PUBLIC:
          case K_PURGE:
          case K_QUALIFY:
          case K_QUERY:
          case K_QUICK:
          case K_QUIESCE:
          case K_RANGE:
          case K_RAW:
          case K_READ:
          case K_RECYCLEBIN:
          case K_RECURSIVE:
          case K_REFERENCES:
          case K_REFRESH:
          case K_REGEXP:
          case K_RESPECT:
          case K_RLIKE:
          case K_REGISTER:
          case K_REMOTE:
          case K_RENAME:
          case K_REPEATABLE:
          case K_REPLACE:
          case K_RESET:
          case K_RESTART:
          case K_RESUMABLE:
          case K_RESUME:
          case K_RESTRICT:
          case K_RESTRICTED:
          case K_RETURN:
          case K_RIGHT:
          case K_ROLLBACK:
          case K_ROLLUP:
          case K_ROOT:
          case K_ROW:
          case K_ROWS:
          case K_SAVEPOINT:
          case K_SCHEMA:
          case K_SECURE:
          case K_SEED:
          case K_SEQUENCE:
          case K_SEPARATOR:
          case K_SESSION:
          case K_SET:
          case K_SETS:
          case K_SHOW:
          case K_SHUTDOWN:
          case K_SHARE:
          case K_SIBLINGS:
          case K_SIMILAR:
          case K_SIZE:
          case K_SKIP:
          case K_SOME:
          case K_START:
          case K_STORED:
          case K_STRING:
          case K_STRUCT:
          case K_SUSPEND:
          case K_SWITCH:
          case K_SYNONYM:
          case K_SYSTEM:
          case K_TABLE:
          case K_TABLES:
          case K_TABLESPACE:
          case K_TRIGGER:
          case K_THEN:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIME_KEY_EXPR:
          case K_TIMEOUT:
          case K_TO:
          case K_TOP:
          case K_TRUNCATE:
          case K_TRUE:
          case K_TUMBLING:
          case K_TYPE:
          case K_UNLOGGED:
          case K_UPDATE:
          case K_UPSERT:
          case K_UNQIESCE:
          case K_USER:
          case K_SIGNED:
          case K_STRING_FUNCTION_NAME:
          case K_UNSIGNED:
          case K_VALIDATE:
          case K_VALUE:
          case K_VALUES:
          case K_VERBOSE:
          case K_VIEW:
          case K_VOLATILE:
          case K_CONCURRENTLY:
          case K_WAIT:
          case K_WITHIN:
          case K_WITHOUT:
          case K_WORK:
          case K_XML:
          case K_XMLAGG:
          case K_XMLDATA:
          case K_XMLSCHEMA:
          case K_XMLTEXT:
          case K_XSINIL:
          case K_YAML:
          case K_YES:
          case K_ZONE:
          case DATA_TYPE:
          case S_IDENTIFIER:
          case S_QUOTED_IDENTIFIER:
          case 429:
          case 430:
          case 431:
          case 432:
          case 433:
          case 434:
          case 435:
          case 436:{
            name = RelObjectNameExt();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 427:{
              jj_consume_token(427);
useEqual=true;
              break;
              }
            default:
              jj_la1[38] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[39] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        exp = Expression();
expList = new ExpressionList();
                    expList.add(exp);
                    set.add(name, expList, useEqual);
      } else if (jj_2_17(1)) {
        exp = Expression();
expList.add(exp);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return set;
}

  final public ResetStatement Reset() throws ParseException {String name;
    ResetStatement reset;
    Token all;
    jj_consume_token(K_RESET);
    if (jj_2_18(2)) {
      jj_consume_token(K_DATETIMELITERAL);
      jj_consume_token(K_ZONE);
name = "Time Zone";
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALTER:
      case K_ANALYZE:
      case K_APPLY:
      case K_APPROXIMATE:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BASE64:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONNECT:
      case K_CONSTRAINTS:
      case K_CONVERT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATABASE:
      case K_DATA:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GRANT:
      case K_GROUP:
      case K_GUARD:
      case K_HASH:
      case K_HISTORY:
      case K_HOPPING:
      case K_IGNORE:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_INTERVAL:
      case K_INVALIDATE:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_LOOP:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAX:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MIN:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_ON:
      case K_OPEN:
      case K_OVER:
      case K_OVERLAPS:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PURGE:
      case K_QUALIFY:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_RECURSIVE:
      case K_REFERENCES:
      case K_REFRESH:
      case K_REGEXP:
      case K_RESPECT:
      case K_RLIKE:
      case K_REGISTER:
      case K_REMOTE:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_RETURN:
      case K_ROLLBACK:
      case K_ROLLUP:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SECURE:
      case K_SEED:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SHARE:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_START:
      case K_STORED:
      case K_STRING:
      case K_STRUCT:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VERBOSE:
      case K_VIEW:
      case K_VOLATILE:
      case K_CONCURRENTLY:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case DATA_TYPE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 429:
      case 430:
      case 431:
      case 432:
      case 433:
      case 434:
      case 435:
      case 436:{
        name = RelObjectName();
        break;
        }
      case K_ALL:{
        all = jj_consume_token(K_ALL);
name = all.image;
        break;
        }
      default:
        jj_la1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
reset = new ResetStatement(name);   return reset;
}

  final public RenameTableStatement RenameTableStatement() throws ParseException {RenameTableStatement renameTableStatement;
    Table oldName;
    Table newName;
    boolean usingTableKeyword=false;
    boolean usesIfExistsKeyword=false;
    String waitDirective = "";
    Token token;
    jj_consume_token(K_RENAME);
    if (jj_2_19(2)) {
      jj_consume_token(K_TABLE);
usingTableKeyword = true;
    } else {
      ;
    }
    if (jj_2_20(2)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_EXISTS);
usesIfExistsKeyword = true;
    } else {
      ;
    }
    oldName = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOWAIT:
    case K_WAIT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WAIT:{
        jj_consume_token(K_WAIT);
        token = jj_consume_token(S_LONG);
waitDirective = "WAIT " + token.image;
        break;
        }
      case K_NOWAIT:{
        jj_consume_token(K_NOWAIT);
waitDirective = "NOWAIT";
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      ;
    }
    jj_consume_token(K_TO);
    newName = Table();
renameTableStatement = new RenameTableStatement(oldName, newName, usingTableKeyword, usesIfExistsKeyword, waitDirective);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        break label_11;
      }
      jj_consume_token(K_COMMA);
      oldName = Table();
      jj_consume_token(K_TO);
      newName = Table();
renameTableStatement.addTableNames(oldName, newName);
    }
return renameTableStatement;
}

  final public PurgeStatement PurgeStatement() throws ParseException {PurgeStatement purgeStatement = null;
    Table table;
    Index index;
    Token tableSpaceToken;
    Token userToken = null;
    jj_consume_token(K_PURGE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TABLE:{
      jj_consume_token(K_TABLE);
      table = Table();
purgeStatement = new PurgeStatement(table);
      break;
      }
    case K_INDEX:{
      jj_consume_token(K_INDEX);
      index = Index();
purgeStatement = new PurgeStatement(index);
      break;
      }
    case K_RECYCLEBIN:{
      jj_consume_token(K_RECYCLEBIN);
purgeStatement = new PurgeStatement(PurgeObjectType.RECYCLEBIN);
      break;
      }
    case K_DBA_RECYCLEBIN:{
      jj_consume_token(K_DBA_RECYCLEBIN);
purgeStatement = new PurgeStatement(PurgeObjectType.DBA_RECYCLEBIN);
      break;
      }
    case K_TABLESPACE:{
      jj_consume_token(K_TABLESPACE);
      tableSpaceToken = jj_consume_token(S_IDENTIFIER);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_USER:{
        jj_consume_token(K_USER);
        userToken = jj_consume_token(S_IDENTIFIER);
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        ;
      }
purgeStatement = new PurgeStatement(
                PurgeObjectType.TABLESPACE
                , tableSpaceToken.image
                , userToken!=null ? userToken.image : null);
      break;
      }
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return purgeStatement;
}

  final public DescribeStatement Describe() throws ParseException {Table table;
    DescribeStatement stmt = new DescribeStatement();
    Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DESCRIBE:{
      tk = jj_consume_token(K_DESCRIBE);
      break;
      }
    case K_DESC:{
      tk = jj_consume_token(K_DESC);
      break;
      }
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    table = Table();
stmt.setDescribeType(tk.image).setTable(table);
return stmt;
}

  final public ExplainStatement Explain() throws ParseException {Select select;
    Table table = null;
    List<ExplainStatement.Option> options = null;
    ExplainStatement es = new ExplainStatement();
    jj_consume_token(K_EXPLAIN);
    if (jj_2_21(3)) {
      options = ExplainStatementOptions();
      select = Select();
es.setStatement(select);
               if (options != null && !options.isEmpty()) {
                 for(ExplainStatement.Option o : options) {
                   es.addOption(o);
                 }
               }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALL:
      case K_ALTER:
      case K_ANALYZE:
      case K_ANY:
      case K_APPLY:
      case K_APPROXIMATE:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BASE64:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONNECT:
      case K_CONSTRAINTS:
      case K_CONVERT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATABASE:
      case K_DATA:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GLOBAL:
      case K_GRANT:
      case K_GROUP:
      case K_GROUPING:
      case K_GUARD:
      case K_HASH:
      case K_HISTORY:
      case K_HOPPING:
      case K_IF:
      case K_IIF:
      case K_IGNORE:
      case K_IN:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_INTERVAL:
      case K_INVALIDATE:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_LOOP:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAX:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MIN:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NEXTVAL:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OVERLAPS:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_PURGE:
      case K_QUALIFY:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_RECURSIVE:
      case K_REFERENCES:
      case K_REFRESH:
      case K_REGEXP:
      case K_RESPECT:
      case K_RLIKE:
      case K_REGISTER:
      case K_REMOTE:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_RETURN:
      case K_RIGHT:
      case K_ROLLBACK:
      case K_ROLLUP:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SECURE:
      case K_SEED:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SHARE:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_SOME:
      case K_START:
      case K_STORED:
      case K_STRING:
      case K_STRUCT:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VERBOSE:
      case K_VIEW:
      case K_VOLATILE:
      case K_CONCURRENTLY:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case DATA_TYPE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 429:
      case 430:
      case 431:
      case 432:
      case 433:
      case 434:
      case 435:
      case 436:{
        table = Table();
es.setTable(table);
        break;
        }
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return es;
}

/**
 * Postgres supports TRUE,ON,1,FALSE,OFF,0 as values
 */
  final public String ExplainOptionBoolean() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FALSE:
    case K_OFF:
    case K_ON:
    case K_TRUE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TRUE:{
        tk = jj_consume_token(K_TRUE);
        break;
        }
      case K_FALSE:{
        tk = jj_consume_token(K_FALSE);
        break;
        }
      case K_ON:{
        tk = jj_consume_token(K_ON);
        break;
        }
      case K_OFF:{
        tk = jj_consume_token(K_OFF);
        break;
        }
      default:
        jj_la1[48] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[49] = jj_gen;
      ;
    }
return tk != null ? tk.image : null;
}

/**
 * The output format, which can be TEXT, XML, JSON, or YAML
 */
  final public String ExplainFormatOption() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_JSON:
    case K_XML:
    case K_YAML:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_XML:{
        tk = jj_consume_token(K_XML);
        break;
        }
      case K_JSON:{
        tk = jj_consume_token(K_JSON);
        break;
        }
      case K_YAML:{
        tk = jj_consume_token(K_YAML);
        break;
        }
      default:
        jj_la1[50] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[51] = jj_gen;
      ;
    }
return tk != null ? tk.image : null;
}

/**
 * Options for explain, see https://www.postgresql.org/docs/9.1/sql-explain.html
 */
  final public List<ExplainStatement.Option> ExplainStatementOptions() throws ParseException {List<ExplainStatement.Option> options = new ArrayList<ExplainStatement.Option>();
  ExplainStatement.Option option = null;
  Token token = null;
  String value = null;
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ANALYZE:
      case K_BUFFERS:
      case K_COSTS:
      case K_FORMAT:
      case K_VERBOSE:{
        ;
        break;
        }
      default:
        jj_la1[52] = jj_gen;
        break label_12;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ANALYZE:{
        jj_consume_token(K_ANALYZE);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.ANALYZE);
       option.setValue(value);
       options.add(option);
        break;
        }
      case K_BUFFERS:{
        jj_consume_token(K_BUFFERS);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.BUFFERS);
        option.setValue(value);
        options.add(option);
        break;
        }
      case K_COSTS:{
        jj_consume_token(K_COSTS);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.COSTS);
        option.setValue(value);
        options.add(option);
        break;
        }
      case K_VERBOSE:{
        jj_consume_token(K_VERBOSE);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.VERBOSE);
        option.setValue(value);
        options.add(option);
        break;
        }
      case K_FORMAT:{
        jj_consume_token(K_FORMAT);
        value = ExplainFormatOption();
option = new ExplainStatement.Option(ExplainStatement.OptionType.FORMAT);
        option.setValue(value);
        options.add(option);
        break;
        }
      default:
        jj_la1[53] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return options;
}

  final public UseStatement Use() throws ParseException {String name;
    boolean hasSchemaKeyword = false;
    jj_consume_token(K_USE);
    if (jj_2_22(2)) {
      jj_consume_token(K_SCHEMA);
hasSchemaKeyword = true;
    } else {
      ;
    }
    name = RelObjectNameExt();
return new UseStatement(name, hasSchemaKeyword);
}

  final public Statement Show() throws ParseException {Statement statement;
    List<String> captureRest;
    jj_consume_token(K_SHOW);
    if (jj_2_23(2)) {
      statement = ShowColumns();
    } else if (jj_2_24(2)) {
      statement = ShowIndex();
    } else if (jj_2_25(2)) {
      statement = ShowTables();
    } else {
      // any of the RDBMS specific SHOW syntax
              captureRest = captureRest();
if (captureRest.size()==1) {
                statement = new ShowStatement(captureRest.get(0));
            } else {
                statement = new UnsupportedStatement("SHOW", captureRest);
            }
    }
return statement;
}

  final public ShowColumnsStatement ShowColumns() throws ParseException {String tableName;
    jj_consume_token(K_COLUMNS);
    jj_consume_token(K_FROM);
    tableName = RelObjectNameExt();
return new ShowColumnsStatement(tableName);
}

  final public ShowIndexStatement ShowIndex() throws ParseException {String tableName;
    jj_consume_token(K_INDEX);
    jj_consume_token(K_FROM);
    tableName = RelObjectNameExt();
return new ShowIndexStatement(tableName);
}

  final public Statement RefreshMaterializedView() throws ParseException {Table view = null;
    boolean concurrently = false;
    RefreshMode refreshMode = null;
    List<String> captureRest;
    jj_consume_token(K_REFRESH);
    jj_consume_token(K_MATERIALIZED);
    jj_consume_token(K_VIEW);
    if (jj_2_26(2)) {
      jj_consume_token(K_CONCURRENTLY);
concurrently = true;
    } else {
      ;
    }
    view = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WITH:{
      jj_consume_token(K_WITH);
refreshMode = RefreshMode.WITH_DATA;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NO:{
        jj_consume_token(K_NO);
refreshMode = RefreshMode.WITH_NO_DATA;
        break;
        }
      default:
        jj_la1[54] = jj_gen;
        ;
      }
      jj_consume_token(K_DATA);
      break;
      }
    default:
      jj_la1[55] = jj_gen;
      ;
    }
    captureRest = captureRest();
if (concurrently && refreshMode == RefreshMode.WITH_NO_DATA) {
            return new UnsupportedStatement("REFRESH", captureRest);
        } else {
           return new RefreshMaterializedViewStatement(view, concurrently, refreshMode);
        }
}

// https://dev.mysql.com/doc/refman/8.0/en/show-tables.html
  final public ShowTablesStatement ShowTables() throws ParseException {ShowTablesStatement showTablesStatement;
    EnumSet<ShowTablesStatement.Modifiers> modifiers =  EnumSet.noneOf(ShowTablesStatement.Modifiers.class);
    ShowTablesStatement.SelectionMode selectionMode = null;
    String dbName = null;
    Expression likeExpression = null;
    Expression whereCondition = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXTENDED:{
      jj_consume_token(K_EXTENDED);
modifiers.add(ShowTablesStatement.Modifiers.EXTENDED);
      break;
      }
    default:
      jj_la1[56] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FULL:{
      jj_consume_token(K_FULL);
modifiers.add(ShowTablesStatement.Modifiers.FULL);
      break;
      }
    default:
      jj_la1[57] = jj_gen;
      ;
    }
    jj_consume_token(K_TABLES);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:
    case K_IN:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FROM:{
        jj_consume_token(K_FROM);
selectionMode = ShowTablesStatement.SelectionMode.FROM;
        break;
        }
      case K_IN:{
        jj_consume_token(K_IN);
selectionMode = ShowTablesStatement.SelectionMode.IN;
        break;
        }
      default:
        jj_la1[58] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      dbName = RelObjectNameExt();
      break;
      }
    default:
      jj_la1[59] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIKE:
    case K_WHERE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LIKE:{
        jj_consume_token(K_LIKE);
        likeExpression = SimpleExpression();
        break;
        }
      case K_WHERE:{
        jj_consume_token(K_WHERE);
        whereCondition = Expression();
        break;
        }
      default:
        jj_la1[60] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[61] = jj_gen;
      ;
    }
showTablesStatement = new ShowTablesStatement();
    showTablesStatement.setModifiers(modifiers);
    showTablesStatement.setSelectionMode(selectionMode);
    showTablesStatement.setDbName(dbName);
    showTablesStatement.setLikeExpression(likeExpression);
    showTablesStatement.setWhereCondition(whereCondition);
    return showTablesStatement;
}

  final public Values Values() throws ParseException {ExpressionList expressions;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_VALUES:{
      jj_consume_token(K_VALUES);
      break;
      }
    case K_VALUE:{
      jj_consume_token(K_VALUE);
      break;
      }
    default:
      jj_la1[62] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    expressions = ExpressionList();
return new Values(expressions);
}

  final public ReturningClause ReturningClause() throws ParseException {Token keyword;
    List<SelectItem<?>> selectItems;
    Object dataItem;
    List<Object> dataItems = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURNING:{
      keyword = jj_consume_token(K_RETURNING);
      break;
      }
    case K_RETURN:{
      keyword = jj_consume_token(K_RETURN);
      break;
      }
    default:
      jj_la1[63] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    selectItems = SelectItemsList();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INTO:{
      jj_consume_token(K_INTO);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALL:
      case K_ALTER:
      case K_ANALYZE:
      case K_ANY:
      case K_APPLY:
      case K_APPROXIMATE:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BASE64:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONNECT:
      case K_CONSTRAINTS:
      case K_CONVERT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATABASE:
      case K_DATA:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GLOBAL:
      case K_GRANT:
      case K_GROUP:
      case K_GROUPING:
      case K_GUARD:
      case K_HASH:
      case K_HISTORY:
      case K_HOPPING:
      case K_IF:
      case K_IIF:
      case K_IGNORE:
      case K_IN:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_INTERVAL:
      case K_INVALIDATE:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_LOOP:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAX:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MIN:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NEXTVAL:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OVERLAPS:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_PURGE:
      case K_QUALIFY:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_RECURSIVE:
      case K_REFERENCES:
      case K_REFRESH:
      case K_REGEXP:
      case K_RESPECT:
      case K_RLIKE:
      case K_REGISTER:
      case K_REMOTE:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_RETURN:
      case K_RIGHT:
      case K_ROLLBACK:
      case K_ROLLUP:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SECURE:
      case K_SEED:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SHARE:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_SOME:
      case K_START:
      case K_STORED:
      case K_STRING:
      case K_STRUCT:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VERBOSE:
      case K_VIEW:
      case K_VOLATILE:
      case K_CONCURRENTLY:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case DATA_TYPE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 429:
      case 430:
      case 431:
      case 432:
      case 433:
      case 434:
      case 435:
      case 436:{
        dataItem = Table();
        break;
        }
      case 445:
      case 476:{
        dataItem = UserVariable();
        break;
        }
      default:
        jj_la1[64] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
dataItems = new ArrayList<Object>(); dataItems.add(dataItem);
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[65] = jj_gen;
          break label_13;
        }
        jj_consume_token(K_COMMA);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ACTIVE:
        case K_ADD:
        case K_ADVANCE:
        case K_ADVISE:
        case K_AGAINST:
        case K_ALGORITHM:
        case K_ALL:
        case K_ALTER:
        case K_ANALYZE:
        case K_ANY:
        case K_APPLY:
        case K_APPROXIMATE:
        case K_ARCHIVE:
        case K_ARRAY_LITERAL:
        case K_AT:
        case K_ASC:
        case K_AUTHORIZATION:
        case K_AUTO:
        case K_BASE64:
        case K_BEGIN:
        case K_BERNOULLI:
        case K_BINARY:
        case K_BIT:
        case K_BLOCK:
        case K_BROWSE:
        case K_BY:
        case K_BYTES:
        case K_CACHE:
        case K_BUFFERS:
        case K_BYTE:
        case K_CALL:
        case K_CASCADE:
        case K_CASE:
        case K_CASEWHEN:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHANGES:
        case K_CHECKPOINT:
        case K_CHAR:
        case K_CLOSE:
        case K_COLLATE:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CONFLICT:
        case K_CONNECT:
        case K_CONSTRAINTS:
        case K_CONVERT:
        case K_COSTS:
        case K_CREATE:
        case K_CYCLE:
        case K_DATABASE:
        case K_DATA:
        case K_DECLARE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DEFAULT:
        case K_DEFERRABLE:
        case K_DELAYED:
        case K_DELETE:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DISCONNECT:
        case K_DIV:
        case K_DDL:
        case K_DML:
        case K_DO:
        case K_DOMAIN:
        case K_DROP:
        case K_DUMP:
        case K_DUPLICATE:
        case K_ELEMENTS:
        case K_EMIT:
        case K_ENABLE:
        case K_END:
        case K_ESCAPE:
        case K_EXCLUDE:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_EXPLICIT:
        case K_EXTENDED:
        case K_EXTRACT:
        case K_ISOLATION:
        case K_FILTER:
        case K_FIRST:
        case K_FALSE:
        case K_FLUSH:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_FULLTEXT:
        case K_FUNCTION:
        case K_GLOBAL:
        case K_GRANT:
        case K_GROUP:
        case K_GROUPING:
        case K_GUARD:
        case K_HASH:
        case K_HISTORY:
        case K_HOPPING:
        case K_IF:
        case K_IIF:
        case K_IGNORE:
        case K_IN:
        case K_INCLUDE:
        case K_INCREMENT:
        case K_INDEX:
        case K_INSERT:
        case K_INTERLEAVE:
        case K_INTERPRET:
        case K_INTERVAL:
        case K_INVALIDATE:
        case K_ISNULL:
        case K_JSON:
        case K_KEEP:
        case K_KEY:
        case K_KEYS:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LEFT:
        case K_LIMIT:
        case K_LOCAL:
        case K_LOCKED:
        case K_LINK:
        case K_LOG:
        case K_LOOP:
        case K_MATCH:
        case K_MATCHED:
        case K_MATERIALIZED:
        case K_MAX:
        case K_MAXVALUE:
        case K_MEMBER:
        case K_MERGE:
        case K_MIN:
        case K_MINVALUE:
        case K_MODIFY:
        case K_MOVEMENT:
        case K_NEXT:
        case K_NEXTVAL:
        case K_NO:
        case K_NOCACHE:
        case K_NOKEEP:
        case K_NOLOCK:
        case K_NOMAXVALUE:
        case K_NOMINVALUE:
        case K_NOORDER:
        case K_NOTHING:
        case K_NOTNULL:
        case K_NOVALIDATE:
        case K_NULLS:
        case K_NOWAIT:
        case K_OF:
        case K_OFF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OVERLAPS:
        case K_OPTIMIZE:
        case K_PARALLEL:
        case K_PARENT:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PLACING:
        case K_PRECEDING:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_PURGE:
        case K_QUALIFY:
        case K_QUERY:
        case K_QUICK:
        case K_QUIESCE:
        case K_RANGE:
        case K_RAW:
        case K_READ:
        case K_RECYCLEBIN:
        case K_RECURSIVE:
        case K_REFERENCES:
        case K_REFRESH:
        case K_REGEXP:
        case K_RESPECT:
        case K_RLIKE:
        case K_REGISTER:
        case K_REMOTE:
        case K_RENAME:
        case K_REPEATABLE:
        case K_REPLACE:
        case K_RESET:
        case K_RESTART:
        case K_RESUMABLE:
        case K_RESUME:
        case K_RESTRICT:
        case K_RESTRICTED:
        case K_RETURN:
        case K_RIGHT:
        case K_ROLLBACK:
        case K_ROLLUP:
        case K_ROOT:
        case K_ROW:
        case K_ROWS:
        case K_SAVEPOINT:
        case K_SCHEMA:
        case K_SECURE:
        case K_SEED:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SETS:
        case K_SHOW:
        case K_SHUTDOWN:
        case K_SHARE:
        case K_SIBLINGS:
        case K_SIMILAR:
        case K_SIZE:
        case K_SKIP:
        case K_SOME:
        case K_START:
        case K_STORED:
        case K_STRING:
        case K_STRUCT:
        case K_SUSPEND:
        case K_SWITCH:
        case K_SYNONYM:
        case K_SYSTEM:
        case K_TABLE:
        case K_TABLES:
        case K_TABLESPACE:
        case K_TRIGGER:
        case K_THEN:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TUMBLING:
        case K_TYPE:
        case K_UNLOGGED:
        case K_UPDATE:
        case K_UPSERT:
        case K_UNQIESCE:
        case K_USER:
        case K_SIGNED:
        case K_STRING_FUNCTION_NAME:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VERBOSE:
        case K_VIEW:
        case K_VOLATILE:
        case K_CONCURRENTLY:
        case K_WAIT:
        case K_WITHIN:
        case K_WITHOUT:
        case K_WORK:
        case K_XML:
        case K_XMLAGG:
        case K_XMLDATA:
        case K_XMLSCHEMA:
        case K_XMLTEXT:
        case K_XSINIL:
        case K_YAML:
        case K_YES:
        case K_ZONE:
        case DATA_TYPE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:
        case 429:
        case 430:
        case 431:
        case 432:
        case 433:
        case 434:
        case 435:
        case 436:{
          dataItem = Table();
          break;
          }
        case 445:
        case 476:{
          dataItem = UserVariable();
          break;
          }
        default:
          jj_la1[66] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
dataItems.add(dataItem);
      }
      break;
      }
    default:
      jj_la1[67] = jj_gen;
      ;
    }
return new ReturningClause(keyword.image, selectItems, dataItems);
}

  final public Update Update(List<WithItem> with) throws ParseException {Update update = new Update();
    Table table = null;
    List<Join> startJoins = null;

    List<UpdateSet> updateSets;
    Expression where = null;
    FromItem fromItem = null;
    List<Join> joins = null;
    Limit limit = null;
    List<OrderByElement> orderByElements;
    boolean useColumnsBrackets = false;
    ReturningClause returningClause;
    Token tk = null;
    UpdateModifierPriority modifierPriority = null;
    boolean modifierIgnore = false;

    OutputClause outputClause = null;
    jj_consume_token(K_UPDATE);
update.setOracleHint(getOracleHint());
    if (jj_2_27(2)) {
      jj_consume_token(K_LOW_PRIORITY);
modifierPriority = UpdateModifierPriority.LOW_PRIORITY;
    } else {
      ;
    }
    if (jj_2_28(2)) {
      jj_consume_token(K_IGNORE);
modifierIgnore = true;
    } else {
      ;
    }
    table = TableWithAliasAndMysqlIndexHint();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_APPLY:
    case K_COMMA:
    case K_CROSS:
    case K_FULL:
    case K_GLOBAL:
    case K_HASH:
    case K_INNER:
    case K_STRAIGHT:
    case K_JOIN:
    case K_LEFT:
    case K_LOOP:
    case K_MERGE:
    case K_NATURAL:
    case K_OUTER:
    case K_REMOTE:
    case K_RIGHT:{
      startJoins = JoinsList();
      break;
      }
    default:
      jj_la1[68] = jj_gen;
      ;
    }
    jj_consume_token(K_SET);
    updateSets = UpdateSets();
update.setUpdateSets(updateSets);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OUTPUT:{
      outputClause = OutputClause();
update.setOutputClause(outputClause);
      break;
      }
    default:
      jj_la1[69] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:{
      jj_consume_token(K_FROM);
      fromItem = FromItem();
      if (jj_2_29(2)) {
        joins = JoinsList();
      } else {
        ;
      }
      break;
      }
    default:
      jj_la1[70] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      where = WhereClause();
update.setWhere(where);
      break;
      }
    default:
      jj_la1[71] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
update.setOrderByElements(orderByElements);
      break;
      }
    default:
      jj_la1[72] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIMIT:{
      limit = PlainLimit();
update.setLimit(limit);
      break;
      }
    default:
      jj_la1[73] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURN:
    case K_RETURNING:{
      returningClause = ReturningClause();
update.setReturningClause(returningClause);
      break;
      }
    default:
      jj_la1[74] = jj_gen;
      ;
    }
return update.withWithItemsList(with)
              .withTable(table)
              .withStartJoins(startJoins)
              .withFromItem(fromItem)
              .withJoins(joins)
              .withModifierPriority(modifierPriority)
              .withModifierIgnore(modifierIgnore);
}

  final public List<UpdateSet> UpdateSets() throws ParseException {ArrayList<UpdateSet> updateSets = new ArrayList<UpdateSet>();
    UpdateSet updateSet;
    Column tableColumn;
    Expression valueExpression;

    ExpressionList<Column> columns;
    ExpressionList<Expression>values;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALL:
    case K_ALTER:
    case K_ANALYZE:
    case K_ANY:
    case K_APPLY:
    case K_APPROXIMATE:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BASE64:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CASEWHEN:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONNECT:
    case K_CONSTRAINTS:
    case K_CONVERT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATABASE:
    case K_DATA:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GLOBAL:
    case K_GRANT:
    case K_GROUP:
    case K_GROUPING:
    case K_GUARD:
    case K_HASH:
    case K_HISTORY:
    case K_HOPPING:
    case K_IF:
    case K_IIF:
    case K_IGNORE:
    case K_IN:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_INVALIDATE:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LEFT:
    case K_LIMIT:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_LOOP:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAX:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MIN:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NEXTVAL:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OVERLAPS:
    case K_OPTIMIZE:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_PURGE:
    case K_QUALIFY:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_RECURSIVE:
    case K_REFERENCES:
    case K_REFRESH:
    case K_REGEXP:
    case K_RESPECT:
    case K_RLIKE:
    case K_REGISTER:
    case K_REMOTE:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_RETURN:
    case K_RIGHT:
    case K_ROLLBACK:
    case K_ROLLUP:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SECURE:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SHARE:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_SOME:
    case K_START:
    case K_STORED:
    case K_STRING:
    case K_STRUCT:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_VOLATILE:
    case K_CONCURRENTLY:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case DATA_TYPE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 429:
    case 430:
    case 431:
    case 432:
    case 433:
    case 434:
    case 435:
    case 436:{
      tableColumn = Column();
      jj_consume_token(427);
      valueExpression = Expression();
updateSets.add( new UpdateSet (tableColumn, valueExpression));
      break;
      }
    case 425:{
updateSet = new UpdateSet(); updateSets.add(updateSet);
      columns = ParenthesedExpressionList();
updateSet.setColumns(columns);
      jj_consume_token(427);
      if (jj_2_30(3)) {
        valueExpression = ParenthesedSelect();
updateSet.setValues( new ExpressionList(valueExpression));
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 425:{
          values = ParenthesedExpressionList();
updateSet.setValues(values);
          break;
          }
        default:
          jj_la1[75] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[76] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:
      case 425:{
        ;
        break;
        }
      default:
        jj_la1[77] = jj_gen;
        break label_14;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        jj_consume_token(K_COMMA);
        tableColumn = Column();
        jj_consume_token(427);
        valueExpression = Expression();
updateSets.add( new UpdateSet (tableColumn, valueExpression));
        break;
        }
      case 425:{
updateSet = new UpdateSet(); updateSets.add(updateSet);
        columns = ParenthesedExpressionList();
updateSet.setColumns(columns);
        jj_consume_token(427);
        if (jj_2_31(3)) {
          valueExpression = ParenthesedSelect();
updateSet.setValues( new ExpressionList(valueExpression));
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 425:{
            values = ParenthesedExpressionList();
updateSet.setValues(values);
            break;
            }
          default:
            jj_la1[78] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[79] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return updateSets;
}

  final public Insert Insert(List<WithItem> with) throws ParseException {Insert insert = new Insert();
    Table table = null;
    Column tableColumn = null;
    ExpressionList<Column> columns = new ExpressionList<Column>();
    Expression exp = null;
    ReturningClause returningClause;
    Select select = null;
    boolean useDuplicate = false;
    Token tk = null;
    InsertModifierPriority modifierPriority = null;
    boolean modifierIgnore = false;

    List<UpdateSet> updateSets;
    List<UpdateSet> duplicateUpdateSets;

    String name = null;
    boolean useAs = false;
    OutputClause outputClause = null;

    InsertConflictTarget conflictTarget = null;
    InsertConflictAction conflictAction = null;
    jj_consume_token(K_INSERT);
insert.setOracleHint(getOracleHint());
    if (jj_2_32(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LOW_PRIORITY:{
        tk = jj_consume_token(K_LOW_PRIORITY);
        break;
        }
      case K_DELAYED:{
        tk = jj_consume_token(K_DELAYED);
        break;
        }
      case K_HIGH_PRIORITY:{
        tk = jj_consume_token(K_HIGH_PRIORITY);
        break;
        }
      default:
        jj_la1[80] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (tk!=null)
            modifierPriority = InsertModifierPriority.from(tk.image);
    } else {
      ;
    }
    if (jj_2_33(2)) {
      jj_consume_token(K_IGNORE);
modifierIgnore = true;
    } else {
      ;
    }
    if (jj_2_34(2)) {
      jj_consume_token(K_INTO);
    } else {
      ;
    }
    table = Table();
    if (jj_2_35(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AS:{
        jj_consume_token(K_AS);
useAs = true;
        break;
        }
      default:
        jj_la1[81] = jj_gen;
        ;
      }
      name = RelObjectNameWithoutValue();
table.setAlias(new Alias(name,useAs));
    } else {
      ;
    }
    if (jj_2_36(2)) {
      jj_consume_token(425);
      columns = ColumnList();
      jj_consume_token(426);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OUTPUT:{
      outputClause = OutputClause();
insert.setOutputClause(outputClause);
      break;
      }
    default:
      jj_la1[82] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SET:{
      jj_consume_token(K_SET);
      updateSets = UpdateSets();
insert.withSetUpdateSets(updateSets);
      break;
      }
    case K_SELECT:
    case K_VALUE:
    case K_VALUES:
    case K_WITH:
    case 425:{
      select = Select();
      break;
      }
    default:
      jj_la1[83] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_37(2)) {
      jj_consume_token(K_ON);
      jj_consume_token(K_DUPLICATE);
      jj_consume_token(K_KEY);
      jj_consume_token(K_UPDATE);
      duplicateUpdateSets = UpdateSets();
insert.withDuplicateUpdateSets(duplicateUpdateSets);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ON:{
      jj_consume_token(K_ON);
      jj_consume_token(K_CONFLICT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ON:
      case 425:{
        conflictTarget = InsertConflictTarget();
        break;
        }
      default:
        jj_la1[84] = jj_gen;
        ;
      }
      conflictAction = InsertConflictAction();
insert.withConflictTarget(conflictTarget).setConflictAction(conflictAction);
      break;
      }
    default:
      jj_la1[85] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURN:
    case K_RETURNING:{
      returningClause = ReturningClause();
insert.setReturningClause(returningClause);
      break;
      }
    default:
      jj_la1[86] = jj_gen;
      ;
    }
if (!columns.isEmpty()) {
            insert.setColumns(columns);
        }
        return insert.withWithItemsList(with)
              .withSelect(select)
              .withTable(table)
              .withModifierPriority(modifierPriority)
              .withModifierIgnore(modifierIgnore);
}

  final public InsertConflictTarget InsertConflictTarget() throws ParseException {String indexColumnName;
    ArrayList<String> indexColumnNames = new ArrayList<String>();
    Expression indexExpression = null;
    Expression whereExpression = null;
    String constraintName = null ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 425:{
      jj_consume_token(425);
      indexColumnName = RelObjectNameExt2();
indexColumnNames.add(indexColumnName);
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[87] = jj_gen;
          break label_15;
        }
        jj_consume_token(K_COMMA);
        indexColumnName = RelObjectNameExt2();
indexColumnNames.add(indexColumnName);
      }
      jj_consume_token(426);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WHERE:{
        whereExpression = WhereClause();
        break;
        }
      default:
        jj_la1[88] = jj_gen;
        ;
      }
      break;
      }
    case K_ON:{
      jj_consume_token(K_ON);
      jj_consume_token(K_CONSTRAINT);
      constraintName = RelObjectNameExt2();
      break;
      }
    default:
      jj_la1[89] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return new InsertConflictTarget(indexColumnNames, indexExpression, whereExpression, constraintName);
}

  final public InsertConflictAction InsertConflictAction() throws ParseException {InsertConflictAction conflictAction;
    Expression whereExpression = null;
    List<UpdateSet> updateSets;
    if (jj_2_38(2)) {
      jj_consume_token(K_DO);
      jj_consume_token(K_NOTHING);
conflictAction = new InsertConflictAction( ConflictActionType.DO_NOTHING );
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DO:{
        jj_consume_token(K_DO);
        jj_consume_token(K_UPDATE);
        jj_consume_token(K_SET);
conflictAction = new InsertConflictAction( ConflictActionType.DO_UPDATE );
        updateSets = UpdateSets();
conflictAction.setUpdateSets(updateSets);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHERE:{
          whereExpression = WhereClause();
          break;
          }
        default:
          jj_la1[90] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[91] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return conflictAction
                .withWhereExpression(whereExpression);
}

  final public OutputClause OutputClause() throws ParseException {List<SelectItem<?>> selectItemList = null;
    UserVariable tableVariable = null;
    Table outputTable = null;
    List<String> columnList = null;
    jj_consume_token(K_OUTPUT);
    selectItemList = SelectItemsList();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INTO:{
      jj_consume_token(K_INTO);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 445:
      case 476:{
        tableVariable = UserVariable();
        break;
        }
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALL:
      case K_ALTER:
      case K_ANALYZE:
      case K_ANY:
      case K_APPLY:
      case K_APPROXIMATE:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BASE64:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONNECT:
      case K_CONSTRAINTS:
      case K_CONVERT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATABASE:
      case K_DATA:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GLOBAL:
      case K_GRANT:
      case K_GROUP:
      case K_GROUPING:
      case K_GUARD:
      case K_HASH:
      case K_HISTORY:
      case K_HOPPING:
      case K_IF:
      case K_IIF:
      case K_IGNORE:
      case K_IN:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_INTERVAL:
      case K_INVALIDATE:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_LOOP:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAX:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MIN:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NEXTVAL:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OVERLAPS:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_PURGE:
      case K_QUALIFY:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_RECURSIVE:
      case K_REFERENCES:
      case K_REFRESH:
      case K_REGEXP:
      case K_RESPECT:
      case K_RLIKE:
      case K_REGISTER:
      case K_REMOTE:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_RETURN:
      case K_RIGHT:
      case K_ROLLBACK:
      case K_ROLLUP:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SECURE:
      case K_SEED:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SHARE:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_SOME:
      case K_START:
      case K_STORED:
      case K_STRING:
      case K_STRUCT:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VERBOSE:
      case K_VIEW:
      case K_VOLATILE:
      case K_CONCURRENTLY:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case DATA_TYPE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 429:
      case 430:
      case 431:
      case 432:
      case 433:
      case 434:
      case 435:
      case 436:{
        outputTable = Table();
        break;
        }
      default:
        jj_la1[92] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_39(2)) {
        columnList = ColumnsNamesList();
      } else {
        ;
      }
      break;
      }
    default:
      jj_la1[93] = jj_gen;
      ;
    }
return new OutputClause(selectItemList, tableVariable, outputTable, columnList);
}

  final public Upsert Upsert() throws ParseException {Upsert upsert = new Upsert();
    Table table = null;
    ExpressionList<Column> columns;
    List<UpdateSet> updateSets;

    Select select = null;
    List<UpdateSet> duplicateUpdateSets;
    Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_UPSERT:{
      jj_consume_token(K_UPSERT);
upsert.setUpsertType(UpsertType.UPSERT);
      break;
      }
    case K_REPLACE:{
      jj_consume_token(K_REPLACE);
upsert.setUpsertType(UpsertType.REPLACE);
      break;
      }
    case K_INSERT:{
      jj_consume_token(K_INSERT);
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
upsert.setUpsertType(UpsertType.INSERT_OR_REPLACE);
      break;
      }
    default:
      jj_la1[94] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_40(2)) {
      jj_consume_token(K_INTO);
upsert.setUsingInto(true);
    } else {
      ;
    }
    table = Table();
upsert.setTable(table);
    if (jj_2_41(2)) {
      columns = ParenthesedColumnList();
upsert.setColumns(columns);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SET:{
      jj_consume_token(K_SET);
      updateSets = UpdateSets();
upsert.setUpdateSets(updateSets);
      break;
      }
    case K_SELECT:
    case K_VALUE:
    case K_VALUES:
    case K_WITH:
    case 425:{
      select = Select();
upsert.setSelect(select);
      break;
      }
    default:
      jj_la1[95] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ON:{
      jj_consume_token(K_ON);
      jj_consume_token(K_DUPLICATE);
      jj_consume_token(K_KEY);
      jj_consume_token(K_UPDATE);
      duplicateUpdateSets = UpdateSets();
upsert.setDuplicateUpdateSets(duplicateUpdateSets);
      break;
      }
    default:
      jj_la1[96] = jj_gen;
      ;
    }
return upsert;
}

  final public Delete Delete(List<WithItem> with) throws ParseException {Delete delete = new Delete();
    Table table = null;
    List<Table> tables = new ArrayList<Table>();
    Table usingTable = null;
    List<Table> usingList = new ArrayList<Table>();
    List<Join> joins = null;
    Expression where = null;
    Limit limit = null;
    List<OrderByElement> orderByElements;
    boolean hasFrom = false;
    Token tk = null;
    DeleteModifierPriority modifierPriority = null;
    boolean modifierIgnore = false;
    boolean modifierQuick = false;

    ReturningClause returningClause;
    OutputClause outputClause;
    jj_consume_token(K_DELETE);
delete.setOracleHint(getOracleHint());
    if (jj_2_42(2)) {
      jj_consume_token(K_LOW_PRIORITY);
modifierPriority = DeleteModifierPriority.LOW_PRIORITY;
    } else {
      ;
    }
    if (jj_2_43(2)) {
      jj_consume_token(K_QUICK);
modifierQuick = true;
    } else {
      ;
    }
    if (jj_2_44(2)) {
      jj_consume_token(K_IGNORE);
modifierIgnore = true;
    } else {
      ;
    }
    if (jj_2_45(4)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALL:
      case K_ALTER:
      case K_ANALYZE:
      case K_ANY:
      case K_APPLY:
      case K_APPROXIMATE:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BASE64:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONNECT:
      case K_CONSTRAINTS:
      case K_CONVERT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATABASE:
      case K_DATA:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GLOBAL:
      case K_GRANT:
      case K_GROUP:
      case K_GROUPING:
      case K_GUARD:
      case K_HASH:
      case K_HISTORY:
      case K_HOPPING:
      case K_IF:
      case K_IIF:
      case K_IGNORE:
      case K_IN:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_INTERVAL:
      case K_INVALIDATE:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_LOOP:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAX:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MIN:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NEXTVAL:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OVERLAPS:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_PURGE:
      case K_QUALIFY:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_RECURSIVE:
      case K_REFERENCES:
      case K_REFRESH:
      case K_REGEXP:
      case K_RESPECT:
      case K_RLIKE:
      case K_REGISTER:
      case K_REMOTE:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_RETURN:
      case K_RIGHT:
      case K_ROLLBACK:
      case K_ROLLUP:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SECURE:
      case K_SEED:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SHARE:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_SOME:
      case K_START:
      case K_STORED:
      case K_STRING:
      case K_STRUCT:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VERBOSE:
      case K_VIEW:
      case K_VOLATILE:
      case K_CONCURRENTLY:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case DATA_TYPE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 429:
      case 430:
      case 431:
      case 432:
      case 433:
      case 434:
      case 435:
      case 436:{
        table = TableWithAlias();
tables.add(table);
        label_16:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[97] = jj_gen;
            break label_16;
          }
          jj_consume_token(K_COMMA);
          table = TableWithAlias();
tables.add(table);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_OUTPUT:{
          outputClause = OutputClause();
delete.setOutputClause(outputClause);
          break;
          }
        default:
          jj_la1[98] = jj_gen;
          ;
        }
        jj_consume_token(K_FROM);
        break;
        }
      case K_FROM:{
        jj_consume_token(K_FROM);
        break;
        }
      default:
        jj_la1[99] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
hasFrom = true;
    } else {
      ;
    }
    if (jj_2_47(3)) {
      table = TableWithAlias();
      if (jj_2_46(2)) {
        joins = JoinsList();
      } else {
        ;
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_USING:{
      jj_consume_token(K_USING);
      usingTable = TableWithAlias();
usingList.add(usingTable);
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[100] = jj_gen;
          break label_17;
        }
        jj_consume_token(K_COMMA);
        usingTable = TableWithAlias();
usingList.add(usingTable);
      }
      break;
      }
    default:
      jj_la1[101] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      where = WhereClause();
delete.setWhere(where);
      break;
      }
    default:
      jj_la1[102] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
delete.setOrderByElements(orderByElements);
      break;
      }
    default:
      jj_la1[103] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIMIT:{
      limit = PlainLimit();
delete.setLimit(limit);
      break;
      }
    default:
      jj_la1[104] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURN:
    case K_RETURNING:{
      returningClause = ReturningClause();
delete.setReturningClause(returningClause);
      break;
      }
    default:
      jj_la1[105] = jj_gen;
      ;
    }
if (joins != null && joins.size() > 0) {
            delete.setJoins(joins);
        }
        return delete.withWithItemsList(with)
              .withTables(tables)
              .withTable(table)
              .withHasFrom(hasFrom)
              .withUsingList(usingList)
              .withModifierPriority(modifierPriority)
              .withModifierIgnore(modifierIgnore)
              .withModifierQuick(modifierQuick);
}

  final public Statement Merge(List<WithItem> with) throws ParseException {Merge merge = new Merge();
    Table table;
    FromItem fromItem;
    Expression condition;
    List<MergeOperation> operations;
    OutputClause outputClause;
    jj_consume_token(K_MERGE);
merge.setOracleHint(getOracleHint());
    jj_consume_token(K_INTO);
    table = TableWithAlias();
merge.setTable(table);
    jj_consume_token(K_USING);
    fromItem = FromItem();
merge.setFromItem(fromItem);
    jj_consume_token(K_ON);
    condition = Expression();
merge.setOnCondition(condition);
    operations = MergeOperations();
merge.setOperations(operations);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OUTPUT:{
      outputClause = OutputClause();
merge.setOutputClause(outputClause);
      break;
      }
    default:
      jj_la1[106] = jj_gen;
      ;
    }
return merge.withWithItemsList(with);
}

  final public List<MergeOperation> MergeOperations() throws ParseException {List<MergeOperation> operationsList = new ArrayList<MergeOperation>();
    MergeOperation operation;
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WHEN:{
        ;
        break;
        }
      default:
        jj_la1[107] = jj_gen;
        break label_18;
      }
      if (jj_2_48(2)) {
        operation = MergeWhenMatched();
operationsList.add(operation);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          operation = MergeWhenNotMatched();
operationsList.add(operation);
          break;
          }
        default:
          jj_la1[108] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return operationsList;
}

  final public MergeOperation MergeWhenMatched() throws ParseException {Expression predicate = null;
    MergeOperation operation;
    jj_consume_token(K_WHEN);
    jj_consume_token(K_MATCHED);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AND:{
      jj_consume_token(K_AND);
      predicate = Expression();
      break;
      }
    default:
      jj_la1[109] = jj_gen;
      ;
    }
    jj_consume_token(K_THEN);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DELETE:{
      operation = MergeDeleteClause(predicate);
      break;
      }
    case K_UPDATE:{
      operation = MergeUpdateClause(predicate);
      break;
      }
    default:
      jj_la1[110] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return operation;
}

  final public MergeOperation MergeDeleteClause(Expression predicate) throws ParseException {MergeDelete md = new MergeDelete().withAndPredicate(predicate);
    jj_consume_token(K_DELETE);
return md;
}

  final public MergeOperation MergeUpdateClause(Expression predicate) throws ParseException {MergeUpdate mu = new MergeUpdate().withAndPredicate(predicate);
    List<UpdateSet> updateSets;
    Expression condition;
    jj_consume_token(K_UPDATE);
    jj_consume_token(K_SET);
    updateSets = UpdateSets();
mu.setUpdateSets(updateSets);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      jj_consume_token(K_WHERE);
      condition = Expression();
mu.setWhereCondition(condition);
      break;
      }
    default:
      jj_la1[111] = jj_gen;
      ;
    }
    if (jj_2_49(2)) {
      jj_consume_token(K_DELETE);
      jj_consume_token(K_WHERE);
      condition = Expression();
mu.setDeleteWhereCondition(condition);
    } else {
      ;
    }
return mu;
}

  final public MergeOperation MergeWhenNotMatched() throws ParseException {MergeInsert mi = new MergeInsert();
    Expression predicate;
    ExpressionList<Column> columns;
    ExpressionList expList;
    Expression condition;
    jj_consume_token(K_WHEN);
    jj_consume_token(K_NOT);
    jj_consume_token(K_MATCHED);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AND:{
      jj_consume_token(K_AND);
      predicate = Expression();
mi.setAndPredicate(predicate);
      break;
      }
    default:
      jj_la1[112] = jj_gen;
      ;
    }
    jj_consume_token(K_THEN);
    jj_consume_token(K_INSERT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 425:{
      jj_consume_token(425);
      columns = ColumnList();
      jj_consume_token(426);
mi.setColumns( new ParenthesedExpressionList<Column>(columns) );
      break;
      }
    default:
      jj_la1[113] = jj_gen;
      ;
    }
    jj_consume_token(K_VALUES);
    jj_consume_token(425);
    expList = SimpleExpressionList();
    jj_consume_token(426);
mi.setValues( new ParenthesedExpressionList(expList) );
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      jj_consume_token(K_WHERE);
      condition = Expression();
mi.setWhereCondition(condition);
      break;
      }
    default:
      jj_la1[114] = jj_gen;
      ;
    }
return mi;
}

  final public ObjectNames RelObjectNames() throws ParseException {String token = null;
    Token delimiter = null;
    List<String> data = new ArrayList<String>();
    List<String> delimiters = new ArrayList<String>();
    token = RelObjectNameExt();
data.add(token);
    label_19:
    while (true) {
      if (jj_2_50(2)) {
        ;
      } else {
        break label_19;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 428:{
        delimiter = jj_consume_token(428);
        break;
        }
      case DOUBLE_COLON:{
        delimiter = jj_consume_token(DOUBLE_COLON);
        break;
        }
      default:
        jj_la1[115] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
delimiters.add(delimiter.image);
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case DOUBLE_COLON:
        case 428:{
          ;
          break;
          }
        default:
          jj_la1[116] = jj_gen;
          break label_20;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 428:{
          delimiter = jj_consume_token(428);
          break;
          }
        case DOUBLE_COLON:{
          delimiter = jj_consume_token(DOUBLE_COLON);
          break;
          }
        default:
          jj_la1[117] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
data.add(null); delimiters.add(delimiter.image);
      }
      token = RelObjectNameExt2();
data.add(token);
    }
return new ObjectNames(data, delimiters);
}

// See: http://technet.microsoft.com/en-us/library/ms187879%28v=sql.105%29.aspx
  final public 
Column Column() throws ParseException {/*@bgen(jjtree) Column */
    SimpleNode jjtn000 = new SimpleNode(JJTCOLUMN);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));ObjectNames data = null;
    ArrayConstructor arrayConstructor = null;
    Token tk = null;
    try {
      data = RelObjectNames();
      if (jj_2_51(2)) {
        jj_consume_token(K_COMMENT);
        tk = jj_consume_token(S_CHAR_LITERAL);
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 428:{
        jj_consume_token(428);
        jj_consume_token(K_NEXTVAL);
data.getNames().add("nextval");
        break;
        }
      default:
        jj_la1[118] = jj_gen;
        ;
      }
      if (jj_2_52(2)) {
        arrayConstructor = ArrayConstructor(false);
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Column col = new Column(data.getNames(), data.getDelimiters());
        if (tk != null) { col.withCommentText(tk.image); }
        if (arrayConstructor!=null) {
            col.setArrayConstructor(arrayConstructor);
        }
        linkAST(col,jjtn000);
        return col;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

/*
The following tokens are allowed as Names for Schema, Table, Column and Aliases
*/

// Generated Code! Please do not edit manually.
// Instead:
// 1) define the ALL_RESERVED_KEYWORDS in the PARSER DECLARATION above (line 157 ff)
// 2) run the Gradle Task :JSQLParser:updateKeywords, which would update/replace the content of this method
  final public String RelObjectNameWithoutValue() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DATA_TYPE:{
      tk = jj_consume_token(DATA_TYPE);
      break;
      }
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      tk = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    case K_DATE_LITERAL:{
      tk = jj_consume_token(K_DATE_LITERAL);
      break;
      }
    case K_DATETIMELITERAL:{
      tk = jj_consume_token(K_DATETIMELITERAL);
      break;
      }
    case K_STRING_FUNCTION_NAME:{
      tk = jj_consume_token(K_STRING_FUNCTION_NAME);
      break;
      }
    case K_ISOLATION:{
      tk = jj_consume_token(K_ISOLATION);
      break;
      }
    case K_TIME_KEY_EXPR:{
      tk = jj_consume_token(K_TIME_KEY_EXPR);
      break;
      }
    case K_ACTION:{
      tk = jj_consume_token(K_ACTION);
      break;
      }
    case K_ACTIVE:{
      tk = jj_consume_token(K_ACTIVE);
      break;
      }
    case K_ADD:{
      tk = jj_consume_token(K_ADD);
      break;
      }
    case K_ADVANCE:{
      tk = jj_consume_token(K_ADVANCE);
      break;
      }
    case K_ADVISE:{
      tk = jj_consume_token(K_ADVISE);
      break;
      }
    case K_AGAINST:{
      tk = jj_consume_token(K_AGAINST);
      break;
      }
    case K_ALGORITHM:{
      tk = jj_consume_token(K_ALGORITHM);
      break;
      }
    case K_ALTER:{
      tk = jj_consume_token(K_ALTER);
      break;
      }
    case K_ANALYZE:{
      tk = jj_consume_token(K_ANALYZE);
      break;
      }
    case K_APPLY:{
      tk = jj_consume_token(K_APPLY);
      break;
      }
    case K_APPROXIMATE:{
      tk = jj_consume_token(K_APPROXIMATE);
      break;
      }
    case K_ARCHIVE:{
      tk = jj_consume_token(K_ARCHIVE);
      break;
      }
    case K_ARRAY_LITERAL:{
      tk = jj_consume_token(K_ARRAY_LITERAL);
      break;
      }
    case K_ASC:{
      tk = jj_consume_token(K_ASC);
      break;
      }
    case K_AT:{
      tk = jj_consume_token(K_AT);
      break;
      }
    case K_AUTHORIZATION:{
      tk = jj_consume_token(K_AUTHORIZATION);
      break;
      }
    case K_AUTO:{
      tk = jj_consume_token(K_AUTO);
      break;
      }
    case K_BASE64:{
      tk = jj_consume_token(K_BASE64);
      break;
      }
    case K_BEGIN:{
      tk = jj_consume_token(K_BEGIN);
      break;
      }
    case K_BERNOULLI:{
      tk = jj_consume_token(K_BERNOULLI);
      break;
      }
    case K_BINARY:{
      tk = jj_consume_token(K_BINARY);
      break;
      }
    case K_BIT:{
      tk = jj_consume_token(K_BIT);
      break;
      }
    case K_BLOCK:{
      tk = jj_consume_token(K_BLOCK);
      break;
      }
    case K_BROWSE:{
      tk = jj_consume_token(K_BROWSE);
      break;
      }
    case K_BUFFERS:{
      tk = jj_consume_token(K_BUFFERS);
      break;
      }
    case K_BY:{
      tk = jj_consume_token(K_BY);
      break;
      }
    case K_BYTE:{
      tk = jj_consume_token(K_BYTE);
      break;
      }
    case K_BYTES:{
      tk = jj_consume_token(K_BYTES);
      break;
      }
    case K_CACHE:{
      tk = jj_consume_token(K_CACHE);
      break;
      }
    case K_CALL:{
      tk = jj_consume_token(K_CALL);
      break;
      }
    case K_CASCADE:{
      tk = jj_consume_token(K_CASCADE);
      break;
      }
    case K_CASE:{
      tk = jj_consume_token(K_CASE);
      break;
      }
    case K_CAST:{
      tk = jj_consume_token(K_CAST);
      break;
      }
    case K_CHANGE:{
      tk = jj_consume_token(K_CHANGE);
      break;
      }
    case K_CHANGES:{
      tk = jj_consume_token(K_CHANGES);
      break;
      }
    case K_CHAR:{
      tk = jj_consume_token(K_CHAR);
      break;
      }
    case K_CHARACTER:{
      tk = jj_consume_token(K_CHARACTER);
      break;
      }
    case K_CHECKPOINT:{
      tk = jj_consume_token(K_CHECKPOINT);
      break;
      }
    case K_CLOSE:{
      tk = jj_consume_token(K_CLOSE);
      break;
      }
    case K_COLLATE:{
      tk = jj_consume_token(K_COLLATE);
      break;
      }
    case K_COLUMN:{
      tk = jj_consume_token(K_COLUMN);
      break;
      }
    case K_COLUMNS:{
      tk = jj_consume_token(K_COLUMNS);
      break;
      }
    case K_COMMENT:{
      tk = jj_consume_token(K_COMMENT);
      break;
      }
    case K_COMMIT:{
      tk = jj_consume_token(K_COMMIT);
      break;
      }
    case K_CONCURRENTLY:{
      tk = jj_consume_token(K_CONCURRENTLY);
      break;
      }
    case K_CONFLICT:{
      tk = jj_consume_token(K_CONFLICT);
      break;
      }
    case K_CONSTRAINTS:{
      tk = jj_consume_token(K_CONSTRAINTS);
      break;
      }
    case K_CONVERT:{
      tk = jj_consume_token(K_CONVERT);
      break;
      }
    case K_COSTS:{
      tk = jj_consume_token(K_COSTS);
      break;
      }
    case 429:{
      tk = jj_consume_token(429);
      break;
      }
    case K_CYCLE:{
      tk = jj_consume_token(K_CYCLE);
      break;
      }
    case K_DATA:{
      tk = jj_consume_token(K_DATA);
      break;
      }
    case K_DATABASE:{
      tk = jj_consume_token(K_DATABASE);
      break;
      }
    case 430:{
      tk = jj_consume_token(430);
      break;
      }
    case K_DDL:{
      tk = jj_consume_token(K_DDL);
      break;
      }
    case K_DECLARE:{
      tk = jj_consume_token(K_DECLARE);
      break;
      }
    case K_DEFAULT:{
      tk = jj_consume_token(K_DEFAULT);
      break;
      }
    case K_DEFERRABLE:{
      tk = jj_consume_token(K_DEFERRABLE);
      break;
      }
    case K_DELAYED:{
      tk = jj_consume_token(K_DELAYED);
      break;
      }
    case K_DELETE:{
      tk = jj_consume_token(K_DELETE);
      break;
      }
    case K_DESC:{
      tk = jj_consume_token(K_DESC);
      break;
      }
    case K_DESCRIBE:{
      tk = jj_consume_token(K_DESCRIBE);
      break;
      }
    case K_DISABLE:{
      tk = jj_consume_token(K_DISABLE);
      break;
      }
    case K_DISCONNECT:{
      tk = jj_consume_token(K_DISCONNECT);
      break;
      }
    case K_DIV:{
      tk = jj_consume_token(K_DIV);
      break;
      }
    case K_DML:{
      tk = jj_consume_token(K_DML);
      break;
      }
    case K_DO:{
      tk = jj_consume_token(K_DO);
      break;
      }
    case K_DOMAIN:{
      tk = jj_consume_token(K_DOMAIN);
      break;
      }
    case K_DROP:{
      tk = jj_consume_token(K_DROP);
      break;
      }
    case K_DUMP:{
      tk = jj_consume_token(K_DUMP);
      break;
      }
    case K_DUPLICATE:{
      tk = jj_consume_token(K_DUPLICATE);
      break;
      }
    case K_ELEMENTS:{
      tk = jj_consume_token(K_ELEMENTS);
      break;
      }
    case K_EMIT:{
      tk = jj_consume_token(K_EMIT);
      break;
      }
    case K_ENABLE:{
      tk = jj_consume_token(K_ENABLE);
      break;
      }
    case K_END:{
      tk = jj_consume_token(K_END);
      break;
      }
    case K_ESCAPE:{
      tk = jj_consume_token(K_ESCAPE);
      break;
      }
    case K_EXCLUDE:{
      tk = jj_consume_token(K_EXCLUDE);
      break;
      }
    case K_EXEC:{
      tk = jj_consume_token(K_EXEC);
      break;
      }
    case K_EXECUTE:{
      tk = jj_consume_token(K_EXECUTE);
      break;
      }
    case K_EXPLAIN:{
      tk = jj_consume_token(K_EXPLAIN);
      break;
      }
    case K_EXPLICIT:{
      tk = jj_consume_token(K_EXPLICIT);
      break;
      }
    case K_EXTENDED:{
      tk = jj_consume_token(K_EXTENDED);
      break;
      }
    case K_EXTRACT:{
      tk = jj_consume_token(K_EXTRACT);
      break;
      }
    case K_FALSE:{
      tk = jj_consume_token(K_FALSE);
      break;
      }
    case K_FILTER:{
      tk = jj_consume_token(K_FILTER);
      break;
      }
    case K_FIRST:{
      tk = jj_consume_token(K_FIRST);
      break;
      }
    case K_FLUSH:{
      tk = jj_consume_token(K_FLUSH);
      break;
      }
    case K_FN:{
      tk = jj_consume_token(K_FN);
      break;
      }
    case K_FOLLOWING:{
      tk = jj_consume_token(K_FOLLOWING);
      break;
      }
    case K_FORMAT:{
      tk = jj_consume_token(K_FORMAT);
      break;
      }
    case K_FULLTEXT:{
      tk = jj_consume_token(K_FULLTEXT);
      break;
      }
    case K_FUNCTION:{
      tk = jj_consume_token(K_FUNCTION);
      break;
      }
    case K_GRANT:{
      tk = jj_consume_token(K_GRANT);
      break;
      }
    case K_GUARD:{
      tk = jj_consume_token(K_GUARD);
      break;
      }
    case K_HASH:{
      tk = jj_consume_token(K_HASH);
      break;
      }
    case K_HISTORY:{
      tk = jj_consume_token(K_HISTORY);
      break;
      }
    case K_HOPPING:{
      tk = jj_consume_token(K_HOPPING);
      break;
      }
    case K_INCLUDE:{
      tk = jj_consume_token(K_INCLUDE);
      break;
      }
    case K_INCREMENT:{
      tk = jj_consume_token(K_INCREMENT);
      break;
      }
    case K_INDEX:{
      tk = jj_consume_token(K_INDEX);
      break;
      }
    case K_INSERT:{
      tk = jj_consume_token(K_INSERT);
      break;
      }
    case K_INTERLEAVE:{
      tk = jj_consume_token(K_INTERLEAVE);
      break;
      }
    case K_INTERPRET:{
      tk = jj_consume_token(K_INTERPRET);
      break;
      }
    case K_INVALIDATE:{
      tk = jj_consume_token(K_INVALIDATE);
      break;
      }
    case K_ISNULL:{
      tk = jj_consume_token(K_ISNULL);
      break;
      }
    case K_JSON:{
      tk = jj_consume_token(K_JSON);
      break;
      }
    case K_KEEP:{
      tk = jj_consume_token(K_KEEP);
      break;
      }
    case K_KEY:{
      tk = jj_consume_token(K_KEY);
      break;
      }
    case K_KEYS:{
      tk = jj_consume_token(K_KEYS);
      break;
      }
    case K_LAST:{
      tk = jj_consume_token(K_LAST);
      break;
      }
    case K_LEADING:{
      tk = jj_consume_token(K_LEADING);
      break;
      }
    case K_LINK:{
      tk = jj_consume_token(K_LINK);
      break;
      }
    case K_LOCAL:{
      tk = jj_consume_token(K_LOCAL);
      break;
      }
    case K_LOCKED:{
      tk = jj_consume_token(K_LOCKED);
      break;
      }
    case K_LOG:{
      tk = jj_consume_token(K_LOG);
      break;
      }
    case K_LOOP:{
      tk = jj_consume_token(K_LOOP);
      break;
      }
    case K_MATCH:{
      tk = jj_consume_token(K_MATCH);
      break;
      }
    case K_MATCHED:{
      tk = jj_consume_token(K_MATCHED);
      break;
      }
    case K_MATERIALIZED:{
      tk = jj_consume_token(K_MATERIALIZED);
      break;
      }
    case K_MAX:{
      tk = jj_consume_token(K_MAX);
      break;
      }
    case K_MAXVALUE:{
      tk = jj_consume_token(K_MAXVALUE);
      break;
      }
    case K_MEMBER:{
      tk = jj_consume_token(K_MEMBER);
      break;
      }
    case K_MERGE:{
      tk = jj_consume_token(K_MERGE);
      break;
      }
    case K_MIN:{
      tk = jj_consume_token(K_MIN);
      break;
      }
    case K_MINVALUE:{
      tk = jj_consume_token(K_MINVALUE);
      break;
      }
    case K_MODIFY:{
      tk = jj_consume_token(K_MODIFY);
      break;
      }
    case K_MOVEMENT:{
      tk = jj_consume_token(K_MOVEMENT);
      break;
      }
    case K_NEXT:{
      tk = jj_consume_token(K_NEXT);
      break;
      }
    case K_NO:{
      tk = jj_consume_token(K_NO);
      break;
      }
    case K_NOCACHE:{
      tk = jj_consume_token(K_NOCACHE);
      break;
      }
    case K_NOKEEP:{
      tk = jj_consume_token(K_NOKEEP);
      break;
      }
    case K_NOLOCK:{
      tk = jj_consume_token(K_NOLOCK);
      break;
      }
    case K_NOMAXVALUE:{
      tk = jj_consume_token(K_NOMAXVALUE);
      break;
      }
    case K_NOMINVALUE:{
      tk = jj_consume_token(K_NOMINVALUE);
      break;
      }
    case K_NOORDER:{
      tk = jj_consume_token(K_NOORDER);
      break;
      }
    case K_NOTHING:{
      tk = jj_consume_token(K_NOTHING);
      break;
      }
    case K_NOTNULL:{
      tk = jj_consume_token(K_NOTNULL);
      break;
      }
    case K_NOVALIDATE:{
      tk = jj_consume_token(K_NOVALIDATE);
      break;
      }
    case K_NOWAIT:{
      tk = jj_consume_token(K_NOWAIT);
      break;
      }
    case K_NULLS:{
      tk = jj_consume_token(K_NULLS);
      break;
      }
    case K_OF:{
      tk = jj_consume_token(K_OF);
      break;
      }
    case K_OFF:{
      tk = jj_consume_token(K_OFF);
      break;
      }
    case K_OPEN:{
      tk = jj_consume_token(K_OPEN);
      break;
      }
    case K_OVER:{
      tk = jj_consume_token(K_OVER);
      break;
      }
    case K_OVERLAPS:{
      tk = jj_consume_token(K_OVERLAPS);
      break;
      }
    case K_PARALLEL:{
      tk = jj_consume_token(K_PARALLEL);
      break;
      }
    case K_PARENT:{
      tk = jj_consume_token(K_PARENT);
      break;
      }
    case K_PARTITION:{
      tk = jj_consume_token(K_PARTITION);
      break;
      }
    case K_PATH:{
      tk = jj_consume_token(K_PATH);
      break;
      }
    case K_PERCENT:{
      tk = jj_consume_token(K_PERCENT);
      break;
      }
    case K_PLACING:{
      tk = jj_consume_token(K_PLACING);
      break;
      }
    case K_PRECEDING:{
      tk = jj_consume_token(K_PRECEDING);
      break;
      }
    case 431:{
      tk = jj_consume_token(431);
      break;
      }
    case K_PRIMARY:{
      tk = jj_consume_token(K_PRIMARY);
      break;
      }
    case K_PRIOR:{
      tk = jj_consume_token(K_PRIOR);
      break;
      }
    case K_PURGE:{
      tk = jj_consume_token(K_PURGE);
      break;
      }
    case K_QUERY:{
      tk = jj_consume_token(K_QUERY);
      break;
      }
    case K_QUICK:{
      tk = jj_consume_token(K_QUICK);
      break;
      }
    case K_QUIESCE:{
      tk = jj_consume_token(K_QUIESCE);
      break;
      }
    case K_RANGE:{
      tk = jj_consume_token(K_RANGE);
      break;
      }
    case K_RAW:{
      tk = jj_consume_token(K_RAW);
      break;
      }
    case K_READ:{
      tk = jj_consume_token(K_READ);
      break;
      }
    case K_RECURSIVE:{
      tk = jj_consume_token(K_RECURSIVE);
      break;
      }
    case K_RECYCLEBIN:{
      tk = jj_consume_token(K_RECYCLEBIN);
      break;
      }
    case K_REFERENCES:{
      tk = jj_consume_token(K_REFERENCES);
      break;
      }
    case K_REFRESH:{
      tk = jj_consume_token(K_REFRESH);
      break;
      }
    case K_REGEXP:{
      tk = jj_consume_token(K_REGEXP);
      break;
      }
    case K_REGISTER:{
      tk = jj_consume_token(K_REGISTER);
      break;
      }
    case K_REMOTE:{
      tk = jj_consume_token(K_REMOTE);
      break;
      }
    case K_RENAME:{
      tk = jj_consume_token(K_RENAME);
      break;
      }
    case K_REPEATABLE:{
      tk = jj_consume_token(K_REPEATABLE);
      break;
      }
    case K_REPLACE:{
      tk = jj_consume_token(K_REPLACE);
      break;
      }
    case K_RESET:{
      tk = jj_consume_token(K_RESET);
      break;
      }
    case K_RESPECT:{
      tk = jj_consume_token(K_RESPECT);
      break;
      }
    case K_RESTART:{
      tk = jj_consume_token(K_RESTART);
      break;
      }
    case K_RESTRICT:{
      tk = jj_consume_token(K_RESTRICT);
      break;
      }
    case K_RESTRICTED:{
      tk = jj_consume_token(K_RESTRICTED);
      break;
      }
    case K_RESUMABLE:{
      tk = jj_consume_token(K_RESUMABLE);
      break;
      }
    case K_RESUME:{
      tk = jj_consume_token(K_RESUME);
      break;
      }
    case K_RETURN:{
      tk = jj_consume_token(K_RETURN);
      break;
      }
    case K_RLIKE:{
      tk = jj_consume_token(K_RLIKE);
      break;
      }
    case K_ROLLBACK:{
      tk = jj_consume_token(K_ROLLBACK);
      break;
      }
    case K_ROLLUP:{
      tk = jj_consume_token(K_ROLLUP);
      break;
      }
    case K_ROOT:{
      tk = jj_consume_token(K_ROOT);
      break;
      }
    case K_ROW:{
      tk = jj_consume_token(K_ROW);
      break;
      }
    case K_ROWS:{
      tk = jj_consume_token(K_ROWS);
      break;
      }
    case 432:{
      tk = jj_consume_token(432);
      break;
      }
    case 433:{
      tk = jj_consume_token(433);
      break;
      }
    case K_SAVEPOINT:{
      tk = jj_consume_token(K_SAVEPOINT);
      break;
      }
    case K_SCHEMA:{
      tk = jj_consume_token(K_SCHEMA);
      break;
      }
    case K_SECURE:{
      tk = jj_consume_token(K_SECURE);
      break;
      }
    case K_SEED:{
      tk = jj_consume_token(K_SEED);
      break;
      }
    case K_SEPARATOR:{
      tk = jj_consume_token(K_SEPARATOR);
      break;
      }
    case K_SEQUENCE:{
      tk = jj_consume_token(K_SEQUENCE);
      break;
      }
    case K_SESSION:{
      tk = jj_consume_token(K_SESSION);
      break;
      }
    case K_SETS:{
      tk = jj_consume_token(K_SETS);
      break;
      }
    case K_SHARE:{
      tk = jj_consume_token(K_SHARE);
      break;
      }
    case K_SHOW:{
      tk = jj_consume_token(K_SHOW);
      break;
      }
    case K_SHUTDOWN:{
      tk = jj_consume_token(K_SHUTDOWN);
      break;
      }
    case K_SIBLINGS:{
      tk = jj_consume_token(K_SIBLINGS);
      break;
      }
    case K_SIGNED:{
      tk = jj_consume_token(K_SIGNED);
      break;
      }
    case K_SIMILAR:{
      tk = jj_consume_token(K_SIMILAR);
      break;
      }
    case K_SIZE:{
      tk = jj_consume_token(K_SIZE);
      break;
      }
    case K_SKIP:{
      tk = jj_consume_token(K_SKIP);
      break;
      }
    case K_STORED:{
      tk = jj_consume_token(K_STORED);
      break;
      }
    case K_STRING:{
      tk = jj_consume_token(K_STRING);
      break;
      }
    case K_STRUCT:{
      tk = jj_consume_token(K_STRUCT);
      break;
      }
    case K_SUSPEND:{
      tk = jj_consume_token(K_SUSPEND);
      break;
      }
    case K_SWITCH:{
      tk = jj_consume_token(K_SWITCH);
      break;
      }
    case K_SYNONYM:{
      tk = jj_consume_token(K_SYNONYM);
      break;
      }
    case K_SYSTEM:{
      tk = jj_consume_token(K_SYSTEM);
      break;
      }
    case K_TABLE:{
      tk = jj_consume_token(K_TABLE);
      break;
      }
    case K_TABLESPACE:{
      tk = jj_consume_token(K_TABLESPACE);
      break;
      }
    case K_TEMP:{
      tk = jj_consume_token(K_TEMP);
      break;
      }
    case K_TEMPORARY:{
      tk = jj_consume_token(K_TEMPORARY);
      break;
      }
    case K_THEN:{
      tk = jj_consume_token(K_THEN);
      break;
      }
    case K_TIMEOUT:{
      tk = jj_consume_token(K_TIMEOUT);
      break;
      }
    case 434:{
      tk = jj_consume_token(434);
      break;
      }
    case 435:{
      tk = jj_consume_token(435);
      break;
      }
    case K_TO:{
      tk = jj_consume_token(K_TO);
      break;
      }
    case K_TRIGGER:{
      tk = jj_consume_token(K_TRIGGER);
      break;
      }
    case K_TRUE:{
      tk = jj_consume_token(K_TRUE);
      break;
      }
    case K_TRUNCATE:{
      tk = jj_consume_token(K_TRUNCATE);
      break;
      }
    case K_TUMBLING:{
      tk = jj_consume_token(K_TUMBLING);
      break;
      }
    case K_TYPE:{
      tk = jj_consume_token(K_TYPE);
      break;
      }
    case K_UNLOGGED:{
      tk = jj_consume_token(K_UNLOGGED);
      break;
      }
    case K_UNQIESCE:{
      tk = jj_consume_token(K_UNQIESCE);
      break;
      }
    case K_UNSIGNED:{
      tk = jj_consume_token(K_UNSIGNED);
      break;
      }
    case K_UPDATE:{
      tk = jj_consume_token(K_UPDATE);
      break;
      }
    case K_UPSERT:{
      tk = jj_consume_token(K_UPSERT);
      break;
      }
    case 436:{
      tk = jj_consume_token(436);
      break;
      }
    case K_USER:{
      tk = jj_consume_token(K_USER);
      break;
      }
    case K_VALIDATE:{
      tk = jj_consume_token(K_VALIDATE);
      break;
      }
    case K_VERBOSE:{
      tk = jj_consume_token(K_VERBOSE);
      break;
      }
    case K_VIEW:{
      tk = jj_consume_token(K_VIEW);
      break;
      }
    case K_VOLATILE:{
      tk = jj_consume_token(K_VOLATILE);
      break;
      }
    case K_WAIT:{
      tk = jj_consume_token(K_WAIT);
      break;
      }
    case K_WITHIN:{
      tk = jj_consume_token(K_WITHIN);
      break;
      }
    case K_WITHOUT:{
      tk = jj_consume_token(K_WITHOUT);
      break;
      }
    case K_WORK:{
      tk = jj_consume_token(K_WORK);
      break;
      }
    case K_XML:{
      tk = jj_consume_token(K_XML);
      break;
      }
    case K_XMLAGG:{
      tk = jj_consume_token(K_XMLAGG);
      break;
      }
    case K_XMLDATA:{
      tk = jj_consume_token(K_XMLDATA);
      break;
      }
    case K_XMLSCHEMA:{
      tk = jj_consume_token(K_XMLSCHEMA);
      break;
      }
    case K_XMLTEXT:{
      tk = jj_consume_token(K_XMLTEXT);
      break;
      }
    case K_XSINIL:{
      tk = jj_consume_token(K_XSINIL);
      break;
      }
    case K_YAML:{
      tk = jj_consume_token(K_YAML);
      break;
      }
    case K_YES:{
      tk = jj_consume_token(K_YES);
      break;
      }
    case K_ZONE:{
      tk = jj_consume_token(K_ZONE);
      break;
      }
    default:
      jj_la1[119] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return tk.image;
}

/*
These tokens can be used as names for Schema and Tables and Columns
BUT NOT for Aliases (without quoting)
*/
  final public String RelObjectName() throws ParseException {Token tk = null; String result = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALTER:
    case K_ANALYZE:
    case K_APPLY:
    case K_APPROXIMATE:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BASE64:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONSTRAINTS:
    case K_CONVERT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATABASE:
    case K_DATA:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GRANT:
    case K_GUARD:
    case K_HASH:
    case K_HISTORY:
    case K_HOPPING:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INVALIDATE:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_LOOP:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAX:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MIN:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_OPEN:
    case K_OVER:
    case K_OVERLAPS:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PURGE:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_RECURSIVE:
    case K_REFERENCES:
    case K_REFRESH:
    case K_REGEXP:
    case K_RESPECT:
    case K_RLIKE:
    case K_REGISTER:
    case K_REMOTE:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_RETURN:
    case K_ROLLBACK:
    case K_ROLLUP:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SECURE:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SHARE:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_STORED:
    case K_STRING:
    case K_STRUCT:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VERBOSE:
    case K_VIEW:
    case K_VOLATILE:
    case K_CONCURRENTLY:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case DATA_TYPE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 429:
    case 430:
    case 431:
    case 432:
    case 433:
    case 434:
    case 435:
    case 436:{
      result = RelObjectNameWithoutValue();
      break;
      }
    case K_GROUP:{
      tk = jj_consume_token(K_GROUP);
      break;
      }
    case K_INTERVAL:{
      tk = jj_consume_token(K_INTERVAL);
      break;
      }
    case K_ON:{
      tk = jj_consume_token(K_ON);
      break;
      }
    case K_START:{
      tk = jj_consume_token(K_START);
      break;
      }
    case K_TOP:{
      tk = jj_consume_token(K_TOP);
      break;
      }
    case K_VALUE:{
      tk = jj_consume_token(K_VALUE);
      break;
      }
    case K_VALUES:{
      tk = jj_consume_token(K_VALUES);
      break;
      }
    case K_CREATE:{
      tk = jj_consume_token(K_CREATE);
      break;
      }
    case K_TABLES:{
      tk = jj_consume_token(K_TABLES);
      break;
      }
    case K_CONNECT:{
      tk = jj_consume_token(K_CONNECT);
      break;
      }
    case K_IGNORE:{
      tk = jj_consume_token(K_IGNORE);
      break;
      }
    case K_QUALIFY:{
      tk = jj_consume_token(K_QUALIFY);
      break;
      }
    default:
      jj_la1[120] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return tk!=null ? tk.image : result;
}

  final public String RelObjectNameWithoutStart() throws ParseException {Token tk = null; String result = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALTER:
    case K_ANALYZE:
    case K_APPLY:
    case K_APPROXIMATE:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BASE64:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONSTRAINTS:
    case K_CONVERT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATABASE:
    case K_DATA:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GRANT:
    case K_GUARD:
    case K_HASH:
    case K_HISTORY:
    case K_HOPPING:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INVALIDATE:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_LOOP:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAX:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MIN:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_OPEN:
    case K_OVER:
    case K_OVERLAPS:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PURGE:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_RECURSIVE:
    case K_REFERENCES:
    case K_REFRESH:
    case K_REGEXP:
    case K_RESPECT:
    case K_RLIKE:
    case K_REGISTER:
    case K_REMOTE:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_RETURN:
    case K_ROLLBACK:
    case K_ROLLUP:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SECURE:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SHARE:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_STORED:
    case K_STRING:
    case K_STRUCT:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VERBOSE:
    case K_VIEW:
    case K_VOLATILE:
    case K_CONCURRENTLY:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case DATA_TYPE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 429:
    case 430:
    case 431:
    case 432:
    case 433:
    case 434:
    case 435:
    case 436:{
      result = RelObjectNameWithoutValue();
      break;
      }
    case K_TOP:{
      tk = jj_consume_token(K_TOP);
      break;
      }
    case K_VALUE:{
      tk = jj_consume_token(K_VALUE);
      break;
      }
    case K_VALUES:{
      tk = jj_consume_token(K_VALUES);
      break;
      }
    case K_INTERVAL:{
      tk = jj_consume_token(K_INTERVAL);
      break;
      }
    default:
      jj_la1[121] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return tk!=null ? tk.image : result;
}

/*
Extended version of object names.

These tokens can be used as names for Schema and Tables and Columns
BUT NOT for Aliases (without quoting)

*/
  final public String RelObjectNameExt() throws ParseException {Token tk = null;
  String result=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALTER:
    case K_ANALYZE:
    case K_APPLY:
    case K_APPROXIMATE:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BASE64:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONNECT:
    case K_CONSTRAINTS:
    case K_CONVERT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATABASE:
    case K_DATA:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GRANT:
    case K_GROUP:
    case K_GUARD:
    case K_HASH:
    case K_HISTORY:
    case K_HOPPING:
    case K_IGNORE:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_INVALIDATE:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_LOOP:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAX:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MIN:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_ON:
    case K_OPEN:
    case K_OVER:
    case K_OVERLAPS:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PURGE:
    case K_QUALIFY:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_RECURSIVE:
    case K_REFERENCES:
    case K_REFRESH:
    case K_REGEXP:
    case K_RESPECT:
    case K_RLIKE:
    case K_REGISTER:
    case K_REMOTE:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_RETURN:
    case K_ROLLBACK:
    case K_ROLLUP:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SECURE:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SHARE:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_START:
    case K_STORED:
    case K_STRING:
    case K_STRUCT:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_VOLATILE:
    case K_CONCURRENTLY:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case DATA_TYPE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 429:
    case 430:
    case 431:
    case 432:
    case 433:
    case 434:
    case 435:
    case 436:{
      result = RelObjectName();
      break;
      }
    case K_ALL:{
      tk = jj_consume_token(K_ALL);
      break;
      }
    case K_ANY:{
      tk = jj_consume_token(K_ANY);
      break;
      }
    case K_SOME:{
      tk = jj_consume_token(K_SOME);
      break;
      }
    case K_LEFT:{
      tk = jj_consume_token(K_LEFT);
      break;
      }
    case K_RIGHT:{
      tk = jj_consume_token(K_RIGHT);
      break;
      }
    case K_SET:{
      tk = jj_consume_token(K_SET);
      break;
      }
    case K_IF:{
      tk = jj_consume_token(K_IF);
      break;
      }
    case K_IIF:{
      tk = jj_consume_token(K_IIF);
      break;
      }
    case K_OPTIMIZE:{
      tk = jj_consume_token(K_OPTIMIZE);
      break;
      }
    case K_LIMIT:{
      tk = jj_consume_token(K_LIMIT);
      break;
      }
    case K_OFFSET:{
      tk = jj_consume_token(K_OFFSET);
      break;
      }
    case K_PROCEDURE:{
      tk = jj_consume_token(K_PROCEDURE);
      break;
      }
    case K_PUBLIC:{
      tk = jj_consume_token(K_PUBLIC);
      break;
      }
    case K_CASEWHEN:{
      tk = jj_consume_token(K_CASEWHEN);
      break;
      }
    case K_IN:{
      tk = jj_consume_token(K_IN);
      break;
      }
    case K_GROUPING:{
      tk = jj_consume_token(K_GROUPING);
      break;
      }
    case K_ORDER:{
      tk = jj_consume_token(K_ORDER);
      break;
      }
    case K_NEXTVAL:{
      tk = jj_consume_token(K_NEXTVAL);
      break;
      }
    case K_GLOBAL:{
      tk = jj_consume_token(K_GLOBAL);
      break;
      }
    default:
      jj_la1[122] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return tk!=null ? tk.image : result;
}

/*
Extended usage of object names - part 2. Using within multipart names as following parts.

These tokens can be used as names for Tables and Columns
BUT NOT for Schema or  Aliases (without quoting)

*/
  final public String RelObjectNameExt2() throws ParseException {Token tk = null;
  String result=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALL:
    case K_ALTER:
    case K_ANALYZE:
    case K_ANY:
    case K_APPLY:
    case K_APPROXIMATE:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BASE64:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CASEWHEN:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONNECT:
    case K_CONSTRAINTS:
    case K_CONVERT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATABASE:
    case K_DATA:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GLOBAL:
    case K_GRANT:
    case K_GROUP:
    case K_GROUPING:
    case K_GUARD:
    case K_HASH:
    case K_HISTORY:
    case K_HOPPING:
    case K_IF:
    case K_IIF:
    case K_IGNORE:
    case K_IN:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_INVALIDATE:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LEFT:
    case K_LIMIT:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_LOOP:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAX:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MIN:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NEXTVAL:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OVERLAPS:
    case K_OPTIMIZE:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_PURGE:
    case K_QUALIFY:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_RECURSIVE:
    case K_REFERENCES:
    case K_REFRESH:
    case K_REGEXP:
    case K_RESPECT:
    case K_RLIKE:
    case K_REGISTER:
    case K_REMOTE:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_RETURN:
    case K_RIGHT:
    case K_ROLLBACK:
    case K_ROLLUP:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SECURE:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SHARE:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_SOME:
    case K_START:
    case K_STORED:
    case K_STRING:
    case K_STRUCT:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_VOLATILE:
    case K_CONCURRENTLY:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case DATA_TYPE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 429:
    case 430:
    case 431:
    case 432:
    case 433:
    case 434:
    case 435:
    case 436:{
      result = RelObjectNameExt();
      break;
      }
    case K_FROM:{
      tk = jj_consume_token(K_FROM);
      break;
      }
    case K_SELECT:{
      tk = jj_consume_token(K_SELECT);
      break;
      }
    case K_CURRENT:{
      tk = jj_consume_token(K_CURRENT);
      break;
      }
    default:
      jj_la1[123] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return tk!=null ? tk.image : result;
}

  final public Table Table() throws ParseException {/*@bgen(jjtree) TableName */
    SimpleNode jjtn000 = new SimpleNode(JJTTABLENAME);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));//String serverName = null, databaseName = null, schemaName = null, tableName = null;
    ObjectNames data = null;
    try {
      data = RelObjectNames();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Table table = new Table(data.getNames());
                linkAST(table,jjtn000);
        return table;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Table TableWithAlias() throws ParseException {Table table = null;
    Alias alias = null;
    table = Table();
    if (jj_2_53(2)) {
      alias = Alias();
table.setAlias(alias);
    } else {
      ;
    }
return table;
}

  final public Table TableWithAliasAndMysqlIndexHint() throws ParseException {Table table = null;
    Alias alias = null;
    MySQLIndexHint indexHint = null;
    table = Table();
    if (jj_2_54(2)) {
      alias = Alias();
table.setAlias(alias);
    } else {
      ;
    }
    if (jj_2_55(2)) {
      indexHint = MySQLIndexHint();
table.setHint(indexHint);
    } else {
      ;
    }
return table;
}

  final public Number Number() throws ParseException {Token token;
    Number number;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_DOUBLE:{
      token = jj_consume_token(S_DOUBLE);
number = Double.valueOf(token.image);
      break;
      }
    case S_LONG:{
      token = jj_consume_token(S_LONG);
number = Long.valueOf(token.image);
      break;
      }
    default:
      jj_la1[124] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return number;
}

  final public SampleClause SampleClause() throws ParseException {Token token;
    SampleClause sampleClause;
    String keyword;
    String method=null;
    Number percentageArgument;
    Number repeatArgument=null;
    Number seedArgument=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SAMPLE:{
      // Oracle
                  token = jj_consume_token(K_SAMPLE);
keyword = token.image;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_BLOCK:{
        token = jj_consume_token(K_BLOCK);
method = token.image;
        break;
        }
      default:
        jj_la1[125] = jj_gen;
        ;
      }
      break;
      }
    case K_TABLESAMPLE:{
      // SQL:2016 compliant
                  token = jj_consume_token(K_TABLESAMPLE);
keyword = token.image;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SYSTEM:{
        token = jj_consume_token(K_SYSTEM);
        break;
        }
      case K_BERNOULLI:{
        token = jj_consume_token(K_BERNOULLI);
        break;
        }
      default:
        jj_la1[126] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
method = token.image;
      break;
      }
    default:
      jj_la1[127] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(425);
    percentageArgument = Number();
    jj_consume_token(426);
    if (jj_2_56(2)) {
      jj_consume_token(K_REPEATABLE);
      jj_consume_token(425);
      repeatArgument = Number();
      jj_consume_token(426);
    } else {
      ;
    }
    if (jj_2_57(2)) {
      jj_consume_token(K_SEED);
      jj_consume_token(425);
      seedArgument = Number();
      jj_consume_token(426);
    } else {
      ;
    }
return new SampleClause(keyword, method, percentageArgument, repeatArgument, seedArgument);
}

  final public Select SelectWithWithItems(List<WithItem> withItems) throws ParseException {Select select;
    select = Select();
select.setWithItemsList( withItems );
    return select;
}

  final public Select Select() throws ParseException {/*@bgen(jjtree) Select */
    SimpleNode jjtn000 = new SimpleNode(JJTSELECT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Select select = null;
    List<WithItem> with = null;
    List<OrderByElement> orderByElements = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    WithIsolation withIsolation = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WITH:{
        with = WithList();
        break;
        }
      default:
        jj_la1[128] = jj_gen;
        ;
      }
      if (jj_2_58(3)) {
        select = PlainSelect();
      } else if (jj_2_59(3)) {
        select = Values();
      } else if (jj_2_60(3)) {
        select = ParenthesedSelect();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_61(2)) {
        select = SetOperationList(select);
      } else {
        ;
      }
      if (jj_2_62(2147483647)) {
        orderByElements = OrderByElements();
select.setOrderByElements(orderByElements);
      } else {
        ;
      }
      if (jj_2_63(2147483647)) {
        limit = LimitWithOffset();
select.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_64(2147483647)) {
        offset = Offset();
select.setOffset(offset);
      } else {
        ;
      }
      if (jj_2_65(2147483647)) {
        fetch = Fetch();
select.setFetch(fetch);
      } else {
        ;
      }
      if (jj_2_66(2147483647)) {
        withIsolation = WithIsolation();
select.setIsolation(withIsolation);
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(select, jjtn000);
        return select.withWithItemsList(with);
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public TableStatement TableStatement() throws ParseException {Table table = null;
    List<OrderByElement> orderByElements = null;
    Limit limit = null;
    Offset offset = null;
    TableStatement tableStatement = new TableStatement();
    jj_consume_token(K_TABLE);
    table = Table();
tableStatement.setTable(table);
    if (jj_2_67(2147483647)) {
      orderByElements = OrderByElements();
tableStatement.setOrderByElements(orderByElements);
    } else {
      ;
    }
    if (jj_2_68(2147483647)) {
      limit = LimitWithOffset();
tableStatement.setLimit(limit);
    } else {
      ;
    }
    if (jj_2_69(2147483647)) {
      offset = Offset();
tableStatement.setOffset(offset);
    } else {
      ;
    }
return tableStatement;
}

  final public ParenthesedSelect ParenthesedSelect() throws ParseException {/*@bgen(jjtree) ParenthesedSelect */
    SimpleNode jjtn000 = new SimpleNode(JJTPARENTHESEDSELECT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));ParenthesedSelect parenthesedSelect = new ParenthesedSelect();
    Select select;
    try {
      jj_consume_token(425);
      select = Select();
      jj_consume_token(426);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(parenthesedSelect,jjtn000);
        return parenthesedSelect.withSelect(select);
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public LateralView LateralView() throws ParseException {/*@bgen(jjtree) LateralView */
    SimpleNode jjtn000 = new SimpleNode(JJTLATERALVIEW);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));boolean useOuter = false;
    Function generatorFunction = null;
    String tableName = null;
    String columnName = null;
    Alias tableAlias = null;
    Alias columnAlias = null;
    try {
      jj_consume_token(K_LATERAL);
      jj_consume_token(K_VIEW);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_OUTER:{
        jj_consume_token(K_OUTER);
useOuter=true;
        break;
        }
      default:
        jj_la1[129] = jj_gen;
        ;
      }
      generatorFunction = Function();
      if (jj_2_70(2)) {
        tableName = RelObjectNameWithoutStart();
tableAlias = new Alias(tableName, false);
      } else {
        ;
      }
      jj_consume_token(K_AS);
      columnName = RelObjectNameWithoutStart();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
columnAlias = new Alias(columnName, true);
        return new LateralView(
            useOuter
            , generatorFunction
            , tableAlias
            , columnAlias
        );
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ForClause ForClause() throws ParseException {/*@bgen(jjtree) ForClause */
    SimpleNode jjtn000 = new SimpleNode(JJTFORCLAUSE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Token token = null;
    ForClause forClause = new ForClause();
    try {
      jj_consume_token(K_FOR);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_BROWSE:{
        token = jj_consume_token(K_BROWSE);
        break;
        }
      case K_XML:{
        token = jj_consume_token(K_XML);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_AUTO:
        case K_RAW:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_RAW:{
            jj_consume_token(K_RAW);
            if (jj_2_71(2)) {
              jj_consume_token(425);
              jj_consume_token(S_CHAR_LITERAL);
              jj_consume_token(426);
            } else {
              ;
            }
            break;
            }
          case K_AUTO:{
            jj_consume_token(K_AUTO);
            break;
            }
          default:
            jj_la1[130] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          label_21:
          while (true) {
            if (jj_2_72(2)) {
              ;
            } else {
              break label_21;
            }
            jj_consume_token(K_COMMA);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_BINARY:{
              jj_consume_token(K_BINARY);
              jj_consume_token(K_BASE64);
              break;
              }
            case K_TYPE:{
              jj_consume_token(K_TYPE);
              break;
              }
            case K_ROOT:{
              jj_consume_token(K_ROOT);
              if (jj_2_73(2)) {
                jj_consume_token(425);
                jj_consume_token(S_CHAR_LITERAL);
                jj_consume_token(426);
              } else {
                ;
              }
              break;
              }
            case K_XMLDATA:{
              jj_consume_token(K_XMLDATA);
              break;
              }
            case K_XMLSCHEMA:{
              jj_consume_token(K_XMLSCHEMA);
              if (jj_2_74(2)) {
                jj_consume_token(425);
                jj_consume_token(S_CHAR_LITERAL);
                jj_consume_token(426);
              } else {
                ;
              }
              break;
              }
            case K_ELEMENTS:{
              jj_consume_token(K_ELEMENTS);
              if (jj_2_75(2)) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_XSINIL:{
                  jj_consume_token(K_XSINIL);
                  break;
                  }
                case K_ABSENT:{
                  jj_consume_token(K_ABSENT);
                  break;
                  }
                default:
                  jj_la1[131] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              } else {
                ;
              }
              break;
              }
            default:
              jj_la1[132] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
          }
        case K_EXPLICIT:{
          jj_consume_token(K_EXPLICIT);
          label_22:
          while (true) {
            if (jj_2_76(2)) {
              ;
            } else {
              break label_22;
            }
            jj_consume_token(K_COMMA);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_BINARY:{
              jj_consume_token(K_BINARY);
              jj_consume_token(K_BASE64);
              break;
              }
            case K_TYPE:{
              jj_consume_token(K_TYPE);
              break;
              }
            case K_ROOT:{
              jj_consume_token(K_ROOT);
              if (jj_2_77(2)) {
                jj_consume_token(425);
                jj_consume_token(S_CHAR_LITERAL);
                jj_consume_token(426);
              } else {
                ;
              }
              break;
              }
            case K_XMLDATA:{
              jj_consume_token(K_XMLDATA);
              break;
              }
            default:
              jj_la1[133] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
          }
        case K_PATH:{
          jj_consume_token(K_PATH);
          if (jj_2_78(2)) {
            jj_consume_token(425);
            jj_consume_token(S_CHAR_LITERAL);
            jj_consume_token(426);
          } else {
            ;
          }
          label_23:
          while (true) {
            if (jj_2_79(2)) {
              ;
            } else {
              break label_23;
            }
            jj_consume_token(K_COMMA);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_BINARY:{
              jj_consume_token(K_BINARY);
              jj_consume_token(K_BASE64);
              break;
              }
            case K_TYPE:{
              jj_consume_token(K_TYPE);
              break;
              }
            case K_ROOT:{
              jj_consume_token(K_ROOT);
              if (jj_2_80(2)) {
                jj_consume_token(425);
                jj_consume_token(S_CHAR_LITERAL);
                jj_consume_token(426);
              } else {
                ;
              }
              break;
              }
            case K_ELEMENTS:{
              jj_consume_token(K_ELEMENTS);
              if (jj_2_81(2)) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_XSINIL:{
                  jj_consume_token(K_XSINIL);
                  break;
                  }
                case K_ABSENT:{
                  jj_consume_token(K_ABSENT);
                  break;
                  }
                default:
                  jj_la1[134] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              } else {
                ;
              }
              break;
              }
            default:
              jj_la1[135] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
          }
        default:
          jj_la1[136] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_JSON:{
        token = jj_consume_token(K_JSON);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_AUTO:{
          jj_consume_token(K_AUTO);
          break;
          }
        case K_PATH:{
          jj_consume_token(K_PATH);
          break;
          }
        default:
          jj_la1[137] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_24:
        while (true) {
          if (jj_2_82(2)) {
            ;
          } else {
            break label_24;
          }
          jj_consume_token(K_COMMA);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ROOT:{
            jj_consume_token(K_ROOT);
            if (jj_2_83(2)) {
              jj_consume_token(425);
              jj_consume_token(S_CHAR_LITERAL);
              jj_consume_token(426);
            } else {
              ;
            }
            break;
            }
          case K_INCLUDE_NULL_VALUES:{
            jj_consume_token(K_INCLUDE_NULL_VALUES);
            break;
            }
          case K_WITHOUT_ARRAY_WRAPPER:{
            jj_consume_token(K_WITHOUT_ARRAY_WRAPPER);
            break;
            }
          default:
            jj_la1[138] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[139] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
forClause.setForOption(token.image);
        linkAST(forClause,jjtn000);
        return forClause;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public List<LateralView> LateralViews() throws ParseException {ArrayList<LateralView> lateralViews = new ArrayList<LateralView>();
    LateralView lateralView = null;
    lateralView = LateralView();
lateralViews.add(lateralView);
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LATERAL:{
        ;
        break;
        }
      default:
        jj_la1[140] = jj_gen;
        break label_25;
      }
      lateralView = LateralView();
lateralViews.add(lateralView);
    }
return lateralViews;
}

  final public LateralSubSelect LateralSubSelect() throws ParseException {/*@bgen(jjtree) LateralSubSelect */
    SimpleNode jjtn000 = new SimpleNode(JJTLATERALSUBSELECT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));LateralSubSelect lateralSubSelect = new LateralSubSelect();;
    Select select;
    try {
      jj_consume_token(K_LATERAL);
      jj_consume_token(425);
      select = Select();
      jj_consume_token(426);
lateralSubSelect.withSelect(select).setPrefix("LATERAL");
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(lateralSubSelect,jjtn000);
        return lateralSubSelect;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public PlainSelect PlainSelect() throws ParseException {/*@bgen(jjtree) PlainSelect */
    SimpleNode jjtn000 = new SimpleNode(JJTPLAINSELECT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));PlainSelect plainSelect = new PlainSelect();
    List<SelectItem<?>> selectItems = null;
    FromItem fromItem = null;
    List<LateralView> lateralViews = null;
    List<Join> joins = null;
    List<SelectItem<?>> distinctOn = null;
    Expression where = null;
    ForClause forClause = null;
    List<OrderByElement> orderByElements;
    GroupByElement groupBy = null;
    Expression having = null;
    Expression qualify;
    Limit limitBy = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    WithIsolation withIsolation = null;
    OptimizeFor optimize = null;
    Top top = null;
    Skip skip = null;
    First first = null;
    OracleHierarchicalExpression oracleHierarchicalQueryClause = null;
    List<Table> intoTables = null;
    Table updateTable = null;
    Wait wait = null;
    boolean mySqlSqlCalcFoundRows = false;
    Token token;
    KSQLWindow ksqlWindow = null;
    boolean noWait = false;
    String windowName = null;
    WindowDefinition winDef;
    Table intoTempTable = null;
    try {
      jj_consume_token(K_SELECT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_STRAIGHT:{
        jj_consume_token(K_STRAIGHT);
plainSelect.setMySqlHintStraightJoin(true);
        break;
        }
      default:
        jj_la1[141] = jj_gen;
        ;
      }
plainSelect.setOracleHint(getOracleHint());
      if (jj_2_84(2)) {
        skip = Skip();
plainSelect.setSkip(skip);
      } else {
        ;
      }
      if (jj_2_85(2)) {
        first = First();
plainSelect.setFirst(first);
      } else {
        ;
      }
      if (jj_2_86(2)) {
        top = Top();
plainSelect.setTop(top);
      } else {
        ;
      }
      if (jj_2_88(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALL:{
          jj_consume_token(K_ALL);
          break;
          }
        case K_DISTINCT:{
          jj_consume_token(K_DISTINCT);
Distinct distinct = new Distinct(); plainSelect.setDistinct(distinct);
          if (jj_2_87(2)) {
            jj_consume_token(K_ON);
            jj_consume_token(425);
            distinctOn = SelectItemsList();
plainSelect.getDistinct().setOnSelectItems(distinctOn);
            jj_consume_token(426);
          } else {
            ;
          }
          break;
          }
        case K_UNIQUE:{
          jj_consume_token(K_UNIQUE);
Distinct distinct = new Distinct(true); plainSelect.setDistinct(distinct);
          break;
          }
        case K_SQL_CALC_FOUND_ROWS:{
          jj_consume_token(K_SQL_CALC_FOUND_ROWS);
plainSelect.setMySqlSqlCalcFoundRows(true);
          break;
          }
        case K_SQL_NO_CACHE:{
          jj_consume_token(K_SQL_NO_CACHE);
plainSelect.setMySqlSqlCacheFlag(MySqlSqlCacheFlags.SQL_NO_CACHE);
          break;
          }
        case K_SQL_CACHE:{
          jj_consume_token(K_SQL_CACHE);
plainSelect.setMySqlSqlCacheFlag(MySqlSqlCacheFlags.SQL_CACHE);
          break;
          }
        default:
          jj_la1[142] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AS:{
        jj_consume_token(K_AS);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_STRUCT:{
          jj_consume_token(K_STRUCT);
plainSelect.setBigQuerySelectQualifier( PlainSelect.BigQuerySelectQualifier.AS_STRUCT );
          break;
          }
        case K_VALUE:{
          jj_consume_token(K_VALUE);
plainSelect.setBigQuerySelectQualifier( PlainSelect.BigQuerySelectQualifier.AS_VALUE );
          break;
          }
        default:
          jj_la1[143] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[144] = jj_gen;
        ;
      }
      if (jj_2_89(2)) {
        top = Top();
plainSelect.setTop(top);
      } else {
        ;
      }
      selectItems = SelectItemsList();
      if (jj_2_90(2)) {
        intoTables = IntoClause();
plainSelect.setIntoTables(intoTables);
      } else {
        ;
      }
      if (jj_2_92(2)) {
        jj_consume_token(K_FROM);
        fromItem = FromItem();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_LATERAL:{
          lateralViews = LateralViews();
          break;
          }
        default:
          jj_la1[145] = jj_gen;
          ;
        }
        if (jj_2_91(2)) {
          joins = JoinsList();
        } else {
          ;
        }
      } else {
        ;
      }
      if (jj_2_94(3)) {
        jj_consume_token(K_FROM);
        jj_consume_token(K_ONLY);
plainSelect.setUsingOnly(true);
        fromItem = FromItem();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_LATERAL:{
          lateralViews = LateralViews();
          break;
          }
        default:
          jj_la1[146] = jj_gen;
          ;
        }
        if (jj_2_93(2)) {
          joins = JoinsList();
        } else {
          ;
        }
      } else {
        ;
      }
      if (jj_2_95(2)) {
        jj_consume_token(K_FINAL);
plainSelect.setUsingFinal(true);
      } else {
        ;
      }
      if (jj_2_96(2)) {
        ksqlWindow = KSQLWindowClause();
plainSelect.setKsqlWindow(ksqlWindow);
      } else {
        ;
      }
      if (jj_2_97(2)) {
        where = WhereClause();
plainSelect.setWhere(where);
      } else {
        ;
      }
      if (jj_2_98(2)) {
        oracleHierarchicalQueryClause = OracleHierarchicalQueryClause();
plainSelect.setOracleHierarchical(oracleHierarchicalQueryClause);
      } else {
        ;
      }
      if (jj_2_99(2)) {
        having = Having();
plainSelect.setHaving(having);
      } else {
        ;
      }
      if (jj_2_100(2)) {
        groupBy = GroupByColumnReferences();
plainSelect.setGroupByElement(groupBy);
      } else {
        ;
      }
      if (jj_2_101(2)) {
        having = Having();
plainSelect.setHaving(having);
      } else {
        ;
      }
      if (jj_2_102(2)) {
        qualify = Qualify();
plainSelect.setQualify(qualify);
      } else {
        ;
      }
      if (jj_2_103(2)) {
        forClause = ForClause();
plainSelect.setForClause(forClause);
      } else {
        ;
      }
      if (jj_2_104(2147483647)) {
        orderByElements = OrderByElements();
plainSelect.setOracleSiblings(true); plainSelect.setOrderByElements(orderByElements);
      } else {
        ;
      }
      if (jj_2_106(2)) {
        jj_consume_token(K_WINDOW);
        windowName = RelObjectName();
        jj_consume_token(K_AS);
        winDef = windowDefinition();
List<WindowDefinition> winDefs = new ArrayList<WindowDefinition>(); winDefs.add(winDef.withWindowName(windowName));
        label_26:
        while (true) {
          if (jj_2_105(2)) {
            ;
          } else {
            break label_26;
          }
          jj_consume_token(K_COMMA);
          windowName = RelObjectName();
          jj_consume_token(K_AS);
          winDef = windowDefinition();
winDefs.add(winDef.withWindowName(windowName));
        }
plainSelect.setWindowDefinitions(winDefs);
      } else {
        ;
      }
      if (jj_2_107(2147483647)) {
        orderByElements = OrderByElements();
plainSelect.setOrderByElements(orderByElements);
      } else {
        ;
      }
      if (jj_2_108(2)) {
        jj_consume_token(K_EMIT);
        jj_consume_token(K_CHANGES);
plainSelect.setEmitChanges(true);
      } else {
        ;
      }
      if (jj_2_109(2147483647)) {
        limit = LimitBy();
plainSelect.setLimitBy(limit);
      } else {
        ;
      }
      if (jj_2_110(2147483647)) {
        limit = LimitWithOffset();
plainSelect.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_111(2147483647)) {
        offset = Offset();
plainSelect.setOffset(offset);
      } else {
        ;
      }
      if (jj_2_112(2147483647) && (limit==null)) {
        limit = LimitWithOffset();
plainSelect.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_113(2147483647)) {
        fetch = Fetch();
plainSelect.setFetch(fetch);
      } else {
        ;
      }
      if (jj_2_114(2147483647)) {
        withIsolation = WithIsolation();
plainSelect.setIsolation(withIsolation);
      } else {
        ;
      }
      if (jj_2_118(2)) {
        jj_consume_token(K_FOR);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_UPDATE:{
          jj_consume_token(K_UPDATE);
plainSelect.setForMode(ForMode.UPDATE);
          break;
          }
        case K_SHARE:{
          jj_consume_token(K_SHARE);
plainSelect.setForMode(ForMode.SHARE);
          break;
          }
        case K_NO:{
          jj_consume_token(K_NO);
          jj_consume_token(K_KEY);
          jj_consume_token(K_UPDATE);
plainSelect.setForMode(ForMode.NO_KEY_UPDATE);
          break;
          }
        case K_KEY:{
          jj_consume_token(K_KEY);
          jj_consume_token(K_SHARE);
plainSelect.setForMode(ForMode.KEY_SHARE);
          break;
          }
        default:
          jj_la1[147] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        if (jj_2_115(2)) {
          jj_consume_token(K_OF);
          updateTable = Table();
plainSelect.setForUpdateTable(updateTable);
        } else {
          ;
        }
        if (jj_2_116(2147483647)) {
          wait = Wait();
plainSelect.setWait(wait);
        } else {
          ;
        }
        if (jj_2_117(2)) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOWAIT:{
            jj_consume_token(K_NOWAIT);
plainSelect.setNoWait(true);
            break;
            }
          case K_SKIP:{
            jj_consume_token(K_SKIP);
            jj_consume_token(K_LOCKED);
plainSelect.setSkipLocked(true);
            break;
            }
          default:
            jj_la1[148] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        } else {
          ;
        }
      } else {
        ;
      }
      if (jj_2_119(2147483647)) {
        optimize = OptimizeFor();
plainSelect.setOptimizeFor(optimize);
      } else {
        ;
      }
      if (jj_2_120(3)) {
        jj_consume_token(K_INTO);
        jj_consume_token(K_TEMP);
        intoTempTable = Table();
plainSelect.setIntoTempTable(intoTempTable);
      } else {
        ;
      }
      if (jj_2_121(3)) {
        jj_consume_token(K_WITH);
        jj_consume_token(K_NO);
        jj_consume_token(K_LOG);
plainSelect.setUseWithNoLog(true);
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
plainSelect.setSelectItems(selectItems);
        plainSelect.setFromItem(fromItem);
        if ( lateralViews!=null && lateralViews.size()>0 ) {
            plainSelect.setLateralViews( lateralViews );
        }
        if ( joins!=null && joins.size()>0 ) {
            plainSelect.setJoins( joins );
        }
        linkAST(plainSelect,jjtn000);
        return plainSelect;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Select SetOperationList(Select select) throws ParseException {/*@bgen(jjtree) SetOperationList */
    SimpleNode jjtn000 = new SimpleNode(JJTSETOPERATIONLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SetOperationList list = new SetOperationList();
    List<OrderByElement> orderByElements = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    WithIsolation withIsolation = null;
    List<Select> selects = new ArrayList<Select>();
    List<SetOperation> operations = new ArrayList<SetOperation>();
    try {
selects.add(select);
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_UNION:{
          jj_consume_token(K_UNION);
UnionOp union = new UnionOp(); linkAST(union,jjtn000); operations.add(union);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALL:
          case K_DISTINCT:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ALL:{
              jj_consume_token(K_ALL);
union.setAll(true);
              break;
              }
            case K_DISTINCT:{
              jj_consume_token(K_DISTINCT);
union.setDistinct(true);
              break;
              }
            default:
              jj_la1[149] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[150] = jj_gen;
            ;
          }
          break;
          }
        case K_INTERSECT:{
          jj_consume_token(K_INTERSECT);
operations.add(new IntersectOp());
          break;
          }
        case K_MINUS:{
          jj_consume_token(K_MINUS);
operations.add(new MinusOp());
          break;
          }
        case K_EXCEPT:{
          jj_consume_token(K_EXCEPT);
operations.add(new ExceptOp());
          break;
          }
        default:
          jj_la1[151] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:{
          select = PlainSelect();
          break;
          }
        case K_VALUE:
        case K_VALUES:{
          select = Values();
          break;
          }
        case 425:{
          select = ParenthesedSelect();
          break;
          }
        default:
          jj_la1[152] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
selects.add(select);
        if (jj_2_122(2)) {
          ;
        } else {
          break label_27;
        }
      }
      if (jj_2_123(2)) {
        orderByElements = OrderByElements();
list.setOrderByElements(orderByElements);
      } else {
        ;
      }
      if (jj_2_124(2147483647)) {
        limit = LimitWithOffset();
list.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_125(2147483647)) {
        offset = Offset();
list.setOffset(offset);
      } else {
        ;
      }
      if (jj_2_126(2147483647) && (limit==null)) {
        limit = LimitWithOffset();
list.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_127(2147483647)) {
        fetch = Fetch();
list.setFetch(fetch);
      } else {
        ;
      }
      if (jj_2_128(2147483647)) {
        withIsolation = WithIsolation();
list.setIsolation(withIsolation);
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
if ( selects.get(selects.size()-1) instanceof PlainSelect ) {
            PlainSelect ps = (PlainSelect)selects.get(selects.size()-1);
            if (ps.getOrderByElements() != null) {
                list.setOrderByElements(ps.getOrderByElements());
                list.setLimit(ps.getLimit());
                list.setOffset(ps.getOffset());
                ps.setOrderByElements(null);
                ps.setLimit(null);
                ps.setOffset(null);
            }
            if (ps.getFetch() != null) {
                list.setFetch(ps.getFetch());
                ps.setFetch(null);
            }
            if (ps.getIsolation() != null) {
                list.setIsolation(ps.getIsolation());
                ps.setIsolation(null);
            }
        }
        list.setBracketsOpsAndSelects(selects,operations);
        return list;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public List<WithItem> WithList() throws ParseException {List<WithItem> withItemsList = new ArrayList<WithItem>();
    WithItem with = null;
    jj_consume_token(K_WITH);
    with = WithItem();
withItemsList.add(with);
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[153] = jj_gen;
        break label_28;
      }
      jj_consume_token(K_COMMA);
      with = WithItem();
withItemsList.add(with);
    }
return withItemsList;
}

  final public WithItem WithItem() throws ParseException {/*@bgen(jjtree) WithItem */
    SimpleNode jjtn000 = new SimpleNode(JJTWITHITEM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));WithItem withItem = new WithItem();
    String name;
    List<SelectItem<?>> selectItems;
    Select select;
    try {
      if (jj_2_129(2)) {
        jj_consume_token(K_RECURSIVE);
withItem.setRecursive(true);
      } else {
        ;
      }
      name = RelObjectName();
withItem.setAlias( new Alias( name, false));
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 425:{
        jj_consume_token(425);
        selectItems = SelectItemsList();
        jj_consume_token(426);
withItem.setWithItemList(selectItems);
        break;
        }
      default:
        jj_la1[154] = jj_gen;
        ;
      }
      jj_consume_token(K_AS);
      select = ParenthesedSelect();
withItem.setSelect(select);
jjtree.closeNodeScope(jjtn000, true);
       jjtc000 = false;
       jjtn000.jjtSetLastToken(getToken(0));
return withItem;
    } catch (Throwable jjte000) {
if (jjtc000) {
         jjtree.clearNodeScope(jjtn000);
         jjtc000 = false;
       } else {
         jjtree.popNode();
       }
       if (jjte000 instanceof RuntimeException) {
         {if (true) throw (RuntimeException)jjte000;}
       }
       if (jjte000 instanceof ParseException) {
         {if (true) throw (ParseException)jjte000;}
       }
       {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
         jjtree.closeNodeScope(jjtn000, true);
         jjtn000.jjtSetLastToken(getToken(0));
       }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public List<SelectItem<Column>> ColumnSelectItemsList() throws ParseException {List<SelectItem<Column>> selectItemsList = null;
    SelectItem selectItem = null;
    selectItem = SelectItem();
selectItemsList = new ArrayList<SelectItem<Column>>(); selectItemsList.add(selectItem);
    label_29:
    while (true) {
      if (jj_2_130(2)) {
        ;
      } else {
        break label_29;
      }
      jj_consume_token(K_COMMA);
      selectItem = SelectItem();
selectItemsList.add(selectItem);
    }
return selectItemsList;
}

  final public List<SelectItem<?>> SelectItemsList() throws ParseException {List<SelectItem<?>> selectItemsList = null;
    SelectItem selectItem = null;
    selectItem = SelectItem();
selectItemsList = new ArrayList<SelectItem<?>>(); selectItemsList.add(selectItem);
    label_30:
    while (true) {
      if (jj_2_131(2)) {
        ;
      } else {
        break label_30;
      }
      jj_consume_token(K_COMMA);
      selectItem = SelectItem();
selectItemsList.add(selectItem);
    }
return selectItemsList;
}

  final public SelectItem<?> SelectItem() throws ParseException {/*@bgen(jjtree) SelectItem */
    SimpleNode jjtn000 = new SimpleNode(JJTSELECTITEM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression expression;
    Alias alias = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 437:{
        expression = AllColumns();
        break;
        }
      default:
        jj_la1[155] = jj_gen;
        if (jj_2_132(2147483647)) {
          expression = AllTableColumns();
        } else if (jj_2_133(3)) {
          expression = XorExpression();
        } else if (jj_2_134(3)) {
          expression = ConcatExpression();
        } else if (jj_2_135(1)) {
          expression = Expression();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      if (jj_2_136(2)) {
        alias = Alias();
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
SelectItem<?> selectItem = new SelectItem(expression, alias);
        linkAST(selectItem,jjtn000);
        return selectItem;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public AllColumns AllColumns() throws ParseException {ParenthesedExpressionList<Column> exceptColumns = null;
    List<SelectItem<Column>> replaceExpressions = null;
    String exceptKeyword=null;
    Token tk;
    jj_consume_token(437);
    if (jj_2_137(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_EXCEPT:{
        tk = jj_consume_token(K_EXCEPT);
        break;
        }
      case K_EXCLUDE:{
        tk = jj_consume_token(K_EXCLUDE);
        break;
        }
      default:
        jj_la1[156] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      exceptColumns = ParenthesedColumnList();
exceptKeyword=tk.image;
    } else {
      ;
    }
    if (jj_2_138(2)) {
      jj_consume_token(K_REPLACE);
      jj_consume_token(425);
      replaceExpressions = ColumnSelectItemsList();
      jj_consume_token(426);
    } else {
      ;
    }
return new AllColumns(exceptColumns, replaceExpressions, exceptKeyword);
}

  final public AllTableColumns AllTableColumns() throws ParseException {Table table = null;
    AllColumns allColumns;
    table = Table();
    jj_consume_token(428);
    allColumns = AllColumns();
return new AllTableColumns(table, allColumns);
}

  final public Alias Alias() throws ParseException {String name = "";
  Token token = null;
  boolean useAs = false;
  Alias alias;
  String colname;
  ColDataType colDataType = null;
    if (jj_2_141(3)) {
      jj_consume_token(K_AS);
      if (jj_2_139(2)) {
        name = RelObjectNameWithoutStart();
      } else {
        ;
      }
alias = new Alias(name, true );
      jj_consume_token(425);
List<Alias.AliasColumn> list = new ArrayList<Alias.AliasColumn>();
      colname = RelObjectName();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_BINARY:
      case K_BIT:
      case K_BYTES:
      case K_CHARACTER:
      case K_CHAR:
      case K_DATA:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_INTERVAL:
      case K_JSON:
      case K_PUBLIC:
      case K_SET:
      case K_STRING:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_XML:
      case DT_ZONE:
      case DATA_TYPE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        colDataType = ColDataType();
        break;
        }
      default:
        jj_la1[157] = jj_gen;
        ;
      }
list.add(new Alias.AliasColumn(colname, colDataType));
      label_31:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[158] = jj_gen;
          break label_31;
        }
        jj_consume_token(K_COMMA);
colDataType=null;
        colname = RelObjectName();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ARRAY_LITERAL:
        case K_BINARY:
        case K_BIT:
        case K_BYTES:
        case K_CHARACTER:
        case K_CHAR:
        case K_DATA:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_INTERVAL:
        case K_JSON:
        case K_PUBLIC:
        case K_SET:
        case K_STRING:
        case K_SIGNED:
        case K_UNSIGNED:
        case K_XML:
        case DT_ZONE:
        case DATA_TYPE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          colDataType = ColDataType();
          break;
          }
        default:
          jj_la1[159] = jj_gen;
          ;
        }
list.add(new Alias.AliasColumn(colname, colDataType));
      }
      jj_consume_token(426);
alias.setAliasColumns(list);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALTER:
      case K_ANALYZE:
      case K_APPLY:
      case K_APPROXIMATE:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AS:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BASE64:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONSTRAINTS:
      case K_CONVERT:
      case K_COSTS:
      case K_CYCLE:
      case K_DATABASE:
      case K_DATA:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GRANT:
      case K_GUARD:
      case K_HASH:
      case K_HISTORY:
      case K_HOPPING:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_INTERVAL:
      case K_INVALIDATE:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_LOOP:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAX:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MIN:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_OPEN:
      case K_OVER:
      case K_OVERLAPS:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PURGE:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_RECURSIVE:
      case K_REFERENCES:
      case K_REFRESH:
      case K_REGEXP:
      case K_RESPECT:
      case K_RLIKE:
      case K_REGISTER:
      case K_REMOTE:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_RETURN:
      case K_ROLLBACK:
      case K_ROLLUP:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SECURE:
      case K_SEED:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SHARE:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_STORED:
      case K_STRING:
      case K_STRUCT:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VERBOSE:
      case K_VIEW:
      case K_VOLATILE:
      case K_CONCURRENTLY:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case DATA_TYPE:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 429:
      case 430:
      case 431:
      case 432:
      case 433:
      case 434:
      case 435:
      case 436:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_AS:{
          jj_consume_token(K_AS);
useAs = true;
          break;
          }
        default:
          jj_la1[160] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ACTIVE:
        case K_ADD:
        case K_ADVANCE:
        case K_ADVISE:
        case K_AGAINST:
        case K_ALGORITHM:
        case K_ALTER:
        case K_ANALYZE:
        case K_APPLY:
        case K_APPROXIMATE:
        case K_ARCHIVE:
        case K_ARRAY_LITERAL:
        case K_AT:
        case K_ASC:
        case K_AUTHORIZATION:
        case K_AUTO:
        case K_BASE64:
        case K_BEGIN:
        case K_BERNOULLI:
        case K_BINARY:
        case K_BIT:
        case K_BLOCK:
        case K_BROWSE:
        case K_BY:
        case K_BYTES:
        case K_CACHE:
        case K_BUFFERS:
        case K_BYTE:
        case K_CALL:
        case K_CASCADE:
        case K_CASE:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHANGES:
        case K_CHECKPOINT:
        case K_CHAR:
        case K_CLOSE:
        case K_COLLATE:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CONFLICT:
        case K_CONSTRAINTS:
        case K_CONVERT:
        case K_COSTS:
        case K_CYCLE:
        case K_DATABASE:
        case K_DATA:
        case K_DECLARE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DEFAULT:
        case K_DEFERRABLE:
        case K_DELAYED:
        case K_DELETE:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DISCONNECT:
        case K_DIV:
        case K_DDL:
        case K_DML:
        case K_DO:
        case K_DOMAIN:
        case K_DROP:
        case K_DUMP:
        case K_DUPLICATE:
        case K_ELEMENTS:
        case K_EMIT:
        case K_ENABLE:
        case K_END:
        case K_ESCAPE:
        case K_EXCLUDE:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_EXPLICIT:
        case K_EXTENDED:
        case K_EXTRACT:
        case K_ISOLATION:
        case K_FILTER:
        case K_FIRST:
        case K_FALSE:
        case K_FLUSH:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_FULLTEXT:
        case K_FUNCTION:
        case K_GRANT:
        case K_GUARD:
        case K_HASH:
        case K_HISTORY:
        case K_HOPPING:
        case K_INCLUDE:
        case K_INCREMENT:
        case K_INDEX:
        case K_INSERT:
        case K_INTERLEAVE:
        case K_INTERPRET:
        case K_INTERVAL:
        case K_INVALIDATE:
        case K_ISNULL:
        case K_JSON:
        case K_KEEP:
        case K_KEY:
        case K_KEYS:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LOCAL:
        case K_LOCKED:
        case K_LINK:
        case K_LOG:
        case K_LOOP:
        case K_MATCH:
        case K_MATCHED:
        case K_MATERIALIZED:
        case K_MAX:
        case K_MAXVALUE:
        case K_MEMBER:
        case K_MERGE:
        case K_MIN:
        case K_MINVALUE:
        case K_MODIFY:
        case K_MOVEMENT:
        case K_NEXT:
        case K_NO:
        case K_NOCACHE:
        case K_NOKEEP:
        case K_NOLOCK:
        case K_NOMAXVALUE:
        case K_NOMINVALUE:
        case K_NOORDER:
        case K_NOTHING:
        case K_NOTNULL:
        case K_NOVALIDATE:
        case K_NULLS:
        case K_NOWAIT:
        case K_OF:
        case K_OFF:
        case K_OPEN:
        case K_OVER:
        case K_OVERLAPS:
        case K_PARALLEL:
        case K_PARENT:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PLACING:
        case K_PRECEDING:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PURGE:
        case K_QUERY:
        case K_QUICK:
        case K_QUIESCE:
        case K_RANGE:
        case K_RAW:
        case K_READ:
        case K_RECYCLEBIN:
        case K_RECURSIVE:
        case K_REFERENCES:
        case K_REFRESH:
        case K_REGEXP:
        case K_RESPECT:
        case K_RLIKE:
        case K_REGISTER:
        case K_REMOTE:
        case K_RENAME:
        case K_REPEATABLE:
        case K_REPLACE:
        case K_RESET:
        case K_RESTART:
        case K_RESUMABLE:
        case K_RESUME:
        case K_RESTRICT:
        case K_RESTRICTED:
        case K_RETURN:
        case K_ROLLBACK:
        case K_ROLLUP:
        case K_ROOT:
        case K_ROW:
        case K_ROWS:
        case K_SAVEPOINT:
        case K_SCHEMA:
        case K_SECURE:
        case K_SEED:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SETS:
        case K_SHOW:
        case K_SHUTDOWN:
        case K_SHARE:
        case K_SIBLINGS:
        case K_SIMILAR:
        case K_SIZE:
        case K_SKIP:
        case K_STORED:
        case K_STRING:
        case K_STRUCT:
        case K_SUSPEND:
        case K_SWITCH:
        case K_SYNONYM:
        case K_SYSTEM:
        case K_TABLE:
        case K_TABLESPACE:
        case K_TRIGGER:
        case K_THEN:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TUMBLING:
        case K_TYPE:
        case K_UNLOGGED:
        case K_UPDATE:
        case K_UPSERT:
        case K_UNQIESCE:
        case K_USER:
        case K_SIGNED:
        case K_STRING_FUNCTION_NAME:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VERBOSE:
        case K_VIEW:
        case K_VOLATILE:
        case K_CONCURRENTLY:
        case K_WAIT:
        case K_WITHIN:
        case K_WITHOUT:
        case K_WORK:
        case K_XML:
        case K_XMLAGG:
        case K_XMLDATA:
        case K_XMLSCHEMA:
        case K_XMLTEXT:
        case K_XSINIL:
        case K_YAML:
        case K_YES:
        case K_ZONE:
        case DATA_TYPE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:
        case 429:
        case 430:
        case 431:
        case 432:
        case 433:
        case 434:
        case 435:
        case 436:{
          name = RelObjectNameWithoutStart();
          break;
          }
        case S_CHAR_LITERAL:{
          token = jj_consume_token(S_CHAR_LITERAL);
name=token.image;
          break;
          }
        default:
          jj_la1[161] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alias = new Alias(name,useAs);
        if (jj_2_140(2)) {
          jj_consume_token(425);
List<Alias.AliasColumn> list = new ArrayList<Alias.AliasColumn>();
          colname = RelObjectName();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ARRAY_LITERAL:
          case K_BINARY:
          case K_BIT:
          case K_BYTES:
          case K_CHARACTER:
          case K_CHAR:
          case K_DATA:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_INTERVAL:
          case K_JSON:
          case K_PUBLIC:
          case K_SET:
          case K_STRING:
          case K_SIGNED:
          case K_UNSIGNED:
          case K_XML:
          case DT_ZONE:
          case DATA_TYPE:
          case S_IDENTIFIER:
          case S_QUOTED_IDENTIFIER:{
            colDataType = ColDataType();
            break;
            }
          default:
            jj_la1[162] = jj_gen;
            ;
          }
list.add(new Alias.AliasColumn(colname, colDataType));
          label_32:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[163] = jj_gen;
              break label_32;
            }
            jj_consume_token(K_COMMA);
colDataType=null;
            colname = RelObjectName();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ARRAY_LITERAL:
            case K_BINARY:
            case K_BIT:
            case K_BYTES:
            case K_CHARACTER:
            case K_CHAR:
            case K_DATA:
            case K_DATETIMELITERAL:
            case K_DATE_LITERAL:
            case K_INTERVAL:
            case K_JSON:
            case K_PUBLIC:
            case K_SET:
            case K_STRING:
            case K_SIGNED:
            case K_UNSIGNED:
            case K_XML:
            case DT_ZONE:
            case DATA_TYPE:
            case S_IDENTIFIER:
            case S_QUOTED_IDENTIFIER:{
              colDataType = ColDataType();
              break;
              }
            default:
              jj_la1[164] = jj_gen;
              ;
            }
list.add(new Alias.AliasColumn(colname, colDataType));
          }
          jj_consume_token(426);
alias.setAliasColumns(list);
        } else {
          ;
        }
        break;
        }
      default:
        jj_la1[165] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return alias;
}

  final public void SQLServerHint(SQLServerHints hints) throws ParseException {String str;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INDEX:{
      jj_consume_token(K_INDEX);
      jj_consume_token(425);
      str = RelObjectName();
      jj_consume_token(426);
hints.setIndexName(str);
      break;
      }
    case K_NOLOCK:{
      jj_consume_token(K_NOLOCK);
hints.withNoLock();
      break;
      }
    default:
      jj_la1[166] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public SQLServerHints SQLServerHints() throws ParseException {SQLServerHints hints = new SQLServerHints();
    jj_consume_token(K_WITH);
    jj_consume_token(425);
    SQLServerHint(hints);
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[167] = jj_gen;
        break label_33;
      }
      jj_consume_token(K_COMMA);
      SQLServerHint(hints);
    }
    jj_consume_token(426);
return hints;
}

  final public MySQLIndexHint MySQLIndexHint() throws ParseException {Token actionToken = null;
        Token indexToken = null;
        String indexName = null;
        List<String> indexNameList = new ArrayList<String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_USE:{
      actionToken = jj_consume_token(K_USE);
      break;
      }
    case K_SHOW:{
      actionToken = jj_consume_token(K_SHOW);
      break;
      }
    case K_IGNORE:{
      actionToken = jj_consume_token(K_IGNORE);
      break;
      }
    case K_FORCE:{
      actionToken = jj_consume_token(K_FORCE);
      break;
      }
    default:
      jj_la1[168] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INDEX:{
      indexToken = jj_consume_token(K_INDEX);
      break;
      }
    case K_KEY:{
      indexToken = jj_consume_token(K_KEY);
      break;
      }
    default:
      jj_la1[169] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(425);
    indexName = RelObjectNameWithoutValue();
indexNameList.add(indexName);
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[170] = jj_gen;
        break label_34;
      }
      jj_consume_token(K_COMMA);
      indexName = RelObjectNameWithoutValue();
indexNameList.add(indexName);
    }
    jj_consume_token(426);
return new MySQLIndexHint(actionToken.image, indexToken.image, indexNameList);
}

  final public SelectItem<Function> FunctionItem() throws ParseException {Alias alias = null;
    Function function;
    function = Function();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALTER:
    case K_ANALYZE:
    case K_APPLY:
    case K_APPROXIMATE:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BASE64:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONSTRAINTS:
    case K_CONVERT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATABASE:
    case K_DATA:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GRANT:
    case K_GUARD:
    case K_HASH:
    case K_HISTORY:
    case K_HOPPING:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_INVALIDATE:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_LOOP:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAX:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MIN:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_OPEN:
    case K_OVER:
    case K_OVERLAPS:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PURGE:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_RECURSIVE:
    case K_REFERENCES:
    case K_REFRESH:
    case K_REGEXP:
    case K_RESPECT:
    case K_RLIKE:
    case K_REGISTER:
    case K_REMOTE:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_RETURN:
    case K_ROLLBACK:
    case K_ROLLUP:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SECURE:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SHARE:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_STORED:
    case K_STRING:
    case K_STRUCT:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_VOLATILE:
    case K_CONCURRENTLY:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case DATA_TYPE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 429:
    case 430:
    case 431:
    case 432:
    case 433:
    case 434:
    case 435:
    case 436:{
      alias = Alias();
      break;
      }
    default:
      jj_la1[171] = jj_gen;
      ;
    }
return new SelectItem<Function>(function, alias);
}

  final public ExpressionList<Column> PivotForColumns() throws ParseException {ExpressionList<Column> columns;
    Column column;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 425:{
      columns = ParenthesedColumnList();
      break;
      }
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALL:
    case K_ALTER:
    case K_ANALYZE:
    case K_ANY:
    case K_APPLY:
    case K_APPROXIMATE:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BASE64:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CASEWHEN:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONNECT:
    case K_CONSTRAINTS:
    case K_CONVERT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATABASE:
    case K_DATA:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GLOBAL:
    case K_GRANT:
    case K_GROUP:
    case K_GROUPING:
    case K_GUARD:
    case K_HASH:
    case K_HISTORY:
    case K_HOPPING:
    case K_IF:
    case K_IIF:
    case K_IGNORE:
    case K_IN:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_INVALIDATE:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LEFT:
    case K_LIMIT:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_LOOP:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAX:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MIN:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NEXTVAL:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OVERLAPS:
    case K_OPTIMIZE:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_PURGE:
    case K_QUALIFY:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_RECURSIVE:
    case K_REFERENCES:
    case K_REFRESH:
    case K_REGEXP:
    case K_RESPECT:
    case K_RLIKE:
    case K_REGISTER:
    case K_REMOTE:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_RETURN:
    case K_RIGHT:
    case K_ROLLBACK:
    case K_ROLLUP:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SECURE:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SHARE:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_SOME:
    case K_START:
    case K_STORED:
    case K_STRING:
    case K_STRUCT:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_VOLATILE:
    case K_CONCURRENTLY:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case DATA_TYPE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 429:
    case 430:
    case 431:
    case 432:
    case 433:
    case 434:
    case 435:
    case 436:{
      column = Column();
columns = new ExpressionList<Column>(column);
      break;
      }
    default:
      jj_la1[172] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return columns;
}

  final public List<SelectItem<Function>> PivotFunctionItems() throws ParseException {List<SelectItem<Function>> functionItems = new ArrayList<SelectItem<Function>>();
    SelectItem<Function> item;
    item = FunctionItem();
functionItems.add(item);
    label_35:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[173] = jj_gen;
        break label_35;
      }
      jj_consume_token(K_COMMA);
      item = FunctionItem();
functionItems.add(item);
    }
return functionItems;
}

  final public SelectItem<ExpressionList<?>> ExpressionListItem() throws ParseException {ExpressionList expressionList;
    Alias alias = null;
    expressionList = ParenthesedExpressionList();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALTER:
    case K_ANALYZE:
    case K_APPLY:
    case K_APPROXIMATE:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BASE64:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONSTRAINTS:
    case K_CONVERT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATABASE:
    case K_DATA:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GRANT:
    case K_GUARD:
    case K_HASH:
    case K_HISTORY:
    case K_HOPPING:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_INVALIDATE:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_LOOP:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAX:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MIN:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_OPEN:
    case K_OVER:
    case K_OVERLAPS:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PURGE:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_RECURSIVE:
    case K_REFERENCES:
    case K_REFRESH:
    case K_REGEXP:
    case K_RESPECT:
    case K_RLIKE:
    case K_REGISTER:
    case K_REMOTE:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_RETURN:
    case K_ROLLBACK:
    case K_ROLLUP:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SECURE:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SHARE:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_STORED:
    case K_STRING:
    case K_STRUCT:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_VOLATILE:
    case K_CONCURRENTLY:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case DATA_TYPE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 429:
    case 430:
    case 431:
    case 432:
    case 433:
    case 434:
    case 435:
    case 436:{
      alias = Alias();
      break;
      }
    default:
      jj_la1[174] = jj_gen;
      ;
    }
return new SelectItem<ExpressionList<?>>(expressionList, alias);
}

  final public List<SelectItem<ExpressionList<?>>> PivotMultiInItems() throws ParseException {List<SelectItem<ExpressionList<?>>> retval = new ArrayList<SelectItem<ExpressionList<?>>>();
   SelectItem<ExpressionList<?>> item;
    item = ExpressionListItem();
retval.add(item);
    label_36:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[175] = jj_gen;
        break label_36;
      }
      jj_consume_token(K_COMMA);
      item = ExpressionListItem();
retval.add(item);
    }
return retval;
}

  final public Pivot Pivot() throws ParseException {Pivot retval = new Pivot();
    List<SelectItem<Function>> functionItems;
    ExpressionList<Column> forColumns;
    List<SelectItem<?>> singleInItems = null;
    List<SelectItem<ExpressionList<?>>> multiInItems = null;
    Alias alias = null;
    jj_consume_token(K_PIVOT);
    jj_consume_token(425);
    functionItems = PivotFunctionItems();
    jj_consume_token(K_FOR);
    forColumns = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(425);
    if (jj_2_142(3)) {
      singleInItems = SelectItemsList();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 425:{
        multiInItems = PivotMultiInItems();
        break;
        }
      default:
        jj_la1[176] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(426);
    jj_consume_token(426);
    if (jj_2_143(2)) {
      alias = Alias();
    } else {
      ;
    }
retval.setFunctionItems(functionItems);
        retval.setForColumns(forColumns);
        retval.setSingleInItems(singleInItems);
        retval.setMultiInItems(multiInItems);
        retval.setAlias(alias);
        return retval;
}

  final public PivotXml PivotXml() throws ParseException {PivotXml retval = new PivotXml();
    List<SelectItem<Function>> functionItems;
    ExpressionList<Column> forColumns;
    List<SelectItem<?>> singleInItems = null;
    List<SelectItem<ExpressionList<?>>> multiInItems = null;
    Select inSelect = null;
    jj_consume_token(K_PIVOT);
    jj_consume_token(K_XML);
    jj_consume_token(425);
    functionItems = PivotFunctionItems();
    jj_consume_token(K_FOR);
    forColumns = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(425);
    if (jj_2_144(2)) {
      jj_consume_token(K_ANY);
retval.setInAny(true);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case K_VALUE:
      case K_VALUES:
      case K_WITH:
      case 425:{
        inSelect = Select();
        break;
        }
      default:
        jj_la1[177] = jj_gen;
        if (jj_2_145(2)) {
          singleInItems = SelectItemsList();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 425:{
            multiInItems = PivotMultiInItems();
            break;
            }
          default:
            jj_la1[178] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    jj_consume_token(426);
    jj_consume_token(426);
retval.setFunctionItems(functionItems);
        retval.setForColumns(forColumns);
        retval.setSingleInItems(singleInItems);
        retval.setMultiInItems(multiInItems);
        retval.setInSelect(inSelect);
        return retval;
}

  final public UnPivot UnPivot() throws ParseException {UnPivot retval = new UnPivot();
    ExpressionList<Column> unpivotClause;
    ExpressionList<Column> unpivotForClause;
    List<SelectItem<?>> unpivotInClause;
    Alias alias = null;
    jj_consume_token(K_UNPIVOT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXCLUDE:
    case K_INCLUDE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_INCLUDE:{
        jj_consume_token(K_INCLUDE);
        jj_consume_token(K_NULLS);
retval.setIncludeNulls(true);
        break;
        }
      case K_EXCLUDE:{
        jj_consume_token(K_EXCLUDE);
        jj_consume_token(K_NULLS);
retval.setIncludeNulls(false);
        break;
        }
      default:
        jj_la1[179] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[180] = jj_gen;
      ;
    }
    jj_consume_token(425);
    unpivotClause = PivotForColumns();
    jj_consume_token(K_FOR);
    unpivotForClause = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(425);
    unpivotInClause = SelectItemsList();
    jj_consume_token(426);
    jj_consume_token(426);
    if (jj_2_146(2)) {
      alias = Alias();
    } else {
      ;
    }
retval.setUnPivotClause(unpivotClause);
        retval.setUnPivotForClause(unpivotForClause);
        retval.setUnPivotInClause(unpivotInClause);
        retval.setAlias(alias);
        return retval;
}

  final public List<Table> IntoClause() throws ParseException {List<Table> tables = new ArrayList<Table>();
    Table table;
    jj_consume_token(K_INTO);
    table = Table();
tables.add(table);
    label_37:
    while (true) {
      if (jj_2_147(2)) {
        ;
      } else {
        break label_37;
      }
      jj_consume_token(K_COMMA);
      table = Table();
tables.add(table);
    }
return tables;
}

  final public FromItem ParenthesedFromItem() throws ParseException {ParenthesedFromItem ParenthesedFromItem = new ParenthesedFromItem();
    FromItem fromItem;
    List<Join> joins = null;
    jj_consume_token(425);
    fromItem = FromItem();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_APPLY:
    case K_COMMA:
    case K_CROSS:
    case K_FULL:
    case K_GLOBAL:
    case K_HASH:
    case K_INNER:
    case K_STRAIGHT:
    case K_JOIN:
    case K_LEFT:
    case K_LOOP:
    case K_MERGE:
    case K_NATURAL:
    case K_OUTER:
    case K_REMOTE:
    case K_RIGHT:{
      joins = JoinsList();
      break;
      }
    default:
      jj_la1[181] = jj_gen;
      ;
    }
    jj_consume_token(426);
return ParenthesedFromItem.withFromItem(fromItem).withJoins(joins);
}

  final public FromItem FromItem() throws ParseException {/*@bgen(jjtree) FromItem */
    SimpleNode jjtn000 = new SimpleNode(JJTFROMITEM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));FromItem fromItem = null;
    FromItem fromItem2 = null;
    SampleClause sampleClause;
    Pivot pivot = null;
    UnPivot unpivot = null;
    Alias alias = null;
    MySQLIndexHint indexHint = null;
    SQLServerHints sqlServerHints = null;
    Select select;
    try {
      if (jj_2_150(3)) {
        fromItem = Values();
      } else if (jj_2_151(2147483647)) {
        fromItem = TableFunction();
      } else if (jj_2_152(3)) {
        fromItem = Table();
      } else if (jj_2_153(2147483647)) {
        fromItem = ParenthesedFromItem();
      } else if (jj_2_154(3)) {
        fromItem = ParenthesedSelect();
        if (jj_2_148(2)) {
          pivot = Pivot();
fromItem.setPivot(pivot);
        } else {
          ;
        }
        if (jj_2_149(2)) {
          unpivot = UnPivot();
fromItem.setUnPivot(unpivot);
        } else {
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_LATERAL:{
          fromItem = LateralSubSelect();
          break;
          }
        default:
          jj_la1[182] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      if (jj_2_155(2)) {
        alias = Alias();
fromItem.setAlias(alias);
      } else {
        ;
      }
      if (jj_2_156(2)) {
        sampleClause = SampleClause();
((Table) fromItem).setSampleClause(sampleClause);
      } else {
        ;
      }
      if (jj_2_157(2)) {
        unpivot = UnPivot();
fromItem.setUnPivot(unpivot);
      } else {
        ;
      }
      if (jj_2_159(2)) {
        if (jj_2_158(2)) {
          pivot = PivotXml();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_PIVOT:{
            pivot = Pivot();
            break;
            }
          default:
            jj_la1[183] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
fromItem.setPivot(pivot);
      } else {
        ;
      }
      if (jj_2_160(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_FORCE:
        case K_IGNORE:
        case K_SHOW:
        case K_USE:{
          indexHint = MySQLIndexHint();
if (fromItem instanceof Table)
                    ((Table) fromItem).setHint(indexHint);
          break;
          }
        case K_WITH:{
          sqlServerHints = SQLServerHints();
if (fromItem instanceof Table)
                    ((Table) fromItem).setSqlServerHints(sqlServerHints);
          break;
          }
        default:
          jj_la1[184] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(fromItem,jjtn000);
        return fromItem;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public List<Join> JoinsList() throws ParseException {List<Join> joinsList = new ArrayList<Join>();
    Join join = null;
    label_38:
    while (true) {
      join = JoinerExpression();
joinsList.add(join);
      if (jj_2_161(2)) {
        ;
      } else {
        break label_38;
      }
    }
return joinsList;
}

  final public JoinHint JoinHint() throws ParseException {Token token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LOOP:{
      token = jj_consume_token(K_LOOP);
      break;
      }
    case K_HASH:{
      token = jj_consume_token(K_HASH);
      break;
      }
    case K_MERGE:{
      token = jj_consume_token(K_MERGE);
      break;
      }
    case K_REMOTE:{
      token = jj_consume_token(K_REMOTE);
      break;
      }
    default:
      jj_la1[185] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return new JoinHint(token.image);
}

  final public Join JoinerExpression() throws ParseException {/*@bgen(jjtree) JoinerExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTJOINEREXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Join join = new Join();
    FromItem right = null;
    Expression onExpression = null;
    Column tableColumn;
    List<Column> columns = null;
    KSQLJoinWindow joinWindow = null;
    JoinHint joinHint = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_GLOBAL:{
        jj_consume_token(K_GLOBAL);
join.setGlobal(true);
        break;
        }
      default:
        jj_la1[186] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NATURAL:{
        jj_consume_token(K_NATURAL);
join.setNatural(true);
        break;
        }
      default:
        jj_la1[187] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CROSS:
      case K_FULL:
      case K_INNER:
      case K_LEFT:
      case K_OUTER:
      case K_RIGHT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_FULL:
        case K_INNER:
        case K_LEFT:
        case K_RIGHT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_LEFT:{
            jj_consume_token(K_LEFT);
join.setLeft(true);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_OUTER:
            case K_SEMI:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_SEMI:{
                jj_consume_token(K_SEMI);
join.setSemi(true);
                break;
                }
              case K_OUTER:{
                jj_consume_token(K_OUTER);
join.setOuter(true);
                break;
                }
              default:
                jj_la1[188] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
              }
            default:
              jj_la1[189] = jj_gen;
              ;
            }
            break;
            }
          case K_FULL:
          case K_RIGHT:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_RIGHT:{
              jj_consume_token(K_RIGHT);
join.setRight(true);
              break;
              }
            case K_FULL:{
              jj_consume_token(K_FULL);
join.setFull(true);
              break;
              }
            default:
              jj_la1[190] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_OUTER:{
              jj_consume_token(K_OUTER);
join.setOuter(true);
              break;
              }
            default:
              jj_la1[191] = jj_gen;
              ;
            }
            break;
            }
          case K_INNER:{
            jj_consume_token(K_INNER);
join.setInner(true);
            break;
            }
          default:
            jj_la1[192] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        case K_CROSS:{
          jj_consume_token(K_CROSS);
join.setCross(true);
          break;
          }
        case K_OUTER:{
          jj_consume_token(K_OUTER);
join.setOuter(true);
          break;
          }
        default:
          jj_la1[193] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[194] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_HASH:
      case K_JOIN:
      case K_LOOP:
      case K_MERGE:
      case K_REMOTE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_HASH:
        case K_LOOP:
        case K_MERGE:
        case K_REMOTE:{
          joinHint = JoinHint();
join.setJoinHint(joinHint);
          break;
          }
        default:
          jj_la1[195] = jj_gen;
          ;
        }
        jj_consume_token(K_JOIN);
        break;
        }
      case K_COMMA:{
        jj_consume_token(K_COMMA);
join.setSimple(true);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_OUTER:{
          jj_consume_token(K_OUTER);
join.setOuter(true);
          break;
          }
        default:
          jj_la1[196] = jj_gen;
          ;
        }
        break;
        }
      case K_STRAIGHT:{
        jj_consume_token(K_STRAIGHT);
join.setStraight(true);
        break;
        }
      case K_APPLY:{
        jj_consume_token(K_APPLY);
join.setApply(true);
        break;
        }
      default:
        jj_la1[197] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = FromItem();
      if (jj_2_163(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ON:
        case K_WITHIN:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_WITHIN:{
            jj_consume_token(K_WITHIN);
            jj_consume_token(425);
            joinWindow = JoinWindow();
            jj_consume_token(426);
join.setJoinWindow(joinWindow);
            break;
            }
          default:
            jj_la1[198] = jj_gen;
            ;
          }
          jj_consume_token(K_ON);
          onExpression = Expression();
join.addOnExpression(onExpression);
          label_39:
          while (true) {
            if (jj_2_162(2)) {
              ;
            } else {
              break label_39;
            }
            jj_consume_token(K_ON);
            onExpression = Expression();
join.addOnExpression(onExpression);
          }
          break;
          }
        case K_USING:{
          jj_consume_token(K_USING);
          jj_consume_token(425);
          tableColumn = Column();
columns = new ArrayList<Column>(); columns.add(tableColumn);
          label_40:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[199] = jj_gen;
              break label_40;
            }
            jj_consume_token(K_COMMA);
            tableColumn = Column();
columns.add(tableColumn);
          }
          jj_consume_token(426);
join.setUsingColumns(columns);
          break;
          }
        default:
          jj_la1[200] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(join,jjtn000);
        join.setFromItem(right);
        return join;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public KSQLJoinWindow JoinWindow() throws ParseException {KSQLJoinWindow retval = new KSQLJoinWindow();
    boolean beforeAfter;
    Token beforeDurationToken = null;
    Token beforeTimeUnitToken = null;
    Token afterDurationToken = null;
    Token afterTimeUnitToken = null;
    beforeDurationToken = jj_consume_token(S_LONG);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      beforeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case K_DATE_LITERAL:{
      beforeTimeUnitToken = jj_consume_token(K_DATE_LITERAL);
      break;
      }
    default:
      jj_la1[201] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_COMMA:{
      jj_consume_token(K_COMMA);
      afterDurationToken = jj_consume_token(S_LONG);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        afterTimeUnitToken = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_DATE_LITERAL:{
        afterTimeUnitToken = jj_consume_token(K_DATE_LITERAL);
        break;
        }
      default:
        jj_la1[202] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[203] = jj_gen;
      ;
    }
if (afterDurationToken == null) {
            retval.setDuration(Long.parseLong(beforeDurationToken.image));
            retval.setTimeUnit(KSQLWindow.TimeUnit.from(beforeTimeUnitToken.image));
            retval.setBeforeAfterWindow(false);
            return retval;
        }
        retval.setBeforeDuration(Long.parseLong(beforeDurationToken.image));
        retval.setBeforeTimeUnit(KSQLWindow.TimeUnit.from(beforeTimeUnitToken.image));
        retval.setAfterDuration(Long.parseLong(afterDurationToken.image));
        retval.setAfterTimeUnit(KSQLWindow.TimeUnit.from(afterTimeUnitToken.image));
        retval.setBeforeAfterWindow(true);
        return retval;
}

  final public KSQLWindow KSQLWindowClause() throws ParseException {KSQLWindow retval = null;
    Token sizeDurationToken = null;
    Token sizeTimeUnitToken = null;
    Token advanceDurationToken = null;
    Token advanceTimeUnitToken = null;
    jj_consume_token(K_WINDOW);
retval=new KSQLWindow();
        retval.setHoppingWindow(false);
        retval.setSessionWindow(false);
        retval.setTumblingWindow(false);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_HOPPING:{
      jj_consume_token(K_HOPPING);
      jj_consume_token(425);
      jj_consume_token(K_SIZE);
      sizeDurationToken = jj_consume_token(S_LONG);
      sizeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(K_COMMA);
      jj_consume_token(K_ADVANCE);
      jj_consume_token(K_BY);
      advanceDurationToken = jj_consume_token(S_LONG);
      advanceTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(426);
retval.setHoppingWindow(true);
      break;
      }
    case K_SESSION:{
      jj_consume_token(K_SESSION);
      jj_consume_token(425);
      sizeDurationToken = jj_consume_token(S_LONG);
      sizeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(426);
retval.setSessionWindow(true);
      break;
      }
    case K_TUMBLING:{
      jj_consume_token(K_TUMBLING);
      jj_consume_token(425);
      jj_consume_token(K_SIZE);
      sizeDurationToken = jj_consume_token(S_LONG);
      sizeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(426);
retval.setTumblingWindow(true);
      break;
      }
    default:
      jj_la1[204] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
retval.setSizeDuration(Long.parseLong(sizeDurationToken.image));
            retval.setSizeTimeUnit(KSQLWindow.TimeUnit.from(sizeTimeUnitToken.image));
            if (advanceDurationToken != null) {
                retval.setAdvanceDuration(Long.parseLong(advanceDurationToken.image));
                retval.setAdvanceTimeUnit(KSQLWindow.TimeUnit.from(advanceTimeUnitToken.image));
            }
            return retval;
}

  final public Expression WhereClause() throws ParseException {Expression retval = null;
    jj_consume_token(K_WHERE);
    retval = Expression();
return retval;
}

  final public OracleHierarchicalExpression OracleHierarchicalQueryClause() throws ParseException {OracleHierarchicalExpression result = new OracleHierarchicalExpression();
    Expression expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_START:{
      jj_consume_token(K_START);
      jj_consume_token(K_WITH);
      expr = AndExpression();
result.setStartExpression(expr);
      jj_consume_token(K_CONNECT);
      jj_consume_token(K_BY);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOCYCLE:{
        jj_consume_token(K_NOCYCLE);
result.setNoCycle(true);
        break;
        }
      default:
        jj_la1[205] = jj_gen;
        ;
      }
      expr = AndExpression();
result.setConnectExpression(expr);
      break;
      }
    case K_CONNECT:{
      jj_consume_token(K_CONNECT);
      jj_consume_token(K_BY);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOCYCLE:{
        jj_consume_token(K_NOCYCLE);
result.setNoCycle(true);
        break;
        }
      default:
        jj_la1[206] = jj_gen;
        ;
      }
      expr = AndExpression();
result.setConnectExpression(expr);
                result.setConnectFirst(true);
      if (jj_2_164(2)) {
        jj_consume_token(K_START);
        jj_consume_token(K_WITH);
        expr = AndExpression();
result.setStartExpression(expr);
      } else {
        ;
      }
      break;
      }
    default:
      jj_la1[207] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return result;
}

  final public GroupByElement GroupByColumnReferences() throws ParseException {Expression columnReference;
    GroupByElement groupBy = new GroupByElement();
    Expression expr;
    ExpressionList list;
    Token token;
    jj_consume_token(K_GROUP);
    jj_consume_token(K_BY);
    if (jj_2_169(2)) {
      jj_consume_token(K_GROUPING);
      jj_consume_token(K_SETS);
      jj_consume_token(425);
      list = GroupingSet();
groupBy.addGroupingSet(list);
      label_41:
      while (true) {
        if (jj_2_165(2)) {
          ;
        } else {
          break label_41;
        }
        jj_consume_token(K_COMMA);
        list = GroupingSet();
groupBy.addGroupingSet(list);
      }
      jj_consume_token(426);
    } else if (jj_2_170(1)) {
      list = ExpressionList();
groupBy.setGroupByExpressions(list);
      if (jj_2_167(2)) {
        jj_consume_token(K_GROUPING);
        jj_consume_token(K_SETS);
        jj_consume_token(425);
        list = GroupingSet();
groupBy.addGroupingSet(list);
        label_42:
        while (true) {
          if (jj_2_166(2)) {
            ;
          } else {
            break label_42;
          }
          jj_consume_token(K_COMMA);
          list = GroupingSet();
groupBy.addGroupingSet(list);
        }
        jj_consume_token(426);
      } else {
        ;
      }
      if (jj_2_168(2)) {
        jj_consume_token(K_WITH);
        jj_consume_token(K_ROLLUP);
groupBy.setMysqlWithRollup(true);
      } else {
        ;
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
return groupBy;
}

  final public ExpressionList GroupingSet() throws ParseException {ExpressionList list;
    Expression expression;
    if (jj_2_171(2)) {
      list = ParenthesedExpressionList();
    } else if (jj_2_172(1)) {
      expression = SimpleExpression();
list = new ExpressionList(expression);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
return list;
}

  final public Expression Having() throws ParseException {Expression having = null;
    jj_consume_token(K_HAVING);
    having = Expression();
return having;
}

  final public Expression Qualify() throws ParseException {Expression qualify = null;
    jj_consume_token(K_QUALIFY);
    qualify = Expression();
return qualify;
}

  final public List<OrderByElement> OrderByElements() throws ParseException {List<OrderByElement> orderByList = new ArrayList<OrderByElement>();
    OrderByElement orderByElement = null;
    jj_consume_token(K_ORDER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SIBLINGS:{
      jj_consume_token(K_SIBLINGS);
      break;
      }
    default:
      jj_la1[208] = jj_gen;
      ;
    }
    jj_consume_token(K_BY);
    orderByElement = OrderByElement();
orderByList.add(orderByElement);
    label_43:
    while (true) {
      if (jj_2_173(2)) {
        ;
      } else {
        break label_43;
      }
      jj_consume_token(K_COMMA);
      orderByElement = OrderByElement();
orderByList.add(orderByElement);
    }
return orderByList;
}

  final public OrderByElement OrderByElement() throws ParseException {OrderByElement orderByElement = new OrderByElement();
    Expression columnReference = null;
    columnReference = Expression();
    if (jj_2_174(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ASC:{
        jj_consume_token(K_ASC);
        break;
        }
      case K_DESC:{
        jj_consume_token(K_DESC);
orderByElement.setAsc(false);
        break;
        }
      default:
        jj_la1[209] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
orderByElement.setAscDescPresent(true);
    } else {
      ;
    }
    if (jj_2_176(2)) {
      jj_consume_token(K_NULLS);
      if (jj_2_175(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_FIRST:{
          jj_consume_token(K_FIRST);
orderByElement.setNullOrdering(OrderByElement.NullOrdering.NULLS_FIRST);
          break;
          }
        case K_LAST:{
          jj_consume_token(K_LAST);
orderByElement.setNullOrdering(OrderByElement.NullOrdering.NULLS_LAST);
          break;
          }
        default:
          jj_la1[210] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
    } else {
      ;
    }
    if (jj_2_177(2)) {
      jj_consume_token(K_WITH);
      jj_consume_token(K_ROLLUP);
orderByElement.setMysqlWithRollup(true);
    } else {
      ;
    }
orderByElement.setExpression(columnReference);
        return orderByElement;
}

  final public JdbcParameter JdbcParameter() throws ParseException {Token tk;
    JdbcParameter retval;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 438:{
      tk = jj_consume_token(438);
      break;
      }
    case S_PARAMETER:{
      tk = jj_consume_token(S_PARAMETER);
      break;
      }
    default:
      jj_la1[211] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
retval = new JdbcParameter(++jdbcParameterIndex, false, tk.image);
    if (jj_2_178(2)) {
      token = jj_consume_token(S_LONG);
retval.setUseFixedIndex(true); retval.setIndex(Integer.valueOf(token.image));
    } else {
      ;
    }
return retval;
}

  final public Limit LimitWithOffset() throws ParseException {/*@bgen(jjtree) LimitWithOffset */
    SimpleNode jjtn000 = new SimpleNode(JJTLIMITWITHOFFSET);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Limit limit = new Limit();
    Expression rowCountExpression;
    Expression offsetExpression;
    try {
      if (jj_2_179(2147483647)) {
        jj_consume_token(K_LIMIT);
        offsetExpression = Expression();
limit.setOffset( offsetExpression );
        jj_consume_token(K_COMMA);
        rowCountExpression = Expression();
limit.setRowCount( rowCountExpression );
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_LIMIT:{
          limit = PlainLimit();
          break;
          }
        default:
          jj_la1[212] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(limit,jjtn000);
        return limit;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Limit PlainLimit() throws ParseException {/*@bgen(jjtree) PlainLimit */
    SimpleNode jjtn000 = new SimpleNode(JJTPLAINLIMIT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Limit limit = new Limit();
    Expression rowCountExpression;
    try {
      jj_consume_token(K_LIMIT);
      if (jj_2_180(3)) {
        rowCountExpression = ParenthesedSelect();
      } else if (jj_2_181(1)) {
        rowCountExpression = Expression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
limit.setRowCount(rowCountExpression);
        linkAST(limit,jjtn000);
        return limit;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

/**
 * Clickhouse LIMIT BY
 * @see <a href='https://clickhouse.com/docs/en/sql-reference/statements/select'>SELECT Query</a>
 */
  final public Limit LimitBy() throws ParseException {Limit limit;
    ExpressionList byExpressions;
    limit = LimitWithOffset();
    jj_consume_token(K_BY);
    byExpressions = ExpressionList();
limit.setByExpressions(byExpressions);
        return limit;
}

  final public Offset Offset() throws ParseException {Offset offset = new Offset();
    Expression offsetExpression;
    jj_consume_token(K_OFFSET);
    offsetExpression = Expression();
offset.setOffset( offsetExpression );
    if (jj_2_182(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ROWS:{
        jj_consume_token(K_ROWS);
offset.setOffsetParam("ROWS");
        break;
        }
      case K_ROW:{
        jj_consume_token(K_ROW);
offset.setOffsetParam("ROW");
        break;
        }
      default:
        jj_la1[213] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
return offset;
}

  final public Fetch Fetch() throws ParseException {Fetch fetch = new Fetch();
    Token token = null;
    Expression expression;
    List<String> fetchParameters = new ArrayList<String>();
    if (jj_2_183(3)) {
      jj_consume_token(K_FETCH);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FIRST:{
        jj_consume_token(K_FIRST);
fetch.setFetchParamFirst(true);
        break;
        }
      case K_NEXT:{
        jj_consume_token(K_NEXT);
        break;
        }
      default:
        jj_la1[214] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ROWS:{
        jj_consume_token(K_ROWS);
fetch.addFetchParameter("ROWS");
        break;
        }
      case K_ROW:{
        jj_consume_token(K_ROW);
fetch.addFetchParameter("ROW");
        break;
        }
      default:
        jj_la1[215] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ONLY:{
        jj_consume_token(K_ONLY);
fetch.addFetchParameter("ONLY");
        break;
        }
      case K_WITH_TIES:{
        jj_consume_token(K_WITH_TIES);
fetch.addFetchParameter("WITH TIES");
        break;
        }
      default:
        jj_la1[216] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FETCH:{
        jj_consume_token(K_FETCH);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_FIRST:{
          jj_consume_token(K_FIRST);
fetch.setFetchParamFirst(true);
          break;
          }
        case K_NEXT:{
          jj_consume_token(K_NEXT);
          break;
          }
        default:
          jj_la1[217] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        // Expression is optional according to https://www.h2database.com/html/commands.html#select
                    expression = Expression();
fetch.setExpression(expression);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_PERCENT:{
          jj_consume_token(K_PERCENT);
fetch.addFetchParameter("PERCENT");
          break;
          }
        default:
          jj_la1[218] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ROWS:{
          jj_consume_token(K_ROWS);
fetch.addFetchParameter("ROWS");
          break;
          }
        case K_ROW:{
          jj_consume_token(K_ROW);
fetch.addFetchParameter("ROW");
          break;
          }
        default:
          jj_la1[219] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ONLY:{
          jj_consume_token(K_ONLY);
fetch.addFetchParameter("ONLY");
          break;
          }
        case K_WITH_TIES:{
          jj_consume_token(K_WITH_TIES);
fetch.addFetchParameter("WITH TIES");
          break;
          }
        default:
          jj_la1[220] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[221] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return fetch;
}

  final public WithIsolation WithIsolation() throws ParseException {WithIsolation withIsolation = new WithIsolation();
    Token token = null;
    JdbcParameter jdbc;
    jj_consume_token(K_WITH);
    token = jj_consume_token(K_ISOLATION);
withIsolation.setIsolation(token.image);
return withIsolation;
}

  final public OptimizeFor OptimizeFor() throws ParseException {Token token;
    LongValue value;
    jj_consume_token(K_OPTIMIZE);
    jj_consume_token(K_FOR);
    token = jj_consume_token(S_LONG);
    jj_consume_token(K_ROWS);
value = new LongValue(token.image);
        return new OptimizeFor(value.getValue());
}

// according to http://technet.microsoft.com/en-us/library/ms189463.aspx
  final public Top Top() throws ParseException {/*@bgen(jjtree) Top */
    SimpleNode jjtn000 = new SimpleNode(JJTTOP);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Top top = new Top();
    Token token = null;
    Expression expr = null;
    JdbcParameter jdbc = null;
    try {
      jj_consume_token(K_TOP);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_LONG:{
        token = jj_consume_token(S_LONG);
top.setExpression(new LongValue(token.image));
        break;
        }
      case S_PARAMETER:
      case 438:{
        jdbc = JdbcParameter();
top.setExpression(jdbc);
        break;
        }
      case DOUBLE_COLON:{
        jj_consume_token(DOUBLE_COLON);
top.setExpression(new JdbcNamedParameter());
        if (jj_2_184(2)) {
          token = jj_consume_token(S_IDENTIFIER);
((JdbcNamedParameter)top.getExpression()).setName(token.image);
        } else {
          ;
        }
        break;
        }
      case 425:{
        jj_consume_token(425);
        expr = AdditiveExpression();
top.setExpression(expr);
            top.setParenthesis(true);
        jj_consume_token(426);
        break;
        }
      default:
        jj_la1[222] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_185(2)) {
        jj_consume_token(K_PERCENT);
top.setPercentage(true);
      } else {
        ;
      }
      if (jj_2_186(2)) {
        jj_consume_token(K_WITH_TIES);
top.setWithTies(true);
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(top,jjtn000);
        return top;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

// according to http://www-01.ibm.com/support/knowledgecenter/SSGU8G_12.1.0/com.ibm.sqls.doc/ids_sqs_0156.htm
  final public Skip Skip() throws ParseException {Skip skip = new Skip();
    Token token = null;
    JdbcParameter jdbc;
    jj_consume_token(K_SKIP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
skip.setRowCount(Long.parseLong(token.image));
      break;
      }
    case S_IDENTIFIER:{
      token = jj_consume_token(S_IDENTIFIER);
skip.setVariable(token.image);
      break;
      }
    case S_PARAMETER:
    case 438:{
      jdbc = JdbcParameter();
skip.setJdbcParameter(jdbc);
      break;
      }
    default:
      jj_la1[223] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return skip;
}

  OracleHint getOracleHint() throws ParseException {OracleHint hint = null;
  Token tok = getToken(1);
  // Retrieve first comment (if any) prior next token
  if (tok.specialToken != null) {
    tok = tok.specialToken;
    while (tok.specialToken != null) tok = tok.specialToken;
    // Check if it matches Hint pattern?
    if (OracleHint.isHintMatch(tok.image)) {
      hint = new OracleHint();
      hint.setComment(tok.image);
    }
  }
  return hint;
  }

  final public First First() throws ParseException {First first = new First();
    Token token = null;
    JdbcParameter jdbc;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
first.setKeyword(First.Keyword.FIRST);
      break;
      }
    case K_LIMIT:{
      jj_consume_token(K_LIMIT);
first.setKeyword(First.Keyword.LIMIT);
      break;
      }
    default:
      jj_la1[224] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
first.setRowCount(Long.parseLong(token.image));
      break;
      }
    case S_IDENTIFIER:{
      token = jj_consume_token(S_IDENTIFIER);
first.setVariable(token.image);
      break;
      }
    case S_PARAMETER:
    case 438:{
      jdbc = JdbcParameter();
first.setJdbcParameter(jdbc);
      break;
      }
    default:
      jj_la1[225] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return first;
}

  final public Expression Expression() throws ParseException {/*@bgen(jjtree) Expression */
    SimpleNode jjtn000 = new SimpleNode(JJTEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression retval = null;
    try {
      retval = XorExpression();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression XorExpression() throws ParseException {Expression left, right, result;
    left = OrExpression();
result = left;
    label_44:
    while (true) {
      if (jj_2_187(2)) {
        ;
      } else {
        break label_44;
      }
      jj_consume_token(K_XOR);
      right = OrExpression();
result = new XorExpression(left, right);
            left = result;
    }
return result;
}

  final public Expression OrExpression() throws ParseException {Expression left, right, result;
    left = AndExpression();
result = left;
    label_45:
    while (true) {
      if (jj_2_188(2)) {
        ;
      } else {
        break label_45;
      }
      jj_consume_token(K_OR);
      right = AndExpression();
result = new OrExpression(left, right);
            left = result;
    }
return result;
}

  final public Expression AndExpression() throws ParseException {Expression left, right, result;
    boolean not = false;
        boolean exclamationMarkNot=false;
    if (jj_2_189(2147483647) && (!interrupted)) {
      left = Condition();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:
      case 425:
      case 439:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:
        case 439:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOT:{
            jj_consume_token(K_NOT);
not=true;
            break;
            }
          case 439:{
            jj_consume_token(439);
not=true; exclamationMarkNot=true;
            break;
            }
          default:
            jj_la1[226] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[227] = jj_gen;
          ;
        }
        jj_consume_token(425);
        left = XorExpression();
        jj_consume_token(426);
left = new ParenthesedExpressionList(left); if (not) { left = new NotExpression(left, exclamationMarkNot); not = false; }
        break;
        }
      default:
        jj_la1[228] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
result = left;
    label_46:
    while (true) {
      if (jj_2_190(2)) {
        ;
      } else {
        break label_46;
      }
boolean useOperator = false;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AND:{
        jj_consume_token(K_AND);
        break;
        }
      case OP_DOUBLEAND:{
        jj_consume_token(OP_DOUBLEAND);
useOperator=true;
        break;
        }
      default:
        jj_la1[229] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_191(2147483647) && (!interrupted)) {
        right = Condition();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:
        case 425:
        case 439:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOT:
          case 439:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_NOT:{
              jj_consume_token(K_NOT);
not=true;
              break;
              }
            case 439:{
              jj_consume_token(439);
not=true; exclamationMarkNot=true;
              break;
              }
            default:
              jj_la1[230] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[231] = jj_gen;
            ;
          }
          jj_consume_token(425);
          right = XorExpression();
          jj_consume_token(426);
right = new ParenthesedExpressionList(right); if (not) { right = new NotExpression(right, exclamationMarkNot); not = false; }
          break;
          }
        default:
          jj_la1[232] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
result = new AndExpression(left, right);
            ((AndExpression)result).setUseOperator(useOperator);
            left = result;
    }
return result;
}

  final public Expression Condition() throws ParseException {Expression result;
    Token token;
    boolean not = false;
        boolean exclamationMarkNot = false;
    if (jj_2_192(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
not=true;
        break;
        }
      case 439:{
        jj_consume_token(439);
not=true; exclamationMarkNot=true;
        break;
        }
      default:
        jj_la1[233] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    if (jj_2_193(2147483647)) {
      result = RegularCondition();
    } else if (jj_2_194(1)) {
      result = SQLCondition();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
return not?new NotExpression(result, exclamationMarkNot):result;
}

  final public Expression OverlapsCondition() throws ParseException {ExpressionList left = new ExpressionList();
    ExpressionList right = new ExpressionList();
    //As per the sql2003 standard, we need at least two items in the list if there is not explicit ROW prefix
        //More than two expression are allowed per the sql2003 grammar.
        left = ParenthesedExpressionList();
    jj_consume_token(K_OVERLAPS);
    right = ParenthesedExpressionList();
return new OverlapsCondition(left, right);
}

  final public Expression RegularCondition() throws ParseException {/*@bgen(jjtree) RegularCondition */
    SimpleNode jjtn000 = new SimpleNode(JJTREGULARCONDITION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression result = null;
    Expression leftExpression;
    Expression rightExpression;
    int oracleJoin=EqualsTo.NO_ORACLE_JOIN;
    int oraclePrior=EqualsTo.NO_ORACLE_PRIOR;
    boolean binary = false;
    boolean not = false;
    try {
      if (jj_2_195(2)) {
        jj_consume_token(K_PRIOR);
oraclePrior = EqualsTo.ORACLE_PRIOR_START;
      } else {
        ;
      }
      leftExpression = ComparisonItem();
result = leftExpression;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 425:{
        jj_consume_token(425);
        jj_consume_token(440);
        jj_consume_token(426);
oracleJoin=EqualsTo.ORACLE_JOIN_RIGHT;
        break;
        }
      default:
        jj_la1[234] = jj_gen;
        ;
      }
      if (jj_2_196(2)) {
        jj_consume_token(441);
result = new GreaterThan();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 442:{
          jj_consume_token(442);
result = new MinorThan();
          break;
          }
        case 427:{
          jj_consume_token(427);
result = new EqualsTo();
          break;
          }
        case OP_GREATERTHANEQUALS:{
          token = jj_consume_token(OP_GREATERTHANEQUALS);
result = new GreaterThanEquals(token.image);
          break;
          }
        case OP_MINORTHANEQUALS:{
          token = jj_consume_token(OP_MINORTHANEQUALS);
result = new MinorThanEquals(token.image);
          break;
          }
        case OP_NOTEQUALSSTANDARD:{
          token = jj_consume_token(OP_NOTEQUALSSTANDARD);
result = new NotEqualsTo(token.image);
          break;
          }
        case OP_NOTEQUALSBANG:{
          token = jj_consume_token(OP_NOTEQUALSBANG);
result = new NotEqualsTo(token.image);
          break;
          }
        case 443:{
          jj_consume_token(443);
result = new TSQLLeftJoin();
          break;
          }
        case 444:{
          jj_consume_token(444);
result = new TSQLRightJoin();
          break;
          }
        case OP_DOUBLEAND:{
          token = jj_consume_token(OP_DOUBLEAND);
result = new DoubleAnd();
          break;
          }
        case OP_CONTAINS:{
          token = jj_consume_token(OP_CONTAINS);
result = new Contains();
          break;
          }
        case OP_CONTAINEDBY:{
          token = jj_consume_token(OP_CONTAINEDBY);
result = new ContainedBy();
          break;
          }
        case 445:{
          jj_consume_token(445);
result = new Matches();
          break;
          }
        case 446:{
          jj_consume_token(446);
result = new RegExpMatchOperator(RegExpMatchOperatorType.MATCH_CASESENSITIVE);
          break;
          }
        case 447:{
          jj_consume_token(447);
result = new RegExpMatchOperator(RegExpMatchOperatorType.MATCH_CASEINSENSITIVE);
          break;
          }
        case 448:{
          jj_consume_token(448);
result = new RegExpMatchOperator(RegExpMatchOperatorType.NOT_MATCH_CASESENSITIVE);
          break;
          }
        case 449:{
          jj_consume_token(449);
result = new RegExpMatchOperator(RegExpMatchOperatorType.NOT_MATCH_CASEINSENSITIVE);
          break;
          }
        case 450:{
          jj_consume_token(450);
result = new JsonOperator("@>");
          break;
          }
        case 451:{
          jj_consume_token(451);
result = new JsonOperator("<@");
          break;
          }
        case 438:{
          jj_consume_token(438);
result = new JsonOperator("?");
          break;
          }
        case 452:{
          jj_consume_token(452);
result = new JsonOperator("?|");
          break;
          }
        case 453:{
          jj_consume_token(453);
result = new JsonOperator("?&");
          break;
          }
        case OP_CONCAT:{
          jj_consume_token(OP_CONCAT);
result = new JsonOperator("||");
          break;
          }
        case 454:{
          jj_consume_token(454);
result = new JsonOperator("-");
          break;
          }
        case 455:{
          jj_consume_token(455);
result = new JsonOperator("-#");
          break;
          }
        case 456:{
          jj_consume_token(456);
result = new GeometryDistance("<->");
          break;
          }
        case 457:{
          jj_consume_token(457);
result = new GeometryDistance("<#>");
          break;
          }
        default:
          jj_la1[235] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      if (jj_2_197(2)) {
        jj_consume_token(K_PRIOR);
        rightExpression = ComparisonItem();
oraclePrior = EqualsTo.ORACLE_PRIOR_END;
      } else if (jj_2_198(1)) {
        rightExpression = ComparisonItem();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_199(2)) {
        jj_consume_token(425);
        jj_consume_token(440);
        jj_consume_token(426);
oracleJoin=EqualsTo.ORACLE_JOIN_LEFT;
      } else {
        ;
      }
BinaryExpression regCond = (BinaryExpression) result;
        regCond.setLeftExpression(leftExpression);
        regCond.setRightExpression(rightExpression);

        if (oracleJoin>0)
            ((SupportsOldOracleJoinSyntax)result).setOldOracleJoinSyntax(oracleJoin);

        if (oraclePrior!=EqualsTo.NO_ORACLE_PRIOR)
            ((SupportsOldOracleJoinSyntax)result).setOraclePriorPosition(oraclePrior);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression SQLCondition() throws ParseException {Expression result;
    Expression left;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXISTS:{
      result = ExistsExpression();
      break;
      }
    default:
      jj_la1[238] = jj_gen;
      if (jj_2_208(2147483647) && (!interrupted)) {
        result = InExpression();
      } else if (jj_2_209(2147483647) && (!interrupted)) {
        result = OverlapsCondition();
      } else if (jj_2_210(1)) {
        left = SimpleExpression();
result = left;
        if (jj_2_207(2)) {
          if (jj_2_200(2147483647)) {
            result = ExcludesExpression(left);
          } else if (jj_2_201(2147483647)) {
            result = IncludesExpression(left);
          } else if (jj_2_202(2)) {
            result = Between(left);
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_MEMBER:{
              result = MemberOfExpression(left);
              break;
              }
            default:
              jj_la1[236] = jj_gen;
              if (jj_2_203(2147483647)) {
                result = IsNullExpression(left);
              } else if (jj_2_204(2147483647)) {
                result = IsBooleanExpression(left);
              } else if (jj_2_205(2)) {
                result = LikeExpression(left);
              } else if (jj_2_206(2147483647)) {
                result = IsDistinctExpression(left);
              } else {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_NOT:
                case K_SIMILAR:{
                  result = SimilarToExpression(left);
                  break;
                  }
                default:
                  jj_la1[237] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        } else {
          ;
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return result;
}

  final public Expression InExpression() throws ParseException {/*@bgen(jjtree) InExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTINEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Token token;
    int oldOracleJoin = 0;
    boolean usingNot = false;
    boolean usingGlobal = false;
    Expression leftExpression;
    Expression rightExpression;
    try {
      leftExpression = SimpleExpression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 425:{
        jj_consume_token(425);
        jj_consume_token(440);
        jj_consume_token(426);
oldOracleJoin=EqualsTo.ORACLE_JOIN_RIGHT;
        break;
        }
      default:
        jj_la1[239] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_GLOBAL:{
        jj_consume_token(K_GLOBAL);
usingGlobal=true;
        break;
        }
      default:
        jj_la1[240] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
usingNot=true;
        break;
        }
      default:
        jj_la1[241] = jj_gen;
        ;
      }
      jj_consume_token(K_IN);
      if (jj_2_211(2)) {
        token = jj_consume_token(S_CHAR_LITERAL);
rightExpression = new StringValue(token.image);
      } else if (jj_2_212(3)) {
        rightExpression = Function();
      } else if (jj_2_213(2147483647) && (!interrupted)) {
        rightExpression = ParenthesedSelect();
      } else if (jj_2_214(3)) {
        rightExpression = ParenthesedExpressionList();
      } else if (jj_2_215(1)) {
        rightExpression = SimpleExpression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
InExpression inExpression =  new InExpression(leftExpression, rightExpression)
                                                .withOldOracleJoinSyntax(oldOracleJoin)
                                                .withNot(usingNot)
                                                .setGlobal(usingGlobal);
        linkAST(inExpression,jjtn000);
        return inExpression;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression IncludesExpression(Expression leftExpression) throws ParseException {/*@bgen(jjtree) IncludesExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTINCLUDESEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Token token;
    Expression rightExpression;
    try {
      jj_consume_token(K_INCLUDES);
      rightExpression = ParenthesedExpressionList();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
IncludesExpression includesExpression =  new IncludesExpression(leftExpression, rightExpression);

        linkAST(includesExpression,jjtn000);
        return includesExpression;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression ExcludesExpression(Expression leftExpression) throws ParseException {/*@bgen(jjtree) ExcludesExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTEXCLUDESEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Token token;
    Expression rightExpression;
    try {
      jj_consume_token(K_EXCLUDES);
      rightExpression = ParenthesedExpressionList();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
ExcludesExpression excludesExpression =  new ExcludesExpression(leftExpression, rightExpression);

        linkAST(excludesExpression,jjtn000);
        return excludesExpression;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression Between(Expression leftExpression) throws ParseException {Between result = new Between();
    Expression betweenExpressionStart = null;
    Expression betweenExpressionEnd = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      break;
      }
    default:
      jj_la1[242] = jj_gen;
      ;
    }
    jj_consume_token(K_BETWEEN);
    if (jj_2_216(3)) {
      betweenExpressionStart = ParenthesedSelect();
    } else if (jj_2_217(2147483647)) {
      betweenExpressionStart = RegularCondition();
    } else if (jj_2_218(1)) {
      betweenExpressionStart = SimpleExpression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_AND);
    if (jj_2_219(3)) {
      betweenExpressionEnd = ParenthesedSelect();
    } else if (jj_2_220(2147483647)) {
      betweenExpressionEnd = RegularCondition();
    } else if (jj_2_221(1)) {
      betweenExpressionEnd = SimpleExpression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
result.setLeftExpression(leftExpression);
        result.setBetweenExpressionStart(betweenExpressionStart);
        result.setBetweenExpressionEnd(betweenExpressionEnd);
        return result;
}

  final public Expression LikeExpression(Expression leftExpression) throws ParseException {/*@bgen(jjtree) LikeExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTLIKEEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));LikeExpression result = new LikeExpression();
    Expression rightExpression = null;
    Expression escape;
    Token token;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[243] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LIKE:{
        token = jj_consume_token(K_LIKE);
        break;
        }
      case K_ILIKE:{
        token = jj_consume_token(K_ILIKE);
        break;
        }
      case K_RLIKE:{
        token = jj_consume_token(K_RLIKE);
        break;
        }
      case K_REGEXP:{
        token = jj_consume_token(K_REGEXP);
        break;
        }
      case K_SIMILAR_TO:{
        token = jj_consume_token(K_SIMILAR_TO);
        break;
        }
      default:
        jj_la1[244] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
result.setLikeKeyWord( LikeExpression.KeyWord.from(token.image));
      if (jj_2_222(2)) {
        jj_consume_token(K_BINARY);
result.setUseBinary(true);
      } else {
        ;
      }
      rightExpression = SimpleExpression();
      if (jj_2_225(2)) {
        jj_consume_token(K_ESCAPE);
        if (jj_2_223(2)) {
          token = jj_consume_token(S_CHAR_LITERAL);
result.setEscape( new StringValue( token.image ) );
        } else if (jj_2_224(1)) {
          escape = Expression();
result.setEscape(escape);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
result.setLeftExpression(leftExpression);
        result.setRightExpression(rightExpression);
        linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression SimilarToExpression(Expression leftExpression) throws ParseException {/*@bgen(jjtree) SimilarToExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTSIMILARTOEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SimilarToExpression result = new SimilarToExpression();
    Expression rightExpression = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[245] = jj_gen;
        ;
      }
      jj_consume_token(K_SIMILAR);
      jj_consume_token(K_TO);
      rightExpression = SimpleExpression();
      if (jj_2_226(2)) {
        jj_consume_token(K_ESCAPE);
        token = jj_consume_token(S_CHAR_LITERAL);
result.setEscape((new StringValue(token.image)).getValue());
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
result.setLeftExpression(leftExpression);
        result.setRightExpression(rightExpression);
        linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression IsDistinctExpression(Expression leftExpression) throws ParseException {/*@bgen(jjtree) IsDistinctExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTISDISTINCTEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));IsDistinctExpression result = new IsDistinctExpression();
    Expression rightExpression = null;
    try {
      jj_consume_token(K_IS);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[246] = jj_gen;
        ;
      }
      jj_consume_token(K_DISTINCT);
      jj_consume_token(K_FROM);
      rightExpression = SimpleExpression();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
result.setLeftExpression(leftExpression);
        result.setRightExpression(rightExpression);
        linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression IsNullExpression(Expression leftExpression) throws ParseException {IsNullExpression result = new IsNullExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ISNULL:
    case K_NOT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[247] = jj_gen;
        ;
      }
      jj_consume_token(K_ISNULL);
result.setUseIsNull(true);
      break;
      }
    case K_NOTNULL:{
      jj_consume_token(K_NOTNULL);
result.setUseIsNull(true); result.setUseNotNull(true);
      break;
      }
    case K_IS:{
      jj_consume_token(K_IS);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[248] = jj_gen;
        ;
      }
      jj_consume_token(K_NULL);
      break;
      }
    default:
      jj_la1[249] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
result.setLeftExpression(leftExpression);
        return result;
}

  final public Expression IsBooleanExpression(Expression leftExpression) throws ParseException {IsBooleanExpression result = new IsBooleanExpression();
    jj_consume_token(K_IS);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      break;
      }
    default:
      jj_la1[250] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TRUE:{
      jj_consume_token(K_TRUE);
result.setIsTrue(true);
      break;
      }
    case K_FALSE:{
      jj_consume_token(K_FALSE);
result.setIsTrue(false);
      break;
      }
    default:
      jj_la1[251] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
result.setLeftExpression(leftExpression);
        return result;
}

  final public Expression ExistsExpression() throws ParseException {ExistsExpression result = new ExistsExpression();
    Expression rightExpression = null;
    jj_consume_token(K_EXISTS);
    rightExpression = SimpleExpression();
result.setRightExpression(rightExpression);
        return result;
}

  final public Expression MemberOfExpression(Expression leftExpression) throws ParseException {MemberOfExpression result;
    Expression rightExpression = null;
    jj_consume_token(K_MEMBER);
    jj_consume_token(K_OF);
    rightExpression = Expression();
return new MemberOfExpression(leftExpression, rightExpression );
}

  final public ExpressionList ExpressionList() throws ParseException {/*@bgen(jjtree) ExpressionList */
    SimpleNode jjtn000 = new SimpleNode(JJTEXPRESSIONLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));ExpressionList expressionList;
    try {
      if (jj_2_227(3) && (getAsBoolean(Feature.allowComplexParsing) && !interrupted)) {
        expressionList = ComplexExpressionList();
      } else if (jj_2_228(3)) {
        expressionList = SimpleExpressionList();
      } else if (jj_2_229(3)) {
        expressionList = ParenthesedExpressionList();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
// Avoid redundant ExpressionLists containing only one ParenthesedExpressionList
        // return the Parenthesed Sub ExpressionList instead
        // Same for ParenthesedExpressionList containing only 1 ExpressionList

        if ( expressionList.size() == 1 && expressionList.get(0) instanceof ExpressionList ) {
            ExpressionList subList = (ExpressionList) expressionList.get(0);
            if (expressionList instanceof ParenthesedExpressionList) {
                if (subList instanceof ParenthesedExpressionList) {
                    return expressionList;
                } else {
                    return new ParenthesedExpressionList(subList);
                }
            } else {
                if (subList instanceof ParenthesedExpressionList) {
                    return new ParenthesedExpressionList(subList);
                } else {
                    return subList;
                }
            }
        }
        return expressionList;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ParenthesedExpressionList ParenthesedExpressionList() throws ParseException {ExpressionList expressions=new ExpressionList();
    jj_consume_token(425);
    if (jj_2_231(1)) {
      if (getAsBoolean(Feature.allowComplexParsing) && !interrupted) {
        expressions = ComplexExpressionList();
      } else if (jj_2_230(1)) {
        expressions = SimpleExpressionList();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    jj_consume_token(426);
return new ParenthesedExpressionList(expressions);
}

  final public ExpressionList SimpleExpressionList() throws ParseException {ExpressionList expressions = new ExpressionList();
    Expression expr;
    expr = SimpleExpression();
expressions.add(expr);
    label_47:
    while (true) {
      if (jj_2_232(2) && (!interrupted)) {
        ;
      } else {
        break label_47;
      }
      jj_consume_token(K_COMMA);
      if (jj_2_233(2)) {
        expr = LambdaExpression();
      } else if (jj_2_234(1)) {
        expr = SimpleExpression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
expressions.add(expr);
    }
return expressions;
}

  final public ExpressionList<Column> ColumnList() throws ParseException {ExpressionList<Column> expressions = new ExpressionList<Column>();
    Column expr;
    expr = Column();
expressions.add(expr);
    label_48:
    while (true) {
      if (jj_2_235(2)) {
        ;
      } else {
        break label_48;
      }
      jj_consume_token(K_COMMA);
      expr = Column();
expressions.add(expr);
    }
return expressions;
}

  final public ParenthesedExpressionList<Column> ParenthesedColumnList() throws ParseException {ExpressionList<Column> expressions;
    jj_consume_token(425);
    expressions = ColumnList();
    jj_consume_token(426);
return new ParenthesedExpressionList<Column>(expressions);
}

  final public ExpressionList ComplexExpressionList() throws ParseException {ExpressionList expressions = new ExpressionList();
    Expression expr;
    if (jj_2_236(2)) {
      expr = OracleNamedFunctionParameter();
    } else if (jj_2_237(1)) {
      expr = Expression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
expressions.add(expr);
    label_49:
    while (true) {
      if (jj_2_238(2) && (!interrupted)) {
        ;
      } else {
        break label_49;
      }
      jj_consume_token(K_COMMA);
      if (jj_2_239(2)) {
        expr = OracleNamedFunctionParameter();
      } else if (jj_2_240(2)) {
        expr = LambdaExpression();
      } else if (jj_2_241(1)) {
        expr = Expression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
expressions.add(expr);
    }
return expressions;
}

// @Todo: Refactor this with proper SQL:2016 functions according to https://manticore-projects.com/SQL2016Parser/syntax.html#character-value-function
// substring(expr1 from expr2)
// substring(expr1 from expr2 for expr3)
// trim(expr1 from expr2)   <-- Superceded by TrimFunction() below
// position(expr1 in expr2)
// overlay(expr1 placing expr2 from expr3)
// overlay(expr1 placing expr2 from expr3 for expr4)
// expr1 has already been consumed
  final public NamedExpressionList NamedExpressionListExprFirst() throws ParseException {NamedExpressionList retval = new NamedExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    List<String> names = new ArrayList<String>();
    Expression expr1 = null;
    Expression expr2 = null;
    Expression expr3 = null;
    Expression expr4 = null;
    Token tk2 = null;
    Token tk3 = null;
    Token tk4 = null;
    expr1 = SimpleExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:{
      tk2 = jj_consume_token(K_FROM);
      break;
      }
    case K_IN:{
      tk2 = jj_consume_token(K_IN);
      break;
      }
    case K_PLACING:{
      tk2 = jj_consume_token(K_PLACING);
      break;
      }
    default:
      jj_la1[252] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
names.add("");
                expressions.add(expr1);
                names.add(tk2.image);
    expr2 = SimpleExpression();
expressions.add(expr2);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FOR:
    case K_FROM:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FOR:{
        tk3 = jj_consume_token(K_FOR);
        break;
        }
      case K_FROM:{
        tk3 = jj_consume_token(K_FROM);
        break;
        }
      default:
        jj_la1[253] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr3 = SimpleExpression();
names.add(tk3.image); expressions.add(expr3);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FOR:{
        tk4 = jj_consume_token(K_FOR);
        expr4 = SimpleExpression();
names.add(tk4.image); expressions.add(expr4);
        break;
        }
      default:
        jj_la1[254] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[255] = jj_gen;
      ;
    }
retval.setNames(names);
        retval.setExpressions(expressions);
        return retval;
}

  final public Expression ComparisonItem() throws ParseException {Expression retval = null;
    if (jj_2_242(2147483647)) {
      retval = AnyComparisonExpression();
    } else if (jj_2_243(3)) {
      retval = SimpleExpression();
    } else if (jj_2_244(3)) {
      retval = ParenthesedExpressionList();
    } else if (jj_2_245(3)) {
      retval = RowConstructor();
    } else if (jj_2_246(1)) {
      retval = PrimaryExpression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
return retval;
}

  final public Expression AnyComparisonExpression() throws ParseException {AnyType anyType;
    Select select;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ANY:{
      jj_consume_token(K_ANY);
anyType = AnyType.ANY;
      break;
      }
    case K_SOME:{
      jj_consume_token(K_SOME);
anyType = AnyType.SOME;
      break;
      }
    case K_ALL:{
      jj_consume_token(K_ALL);
anyType = AnyType.ALL;
      break;
      }
    default:
      jj_la1[256] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    select = ParenthesedSelect();
return new AnyComparisonExpression(anyType, select);
}

  final public Expression SimpleExpression() throws ParseException {Expression retval = null;
    UserVariable user = null;
    Token operation = null;
    if (jj_2_247(2147483647)) {
      user = UserVariable();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 427:{
        operation = jj_consume_token(427);
        break;
        }
      case 458:{
        operation = jj_consume_token(458);
        break;
        }
      default:
        jj_la1[257] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    retval = ConcatExpression();
if (user != null) {
            VariableAssignment assignment = new VariableAssignment();
            assignment.setVariable(user);
            assignment.setOperation(operation.image);
            assignment.setExpression(retval);
            return assignment;
        } else
            return retval;
}

  final public Expression ConcatExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = BitwiseAndOr();
result = leftExpression;
    label_50:
    while (true) {
      if (jj_2_248(3)) {
        ;
      } else {
        break label_50;
      }
      jj_consume_token(OP_CONCAT);
      /* Oracle allows space between the bars. */
              rightExpression = BitwiseAndOr();
Concat binExp = new Concat();
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            result = binExp;
            leftExpression = result;
    }
return result;
}

  final public Expression BitwiseAndOr() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = AdditiveExpression();
result = leftExpression;
    label_51:
    while (true) {
      if (jj_2_249(2)) {
        ;
      } else {
        break label_51;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 459:{
        jj_consume_token(459);
result = new BitwiseOr();
        break;
        }
      case 460:{
        jj_consume_token(460);
result = new BitwiseAnd();
        break;
        }
      case 461:{
        jj_consume_token(461);
result = new BitwiseLeftShift();
        break;
        }
      case 462:{
        jj_consume_token(462);
result = new BitwiseRightShift();
        break;
        }
      default:
        jj_la1[258] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = AdditiveExpression();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression AdditiveExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = MultiplicativeExpression();
result = leftExpression;
    label_52:
    while (true) {
      if (jj_2_250(2)) {
        ;
      } else {
        break label_52;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 440:{
        jj_consume_token(440);
result = new Addition();
        break;
        }
      case 454:{
        jj_consume_token(454);
result = new Subtraction();
        break;
        }
      default:
        jj_la1[259] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = MultiplicativeExpression();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression MultiplicativeExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = BitwiseXor();
result = leftExpression;
    label_53:
    while (true) {
      if (jj_2_251(2)) {
        ;
      } else {
        break label_53;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 437:{
        jj_consume_token(437);
result = new Multiplication();
        break;
        }
      case 463:{
        jj_consume_token(463);
result = new Division();
        break;
        }
      case K_DIV:{
        jj_consume_token(K_DIV);
result = new IntegerDivision();
        break;
        }
      case 464:{
        jj_consume_token(464);
result = new Modulo();
        break;
        }
      default:
        jj_la1[260] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = BitwiseXor();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression BitwiseXor() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = PrimaryExpression();
result = leftExpression;
    label_54:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 465:{
        ;
        break;
        }
      default:
        jj_la1[261] = jj_gen;
        break label_54;
      }
      jj_consume_token(465);
      rightExpression = PrimaryExpression();
BitwiseXor binExp = new BitwiseXor();
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            result = binExp;
            leftExpression = result;
    }
return result;
}

  final public Expression ArrayExpression(Expression obj) throws ParseException {Expression expr;
    Expression idxExpr = null;
    Expression startExpr = null;
    Expression stopExpr = null;
    jj_consume_token(466);
    if (jj_2_252(3)) {
      idxExpr = SimpleExpression();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOUBLE_COLON:{
      jj_consume_token(DOUBLE_COLON);
startExpr=idxExpr; idxExpr=null;
      if (jj_2_253(1)) {
        stopExpr = SimpleExpression();
      } else {
        ;
      }
      break;
      }
    default:
      jj_la1[262] = jj_gen;
      ;
    }
    jj_consume_token(467);
expr =  new ArrayExpression(obj, idxExpr, startExpr, stopExpr);
    label_55:
    while (true) {
      if (jj_2_254(2)) {
        ;
      } else {
        break label_55;
      }
      jj_consume_token(466);
      if (jj_2_255(3)) {
        idxExpr = SimpleExpression();
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOUBLE_COLON:{
        jj_consume_token(DOUBLE_COLON);
startExpr=idxExpr; idxExpr=null;
        if (jj_2_256(1)) {
          stopExpr = SimpleExpression();
        } else {
          ;
        }
        break;
        }
      default:
        jj_la1[263] = jj_gen;
        ;
      }
      jj_consume_token(467);
expr =  new ArrayExpression(expr, idxExpr, startExpr, stopExpr);
    }
return expr;
}

  final public Expression PrimaryExpression() throws ParseException {/*@bgen(jjtree) PrimaryExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTPRIMARYEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression retval = null;
    CastExpression castExpr = null;
    TimezoneExpression timezoneExpr = null;
    Expression timezoneRightExpr = null;
    Token token = null;
    Token sign = null;
    String tmp = "";
    ColDataType type = null;
    boolean not = false;
    boolean exclamationMarkNot = false;
    boolean dateExpressionAllowed = true;
    ExpressionList list;

    final List<Map.Entry<String, String>> jsonIdents = new ArrayList<Map.Entry<String, String>>();
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:
      case 439:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:{
          jj_consume_token(K_NOT);
not=true;
          break;
          }
        case 439:{
          jj_consume_token(439);
not=true; exclamationMarkNot=true;
          break;
          }
        default:
          jj_la1[264] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[265] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 440:
      case 446:
      case 454:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 440:{
          sign = jj_consume_token(440);
          break;
          }
        case 454:{
          sign = jj_consume_token(454);
          break;
          }
        case 446:{
          sign = jj_consume_token(446);
          break;
          }
        default:
          jj_la1[266] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[267] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NULL:{
        jj_consume_token(K_NULL);
retval = new NullValue();
        break;
        }
      default:
        jj_la1[270] = jj_gen;
        if (jj_2_258(3) && (!interrupted)) {
          retval = CaseWhenExpression();
        } else if (jj_2_259(2) && (!interrupted)) {
          retval = CharacterPrimary();
        } else if (jj_2_260(2147483647) && (!interrupted)) {
          retval = ImplicitCast();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_PARAMETER:
          case 438:{
            retval = JdbcParameter();
            break;
            }
          default:
            jj_la1[271] = jj_gen;
            if (jj_2_261(2)) {
              retval = JdbcNamedParameter();
            } else if (jj_2_262(3)) {
              retval = UserVariable();
            } else if (jj_2_263(2) && (!interrupted)) {
              retval = NumericBind();
            } else if (jj_2_264(2147483647) && (!interrupted)) {
              retval = ExtractExpression();
            } else if (jj_2_265(3)) {
              retval = MySQLGroupConcat();
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_XMLSERIALIZE:{
                retval = XMLSerializeExpr();
                break;
                }
              default:
                jj_la1[272] = jj_gen;
                if (jj_2_266(3) && (!interrupted)) {
                  retval = JsonFunction();
                } else if (jj_2_267(3) && (!interrupted)) {
                  retval = JsonAggregateFunction();
                } else if (jj_2_268(3) && (!interrupted)) {
                  retval = FullTextSearch();
                } else if (jj_2_269(2147483647) && (!interrupted)) {
                  retval = Function();
                  if (jj_2_257(2)) {
                    retval = AnalyticExpression((Function) retval);
                  } else {
                    ;
                  }
                } else if (jj_2_270(2) && (!interrupted)) {
                  retval = IntervalExpression();
dateExpressionAllowed = false;
                } else {
                  switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                  case S_DOUBLE:{
                    token = jj_consume_token(S_DOUBLE);
retval = new DoubleValue(token.image);
                    break;
                    }
                  case S_LONG:{
                    token = jj_consume_token(S_LONG);
retval = new LongValue(token.image);
                    break;
                    }
                  case S_HEX:{
                    token = jj_consume_token(S_HEX);
retval = new HexValue(token.image);
                    break;
                    }
                  default:
                    jj_la1[273] = jj_gen;
                    if (jj_2_271(2) && (!interrupted)) {
                      retval = CastExpression();
                    } else if (jj_2_272(2) && (!interrupted)) {
                      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                      case K_TIME_KEY_EXPR:{
                        token = jj_consume_token(K_TIME_KEY_EXPR);
                        break;
                        }
                      case K_CURRENT:{
                        token = jj_consume_token(K_CURRENT);
                        break;
                        }
                      default:
                        jj_la1[268] = jj_gen;
                        jj_consume_token(-1);
                        throw new ParseException();
                      }
retval = new TimeKeyExpression(token.image);
                    } else if (jj_2_273(2) && (!interrupted)) {
                      retval = DateTimeLiteralExpression();
                    } else if (jj_2_274(3) && (!interrupted)) {
                      retval = StructType();
                    } else if (jj_2_275(3) && (!interrupted)) {
                      jj_consume_token(K_ARRAY_LITERAL);
                      retval = ArrayConstructor(true);
                    } else if (jj_2_276(3) && (!interrupted)) {
                      retval = ArrayConstructor(false);
                    } else if (jj_2_277(2) && (!interrupted)) {
                      retval = NextValExpression();
                    } else {
                      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                      case K_CONNECT_BY_ROOT:{
                        retval = ConnectByRootOperator();
                        break;
                        }
                      default:
                        jj_la1[274] = jj_gen;
                        if (jj_2_278(2) && (!interrupted)) {
                          jj_consume_token(K_ALL);
retval = new AllValue();
                        } else if (jj_2_279(2) && (!interrupted)) {
                          retval = Column();
                        } else {
                          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                          case S_CHAR_LITERAL:{
                            token = jj_consume_token(S_CHAR_LITERAL);
retval = new StringValue(token.image); linkAST(retval,jjtn000);
                            break;
                            }
                          case 468:{
                            jj_consume_token(468);
                            token = jj_consume_token(S_CHAR_LITERAL);
                            jj_consume_token(CLOSING_CURLY_BRACKET);
retval = new DateValue(token.image);
                            break;
                            }
                          case 469:{
                            jj_consume_token(469);
                            token = jj_consume_token(S_CHAR_LITERAL);
                            jj_consume_token(CLOSING_CURLY_BRACKET);
retval = new TimeValue(token.image);
                            break;
                            }
                          case 470:{
                            jj_consume_token(470);
                            token = jj_consume_token(S_CHAR_LITERAL);
                            jj_consume_token(CLOSING_CURLY_BRACKET);
retval = new TimestampValue(token.image);
                            break;
                            }
                          default:
                            jj_la1[275] = jj_gen;
                            if (jj_2_280(2147483647) && (!interrupted)) {
                              retval = ParenthesedSelect();
                            } else {
                              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                              case 425:{
                                list = ParenthesedExpressionList();
if (list.size() == 1) {
                    retval = new ParenthesedExpressionList( (Expression) list.getExpressions().get(0));
                } else {
                    retval = list;
                }
                                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                                case 428:{
                                  jj_consume_token(428);
                                  tmp = RelObjectNameExt();
retval = new RowGetExpression(retval, tmp);
                                  break;
                                  }
                                default:
                                  jj_la1[269] = jj_gen;
                                  ;
                                }
                                break;
                                }
                              default:
                                jj_la1[276] = jj_gen;
                                jj_consume_token(-1);
                                throw new ParseException();
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      if (jj_2_281(2)) {
        jj_consume_token(K_COLLATE);
        token = jj_consume_token(S_IDENTIFIER);
retval = new CollateExpression(retval, token.image);
      } else {
        ;
      }
      if (jj_2_282(2) && (dateExpressionAllowed)) {
        retval = IntervalExpressionWithoutInterval(retval);
      } else {
        ;
      }
      if (jj_2_283(2)) {
        retval = ArrayExpression(retval);
      } else {
        ;
      }
      label_56:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 471:{
          ;
          break;
          }
        default:
          jj_la1[277] = jj_gen;
          break label_56;
        }
        jj_consume_token(471);
        type = ColDataType();
castExpr = new CastExpression();
            castExpr.setUseCastKeyword(false);
            castExpr.setLeftExpression(retval);
            castExpr.setColDataType(type);
            retval=castExpr;
      }
      if (jj_2_284(2)) {
        label_57:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 472:{
            jj_consume_token(472);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S_CHAR_LITERAL:{
              token = jj_consume_token(S_CHAR_LITERAL);
              break;
              }
            case S_LONG:{
              token = jj_consume_token(S_LONG);
              break;
              }
            default:
              jj_la1[278] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
jsonIdents.add(new AbstractMap.SimpleEntry<String, String>(token.image,"->"));
            break;
            }
          case 473:{
            jj_consume_token(473);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S_CHAR_LITERAL:{
              token = jj_consume_token(S_CHAR_LITERAL);
              break;
              }
            case S_LONG:{
              token = jj_consume_token(S_LONG);
              break;
              }
            default:
              jj_la1[279] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
jsonIdents.add(new AbstractMap.SimpleEntry<String, String>(token.image,"->>"));
            break;
            }
          case 474:{
            jj_consume_token(474);
            token = jj_consume_token(S_CHAR_LITERAL);
jsonIdents.add(new AbstractMap.SimpleEntry<String, String>(token.image,"#>"));
            break;
            }
          case 475:{
            jj_consume_token(475);
            token = jj_consume_token(S_CHAR_LITERAL);
jsonIdents.add(new AbstractMap.SimpleEntry<String, String>(token.image,"#>>"));
            break;
            }
          default:
            jj_la1[280] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 472:
          case 473:
          case 474:
          case 475:{
            ;
            break;
            }
          default:
            jj_la1[281] = jj_gen;
            break label_57;
          }
        }
        retval = JsonExpression(retval, jsonIdents);
      } else {
        ;
      }
      label_58:
      while (true) {
        if (jj_2_285(2)) {
          ;
        } else {
          break label_58;
        }
        jj_consume_token(K_AT);
        jj_consume_token(K_DATETIMELITERAL);
        jj_consume_token(K_ZONE);
        timezoneRightExpr = PrimaryExpression();
if (timezoneExpr == null)
            timezoneExpr = new TimezoneExpression();

        timezoneExpr.addTimezoneExpression(timezoneRightExpr);
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
if (timezoneExpr != null && !timezoneExpr.getTimezoneExpressions().isEmpty()) {
            timezoneExpr.setLeftExpression(retval);
            retval=timezoneExpr;
        }
        if (sign != null) {
            retval = new SignedExpression(sign.image.charAt(0), retval);
        }
        if (not) {
            retval = new NotExpression(retval, exclamationMarkNot);
        }
        linkAST(retval, jjtn000);
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ConnectByRootOperator ConnectByRootOperator() throws ParseException {/*@bgen(jjtree) ConnectByRootOperator */
    SimpleNode jjtn000 = new SimpleNode(JJTCONNECTBYROOTOPERATOR);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Column column;
    try {
      jj_consume_token(K_CONNECT_BY_ROOT);
      column = Column();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return new ConnectByRootOperator(column);
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public NextValExpression NextValExpression() throws ParseException {ObjectNames data = null;
    Token token;
    token = jj_consume_token(K_NEXTVAL);
    data = RelObjectNames();
return new NextValExpression(data.getNames(), token.image);
}

  final public JdbcNamedParameter JdbcNamedParameter() throws ParseException {JdbcNamedParameter parameter = new JdbcNamedParameter();
    String name;
    String namePart;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOUBLE_COLON:{
      jj_consume_token(DOUBLE_COLON);
      break;
      }
    case 460:{
      jj_consume_token(460);
parameter.setParameterCharacter("&");
      break;
      }
    default:
      jj_la1[282] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    name = IdentifierChain();
parameter.setName(name);
        return parameter;
}

  final public OracleNamedFunctionParameter OracleNamedFunctionParameter() throws ParseException {Token token = null;
    String name = null;
    Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALL:
    case K_ALTER:
    case K_ANALYZE:
    case K_ANY:
    case K_APPLY:
    case K_APPROXIMATE:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BASE64:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CASEWHEN:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONNECT:
    case K_CONSTRAINTS:
    case K_CONVERT:
    case K_COSTS:
    case K_CREATE:
    case K_CURRENT:
    case K_CYCLE:
    case K_DATABASE:
    case K_DATA:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FROM:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GLOBAL:
    case K_GRANT:
    case K_GROUP:
    case K_GROUPING:
    case K_GUARD:
    case K_HASH:
    case K_HISTORY:
    case K_HOPPING:
    case K_IF:
    case K_IIF:
    case K_IGNORE:
    case K_IN:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_INVALIDATE:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LEFT:
    case K_LIMIT:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_LOOP:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAX:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MIN:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NEXTVAL:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OVERLAPS:
    case K_OPTIMIZE:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_PURGE:
    case K_QUALIFY:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_RECURSIVE:
    case K_REFERENCES:
    case K_REFRESH:
    case K_REGEXP:
    case K_RESPECT:
    case K_RLIKE:
    case K_REGISTER:
    case K_REMOTE:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_RETURN:
    case K_RIGHT:
    case K_ROLLBACK:
    case K_ROLLUP:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SECURE:
    case K_SEED:
    case K_SELECT:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SHARE:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_SOME:
    case K_START:
    case K_STORED:
    case K_STRING:
    case K_STRUCT:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_VOLATILE:
    case K_CONCURRENTLY:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case DATA_TYPE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 429:
    case 430:
    case 431:
    case 432:
    case 433:
    case 434:
    case 435:
    case 436:{
      name = RelObjectNameExt2();
      break;
      }
    case K_OUTER:{
      token = jj_consume_token(K_OUTER);
      break;
      }
    default:
      jj_la1[283] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_ORACLE_NAMED_PARAMETER_ASSIGNMENT);
    expression = Expression();
return new OracleNamedFunctionParameter(name != null ? name : token.image, expression);
}

  final public UserVariable UserVariable() throws ParseException {UserVariable var = new UserVariable();
    String varName;
    String var2;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 476:{
      jj_consume_token(476);
      break;
      }
    case 445:{
      jj_consume_token(445);
var.setDoubleAdd(true);
      break;
      }
    default:
      jj_la1[284] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    varName = IdentifierChain();
var.setName(varName);
        return var;
}

  final public NumericBind NumericBind() throws ParseException {NumericBind var = new NumericBind();
    Token token;
    jj_consume_token(DOUBLE_COLON);
    token = jj_consume_token(S_LONG);
var.setBindId(Integer.valueOf(token.image));
        return var;
}

  final public DateTimeLiteralExpression DateTimeLiteralExpression() throws ParseException {DateTimeLiteralExpression expr = new DateTimeLiteralExpression();
    Token t;
    t = jj_consume_token(K_DATETIMELITERAL);
expr.setType(DateTimeLiteralExpression.DateTime.from(t.image));
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_CHAR_LITERAL:{
      t = jj_consume_token(S_CHAR_LITERAL);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      t = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    default:
      jj_la1[285] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
expr.setValue(t.image); return expr;
}

  final public RangeExpression RangeExpression(Expression startExpression) throws ParseException {Expression endExpression;
    jj_consume_token(DOUBLE_COLON);
    endExpression = Expression();
return new RangeExpression(startExpression, endExpression);
}

  final public ArrayConstructor ArrayConstructor(boolean arrayKeyword) throws ParseException {ExpressionList expList = new ExpressionList();
    ArrayConstructor array = new ArrayConstructor(expList, arrayKeyword);
    Expression exp;
    jj_consume_token(466);
    if (jj_2_288(1)) {
      if (jj_2_286(3)) {
        exp = Expression();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case DOUBLE_COLON:{
          exp = RangeExpression(exp);
          break;
          }
        default:
          jj_la1[286] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 466:{
          exp = ArrayConstructor(false);
          break;
          }
        default:
          jj_la1[287] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
expList.add(exp);
      label_59:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[288] = jj_gen;
          break label_59;
        }
        jj_consume_token(K_COMMA);
        if (jj_2_287(3)) {
          exp = Expression();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case DOUBLE_COLON:{
            exp = RangeExpression(exp);
            break;
            }
          default:
            jj_la1[289] = jj_gen;
            ;
          }
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 466:{
            exp = ArrayConstructor(false);
            break;
            }
          default:
            jj_la1[290] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
expList.add(exp);
      }
    } else {
      ;
    }
    jj_consume_token(467);
return array;
}

  final public List<Map.Entry<String, ColDataType>> StructParameters() throws ParseException {String parameterName = "";
    ColDataType parameterType = null;
    AbstractMap.SimpleEntry<String, ColDataType> parameter = null;
    List<Map.Entry<String, ColDataType>> parameters = new ArrayList<Map.Entry<String, ColDataType>>();
    if (jj_2_289(2)) {
      parameterName = RelObjectName();
    } else {
      ;
    }
    parameterType = ColDataType();
parameters.add( new AbstractMap.SimpleEntry<String, ColDataType>(parameterName, parameterType) );
    label_60:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[291] = jj_gen;
        break label_60;
      }
      jj_consume_token(K_COMMA);
parameterName="";
      if (jj_2_290(2)) {
        parameterName = RelObjectName();
      } else {
        ;
      }
      parameterType = ColDataType();
parameters.add( new AbstractMap.SimpleEntry<String, ColDataType>(parameterName, parameterType) );
    }
return parameters;
}

  final public StructType StructType() throws ParseException {/*@bgen(jjtree) StruckType */
    SimpleNode jjtn000 = new SimpleNode(JJTSTRUCKTYPE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));StructType.Dialect dialect = StructType.Dialect.BIG_QUERY;
    Token tk1;
    String keyword = "";
    List<Map.Entry<String, ColDataType>> parameters = null;
    List<SelectItem<?>> arguments = null;
    String id = null;
    Expression expression = null;
    StructType type;
    try {
      if (jj_2_292(4)) {
        tk1 = jj_consume_token(K_STRUCT);
keyword = tk1.image;
        jj_consume_token(442);
        parameters = StructParameters();
        jj_consume_token(441);
        jj_consume_token(425);
System.out.println("found arguments!");
        arguments = SelectItemsList();
        jj_consume_token(426);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_STRUCT:{
          tk1 = jj_consume_token(K_STRUCT);
keyword = tk1.image;
          jj_consume_token(425);
          arguments = SelectItemsList();
          jj_consume_token(426);
          break;
          }
        case OPENING_CURLY_BRACKET:{
          jj_consume_token(OPENING_CURLY_BRACKET);
arguments= new  ArrayList<SelectItem<?>>(); dialect = StructType.Dialect.DUCKDB;
          id = RelObjectName();
          jj_consume_token(DOUBLE_COLON);
          expression = Expression();
arguments.add( new SelectItem( expression, id) );
          label_61:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[292] = jj_gen;
              break label_61;
            }
            jj_consume_token(K_COMMA);
            id = RelObjectName();
            jj_consume_token(DOUBLE_COLON);
            expression = Expression();
arguments.add( new SelectItem( expression, id) );
          }
          jj_consume_token(CLOSING_CURLY_BRACKET);
          label_62:
          while (true) {
            if (jj_2_291(2)) {
              ;
            } else {
              break label_62;
            }
            jj_consume_token(471);
            jj_consume_token(K_STRUCT);
            jj_consume_token(425);
            parameters = StructParameters();
            jj_consume_token(426);
          }
          break;
          }
        default:
          jj_la1[293] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
type = new StructType(dialect, keyword, parameters, arguments);
        linkAST(type,jjtn000);
        return type;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression ParenthesedExpression() throws ParseException {Expression expression;
    jj_consume_token(425);
    expression = PrimaryExpression();
    jj_consume_token(426);
return new ParenthesedExpressionList(expression);
}

  final public JsonExpression JsonExpression(Expression expr, List<Map.Entry<String, String>> idents) throws ParseException {JsonExpression result = new JsonExpression(expr, idents);
  Token token;
  ColDataType type = null;
  CastExpression castExpr = null;
    label_63:
    while (true) {
      if (jj_2_293(2) && (!interrupted)) {
        ;
      } else {
        break label_63;
      }
      label_64:
      while (true) {
        jj_consume_token(471);
        type = ColDataType();
castExpr = new CastExpression();
                    castExpr.setUseCastKeyword(false);
                    castExpr.setLeftExpression(result);
                    castExpr.setColDataType(type);
                    expr=castExpr;
        if (jj_2_294(2)) {
          ;
        } else {
          break label_64;
        }
      }
result = new JsonExpression(expr);
      label_65:
      while (true) {
        if (jj_2_295(2)) {
          ;
        } else {
          break label_65;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 472:{
          jj_consume_token(472);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_CHAR_LITERAL:{
            token = jj_consume_token(S_CHAR_LITERAL);
            break;
            }
          case S_LONG:{
            token = jj_consume_token(S_LONG);
            break;
            }
          default:
            jj_la1[294] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
result.addIdent(token.image,"->");
          break;
          }
        case 473:{
          jj_consume_token(473);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_CHAR_LITERAL:{
            token = jj_consume_token(S_CHAR_LITERAL);
            break;
            }
          case S_LONG:{
            token = jj_consume_token(S_LONG);
            break;
            }
          default:
            jj_la1[295] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
result.addIdent(token.image,"->>");
          break;
          }
        case 474:{
          jj_consume_token(474);
          token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"#>");
          break;
          }
        case 475:{
          jj_consume_token(475);
          token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"#>>");
          break;
          }
        default:
          jj_la1[296] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
result.setExpression(expr);
        return result;
}

  final public JsonFunction JsonFunction() throws ParseException {JsonFunction result = new JsonFunction();
    boolean usingKeyKeyword = false;
    boolean usingValueKeyword = false;
    boolean usingFormatJason = false;
    Token keyToken;
    Token valueToken = null;
    Column column = null;
    JsonKeyValuePair keyValuePair;

    Expression expression = null;
    JsonFunctionExpression functionExpression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_JSON_OBJECT:{
      jj_consume_token(K_JSON_OBJECT);
      jj_consume_token(425);
result.setType( JsonFunctionType.OBJECT );
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_KEY:
      case S_CHAR_LITERAL:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_KEY:{
          jj_consume_token(K_KEY);
usingKeyKeyword = true;
          break;
          }
        default:
          jj_la1[297] = jj_gen;
          ;
        }
        keyToken = jj_consume_token(S_CHAR_LITERAL);
        if (jj_2_296(2)) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case DOUBLE_COLON:{
            jj_consume_token(DOUBLE_COLON);
            break;
            }
          case K_COMMA:{
            jj_consume_token(K_COMMA);
result.setType( JsonFunctionType.POSTGRES_OBJECT );
            break;
            }
          case K_VALUE:{
            jj_consume_token(K_VALUE);
usingValueKeyword = true;
            break;
            }
          default:
            jj_la1[298] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          expression = Expression();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_FORMAT:{
            jj_consume_token(K_FORMAT);
            jj_consume_token(K_JSON);
usingFormatJason = true;
            break;
            }
          default:
            jj_la1[299] = jj_gen;
            ;
          }
        } else {
          ;
        }
if (expression !=null) {
                                                                           keyValuePair = new JsonKeyValuePair( keyToken.image, expression, usingKeyKeyword, usingValueKeyword );
                                                                           keyValuePair.setUsingFormatJson( usingFormatJason );
                                                                           result.add(keyValuePair);
                                                                      } else {
                                       result.setType( JsonFunctionType.POSTGRES_OBJECT );
                                       keyValuePair = new JsonKeyValuePair( keyToken.image, null, false, false );
                                       result.add(keyValuePair);
                                  }
        label_66:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[300] = jj_gen;
            break label_66;
          }
          jj_consume_token(K_COMMA);
usingKeyKeyword = false; usingValueKeyword = false;
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_KEY:{
            jj_consume_token(K_KEY);
usingKeyKeyword = true;
            break;
            }
          default:
            jj_la1[301] = jj_gen;
            ;
          }
          keyToken = jj_consume_token(S_CHAR_LITERAL);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case DOUBLE_COLON:{
            jj_consume_token(DOUBLE_COLON);
            break;
            }
          case K_COMMA:{
            jj_consume_token(K_COMMA);
result.setType( JsonFunctionType.MYSQL_OBJECT );
            break;
            }
          case K_VALUE:{
            jj_consume_token(K_VALUE);
usingValueKeyword = true;
            break;
            }
          default:
            jj_la1[302] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          expression = Expression();
keyValuePair = new JsonKeyValuePair( keyToken.image, expression, usingKeyKeyword, usingValueKeyword ); result.add(keyValuePair);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_FORMAT:{
            jj_consume_token(K_FORMAT);
            jj_consume_token(K_JSON);
keyValuePair.setUsingFormatJson( true );
            break;
            }
          default:
            jj_la1[303] = jj_gen;
            ;
          }
        }
        break;
        }
      default:
        jj_la1[304] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ABSENT:
      case K_NULL:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NULL:{
          jj_consume_token(K_NULL);
          jj_consume_token(K_ON);
          jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.NULL );
          break;
          }
        case K_ABSENT:{
          jj_consume_token(K_ABSENT);
          jj_consume_token(K_ON);
          jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.ABSENT );
          break;
          }
        default:
          jj_la1[305] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[306] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WITH:
      case K_WITHOUT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WITH:{
          jj_consume_token(K_WITH);
          jj_consume_token(K_UNIQUE);
          jj_consume_token(K_KEYS);
result.setUniqueKeysType( JsonAggregateUniqueKeysType.WITH );
          break;
          }
        case K_WITHOUT:{
          jj_consume_token(K_WITHOUT);
          jj_consume_token(K_UNIQUE);
          jj_consume_token(K_KEYS);
result.setUniqueKeysType( JsonAggregateUniqueKeysType.WITHOUT );
          break;
          }
        default:
          jj_la1[307] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[308] = jj_gen;
        ;
      }
      jj_consume_token(426);
      break;
      }
    case K_JSON_ARRAY:{
      jj_consume_token(K_JSON_ARRAY);
result.setType( JsonFunctionType.ARRAY );
      jj_consume_token(425);
      label_67:
      while (true) {
        if (jj_2_297(1)) {
          ;
        } else {
          break label_67;
        }
        if (jj_2_300(2)) {
          jj_consume_token(K_NULL);
          jj_consume_token(K_ON);
          jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.NULL );
        } else if (jj_2_301(1)) {
          expression = Expression();
functionExpression = new JsonFunctionExpression( expression ); result.add( functionExpression );
          if (jj_2_298(2)) {
            jj_consume_token(K_FORMAT);
            jj_consume_token(K_JSON);
functionExpression.setUsingFormatJson( true );
          } else {
            ;
          }
          label_68:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[309] = jj_gen;
              break label_68;
            }
            jj_consume_token(K_COMMA);
            expression = Expression();
functionExpression = new JsonFunctionExpression( expression ); result.add( functionExpression );
            if (jj_2_299(2)) {
              jj_consume_token(K_FORMAT);
              jj_consume_token(K_JSON);
functionExpression.setUsingFormatJson( true );
            } else {
              ;
            }
          }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ABSENT:{
        jj_consume_token(K_ABSENT);
        jj_consume_token(K_ON);
        jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.ABSENT );
        break;
        }
      default:
        jj_la1[310] = jj_gen;
        ;
      }
      jj_consume_token(426);
      break;
      }
    default:
      jj_la1[311] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return result;
}

  final public JsonAggregateFunction JsonAggregateFunction() throws ParseException {JsonAggregateFunction result = new JsonAggregateFunction();
    Token token;
    Expression expression;
    List<OrderByElement> expressionOrderByList = null;

    Expression filter;
    ExpressionList expressionList = null;
    List<OrderByElement> olist = null;
    WindowElement windowElement = null;
    boolean partitionByBrackets = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_JSON_OBJECTAGG:{
      jj_consume_token(K_JSON_OBJECTAGG);
      jj_consume_token(425);
result.setType( JsonFunctionType.OBJECT );
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_KEY:{
        jj_consume_token(K_KEY);
result.setUsingKeyKeyword( true );
        break;
        }
      default:
        jj_la1[312] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DT_ZONE:{
        token = jj_consume_token(DT_ZONE);
        break;
        }
      case S_DOUBLE:{
        token = jj_consume_token(S_DOUBLE);
        break;
        }
      case S_LONG:{
        token = jj_consume_token(S_LONG);
        break;
        }
      case S_HEX:{
        token = jj_consume_token(S_HEX);
        break;
        }
      case S_CHAR_LITERAL:{
        token = jj_consume_token(S_CHAR_LITERAL);
        break;
        }
      case S_IDENTIFIER:{
        token = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        token = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[313] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
result.setKey( token.image );
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOUBLE_COLON:{
        jj_consume_token(DOUBLE_COLON);
        break;
        }
      case K_VALUE:{
        jj_consume_token(K_VALUE);
result.setUsingValueKeyword( true );
        break;
        }
      default:
        jj_la1[314] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        token = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        token = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[315] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
result.setValue( token.image );
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FORMAT:{
        jj_consume_token(K_FORMAT);
        jj_consume_token(K_JSON);
result.setUsingFormatJson( true );
        break;
        }
      default:
        jj_la1[316] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ABSENT:
      case K_NULL:{
        if (jj_2_302(2)) {
          jj_consume_token(K_NULL);
          jj_consume_token(K_ON);
          jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.NULL );
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ABSENT:{
            jj_consume_token(K_ABSENT);
            jj_consume_token(K_ON);
            jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.ABSENT );
            break;
            }
          default:
            jj_la1[317] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[318] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WITH:
      case K_WITHOUT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WITH:{
          jj_consume_token(K_WITH);
          jj_consume_token(K_UNIQUE);
          jj_consume_token(K_KEYS);
result.setUniqueKeysType( JsonAggregateUniqueKeysType.WITH );
          break;
          }
        case K_WITHOUT:{
          jj_consume_token(K_WITHOUT);
          jj_consume_token(K_UNIQUE);
          jj_consume_token(K_KEYS);
result.setUniqueKeysType( JsonAggregateUniqueKeysType.WITHOUT );
          break;
          }
        default:
          jj_la1[319] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[320] = jj_gen;
        ;
      }
      jj_consume_token(426);
      break;
      }
    case K_JSON_ARRAYAGG:{
      jj_consume_token(K_JSON_ARRAYAGG);
      jj_consume_token(425);
result.setType( JsonFunctionType.ARRAY );
      expression = Expression();
result.setExpression( expression );
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FORMAT:{
        jj_consume_token(K_FORMAT);
        jj_consume_token(K_JSON);
result.setUsingFormatJson( true );
        break;
        }
      default:
        jj_la1[321] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ORDER:{
        expressionOrderByList = OrderByElements();
result.setExpressionOrderByElements( expressionOrderByList );
        break;
        }
      default:
        jj_la1[322] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ABSENT:
      case K_NULL:{
        if (jj_2_303(2)) {
          jj_consume_token(K_NULL);
          jj_consume_token(K_ON);
          jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.NULL );
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ABSENT:{
            jj_consume_token(K_ABSENT);
            jj_consume_token(K_ON);
            jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.ABSENT );
            break;
            }
          default:
            jj_la1[323] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[324] = jj_gen;
        ;
      }
      jj_consume_token(426);
      break;
      }
    default:
      jj_la1[325] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_304(2)) {
      jj_consume_token(K_FILTER);
      jj_consume_token(425);
      jj_consume_token(K_WHERE);
result.setAnalyticType(AnalyticType.FILTER_ONLY);
      filter = Expression();
result.setFilterExpression( filter );
      jj_consume_token(426);
    } else {
      ;
    }
    if (jj_2_306(2)) {
      jj_consume_token(K_OVER);
result.setAnalyticType(AnalyticType.OVER);
      jj_consume_token(425);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_PARTITION:{
        jj_consume_token(K_PARTITION);
        jj_consume_token(K_BY);
        if (jj_2_305(2147483647)) {
          expressionList = ComplexExpressionList();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 425:{
            jj_consume_token(425);
partitionByBrackets = true;
            expressionList = ComplexExpressionList();
            jj_consume_token(426);
            break;
            }
          default:
            jj_la1[326] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[327] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ORDER:{
        olist = OrderByElements();
        break;
        }
      default:
        jj_la1[328] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_RANGE:
      case K_ROWS:{
        windowElement = WindowElement();
        break;
        }
      default:
        jj_la1[329] = jj_gen;
        ;
      }
result.setPartitionExpressionList(expressionList, partitionByBrackets);
                result.setOrderByElements(olist);
                result.setWindowElement(windowElement);
      jj_consume_token(426);
    } else {
      ;
    }
return result;
}

  final public IntervalExpression IntervalExpression() throws ParseException {IntervalExpression interval;
    Token token = null;
    Expression expr = null;
    boolean signed = false;
interval = new IntervalExpression();
    jj_consume_token(K_INTERVAL);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 454:{
      jj_consume_token(454);
signed=true;
      break;
      }
    default:
      jj_la1[330] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
      break;
      }
    case S_DOUBLE:{
      token = jj_consume_token(S_DOUBLE);
      break;
      }
    case S_CHAR_LITERAL:{
      token = jj_consume_token(S_CHAR_LITERAL);
      break;
      }
    default:
      jj_la1[331] = jj_gen;
      if (jj_2_307(2147483647)) {
        expr = JdbcParameter();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case DOUBLE_COLON:
        case 460:{
          expr = JdbcNamedParameter();
          break;
          }
        default:
          jj_la1[332] = jj_gen;
          if (jj_2_308(2147483647)) {
            expr = Function();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ACTION:
            case K_ACTIVE:
            case K_ADD:
            case K_ADVANCE:
            case K_ADVISE:
            case K_AGAINST:
            case K_ALGORITHM:
            case K_ALL:
            case K_ALTER:
            case K_ANALYZE:
            case K_ANY:
            case K_APPLY:
            case K_APPROXIMATE:
            case K_ARCHIVE:
            case K_ARRAY_LITERAL:
            case K_AT:
            case K_ASC:
            case K_AUTHORIZATION:
            case K_AUTO:
            case K_BASE64:
            case K_BEGIN:
            case K_BERNOULLI:
            case K_BINARY:
            case K_BIT:
            case K_BLOCK:
            case K_BROWSE:
            case K_BY:
            case K_BYTES:
            case K_CACHE:
            case K_BUFFERS:
            case K_BYTE:
            case K_CALL:
            case K_CASCADE:
            case K_CASE:
            case K_CASEWHEN:
            case K_CAST:
            case K_CHARACTER:
            case K_CHANGE:
            case K_CHANGES:
            case K_CHECKPOINT:
            case K_CHAR:
            case K_CLOSE:
            case K_COLLATE:
            case K_COLUMN:
            case K_COLUMNS:
            case K_COMMIT:
            case K_COMMENT:
            case K_CONFLICT:
            case K_CONNECT:
            case K_CONSTRAINTS:
            case K_CONVERT:
            case K_COSTS:
            case K_CREATE:
            case K_CYCLE:
            case K_DATABASE:
            case K_DATA:
            case K_DECLARE:
            case K_DATETIMELITERAL:
            case K_DATE_LITERAL:
            case K_DEFAULT:
            case K_DEFERRABLE:
            case K_DELAYED:
            case K_DELETE:
            case K_DESC:
            case K_DESCRIBE:
            case K_DISABLE:
            case K_DISCONNECT:
            case K_DIV:
            case K_DDL:
            case K_DML:
            case K_DO:
            case K_DOMAIN:
            case K_DROP:
            case K_DUMP:
            case K_DUPLICATE:
            case K_ELEMENTS:
            case K_EMIT:
            case K_ENABLE:
            case K_END:
            case K_ESCAPE:
            case K_EXCLUDE:
            case K_EXEC:
            case K_EXECUTE:
            case K_EXPLAIN:
            case K_EXPLICIT:
            case K_EXTENDED:
            case K_EXTRACT:
            case K_ISOLATION:
            case K_FILTER:
            case K_FIRST:
            case K_FALSE:
            case K_FLUSH:
            case K_FOLLOWING:
            case K_FORMAT:
            case K_FULLTEXT:
            case K_FUNCTION:
            case K_GLOBAL:
            case K_GRANT:
            case K_GROUP:
            case K_GROUPING:
            case K_GUARD:
            case K_HASH:
            case K_HISTORY:
            case K_HOPPING:
            case K_IF:
            case K_IIF:
            case K_IGNORE:
            case K_IN:
            case K_INCLUDE:
            case K_INCREMENT:
            case K_INDEX:
            case K_INSERT:
            case K_INTERLEAVE:
            case K_INTERPRET:
            case K_INTERVAL:
            case K_INVALIDATE:
            case K_ISNULL:
            case K_JSON:
            case K_KEEP:
            case K_KEY:
            case K_KEYS:
            case K_FN:
            case K_LAST:
            case K_LEADING:
            case K_LEFT:
            case K_LIMIT:
            case K_LOCAL:
            case K_LOCKED:
            case K_LINK:
            case K_LOG:
            case K_LOOP:
            case K_MATCH:
            case K_MATCHED:
            case K_MATERIALIZED:
            case K_MAX:
            case K_MAXVALUE:
            case K_MEMBER:
            case K_MERGE:
            case K_MIN:
            case K_MINVALUE:
            case K_MODIFY:
            case K_MOVEMENT:
            case K_NEXT:
            case K_NEXTVAL:
            case K_NO:
            case K_NOCACHE:
            case K_NOKEEP:
            case K_NOLOCK:
            case K_NOMAXVALUE:
            case K_NOMINVALUE:
            case K_NOORDER:
            case K_NOTHING:
            case K_NOTNULL:
            case K_NOVALIDATE:
            case K_NULLS:
            case K_NOWAIT:
            case K_OF:
            case K_OFF:
            case K_OFFSET:
            case K_ON:
            case K_OPEN:
            case K_ORDER:
            case K_OVER:
            case K_OVERLAPS:
            case K_OPTIMIZE:
            case K_PARALLEL:
            case K_PARENT:
            case K_PARTITION:
            case K_PATH:
            case K_PERCENT:
            case K_PLACING:
            case K_PRECEDING:
            case K_PRIMARY:
            case K_PRIOR:
            case K_PROCEDURE:
            case K_PUBLIC:
            case K_PURGE:
            case K_QUALIFY:
            case K_QUERY:
            case K_QUICK:
            case K_QUIESCE:
            case K_RANGE:
            case K_RAW:
            case K_READ:
            case K_RECYCLEBIN:
            case K_RECURSIVE:
            case K_REFERENCES:
            case K_REFRESH:
            case K_REGEXP:
            case K_RESPECT:
            case K_RLIKE:
            case K_REGISTER:
            case K_REMOTE:
            case K_RENAME:
            case K_REPEATABLE:
            case K_REPLACE:
            case K_RESET:
            case K_RESTART:
            case K_RESUMABLE:
            case K_RESUME:
            case K_RESTRICT:
            case K_RESTRICTED:
            case K_RETURN:
            case K_RIGHT:
            case K_ROLLBACK:
            case K_ROLLUP:
            case K_ROOT:
            case K_ROW:
            case K_ROWS:
            case K_SAVEPOINT:
            case K_SCHEMA:
            case K_SECURE:
            case K_SEED:
            case K_SEQUENCE:
            case K_SEPARATOR:
            case K_SESSION:
            case K_SET:
            case K_SETS:
            case K_SHOW:
            case K_SHUTDOWN:
            case K_SHARE:
            case K_SIBLINGS:
            case K_SIMILAR:
            case K_SIZE:
            case K_SKIP:
            case K_SOME:
            case K_START:
            case K_STORED:
            case K_STRING:
            case K_STRUCT:
            case K_SUSPEND:
            case K_SWITCH:
            case K_SYNONYM:
            case K_SYSTEM:
            case K_TABLE:
            case K_TABLES:
            case K_TABLESPACE:
            case K_TRIGGER:
            case K_THEN:
            case K_TEMP:
            case K_TEMPORARY:
            case K_TIME_KEY_EXPR:
            case K_TIMEOUT:
            case K_TO:
            case K_TOP:
            case K_TRUNCATE:
            case K_TRUE:
            case K_TUMBLING:
            case K_TYPE:
            case K_UNLOGGED:
            case K_UPDATE:
            case K_UPSERT:
            case K_UNQIESCE:
            case K_USER:
            case K_SIGNED:
            case K_STRING_FUNCTION_NAME:
            case K_UNSIGNED:
            case K_VALIDATE:
            case K_VALUE:
            case K_VALUES:
            case K_VERBOSE:
            case K_VIEW:
            case K_VOLATILE:
            case K_CONCURRENTLY:
            case K_WAIT:
            case K_WITHIN:
            case K_WITHOUT:
            case K_WORK:
            case K_XML:
            case K_XMLAGG:
            case K_XMLDATA:
            case K_XMLSCHEMA:
            case K_XMLTEXT:
            case K_XSINIL:
            case K_YAML:
            case K_YES:
            case K_ZONE:
            case DATA_TYPE:
            case S_IDENTIFIER:
            case S_QUOTED_IDENTIFIER:
            case 429:
            case 430:
            case 431:
            case 432:
            case 433:
            case 434:
            case 435:
            case 436:{
              expr = Column();
              break;
              }
            default:
              jj_la1[333] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
    }
if (expr != null) {
            if (signed) expr = new SignedExpression('-', expr);
            interval.setExpression(expr);
        } else {
            interval.setParameter((signed?"-":"") + token.image);
        }
    if (jj_2_309(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        token = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_DATE_LITERAL:{
        token = jj_consume_token(K_DATE_LITERAL);
        break;
        }
      default:
        jj_la1[334] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
interval.setIntervalType(token.image);
    } else {
      ;
    }
return interval;
}

  final public IntervalExpression IntervalExpressionWithoutInterval(Expression expr) throws ParseException {IntervalExpression interval;
    Token token;
    boolean signed = false;
interval = new IntervalExpression(false);
        interval.setExpression(expr);
    token = jj_consume_token(K_DATE_LITERAL);
interval.setIntervalType(token.image);
        return interval;
}

  final public KeepExpression KeepExpression() throws ParseException {KeepExpression keep = new KeepExpression();
    Token token;
    List<OrderByElement> list;
    jj_consume_token(K_KEEP);
    jj_consume_token(425);
    token = jj_consume_token(S_IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
keep.setFirst(true);
      break;
      }
    case K_LAST:{
      jj_consume_token(K_LAST);
keep.setFirst(false);
      break;
      }
    default:
      jj_la1[335] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    list = OrderByElements();
    jj_consume_token(426);
keep.setName(token.image);
        keep.setOrderByElements(list);
        return keep;
}

  final public void windowFun(AnalyticExpression retval) throws ParseException {ExpressionList expressionList = null;
     boolean partitionByBrackets = false;
     String windowName = null;
     WindowDefinition winDef;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OVER:{
      jj_consume_token(K_OVER);
retval.setType(AnalyticType.OVER);
      break;
      }
    case K_WITHIN:{
      jj_consume_token(K_WITHIN);
      jj_consume_token(K_GROUP);
retval.setType(AnalyticType.WITHIN_GROUP);
      break;
      }
    default:
      jj_la1[336] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALTER:
    case K_ANALYZE:
    case K_APPLY:
    case K_APPROXIMATE:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BASE64:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONNECT:
    case K_CONSTRAINTS:
    case K_CONVERT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATABASE:
    case K_DATA:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GRANT:
    case K_GROUP:
    case K_GUARD:
    case K_HASH:
    case K_HISTORY:
    case K_HOPPING:
    case K_IGNORE:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_INVALIDATE:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_LOOP:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAX:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MIN:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_ON:
    case K_OPEN:
    case K_OVER:
    case K_OVERLAPS:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PURGE:
    case K_QUALIFY:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_RECURSIVE:
    case K_REFERENCES:
    case K_REFRESH:
    case K_REGEXP:
    case K_RESPECT:
    case K_RLIKE:
    case K_REGISTER:
    case K_REMOTE:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_RETURN:
    case K_ROLLBACK:
    case K_ROLLUP:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SECURE:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SHARE:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_START:
    case K_STORED:
    case K_STRING:
    case K_STRUCT:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_VOLATILE:
    case K_CONCURRENTLY:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case DATA_TYPE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 429:
    case 430:
    case 431:
    case 432:
    case 433:
    case 434:
    case 435:
    case 436:{
      windowName = RelObjectName();
retval.setWindowName(windowName);
      break;
      }
    case 425:{
      winDef = windowDefinition();
retval.setWindowDefinition(winDef);
      if (jj_2_311(2)) {
        jj_consume_token(K_OVER);
        jj_consume_token(425);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_PARTITION:{
          jj_consume_token(K_PARTITION);
          jj_consume_token(K_BY);
          if (jj_2_310(2147483647)) {
            expressionList = ComplexExpressionList();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 425:{
              jj_consume_token(425);
partitionByBrackets = true;
              expressionList = ComplexExpressionList();
              jj_consume_token(426);
              break;
              }
            default:
              jj_la1[337] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
          }
        default:
          jj_la1[338] = jj_gen;
          ;
        }
        jj_consume_token(426);
winDef.setPartitionExpressionList(expressionList, partitionByBrackets); retval.setType(AnalyticType.WITHIN_GROUP_OVER);
      } else {
        ;
      }
      break;
      }
    default:
      jj_la1[339] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public WindowDefinition windowDefinition() throws ParseException {ExpressionList expressionList = null;
    List<OrderByElement> olist = null;
    WindowElement windowElement = null;
    boolean partitionByBrackets = false;
    WindowDefinition winDef = new WindowDefinition();
    jj_consume_token(425);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PARTITION:{
      jj_consume_token(K_PARTITION);
      jj_consume_token(K_BY);
      if (jj_2_312(2147483647)) {
        expressionList = ComplexExpressionList();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 425:{
          jj_consume_token(425);
partitionByBrackets = true;
          expressionList = ComplexExpressionList();
          jj_consume_token(426);
          break;
          }
        default:
          jj_la1[340] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[341] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      olist = OrderByElements();
      break;
      }
    default:
      jj_la1[342] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RANGE:
    case K_ROWS:{
      windowElement = WindowElement();
      break;
      }
    default:
      jj_la1[343] = jj_gen;
      ;
    }
winDef.setPartitionExpressionList(expressionList, partitionByBrackets);
        winDef.setOrderByElements(olist);
        winDef.setWindowElement(windowElement);
    jj_consume_token(426);
return winDef;
}

  final public AnalyticExpression AnalyticExpression(Function function) throws ParseException {AnalyticExpression retval = new AnalyticExpression(function);
    Expression filter = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FILTER:{
      jj_consume_token(K_FILTER);
      jj_consume_token(425);
      jj_consume_token(K_WHERE);
retval.setType(AnalyticType.FILTER_ONLY);
      filter = Expression();
      jj_consume_token(426);
      if (jj_2_313(2)) {
        windowFun(retval);
      } else {
        ;
      }
      break;
      }
    case K_OVER:
    case K_WITHIN:{
      windowFun(retval);
      break;
      }
    default:
      jj_la1[344] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
retval.setFilterExpression(filter);
        return retval;
}

  final public WindowElement WindowElement() throws ParseException {WindowElement windowElement = new WindowElement();
    WindowRange range = new WindowRange();
    WindowOffset offset = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROWS:{
      jj_consume_token(K_ROWS);
windowElement.setType(WindowElement.Type.ROWS);
      break;
      }
    case K_RANGE:{
      jj_consume_token(K_RANGE);
windowElement.setType(WindowElement.Type.RANGE);
      break;
      }
    default:
      jj_la1[345] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_BETWEEN:{
      jj_consume_token(K_BETWEEN);
windowElement.setRange(range);
      offset = WindowOffset();
range.setStart(offset);
      jj_consume_token(K_AND);
      offset = WindowOffset();
range.setEnd(offset);
      break;
      }
    default:
      jj_la1[346] = jj_gen;
      if (jj_2_314(1)) {
        offset = WindowOffset();
windowElement.setOffset(offset);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return windowElement;
}

  final public WindowOffset WindowOffset() throws ParseException {WindowOffset offset = new WindowOffset();
    Expression expr = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_UNBOUNDED:{
      jj_consume_token(K_UNBOUNDED);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_PRECEDING:{
        jj_consume_token(K_PRECEDING);
offset.setType(WindowOffset.Type.PRECEDING);
        break;
        }
      case K_FOLLOWING:{
        jj_consume_token(K_FOLLOWING);
offset.setType(WindowOffset.Type.FOLLOWING);
        break;
        }
      default:
        jj_la1[347] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[349] = jj_gen;
      if (jj_2_315(2)) {
        jj_consume_token(K_CURRENT);
        jj_consume_token(K_ROW);
offset.setType(WindowOffset.Type.CURRENT);
      } else if (jj_2_316(1)) {
        expr = SimpleExpression();
offset.setType(WindowOffset.Type.EXPR);
                        offset.setExpression(expr);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_PRECEDING:{
          jj_consume_token(K_PRECEDING);
offset.setType(WindowOffset.Type.PRECEDING);
          break;
          }
        case K_FOLLOWING:{
          jj_consume_token(K_FOLLOWING);
offset.setType(WindowOffset.Type.FOLLOWING);
          break;
          }
        default:
          jj_la1[348] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return offset;
}

  final public ExtractExpression ExtractExpression() throws ParseException {ExtractExpression retval = new ExtractExpression();
    String fieldName = null;
    Token token = null;
    Expression expr = null;
    jj_consume_token(K_EXTRACT);
    jj_consume_token(425);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALTER:
    case K_ANALYZE:
    case K_APPLY:
    case K_APPROXIMATE:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BASE64:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONNECT:
    case K_CONSTRAINTS:
    case K_CONVERT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATABASE:
    case K_DATA:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GRANT:
    case K_GROUP:
    case K_GUARD:
    case K_HASH:
    case K_HISTORY:
    case K_HOPPING:
    case K_IGNORE:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_INVALIDATE:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_LOOP:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAX:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MIN:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_ON:
    case K_OPEN:
    case K_OVER:
    case K_OVERLAPS:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PURGE:
    case K_QUALIFY:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_RECURSIVE:
    case K_REFERENCES:
    case K_REFRESH:
    case K_REGEXP:
    case K_RESPECT:
    case K_RLIKE:
    case K_REGISTER:
    case K_REMOTE:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_RETURN:
    case K_ROLLBACK:
    case K_ROLLUP:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SECURE:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SHARE:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_START:
    case K_STORED:
    case K_STRING:
    case K_STRUCT:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_VOLATILE:
    case K_CONCURRENTLY:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case DATA_TYPE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 429:
    case 430:
    case 431:
    case 432:
    case 433:
    case 434:
    case 435:
    case 436:{
      fieldName = RelObjectName();
retval.setName(fieldName);
      break;
      }
    case S_CHAR_LITERAL:{
      token = jj_consume_token(S_CHAR_LITERAL);
retval.setName(token.image);
      break;
      }
    default:
      jj_la1[350] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_FROM);
    expr = SimpleExpression();
retval.setExpression(expr);
    jj_consume_token(426);
return retval;
}

  final public CastExpression ImplicitCast() throws ParseException {/*@bgen(jjtree) ImplicitCast */
    SimpleNode jjtn000 = new SimpleNode(JJTIMPLICITCAST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));ColDataType colDataType;
    Token tk1;
    Token tk2;

    int precision = -1;
    int scale = -1;
    try {
      colDataType = DataType();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_CHAR_LITERAL:{
        tk2 = jj_consume_token(S_CHAR_LITERAL);
        break;
        }
      case S_LONG:{
        tk2 = jj_consume_token(S_LONG);
        break;
        }
      case S_DOUBLE:{
        tk2 = jj_consume_token(S_DOUBLE);
        break;
        }
      default:
        jj_la1[351] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
CastExpression castExpression = new CastExpression(colDataType, tk2.image);
        return castExpression;
    } catch (Throwable jjte000) {
if (jjtc000) {
         jjtree.clearNodeScope(jjtn000);
         jjtc000 = false;
       } else {
         jjtree.popNode();
       }
       if (jjte000 instanceof RuntimeException) {
         {if (true) throw (RuntimeException)jjte000;}
       }
       if (jjte000 instanceof ParseException) {
         {if (true) throw (ParseException)jjte000;}
       }
       {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
         jjtree.closeNodeScope(jjtn000, true);
         jjtn000.jjtSetLastToken(getToken(0));
       }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public CastExpression CastExpression() throws ParseException {Token keyword;
    CastExpression retval;
    ColumnDefinition columnDefinition;
    ColDataType type;
    Expression expression = null;
    boolean    useCastKeyword;
    Token formatCharLiteral;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CAST:{
      keyword = jj_consume_token(K_CAST);
      break;
      }
    case K_SAFE_CAST:{
      keyword = jj_consume_token(K_SAFE_CAST);
      break;
      }
    case K_TRY_CAST:{
      keyword = jj_consume_token(K_TRY_CAST);
      break;
      }
    case K_INTERPRET:{
      keyword = jj_consume_token(K_INTERPRET);
      break;
      }
    default:
      jj_la1[352] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
retval = new CastExpression(keyword.image);
    jj_consume_token(425);
    expression = SimpleExpression();
    jj_consume_token(K_AS);
retval.setUseCastKeyword(true);
    if (jj_2_317(2)) {
      jj_consume_token(K_ROW);
      jj_consume_token(425);
      columnDefinition = ColumnDefinition();
retval.addColumnDefinition(columnDefinition);
      label_69:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[353] = jj_gen;
          break label_69;
        }
        jj_consume_token(K_COMMA);
        columnDefinition = ColumnDefinition();
retval.addColumnDefinition(columnDefinition);
      }
      jj_consume_token(426);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_BINARY:
      case K_BIT:
      case K_BYTES:
      case K_CHARACTER:
      case K_CHAR:
      case K_DATA:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_INTERVAL:
      case K_JSON:
      case K_PUBLIC:
      case K_SET:
      case K_STRING:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_XML:
      case DT_ZONE:
      case DATA_TYPE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        type = ColDataType();
retval.setColDataType(type);
        break;
        }
      default:
        jj_la1[354] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FORMAT:{
      jj_consume_token(K_FORMAT);
      formatCharLiteral = jj_consume_token(S_CHAR_LITERAL);
retval.setFormat(formatCharLiteral.image);
      break;
      }
    default:
      jj_la1[355] = jj_gen;
      ;
    }
    jj_consume_token(426);
retval.setLeftExpression(expression);
        return retval;
}

  final public Expression CaseWhenExpression() throws ParseException {/*@bgen(jjtree) CaseWhenExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTCASEWHENEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));CaseExpression caseExp = new CaseExpression();
    Expression switchExp = null;
    WhenClause clause;
    List<WhenClause> whenClauses = new ArrayList<WhenClause>();
    Expression elseExp = null;
    try {
      jj_consume_token(K_CASE);
caseCounter++;
      if (jj_2_318(2)) {
        switchExp = Expression();
      } else {
        ;
      }
      label_70:
      while (true) {
        clause = WhenThenSearchCondition();
whenClauses.add(clause);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          ;
          break;
          }
        default:
          jj_la1[356] = jj_gen;
          break label_70;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ELSE:{
        jj_consume_token(K_ELSE);
        if (getAsBoolean(Feature.allowComplexParsing) && !interrupted) {
          elseExp = Expression();
        } else if (jj_2_319(1)) {
          elseExp = SimpleExpression();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[357] = jj_gen;
        ;
      }
      jj_consume_token(K_END);
caseCounter--;
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
caseExp.setSwitchExpression(switchExp);
        caseExp.setWhenClauses(whenClauses);
        caseExp.setElseExpression(elseExp);
        return caseExp;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public WhenClause WhenThenSearchCondition() throws ParseException {WhenClause whenThen = new WhenClause();
    Expression whenExp;
    Expression thenExp;
    jj_consume_token(K_WHEN);
    whenExp = Expression();
    jj_consume_token(K_THEN);
    if (getAsBoolean(Feature.allowComplexParsing) && !interrupted) {
      thenExp = Expression();
    } else if (jj_2_320(1)) {
      thenExp = SimpleExpression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
whenThen.setWhenExpression(whenExp);
       whenThen.setThenExpression(thenExp);
       return whenThen;
}

  final public RowConstructor RowConstructor() throws ParseException {Token token;
    ParenthesedExpressionList expressions;
    token = jj_consume_token(K_ROW);
    expressions = ParenthesedExpressionList();
return new RowConstructor(token.image, expressions);
}

/**
TODO: VariableExpression should be a standalone class with more operations available.
*/
  final public EqualsTo VariableExpression() throws ParseException {Expression left;
    Expression right;
    left = UserVariable();
    jj_consume_token(427);
    right = SimpleExpression();
EqualsTo equals = new EqualsTo();
        equals.setLeftExpression(left);
        equals.setRightExpression(right);
        return equals;
}

  final public Execute Execute() throws ParseException {Token token;
    ObjectNames funcName;
    ExpressionList expressionList = null;
    Execute execute = new Execute();
    List<Expression> namedExprList;
    Expression expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXEC:{
      jj_consume_token(K_EXEC);
execute.setExecType(Execute.ExecType.EXEC);
      break;
      }
    case K_EXECUTE:{
      jj_consume_token(K_EXECUTE);
execute.setExecType(Execute.ExecType.EXECUTE);
      break;
      }
    case K_CALL:{
      jj_consume_token(K_CALL);
execute.setExecType(Execute.ExecType.CALL);
      break;
      }
    default:
      jj_la1[358] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    funcName = RelObjectNames();
execute.setName(funcName.getNames());
    if (jj_2_321(2)) {
      expressionList = ExpressionList();
execute.setExprList(expressionList);
    } else {
      ;
    }
return execute;
}

  final public FullTextSearch FullTextSearch() throws ParseException {Token searchModifier;
    Token againstValue;
    JdbcParameter jdbcParameter;
    JdbcNamedParameter jdbcNamedParameter;
    FullTextSearch fs = new FullTextSearch();
    ExpressionList<Column> matchedColumns;
    jj_consume_token(K_MATCH);
    jj_consume_token(425);
    matchedColumns = ColumnList();
    jj_consume_token(426);
    jj_consume_token(K_AGAINST);
    jj_consume_token(425);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_CHAR_LITERAL:{
      againstValue = jj_consume_token(S_CHAR_LITERAL);
fs.setAgainstValue(new StringValue(againstValue.image));
      break;
      }
    case S_PARAMETER:
    case 438:{
      jdbcParameter = JdbcParameter();
fs.setAgainstValue(  jdbcParameter );
      break;
      }
    case DOUBLE_COLON:
    case 460:{
      jdbcNamedParameter = JdbcNamedParameter();
fs.setAgainstValue(  jdbcNamedParameter );
      break;
      }
    default:
      jj_la1[359] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 477:
    case 478:
    case 479:
    case 480:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 477:{
        searchModifier = jj_consume_token(477);
        break;
        }
      case 478:{
        searchModifier = jj_consume_token(478);
        break;
        }
      case 479:{
        searchModifier = jj_consume_token(479);
        break;
        }
      case 480:{
        searchModifier = jj_consume_token(480);
        break;
        }
      default:
        jj_la1[360] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
fs.setSearchModifier(searchModifier.image);
      break;
      }
    default:
      jj_la1[361] = jj_gen;
      ;
    }
    jj_consume_token(426);
fs.setMatchColumns(matchedColumns);
        return fs;
}

  final public LambdaExpression LambdaExpression() throws ParseException {/*@bgen(jjtree) LambdaExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTLAMBDAEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));String s;
    ArrayList<String> identifiers = new ArrayList<String>();
    Expression expression;
    LambdaExpression lambdaExpression;
    try {
      s = RelObjectName();
identifiers.add(s);
      jj_consume_token(472);
      expression = Expression();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
lambdaExpression = new LambdaExpression(identifiers, expression);
        linkAST(lambdaExpression,jjtn000);
        return lambdaExpression;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Function Function() throws ParseException {/*@bgen(jjtree) Function */
    SimpleNode jjtn000 = new SimpleNode(JJTFUNCTION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Function function;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OPENING_CURLY_BRACKET:{
        jj_consume_token(OPENING_CURLY_BRACKET);
        jj_consume_token(K_FN);
        function = InternalFunction(true);
        jj_consume_token(CLOSING_CURLY_BRACKET);
        break;
        }
      default:
        jj_la1[362] = jj_gen;
        if (jj_2_322(2147483647) && (getAsBoolean(Feature.allowComplexParsing))) {
          function = SimpleFunction();
        } else if (jj_2_323(3)) {
          function = SpecialStringFunctionWithNamedParameters();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ACTIVE:
          case K_ADD:
          case K_ADVANCE:
          case K_ADVISE:
          case K_AGAINST:
          case K_ALGORITHM:
          case K_ALL:
          case K_ALTER:
          case K_ANALYZE:
          case K_ANY:
          case K_APPLY:
          case K_APPROXIMATE:
          case K_ARCHIVE:
          case K_ARRAY_LITERAL:
          case K_AT:
          case K_ASC:
          case K_AUTHORIZATION:
          case K_AUTO:
          case K_BASE64:
          case K_BEGIN:
          case K_BERNOULLI:
          case K_BINARY:
          case K_BIT:
          case K_BLOCK:
          case K_BROWSE:
          case K_BY:
          case K_BYTES:
          case K_CACHE:
          case K_BUFFERS:
          case K_BYTE:
          case K_CALL:
          case K_CASCADE:
          case K_CASE:
          case K_CASEWHEN:
          case K_CAST:
          case K_CHARACTER:
          case K_CHANGE:
          case K_CHANGES:
          case K_CHECKPOINT:
          case K_CHAR:
          case K_CLOSE:
          case K_COLLATE:
          case K_COLUMN:
          case K_COLUMNS:
          case K_COMMIT:
          case K_COMMENT:
          case K_CONFLICT:
          case K_CONNECT:
          case K_CONSTRAINTS:
          case K_CONVERT:
          case K_COSTS:
          case K_CREATE:
          case K_CYCLE:
          case K_DATABASE:
          case K_DATA:
          case K_DECLARE:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_DEFAULT:
          case K_DEFERRABLE:
          case K_DELAYED:
          case K_DELETE:
          case K_DESC:
          case K_DESCRIBE:
          case K_DISABLE:
          case K_DISCONNECT:
          case K_DIV:
          case K_DDL:
          case K_DML:
          case K_DO:
          case K_DOMAIN:
          case K_DROP:
          case K_DUMP:
          case K_DUPLICATE:
          case K_ELEMENTS:
          case K_EMIT:
          case K_ENABLE:
          case K_END:
          case K_ESCAPE:
          case K_EXCLUDE:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_EXPLICIT:
          case K_EXTENDED:
          case K_EXTRACT:
          case K_ISOLATION:
          case K_FILTER:
          case K_FIRST:
          case K_FALSE:
          case K_FLUSH:
          case K_FOLLOWING:
          case K_FORMAT:
          case K_FULLTEXT:
          case K_FUNCTION:
          case K_GLOBAL:
          case K_GRANT:
          case K_GROUP:
          case K_GROUPING:
          case K_GUARD:
          case K_HASH:
          case K_HISTORY:
          case K_HOPPING:
          case K_IF:
          case K_IIF:
          case K_IGNORE:
          case K_IN:
          case K_INCLUDE:
          case K_INCREMENT:
          case K_INDEX:
          case K_INSERT:
          case K_INTERLEAVE:
          case K_INTERPRET:
          case K_INTERVAL:
          case K_INVALIDATE:
          case K_ISNULL:
          case K_JSON:
          case K_KEEP:
          case K_KEY:
          case K_KEYS:
          case K_FN:
          case K_LAST:
          case K_LEADING:
          case K_LEFT:
          case K_LIMIT:
          case K_LOCAL:
          case K_LOCKED:
          case K_LINK:
          case K_LOG:
          case K_LOOP:
          case K_MATCH:
          case K_MATCHED:
          case K_MATERIALIZED:
          case K_MAX:
          case K_MAXVALUE:
          case K_MEMBER:
          case K_MERGE:
          case K_MIN:
          case K_MINVALUE:
          case K_MODIFY:
          case K_MOVEMENT:
          case K_NEXT:
          case K_NEXTVAL:
          case K_NO:
          case K_NOCACHE:
          case K_NOKEEP:
          case K_NOLOCK:
          case K_NOMAXVALUE:
          case K_NOMINVALUE:
          case K_NOORDER:
          case K_NOTHING:
          case K_NOTNULL:
          case K_NOVALIDATE:
          case K_NULLS:
          case K_NOWAIT:
          case K_OF:
          case K_OFF:
          case K_OFFSET:
          case K_ON:
          case K_OPEN:
          case K_ORDER:
          case K_OVER:
          case K_OVERLAPS:
          case K_OPTIMIZE:
          case K_PARALLEL:
          case K_PARENT:
          case K_PARTITION:
          case K_PATH:
          case K_PERCENT:
          case K_PLACING:
          case K_PRECEDING:
          case K_PRIMARY:
          case K_PRIOR:
          case K_PROCEDURE:
          case K_PUBLIC:
          case K_PURGE:
          case K_QUALIFY:
          case K_QUERY:
          case K_QUICK:
          case K_QUIESCE:
          case K_RANGE:
          case K_RAW:
          case K_READ:
          case K_RECYCLEBIN:
          case K_RECURSIVE:
          case K_REFERENCES:
          case K_REFRESH:
          case K_REGEXP:
          case K_RESPECT:
          case K_RLIKE:
          case K_REGISTER:
          case K_REMOTE:
          case K_RENAME:
          case K_REPEATABLE:
          case K_REPLACE:
          case K_RESET:
          case K_RESTART:
          case K_RESUMABLE:
          case K_RESUME:
          case K_RESTRICT:
          case K_RESTRICTED:
          case K_RETURN:
          case K_RIGHT:
          case K_ROLLBACK:
          case K_ROLLUP:
          case K_ROOT:
          case K_ROW:
          case K_ROWS:
          case K_SAVEPOINT:
          case K_SCHEMA:
          case K_SECURE:
          case K_SEED:
          case K_SEQUENCE:
          case K_SEPARATOR:
          case K_SESSION:
          case K_SET:
          case K_SETS:
          case K_SHOW:
          case K_SHUTDOWN:
          case K_SHARE:
          case K_SIBLINGS:
          case K_SIMILAR:
          case K_SIZE:
          case K_SKIP:
          case K_SOME:
          case K_START:
          case K_STORED:
          case K_STRING:
          case K_STRUCT:
          case K_SUSPEND:
          case K_SWITCH:
          case K_SYNONYM:
          case K_SYSTEM:
          case K_TABLE:
          case K_TABLES:
          case K_TABLESPACE:
          case K_TRIGGER:
          case K_THEN:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIME_KEY_EXPR:
          case K_TIMEOUT:
          case K_TO:
          case K_TOP:
          case K_TRUNCATE:
          case K_TRUE:
          case K_TUMBLING:
          case K_TYPE:
          case K_UNLOGGED:
          case K_UPDATE:
          case K_UPSERT:
          case K_UNQIESCE:
          case K_USER:
          case K_SIGNED:
          case K_STRING_FUNCTION_NAME:
          case K_UNSIGNED:
          case K_VALIDATE:
          case K_VALUE:
          case K_VALUES:
          case K_VERBOSE:
          case K_VIEW:
          case K_VOLATILE:
          case K_CONCURRENTLY:
          case K_WAIT:
          case K_WITHIN:
          case K_WITHOUT:
          case K_WORK:
          case K_XML:
          case K_XMLAGG:
          case K_XMLDATA:
          case K_XMLSCHEMA:
          case K_XMLTEXT:
          case K_XSINIL:
          case K_YAML:
          case K_YES:
          case K_ZONE:
          case DATA_TYPE:
          case S_IDENTIFIER:
          case S_QUOTED_IDENTIFIER:
          case 429:
          case 430:
          case 431:
          case 432:
          case 433:
          case 434:
          case 435:
          case 436:{
            function = InternalFunction(false);
            break;
            }
          default:
            jj_la1[363] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(function,jjtn000);
        return function;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Function SpecialStringFunctionWithNamedParameters() throws ParseException {Token funcName;
    NamedExpressionList namedExpressionList = null;
    ExpressionList expressionList = null;
    List<OrderByElement> orderByList;
    funcName = jj_consume_token(K_STRING_FUNCTION_NAME);
    jj_consume_token(425);
    if (jj_2_324(2147483647) && (getAsBoolean(Feature.allowComplexParsing))) {
      namedExpressionList = NamedExpressionListExprFirst();
    } else if (jj_2_325(1)) {
      expressionList = ExpressionList();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(426);
return new Function()
            .withName(funcName.image)
            .withNamedParameters(namedExpressionList)
            .withParameters(expressionList);
}

// a simplified function with only one parameter
// useful for parsing nested functions fast
  final public Function SimpleFunction() throws ParseException {Function function = new Function();
    ObjectNames name;
    Expression expr=null;
    Expression attributeExpression = null;
    Column attributeColumn = null;
    name = RelObjectNames();
    jj_consume_token(425);
    if (jj_2_331(1)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 437:{
        jj_consume_token(437);
expr = new AllColumns();
        break;
        }
      default:
        jj_la1[364] = jj_gen;
        if (jj_2_326(2147483647)) {
          expr = AllTableColumns();
        } else if (jj_2_327(3)) {
          expr = ParenthesedSelect();
        } else if (jj_2_328(2147483647)) {
          expr = SimpleFunction();
        } else if (jj_2_329(2147483647)) {
          expr = RegularCondition();
        } else if (jj_2_330(2147483647)) {
          expr = SimpleExpressionList();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else {
      ;
    }
    jj_consume_token(426);
function.setName(name.getNames());
        if (expr!=null) {
            function.setParameters(expr);
        }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 428:{
      jj_consume_token(428);
      if (jj_2_332(2147483647)) {
        attributeExpression = Function();
function.setAttribute(attributeExpression);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ACTIVE:
        case K_ADD:
        case K_ADVANCE:
        case K_ADVISE:
        case K_AGAINST:
        case K_ALGORITHM:
        case K_ALL:
        case K_ALTER:
        case K_ANALYZE:
        case K_ANY:
        case K_APPLY:
        case K_APPROXIMATE:
        case K_ARCHIVE:
        case K_ARRAY_LITERAL:
        case K_AT:
        case K_ASC:
        case K_AUTHORIZATION:
        case K_AUTO:
        case K_BASE64:
        case K_BEGIN:
        case K_BERNOULLI:
        case K_BINARY:
        case K_BIT:
        case K_BLOCK:
        case K_BROWSE:
        case K_BY:
        case K_BYTES:
        case K_CACHE:
        case K_BUFFERS:
        case K_BYTE:
        case K_CALL:
        case K_CASCADE:
        case K_CASE:
        case K_CASEWHEN:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHANGES:
        case K_CHECKPOINT:
        case K_CHAR:
        case K_CLOSE:
        case K_COLLATE:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CONFLICT:
        case K_CONNECT:
        case K_CONSTRAINTS:
        case K_CONVERT:
        case K_COSTS:
        case K_CREATE:
        case K_CYCLE:
        case K_DATABASE:
        case K_DATA:
        case K_DECLARE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DEFAULT:
        case K_DEFERRABLE:
        case K_DELAYED:
        case K_DELETE:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DISCONNECT:
        case K_DIV:
        case K_DDL:
        case K_DML:
        case K_DO:
        case K_DOMAIN:
        case K_DROP:
        case K_DUMP:
        case K_DUPLICATE:
        case K_ELEMENTS:
        case K_EMIT:
        case K_ENABLE:
        case K_END:
        case K_ESCAPE:
        case K_EXCLUDE:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_EXPLICIT:
        case K_EXTENDED:
        case K_EXTRACT:
        case K_ISOLATION:
        case K_FILTER:
        case K_FIRST:
        case K_FALSE:
        case K_FLUSH:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_FULLTEXT:
        case K_FUNCTION:
        case K_GLOBAL:
        case K_GRANT:
        case K_GROUP:
        case K_GROUPING:
        case K_GUARD:
        case K_HASH:
        case K_HISTORY:
        case K_HOPPING:
        case K_IF:
        case K_IIF:
        case K_IGNORE:
        case K_IN:
        case K_INCLUDE:
        case K_INCREMENT:
        case K_INDEX:
        case K_INSERT:
        case K_INTERLEAVE:
        case K_INTERPRET:
        case K_INTERVAL:
        case K_INVALIDATE:
        case K_ISNULL:
        case K_JSON:
        case K_KEEP:
        case K_KEY:
        case K_KEYS:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LEFT:
        case K_LIMIT:
        case K_LOCAL:
        case K_LOCKED:
        case K_LINK:
        case K_LOG:
        case K_LOOP:
        case K_MATCH:
        case K_MATCHED:
        case K_MATERIALIZED:
        case K_MAX:
        case K_MAXVALUE:
        case K_MEMBER:
        case K_MERGE:
        case K_MIN:
        case K_MINVALUE:
        case K_MODIFY:
        case K_MOVEMENT:
        case K_NEXT:
        case K_NEXTVAL:
        case K_NO:
        case K_NOCACHE:
        case K_NOKEEP:
        case K_NOLOCK:
        case K_NOMAXVALUE:
        case K_NOMINVALUE:
        case K_NOORDER:
        case K_NOTHING:
        case K_NOTNULL:
        case K_NOVALIDATE:
        case K_NULLS:
        case K_NOWAIT:
        case K_OF:
        case K_OFF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OVERLAPS:
        case K_OPTIMIZE:
        case K_PARALLEL:
        case K_PARENT:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PLACING:
        case K_PRECEDING:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_PURGE:
        case K_QUALIFY:
        case K_QUERY:
        case K_QUICK:
        case K_QUIESCE:
        case K_RANGE:
        case K_RAW:
        case K_READ:
        case K_RECYCLEBIN:
        case K_RECURSIVE:
        case K_REFERENCES:
        case K_REFRESH:
        case K_REGEXP:
        case K_RESPECT:
        case K_RLIKE:
        case K_REGISTER:
        case K_REMOTE:
        case K_RENAME:
        case K_REPEATABLE:
        case K_REPLACE:
        case K_RESET:
        case K_RESTART:
        case K_RESUMABLE:
        case K_RESUME:
        case K_RESTRICT:
        case K_RESTRICTED:
        case K_RETURN:
        case K_RIGHT:
        case K_ROLLBACK:
        case K_ROLLUP:
        case K_ROOT:
        case K_ROW:
        case K_ROWS:
        case K_SAVEPOINT:
        case K_SCHEMA:
        case K_SECURE:
        case K_SEED:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SETS:
        case K_SHOW:
        case K_SHUTDOWN:
        case K_SHARE:
        case K_SIBLINGS:
        case K_SIMILAR:
        case K_SIZE:
        case K_SKIP:
        case K_SOME:
        case K_START:
        case K_STORED:
        case K_STRING:
        case K_STRUCT:
        case K_SUSPEND:
        case K_SWITCH:
        case K_SYNONYM:
        case K_SYSTEM:
        case K_TABLE:
        case K_TABLES:
        case K_TABLESPACE:
        case K_TRIGGER:
        case K_THEN:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TUMBLING:
        case K_TYPE:
        case K_UNLOGGED:
        case K_UPDATE:
        case K_UPSERT:
        case K_UNQIESCE:
        case K_USER:
        case K_SIGNED:
        case K_STRING_FUNCTION_NAME:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VERBOSE:
        case K_VIEW:
        case K_VOLATILE:
        case K_CONCURRENTLY:
        case K_WAIT:
        case K_WITHIN:
        case K_WITHOUT:
        case K_WORK:
        case K_XML:
        case K_XMLAGG:
        case K_XMLDATA:
        case K_XMLSCHEMA:
        case K_XMLTEXT:
        case K_XSINIL:
        case K_YAML:
        case K_YES:
        case K_ZONE:
        case DATA_TYPE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:
        case 429:
        case 430:
        case 431:
        case 432:
        case 433:
        case 434:
        case 435:
        case 436:{
          attributeColumn = Column();
function.setAttribute(attributeColumn);
          break;
          }
        default:
          jj_la1[365] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[366] = jj_gen;
      ;
    }
return function;
}

  final public Function InternalFunction(boolean escaped) throws ParseException {Token prefixToken = null;
    Function retval = new Function();
    ObjectNames funcName;
    ExpressionList expressionList = null;
    KeepExpression keep = null;
    Expression expr = null;
    Expression attributeExpression = null;
    Column attributeColumn = null;
    List<OrderByElement> orderByList;
    Limit limit;
    if (jj_2_333(2)) {
      prefixToken = jj_consume_token(K_APPROXIMATE);
    } else {
      ;
    }
    funcName = RelObjectNames();
if (prefixToken!=null) funcName.getNames().add(0, prefixToken.image );
    jj_consume_token(425);
    if (jj_2_336(2)) {
      if (jj_2_334(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DISTINCT:{
          jj_consume_token(K_DISTINCT);
retval.setDistinct(true);
          break;
          }
        case K_ALL:{
          jj_consume_token(K_ALL);
retval.setAllColumns(true);
          break;
          }
        case K_UNIQUE:{
          jj_consume_token(K_UNIQUE);
retval.setUnique(true);
          break;
          }
        default:
          jj_la1[367] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
      if (jj_2_335(3)) {
        expressionList = ExpressionList();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ORDER:{
          orderByList = OrderByElements();
retval.setOrderByElements(orderByList);
          break;
          }
        default:
          jj_la1[368] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:
        case K_VALUE:
        case K_VALUES:
        case K_WITH:
        case 425:{
          expr = Select();
expressionList = new ExpressionList(expr);
          break;
          }
        default:
          jj_la1[369] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_HAVING:{
      jj_consume_token(K_HAVING);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_MIN:{
        jj_consume_token(K_MIN);
        expr = Expression();
retval.setHavingClause( "MIN", expr );
        break;
        }
      case K_MAX:{
        jj_consume_token(K_MAX);
        expr = Expression();
retval.setHavingClause( "MAX", expr );
        break;
        }
      default:
        jj_la1[370] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[371] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IGNORE:
    case K_RESPECT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_IGNORE:{
        jj_consume_token(K_IGNORE);
        jj_consume_token(K_NULLS);
retval.setNullHandling(Function.NullHandling.IGNORE_NULLS);
        break;
        }
      case K_RESPECT:{
        jj_consume_token(K_RESPECT);
        jj_consume_token(K_NULLS);
retval.setNullHandling(Function.NullHandling.RESPECT_NULLS);
        break;
        }
      default:
        jj_la1[372] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[373] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIMIT:{
      limit = PlainLimit();
retval.setLimit(limit);
      break;
      }
    default:
      jj_la1[374] = jj_gen;
      ;
    }
    jj_consume_token(426);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 428:{
      jj_consume_token(428);
      if (jj_2_337(2147483647)) {
        attributeExpression = Function();
retval.setAttribute(attributeExpression);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ACTIVE:
        case K_ADD:
        case K_ADVANCE:
        case K_ADVISE:
        case K_AGAINST:
        case K_ALGORITHM:
        case K_ALL:
        case K_ALTER:
        case K_ANALYZE:
        case K_ANY:
        case K_APPLY:
        case K_APPROXIMATE:
        case K_ARCHIVE:
        case K_ARRAY_LITERAL:
        case K_AT:
        case K_ASC:
        case K_AUTHORIZATION:
        case K_AUTO:
        case K_BASE64:
        case K_BEGIN:
        case K_BERNOULLI:
        case K_BINARY:
        case K_BIT:
        case K_BLOCK:
        case K_BROWSE:
        case K_BY:
        case K_BYTES:
        case K_CACHE:
        case K_BUFFERS:
        case K_BYTE:
        case K_CALL:
        case K_CASCADE:
        case K_CASE:
        case K_CASEWHEN:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHANGES:
        case K_CHECKPOINT:
        case K_CHAR:
        case K_CLOSE:
        case K_COLLATE:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CONFLICT:
        case K_CONNECT:
        case K_CONSTRAINTS:
        case K_CONVERT:
        case K_COSTS:
        case K_CREATE:
        case K_CYCLE:
        case K_DATABASE:
        case K_DATA:
        case K_DECLARE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DEFAULT:
        case K_DEFERRABLE:
        case K_DELAYED:
        case K_DELETE:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DISCONNECT:
        case K_DIV:
        case K_DDL:
        case K_DML:
        case K_DO:
        case K_DOMAIN:
        case K_DROP:
        case K_DUMP:
        case K_DUPLICATE:
        case K_ELEMENTS:
        case K_EMIT:
        case K_ENABLE:
        case K_END:
        case K_ESCAPE:
        case K_EXCLUDE:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_EXPLICIT:
        case K_EXTENDED:
        case K_EXTRACT:
        case K_ISOLATION:
        case K_FILTER:
        case K_FIRST:
        case K_FALSE:
        case K_FLUSH:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_FULLTEXT:
        case K_FUNCTION:
        case K_GLOBAL:
        case K_GRANT:
        case K_GROUP:
        case K_GROUPING:
        case K_GUARD:
        case K_HASH:
        case K_HISTORY:
        case K_HOPPING:
        case K_IF:
        case K_IIF:
        case K_IGNORE:
        case K_IN:
        case K_INCLUDE:
        case K_INCREMENT:
        case K_INDEX:
        case K_INSERT:
        case K_INTERLEAVE:
        case K_INTERPRET:
        case K_INTERVAL:
        case K_INVALIDATE:
        case K_ISNULL:
        case K_JSON:
        case K_KEEP:
        case K_KEY:
        case K_KEYS:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LEFT:
        case K_LIMIT:
        case K_LOCAL:
        case K_LOCKED:
        case K_LINK:
        case K_LOG:
        case K_LOOP:
        case K_MATCH:
        case K_MATCHED:
        case K_MATERIALIZED:
        case K_MAX:
        case K_MAXVALUE:
        case K_MEMBER:
        case K_MERGE:
        case K_MIN:
        case K_MINVALUE:
        case K_MODIFY:
        case K_MOVEMENT:
        case K_NEXT:
        case K_NEXTVAL:
        case K_NO:
        case K_NOCACHE:
        case K_NOKEEP:
        case K_NOLOCK:
        case K_NOMAXVALUE:
        case K_NOMINVALUE:
        case K_NOORDER:
        case K_NOTHING:
        case K_NOTNULL:
        case K_NOVALIDATE:
        case K_NULLS:
        case K_NOWAIT:
        case K_OF:
        case K_OFF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OVERLAPS:
        case K_OPTIMIZE:
        case K_PARALLEL:
        case K_PARENT:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PLACING:
        case K_PRECEDING:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_PURGE:
        case K_QUALIFY:
        case K_QUERY:
        case K_QUICK:
        case K_QUIESCE:
        case K_RANGE:
        case K_RAW:
        case K_READ:
        case K_RECYCLEBIN:
        case K_RECURSIVE:
        case K_REFERENCES:
        case K_REFRESH:
        case K_REGEXP:
        case K_RESPECT:
        case K_RLIKE:
        case K_REGISTER:
        case K_REMOTE:
        case K_RENAME:
        case K_REPEATABLE:
        case K_REPLACE:
        case K_RESET:
        case K_RESTART:
        case K_RESUMABLE:
        case K_RESUME:
        case K_RESTRICT:
        case K_RESTRICTED:
        case K_RETURN:
        case K_RIGHT:
        case K_ROLLBACK:
        case K_ROLLUP:
        case K_ROOT:
        case K_ROW:
        case K_ROWS:
        case K_SAVEPOINT:
        case K_SCHEMA:
        case K_SECURE:
        case K_SEED:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SETS:
        case K_SHOW:
        case K_SHUTDOWN:
        case K_SHARE:
        case K_SIBLINGS:
        case K_SIMILAR:
        case K_SIZE:
        case K_SKIP:
        case K_SOME:
        case K_START:
        case K_STORED:
        case K_STRING:
        case K_STRUCT:
        case K_SUSPEND:
        case K_SWITCH:
        case K_SYNONYM:
        case K_SYSTEM:
        case K_TABLE:
        case K_TABLES:
        case K_TABLESPACE:
        case K_TRIGGER:
        case K_THEN:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TUMBLING:
        case K_TYPE:
        case K_UNLOGGED:
        case K_UPDATE:
        case K_UPSERT:
        case K_UNQIESCE:
        case K_USER:
        case K_SIGNED:
        case K_STRING_FUNCTION_NAME:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VERBOSE:
        case K_VIEW:
        case K_VOLATILE:
        case K_CONCURRENTLY:
        case K_WAIT:
        case K_WITHIN:
        case K_WITHOUT:
        case K_WORK:
        case K_XML:
        case K_XMLAGG:
        case K_XMLDATA:
        case K_XMLSCHEMA:
        case K_XMLTEXT:
        case K_XSINIL:
        case K_YAML:
        case K_YES:
        case K_ZONE:
        case DATA_TYPE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:
        case 429:
        case 430:
        case 431:
        case 432:
        case 433:
        case 434:
        case 435:
        case 436:{
          attributeColumn = Column();
retval.setAttribute(attributeColumn);
          break;
          }
        default:
          jj_la1[375] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[376] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IGNORE:
    case K_RESPECT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_IGNORE:{
        jj_consume_token(K_IGNORE);
        jj_consume_token(K_NULLS);
retval.setNullHandling(Function.NullHandling.IGNORE_NULLS);
                retval.setIgnoreNullsOutside(true);
        break;
        }
      case K_RESPECT:{
        jj_consume_token(K_RESPECT);
        jj_consume_token(K_NULLS);
retval.setNullHandling(Function.NullHandling.RESPECT_NULLS);
                retval.setIgnoreNullsOutside(true);
        break;
        }
      default:
        jj_la1[377] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[378] = jj_gen;
      ;
    }
    if (jj_2_338(2)) {
      keep = KeepExpression();
    } else {
      ;
    }
retval.setEscaped(escaped);
        retval.setParameters(expressionList);
        retval.setName(funcName.getNames());
        retval.setKeep(keep);
        return retval;
}

  final public XMLSerializeExpr XMLSerializeExpr() throws ParseException {XMLSerializeExpr result;
   Expression expression;
   List<OrderByElement> orderByElements = null;
   ColDataType dataType;
    jj_consume_token(K_XMLSERIALIZE);
    jj_consume_token(425);
    jj_consume_token(K_XMLAGG);
    jj_consume_token(425);
    jj_consume_token(K_XMLTEXT);
    jj_consume_token(425);
    expression = SimpleExpression();
    jj_consume_token(426);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
      break;
      }
    default:
      jj_la1[379] = jj_gen;
      ;
    }
    jj_consume_token(426);
    jj_consume_token(K_AS);
    dataType = ColDataType();
    jj_consume_token(426);
result = new XMLSerializeExpr();
        result.setExpression(expression);
        result.setOrderByElements(orderByElements);
        result.setDataType(dataType);
        return result;
}

  final public MySQLGroupConcat MySQLGroupConcat() throws ParseException {MySQLGroupConcat retval = new MySQLGroupConcat();
    ExpressionList expressionList = null;
    List<OrderByElement> orderByList = null;
    Token t;
    jj_consume_token(K_GROUP_CONCAT);
    jj_consume_token(425);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DISTINCT:{
      jj_consume_token(K_DISTINCT);
retval.setDistinct(true);
      break;
      }
    default:
      jj_la1[380] = jj_gen;
      ;
    }
    expressionList = ExpressionList();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByList = OrderByElements();
retval.setOrderByElements(orderByList);
      break;
      }
    default:
      jj_la1[381] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SEPARATOR:{
      jj_consume_token(K_SEPARATOR);
      t = jj_consume_token(S_CHAR_LITERAL);
retval.setSeparator(t.image);
      break;
      }
    default:
      jj_la1[382] = jj_gen;
      ;
    }
    jj_consume_token(426);
retval.setExpressionList(expressionList);
        return retval;
}

  final public TableFunction TableFunction() throws ParseException {Token prefix = null;
    Function function;
    TableFunction functionItem;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LATERAL:{
      prefix = jj_consume_token(K_LATERAL);
      break;
      }
    default:
      jj_la1[383] = jj_gen;
      ;
    }
    function = Function();
return  prefix!=null
            ? new TableFunction(prefix.image, function)
            : new TableFunction(function);
}

  final public List<Index.ColumnParams> ColumnNamesWithParamsList() throws ParseException {List<Index.ColumnParams> colNames = new ArrayList<Index.ColumnParams>();
    String columnName;
    List<String> parameter = null;
    jj_consume_token(425);
    columnName = RelObjectName();
parameter = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_ASC:
    case K_BINARY:
    case K_BY:
    case K_CASCADE:
    case K_CHARACTER:
    case K_CHECK:
    case K_COLLATE:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONSTRAINT:
    case K_DEFAULT:
    case K_DELETE:
    case K_DESC:
    case K_DROP:
    case K_EXCLUDE:
    case K_FIRST:
    case K_FALSE:
    case K_FOREIGN:
    case K_HASH:
    case K_IN:
    case K_KEY:
    case K_LAST:
    case K_NEXTVAL:
    case K_NOT:
    case K_NULL:
    case K_ON:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PRIMARY:
    case K_RAW:
    case K_REFERENCES:
    case K_ROWS:
    case K_START:
    case K_STORED:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TRUE:
    case K_TYPE:
    case K_UNIQUE:
    case K_UPDATE:
    case K_USING:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_WHERE:
    case K_WITH:
    case S_DOUBLE:
    case S_LONG:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 425:
    case 427:
    case 440:
    case 454:
    case 471:{
      parameter = CreateParameter();
      break;
      }
    default:
      jj_la1[384] = jj_gen;
      ;
    }
colNames.add(new Index.ColumnParams(columnName,parameter));
    label_71:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[385] = jj_gen;
        break label_71;
      }
      jj_consume_token(K_COMMA);
      columnName = RelObjectName();
parameter = null;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_AS:
      case K_ASC:
      case K_BINARY:
      case K_BY:
      case K_CASCADE:
      case K_CHARACTER:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_DROP:
      case K_EXCLUDE:
      case K_FIRST:
      case K_FALSE:
      case K_FOREIGN:
      case K_HASH:
      case K_IN:
      case K_KEY:
      case K_LAST:
      case K_NEXTVAL:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PRIMARY:
      case K_RAW:
      case K_REFERENCES:
      case K_ROWS:
      case K_START:
      case K_STORED:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 425:
      case 427:
      case 440:
      case 454:
      case 471:{
        parameter = CreateParameter();
        break;
        }
      default:
        jj_la1[386] = jj_gen;
        ;
      }
colNames.add(new Index.ColumnParams(columnName,parameter));
    }
    jj_consume_token(426);
return colNames;
}

  final public Index Index() throws ParseException {ObjectNames name;
    name = RelObjectNames();
return new Index().withName(name.getNames()).withType("");
}

  final public CreateIndex CreateIndex() throws ParseException {CreateIndex createIndex = new CreateIndex();
    Table table = null;
    List<Index.ColumnParams> colNames;
    Token using;
    Index index = null;
    List<String> parameter = new ArrayList<String>();
    List<String> tailParameters = new ArrayList<String>();
    List<String> name;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_ASC:
    case K_BINARY:
    case K_BY:
    case K_CASCADE:
    case K_CHARACTER:
    case K_CHECK:
    case K_COLLATE:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONSTRAINT:
    case K_DEFAULT:
    case K_DELETE:
    case K_DESC:
    case K_DROP:
    case K_EXCLUDE:
    case K_FIRST:
    case K_FALSE:
    case K_FOREIGN:
    case K_HASH:
    case K_IN:
    case K_KEY:
    case K_LAST:
    case K_NEXTVAL:
    case K_NOT:
    case K_NULL:
    case K_ON:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PRIMARY:
    case K_RAW:
    case K_REFERENCES:
    case K_ROWS:
    case K_START:
    case K_STORED:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TRUE:
    case K_TYPE:
    case K_UNIQUE:
    case K_UPDATE:
    case K_USING:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_WHERE:
    case K_WITH:
    case S_DOUBLE:
    case S_LONG:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 425:
    case 427:
    case 440:
    case 454:
    case 471:{
      parameter = CreateParameter();
      break;
      }
    default:
      jj_la1[387] = jj_gen;
      ;
    }
    jj_consume_token(K_INDEX);
    if (jj_2_339(2)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_NOT);
      jj_consume_token(K_EXISTS);
createIndex.setUsingIfNotExists(true);
    } else {
      ;
    }
    index = Index();
index.setType(parameter.isEmpty() ? null : parameter.get(0));
    if (jj_2_340(3)) {
      jj_consume_token(K_ON);
      table = Table();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_USING:{
        jj_consume_token(K_USING);
        using = jj_consume_token(S_IDENTIFIER);
index.setUsing(using.image);
        break;
        }
      default:
        jj_la1[388] = jj_gen;
        ;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ON:
      case K_USING:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_USING:{
          jj_consume_token(K_USING);
          using = jj_consume_token(S_IDENTIFIER);
index.setUsing(using.image);
                    createIndex.setIndexTypeBeforeOn(true);
          break;
          }
        default:
          jj_la1[389] = jj_gen;
          ;
        }
        jj_consume_token(K_ON);
        table = Table();
        break;
        }
      default:
        jj_la1[390] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    colNames = ColumnNamesWithParamsList();
    label_72:
    while (true) {
      if (jj_2_341(2)) {
        ;
      } else {
        break label_72;
      }
      parameter = CreateParameter();
tailParameters.addAll(parameter);
    }
index.setColumns(colNames);
        createIndex.setIndex(index);
        createIndex.setTable(table);
        createIndex.setTailParameters(tailParameters);
        return createIndex;
}

  final public ColumnDefinition ColumnDefinition() throws ParseException {ColumnDefinition coldef;
    String columnName;
    ColDataType colDataType;
    List<String> columnSpecs = new ArrayList<String>();
    List<String> parameter;
    columnName = RelObjectName();
    colDataType = ColDataType();
    label_73:
    while (true) {
      if (jj_2_342(2)) {
        ;
      } else {
        break label_73;
      }
      parameter = CreateParameter();
columnSpecs.addAll(parameter);
    }
coldef = new ColumnDefinition();
        coldef.setColumnName(columnName);
        coldef.setColDataType(colDataType);
        if (columnSpecs.size() > 0)
            coldef.setColumnSpecs(columnSpecs);
        return coldef;
}

  final public CreateSchema CreateSchema() throws ParseException {Token tk = null;
    CreateTable table = null;
    CreateView view = null;
    CreateSchema schema = new CreateSchema();
    //schema.setSchemaName(System.getProperty("user.name"));
    //schema.setAuthorization(System.getProperty("user.name"));
    List<String> schemaPath = null;
    List<Statement> statements = new ArrayList<Statement>();
    jj_consume_token(K_SCHEMA);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[391] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
schema.setSchemaName(tk.image);
      break;
      }
    default:
      jj_la1[392] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AUTHORIZATION:{
      jj_consume_token(K_AUTHORIZATION);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[393] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
schema.setAuthorization(tk.image);
      break;
      }
    default:
      jj_la1[394] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PATH:{
      schemaPath = PathSpecification();
schema.setSchemaPath(schemaPath);
      break;
      }
    default:
      jj_la1[395] = jj_gen;
      ;
    }
    label_74:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CREATE:
      case K_FORCE:
      case K_MATERIALIZED:
      case K_NO:
      case K_SECURE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_VIEW:
      case K_VOLATILE:{
        ;
        break;
        }
      default:
        jj_la1[396] = jj_gen;
        break label_74;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CREATE:{
        jj_consume_token(K_CREATE);
        table = CreateTable(false);
table.getTable().setSchemaName(schema.getSchemaName());
            schema.addStatement(table);
        break;
        }
      case K_FORCE:
      case K_MATERIALIZED:
      case K_NO:
      case K_SECURE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_VIEW:
      case K_VOLATILE:{
        view = CreateView(false);
view.getView().setSchemaName(schema.getSchemaName());
            schema.addStatement(view);
        break;
        }
      default:
        jj_la1[397] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return schema;
}

  final public List<String> PathSpecification() throws ParseException {Token tk;
    List<String> pathList = new ArrayList<String>();
    jj_consume_token(K_PATH);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      tk = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    default:
      jj_la1[398] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
pathList.add(tk.image);
    label_75:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[399] = jj_gen;
        break label_75;
      }
      jj_consume_token(K_COMMA);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[400] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
pathList.add(tk.image);
    }
return pathList;
}

  final public CreateTable CreateTable(boolean isUsingOrReplace) throws ParseException {CreateTable createTable = new CreateTable();
    Table table = null;
    List<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();
    List<String> columnSpecs = null;
    List<String> tableOptions = new ArrayList<String>();
    List<String> createOptions = new ArrayList<String>();
    String columnName;
    Token tk = null;
    Token tk2 = null;
    Token tk3 = null;
    String sk3 = null;
    ColDataType colDataType = null;
    String stringList = null;
    ColumnDefinition coldef = null;
    List<Index> indexes = new ArrayList<Index>();
    List<Index.ColumnParams> colNames = null;
    List<String> colNames2 = null;
    Index index = null;
    ForeignKeyIndex fkIndex = null;
    List<String> parameter = new ArrayList<String>();
    List<String> idxSpec = new ArrayList<String>();
    Table fkTable = null;
    SpannerInterleaveIn interleaveIn = null;
    Select select = null;
    Table likeTable = null;
    CheckConstraint checkCs = null;
    ExcludeConstraint excludeC = null;
    RowMovement rowMovement = null;
    ReferentialAction.Action action = null;
    String tableColumn = null;
    List<String> columns = new ArrayList<String>();
createTable.setOrReplace(isUsingOrReplace);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_UNLOGGED:{
      jj_consume_token(K_UNLOGGED);
createTable.setUnlogged(true);
      break;
      }
    default:
      jj_la1[401] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_GLOBAL:{
      tk = jj_consume_token(K_GLOBAL);
createOptions.add(tk.image);
      break;
      }
    default:
      jj_la1[402] = jj_gen;
      ;
    }
    label_76:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_AS:
      case K_ASC:
      case K_BINARY:
      case K_BY:
      case K_CASCADE:
      case K_CHARACTER:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_DROP:
      case K_EXCLUDE:
      case K_FIRST:
      case K_FALSE:
      case K_FOREIGN:
      case K_HASH:
      case K_IN:
      case K_KEY:
      case K_LAST:
      case K_NEXTVAL:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PRIMARY:
      case K_RAW:
      case K_REFERENCES:
      case K_ROWS:
      case K_START:
      case K_STORED:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 425:
      case 427:
      case 440:
      case 454:
      case 471:{
        ;
        break;
        }
      default:
        jj_la1[403] = jj_gen;
        break label_76;
      }
      parameter = CreateParameter();
createOptions.addAll(parameter);
    }
    jj_consume_token(K_TABLE);
    if (jj_2_343(2)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_NOT);
      jj_consume_token(K_EXISTS);
createTable.setIfNotExists(true);
    } else {
      ;
    }
    table = Table();
    if (jj_2_353(2)) {
      if (jj_2_352(3)) {
        jj_consume_token(425);
        tableColumn = RelObjectName();
columns.add(tableColumn);
        label_77:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[404] = jj_gen;
            break label_77;
          }
          jj_consume_token(K_COMMA);
          tableColumn = RelObjectName();
columns.add(tableColumn);
        }
        jj_consume_token(426);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 425:{
          jj_consume_token(425);
          coldef = ColumnDefinition();
columnDefinitions.add(coldef);
          label_78:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[405] = jj_gen;
              break label_78;
            }
            jj_consume_token(K_COMMA);
            if (jj_2_346(3)) {
              tk = jj_consume_token(K_INDEX);
              sk3 = RelObjectName();
              /* colNames=ColumnsNamesList() */
                                          colNames = ColumnNamesWithParamsList();
idxSpec.clear();
              label_79:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_ARRAY_LITERAL:
                case K_AS:
                case K_ASC:
                case K_BINARY:
                case K_BY:
                case K_CASCADE:
                case K_CHARACTER:
                case K_CHECK:
                case K_COLLATE:
                case K_COMMIT:
                case K_COMMENT:
                case K_CONSTRAINT:
                case K_DEFAULT:
                case K_DELETE:
                case K_DESC:
                case K_DROP:
                case K_EXCLUDE:
                case K_FIRST:
                case K_FALSE:
                case K_FOREIGN:
                case K_HASH:
                case K_IN:
                case K_KEY:
                case K_LAST:
                case K_NEXTVAL:
                case K_NOT:
                case K_NULL:
                case K_ON:
                case K_PARALLEL:
                case K_PARTITION:
                case K_PRIMARY:
                case K_RAW:
                case K_REFERENCES:
                case K_ROWS:
                case K_START:
                case K_STORED:
                case K_TABLESPACE:
                case K_TEMP:
                case K_TEMPORARY:
                case K_TIME_KEY_EXPR:
                case K_TRUE:
                case K_TYPE:
                case K_UNIQUE:
                case K_UPDATE:
                case K_USING:
                case K_SIGNED:
                case K_UNSIGNED:
                case K_WHERE:
                case K_WITH:
                case S_DOUBLE:
                case S_LONG:
                case S_IDENTIFIER:
                case S_CHAR_LITERAL:
                case S_QUOTED_IDENTIFIER:
                case 425:
                case 427:
                case 440:
                case 454:
                case 471:{
                  ;
                  break;
                  }
                default:
                  jj_la1[406] = jj_gen;
                  break label_79;
                }
                parameter = CreateParameter();
idxSpec.addAll(parameter);
              }
index = new Index().withType(tk.image).withName(sk3).withColumns(colNames).withIndexSpec(new ArrayList<String>(idxSpec));
                                indexes.add(index);
            } else if (jj_2_347(3)) {
index = new NamedConstraint();
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CONSTRAINT:{
                jj_consume_token(K_CONSTRAINT);
                sk3 = RelObjectName();
index.setName(sk3);
                break;
                }
              default:
                jj_la1[407] = jj_gen;
                ;
              }
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_PRIMARY:{
                tk = jj_consume_token(K_PRIMARY);
                tk2 = jj_consume_token(K_KEY);
index.setType(tk.image + " " + tk2.image);
                break;
                }
              case K_UNIQUE:{
                tk = jj_consume_token(K_UNIQUE);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_KEY:{
                  tk2 = jj_consume_token(K_KEY);
                  break;
                  }
                default:
                  jj_la1[408] = jj_gen;
                  ;
                }
index.setType(tk.image + (tk2!=null?" " + tk2.image:""));
                break;
                }
              default:
                jj_la1[409] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              /* colNames=ColumnsNamesList() */
                                          colNames = ColumnNamesWithParamsList();
idxSpec.clear();
              label_80:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_ARRAY_LITERAL:
                case K_AS:
                case K_ASC:
                case K_BINARY:
                case K_BY:
                case K_CASCADE:
                case K_CHARACTER:
                case K_CHECK:
                case K_COLLATE:
                case K_COMMIT:
                case K_COMMENT:
                case K_CONSTRAINT:
                case K_DEFAULT:
                case K_DELETE:
                case K_DESC:
                case K_DROP:
                case K_EXCLUDE:
                case K_FIRST:
                case K_FALSE:
                case K_FOREIGN:
                case K_HASH:
                case K_IN:
                case K_KEY:
                case K_LAST:
                case K_NEXTVAL:
                case K_NOT:
                case K_NULL:
                case K_ON:
                case K_PARALLEL:
                case K_PARTITION:
                case K_PRIMARY:
                case K_RAW:
                case K_REFERENCES:
                case K_ROWS:
                case K_START:
                case K_STORED:
                case K_TABLESPACE:
                case K_TEMP:
                case K_TEMPORARY:
                case K_TIME_KEY_EXPR:
                case K_TRUE:
                case K_TYPE:
                case K_UNIQUE:
                case K_UPDATE:
                case K_USING:
                case K_SIGNED:
                case K_UNSIGNED:
                case K_WHERE:
                case K_WITH:
                case S_DOUBLE:
                case S_LONG:
                case S_IDENTIFIER:
                case S_CHAR_LITERAL:
                case S_QUOTED_IDENTIFIER:
                case 425:
                case 427:
                case 440:
                case 454:
                case 471:{
                  ;
                  break;
                  }
                default:
                  jj_la1[410] = jj_gen;
                  break label_80;
                }
                parameter = CreateParameter();
idxSpec.addAll(parameter);
              }
index.withColumns(colNames).withIndexSpec(new ArrayList<String>(idxSpec));
                                indexes.add(index);
tk2=null;
            } else if (jj_2_348(3)) {
tk=null;
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_UNIQUE:{
                tk = jj_consume_token(K_UNIQUE);
                break;
                }
              default:
                jj_la1[411] = jj_gen;
                ;
              }
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_FULLTEXT:{
                tk3 = jj_consume_token(K_FULLTEXT);
                break;
                }
              default:
                jj_la1[412] = jj_gen;
                ;
              }
              tk2 = jj_consume_token(K_KEY);
              sk3 = RelObjectName();
              /* colNames=ColumnsNamesList() */
                                          colNames = ColumnNamesWithParamsList();
idxSpec.clear();
              label_81:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_ARRAY_LITERAL:
                case K_AS:
                case K_ASC:
                case K_BINARY:
                case K_BY:
                case K_CASCADE:
                case K_CHARACTER:
                case K_CHECK:
                case K_COLLATE:
                case K_COMMIT:
                case K_COMMENT:
                case K_CONSTRAINT:
                case K_DEFAULT:
                case K_DELETE:
                case K_DESC:
                case K_DROP:
                case K_EXCLUDE:
                case K_FIRST:
                case K_FALSE:
                case K_FOREIGN:
                case K_HASH:
                case K_IN:
                case K_KEY:
                case K_LAST:
                case K_NEXTVAL:
                case K_NOT:
                case K_NULL:
                case K_ON:
                case K_PARALLEL:
                case K_PARTITION:
                case K_PRIMARY:
                case K_RAW:
                case K_REFERENCES:
                case K_ROWS:
                case K_START:
                case K_STORED:
                case K_TABLESPACE:
                case K_TEMP:
                case K_TEMPORARY:
                case K_TIME_KEY_EXPR:
                case K_TRUE:
                case K_TYPE:
                case K_UNIQUE:
                case K_UPDATE:
                case K_USING:
                case K_SIGNED:
                case K_UNSIGNED:
                case K_WHERE:
                case K_WITH:
                case S_DOUBLE:
                case S_LONG:
                case S_IDENTIFIER:
                case S_CHAR_LITERAL:
                case S_QUOTED_IDENTIFIER:
                case 425:
                case 427:
                case 440:
                case 454:
                case 471:{
                  ;
                  break;
                  }
                default:
                  jj_la1[413] = jj_gen;
                  break label_81;
                }
                parameter = CreateParameter();
idxSpec.addAll(parameter);
              }
index = new Index()
                                .withType((tk!=null?tk.image + " ":"") + (tk3!=null?tk3.image + " ":"") + tk2.image)
                                .withName(sk3)
                                .withColumns(colNames)
                                .withIndexSpec(new ArrayList<String>(idxSpec));
                                indexes.add(index);
            } else if (jj_2_349(3)) {
fkIndex = new ForeignKeyIndex();
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CONSTRAINT:{
                jj_consume_token(K_CONSTRAINT);
                sk3 = RelObjectName();
fkIndex.setName(sk3);
                break;
                }
              default:
                jj_la1[414] = jj_gen;
                ;
              }
              tk = jj_consume_token(K_FOREIGN);
              tk2 = jj_consume_token(K_KEY);
              /* colNames=ColumnsNamesList() */
                                          colNames = ColumnNamesWithParamsList();
fkIndex.withType(tk.image + " " + tk2.image).withColumns(colNames);
              jj_consume_token(K_REFERENCES);
              fkTable = Table();
              colNames2 = ColumnsNamesList();
fkIndex.setTable(fkTable);
                                fkIndex.setReferencedColumnNames(colNames2);
                                indexes.add(fkIndex);
              if (jj_2_344(2)) {
                jj_consume_token(K_ON);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_DELETE:{
                  tk = jj_consume_token(K_DELETE);
                  break;
                  }
                case K_UPDATE:{
                  tk = jj_consume_token(K_UPDATE);
                  break;
                  }
                default:
                  jj_la1[415] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
                action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.from(tk.image), action);
              } else {
                ;
              }
              if (jj_2_345(2)) {
                jj_consume_token(K_ON);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_DELETE:{
                  tk = jj_consume_token(K_DELETE);
                  break;
                  }
                case K_UPDATE:{
                  tk = jj_consume_token(K_UPDATE);
                  break;
                  }
                default:
                  jj_la1[416] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
                action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.from(tk.image), action);
              } else {
                ;
              }
            } else if (jj_2_350(3)) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CONSTRAINT:{
                jj_consume_token(K_CONSTRAINT);
                sk3 = RelObjectName();
                break;
                }
              default:
                jj_la1[417] = jj_gen;
                ;
              }
Expression exp = null;
              jj_consume_token(K_CHECK);
              label_82:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case 425:{
                  ;
                  break;
                  }
                default:
                  jj_la1[418] = jj_gen;
                  break label_82;
                }
                jj_consume_token(425);
                exp = Expression();
                jj_consume_token(426);
              }
checkCs = new CheckConstraint().withName(sk3).withExpression(exp);
                           indexes.add(checkCs);
            } else if (jj_2_351(2)) {
              tk = jj_consume_token(K_EXCLUDE);
excludeC = new ExcludeConstraint(); Expression exp = null;
              tk2 = jj_consume_token(K_WHERE);
              label_83:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case 425:{
                  ;
                  break;
                  }
                default:
                  jj_la1[419] = jj_gen;
                  break label_83;
                }
                jj_consume_token(425);
                exp = Expression();
                jj_consume_token(426);
              }
excludeC.setExpression(exp);
indexes.add(excludeC);
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_ACTION:
              case K_ACTIVE:
              case K_ADD:
              case K_ADVANCE:
              case K_ADVISE:
              case K_AGAINST:
              case K_ALGORITHM:
              case K_ALTER:
              case K_ANALYZE:
              case K_APPLY:
              case K_APPROXIMATE:
              case K_ARCHIVE:
              case K_ARRAY_LITERAL:
              case K_AT:
              case K_ASC:
              case K_AUTHORIZATION:
              case K_AUTO:
              case K_BASE64:
              case K_BEGIN:
              case K_BERNOULLI:
              case K_BINARY:
              case K_BIT:
              case K_BLOCK:
              case K_BROWSE:
              case K_BY:
              case K_BYTES:
              case K_CACHE:
              case K_BUFFERS:
              case K_BYTE:
              case K_CALL:
              case K_CASCADE:
              case K_CASE:
              case K_CAST:
              case K_CHARACTER:
              case K_CHANGE:
              case K_CHANGES:
              case K_CHECKPOINT:
              case K_CHAR:
              case K_CLOSE:
              case K_COLLATE:
              case K_COLUMN:
              case K_COLUMNS:
              case K_COMMIT:
              case K_COMMENT:
              case K_CONFLICT:
              case K_CONNECT:
              case K_CONSTRAINTS:
              case K_CONVERT:
              case K_COSTS:
              case K_CREATE:
              case K_CYCLE:
              case K_DATABASE:
              case K_DATA:
              case K_DECLARE:
              case K_DATETIMELITERAL:
              case K_DATE_LITERAL:
              case K_DEFAULT:
              case K_DEFERRABLE:
              case K_DELAYED:
              case K_DELETE:
              case K_DESC:
              case K_DESCRIBE:
              case K_DISABLE:
              case K_DISCONNECT:
              case K_DIV:
              case K_DDL:
              case K_DML:
              case K_DO:
              case K_DOMAIN:
              case K_DROP:
              case K_DUMP:
              case K_DUPLICATE:
              case K_ELEMENTS:
              case K_EMIT:
              case K_ENABLE:
              case K_END:
              case K_ESCAPE:
              case K_EXCLUDE:
              case K_EXEC:
              case K_EXECUTE:
              case K_EXPLAIN:
              case K_EXPLICIT:
              case K_EXTENDED:
              case K_EXTRACT:
              case K_ISOLATION:
              case K_FILTER:
              case K_FIRST:
              case K_FALSE:
              case K_FLUSH:
              case K_FOLLOWING:
              case K_FORMAT:
              case K_FULLTEXT:
              case K_FUNCTION:
              case K_GRANT:
              case K_GROUP:
              case K_GUARD:
              case K_HASH:
              case K_HISTORY:
              case K_HOPPING:
              case K_IGNORE:
              case K_INCLUDE:
              case K_INCREMENT:
              case K_INDEX:
              case K_INSERT:
              case K_INTERLEAVE:
              case K_INTERPRET:
              case K_INTERVAL:
              case K_INVALIDATE:
              case K_ISNULL:
              case K_JSON:
              case K_KEEP:
              case K_KEY:
              case K_KEYS:
              case K_FN:
              case K_LAST:
              case K_LEADING:
              case K_LOCAL:
              case K_LOCKED:
              case K_LINK:
              case K_LOG:
              case K_LOOP:
              case K_MATCH:
              case K_MATCHED:
              case K_MATERIALIZED:
              case K_MAX:
              case K_MAXVALUE:
              case K_MEMBER:
              case K_MERGE:
              case K_MIN:
              case K_MINVALUE:
              case K_MODIFY:
              case K_MOVEMENT:
              case K_NEXT:
              case K_NO:
              case K_NOCACHE:
              case K_NOKEEP:
              case K_NOLOCK:
              case K_NOMAXVALUE:
              case K_NOMINVALUE:
              case K_NOORDER:
              case K_NOTHING:
              case K_NOTNULL:
              case K_NOVALIDATE:
              case K_NULLS:
              case K_NOWAIT:
              case K_OF:
              case K_OFF:
              case K_ON:
              case K_OPEN:
              case K_OVER:
              case K_OVERLAPS:
              case K_PARALLEL:
              case K_PARENT:
              case K_PARTITION:
              case K_PATH:
              case K_PERCENT:
              case K_PLACING:
              case K_PRECEDING:
              case K_PRIMARY:
              case K_PRIOR:
              case K_PURGE:
              case K_QUALIFY:
              case K_QUERY:
              case K_QUICK:
              case K_QUIESCE:
              case K_RANGE:
              case K_RAW:
              case K_READ:
              case K_RECYCLEBIN:
              case K_RECURSIVE:
              case K_REFERENCES:
              case K_REFRESH:
              case K_REGEXP:
              case K_RESPECT:
              case K_RLIKE:
              case K_REGISTER:
              case K_REMOTE:
              case K_RENAME:
              case K_REPEATABLE:
              case K_REPLACE:
              case K_RESET:
              case K_RESTART:
              case K_RESUMABLE:
              case K_RESUME:
              case K_RESTRICT:
              case K_RESTRICTED:
              case K_RETURN:
              case K_ROLLBACK:
              case K_ROLLUP:
              case K_ROOT:
              case K_ROW:
              case K_ROWS:
              case K_SAVEPOINT:
              case K_SCHEMA:
              case K_SECURE:
              case K_SEED:
              case K_SEQUENCE:
              case K_SEPARATOR:
              case K_SESSION:
              case K_SETS:
              case K_SHOW:
              case K_SHUTDOWN:
              case K_SHARE:
              case K_SIBLINGS:
              case K_SIMILAR:
              case K_SIZE:
              case K_SKIP:
              case K_START:
              case K_STORED:
              case K_STRING:
              case K_STRUCT:
              case K_SUSPEND:
              case K_SWITCH:
              case K_SYNONYM:
              case K_SYSTEM:
              case K_TABLE:
              case K_TABLES:
              case K_TABLESPACE:
              case K_TRIGGER:
              case K_THEN:
              case K_TEMP:
              case K_TEMPORARY:
              case K_TIME_KEY_EXPR:
              case K_TIMEOUT:
              case K_TO:
              case K_TOP:
              case K_TRUNCATE:
              case K_TRUE:
              case K_TUMBLING:
              case K_TYPE:
              case K_UNLOGGED:
              case K_UPDATE:
              case K_UPSERT:
              case K_UNQIESCE:
              case K_USER:
              case K_SIGNED:
              case K_STRING_FUNCTION_NAME:
              case K_UNSIGNED:
              case K_VALIDATE:
              case K_VALUE:
              case K_VALUES:
              case K_VERBOSE:
              case K_VIEW:
              case K_VOLATILE:
              case K_CONCURRENTLY:
              case K_WAIT:
              case K_WITHIN:
              case K_WITHOUT:
              case K_WORK:
              case K_XML:
              case K_XMLAGG:
              case K_XMLDATA:
              case K_XMLSCHEMA:
              case K_XMLTEXT:
              case K_XSINIL:
              case K_YAML:
              case K_YES:
              case K_ZONE:
              case DATA_TYPE:
              case S_IDENTIFIER:
              case S_QUOTED_IDENTIFIER:
              case 429:
              case 430:
              case 431:
              case 432:
              case 433:
              case 434:
              case 435:
              case 436:{
                coldef = ColumnDefinition();
columnDefinitions.add(coldef);
                break;
                }
              default:
                jj_la1[420] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
          jj_consume_token(426);
          break;
          }
        default:
          jj_la1[421] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else {
      ;
    }
    label_84:
    while (true) {
      if (jj_2_354(2) && (getToken(1).kind != K_AS)) {
        ;
      } else {
        break label_84;
      }
      parameter = CreateParameter();
tableOptions.addAll(parameter);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DISABLE:
    case K_ENABLE:{
      rowMovement = RowMovement();
createTable.setRowMovement(rowMovement);
      break;
      }
    default:
      jj_la1[422] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:{
      jj_consume_token(K_AS);
      select = Select();
createTable.setSelect(select, false);
      break;
      }
    default:
      jj_la1[423] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIKE:{
      jj_consume_token(K_LIKE);
      if (jj_2_355(2147483647)) {
        jj_consume_token(425);
        likeTable = Table();
createTable.setLikeTable(likeTable, true);
        jj_consume_token(426);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ACTIVE:
        case K_ADD:
        case K_ADVANCE:
        case K_ADVISE:
        case K_AGAINST:
        case K_ALGORITHM:
        case K_ALL:
        case K_ALTER:
        case K_ANALYZE:
        case K_ANY:
        case K_APPLY:
        case K_APPROXIMATE:
        case K_ARCHIVE:
        case K_ARRAY_LITERAL:
        case K_AT:
        case K_ASC:
        case K_AUTHORIZATION:
        case K_AUTO:
        case K_BASE64:
        case K_BEGIN:
        case K_BERNOULLI:
        case K_BINARY:
        case K_BIT:
        case K_BLOCK:
        case K_BROWSE:
        case K_BY:
        case K_BYTES:
        case K_CACHE:
        case K_BUFFERS:
        case K_BYTE:
        case K_CALL:
        case K_CASCADE:
        case K_CASE:
        case K_CASEWHEN:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHANGES:
        case K_CHECKPOINT:
        case K_CHAR:
        case K_CLOSE:
        case K_COLLATE:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CONFLICT:
        case K_CONNECT:
        case K_CONSTRAINTS:
        case K_CONVERT:
        case K_COSTS:
        case K_CREATE:
        case K_CYCLE:
        case K_DATABASE:
        case K_DATA:
        case K_DECLARE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DEFAULT:
        case K_DEFERRABLE:
        case K_DELAYED:
        case K_DELETE:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DISCONNECT:
        case K_DIV:
        case K_DDL:
        case K_DML:
        case K_DO:
        case K_DOMAIN:
        case K_DROP:
        case K_DUMP:
        case K_DUPLICATE:
        case K_ELEMENTS:
        case K_EMIT:
        case K_ENABLE:
        case K_END:
        case K_ESCAPE:
        case K_EXCLUDE:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_EXPLICIT:
        case K_EXTENDED:
        case K_EXTRACT:
        case K_ISOLATION:
        case K_FILTER:
        case K_FIRST:
        case K_FALSE:
        case K_FLUSH:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_FULLTEXT:
        case K_FUNCTION:
        case K_GLOBAL:
        case K_GRANT:
        case K_GROUP:
        case K_GROUPING:
        case K_GUARD:
        case K_HASH:
        case K_HISTORY:
        case K_HOPPING:
        case K_IF:
        case K_IIF:
        case K_IGNORE:
        case K_IN:
        case K_INCLUDE:
        case K_INCREMENT:
        case K_INDEX:
        case K_INSERT:
        case K_INTERLEAVE:
        case K_INTERPRET:
        case K_INTERVAL:
        case K_INVALIDATE:
        case K_ISNULL:
        case K_JSON:
        case K_KEEP:
        case K_KEY:
        case K_KEYS:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LEFT:
        case K_LIMIT:
        case K_LOCAL:
        case K_LOCKED:
        case K_LINK:
        case K_LOG:
        case K_LOOP:
        case K_MATCH:
        case K_MATCHED:
        case K_MATERIALIZED:
        case K_MAX:
        case K_MAXVALUE:
        case K_MEMBER:
        case K_MERGE:
        case K_MIN:
        case K_MINVALUE:
        case K_MODIFY:
        case K_MOVEMENT:
        case K_NEXT:
        case K_NEXTVAL:
        case K_NO:
        case K_NOCACHE:
        case K_NOKEEP:
        case K_NOLOCK:
        case K_NOMAXVALUE:
        case K_NOMINVALUE:
        case K_NOORDER:
        case K_NOTHING:
        case K_NOTNULL:
        case K_NOVALIDATE:
        case K_NULLS:
        case K_NOWAIT:
        case K_OF:
        case K_OFF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OVERLAPS:
        case K_OPTIMIZE:
        case K_PARALLEL:
        case K_PARENT:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PLACING:
        case K_PRECEDING:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_PURGE:
        case K_QUALIFY:
        case K_QUERY:
        case K_QUICK:
        case K_QUIESCE:
        case K_RANGE:
        case K_RAW:
        case K_READ:
        case K_RECYCLEBIN:
        case K_RECURSIVE:
        case K_REFERENCES:
        case K_REFRESH:
        case K_REGEXP:
        case K_RESPECT:
        case K_RLIKE:
        case K_REGISTER:
        case K_REMOTE:
        case K_RENAME:
        case K_REPEATABLE:
        case K_REPLACE:
        case K_RESET:
        case K_RESTART:
        case K_RESUMABLE:
        case K_RESUME:
        case K_RESTRICT:
        case K_RESTRICTED:
        case K_RETURN:
        case K_RIGHT:
        case K_ROLLBACK:
        case K_ROLLUP:
        case K_ROOT:
        case K_ROW:
        case K_ROWS:
        case K_SAVEPOINT:
        case K_SCHEMA:
        case K_SECURE:
        case K_SEED:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SETS:
        case K_SHOW:
        case K_SHUTDOWN:
        case K_SHARE:
        case K_SIBLINGS:
        case K_SIMILAR:
        case K_SIZE:
        case K_SKIP:
        case K_SOME:
        case K_START:
        case K_STORED:
        case K_STRING:
        case K_STRUCT:
        case K_SUSPEND:
        case K_SWITCH:
        case K_SYNONYM:
        case K_SYSTEM:
        case K_TABLE:
        case K_TABLES:
        case K_TABLESPACE:
        case K_TRIGGER:
        case K_THEN:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TUMBLING:
        case K_TYPE:
        case K_UNLOGGED:
        case K_UPDATE:
        case K_UPSERT:
        case K_UNQIESCE:
        case K_USER:
        case K_SIGNED:
        case K_STRING_FUNCTION_NAME:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VERBOSE:
        case K_VIEW:
        case K_VOLATILE:
        case K_CONCURRENTLY:
        case K_WAIT:
        case K_WITHIN:
        case K_WITHOUT:
        case K_WORK:
        case K_XML:
        case K_XMLAGG:
        case K_XMLDATA:
        case K_XMLSCHEMA:
        case K_XMLTEXT:
        case K_XSINIL:
        case K_YAML:
        case K_YES:
        case K_ZONE:
        case DATA_TYPE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:
        case 429:
        case 430:
        case 431:
        case 432:
        case 433:
        case 434:
        case 435:
        case 436:{
          likeTable = Table();
createTable.setLikeTable(likeTable, false);
          break;
          }
        default:
          jj_la1[424] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[425] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_COMMA:{
      jj_consume_token(K_COMMA);
      interleaveIn = SpannerInterleaveIn();
createTable.setSpannerInterleaveIn(interleaveIn);
      break;
      }
    default:
      jj_la1[426] = jj_gen;
      ;
    }
createTable.setTable(table);
        if (indexes.size() > 0)
            createTable.setIndexes(indexes);
        if (createOptions.size() > 0)
            createTable.setCreateOptionsStrings(createOptions);
        if (tableOptions.size() > 0)
            createTable.setTableOptionsStrings(tableOptions);
        if (columnDefinitions.size() > 0)
            createTable.setColumnDefinitions(columnDefinitions);
        if (columns.size() > 0)
            createTable.setColumns(columns);
        return createTable;
}

  final public SpannerInterleaveIn SpannerInterleaveIn() throws ParseException {Table table = null;
    SpannerInterleaveIn.OnDelete action = null;
    jj_consume_token(K_INTERLEAVE);
    jj_consume_token(K_IN);
    jj_consume_token(K_PARENT);
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ON:{
      jj_consume_token(K_ON);
      jj_consume_token(K_DELETE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NO:{
        jj_consume_token(K_NO);
        jj_consume_token(K_ACTION);
action = SpannerInterleaveIn.OnDelete.NO_ACTION;
        break;
        }
      case K_CASCADE:{
        jj_consume_token(K_CASCADE);
action = SpannerInterleaveIn.OnDelete.CASCADE;
        break;
        }
      default:
        jj_la1[427] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[428] = jj_gen;
      ;
    }
return new SpannerInterleaveIn(table, action);
}

  final public ColDataType DataType() throws ParseException {ColDataType colDataType = new ColDataType();
    Token prefix = null;
    Token tk = null;
    Token tk2 = null;
    String schema;
    String type="";
    List<String> argumentsStringList = new ArrayList<String>();
    List<Integer> array = new ArrayList<Integer>();
    List<String> name;
    ColDataType arrayType;

    int precision = -1;
    int scale = -1;
    if (jj_2_359(2)) {
      tk = jj_consume_token(K_ARRAY_LITERAL);
      jj_consume_token(442);
      arrayType = ColDataType();
      jj_consume_token(441);
colDataType.setDataType("ARRAY<" + arrayType.getDataType() + ">");
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_BINARY:
      case K_BIT:
      case K_BYTES:
      case K_CHARACTER:
      case K_CHAR:
      case K_DATETIMELITERAL:
      case K_JSON:
      case K_STRING:
      case K_SIGNED:
      case K_UNSIGNED:
      case DT_ZONE:
      case DATA_TYPE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DATETIMELITERAL:{
          tk = jj_consume_token(K_DATETIMELITERAL);
          break;
          }
        case DT_ZONE:{
          tk = jj_consume_token(DT_ZONE);
          break;
          }
        case DATA_TYPE:{
          tk = jj_consume_token(DATA_TYPE);
          break;
          }
        case K_SIGNED:{
          tk = jj_consume_token(K_SIGNED);
          break;
          }
        case K_UNSIGNED:{
          tk = jj_consume_token(K_UNSIGNED);
          break;
          }
        case K_CHARACTER:{
          tk = jj_consume_token(K_CHARACTER);
          break;
          }
        case K_BIT:{
          tk = jj_consume_token(K_BIT);
          break;
          }
        case K_BYTES:{
          tk = jj_consume_token(K_BYTES);
          break;
          }
        case K_BINARY:{
          tk = jj_consume_token(K_BINARY);
          break;
          }
        case K_CHAR:{
          tk = jj_consume_token(K_CHAR);
          break;
          }
        case K_JSON:{
          tk = jj_consume_token(K_JSON);
          break;
          }
        case K_STRING:{
          tk = jj_consume_token(K_STRING);
          break;
          }
        default:
          jj_la1[429] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
type = tk.image;
        if (jj_2_357(2)) {
          label_85:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case DATA_TYPE:{
              tk = jj_consume_token(DATA_TYPE);
              break;
              }
            case K_SIGNED:{
              tk = jj_consume_token(K_SIGNED);
              break;
              }
            case K_UNSIGNED:{
              tk = jj_consume_token(K_UNSIGNED);
              break;
              }
            case K_CHARACTER:{
              tk = jj_consume_token(K_CHARACTER);
              break;
              }
            case K_BIT:{
              tk = jj_consume_token(K_BIT);
              break;
              }
            case K_BYTES:{
              tk = jj_consume_token(K_BYTES);
              break;
              }
            case K_BINARY:{
              tk = jj_consume_token(K_BINARY);
              break;
              }
            case K_CHAR:{
              tk = jj_consume_token(K_CHAR);
              break;
              }
            case K_JSON:{
              tk = jj_consume_token(K_JSON);
              break;
              }
            case K_STRING:{
              tk = jj_consume_token(K_STRING);
              break;
              }
            default:
              jj_la1[430] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
type += " " + tk.image;
            if (jj_2_356(2)) {
              ;
            } else {
              break label_85;
            }
          }
        } else {
          ;
        }
        if (jj_2_358(2)) {
          jj_consume_token(425);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_LONG:{
            tk = jj_consume_token(S_LONG);
precision = Integer.valueOf(tk.image);
            break;
            }
          case K_MAX:{
            tk = jj_consume_token(K_MAX);
precision = Integer.MAX_VALUE;
            break;
            }
          default:
            jj_la1[431] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            jj_consume_token(K_COMMA);
            tk = jj_consume_token(S_LONG);
scale = Integer.valueOf(tk.image);
            break;
            }
          default:
            jj_la1[432] = jj_gen;
            ;
          }
          jj_consume_token(426);
        } else {
          ;
        }
colDataType = new ColDataType(type, precision, scale);
        break;
        }
      default:
        jj_la1[433] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return colDataType;
}

  final public ColDataType ColDataType() throws ParseException {ColDataType colDataType = new ColDataType();
    Token prefix = null;
    Token tk = null;
    Token tk2 = null;
    String schema;
    String type="";
    List<String> argumentsStringList = new ArrayList<String>();
    List<Integer> array = new ArrayList<Integer>();
    List<String> name;
    ColDataType arrayType;

    int precision = -1;
    int scale = -1;
    if (jj_2_360(2)) {
      colDataType = DataType();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_BINARY:
      case K_CHAR:
      case K_DATA:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_INTERVAL:
      case K_JSON:
      case K_PUBLIC:
      case K_SET:
      case K_STRING:
      case K_XML:
      case DT_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        case K_DATETIMELITERAL:{
          tk = jj_consume_token(K_DATETIMELITERAL);
          break;
          }
        case K_DATE_LITERAL:{
          tk = jj_consume_token(K_DATE_LITERAL);
          break;
          }
        case K_XML:{
          tk = jj_consume_token(K_XML);
          break;
          }
        case K_INTERVAL:{
          tk = jj_consume_token(K_INTERVAL);
          break;
          }
        case DT_ZONE:{
          tk = jj_consume_token(DT_ZONE);
          break;
          }
        case K_CHAR:{
          tk = jj_consume_token(K_CHAR);
          break;
          }
        case K_SET:{
          tk = jj_consume_token(K_SET);
          break;
          }
        case K_BINARY:{
          tk = jj_consume_token(K_BINARY);
          break;
          }
        case K_JSON:{
          tk = jj_consume_token(K_JSON);
          break;
          }
        case K_STRING:{
          tk = jj_consume_token(K_STRING);
          break;
          }
        case K_PUBLIC:{
          tk = jj_consume_token(K_PUBLIC);
          break;
          }
        case K_DATA:{
          tk = jj_consume_token(K_DATA);
          break;
          }
        default:
          jj_la1[434] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
schema = tk.image;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 428:{
          jj_consume_token(428);
          arrayType = ColDataType();
schema += "." + arrayType.toString();
          break;
          }
        default:
          jj_la1[435] = jj_gen;
          ;
        }
colDataType.setDataType(schema);
        break;
        }
      default:
        jj_la1[436] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    if (jj_2_362(2)) {
      jj_consume_token(425);
tk2 =null;
      label_86:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CHAR:
        case K_MAX:
        case S_LONG:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:{
          ;
          break;
          }
        default:
          jj_la1[437] = jj_gen;
          break label_86;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_MAX:
        case S_LONG:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_LONG:{
            tk = jj_consume_token(S_LONG);
            break;
            }
          case K_MAX:{
            tk = jj_consume_token(K_MAX);
            break;
            }
          default:
            jj_la1[438] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          if (jj_2_361(2)) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_BYTE:{
              tk2 = jj_consume_token(K_BYTE);
              break;
              }
            case K_CHAR:{
              tk2 = jj_consume_token(K_CHAR);
              break;
              }
            default:
              jj_la1[439] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          } else {
            ;
          }
          break;
          }
        case S_CHAR_LITERAL:{
          tk = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case K_CHAR:{
          tk = jj_consume_token(K_CHAR);
          break;
          }
        default:
          jj_la1[440] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
argumentsStringList.add(tk.image + (tk2!=null?" " + tk2.image:""));
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          jj_consume_token(K_COMMA);
          break;
          }
        default:
          jj_la1[441] = jj_gen;
          ;
        }
      }
      jj_consume_token(426);
    } else {
      ;
    }
    if (jj_2_364(2)) {
      label_87:
      while (true) {
        jj_consume_token(466);
tk=null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          tk = jj_consume_token(S_LONG);
          break;
          }
        default:
          jj_la1[442] = jj_gen;
          ;
        }
array.add(tk!=null?Integer.valueOf(tk.image):null);
        jj_consume_token(467);
        if (jj_2_363(2)) {
          ;
        } else {
          break label_87;
        }
      }
colDataType.setArrayData(array);
    } else {
      ;
    }
    if (jj_2_365(2)) {
      jj_consume_token(K_CHARACTER);
      jj_consume_token(K_SET);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_BINARY:{
        tk = jj_consume_token(K_BINARY);
        break;
        }
      default:
        jj_la1[443] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
colDataType.setCharacterSet(tk.image);
    } else {
      ;
    }
if (argumentsStringList.size() > 0)
            colDataType.setArgumentsStringList(argumentsStringList);
        return colDataType;
}

  final public Analyze Analyze() throws ParseException {Analyze analyze = new Analyze();
    Table table = null;
    jj_consume_token(K_ANALYZE);
    table = Table();
analyze.setTable(table);
        return analyze;
}

  final public ExpressionList<Column> ColumnWithCommentList() throws ParseException {ExpressionList<Column> expressions = new ExpressionList<Column>();
    Column img = null;
    jj_consume_token(425);
    img = Column();
expressions.add(img);
    label_88:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[444] = jj_gen;
        break label_88;
      }
      jj_consume_token(K_COMMA);
      img = Column();
expressions.add(img);
    }
    jj_consume_token(426);
return expressions;
}

  final public CreateView CreateView(boolean isUsingOrReplace) throws ParseException {CreateView createView = new CreateView();
    Table view = null;
    Select select = null;
    ExpressionList<Column> columnNames = null;
    Token tk = null;
    List<String> commentTokens = null;
createView.setOrReplace(isUsingOrReplace);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FORCE:
    case K_NO:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NO:{
        jj_consume_token(K_NO);
        jj_consume_token(K_FORCE);
createView.setForce(ForceOption.NO_FORCE);
        break;
        }
      case K_FORCE:{
        jj_consume_token(K_FORCE);
createView.setForce(ForceOption.FORCE);
        break;
        }
      default:
        jj_la1[445] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[446] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SECURE:{
      jj_consume_token(K_SECURE);
createView.setSecure(true);
      break;
      }
    default:
      jj_la1[447] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TEMP:
    case K_TEMPORARY:
    case K_VOLATILE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TEMP:{
        jj_consume_token(K_TEMP);
createView.setTemporary(TemporaryOption.TEMP);
        break;
        }
      case K_TEMPORARY:{
        jj_consume_token(K_TEMPORARY);
createView.setTemporary(TemporaryOption.TEMPORARY);
        break;
        }
      case K_VOLATILE:{
        jj_consume_token(K_VOLATILE);
createView.setTemporary(TemporaryOption.VOLATILE);
        break;
        }
      default:
        jj_la1[448] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[449] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_MATERIALIZED:{
      jj_consume_token(K_MATERIALIZED);
createView.setMaterialized(true);
      break;
      }
    default:
      jj_la1[450] = jj_gen;
      ;
    }
    jj_consume_token(K_VIEW);
    view = Table();
createView.setView(view);
    if (jj_2_366(3)) {
      jj_consume_token(K_AUTO);
      jj_consume_token(K_REFRESH);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_YES:{
        tk = jj_consume_token(K_YES);
        break;
        }
      case K_NO:{
        tk = jj_consume_token(K_NO);
        break;
        }
      default:
        jj_la1[451] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
createView.setAutoRefresh(AutoRefreshOption.from(tk.image));
    } else {
      ;
    }
    if (jj_2_367(3)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_NOT);
      jj_consume_token(K_EXISTS);
createView.setIfNotExists(true);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 425:{
      columnNames = ColumnWithCommentList();
createView.setColumnNames(columnNames);
      break;
      }
    default:
      jj_la1[452] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_COMMENT:{
      commentTokens = CreateViewTailComment();
createView.setViewCommentOptions(commentTokens);
      break;
      }
    default:
      jj_la1[453] = jj_gen;
      ;
    }
    jj_consume_token(K_AS);
    select = Select();
createView.setSelect(select);
    if (jj_2_368(2)) {
      jj_consume_token(K_WITH);
      jj_consume_token(K_READ);
      jj_consume_token(K_ONLY);
createView.setWithReadOnly(true);
    } else {
      ;
    }
return createView;
}

  final public List<String> CreateViewTailComment() throws ParseException {Token tk = null;
    Token tk2 = null;
    String op = null;
    List<String> result = new ArrayList<String>();
    tk = jj_consume_token(K_COMMENT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 427:{
      jj_consume_token(427);
op = "=";
      break;
      }
    default:
      jj_la1[454] = jj_gen;
      ;
    }
    tk2 = jj_consume_token(S_CHAR_LITERAL);
result.add("");
         result.add(tk.image);
         if (op != null) {
             result.add(op);
         }
         result.add(tk2.image);
return result;
}

  final public ReferentialAction.Action Action() throws ParseException {ReferentialAction.Action action = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CASCADE:{
      jj_consume_token(K_CASCADE);
action=ReferentialAction.Action.CASCADE;
      break;
      }
    case K_RESTRICT:{
      jj_consume_token(K_RESTRICT);
action=ReferentialAction.Action.RESTRICT;
      break;
      }
    case K_NO:{
      jj_consume_token(K_NO);
      jj_consume_token(K_ACTION);
action=ReferentialAction.Action.NO_ACTION;
      break;
      }
    case K_SET:{
      jj_consume_token(K_SET);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NULL:{
        jj_consume_token(K_NULL);
action=ReferentialAction.Action.SET_NULL;
        break;
        }
      case K_DEFAULT:{
        jj_consume_token(K_DEFAULT);
action=ReferentialAction.Action.SET_DEFAULT;
        break;
        }
      default:
        jj_la1[455] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[456] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return action;
}

  final public AlterView AlterView(boolean useReplace) throws ParseException {AlterView alterView = new AlterView();
    Table view = null;
    Select select = null;
    List<String> columnNames = null;
    jj_consume_token(K_VIEW);
    view = Table();
alterView.setView(view); alterView.setUseReplace(useReplace);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 425:{
      columnNames = ColumnsNamesList();
alterView.setColumnNames(columnNames);
      break;
      }
    default:
      jj_la1[457] = jj_gen;
      ;
    }
    jj_consume_token(K_AS);
    select = Select();
alterView.setSelect(select);
        return alterView;
}

  final public List<String> CreateParameter() throws ParseException {String retval = "";
    Token tk = null, tk2 = null;
    Expression exp = null;
    ColDataType colDataType;
    List<String> param = new ArrayList<String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NEXTVAL:{
      jj_consume_token(K_NEXTVAL);
      jj_consume_token(425);
      tk = jj_consume_token(S_CHAR_LITERAL);
      jj_consume_token(471);
      colDataType = ColDataType();
      jj_consume_token(426);
param.add("NextVal( " + tk.image + "::" + colDataType + ")" );
      break;
      }
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[458] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
retval+=tk.image;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 428:{
        jj_consume_token(428);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk2 = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[459] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
retval+="."+tk2.image;
        break;
        }
      default:
        jj_la1[460] = jj_gen;
        ;
      }
param.add(retval);
      break;
      }
    default:
      jj_la1[467] = jj_gen;
      if (jj_2_370(3)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_USING:{
          jj_consume_token(K_USING);
          jj_consume_token(K_INDEX);
param.add("USING INDEX");
          break;
          }
        default:
          jj_la1[461] = jj_gen;
          ;
        }
        jj_consume_token(K_TABLESPACE);
        retval = RelObjectName();
param.add("TABLESPACE " + retval);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ASC:
        case K_BINARY:
        case K_BY:
        case K_CASCADE:
        case K_COLLATE:
        case K_COMMIT:
        case K_COMMENT:
        case K_CONSTRAINT:
        case K_DELETE:
        case K_DESC:
        case K_DROP:
        case K_EXCLUDE:
        case K_FIRST:
        case K_FALSE:
        case K_FOREIGN:
        case K_HASH:
        case K_IN:
        case K_KEY:
        case K_LAST:
        case K_NOT:
        case K_NULL:
        case K_ON:
        case K_PARALLEL:
        case K_PARTITION:
        case K_PRIMARY:
        case K_RAW:
        case K_REFERENCES:
        case K_ROWS:
        case K_START:
        case K_STORED:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TRUE:
        case K_TYPE:
        case K_UNIQUE:
        case K_UPDATE:
        case K_USING:
        case K_SIGNED:
        case K_UNSIGNED:
        case K_WHERE:
        case K_WITH:
        case S_CHAR_LITERAL:
        case 427:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_CHAR_LITERAL:{
            tk = jj_consume_token(S_CHAR_LITERAL);
            break;
            }
          case K_NULL:{
            tk = jj_consume_token(K_NULL);
            break;
            }
          case K_NOT:{
            tk = jj_consume_token(K_NOT);
            break;
            }
          case K_PRIMARY:{
            tk = jj_consume_token(K_PRIMARY);
            break;
            }
          case K_FOREIGN:{
            tk = jj_consume_token(K_FOREIGN);
            break;
            }
          case K_REFERENCES:{
            tk = jj_consume_token(K_REFERENCES);
            break;
            }
          case K_KEY:{
            tk = jj_consume_token(K_KEY);
            break;
            }
          case K_STORED:{
            tk = jj_consume_token(K_STORED);
            break;
            }
          case K_ON:{
            tk = jj_consume_token(K_ON);
            break;
            }
          case K_COMMIT:{
            tk = jj_consume_token(K_COMMIT);
            break;
            }
          case K_DROP:{
            tk = jj_consume_token(K_DROP);
            break;
            }
          case K_ROWS:{
            tk = jj_consume_token(K_ROWS);
            break;
            }
          case K_UNIQUE:{
            tk = jj_consume_token(K_UNIQUE);
            break;
            }
          case K_CASCADE:{
            tk = jj_consume_token(K_CASCADE);
            break;
            }
          case K_DELETE:{
            tk = jj_consume_token(K_DELETE);
            break;
            }
          case K_UPDATE:{
            tk = jj_consume_token(K_UPDATE);
            break;
            }
          case K_CONSTRAINT:{
            tk = jj_consume_token(K_CONSTRAINT);
            break;
            }
          case K_WITH:{
            tk = jj_consume_token(K_WITH);
            break;
            }
          case K_EXCLUDE:{
            tk = jj_consume_token(K_EXCLUDE);
            break;
            }
          case K_WHERE:{
            tk = jj_consume_token(K_WHERE);
            break;
            }
          case K_TEMP:{
            tk = jj_consume_token(K_TEMP);
            break;
            }
          case K_TEMPORARY:{
            tk = jj_consume_token(K_TEMPORARY);
            break;
            }
          case K_PARTITION:{
            tk = jj_consume_token(K_PARTITION);
            break;
            }
          case K_BY:{
            tk = jj_consume_token(K_BY);
            break;
            }
          case K_IN:{
            tk = jj_consume_token(K_IN);
            break;
            }
          case K_TYPE:{
            tk = jj_consume_token(K_TYPE);
            break;
            }
          case K_COMMENT:{
            tk = jj_consume_token(K_COMMENT);
            break;
            }
          case K_USING:{
            tk = jj_consume_token(K_USING);
            break;
            }
          case K_COLLATE:{
            tk = jj_consume_token(K_COLLATE);
            break;
            }
          case K_ASC:{
            tk = jj_consume_token(K_ASC);
            break;
            }
          case K_DESC:{
            tk = jj_consume_token(K_DESC);
            break;
            }
          case K_TRUE:{
            tk = jj_consume_token(K_TRUE);
            break;
            }
          case K_FALSE:{
            tk = jj_consume_token(K_FALSE);
            break;
            }
          case K_PARALLEL:{
            tk = jj_consume_token(K_PARALLEL);
            break;
            }
          case K_BINARY:{
            tk = jj_consume_token(K_BINARY);
            break;
            }
          case K_START:{
            tk = jj_consume_token(K_START);
            break;
            }
          case K_TIME_KEY_EXPR:{
            tk = jj_consume_token(K_TIME_KEY_EXPR);
            break;
            }
          case K_RAW:{
            tk = jj_consume_token(K_RAW);
            break;
            }
          case K_HASH:{
            tk = jj_consume_token(K_HASH);
            break;
            }
          case K_FIRST:{
            tk = jj_consume_token(K_FIRST);
            break;
            }
          case K_LAST:{
            tk = jj_consume_token(K_LAST);
            break;
            }
          case K_SIGNED:{
            tk = jj_consume_token(K_SIGNED);
            break;
            }
          case K_UNSIGNED:{
            tk = jj_consume_token(K_UNSIGNED);
            break;
            }
          case 427:{
            tk = jj_consume_token(427);
            break;
            }
          default:
            jj_la1[462] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
param.add(tk.image);
          break;
          }
        case K_AS:
        case K_CHECK:
        case K_DEFAULT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_DEFAULT:{
            tk = jj_consume_token(K_DEFAULT);
            break;
            }
          case K_AS:{
            tk = jj_consume_token(K_AS);
            break;
            }
          case K_CHECK:{
            tk = jj_consume_token(K_CHECK);
            break;
            }
          default:
            jj_la1[463] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          if (jj_2_369(2)) {
            jj_consume_token(425);
            exp = Expression();
            jj_consume_token(426);
          } else {
            ;
          }
param.add(tk.image);
            if (exp!=null) {
                param.add("(" + exp + ")");
            }
          break;
          }
        case S_DOUBLE:
        case S_LONG:
        case 440:
        case 454:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_LONG:
          case 440:
          case 454:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 440:
            case 454:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case 440:{
                tk = jj_consume_token(440);
                break;
                }
              case 454:{
                tk = jj_consume_token(454);
                break;
                }
              default:
                jj_la1[464] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
retval = tk.image;
              break;
              }
            default:
              jj_la1[465] = jj_gen;
              ;
            }
            tk = jj_consume_token(S_LONG);
            break;
            }
          case S_DOUBLE:{
            tk = jj_consume_token(S_DOUBLE);
            break;
            }
          default:
            jj_la1[466] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
param.add( retval + tk.image );
          break;
          }
        case 425:{
          retval = AList();
param.add(retval);
          break;
          }
        case K_CHARACTER:{
          tk = jj_consume_token(K_CHARACTER);
          tk2 = jj_consume_token(K_SET);
param.add(tk.image); param.add(tk2.image);
          break;
          }
        case K_ARRAY_LITERAL:{
          jj_consume_token(K_ARRAY_LITERAL);
          exp = ArrayConstructor(true);
param.add(exp.toString());
          break;
          }
        case 471:{
          tk = jj_consume_token(471);
          colDataType = ColDataType();
param.add(tk.image); param.add(colDataType.toString());
          break;
          }
        default:
          jj_la1[468] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return param;
}

// row_movement_clause https://docs.oracle.com/cd/B19306_01/server.102/b14200/statements_7002.htm#i2204697
  final public RowMovement RowMovement() throws ParseException {RowMovement rowMovement = new RowMovement();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ENABLE:{
      jj_consume_token(K_ENABLE);
      jj_consume_token(K_ROW);
      jj_consume_token(K_MOVEMENT);
rowMovement.setMode(RowMovementMode.ENABLE);
      break;
      }
    case K_DISABLE:{
      jj_consume_token(K_DISABLE);
      jj_consume_token(K_ROW);
      jj_consume_token(K_MOVEMENT);
rowMovement.setMode(RowMovementMode.DISABLE);
      break;
      }
    default:
      jj_la1[469] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return rowMovement;
}

  final public String AList() throws ParseException {StringBuilder retval = new StringBuilder("(");
    Token tk = null;
    String name = null;
    jj_consume_token(425);
    label_89:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALTER:
      case K_ANALYZE:
      case K_APPLY:
      case K_APPROXIMATE:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BASE64:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONSTRAINTS:
      case K_CONVERT:
      case K_COSTS:
      case K_CYCLE:
      case K_DATABASE:
      case K_DATA:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GRANT:
      case K_GUARD:
      case K_HASH:
      case K_HISTORY:
      case K_HOPPING:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_INVALIDATE:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_LOOP:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAX:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MIN:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_OPEN:
      case K_OVER:
      case K_OVERLAPS:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PURGE:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_RECURSIVE:
      case K_REFERENCES:
      case K_REFRESH:
      case K_REGEXP:
      case K_RESPECT:
      case K_RLIKE:
      case K_REGISTER:
      case K_REMOTE:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_RETURN:
      case K_ROLLBACK:
      case K_ROLLUP:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SECURE:
      case K_SEED:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SHARE:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_STORED:
      case K_STRING:
      case K_STRUCT:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VERBOSE:
      case K_VIEW:
      case K_VOLATILE:
      case K_CONCURRENTLY:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case DATA_TYPE:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 429:
      case 430:
      case 431:
      case 432:
      case 433:
      case 434:
      case 435:
      case 436:{
        ;
        break;
        }
      default:
        jj_la1[470] = jj_gen;
        break label_89;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_DOUBLE:
      case S_LONG:
      case S_CHAR_LITERAL:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          tk = jj_consume_token(S_LONG);
          break;
          }
        case S_DOUBLE:{
          tk = jj_consume_token(S_DOUBLE);
          break;
          }
        case S_CHAR_LITERAL:{
          tk = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        default:
          jj_la1[471] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
retval.append(tk.image);
        break;
        }
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALTER:
      case K_ANALYZE:
      case K_APPLY:
      case K_APPROXIMATE:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BASE64:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONSTRAINTS:
      case K_CONVERT:
      case K_COSTS:
      case K_CYCLE:
      case K_DATABASE:
      case K_DATA:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GRANT:
      case K_GUARD:
      case K_HASH:
      case K_HISTORY:
      case K_HOPPING:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_INVALIDATE:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_LOOP:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAX:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MIN:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_OPEN:
      case K_OVER:
      case K_OVERLAPS:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PURGE:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_RECURSIVE:
      case K_REFERENCES:
      case K_REFRESH:
      case K_REGEXP:
      case K_RESPECT:
      case K_RLIKE:
      case K_REGISTER:
      case K_REMOTE:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_RETURN:
      case K_ROLLBACK:
      case K_ROLLUP:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SECURE:
      case K_SEED:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SHARE:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_STORED:
      case K_STRING:
      case K_STRUCT:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VERBOSE:
      case K_VIEW:
      case K_VOLATILE:
      case K_CONCURRENTLY:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case DATA_TYPE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 429:
      case 430:
      case 431:
      case 432:
      case 433:
      case 434:
      case 435:
      case 436:{
        name = RelObjectNameWithoutValue();
retval.append(name);
        break;
        }
      default:
        jj_la1[472] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:
      case 427:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          jj_consume_token(K_COMMA);
retval.append(",");
          break;
          }
        case 427:{
          jj_consume_token(427);
retval.append("=");
          break;
          }
        default:
          jj_la1[473] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[474] = jj_gen;
        ;
      }
    }
    jj_consume_token(426);
retval.append(")");
        return retval.toString();
}

  final public String ColumnsNamesListItem() throws ParseException {Token tk = null;
    String item = null;
    item = RelObjectName();
    if (jj_2_371(2)) {
      jj_consume_token(425);
      tk = jj_consume_token(S_LONG);
      jj_consume_token(426);
item = item + "(" + tk.image + ")";
    } else {
      ;
    }
return item;
}

  final public List<String> ColumnsNamesList() throws ParseException {List<String> retval = new ArrayList<String>();
    String img = null;
    jj_consume_token(425);
    img = ColumnsNamesListItem();
retval.add(img);
    label_90:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[475] = jj_gen;
        break label_90;
      }
      jj_consume_token(K_COMMA);
      img = ColumnsNamesListItem();
retval.add(img);
    }
    jj_consume_token(426);
return retval;
}

  final public String FuncArgsListItem() throws ParseException {Token tk = null;
    String argName = null;
    String argType = null;
    if (jj_2_372(2)) {
      argName = RelObjectName();
      argType = RelObjectName();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 425:{
        jj_consume_token(425);
        tk = jj_consume_token(S_LONG);
        jj_consume_token(426);
argType = argType + "(" + tk.image + ")";
        break;
        }
      default:
        jj_la1[476] = jj_gen;
        ;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALTER:
      case K_ANALYZE:
      case K_APPLY:
      case K_APPROXIMATE:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BASE64:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONNECT:
      case K_CONSTRAINTS:
      case K_CONVERT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATABASE:
      case K_DATA:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GRANT:
      case K_GROUP:
      case K_GUARD:
      case K_HASH:
      case K_HISTORY:
      case K_HOPPING:
      case K_IGNORE:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_INTERVAL:
      case K_INVALIDATE:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_LOOP:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAX:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MIN:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_ON:
      case K_OPEN:
      case K_OVER:
      case K_OVERLAPS:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PURGE:
      case K_QUALIFY:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_RECURSIVE:
      case K_REFERENCES:
      case K_REFRESH:
      case K_REGEXP:
      case K_RESPECT:
      case K_RLIKE:
      case K_REGISTER:
      case K_REMOTE:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_RETURN:
      case K_ROLLBACK:
      case K_ROLLUP:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SECURE:
      case K_SEED:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SHARE:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_START:
      case K_STORED:
      case K_STRING:
      case K_STRUCT:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VERBOSE:
      case K_VIEW:
      case K_VOLATILE:
      case K_CONCURRENTLY:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case DATA_TYPE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 429:
      case 430:
      case 431:
      case 432:
      case 433:
      case 434:
      case 435:
      case 436:{
        argType = RelObjectName();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 425:{
          jj_consume_token(425);
          tk = jj_consume_token(S_LONG);
          jj_consume_token(426);
argType = argType + "(" + tk.image + ")";
          break;
          }
        default:
          jj_la1[477] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[478] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return argName != null ? String.format("%s %s", argName, argType) : argType;
}

  final public List<String> FuncArgsList() throws ParseException {List<String> retval = null;
    String img = null;
    jj_consume_token(425);
retval = new ArrayList<String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALTER:
    case K_ANALYZE:
    case K_APPLY:
    case K_APPROXIMATE:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BASE64:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONNECT:
    case K_CONSTRAINTS:
    case K_CONVERT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATABASE:
    case K_DATA:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GRANT:
    case K_GROUP:
    case K_GUARD:
    case K_HASH:
    case K_HISTORY:
    case K_HOPPING:
    case K_IGNORE:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_INVALIDATE:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_LOOP:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAX:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MIN:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_ON:
    case K_OPEN:
    case K_OVER:
    case K_OVERLAPS:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PURGE:
    case K_QUALIFY:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_RECURSIVE:
    case K_REFERENCES:
    case K_REFRESH:
    case K_REGEXP:
    case K_RESPECT:
    case K_RLIKE:
    case K_REGISTER:
    case K_REMOTE:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_RETURN:
    case K_ROLLBACK:
    case K_ROLLUP:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SECURE:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SHARE:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_START:
    case K_STORED:
    case K_STRING:
    case K_STRUCT:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_VOLATILE:
    case K_CONCURRENTLY:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case DATA_TYPE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 429:
    case 430:
    case 431:
    case 432:
    case 433:
    case 434:
    case 435:
    case 436:{
      img = FuncArgsListItem();
retval.add(img);
      label_91:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[479] = jj_gen;
          break label_91;
        }
        jj_consume_token(K_COMMA);
        img = FuncArgsListItem();
retval.add(img);
      }
      break;
      }
    default:
      jj_la1[480] = jj_gen;
      ;
    }
    jj_consume_token(426);
return retval;
}

  final public Drop Drop() throws ParseException {Drop drop = new Drop();
    Token tk = null;
    Table name;
    List<String> dropArgs = new ArrayList<String>();
    List<String> funcArgs = null;
    boolean useTemporary = false;
    jj_consume_token(K_DROP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_MATERIALIZED:{
      jj_consume_token(K_MATERIALIZED);
drop.setMaterialized(true);
      break;
      }
    default:
      jj_la1[481] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case K_TABLE:
    case K_TEMPORARY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TEMPORARY:{
        jj_consume_token(K_TEMPORARY);
useTemporary=true;
        break;
        }
      default:
        jj_la1[482] = jj_gen;
        ;
      }
      tk = jj_consume_token(K_TABLE);
      break;
      }
    case K_INDEX:{
      tk = jj_consume_token(K_INDEX);
      break;
      }
    case K_VIEW:{
      tk = jj_consume_token(K_VIEW);
      break;
      }
    case K_SCHEMA:{
      tk = jj_consume_token(K_SCHEMA);
      break;
      }
    case K_SEQUENCE:{
      tk = jj_consume_token(K_SEQUENCE);
      break;
      }
    case K_FUNCTION:{
      tk = jj_consume_token(K_FUNCTION);
      break;
      }
    default:
      jj_la1[483] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
drop.setType(tk.image);
    if (jj_2_373(2)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_EXISTS);
drop.setIfExists(true);
    } else {
      ;
    }
    name = Table();
drop.setName(name);
    if (jj_2_374(2)) {
      funcArgs = FuncArgsList();
    } else {
      ;
    }
    label_92:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CASCADE:
      case K_ON:
      case K_RESTRICT:
      case S_IDENTIFIER:{
        ;
        break;
        }
      default:
        jj_la1[484] = jj_gen;
        break label_92;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_CASCADE:{
        tk = jj_consume_token(K_CASCADE);
        break;
        }
      case K_RESTRICT:{
        tk = jj_consume_token(K_RESTRICT);
        break;
        }
      case K_ON:{
        tk = jj_consume_token(K_ON);
        break;
        }
      default:
        jj_la1[485] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
dropArgs.add(tk.image);
    }
if (dropArgs.size() > 0) {
            drop.setParameters(dropArgs);
        }
        if (drop.getType().equals("FUNCTION")) {
            drop.getTypeToParameters().put("FUNCTION", funcArgs);
        }

        drop.setUsingTemporary(useTemporary);

        return drop;
}

  final public Truncate Truncate() throws ParseException {Truncate truncate = new Truncate();
    Table table;
    jj_consume_token(K_TRUNCATE);
    if (jj_2_375(2)) {
      jj_consume_token(K_TABLE);
truncate.setTableToken(true);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ONLY:{
      jj_consume_token(K_ONLY);
truncate.setOnly(true);
      break;
      }
    default:
      jj_la1[486] = jj_gen;
      ;
    }
    table = Table();
truncate.setTable(table); truncate.setCascade(false);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CASCADE:{
      jj_consume_token(K_CASCADE);
truncate.setCascade(true);
      break;
      }
    default:
      jj_la1[487] = jj_gen;
      ;
    }
return truncate;
}

  final public AlterExpression.ColumnDataType AlterExpressionColumnDataType() throws ParseException {String columnName = null;
    boolean withType = false;
    ColDataType dataType = null;
    List<String> columnSpecs = null;
    List<String> parameter = null;
    columnName = RelObjectName();
columnSpecs = new ArrayList<String>();
    if (jj_2_376(2)) {
      jj_consume_token(K_TYPE);
withType = true;
    } else {
      ;
    }
    if (jj_2_377(2)) {
      dataType = ColDataType();
    } else {
      ;
    }
    label_93:
    while (true) {
      if (jj_2_378(2)) {
        ;
      } else {
        break label_93;
      }
      parameter = CreateParameter();
columnSpecs.addAll(parameter);
    }
return new AlterExpression.ColumnDataType(columnName, withType, dataType, columnSpecs);
}

  final public AlterExpression.ColumnDropNotNull AlterExpressionColumnDropNotNull() throws ParseException {String columnName = null;
    boolean withNot = false;
    ColDataType dataType = null;
    List<String> columnSpecs = null;
    List<String> parameter = null;
    columnName = RelObjectName();
    jj_consume_token(K_DROP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
withNot = true;
      break;
      }
    default:
      jj_la1[488] = jj_gen;
      ;
    }
    jj_consume_token(K_NULL);
return new AlterExpression.ColumnDropNotNull(columnName, withNot);
}

  final public AlterExpression.ColumnDropDefault AlterExpressionColumnDropDefault() throws ParseException {String columnName = null;
    boolean withNot = false;
    ColDataType dataType = null;
    List<String> columnSpecs = null;
    List<String> parameter = null;
    columnName = RelObjectName();
    jj_consume_token(K_DROP);
    jj_consume_token(K_DEFAULT);
return new AlterExpression.ColumnDropDefault(columnName);
}

  final public List<ConstraintState> AlterExpressionConstraintState() throws ParseException {List<ConstraintState> retval = new ArrayList<ConstraintState>();
    label_94:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFERRABLE:
      case K_DISABLE:
      case K_ENABLE:
      case K_NOT:
      case K_NOVALIDATE:
      case K_VALIDATE:{
        ;
        break;
        }
      default:
        jj_la1[489] = jj_gen;
        break label_94;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFERRABLE:{
        jj_consume_token(K_DEFERRABLE);
retval.add(new DeferrableConstraint(false));
        break;
        }
      case K_NOT:{
        jj_consume_token(K_NOT);
        jj_consume_token(K_DEFERRABLE);
retval.add(new DeferrableConstraint(true));
        break;
        }
      case K_VALIDATE:{
        jj_consume_token(K_VALIDATE);
retval.add(new ValidateConstraint(false));
        break;
        }
      case K_NOVALIDATE:{
        jj_consume_token(K_NOVALIDATE);
retval.add(new ValidateConstraint(true));
        break;
        }
      case K_ENABLE:{
        jj_consume_token(K_ENABLE);
retval.add(new EnableConstraint(false));
        break;
        }
      case K_DISABLE:{
        jj_consume_token(K_DISABLE);
retval.add(new EnableConstraint(true));
        break;
        }
      default:
        jj_la1[490] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return retval;
}

  final public Index IndexWithComment(Index index) throws ParseException {Token tk = null;
    jj_consume_token(K_COMMENT);
    tk = jj_consume_token(S_CHAR_LITERAL);
index.setCommentText(tk.image);
return index;
}

/**
* This production needs refactoring to multiple smaller productions. The target class should
* be splitted as well.
*/
  final public AlterExpression AlterExpression() throws ParseException {AlterExpression alterExp = new AlterExpression();
    Token tk;
    Token tk2 = null;
    String sk3 = null;
    String sk4 = null;
    ColDataType dataType;
    List<String> columnNames = null;
    List<ConstraintState> constraints = null;
    ForeignKeyIndex fkIndex = null;
    Index index = null;
    Table fkTable = null;
    AlterExpression.ColumnDataType alterExpressionColumnDataType = null;
    AlterExpression.ColumnDropNotNull alterExpressionColumnDropNotNull = null;
    AlterExpression.ColumnDropDefault alterExpressionColumnDropDefault = null;
    ReferentialAction.Action action = null;
    String truncatePartitionName = null;

    // for captureRest()
    List<String> tokens = new LinkedList<String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ADD:
    case K_ALTER:
    case K_MODIFY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ADD:{
        jj_consume_token(K_ADD);
alterExp.setOperation(AlterOperation.ADD);
        break;
        }
      case K_ALTER:{
        jj_consume_token(K_ALTER);
alterExp.setOperation(AlterOperation.ALTER);
        break;
        }
      case K_MODIFY:{
        jj_consume_token(K_MODIFY);
alterExp.setOperation(AlterOperation.MODIFY);
        break;
        }
      default:
        jj_la1[491] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_394(2)) {
        jj_consume_token(K_PRIMARY);
        jj_consume_token(K_KEY);
        columnNames = ColumnsNamesList();
alterExp.setPkColumns(columnNames);
        constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_USING:{
          jj_consume_token(K_USING);
          sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
          break;
          }
        default:
          jj_la1[492] = jj_gen;
          ;
        }
      } else if (jj_2_395(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_KEY:{
          tk = jj_consume_token(K_KEY);
alterExp.setUk(true);
          break;
          }
        case K_INDEX:{
          tk = jj_consume_token(K_INDEX);
          break;
          }
        default:
          jj_la1[493] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        sk3 = RelObjectName();
        columnNames = ColumnsNamesList();
index = new Index().withType(tk.image).withName(sk3).withColumnsNames(columnNames);
                    alterExp.setIndex(index);
        constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_USING:{
          jj_consume_token(K_USING);
          sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
          break;
          }
        default:
          jj_la1[494] = jj_gen;
          ;
        }
        if (jj_2_379(2)) {
          index = IndexWithComment(index);
alterExp.setIndex(index);
        } else {
          ;
        }
      } else if (jj_2_396(2)) {
        sk3 = RelObjectName();
        jj_consume_token(K_COMMENT);
        tk = jj_consume_token(S_CHAR_LITERAL);
alterExp.withColumnName(sk3).withCommentText(tk.image);
      } else if (jj_2_397(3)) {
        if (jj_2_380(2)) {
          jj_consume_token(K_COLUMN);
alterExp.hasColumn(true);
        } else {
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_IF:{
          jj_consume_token(K_IF);
          jj_consume_token(K_NOT);
          jj_consume_token(K_EXISTS);
alterExp.setUseIfNotExists(true);
          break;
          }
        default:
          jj_la1[495] = jj_gen;
          ;
        }
        if (jj_2_381(4)) {
          jj_consume_token(425);
alterExp.useBrackets(true);
          alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
          label_95:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[496] = jj_gen;
              break label_95;
            }
            jj_consume_token(K_COMMA);
            alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
          }
          jj_consume_token(426);
        } else if (jj_2_382(2)) {
          alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
        } else if (jj_2_383(3)) {
          alterExpressionColumnDropNotNull = AlterExpressionColumnDropNotNull();
alterExp.addColDropNotNull( alterExpressionColumnDropNotNull);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ACTIVE:
          case K_ADD:
          case K_ADVANCE:
          case K_ADVISE:
          case K_AGAINST:
          case K_ALGORITHM:
          case K_ALTER:
          case K_ANALYZE:
          case K_APPLY:
          case K_APPROXIMATE:
          case K_ARCHIVE:
          case K_ARRAY_LITERAL:
          case K_AT:
          case K_ASC:
          case K_AUTHORIZATION:
          case K_AUTO:
          case K_BASE64:
          case K_BEGIN:
          case K_BERNOULLI:
          case K_BINARY:
          case K_BIT:
          case K_BLOCK:
          case K_BROWSE:
          case K_BY:
          case K_BYTES:
          case K_CACHE:
          case K_BUFFERS:
          case K_BYTE:
          case K_CALL:
          case K_CASCADE:
          case K_CASE:
          case K_CAST:
          case K_CHARACTER:
          case K_CHANGE:
          case K_CHANGES:
          case K_CHECKPOINT:
          case K_CHAR:
          case K_CLOSE:
          case K_COLLATE:
          case K_COLUMN:
          case K_COLUMNS:
          case K_COMMIT:
          case K_COMMENT:
          case K_CONFLICT:
          case K_CONNECT:
          case K_CONSTRAINTS:
          case K_CONVERT:
          case K_COSTS:
          case K_CREATE:
          case K_CYCLE:
          case K_DATABASE:
          case K_DATA:
          case K_DECLARE:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_DEFAULT:
          case K_DEFERRABLE:
          case K_DELAYED:
          case K_DELETE:
          case K_DESC:
          case K_DESCRIBE:
          case K_DISABLE:
          case K_DISCONNECT:
          case K_DIV:
          case K_DDL:
          case K_DML:
          case K_DO:
          case K_DOMAIN:
          case K_DROP:
          case K_DUMP:
          case K_DUPLICATE:
          case K_ELEMENTS:
          case K_EMIT:
          case K_ENABLE:
          case K_END:
          case K_ESCAPE:
          case K_EXCLUDE:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_EXPLICIT:
          case K_EXTENDED:
          case K_EXTRACT:
          case K_ISOLATION:
          case K_FILTER:
          case K_FIRST:
          case K_FALSE:
          case K_FLUSH:
          case K_FOLLOWING:
          case K_FORMAT:
          case K_FULLTEXT:
          case K_FUNCTION:
          case K_GRANT:
          case K_GROUP:
          case K_GUARD:
          case K_HASH:
          case K_HISTORY:
          case K_HOPPING:
          case K_IGNORE:
          case K_INCLUDE:
          case K_INCREMENT:
          case K_INDEX:
          case K_INSERT:
          case K_INTERLEAVE:
          case K_INTERPRET:
          case K_INTERVAL:
          case K_INVALIDATE:
          case K_ISNULL:
          case K_JSON:
          case K_KEEP:
          case K_KEY:
          case K_KEYS:
          case K_FN:
          case K_LAST:
          case K_LEADING:
          case K_LOCAL:
          case K_LOCKED:
          case K_LINK:
          case K_LOG:
          case K_LOOP:
          case K_MATCH:
          case K_MATCHED:
          case K_MATERIALIZED:
          case K_MAX:
          case K_MAXVALUE:
          case K_MEMBER:
          case K_MERGE:
          case K_MIN:
          case K_MINVALUE:
          case K_MODIFY:
          case K_MOVEMENT:
          case K_NEXT:
          case K_NO:
          case K_NOCACHE:
          case K_NOKEEP:
          case K_NOLOCK:
          case K_NOMAXVALUE:
          case K_NOMINVALUE:
          case K_NOORDER:
          case K_NOTHING:
          case K_NOTNULL:
          case K_NOVALIDATE:
          case K_NULLS:
          case K_NOWAIT:
          case K_OF:
          case K_OFF:
          case K_ON:
          case K_OPEN:
          case K_OVER:
          case K_OVERLAPS:
          case K_PARALLEL:
          case K_PARENT:
          case K_PARTITION:
          case K_PATH:
          case K_PERCENT:
          case K_PLACING:
          case K_PRECEDING:
          case K_PRIMARY:
          case K_PRIOR:
          case K_PURGE:
          case K_QUALIFY:
          case K_QUERY:
          case K_QUICK:
          case K_QUIESCE:
          case K_RANGE:
          case K_RAW:
          case K_READ:
          case K_RECYCLEBIN:
          case K_RECURSIVE:
          case K_REFERENCES:
          case K_REFRESH:
          case K_REGEXP:
          case K_RESPECT:
          case K_RLIKE:
          case K_REGISTER:
          case K_REMOTE:
          case K_RENAME:
          case K_REPEATABLE:
          case K_REPLACE:
          case K_RESET:
          case K_RESTART:
          case K_RESUMABLE:
          case K_RESUME:
          case K_RESTRICT:
          case K_RESTRICTED:
          case K_RETURN:
          case K_ROLLBACK:
          case K_ROLLUP:
          case K_ROOT:
          case K_ROW:
          case K_ROWS:
          case K_SAVEPOINT:
          case K_SCHEMA:
          case K_SECURE:
          case K_SEED:
          case K_SEQUENCE:
          case K_SEPARATOR:
          case K_SESSION:
          case K_SETS:
          case K_SHOW:
          case K_SHUTDOWN:
          case K_SHARE:
          case K_SIBLINGS:
          case K_SIMILAR:
          case K_SIZE:
          case K_SKIP:
          case K_START:
          case K_STORED:
          case K_STRING:
          case K_STRUCT:
          case K_SUSPEND:
          case K_SWITCH:
          case K_SYNONYM:
          case K_SYSTEM:
          case K_TABLE:
          case K_TABLES:
          case K_TABLESPACE:
          case K_TRIGGER:
          case K_THEN:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIME_KEY_EXPR:
          case K_TIMEOUT:
          case K_TO:
          case K_TOP:
          case K_TRUNCATE:
          case K_TRUE:
          case K_TUMBLING:
          case K_TYPE:
          case K_UNLOGGED:
          case K_UPDATE:
          case K_UPSERT:
          case K_UNQIESCE:
          case K_USER:
          case K_SIGNED:
          case K_STRING_FUNCTION_NAME:
          case K_UNSIGNED:
          case K_VALIDATE:
          case K_VALUE:
          case K_VALUES:
          case K_VERBOSE:
          case K_VIEW:
          case K_VOLATILE:
          case K_CONCURRENTLY:
          case K_WAIT:
          case K_WITHIN:
          case K_WITHOUT:
          case K_WORK:
          case K_XML:
          case K_XMLAGG:
          case K_XMLDATA:
          case K_XMLSCHEMA:
          case K_XMLTEXT:
          case K_XSINIL:
          case K_YAML:
          case K_YES:
          case K_ZONE:
          case DATA_TYPE:
          case S_IDENTIFIER:
          case S_QUOTED_IDENTIFIER:
          case 429:
          case 430:
          case 431:
          case 432:
          case 433:
          case 434:
          case 435:
          case 436:{
            alterExpressionColumnDropDefault = AlterExpressionColumnDropDefault();
alterExp.addColDropDefault( alterExpressionColumnDropDefault);
            break;
            }
          default:
            jj_la1[497] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 425:{
          jj_consume_token(425);
          alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
          label_96:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[498] = jj_gen;
              break label_96;
            }
            jj_consume_token(K_COMMA);
            alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
          }
          jj_consume_token(426);
          break;
          }
        case K_UNIQUE:{
          jj_consume_token(K_UNIQUE);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_INDEX:
          case K_KEY:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_KEY:{
              jj_consume_token(K_KEY);
alterExp.setUk(true);
              break;
              }
            case K_INDEX:{
              jj_consume_token(K_INDEX);
              break;
              }
            default:
              jj_la1[499] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S_IDENTIFIER:{
              tk = jj_consume_token(S_IDENTIFIER);
              break;
              }
            case S_QUOTED_IDENTIFIER:{
              tk = jj_consume_token(S_QUOTED_IDENTIFIER);
              break;
              }
            default:
              jj_la1[500] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
alterExp.setUkName(tk.image);
            break;
            }
          default:
            jj_la1[501] = jj_gen;
            ;
          }
          columnNames = ColumnsNamesList();
alterExp.setUkColumns(columnNames);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_USING:{
            jj_consume_token(K_USING);
            sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
            break;
            }
          default:
            jj_la1[502] = jj_gen;
            ;
          }
          if (jj_2_384(2)) {
            index = IndexWithComment(index);
alterExp.setIndex(index);
          } else {
            ;
          }
          break;
          }
        case K_FOREIGN:{
          jj_consume_token(K_FOREIGN);
          jj_consume_token(K_KEY);
          columnNames = ColumnsNamesList();
alterExp.setFkColumns(columnNames); columnNames = null;
          jj_consume_token(K_REFERENCES);
          fkTable = Table();
          if (jj_2_385(2)) {
            columnNames = ColumnsNamesList();
          } else {
            ;
          }
alterExp.setFkSourceSchema(fkTable.getSchemaName());
                            alterExp.setFkSourceTable(fkTable.getName());
                            alterExp.setFkSourceColumns(columnNames);
          if (jj_2_386(2)) {
            jj_consume_token(K_ON);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_DELETE:{
              tk = jj_consume_token(K_DELETE);
              break;
              }
            case K_UPDATE:{
              tk = jj_consume_token(K_UPDATE);
              break;
              }
            default:
              jj_la1[503] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            action = Action();
alterExp.setReferentialAction(ReferentialAction.Type.from(tk.image), action);
          } else {
            ;
          }
          if (jj_2_387(2)) {
            jj_consume_token(K_ON);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_DELETE:{
              tk = jj_consume_token(K_DELETE);
              break;
              }
            case K_UPDATE:{
              tk = jj_consume_token(K_UPDATE);
              break;
              }
            default:
              jj_la1[504] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            action = Action();
alterExp.setReferentialAction(ReferentialAction.Type.from(tk.image), action);
          } else {
            ;
          }
          break;
          }
        case K_CONSTRAINT:{
          jj_consume_token(K_CONSTRAINT);
          sk3 = RelObjectName();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_FOREIGN:{
            tk = jj_consume_token(K_FOREIGN);
            tk2 = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
fkIndex = new ForeignKeyIndex()
                            .withName(sk3)
                            .withType(tk.image + " " + tk2.image)
                            .withColumnsNames(columnNames);
                                                columnNames = null;
            jj_consume_token(K_REFERENCES);
            fkTable = Table();
            if (jj_2_388(2)) {
              columnNames = ColumnsNamesList();
            } else {
              ;
            }
fkIndex.withTable(fkTable).withReferencedColumnNames(columnNames);
                            alterExp.setIndex(fkIndex);
            if (jj_2_389(2)) {
              jj_consume_token(K_ON);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_DELETE:{
                tk = jj_consume_token(K_DELETE);
                break;
                }
              case K_UPDATE:{
                tk = jj_consume_token(K_UPDATE);
                break;
                }
              default:
                jj_la1[505] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.from(tk.image), action);
            } else {
              ;
            }
            if (jj_2_390(2)) {
              jj_consume_token(K_ON);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_DELETE:{
                tk = jj_consume_token(K_DELETE);
                break;
                }
              case K_UPDATE:{
                tk = jj_consume_token(K_UPDATE);
                break;
                }
              default:
                jj_la1[506] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.from(tk.image), action);
            } else {
              ;
            }
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            break;
            }
          case K_PRIMARY:{
            tk = jj_consume_token(K_PRIMARY);
            tk2 = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
index = new NamedConstraint()
                            .withName(sk3)
                            .withType(tk.image + " " + tk2.image)
                            .withColumnsNames(columnNames);
                            alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_USING:{
              jj_consume_token(K_USING);
              sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
              break;
              }
            default:
              jj_la1[507] = jj_gen;
              ;
            }
            if (jj_2_391(2)) {
              index = IndexWithComment(index);
alterExp.setIndex(index);
            } else {
              ;
            }
            break;
            }
          case K_CHECK:{
            jj_consume_token(K_CHECK);
Expression exp = null;
            label_97:
            while (true) {
              if (jj_2_392(2)) {
                ;
              } else {
                break label_97;
              }
              jj_consume_token(425);
              exp = Expression();
              jj_consume_token(426);
            }
CheckConstraint checkCs = new CheckConstraint().withName(sk3).withExpression(exp);
                            alterExp.setIndex(checkCs);
            break;
            }
          case K_UNIQUE:{
            tk = jj_consume_token(K_UNIQUE);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_INDEX:
            case K_KEY:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_KEY:{
                tk2 = jj_consume_token(K_KEY);
alterExp.setUk(true);
                break;
                }
              case K_INDEX:{
                tk2 = jj_consume_token(K_INDEX);
                break;
                }
              default:
                jj_la1[508] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
              }
            default:
              jj_la1[509] = jj_gen;
              ;
            }
            columnNames = ColumnsNamesList();
index = new NamedConstraint()
                                .withName(sk3)
                                .withType(tk.image + (tk2!=null?" " + tk2.image:""))
                                .withColumnsNames(columnNames);
                              alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_USING:{
              jj_consume_token(K_USING);
              sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
              break;
              }
            default:
              jj_la1[510] = jj_gen;
              ;
            }
            if (jj_2_393(2)) {
              index = IndexWithComment(index);
alterExp.setIndex(index);
            } else {
              ;
            }
            break;
            }
          case K_KEY:{
            tk = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
index = new NamedConstraint()
                              .withName(sk3)
                              .withType(tk.image)
                              .withColumnsNames(columnNames);
                            alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            break;
            }
          default:
            jj_la1[511] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[512] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case K_CHANGE:{
      jj_consume_token(K_CHANGE);
alterExp.setOperation(AlterOperation.CHANGE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COLUMN:{
        jj_consume_token(K_COLUMN);
alterExp.hasColumn(true); alterExp.setOptionalSpecifier("COLUMN");
        break;
        }
      default:
        jj_la1[513] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[514] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.withColumnOldName(tk.image).addColDataType(alterExpressionColumnDataType);
      break;
      }
    case K_DROP:{
      jj_consume_token(K_DROP);
alterExp.setOperation(AlterOperation.DROP);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COLUMN:
      case K_IF:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 425:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 425:{
          // we use the PK Columns Field instead of the Column Field
                              // for holding multiple DROP Columns
                              columnNames = ColumnsNamesList();
alterExp.setPkColumns(columnNames); columnNames = null;
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_INVALIDATE:{
            jj_consume_token(K_INVALIDATE);
alterExp.addParameters("INVALIDATE");
            break;
            }
          default:
            jj_la1[515] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            jj_consume_token(K_CASCADE);
alterExp.addParameters("CASCADE");
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_CONSTRAINTS:{
              jj_consume_token(K_CONSTRAINTS);
alterExp.addParameters("CONSTRAINTS");
              break;
              }
            default:
              jj_la1[516] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[517] = jj_gen;
            ;
          }
          break;
          }
        case K_COLUMN:
        case K_IF:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          if (jj_2_398(2)) {
            jj_consume_token(K_COLUMN);
alterExp.hasColumn(true);
          } else {
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_IF:{
            jj_consume_token(K_IF);
            jj_consume_token(K_EXISTS);
alterExp.setUsingIfExists(true);
            break;
            }
          default:
            jj_la1[518] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_IDENTIFIER:{
            tk = jj_consume_token(S_IDENTIFIER);
            break;
            }
          case S_QUOTED_IDENTIFIER:{
            tk = jj_consume_token(S_QUOTED_IDENTIFIER);
            break;
            }
          default:
            jj_la1[519] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
alterExp.setColumnName(tk.image);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_INVALIDATE:{
            jj_consume_token(K_INVALIDATE);
alterExp.addParameters("INVALIDATE");
            break;
            }
          default:
            jj_la1[520] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            jj_consume_token(K_CASCADE);
alterExp.addParameters("CASCADE");
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_CONSTRAINTS:{
              jj_consume_token(K_CONSTRAINTS);
alterExp.addParameters("CONSTRAINTS");
              break;
              }
            default:
              jj_la1[521] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[522] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[523] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_INDEX:
      case K_KEY:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_INDEX:{
          tk = jj_consume_token(K_INDEX);
          break;
          }
        case K_KEY:{
          tk = jj_consume_token(K_KEY);
          break;
          }
        default:
          jj_la1[524] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk2 = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[525] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
index = new Index().withType(tk.image).withName(tk2.image);
                   alterExp.setIndex(index);
        break;
        }
      case K_UNIQUE:{
        tk = jj_consume_token(K_UNIQUE);
alterExp.setOperation(AlterOperation.DROP_UNIQUE);
        columnNames = ColumnsNamesList();
alterExp.setPkColumns(columnNames); columnNames = null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CASCADE:
        case K_RESTRICT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            tk = jj_consume_token(K_CASCADE);
            break;
            }
          case K_RESTRICT:{
            tk = jj_consume_token(K_RESTRICT);
            break;
            }
          default:
            jj_la1[526] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
alterExp.addParameters(tk.image);
          break;
          }
        default:
          jj_la1[527] = jj_gen;
          ;
        }
        break;
        }
      case K_PRIMARY:{
        tk = jj_consume_token(K_PRIMARY);
        tk2 = jj_consume_token(K_KEY);
alterExp.setOperation(AlterOperation.DROP_PRIMARY_KEY);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CASCADE:
        case K_RESTRICT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            tk = jj_consume_token(K_CASCADE);
            break;
            }
          case K_RESTRICT:{
            tk = jj_consume_token(K_RESTRICT);
            break;
            }
          default:
            jj_la1[528] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
alterExp.addParameters(tk.image);
          break;
          }
        default:
          jj_la1[529] = jj_gen;
          ;
        }
        break;
        }
      case K_FOREIGN:{
        tk = jj_consume_token(K_FOREIGN);
        tk2 = jj_consume_token(K_KEY);
alterExp.setOperation(AlterOperation.DROP_FOREIGN_KEY);
        columnNames = ColumnsNamesList();
alterExp.setPkColumns(columnNames); columnNames = null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CASCADE:
        case K_RESTRICT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            tk = jj_consume_token(K_CASCADE);
            break;
            }
          case K_RESTRICT:{
            tk = jj_consume_token(K_RESTRICT);
            break;
            }
          default:
            jj_la1[530] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
alterExp.addParameters(tk.image);
          break;
          }
        default:
          jj_la1[531] = jj_gen;
          ;
        }
        break;
        }
      case K_CONSTRAINT:{
        jj_consume_token(K_CONSTRAINT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_IF:{
          jj_consume_token(K_IF);
          jj_consume_token(K_EXISTS);
alterExp.setUsingIfExists(true);
          break;
          }
        default:
          jj_la1[532] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[533] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setConstraintName(tk.image);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CASCADE:
        case K_RESTRICT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            tk = jj_consume_token(K_CASCADE);
            break;
            }
          case K_RESTRICT:{
            tk = jj_consume_token(K_RESTRICT);
            break;
            }
          default:
            jj_la1[534] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
alterExp.addParameters(tk.image);
          break;
          }
        default:
          jj_la1[535] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[536] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_ALGORITHM:{
      jj_consume_token(K_ALGORITHM);
alterExp.setOperation(AlterOperation.ALGORITHM);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 427:{
        jj_consume_token(427);
alterExp.setUseEqual(true);
        break;
        }
      default:
        jj_la1[537] = jj_gen;
        ;
      }
      sk3 = RelObjectName();
alterExp.addParameters(sk3);
      break;
      }
    default:
      jj_la1[547] = jj_gen;
      if (jj_2_399(2)) {
        jj_consume_token(K_RENAME);
alterExp.setOperation(AlterOperation.RENAME);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COLUMN:{
          jj_consume_token(K_COLUMN);
alterExp.hasColumn(true);
          break;
          }
        default:
          jj_la1[538] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[539] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setColOldName(tk.image);
        jj_consume_token(K_TO);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk2 = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[540] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setColumnName(tk2.image);
      } else if (jj_2_400(2)) {
        jj_consume_token(K_RENAME);
        jj_consume_token(K_TO);
alterExp.setOperation(AlterOperation.RENAME_TABLE);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk2 = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[541] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setNewTableName(tk2.image);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMENT:{
          jj_consume_token(K_COMMENT);
alterExp.setOperation(AlterOperation.COMMENT);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 427:{
            jj_consume_token(427);
alterExp.setOperation(AlterOperation.COMMENT_WITH_EQUAL_SIGN);
            break;
            }
          default:
            jj_la1[542] = jj_gen;
            ;
          }
          tk = jj_consume_token(S_CHAR_LITERAL);
alterExp.setCommentText(tk.image);
          break;
          }
        default:
          jj_la1[548] = jj_gen;
          if (jj_2_401(2)) {
            jj_consume_token(K_RENAME);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_INDEX:
            case K_KEY:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_INDEX:{
                jj_consume_token(K_INDEX);
alterExp.setOperation(AlterOperation.RENAME_INDEX);
                break;
                }
              case K_KEY:{
                jj_consume_token(K_KEY);
alterExp.setOperation(AlterOperation.RENAME_KEY);
                break;
                }
              default:
                jj_la1[543] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
              }
            case K_CONSTRAINT:{
              jj_consume_token(K_CONSTRAINT);
alterExp.setOperation(AlterOperation.RENAME_CONSTRAINT);
              break;
              }
            default:
              jj_la1[544] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S_IDENTIFIER:{
              tk = jj_consume_token(S_IDENTIFIER);
              break;
              }
            case S_QUOTED_IDENTIFIER:{
              tk = jj_consume_token(S_QUOTED_IDENTIFIER);
              break;
              }
            default:
              jj_la1[545] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
alterExp.setOldIndex(new Index().withName(tk.image));
            jj_consume_token(K_TO);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S_IDENTIFIER:{
              tk2 = jj_consume_token(S_IDENTIFIER);
              break;
              }
            case S_QUOTED_IDENTIFIER:{
              tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
              break;
              }
            default:
              jj_la1[546] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
index = new Index().withName(tk2.image);
              alterExp.setIndex(index);
          } else if (jj_2_402(2)) {
            jj_consume_token(K_TRUNCATE);
            jj_consume_token(K_PARTITION);
alterExp.setOperation(AlterOperation.TRUNCATE_PARTITION);
            truncatePartitionName = RelObjectName();
alterExp.setTruncatePartitionName(truncatePartitionName);
          } else {
            tokens = captureRest();
alterExp.setOperation(AlterOperation.UNSPECIFIC);
                    StringBuilder optionalSpecifier = new StringBuilder();
                    int i=0;

                    for (String s: tokens)
                        if (! (s.equals(";") || s.equals("\n\n\n")) ) {
                            if (i>0)
                                optionalSpecifier.append( " " );
                            optionalSpecifier.append( s );
                            i++;
                        }

                    alterExp.setOptionalSpecifier( optionalSpecifier.toString() );
          }
        }
      }
    }
return alterExp;
}

  final public Statement Alter() throws ParseException {Statement statement;
    List<String> captureRest;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ALTER:{
      jj_consume_token(K_ALTER);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TABLE:{
        statement = AlterTable();
        break;
        }
      case K_SESSION:{
        statement = AlterSession();
        break;
        }
      case K_VIEW:{
        statement = AlterView(false);
        break;
        }
      case K_SYSTEM:{
        statement = AlterSystemStatement();
        break;
        }
      case K_SEQUENCE:{
        statement = AlterSequence();
        break;
        }
      default:
        jj_la1[549] = jj_gen;
        captureRest = captureRest();
statement = new UnsupportedStatement("ALTER", captureRest);
      }
      break;
      }
    case K_REPLACE:{
      jj_consume_token(K_REPLACE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_VIEW:{
        statement = AlterView(true);
        break;
        }
      default:
        jj_la1[550] = jj_gen;
        captureRest = captureRest();
statement = new UnsupportedStatement("REPLACE", captureRest);
      }
      break;
      }
    default:
      jj_la1[551] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return statement;
}

  final public Alter AlterTable() throws ParseException {Alter alter = new Alter();
    Table table;
    AlterExpression alterExp;
    boolean usingIfExists = false;
    jj_consume_token(K_TABLE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ONLY:{
      jj_consume_token(K_ONLY);
alter.setUseOnly(true);
      break;
      }
    default:
      jj_la1[552] = jj_gen;
      ;
    }
    if (jj_2_403(2)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_EXISTS);
alter.setUseTableIfExists(true);
    } else {
      ;
    }
    table = Table();
alter.setTable(table);
    alterExp = AlterExpression();
alter.addAlterExpression(alterExp);
    label_98:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[553] = jj_gen;
        break label_98;
      }
      jj_consume_token(K_COMMA);
      alterExp = AlterExpression();
alter.addAlterExpression(alterExp);
    }
return alter;
}

  final public AlterSession AlterSession() throws ParseException {AlterSessionOperation operation = null;
    List<String> parameters = new ArrayList<String>();
    Token token;
    jj_consume_token(K_SESSION);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ADVISE:{
      jj_consume_token(K_ADVISE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMIT:{
        jj_consume_token(K_COMMIT);
operation = AlterSessionOperation.ADVISE_COMMIT;
        break;
        }
      case K_ROLLBACK:{
        jj_consume_token(K_ROLLBACK);
operation = AlterSessionOperation.ADVISE_ROLLBACK;
        break;
        }
      case K_NOTHING:{
        jj_consume_token(K_NOTHING);
operation = AlterSessionOperation.ADVISE_NOTHING;
        break;
        }
      default:
        jj_la1[554] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_CLOSE:{
      jj_consume_token(K_CLOSE);
      jj_consume_token(K_DATABASE);
      jj_consume_token(K_LINK);
operation = AlterSessionOperation.CLOSE_DATABASE_LINK;
      break;
      }
    case K_ENABLE:{
      jj_consume_token(K_ENABLE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMIT:{
        jj_consume_token(K_COMMIT);
        jj_consume_token(K_IN);
        jj_consume_token(K_PROCEDURE);
operation = AlterSessionOperation.ENABLE_COMMIT_IN_PROCEDURE;
        break;
        }
      case K_GUARD:{
        jj_consume_token(K_GUARD);
operation = AlterSessionOperation.ENABLE_GUARD;
        break;
        }
      case K_PARALLEL:{
        jj_consume_token(K_PARALLEL);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DML:{
          jj_consume_token(K_DML);
operation = AlterSessionOperation.ENABLE_PARALLEL_DML;
          break;
          }
        case K_DDL:{
          jj_consume_token(K_DDL);
operation = AlterSessionOperation.ENABLE_PARALLEL_DDL;
          break;
          }
        case K_QUERY:{
          jj_consume_token(K_QUERY);
operation = AlterSessionOperation.ENABLE_PARALLEL_QUERY;
          break;
          }
        default:
          jj_la1[555] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_RESUMABLE:{
        jj_consume_token(K_RESUMABLE);
operation = AlterSessionOperation.ENABLE_RESUMABLE;
        break;
        }
      default:
        jj_la1[556] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_DISABLE:{
      jj_consume_token(K_DISABLE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMIT:{
        jj_consume_token(K_COMMIT);
        jj_consume_token(K_IN);
        jj_consume_token(K_PROCEDURE);
operation = AlterSessionOperation.DISABLE_COMMIT_IN_PROCEDURE;
        break;
        }
      case K_GUARD:{
        jj_consume_token(K_GUARD);
operation = AlterSessionOperation.DISABLE_GUARD;
        break;
        }
      case K_PARALLEL:{
        jj_consume_token(K_PARALLEL);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DML:{
          jj_consume_token(K_DML);
operation = AlterSessionOperation.DISABLE_PARALLEL_DML;
          break;
          }
        case K_DDL:{
          jj_consume_token(K_DDL);
operation = AlterSessionOperation.DISABLE_PARALLEL_DDL;
          break;
          }
        case K_QUERY:{
          jj_consume_token(K_QUERY);
operation = AlterSessionOperation.DISABLE_PARALLEL_QUERY;
          break;
          }
        default:
          jj_la1[557] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_RESUMABLE:{
        jj_consume_token(K_RESUMABLE);
operation = AlterSessionOperation.DISABLE_RESUMABLE;
        break;
        }
      default:
        jj_la1[558] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_FORCE:{
      jj_consume_token(K_FORCE);
      jj_consume_token(K_PARALLEL);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DML:{
        jj_consume_token(K_DML);
operation = AlterSessionOperation.FORCE_PARALLEL_DML;
        break;
        }
      case K_DDL:{
        jj_consume_token(K_DDL);
operation = AlterSessionOperation.FORCE_PARALLEL_DDL;
        break;
        }
      case K_QUERY:{
        jj_consume_token(K_QUERY);
operation = AlterSessionOperation.FORCE_PARALLEL_QUERY;
        break;
        }
      default:
        jj_la1[559] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_SET:{
      jj_consume_token(K_SET);
operation = AlterSessionOperation.SET;
      break;
      }
    default:
      jj_la1[560] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_99:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_PARALLEL:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case 427:{
        ;
        break;
        }
      default:
        jj_la1[561] = jj_gen;
        break label_99;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_CHAR_LITERAL:{
        token = jj_consume_token(S_CHAR_LITERAL);
        break;
        }
      case S_IDENTIFIER:{
        token = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case 427:{
        token = jj_consume_token(427);
        break;
        }
      case S_LONG:{
        token = jj_consume_token(S_LONG);
        break;
        }
      case K_PARALLEL:{
        token = jj_consume_token(K_PARALLEL);
        break;
        }
      default:
        jj_la1[562] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
parameters.add( token.image );
    }
return new AlterSession(operation, parameters);
}

  final public AlterSystemStatement AlterSystemStatement() throws ParseException {AlterSystemOperation operation = null;
    List<String> parameters = new LinkedList<String>();
    jj_consume_token(K_SYSTEM);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ARCHIVE:{
      jj_consume_token(K_ARCHIVE);
      jj_consume_token(K_LOG);
operation = AlterSystemOperation.ARCHIVE_LOG;
      break;
      }
    case K_CHECKPOINT:{
      jj_consume_token(K_CHECKPOINT);
operation = AlterSystemOperation.CHECKPOINT;
      break;
      }
    case K_DUMP:{
      jj_consume_token(K_DUMP);
      jj_consume_token(K_ACTIVE);
      jj_consume_token(K_SESSION);
      jj_consume_token(K_HISTORY);
operation = AlterSystemOperation.DUMP_ACTIVE_SESSION_HISTORY;
      break;
      }
    case K_ENABLE:{
      jj_consume_token(K_ENABLE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 481:{
        jj_consume_token(481);
operation = AlterSystemOperation.ENABLE_DISTRIBUTED_RECOVERY;
        break;
        }
      case 482:{
        jj_consume_token(482);
operation = AlterSystemOperation.ENABLE_DISTRIBUTED_RECOVERY;
        break;
        }
      default:
        jj_la1[563] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_DISABLE:{
      jj_consume_token(K_DISABLE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 481:{
        jj_consume_token(481);
operation = AlterSystemOperation.DISABLE_DISTRIBUTED_RECOVERY;
        break;
        }
      case 482:{
        jj_consume_token(482);
operation = AlterSystemOperation.DISABLE_RESTRICTED_SESSION;
        break;
        }
      default:
        jj_la1[564] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_FLUSH:{
      jj_consume_token(K_FLUSH);
operation = AlterSystemOperation.FLUSH;
      break;
      }
    case K_DISCONNECT:{
      jj_consume_token(K_DISCONNECT);
      jj_consume_token(K_SESSION);
operation = AlterSystemOperation.DISCONNECT_SESSION;
      break;
      }
    case 483:{
      jj_consume_token(483);
operation = AlterSystemOperation.KILL_SESSION;
      break;
      }
    case K_SWITCH:{
      jj_consume_token(K_SWITCH);
operation = AlterSystemOperation.SWITCH;
      break;
      }
    case K_SUSPEND:{
      jj_consume_token(K_SUSPEND);
operation = AlterSystemOperation.SUSPEND;
      break;
      }
    case K_RESUME:{
      jj_consume_token(K_RESUME);
operation = AlterSystemOperation.RESUME;
      break;
      }
    case K_QUIESCE:{
      jj_consume_token(K_QUIESCE);
      jj_consume_token(K_RESTRICTED);
operation = AlterSystemOperation.QUIESCE;
      break;
      }
    case K_UNQIESCE:{
      jj_consume_token(K_UNQIESCE);
operation = AlterSystemOperation.UNQUIESCE;
      break;
      }
    case K_SHUTDOWN:{
      jj_consume_token(K_SHUTDOWN);
operation = AlterSystemOperation.SHUTDOWN;
      break;
      }
    case K_REGISTER:{
      jj_consume_token(K_REGISTER);
operation = AlterSystemOperation.REGISTER;
      break;
      }
    case K_SET:{
      jj_consume_token(K_SET);
operation = AlterSystemOperation.SET;
      break;
      }
    case K_RESET:{
      jj_consume_token(K_RESET);
operation = AlterSystemOperation.RESET;
      break;
      }
    default:
      jj_la1[565] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    parameters = captureRest();
return new AlterSystemStatement(operation, parameters);
}

  final public Wait Wait() throws ParseException {Wait wait = new Wait();
    Token token = null;
    jj_consume_token(K_WAIT);
    token = jj_consume_token(S_LONG);
wait.setTimeout(Long.parseLong(token.image));
        return wait;
}

  final public SavepointStatement SavepointStatement() throws ParseException {SavepointStatement savepointStatement;
    jj_consume_token(K_SAVEPOINT);
    token = jj_consume_token(S_IDENTIFIER);
savepointStatement = new SavepointStatement(token.image);
        return savepointStatement;
}

  final public RollbackStatement RollbackStatement() throws ParseException {RollbackStatement rollbackStatement;
    boolean usingWorkKeyword=false;
    boolean usingSavepointKeyword=false;
    String savepointName=null;
    String forceDistributedTransactionIdentifier=null;
    jj_consume_token(K_ROLLBACK);
rollbackStatement = new RollbackStatement();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WORK:{
      jj_consume_token(K_WORK);
rollbackStatement.setUsingWorkKeyword(true);
      break;
      }
    default:
      jj_la1[566] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FORCE:
    case K_TO:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TO:{
        jj_consume_token(K_TO);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SAVEPOINT:{
          jj_consume_token(K_SAVEPOINT);
rollbackStatement.setUsingSavepointKeyword(true);
          break;
          }
        default:
          jj_la1[567] = jj_gen;
          ;
        }
        token = jj_consume_token(S_IDENTIFIER);
rollbackStatement.setSavepointName(token.image);
        break;
        }
      case K_FORCE:{
        jj_consume_token(K_FORCE);
        token = jj_consume_token(S_CHAR_LITERAL);
rollbackStatement.setForceDistributedTransactionIdentifier(token.image);
        break;
        }
      default:
        jj_la1[568] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[569] = jj_gen;
      ;
    }
return rollbackStatement;
}

  final public Commit Commit() throws ParseException {Commit commit=new Commit();
    jj_consume_token(K_COMMIT);
return commit;
}

  final public Comment Comment() throws ParseException {Comment result = new Comment();
    Table table;
    Table view;
    Column column;
    Token comment;
    jj_consume_token(K_COMMENT);
    jj_consume_token(K_ON);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TABLE:{
      jj_consume_token(K_TABLE);
      table = Table();
result.setTable(table);
      break;
      }
    case K_COLUMN:{
      jj_consume_token(K_COLUMN);
      column = Column();
result.setColumn(column);
      break;
      }
    case K_VIEW:{
      jj_consume_token(K_VIEW);
      view = Table();
result.setView(view);
      break;
      }
    default:
      jj_la1[570] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_IS);
    comment = jj_consume_token(S_CHAR_LITERAL);
result.setComment(new StringValue(comment.image));
        return result;
}

  final public Grant Grant() throws ParseException {Grant grant = new Grant();
        ArrayList<String> privileges = new ArrayList<String>();
        List<String> users;
        Token tk = null;
    ObjectNames objName;
    jj_consume_token(K_GRANT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ALTER:
    case K_DELETE:
    case K_DROP:
    case K_EXECUTE:
    case K_INSERT:
    case K_ON:
    case K_SELECT:
    case K_UPDATE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ALTER:
      case K_DELETE:
      case K_DROP:
      case K_EXECUTE:
      case K_INSERT:
      case K_SELECT:
      case K_UPDATE:{
        readGrantTypes(privileges);
        label_100:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[571] = jj_gen;
            break label_100;
          }
          jj_consume_token(K_COMMA);
          readGrantTypes(privileges);
        }
        break;
        }
      default:
        jj_la1[572] = jj_gen;
        ;
      }
      jj_consume_token(K_ON);
      objName = RelObjectNames();
grant.setObjectName(objName.getNames());
      break;
      }
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
grant.setRole(tk.image);
      break;
      }
    default:
      jj_la1[573] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_TO);
    users = UsersList();
grant.setUsers(users);
if(privileges.size() > 0) {
                grant.setPrivileges(privileges);
            }
                return grant;
}

  final public List<String> UsersList() throws ParseException {List<String> users = new ArrayList<String>();
    String user = null;
    user = RelObjectName();
users.add(user);
    label_101:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[574] = jj_gen;
        break label_101;
      }
      jj_consume_token(K_COMMA);
      user = ColumnsNamesListItem();
users.add(user);
    }
return users;
}

  final public void readGrantTypes(ArrayList<String> privileges) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SELECT:{
      jj_consume_token(K_SELECT);
privileges.add("SELECT");
      break;
      }
    case K_INSERT:{
      jj_consume_token(K_INSERT);
privileges.add("INSERT");
      break;
      }
    case K_UPDATE:{
      jj_consume_token(K_UPDATE);
privileges.add("UPDATE");
      break;
      }
    case K_DELETE:{
      jj_consume_token(K_DELETE);
privileges.add("DELETE");
      break;
      }
    case K_EXECUTE:{
      jj_consume_token(K_EXECUTE);
privileges.add("EXECUTE");
      break;
      }
    case K_ALTER:{
      jj_consume_token(K_ALTER);
privileges.add("ALTER");
      break;
      }
    case K_DROP:{
      jj_consume_token(K_DROP);
privileges.add("DROP");
      break;
      }
    default:
      jj_la1[575] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public Sequence Sequence() throws ParseException {/*@bgen(jjtree) Sequence */
    SimpleNode jjtn000 = new SimpleNode(JJTSEQUENCE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));ObjectNames data = null;
    String serverName = null, databaseName = null, schemaName = null, sequenceName = null;
    try {
      data = RelObjectNames();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Sequence sequence = new Sequence(data.getNames());
                linkAST(sequence,jjtn000);
        return sequence;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public List<Sequence.Parameter> SequenceParameters() throws ParseException {List<Sequence.Parameter> sequenceParameters = new ArrayList<Sequence.Parameter>();
  Sequence.Parameter parameter = null;
  Token token = null;
    label_102:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CACHE:
      case K_CYCLE:
      case K_GLOBAL:
      case K_INCREMENT:
      case K_KEEP:
      case K_MAXVALUE:
      case K_MINVALUE:
      case K_NOCACHE:
      case K_NOCYCLE:
      case K_NOKEEP:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_ORDER:
      case K_RESTART:
      case K_SESSION:
      case K_START:{
        ;
        break;
        }
      default:
        jj_la1[576] = jj_gen;
        break label_102;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_INCREMENT:{
        jj_consume_token(K_INCREMENT);
        jj_consume_token(K_BY);
        token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.INCREMENT_BY);
        parameter.setValue(Long.parseLong(token.image));
        sequenceParameters.add(parameter);
        break;
        }
      case K_START:{
        jj_consume_token(K_START);
        jj_consume_token(K_WITH);
        token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.START_WITH);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
        break;
        }
      case K_RESTART:{
        jj_consume_token(K_RESTART);
        if (jj_2_404(2)) {
          jj_consume_token(K_WITH);
          token = jj_consume_token(S_LONG);
        } else {
          ;
        }
parameter = new Sequence.Parameter(Sequence.ParameterType.RESTART_WITH);
      if(token != null){
        parameter.setValue(Long.parseLong(token.image));
      }
      sequenceParameters.add(parameter);
        break;
        }
      case K_MAXVALUE:
      case K_NOMAXVALUE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOMAXVALUE:{
          jj_consume_token(K_NOMAXVALUE);
parameter = new Sequence.Parameter(Sequence.ParameterType.NOMAXVALUE);
      sequenceParameters.add(parameter);
          break;
          }
        case K_MAXVALUE:{
          jj_consume_token(K_MAXVALUE);
          token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.MAXVALUE);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
          break;
          }
        default:
          jj_la1[577] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_MINVALUE:
      case K_NOMINVALUE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOMINVALUE:{
          jj_consume_token(K_NOMINVALUE);
parameter = new Sequence.Parameter(Sequence.ParameterType.NOMINVALUE);
      sequenceParameters.add(parameter);
          break;
          }
        case K_MINVALUE:{
          jj_consume_token(K_MINVALUE);
          token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.MINVALUE);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
          break;
          }
        default:
          jj_la1[578] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_CYCLE:
      case K_NOCYCLE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOCYCLE:{
          jj_consume_token(K_NOCYCLE);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.NOCYCLE));
          break;
          }
        case K_CYCLE:{
          jj_consume_token(K_CYCLE);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.CYCLE));
          break;
          }
        default:
          jj_la1[579] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_CACHE:
      case K_NOCACHE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOCACHE:{
          jj_consume_token(K_NOCACHE);
parameter = new Sequence.Parameter(Sequence.ParameterType.NOCACHE);
      sequenceParameters.add(parameter);
          break;
          }
        case K_CACHE:{
          jj_consume_token(K_CACHE);
          token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.CACHE);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
          break;
          }
        default:
          jj_la1[580] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_NOORDER:
      case K_ORDER:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ORDER:{
          jj_consume_token(K_ORDER);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.ORDER));
          break;
          }
        case K_NOORDER:{
          jj_consume_token(K_NOORDER);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.NOORDER));
          break;
          }
        default:
          jj_la1[581] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_KEEP:
      case K_NOKEEP:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_KEEP:{
          jj_consume_token(K_KEEP);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.KEEP));
          break;
          }
        case K_NOKEEP:{
          jj_consume_token(K_NOKEEP);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.NOKEEP));
          break;
          }
        default:
          jj_la1[582] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_GLOBAL:
      case K_SESSION:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SESSION:{
          jj_consume_token(K_SESSION);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.SESSION));
          break;
          }
        case K_GLOBAL:{
          jj_consume_token(K_GLOBAL);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.GLOBAL));
          break;
          }
        default:
          jj_la1[583] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[584] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return sequenceParameters;
}

  final public CreateSequence CreateSequence() throws ParseException {CreateSequence createSequence = new CreateSequence();
  Sequence sequence;
  List<Sequence.Parameter> sequenceParameters;
    jj_consume_token(K_SEQUENCE);
    sequence = Sequence();
createSequence.setSequence(sequence);
    sequenceParameters = SequenceParameters();
sequence.setParameters(sequenceParameters);
        return createSequence;
}

  final public AlterSequence AlterSequence() throws ParseException {AlterSequence alterSequence = new AlterSequence();
  Sequence sequence;
  List<Sequence.Parameter> sequenceParameters;
    jj_consume_token(K_SEQUENCE);
    sequence = Sequence();
alterSequence.setSequence(sequence);
    sequenceParameters = SequenceParameters();
sequence.setParameters(sequenceParameters);
        return alterSequence;
}

  final public Statement Create() throws ParseException {boolean isUsingOrReplace=false;
    Token tk;
    Statement statement;
    List<String> captureRest;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OR:{
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
isUsingOrReplace = true;
      break;
      }
    default:
      jj_la1[585] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FUNCTION:
    case K_PROCEDURE:{
      statement = CreateFunctionStatement(isUsingOrReplace);
      break;
      }
    case K_SCHEMA:{
      statement = CreateSchema();
      break;
      }
    case K_SEQUENCE:{
      statement = CreateSequence();
      break;
      }
    case K_PUBLIC:
    case K_SYNONYM:{
      statement = CreateSynonym(isUsingOrReplace);
      break;
      }
    default:
      jj_la1[587] = jj_gen;
      if (jj_2_405(3)) {
        statement = CreateTable(isUsingOrReplace);
      } else if (jj_2_406(2)) {
        statement = CreateView(isUsingOrReplace);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DOMAIN:
        case K_TRIGGER:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_TRIGGER:{
            tk = jj_consume_token(K_TRIGGER);
            break;
            }
          case K_DOMAIN:{
            tk = jj_consume_token(K_DOMAIN);
            break;
            }
          default:
            jj_la1[586] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          captureRest = captureRest();
statement = new UnsupportedStatement("CREATE " + tk.image, captureRest);
          break;
          }
        case K_ARRAY_LITERAL:
        case K_AS:
        case K_ASC:
        case K_BINARY:
        case K_BY:
        case K_CASCADE:
        case K_CHARACTER:
        case K_CHECK:
        case K_COLLATE:
        case K_COMMIT:
        case K_COMMENT:
        case K_CONSTRAINT:
        case K_DEFAULT:
        case K_DELETE:
        case K_DESC:
        case K_DROP:
        case K_EXCLUDE:
        case K_FIRST:
        case K_FALSE:
        case K_FOREIGN:
        case K_HASH:
        case K_IN:
        case K_INDEX:
        case K_KEY:
        case K_LAST:
        case K_NEXTVAL:
        case K_NOT:
        case K_NULL:
        case K_ON:
        case K_PARALLEL:
        case K_PARTITION:
        case K_PRIMARY:
        case K_RAW:
        case K_REFERENCES:
        case K_ROWS:
        case K_START:
        case K_STORED:
        case K_TABLESPACE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TRUE:
        case K_TYPE:
        case K_UNIQUE:
        case K_UPDATE:
        case K_USING:
        case K_SIGNED:
        case K_UNSIGNED:
        case K_WHERE:
        case K_WITH:
        case S_DOUBLE:
        case S_LONG:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:
        case 425:
        case 427:
        case 440:
        case 454:
        case 471:{
          /* @fixme
                   *  Create Index uses CreateParameter() which allows all kind of tokens
                   *  it can conflict with other statements and must be at the end right now
                   */
                  statement = CreateIndex();
          break;
          }
        default:
          jj_la1[588] = jj_gen;
          captureRest = captureRest();
statement = new UnsupportedStatement("CREATE", captureRest);
        }
      }
    }
return statement;
}

  final public CreateFunctionalStatement CreateFunctionStatement(boolean isUsingOrReplace) throws ParseException {CreateFunctionalStatement type = null;
  List<String> tokens = new LinkedList<String>();
  String statementType = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FUNCTION:{
      jj_consume_token(K_FUNCTION);
statementType = "FUNCTION";
      break;
      }
    case K_PROCEDURE:{
      jj_consume_token(K_PROCEDURE);
statementType = "PROCEDURE";
      break;
      }
    default:
      jj_la1[589] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    tokens = captureFunctionBody();
if(statementType.equals("FUNCTION")) {
      type = new CreateFunction(isUsingOrReplace, tokens);
    }
    if(statementType.equals("PROCEDURE")) {
      type = new CreateProcedure(isUsingOrReplace, tokens);
    }

    return type;
}

  final public CreateSynonym CreateSynonym(boolean isUsingOrReplace) throws ParseException {CreateSynonym createSynonym = new CreateSynonym();
  Synonym synonym;
  boolean publicSynonym = false;
  ObjectNames data = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PUBLIC:{
      jj_consume_token(K_PUBLIC);
publicSynonym = true;
      break;
      }
    default:
      jj_la1[590] = jj_gen;
      ;
    }
    jj_consume_token(K_SYNONYM);
    synonym = Synonym();
createSynonym.setSynonym(synonym);
    jj_consume_token(K_FOR);
    data = RelObjectNames();
createSynonym.setOrReplace(isUsingOrReplace);
    createSynonym.setPublicSynonym(publicSynonym);
    createSynonym.setForList(data.getNames());
    return createSynonym;
}

  final public Synonym Synonym() throws ParseException {/*@bgen(jjtree) Synonym */
    SimpleNode jjtn000 = new SimpleNode(JJTSYNONYM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));ObjectNames data = null;
    String serverName = null, databaseName = null, schemaName = null, sequenceName = null;
    try {
      data = RelObjectNames();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Synonym synonym = new Synonym(data.getNames());
                linkAST(synonym,jjtn000);
        return synonym;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public UnsupportedStatement UnsupportedStatement() throws ParseException {List<String> tokens = new LinkedList<String>();
    tokens = captureUnsupportedStatementDeclaration();
return new UnsupportedStatement(tokens);
}

  List<String> captureRest() throws ParseException {List<String> tokens = new LinkedList<String>();
  Token tok;
  while(true) {
    tok = getToken(1);
    int l = tokens.size();
    if( tok.kind == EOF || tok.kind == ST_SEMICOLON ) {
      break;
    } else if ( l>0 && ( tok.image.equals(".") ||  tokens.get(l-1).endsWith(".")) ) {
        tokens.set(l-1, tokens.get(l-1) + tok.image);
    } else {
        tokens.add(tok.image);
    }
    tok = getNextToken();
  }
  return tokens;
  }

  List<String> captureFunctionBody() throws ParseException {List<String> tokens = new LinkedList<String>();
  Token tok;
  boolean foundEnd = false;
  while(true) {
    tok = getToken(1);
    int l = tokens.size();
    if( tok.kind == EOF || ( foundEnd && tok.kind == ST_SEMICOLON) ) {
      if (tok.kind == ST_SEMICOLON) {
        tokens.add(tok.image);
      }
      break;
    } else if ( l>0 && ( tok.image.equals(".") ||  tokens.get(l-1).endsWith(".")) ) {
        tokens.set(l-1, tokens.get(l-1) + tok.image);
    } else {
        tokens.add(tok.image);
    }
    foundEnd |= (tok.kind == K_END)
        || ( tok.image.trim().startsWith("$$") && tok.image.trim().endsWith("$$")) ;

    tok = getNextToken();
  }
  return tokens;
  }

  List<String> captureUnsupportedStatementDeclaration() throws ParseException {List<String> tokens = new LinkedList<String>();
  Token tok;

  while(true) {
    tok = getToken(1);
    if( tok.kind == EOF || tok.kind== ST_SEMICOLON || tok.kind== K_END ) {
      break;
    }
    tokens.add(tok.image);
    tok = getNextToken();
  }
  return tokens;
  }

  final public String IdentifierChain() throws ParseException {String identifierChain;
    String part;
    identifierChain = RelObjectNameExt2();
    label_103:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 428:{
        ;
        break;
        }
      default:
        jj_la1[591] = jj_gen;
        break label_103;
      }
      jj_consume_token(428);
      part = RelObjectNameExt2();
identifierChain += "." + part;
    }
return identifierChain;
}

  final public Expression CharacterPrimary() throws ParseException {Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CONVERT:{
      expression = TranscodingFunction();
      break;
      }
    case K_TRIM:{
      expression = TrimFunction();
      break;
      }
    default:
      jj_la1[592] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return expression;
}

  final public TranscodingFunction TranscodingFunction() throws ParseException {/*@bgen(jjtree) TranscodingFunction */
    SimpleNode jjtn000 = new SimpleNode(JJTTRANSCODINGFUNCTION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));TranscodingFunction transcodingFunction;
    ColDataType colDataType;
    Expression expression;
    String transcodingName=null;
    Token style;
    try {
      jj_consume_token(K_CONVERT);
      jj_consume_token(425);
      if (jj_2_407(2147483647)) {
        colDataType = ColDataType();
        jj_consume_token(K_COMMA);
        expression = Expression();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          jj_consume_token(K_COMMA);
          style = jj_consume_token(S_LONG);
transcodingName = style.image;
          break;
          }
        default:
          jj_la1[593] = jj_gen;
          ;
        }
transcodingFunction = new TranscodingFunction(colDataType, expression, transcodingName);
      } else if (jj_2_408(1)) {
        expression = Expression();
        jj_consume_token(K_USING);
        transcodingName = IdentifierChain();
transcodingFunction = new TranscodingFunction(expression, transcodingName);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(426);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return transcodingFunction;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public TrimFunction TrimFunction() throws ParseException {TrimFunction.TrimSpecification trimSpecification=null;
    Expression expression = null;
    boolean usesFrom = false;
    Expression fromExpression = null;
    jj_consume_token(K_TRIM);
    jj_consume_token(425);
    if (jj_2_409(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LEADING:{
        jj_consume_token(K_LEADING);
trimSpecification = TrimFunction.TrimSpecification.LEADING;
        break;
        }
      case K_TRAILING:{
        jj_consume_token(K_TRAILING);
trimSpecification = TrimFunction.TrimSpecification.TRAILING;
        break;
        }
      case K_BOTH:{
        jj_consume_token(K_BOTH);
trimSpecification = TrimFunction.TrimSpecification.BOTH;
        break;
        }
      default:
        jj_la1[594] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    if (jj_2_410(1)) {
      expression = Expression();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_COMMA:
    case K_FROM:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        jj_consume_token(K_COMMA);
        break;
        }
      case K_FROM:{
        jj_consume_token(K_FROM);
usesFrom = true;
        break;
        }
      default:
        jj_la1[595] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      fromExpression = Expression();
      break;
      }
    default:
      jj_la1[596] = jj_gen;
      ;
    }
    jj_consume_token(426);
return new TrimFunction(trimSpecification, expression, fromExpression, usesFrom);
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_26()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_27()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_28()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_29()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_30()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_31()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_32()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_33()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_34()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_35()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_36()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_37()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_38()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_39()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_40()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_41()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_42()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_43()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_44()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_45()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_46()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_47()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_48()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_49()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_50()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_51()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_52()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_53()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_54()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_55()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_56()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_57()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_58()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_59()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_60()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_61()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_62()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_2_63(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_63()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  private boolean jj_2_64(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_64()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  private boolean jj_2_65(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_65()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  private boolean jj_2_66(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_66()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  private boolean jj_2_67(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_67()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  private boolean jj_2_68(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_68()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  private boolean jj_2_69(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_69()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  private boolean jj_2_70(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_70()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  private boolean jj_2_71(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_71()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  private boolean jj_2_72(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_72()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  private boolean jj_2_73(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_73()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  private boolean jj_2_74(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_74()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  private boolean jj_2_75(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_75()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  private boolean jj_2_76(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_76()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  private boolean jj_2_77(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_77()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  private boolean jj_2_78(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_78()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  private boolean jj_2_79(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_79()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  private boolean jj_2_80(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_80()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  private boolean jj_2_81(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_81()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  private boolean jj_2_82(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_82()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  private boolean jj_2_83(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_83()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  private boolean jj_2_84(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_84()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  private boolean jj_2_85(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_85()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  private boolean jj_2_86(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_86()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  private boolean jj_2_87(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_87()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  private boolean jj_2_88(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_88()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  private boolean jj_2_89(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_89()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  private boolean jj_2_90(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_90()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  private boolean jj_2_91(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_91()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  private boolean jj_2_92(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_92()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  private boolean jj_2_93(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_93()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  private boolean jj_2_94(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_94()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  private boolean jj_2_95(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_95()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  private boolean jj_2_96(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_96()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  private boolean jj_2_97(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_97()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  private boolean jj_2_98(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_98()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  private boolean jj_2_99(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_99()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  private boolean jj_2_100(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_100()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  private boolean jj_2_101(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_101()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(100, xla); }
  }

  private boolean jj_2_102(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_102()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(101, xla); }
  }

  private boolean jj_2_103(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_103()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(102, xla); }
  }

  private boolean jj_2_104(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_104()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(103, xla); }
  }

  private boolean jj_2_105(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_105()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(104, xla); }
  }

  private boolean jj_2_106(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_106()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(105, xla); }
  }

  private boolean jj_2_107(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_107()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(106, xla); }
  }

  private boolean jj_2_108(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_108()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(107, xla); }
  }

  private boolean jj_2_109(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_109()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(108, xla); }
  }

  private boolean jj_2_110(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_110()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(109, xla); }
  }

  private boolean jj_2_111(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_111()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(110, xla); }
  }

  private boolean jj_2_112(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_112()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(111, xla); }
  }

  private boolean jj_2_113(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_113()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(112, xla); }
  }

  private boolean jj_2_114(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_114()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(113, xla); }
  }

  private boolean jj_2_115(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_115()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(114, xla); }
  }

  private boolean jj_2_116(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_116()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(115, xla); }
  }

  private boolean jj_2_117(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_117()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(116, xla); }
  }

  private boolean jj_2_118(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_118()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(117, xla); }
  }

  private boolean jj_2_119(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_119()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(118, xla); }
  }

  private boolean jj_2_120(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_120()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(119, xla); }
  }

  private boolean jj_2_121(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_121()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(120, xla); }
  }

  private boolean jj_2_122(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_122()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(121, xla); }
  }

  private boolean jj_2_123(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_123()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(122, xla); }
  }

  private boolean jj_2_124(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_124()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(123, xla); }
  }

  private boolean jj_2_125(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_125()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(124, xla); }
  }

  private boolean jj_2_126(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_126()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(125, xla); }
  }

  private boolean jj_2_127(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_127()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(126, xla); }
  }

  private boolean jj_2_128(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_128()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(127, xla); }
  }

  private boolean jj_2_129(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_129()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(128, xla); }
  }

  private boolean jj_2_130(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_130()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(129, xla); }
  }

  private boolean jj_2_131(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_131()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(130, xla); }
  }

  private boolean jj_2_132(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_132()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(131, xla); }
  }

  private boolean jj_2_133(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_133()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(132, xla); }
  }

  private boolean jj_2_134(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_134()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(133, xla); }
  }

  private boolean jj_2_135(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_135()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(134, xla); }
  }

  private boolean jj_2_136(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_136()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(135, xla); }
  }

  private boolean jj_2_137(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_137()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(136, xla); }
  }

  private boolean jj_2_138(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_138()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(137, xla); }
  }

  private boolean jj_2_139(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_139()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(138, xla); }
  }

  private boolean jj_2_140(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_140()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(139, xla); }
  }

  private boolean jj_2_141(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_141()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(140, xla); }
  }

  private boolean jj_2_142(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_142()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(141, xla); }
  }

  private boolean jj_2_143(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_143()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(142, xla); }
  }

  private boolean jj_2_144(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_144()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(143, xla); }
  }

  private boolean jj_2_145(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_145()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(144, xla); }
  }

  private boolean jj_2_146(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_146()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(145, xla); }
  }

  private boolean jj_2_147(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_147()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(146, xla); }
  }

  private boolean jj_2_148(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_148()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(147, xla); }
  }

  private boolean jj_2_149(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_149()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(148, xla); }
  }

  private boolean jj_2_150(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_150()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(149, xla); }
  }

  private boolean jj_2_151(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_151()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(150, xla); }
  }

  private boolean jj_2_152(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_152()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(151, xla); }
  }

  private boolean jj_2_153(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_153()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(152, xla); }
  }

  private boolean jj_2_154(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_154()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(153, xla); }
  }

  private boolean jj_2_155(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_155()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(154, xla); }
  }

  private boolean jj_2_156(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_156()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(155, xla); }
  }

  private boolean jj_2_157(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_157()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(156, xla); }
  }

  private boolean jj_2_158(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_158()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(157, xla); }
  }

  private boolean jj_2_159(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_159()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(158, xla); }
  }

  private boolean jj_2_160(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_160()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(159, xla); }
  }

  private boolean jj_2_161(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_161()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(160, xla); }
  }

  private boolean jj_2_162(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_162()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(161, xla); }
  }

  private boolean jj_2_163(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_163()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(162, xla); }
  }

  private boolean jj_2_164(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_164()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(163, xla); }
  }

  private boolean jj_2_165(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_165()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(164, xla); }
  }

  private boolean jj_2_166(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_166()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(165, xla); }
  }

  private boolean jj_2_167(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_167()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(166, xla); }
  }

  private boolean jj_2_168(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_168()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(167, xla); }
  }

  private boolean jj_2_169(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_169()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(168, xla); }
  }

  private boolean jj_2_170(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_170()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(169, xla); }
  }

  private boolean jj_2_171(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_171()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(170, xla); }
  }

  private boolean jj_2_172(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_172()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(171, xla); }
  }

  private boolean jj_2_173(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_173()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(172, xla); }
  }

  private boolean jj_2_174(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_174()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(173, xla); }
  }

  private boolean jj_2_175(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_175()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(174, xla); }
  }

  private boolean jj_2_176(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_176()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(175, xla); }
  }

  private boolean jj_2_177(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_177()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(176, xla); }
  }

  private boolean jj_2_178(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_178()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(177, xla); }
  }

  private boolean jj_2_179(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_179()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(178, xla); }
  }

  private boolean jj_2_180(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_180()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(179, xla); }
  }

  private boolean jj_2_181(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_181()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(180, xla); }
  }

  private boolean jj_2_182(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_182()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(181, xla); }
  }

  private boolean jj_2_183(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_183()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(182, xla); }
  }

  private boolean jj_2_184(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_184()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(183, xla); }
  }

  private boolean jj_2_185(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_185()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(184, xla); }
  }

  private boolean jj_2_186(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_186()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(185, xla); }
  }

  private boolean jj_2_187(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_187()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(186, xla); }
  }

  private boolean jj_2_188(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_188()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(187, xla); }
  }

  private boolean jj_2_189(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_189()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(188, xla); }
  }

  private boolean jj_2_190(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_190()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(189, xla); }
  }

  private boolean jj_2_191(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_191()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(190, xla); }
  }

  private boolean jj_2_192(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_192()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(191, xla); }
  }

  private boolean jj_2_193(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_193()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(192, xla); }
  }

  private boolean jj_2_194(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_194()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(193, xla); }
  }

  private boolean jj_2_195(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_195()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(194, xla); }
  }

  private boolean jj_2_196(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_196()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(195, xla); }
  }

  private boolean jj_2_197(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_197()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(196, xla); }
  }

  private boolean jj_2_198(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_198()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(197, xla); }
  }

  private boolean jj_2_199(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_199()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(198, xla); }
  }

  private boolean jj_2_200(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_200()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(199, xla); }
  }

  private boolean jj_2_201(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_201()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(200, xla); }
  }

  private boolean jj_2_202(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_202()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(201, xla); }
  }

  private boolean jj_2_203(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_203()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(202, xla); }
  }

  private boolean jj_2_204(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_204()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(203, xla); }
  }

  private boolean jj_2_205(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_205()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(204, xla); }
  }

  private boolean jj_2_206(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_206()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(205, xla); }
  }

  private boolean jj_2_207(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_207()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(206, xla); }
  }

  private boolean jj_2_208(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_208()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(207, xla); }
  }

  private boolean jj_2_209(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_209()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(208, xla); }
  }

  private boolean jj_2_210(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_210()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(209, xla); }
  }

  private boolean jj_2_211(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_211()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(210, xla); }
  }

  private boolean jj_2_212(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_212()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(211, xla); }
  }

  private boolean jj_2_213(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_213()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(212, xla); }
  }

  private boolean jj_2_214(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_214()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(213, xla); }
  }

  private boolean jj_2_215(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_215()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(214, xla); }
  }

  private boolean jj_2_216(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_216()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(215, xla); }
  }

  private boolean jj_2_217(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_217()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(216, xla); }
  }

  private boolean jj_2_218(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_218()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(217, xla); }
  }

  private boolean jj_2_219(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_219()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(218, xla); }
  }

  private boolean jj_2_220(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_220()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(219, xla); }
  }

  private boolean jj_2_221(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_221()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(220, xla); }
  }

  private boolean jj_2_222(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_222()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(221, xla); }
  }

  private boolean jj_2_223(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_223()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(222, xla); }
  }

  private boolean jj_2_224(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_224()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(223, xla); }
  }

  private boolean jj_2_225(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_225()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(224, xla); }
  }

  private boolean jj_2_226(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_226()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(225, xla); }
  }

  private boolean jj_2_227(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_227()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(226, xla); }
  }

  private boolean jj_2_228(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_228()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(227, xla); }
  }

  private boolean jj_2_229(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_229()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(228, xla); }
  }

  private boolean jj_2_230(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_230()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(229, xla); }
  }

  private boolean jj_2_231(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_231()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(230, xla); }
  }

  private boolean jj_2_232(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_232()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(231, xla); }
  }

  private boolean jj_2_233(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_233()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(232, xla); }
  }

  private boolean jj_2_234(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_234()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(233, xla); }
  }

  private boolean jj_2_235(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_235()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(234, xla); }
  }

  private boolean jj_2_236(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_236()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(235, xla); }
  }

  private boolean jj_2_237(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_237()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(236, xla); }
  }

  private boolean jj_2_238(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_238()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(237, xla); }
  }

  private boolean jj_2_239(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_239()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(238, xla); }
  }

  private boolean jj_2_240(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_240()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(239, xla); }
  }

  private boolean jj_2_241(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_241()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(240, xla); }
  }

  private boolean jj_2_242(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_242()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(241, xla); }
  }

  private boolean jj_2_243(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_243()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(242, xla); }
  }

  private boolean jj_2_244(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_244()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(243, xla); }
  }

  private boolean jj_2_245(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_245()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(244, xla); }
  }

  private boolean jj_2_246(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_246()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(245, xla); }
  }

  private boolean jj_2_247(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_247()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(246, xla); }
  }

  private boolean jj_2_248(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_248()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(247, xla); }
  }

  private boolean jj_2_249(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_249()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(248, xla); }
  }

  private boolean jj_2_250(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_250()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(249, xla); }
  }

  private boolean jj_2_251(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_251()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(250, xla); }
  }

  private boolean jj_2_252(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_252()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(251, xla); }
  }

  private boolean jj_2_253(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_253()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(252, xla); }
  }

  private boolean jj_2_254(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_254()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(253, xla); }
  }

  private boolean jj_2_255(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_255()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(254, xla); }
  }

  private boolean jj_2_256(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_256()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(255, xla); }
  }

  private boolean jj_2_257(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_257()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(256, xla); }
  }

  private boolean jj_2_258(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_258()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(257, xla); }
  }

  private boolean jj_2_259(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_259()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(258, xla); }
  }

  private boolean jj_2_260(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_260()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(259, xla); }
  }

  private boolean jj_2_261(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_261()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(260, xla); }
  }

  private boolean jj_2_262(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_262()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(261, xla); }
  }

  private boolean jj_2_263(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_263()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(262, xla); }
  }

  private boolean jj_2_264(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_264()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(263, xla); }
  }

  private boolean jj_2_265(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_265()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(264, xla); }
  }

  private boolean jj_2_266(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_266()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(265, xla); }
  }

  private boolean jj_2_267(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_267()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(266, xla); }
  }

  private boolean jj_2_268(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_268()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(267, xla); }
  }

  private boolean jj_2_269(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_269()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(268, xla); }
  }

  private boolean jj_2_270(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_270()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(269, xla); }
  }

  private boolean jj_2_271(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_271()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(270, xla); }
  }

  private boolean jj_2_272(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_272()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(271, xla); }
  }

  private boolean jj_2_273(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_273()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(272, xla); }
  }

  private boolean jj_2_274(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_274()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(273, xla); }
  }

  private boolean jj_2_275(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_275()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(274, xla); }
  }

  private boolean jj_2_276(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_276()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(275, xla); }
  }

  private boolean jj_2_277(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_277()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(276, xla); }
  }

  private boolean jj_2_278(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_278()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(277, xla); }
  }

  private boolean jj_2_279(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_279()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(278, xla); }
  }

  private boolean jj_2_280(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_280()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(279, xla); }
  }

  private boolean jj_2_281(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_281()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(280, xla); }
  }

  private boolean jj_2_282(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_282()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(281, xla); }
  }

  private boolean jj_2_283(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_283()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(282, xla); }
  }

  private boolean jj_2_284(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_284()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(283, xla); }
  }

  private boolean jj_2_285(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_285()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(284, xla); }
  }

  private boolean jj_2_286(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_286()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(285, xla); }
  }

  private boolean jj_2_287(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_287()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(286, xla); }
  }

  private boolean jj_2_288(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_288()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(287, xla); }
  }

  private boolean jj_2_289(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_289()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(288, xla); }
  }

  private boolean jj_2_290(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_290()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(289, xla); }
  }

  private boolean jj_2_291(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_291()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(290, xla); }
  }

  private boolean jj_2_292(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_292()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(291, xla); }
  }

  private boolean jj_2_293(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_293()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(292, xla); }
  }

  private boolean jj_2_294(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_294()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(293, xla); }
  }

  private boolean jj_2_295(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_295()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(294, xla); }
  }

  private boolean jj_2_296(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_296()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(295, xla); }
  }

  private boolean jj_2_297(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_297()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(296, xla); }
  }

  private boolean jj_2_298(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_298()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(297, xla); }
  }

  private boolean jj_2_299(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_299()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(298, xla); }
  }

  private boolean jj_2_300(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_300()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(299, xla); }
  }

  private boolean jj_2_301(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_301()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(300, xla); }
  }

  private boolean jj_2_302(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_302()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(301, xla); }
  }

  private boolean jj_2_303(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_303()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(302, xla); }
  }

  private boolean jj_2_304(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_304()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(303, xla); }
  }

  private boolean jj_2_305(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_305()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(304, xla); }
  }

  private boolean jj_2_306(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_306()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(305, xla); }
  }

  private boolean jj_2_307(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_307()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(306, xla); }
  }

  private boolean jj_2_308(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_308()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(307, xla); }
  }

  private boolean jj_2_309(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_309()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(308, xla); }
  }

  private boolean jj_2_310(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_310()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(309, xla); }
  }

  private boolean jj_2_311(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_311()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(310, xla); }
  }

  private boolean jj_2_312(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_312()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(311, xla); }
  }

  private boolean jj_2_313(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_313()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(312, xla); }
  }

  private boolean jj_2_314(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_314()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(313, xla); }
  }

  private boolean jj_2_315(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_315()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(314, xla); }
  }

  private boolean jj_2_316(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_316()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(315, xla); }
  }

  private boolean jj_2_317(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_317()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(316, xla); }
  }

  private boolean jj_2_318(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_318()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(317, xla); }
  }

  private boolean jj_2_319(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_319()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(318, xla); }
  }

  private boolean jj_2_320(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_320()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(319, xla); }
  }

  private boolean jj_2_321(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_321()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(320, xla); }
  }

  private boolean jj_2_322(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_322()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(321, xla); }
  }

  private boolean jj_2_323(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_323()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(322, xla); }
  }

  private boolean jj_2_324(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_324()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(323, xla); }
  }

  private boolean jj_2_325(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_325()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(324, xla); }
  }

  private boolean jj_2_326(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_326()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(325, xla); }
  }

  private boolean jj_2_327(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_327()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(326, xla); }
  }

  private boolean jj_2_328(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_328()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(327, xla); }
  }

  private boolean jj_2_329(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_329()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(328, xla); }
  }

  private boolean jj_2_330(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_330()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(329, xla); }
  }

  private boolean jj_2_331(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_331()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(330, xla); }
  }

  private boolean jj_2_332(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_332()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(331, xla); }
  }

  private boolean jj_2_333(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_333()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(332, xla); }
  }

  private boolean jj_2_334(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_334()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(333, xla); }
  }

  private boolean jj_2_335(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_335()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(334, xla); }
  }

  private boolean jj_2_336(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_336()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(335, xla); }
  }

  private boolean jj_2_337(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_337()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(336, xla); }
  }

  private boolean jj_2_338(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_338()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(337, xla); }
  }

  private boolean jj_2_339(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_339()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(338, xla); }
  }

  private boolean jj_2_340(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_340()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(339, xla); }
  }

  private boolean jj_2_341(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_341()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(340, xla); }
  }

  private boolean jj_2_342(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_342()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(341, xla); }
  }

  private boolean jj_2_343(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_343()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(342, xla); }
  }

  private boolean jj_2_344(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_344()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(343, xla); }
  }

  private boolean jj_2_345(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_345()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(344, xla); }
  }

  private boolean jj_2_346(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_346()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(345, xla); }
  }

  private boolean jj_2_347(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_347()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(346, xla); }
  }

  private boolean jj_2_348(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_348()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(347, xla); }
  }

  private boolean jj_2_349(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_349()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(348, xla); }
  }

  private boolean jj_2_350(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_350()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(349, xla); }
  }

  private boolean jj_2_351(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_351()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(350, xla); }
  }

  private boolean jj_2_352(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_352()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(351, xla); }
  }

  private boolean jj_2_353(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_353()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(352, xla); }
  }

  private boolean jj_2_354(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_354()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(353, xla); }
  }

  private boolean jj_2_355(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_355()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(354, xla); }
  }

  private boolean jj_2_356(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_356()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(355, xla); }
  }

  private boolean jj_2_357(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_357()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(356, xla); }
  }

  private boolean jj_2_358(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_358()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(357, xla); }
  }

  private boolean jj_2_359(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_359()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(358, xla); }
  }

  private boolean jj_2_360(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_360()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(359, xla); }
  }

  private boolean jj_2_361(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_361()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(360, xla); }
  }

  private boolean jj_2_362(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_362()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(361, xla); }
  }

  private boolean jj_2_363(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_363()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(362, xla); }
  }

  private boolean jj_2_364(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_364()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(363, xla); }
  }

  private boolean jj_2_365(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_365()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(364, xla); }
  }

  private boolean jj_2_366(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_366()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(365, xla); }
  }

  private boolean jj_2_367(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_367()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(366, xla); }
  }

  private boolean jj_2_368(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_368()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(367, xla); }
  }

  private boolean jj_2_369(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_369()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(368, xla); }
  }

  private boolean jj_2_370(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_370()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(369, xla); }
  }

  private boolean jj_2_371(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_371()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(370, xla); }
  }

  private boolean jj_2_372(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_372()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(371, xla); }
  }

  private boolean jj_2_373(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_373()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(372, xla); }
  }

  private boolean jj_2_374(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_374()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(373, xla); }
  }

  private boolean jj_2_375(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_375()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(374, xla); }
  }

  private boolean jj_2_376(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_376()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(375, xla); }
  }

  private boolean jj_2_377(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_377()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(376, xla); }
  }

  private boolean jj_2_378(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_378()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(377, xla); }
  }

  private boolean jj_2_379(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_379()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(378, xla); }
  }

  private boolean jj_2_380(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_380()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(379, xla); }
  }

  private boolean jj_2_381(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_381()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(380, xla); }
  }

  private boolean jj_2_382(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_382()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(381, xla); }
  }

  private boolean jj_2_383(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_383()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(382, xla); }
  }

  private boolean jj_2_384(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_384()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(383, xla); }
  }

  private boolean jj_2_385(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_385()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(384, xla); }
  }

  private boolean jj_2_386(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_386()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(385, xla); }
  }

  private boolean jj_2_387(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_387()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(386, xla); }
  }

  private boolean jj_2_388(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_388()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(387, xla); }
  }

  private boolean jj_2_389(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_389()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(388, xla); }
  }

  private boolean jj_2_390(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_390()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(389, xla); }
  }

  private boolean jj_2_391(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_391()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(390, xla); }
  }

  private boolean jj_2_392(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_392()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(391, xla); }
  }

  private boolean jj_2_393(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_393()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(392, xla); }
  }

  private boolean jj_2_394(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_394()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(393, xla); }
  }

  private boolean jj_2_395(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_395()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(394, xla); }
  }

  private boolean jj_2_396(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_396()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(395, xla); }
  }

  private boolean jj_2_397(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_397()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(396, xla); }
  }

  private boolean jj_2_398(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_398()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(397, xla); }
  }

  private boolean jj_2_399(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_399()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(398, xla); }
  }

  private boolean jj_2_400(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_400()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(399, xla); }
  }

  private boolean jj_2_401(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_401()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(400, xla); }
  }

  private boolean jj_2_402(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_402()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(401, xla); }
  }

  private boolean jj_2_403(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_403()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(402, xla); }
  }

  private boolean jj_2_404(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_404()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(403, xla); }
  }

  private boolean jj_2_405(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_405()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(404, xla); }
  }

  private boolean jj_2_406(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_406()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(405, xla); }
  }

  private boolean jj_2_407(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_407()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(406, xla); }
  }

  private boolean jj_2_408(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_408()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(407, xla); }
  }

  private boolean jj_2_409(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_409()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(408, xla); }
  }

  private boolean jj_2_410(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_410()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(409, xla); }
  }

  private boolean jj_3R_JoinerExpression_3060_9_436()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_3060_40_656()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JoinerExpression_3058_9_435()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_3058_13_655()) jj_scanpos = xsp;
    if (jj_scan_token(K_JOIN)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_3047_17_759()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_3054_9_654()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_3046_17_758()
 {
    if (jj_scan_token(K_FULL)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_3049_13_730()
 {
    if (jj_scan_token(K_INNER)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_3052_9_653()
 {
    if (jj_scan_token(K_CROSS)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_3044_17_757()
 {
    if (jj_scan_token(K_RIGHT)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_3043_13_729()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_3044_17_757()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_3046_17_758()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_3047_17_759()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JoinerExpression_3041_13_728()
 {
    if (jj_scan_token(K_LEFT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_3041_48_756()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JoinerExpression_3040_9_434()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_3040_9_652()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_3052_9_653()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_3054_9_654()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_3040_9_652()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_3041_13_728()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_3043_13_729()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_3049_13_730()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_3037_7_433()
 {
    if (jj_scan_token(K_NATURAL)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_3036_7_432()
 {
    if (jj_scan_token(K_GLOBAL)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_3036_5_205()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_3036_7_432()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_3037_7_433()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_3040_9_434()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_3058_9_435()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_3060_9_436()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_3062_9_437()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_3064_9_438()) return true;
    }
    }
    }
    if (jj_3R_FromItem_2952_5_166()) return true;
    xsp = jj_scanpos;
    if (jj_3_163()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_355()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_Table_2034_5_176()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2973_54_202()
 {
    if (jj_3R_Pivot_2833_5_196()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_6086_7_579()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_6081_7_577()
 {
    if (jj_scan_token(K_AS)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_6083_5_578()
 {
    if (jj_scan_token(K_LIKE)) return true;
    return false;
  }

  private boolean jj_3R_JoinHint_3011_5_731()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(174)) {
    jj_scanpos = xsp;
    if (jj_scan_token(129)) {
    jj_scanpos = xsp;
    if (jj_scan_token(182)) {
    jj_scanpos = xsp;
    if (jj_scan_token(248)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_CreateTable_6080_7_576()
 {
    if (jj_3R_RowMovement_6447_3_688()) return true;
    return false;
  }

  private boolean jj_3_354()
 {
    if (jj_3R_CreateParameter_6381_5_322()) return true;
    return false;
  }

  private boolean jj_3_161()
 {
    if (jj_3R_JoinerExpression_3036_5_205()) return true;
    return false;
  }

  private boolean jj_3R_JoinsList_3000_5_128()
 {
    Token xsp;
    if (jj_3_161()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_161()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CreateTable_6032_37_329()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2982_13_204()
 {
    if (jj_3R_SQLServerHints_2730_5_431()) return true;
    return false;
  }

  private boolean jj_3_158()
 {
    if (jj_3R_PivotXml_2861_5_201()) return true;
    return false;
  }

  private boolean jj_3_351()
 {
    if (jj_scan_token(K_EXCLUDE)) return true;
    if (jj_scan_token(K_WHERE)) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2977_13_203()
 {
    if (jj_3R_MySQLIndexHint_2744_9_142()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_6030_26_328()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    return false;
  }

  private boolean jj_3_160()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_2977_13_203()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2982_13_204()) return true;
    }
    return false;
  }

  private boolean jj_3_159()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_158()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2973_54_202()) return true;
    }
    return false;
  }

  private boolean jj_3_350()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_6030_26_328()) jj_scanpos = xsp;
    if (jj_scan_token(K_CHECK)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_6032_37_329()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_149()
 {
    if (jj_3R_UnPivot_2891_5_197()) return true;
    return false;
  }

  private boolean jj_3_153()
 {
    if (jj_3R_ParenthesedFromItem_2929_5_199()) return true;
    return false;
  }

  private boolean jj_3_157()
 {
    if (jj_3R_UnPivot_2891_5_197()) return true;
    return false;
  }

  private boolean jj_3_148()
 {
    if (jj_3R_Pivot_2833_5_196()) return true;
    return false;
  }

  private boolean jj_3_156()
 {
    if (jj_3R_SampleClause_2095_5_200()) return true;
    return false;
  }

  private boolean jj_3_155()
 {
    if (jj_3R_Alias_2679_5_141()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2967_9_412()
 {
    if (jj_3R_LateralSubSelect_2321_5_644()) return true;
    return false;
  }

  private boolean jj_3_151()
 {
    if (jj_3R_TableFunction_5724_5_198()) return true;
    return false;
  }

  private boolean jj_3_345()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) return true;
    }
    return false;
  }

  private boolean jj_3_344()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) return true;
    }
    return false;
  }

  private boolean jj_3_154()
 {
    if (jj_3R_ParenthesedSelect_2188_5_129()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_148()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_149()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_147()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Table_2034_5_176()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2959_9_411()
 {
    if (jj_3R_ParenthesedFromItem_2929_5_199()) return true;
    return false;
  }

  private boolean jj_3_152()
 {
    if (jj_3R_Table_2034_5_176()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2955_9_410()
 {
    if (jj_3R_TableFunction_5724_5_198()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_6008_26_327()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    return false;
  }

  private boolean jj_3_150()
 {
    if (jj_3R_Values_1422_5_144()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2952_5_166()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_150()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2955_9_410()) {
    jj_scanpos = xsp;
    if (jj_3_152()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2959_9_411()) {
    jj_scanpos = xsp;
    if (jj_3_154()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2967_9_412()) return true;
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_155()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_156()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_157()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_159()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_160()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_349()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_6008_26_327()) jj_scanpos = xsp;
    if (jj_scan_token(K_FOREIGN)) return true;
    if (jj_scan_token(K_KEY)) return true;
    if (jj_3R_ColumnNamesWithParamsList_5739_6_323()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5940_77_330()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_ParenthesedFromItem_2931_11_428()
 {
    if (jj_3R_JoinsList_3000_5_128()) return true;
    return false;
  }

  private boolean jj_3_348()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(316)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(120)) jj_scanpos = xsp;
    if (jj_scan_token(K_KEY)) return true;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    if (jj_3R_ColumnNamesWithParamsList_5739_6_323()) return true;
    return false;
  }

  private boolean jj_3R_ParenthesedFromItem_2929_5_199()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_FromItem_2952_5_166()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ParenthesedFromItem_2931_11_428()) jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5971_28_326()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(161)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateTable_5970_26_325()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5968_26_324()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    return false;
  }

  private boolean jj_3R_IntoClause_2916_5_165()
 {
    if (jj_scan_token(K_INTO)) return true;
    if (jj_3R_Table_2034_5_176()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_147()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_347()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5968_26_324()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5970_26_325()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateTable_5971_28_326()) return true;
    }
    if (jj_3R_ColumnNamesWithParamsList_5739_6_323()) return true;
    return false;
  }

  private boolean jj_3_146()
 {
    if (jj_3R_Alias_2679_5_141()) return true;
    return false;
  }

  private boolean jj_3R_UnPivot_2892_9_649()
 {
    if (jj_scan_token(K_INCLUDE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3_346()
 {
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    if (jj_3R_ColumnNamesWithParamsList_5739_6_323()) return true;
    return false;
  }

  private boolean jj_3R_UnPivot_2893_7_650()
 {
    if (jj_scan_token(K_EXCLUDE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3R_UnPivot_2892_7_427()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_UnPivot_2892_9_649()) {
    jj_scanpos = xsp;
    if (jj_3R_UnPivot_2893_7_650()) return true;
    }
    return false;
  }

  private boolean jj_3R_UnPivot_2891_5_197()
 {
    if (jj_scan_token(K_UNPIVOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_UnPivot_2892_7_427()) jj_scanpos = xsp;
    if (jj_scan_token(425)) return true;
    if (jj_3R_PivotForColumns_2782_5_755()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_PivotForColumns_2782_5_755()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_3R_SelectItemsList_2601_5_195()) return true;
    if (jj_scan_token(426)) return true;
    if (jj_scan_token(426)) return true;
    xsp = jj_scanpos;
    if (jj_3_146()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateTable_5942_13_331()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_ColumnDefinition_5821_5_565()) return true;
    return false;
  }

  private boolean jj_3R_PivotXml_2868_9_788()
 {
    if (jj_3R_PivotMultiInItems_2818_4_811()) return true;
    return false;
  }

  private boolean jj_3_352()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_5940_77_330()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_145()
 {
    if (jj_3R_SelectItemsList_2601_5_195()) return true;
    return false;
  }

  private boolean jj_3R_PivotXml_2866_9_787()
 {
    if (jj_3R_Select_2141_5_124()) return true;
    return false;
  }

  private boolean jj_3_144()
 {
    if (jj_scan_token(K_ANY)) return true;
    return false;
  }

  private boolean jj_3_353()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_352()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateTable_5942_13_331()) return true;
    }
    return false;
  }

  private boolean jj_3_343()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5933_6_575()
 {
    if (jj_3R_CreateParameter_6381_5_322()) return true;
    return false;
  }

  private boolean jj_3R_PivotXml_2861_5_201()
 {
    if (jj_scan_token(K_PIVOT)) return true;
    if (jj_scan_token(K_XML)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_3R_PivotFunctionItems_2796_5_779()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_PivotForColumns_2782_5_755()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_144()) {
    jj_scanpos = xsp;
    if (jj_3R_PivotXml_2866_9_787()) {
    jj_scanpos = xsp;
    if (jj_3_145()) {
    jj_scanpos = xsp;
    if (jj_3R_PivotXml_2868_9_788()) return true;
    }
    }
    }
    if (jj_scan_token(426)) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5929_7_574()
 {
    if (jj_scan_token(K_GLOBAL)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5926_7_573()
 {
    if (jj_scan_token(K_UNLOGGED)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5925_5_348()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5926_7_573()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5929_7_574()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_5933_6_575()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(K_TABLE)) return true;
    xsp = jj_scanpos;
    if (jj_3_343()) jj_scanpos = xsp;
    if (jj_3R_Table_2034_5_176()) return true;
    xsp = jj_scanpos;
    if (jj_3_353()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_354()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_6080_7_576()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_6081_7_577()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_6083_5_578()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_6086_7_579()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_143()
 {
    if (jj_3R_Alias_2679_5_141()) return true;
    return false;
  }

  private boolean jj_3R_Pivot_2837_7_780()
 {
    if (jj_3R_PivotMultiInItems_2818_4_811()) return true;
    return false;
  }

  private boolean jj_3_142()
 {
    if (jj_3R_SelectItemsList_2601_5_195()) return true;
    return false;
  }

  private boolean jj_3R_Pivot_2833_5_196()
 {
    if (jj_scan_token(K_PIVOT)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_3R_PivotFunctionItems_2796_5_779()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_PivotForColumns_2782_5_755()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_142()) {
    jj_scanpos = xsp;
    if (jj_3R_Pivot_2837_7_780()) return true;
    }
    if (jj_scan_token(426)) return true;
    if (jj_scan_token(426)) return true;
    xsp = jj_scanpos;
    if (jj_3_143()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PivotMultiInItems_2819_5_835()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_ExpressionListItem_2807_5_834()) return true;
    return false;
  }

  private boolean jj_3R_PivotMultiInItems_2818_4_811()
 {
    if (jj_3R_ExpressionListItem_2807_5_834()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PivotMultiInItems_2819_5_835()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ExpressionListItem_2808_7_864()
 {
    if (jj_3R_Alias_2679_5_141()) return true;
    return false;
  }

  private boolean jj_3R_ExpressionListItem_2807_5_834()
 {
    if (jj_3R_ParenthesedExpressionList_4070_5_210()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionListItem_2808_7_864()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PivotFunctionItems_2797_7_810()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_FunctionItem_2771_5_809()) return true;
    return false;
  }

  private boolean jj_3R_PivotFunctionItems_2796_5_779()
 {
    if (jj_3R_FunctionItem_2771_5_809()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PivotFunctionItems_2797_7_810()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_PivotForColumns_2785_9_786()
 {
    if (jj_3R_Column_1932_5_253()) return true;
    return false;
  }

  private boolean jj_3R_PivotForColumns_2783_9_785()
 {
    if (jj_3R_ParenthesedColumnList_4114_5_134()) return true;
    return false;
  }

  private boolean jj_3R_PivotForColumns_2782_5_755()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PivotForColumns_2783_9_785()) {
    jj_scanpos = xsp;
    if (jj_3R_PivotForColumns_2785_9_786()) return true;
    }
    return false;
  }

  private boolean jj_3R_Alias_2709_72_836()
 {
    if (jj_3R_ColDataType_6190_5_297()) return true;
    return false;
  }

  private boolean jj_3R_FunctionItem_2772_7_833()
 {
    if (jj_3R_Alias_2679_5_141()) return true;
    return false;
  }

  private boolean jj_3R_FunctionItem_2771_5_809()
 {
    if (jj_3R_Function_5488_5_248()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FunctionItem_2772_7_833()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_MySQLIndexHint_2758_10_789()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectNameWithoutValue_1960_5_131()) return true;
    return false;
  }

  private boolean jj_3R_Alias_2691_71_812()
 {
    if (jj_3R_ColDataType_6190_5_297()) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHints_2731_31_791()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SQLServerHint_2721_9_790()) return true;
    return false;
  }

  private boolean jj_3_342()
 {
    if (jj_3R_CreateParameter_6381_5_322()) return true;
    return false;
  }

  private boolean jj_3R_ColumnDefinition_5821_5_565()
 {
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    if (jj_3R_ColDataType_6190_5_297()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_342()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Alias_2704_50_640()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_Alias_2708_45_813()
 {
    if (jj_3R_ColDataType_6190_5_297()) return true;
    return false;
  }

  private boolean jj_3R_MySQLIndexHint_2744_9_142()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(322)) {
    jj_scanpos = xsp;
    if (jj_scan_token(279)) {
    jj_scanpos = xsp;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(142)) {
    jj_scanpos = xsp;
    if (jj_scan_token(161)) return true;
    }
    if (jj_scan_token(425)) return true;
    if (jj_3R_RelObjectNameWithoutValue_1960_5_131()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_MySQLIndexHint_2758_10_789()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_341()
 {
    if (jj_3R_CreateParameter_6381_5_322()) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHints_2730_5_431()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_3R_SQLServerHint_2721_9_790()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SQLServerHints_2731_31_791()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_CreateIndex_5791_15_321()
 {
    if (jj_scan_token(K_USING)) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHint_2723_9_816()
 {
    if (jj_scan_token(K_NOLOCK)) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHint_2721_9_815()
 {
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHint_2721_9_790()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SQLServerHint_2721_9_815()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLServerHint_2723_9_816()) return true;
    }
    return false;
  }

  private boolean jj_3R_Alias_2689_41_781()
 {
    if (jj_3R_ColDataType_6190_5_297()) return true;
    return false;
  }

  private boolean jj_3R_Alias_2709_18_814()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_2709_72_836()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_340()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_3R_Table_2034_5_176()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateIndex_5791_15_321()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_140()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_2708_45_813()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_Alias_2709_18_814()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_339()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_Alias_2704_15_639()
 {
    if (jj_3R_RelObjectNameWithoutStart_1984_5_146()) return true;
    return false;
  }

  private boolean jj_3R_Alias_2703_14_638()
 {
    if (jj_scan_token(K_AS)) return true;
    return false;
  }

  private boolean jj_3R_Alias_2691_17_782()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_2691_71_812()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Alias_2697_9_385()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_2703_14_638()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_2704_15_639()) {
    jj_scanpos = xsp;
    if (jj_3R_Alias_2704_50_640()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_140()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_139()
 {
    if (jj_3R_RelObjectNameWithoutStart_1984_5_146()) return true;
    return false;
  }

  private boolean jj_3_141()
 {
    if (jj_scan_token(K_AS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_139()) jj_scanpos = xsp;
    if (jj_scan_token(425)) return true;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    xsp = jj_scanpos;
    if (jj_3R_Alias_2689_41_781()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_Alias_2691_17_782()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_Alias_2679_5_141()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_141()) {
    jj_scanpos = xsp;
    if (jj_3R_Alias_2697_9_385()) return true;
    }
    return false;
  }

  private boolean jj_3R_ColumnNamesWithParamsList_5739_6_323()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    return false;
  }

  private boolean jj_3R_AllTableColumns_2663_6_192()
 {
    if (jj_3R_Table_2034_5_176()) return true;
    if (jj_scan_token(428)) return true;
    if (jj_3R_AllColumns_2648_5_426()) return true;
    return false;
  }

  private boolean jj_3R_TableFunction_5724_5_198()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(165)) jj_scanpos = xsp;
    if (jj_3R_Function_5488_5_248()) return true;
    return false;
  }

  private boolean jj_3_138()
 {
    if (jj_scan_token(K_REPLACE)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_3R_ColumnSelectItemsList_2584_5_727()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_137()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(97)) return true;
    }
    if (jj_3R_ParenthesedColumnList_4114_5_134()) return true;
    return false;
  }

  private boolean jj_3R_AllColumns_2648_5_426()
 {
    if (jj_scan_token(437)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_137()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_138()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_5709_10_819()
 {
    if (jj_scan_token(K_SEPARATOR)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_5708_10_818()
 {
    if (jj_3R_OrderByElements_3280_5_190()) return true;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_5706_9_527()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3_132()
 {
    if (jj_3R_AllTableColumns_2663_6_192()) return true;
    return false;
  }

  private boolean jj_3_136()
 {
    if (jj_3R_Alias_2679_5_141()) return true;
    return false;
  }

  private boolean jj_3_135()
 {
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_5705_5_281()
 {
    if (jj_scan_token(K_GROUP_CONCAT)) return true;
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_MySQLGroupConcat_5706_9_527()) jj_scanpos = xsp;
    if (jj_3R_ExpressionList_4033_5_209()) return true;
    xsp = jj_scanpos;
    if (jj_3R_MySQLGroupConcat_5708_10_818()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_MySQLGroupConcat_5709_10_819()) jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_134()
 {
    if (jj_3R_ConcatExpression_4271_5_194()) return true;
    return false;
  }

  private boolean jj_3_133()
 {
    if (jj_3R_XorExpression_3597_5_193()) return true;
    return false;
  }

  private boolean jj_3R_XMLSerializeExpr_5685_19_820()
 {
    if (jj_3R_OrderByElements_3280_5_190()) return true;
    return false;
  }

  private boolean jj_3R_SelectItem_2624_9_425()
 {
    if (jj_3R_AllTableColumns_2663_6_192()) return true;
    return false;
  }

  private boolean jj_3R_SelectItem_2622_9_424()
 {
    if (jj_3R_AllColumns_2648_5_426()) return true;
    return false;
  }

  private boolean jj_3R_SelectItem_2619_5_191()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SelectItem_2622_9_424()) {
    jj_scanpos = xsp;
    if (jj_3R_SelectItem_2624_9_425()) {
    jj_scanpos = xsp;
    if (jj_3_133()) {
    jj_scanpos = xsp;
    if (jj_3_134()) {
    jj_scanpos = xsp;
    if (jj_3_135()) return true;
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_136()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_WithList_2556_60_763()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_WithItem_2569_6_355()) return true;
    return false;
  }

  private boolean jj_3R_XMLSerializeExpr_5681_5_667()
 {
    if (jj_scan_token(K_XMLSERIALIZE)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_scan_token(K_XMLAGG)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_scan_token(K_XMLTEXT)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    if (jj_scan_token(426)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_XMLSerializeExpr_5685_19_820()) jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_ColDataType_6190_5_297()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_131()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SelectItem_2619_5_191()) return true;
    return false;
  }

  private boolean jj_3R_SelectItemsList_2601_5_195()
 {
    if (jj_3R_SelectItem_2619_5_191()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_131()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_338()
 {
    if (jj_3R_KeepExpression_5097_5_320()) return true;
    return false;
  }

  private boolean jj_3_130()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SelectItem_2619_5_191()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5604_60_318()
 {
    if (jj_3R_OrderByElements_3280_5_190()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5654_9_776()
 {
    if (jj_scan_token(K_RESPECT)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3_337()
 {
    if (jj_3R_Function_5488_5_248()) return true;
    return false;
  }

  private boolean jj_3R_ColumnSelectItemsList_2584_5_727()
 {
    if (jj_3R_SelectItem_2619_5_191()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_130()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_InternalFunction_5646_9_775()
 {
    if (jj_scan_token(K_IGNORE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5646_9_743()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_5646_9_775()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_5654_9_776()) return true;
    }
    return false;
  }

  private boolean jj_3R_InternalFunction_5641_13_774()
 {
    if (jj_3R_Column_1932_5_253()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5639_13_773()
 {
    if (jj_3R_Function_5488_5_248()) return true;
    return false;
  }

  private boolean jj_3R_WithItem_2571_8_715()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_SelectItemsList_2601_5_195()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_129()
 {
    if (jj_scan_token(K_RECURSIVE)) return true;
    return false;
  }

  private boolean jj_3R_WithItem_2569_6_355()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_129()) jj_scanpos = xsp;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    xsp = jj_scanpos;
    if (jj_3R_WithItem_2571_8_715()) jj_scanpos = xsp;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_ParenthesedSelect_2188_5_129()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5635_7_742()
 {
    if (jj_scan_token(428)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_5639_13_773()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_5641_13_774()) return true;
    }
    return false;
  }

  private boolean jj_3R_InternalFunction_5629_9_736()
 {
    if (jj_3R_PlainLimit_3354_5_716()) return true;
    return false;
  }

  private boolean jj_3R_WithList_2556_5_107()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_WithItem_2569_6_355()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_WithList_2556_60_763()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_InternalFunction_5623_9_762()
 {
    if (jj_scan_token(K_RESPECT)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5619_9_735()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_5619_9_761()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_5623_9_762()) return true;
    }
    return false;
  }

  private boolean jj_3R_InternalFunction_5619_9_761()
 {
    if (jj_scan_token(K_IGNORE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5614_13_772()
 {
    if (jj_scan_token(K_MAX)) return true;
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5612_13_771()
 {
    if (jj_scan_token(K_MIN)) return true;
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2496_53_648()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5611_9_734()
 {
    if (jj_scan_token(K_HAVING)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_5612_13_771()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_5614_13_772()) return true;
    }
    return false;
  }

  private boolean jj_3R_InternalFunction_5600_19_317()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5606_13_319()
 {
    if (jj_3R_Select_2141_5_124()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5599_19_316()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3_335()
 {
    if (jj_3R_ExpressionList_4033_5_209()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_5604_60_318()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_InternalFunction_5598_17_315()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3_128()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_ISOLATION)) return true;
    return false;
  }

  private boolean jj_3_127()
 {
    if (jj_scan_token(K_FETCH)) return true;
    return false;
  }

  private boolean jj_3_334()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_5598_17_315()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_5599_19_316()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_5600_19_317()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_126()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3_125()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    return false;
  }

  private boolean jj_3_124()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3_336()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_334()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_335()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_5606_13_319()) return true;
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_2523_7_768()
 {
    if (jj_3R_WithIsolation_3462_5_632()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2522_7_767()
 {
    if (jj_3R_Fetch_3414_5_631()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2521_7_766()
 {
    if (jj_3R_LimitWithOffset_3331_5_421()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2520_7_765()
 {
    if (jj_3R_Offset_3392_5_630()) return true;
    return false;
  }

  private boolean jj_3_333()
 {
    if (jj_scan_token(K_APPROXIMATE)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2519_7_764()
 {
    if (jj_3R_LimitWithOffset_3331_5_421()) return true;
    return false;
  }

  private boolean jj_3_123()
 {
    if (jj_3R_OrderByElements_3280_5_190()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5591_5_664()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_333()) jj_scanpos = xsp;
    if (jj_3R_RelObjectNames_1914_5_422()) return true;
    if (jj_scan_token(425)) return true;
    xsp = jj_scanpos;
    if (jj_3_336()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_5611_9_734()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_5619_9_735()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_5629_9_736()) jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_5635_7_742()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_5646_9_743()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_338()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SetOperationList_2511_13_189()
 {
    if (jj_3R_ParenthesedSelect_2188_5_129()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2509_13_188()
 {
    if (jj_3R_Values_1422_5_144()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2507_13_187()
 {
    if (jj_3R_PlainSelect_2364_5_143()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2503_13_186()
 {
    if (jj_scan_token(K_EXCEPT)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2496_19_423()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2496_19_647()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_2496_53_648()) return true;
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_2496_19_647()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3_332()
 {
    if (jj_3R_Function_5488_5_248()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2501_13_185()
 {
    if (jj_scan_token(K_MINUS)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2499_13_184()
 {
    if (jj_scan_token(K_INTERSECT)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2494_13_183()
 {
    if (jj_scan_token(K_UNION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2496_19_423()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SimpleFunction_5568_9_681()
 {
    if (jj_3R_Column_1932_5_253()) return true;
    return false;
  }

  private boolean jj_3_330()
 {
    if (jj_3R_SimpleExpressionList_4088_5_250()) return true;
    return false;
  }

  private boolean jj_3R_SimpleFunction_5566_9_680()
 {
    if (jj_3R_Function_5488_5_248()) return true;
    return false;
  }

  private boolean jj_3_329()
 {
    if (jj_3R_RegularCondition_3710_5_229()) return true;
    return false;
  }

  private boolean jj_3_122()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2494_13_183()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_2499_13_184()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_2501_13_185()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_2503_13_186()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2507_13_187()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_2509_13_188()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_2511_13_189()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_328()
 {
    if (jj_3R_SimpleFunction_5537_5_307()) return true;
    return false;
  }

  private boolean jj_3R_SimpleFunction_5562_7_553()
 {
    if (jj_scan_token(428)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SimpleFunction_5566_9_680()) {
    jj_scanpos = xsp;
    if (jj_3R_SimpleFunction_5568_9_681()) return true;
    }
    return false;
  }

  private boolean jj_3_326()
 {
    if (jj_3R_AllTableColumns_2663_6_192()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2488_5_145()
 {
    Token xsp;
    if (jj_3_122()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_122()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_123()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2519_7_764()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2520_7_765()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2521_7_766()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2522_7_767()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2523_7_768()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SimpleFunction_5551_13_314()
 {
    if (jj_3R_SimpleExpressionList_4088_5_250()) return true;
    return false;
  }

  private boolean jj_3R_SimpleFunction_5549_13_313()
 {
    if (jj_3R_RegularCondition_3710_5_229()) return true;
    return false;
  }

  private boolean jj_3R_SimpleFunction_5547_13_312()
 {
    if (jj_3R_SimpleFunction_5537_5_307()) return true;
    return false;
  }

  private boolean jj_3_327()
 {
    if (jj_3R_ParenthesedSelect_2188_5_129()) return true;
    return false;
  }

  private boolean jj_3R_SimpleFunction_5543_13_311()
 {
    if (jj_3R_AllTableColumns_2663_6_192()) return true;
    return false;
  }

  private boolean jj_3R_SimpleFunction_5541_13_310()
 {
    if (jj_scan_token(437)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2457_25_177()
 {
    if (jj_scan_token(K_NOWAIT)) return true;
    return false;
  }

  private boolean jj_3_331()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SimpleFunction_5541_13_310()) {
    jj_scanpos = xsp;
    if (jj_3R_SimpleFunction_5543_13_311()) {
    jj_scanpos = xsp;
    if (jj_3_327()) {
    jj_scanpos = xsp;
    if (jj_3R_SimpleFunction_5547_13_312()) {
    jj_scanpos = xsp;
    if (jj_3R_SimpleFunction_5549_13_313()) {
    jj_scanpos = xsp;
    if (jj_3R_SimpleFunction_5551_13_314()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_119()
 {
    if (jj_scan_token(K_OPTIMIZE)) return true;
    return false;
  }

  private boolean jj_3_116()
 {
    if (jj_scan_token(K_WAIT)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2458_18_178()
 {
    if (jj_scan_token(K_SKIP)) return true;
    if (jj_scan_token(K_LOCKED)) return true;
    return false;
  }

  private boolean jj_3R_SimpleFunction_5537_5_307()
 {
    if (jj_3R_RelObjectNames_1914_5_422()) return true;
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_331()) jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    xsp = jj_scanpos;
    if (jj_3R_SimpleFunction_5562_7_553()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_121()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_NO)) return true;
    if (jj_scan_token(K_LOG)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2453_15_182()
 {
    if (jj_scan_token(K_KEY)) return true;
    if (jj_scan_token(K_SHARE)) return true;
    return false;
  }

  private boolean jj_3_120()
 {
    if (jj_scan_token(K_INTO)) return true;
    if (jj_scan_token(K_TEMP)) return true;
    if (jj_3R_Table_2034_5_176()) return true;
    return false;
  }

  private boolean jj_3_117()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2457_25_177()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_2458_18_178()) return true;
    }
    return false;
  }

  private boolean jj_3R_PlainSelect_2456_11_798()
 {
    if (jj_3R_Wait_7287_5_831()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2452_15_181()
 {
    if (jj_scan_token(K_NO)) return true;
    if (jj_scan_token(K_KEY)) return true;
    if (jj_scan_token(K_UPDATE)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2460_7_396()
 {
    if (jj_3R_OptimizeFor_3479_5_643()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2451_15_180()
 {
    if (jj_scan_token(K_SHARE)) return true;
    return false;
  }

  private boolean jj_3_115()
 {
    if (jj_scan_token(K_OF)) return true;
    if (jj_3R_Table_2034_5_176()) return true;
    return false;
  }

  private boolean jj_3_112()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3_324()
 {
    if (jj_3R_NamedExpressionListExprFirst_4170_9_309()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2450_13_179()
 {
    if (jj_scan_token(K_UPDATE)) return true;
    return false;
  }

  private boolean jj_3_114()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_ISOLATION)) return true;
    return false;
  }

  private boolean jj_3_113()
 {
    if (jj_scan_token(K_FETCH)) return true;
    return false;
  }

  private boolean jj_3_111()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    return false;
  }

  private boolean jj_3_110()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3_109()
 {
    if (jj_3R_LimitBy_3378_5_175()) return true;
    return false;
  }

  private boolean jj_3_107()
 {
    if (jj_scan_token(K_ORDER)) return true;
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3_325()
 {
    if (jj_3R_ExpressionList_4033_5_209()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2444_11_393()
 {
    if (jj_3R_LimitWithOffset_3331_5_421()) return true;
    return false;
  }

  private boolean jj_3_118()
 {
    if (jj_scan_token(K_FOR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2450_13_179()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_2451_15_180()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_2452_15_181()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_2453_15_182()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_115()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2456_11_798()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_117()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SpecialStringFunctionWithNamedParameters_5512_13_554()
 {
    if (jj_3R_NamedExpressionListExprFirst_4170_9_309()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2446_7_395()
 {
    if (jj_3R_WithIsolation_3462_5_632()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2445_7_394()
 {
    if (jj_3R_Fetch_3414_5_631()) return true;
    return false;
  }

  private boolean jj_3_104()
 {
    if (jj_scan_token(K_ORDER)) return true;
    if (jj_scan_token(K_SIBLINGS)) return true;
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2443_7_392()
 {
    if (jj_3R_Offset_3392_5_630()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2442_7_391()
 {
    if (jj_3R_LimitWithOffset_3331_5_421()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2441_7_390()
 {
    if (jj_3R_LimitBy_3378_5_175()) return true;
    return false;
  }

  private boolean jj_3_108()
 {
    if (jj_scan_token(K_EMIT)) return true;
    if (jj_scan_token(K_CHANGES)) return true;
    return false;
  }

  private boolean jj_3_105()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_windowDefinition_5143_5_679()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2439_7_389()
 {
    if (jj_3R_OrderByElements_3280_5_190()) return true;
    return false;
  }

  private boolean jj_3R_SpecialStringFunctionWithNamedParameters_5508_9_308()
 {
    if (jj_scan_token(K_STRING_FUNCTION_NAME)) return true;
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_SpecialStringFunctionWithNamedParameters_5512_13_554()) {
    jj_scanpos = xsp;
    if (jj_3_325()) return true;
    }
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_106()
 {
    if (jj_scan_token(K_WINDOW)) return true;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_windowDefinition_5143_5_679()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_105()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_322()
 {
    if (jj_3R_SimpleFunction_5537_5_307()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2433_7_388()
 {
    if (jj_3R_OrderByElements_3280_5_190()) return true;
    return false;
  }

  private boolean jj_3_103()
 {
    if (jj_3R_ForClause_2233_5_173()) return true;
    return false;
  }

  private boolean jj_3_102()
 {
    if (jj_3R_Qualify_3268_5_172()) return true;
    return false;
  }

  private boolean jj_3_101()
 {
    if (jj_3R_Having_3257_5_170()) return true;
    return false;
  }

  private boolean jj_3_100()
 {
    if (jj_3R_GroupByColumnReferences_3209_5_171()) return true;
    return false;
  }

  private boolean jj_3_99()
 {
    if (jj_3R_Having_3257_5_170()) return true;
    return false;
  }

  private boolean jj_3_98()
 {
    if (jj_3R_OracleHierarchicalQueryClause_3177_5_169()) return true;
    return false;
  }

  private boolean jj_3_93()
 {
    if (jj_3R_JoinsList_3000_5_128()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2417_15_797()
 {
    if (jj_3R_LateralViews_2307_5_827()) return true;
    return false;
  }

  private boolean jj_3_97()
 {
    if (jj_3R_WhereClause_3167_5_168()) return true;
    return false;
  }

  private boolean jj_3R_Function_5492_11_494()
 {
    if (jj_3R_InternalFunction_5591_5_664()) return true;
    return false;
  }

  private boolean jj_3_96()
 {
    if (jj_3R_KSQLWindowClause_3128_5_167()) return true;
    return false;
  }

  private boolean jj_3_323()
 {
    if (jj_3R_SpecialStringFunctionWithNamedParameters_5508_9_308()) return true;
    return false;
  }

  private boolean jj_3R_Function_5490_11_493()
 {
    if (jj_3R_SimpleFunction_5537_5_307()) return true;
    return false;
  }

  private boolean jj_3_95()
 {
    if (jj_scan_token(K_FINAL)) return true;
    return false;
  }

  private boolean jj_3R_Function_5489_9_492()
 {
    if (jj_scan_token(OPENING_CURLY_BRACKET)) return true;
    if (jj_scan_token(K_FN)) return true;
    if (jj_3R_InternalFunction_5591_5_664()) return true;
    if (jj_scan_token(CLOSING_CURLY_BRACKET)) return true;
    return false;
  }

  private boolean jj_3_91()
 {
    if (jj_3R_JoinsList_3000_5_128()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2413_11_796()
 {
    if (jj_3R_LateralViews_2307_5_827()) return true;
    return false;
  }

  private boolean jj_3_94()
 {
    if (jj_scan_token(K_FROM)) return true;
    if (jj_scan_token(K_ONLY)) return true;
    if (jj_3R_FromItem_2952_5_166()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2417_15_797()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_93()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Function_5488_5_248()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Function_5489_9_492()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_Function_5490_11_493()) {
    jj_scanpos = xsp;
    if (jj_3_323()) {
    jj_scanpos = xsp;
    if (jj_3R_Function_5492_11_494()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_92()
 {
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_FromItem_2952_5_166()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2413_11_796()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_91()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_90()
 {
    if (jj_3R_IntoClause_2916_5_165()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2403_13_642()
 {
    if (jj_scan_token(K_VALUE)) return true;
    return false;
  }

  private boolean jj_3_89()
 {
    if (jj_3R_Top_3495_5_159()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2401_13_641()
 {
    if (jj_scan_token(K_STRUCT)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2399_9_387()
 {
    if (jj_scan_token(K_AS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2401_13_641()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_2403_13_642()) return true;
    }
    return false;
  }

  private boolean jj_3R_PlainSelect_2394_9_164()
 {
    if (jj_scan_token(K_SQL_CACHE)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2392_9_163()
 {
    if (jj_scan_token(K_SQL_NO_CACHE)) return true;
    return false;
  }

  private boolean jj_3_87()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_3R_SelectItemsList_2601_5_195()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2390_9_162()
 {
    if (jj_scan_token(K_SQL_CALC_FOUND_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2388_9_161()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    return false;
  }

  private boolean jj_3R_LambdaExpression_5462_5_252()
 {
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    if (jj_scan_token(472)) return true;
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2383_9_160()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_87()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_88()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_2383_9_160()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_2388_9_161()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_2390_9_162()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_2392_9_163()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_2394_9_164()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_86()
 {
    if (jj_3R_Top_3495_5_159()) return true;
    return false;
  }

  private boolean jj_3_85()
 {
    if (jj_3R_First_3564_5_158()) return true;
    return false;
  }

  private boolean jj_3R_FullTextSearch_5439_9_824()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(477)) {
    jj_scanpos = xsp;
    if (jj_scan_token(478)) {
    jj_scanpos = xsp;
    if (jj_scan_token(479)) {
    jj_scanpos = xsp;
    if (jj_scan_token(480)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_84()
 {
    if (jj_3R_Skip_3528_5_157()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2366_7_386()
 {
    if (jj_scan_token(K_STRAIGHT)) return true;
    return false;
  }

  private boolean jj_3R_FullTextSearch_5436_7_823()
 {
    if (jj_3R_JdbcNamedParameter_4613_5_278()) return true;
    return false;
  }

  private boolean jj_3R_FullTextSearch_5434_7_822()
 {
    if (jj_3R_JdbcParameter_3315_5_304()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2364_5_143()
 {
    if (jj_scan_token(K_SELECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2366_7_386()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_84()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_85()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_86()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_88()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2399_9_387()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_89()) jj_scanpos = xsp;
    if (jj_3R_SelectItemsList_2601_5_195()) return true;
    xsp = jj_scanpos;
    if (jj_3_90()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_92()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_94()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_95()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_96()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_97()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_98()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_99()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_100()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_101()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_102()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_103()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2433_7_388()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_106()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2439_7_389()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_108()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2441_7_390()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2442_7_391()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2443_7_392()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2444_11_393()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2445_7_394()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2446_7_395()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_118()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2460_7_396()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_120()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_121()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_FullTextSearch_5432_7_821()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_FullTextSearch_5429_5_284()
 {
    if (jj_scan_token(K_MATCH)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_3R_ColumnList_4102_5_132()) return true;
    if (jj_scan_token(426)) return true;
    if (jj_scan_token(K_AGAINST)) return true;
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FullTextSearch_5432_7_821()) {
    jj_scanpos = xsp;
    if (jj_3R_FullTextSearch_5434_7_822()) {
    jj_scanpos = xsp;
    if (jj_3R_FullTextSearch_5436_7_823()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_FullTextSearch_5439_9_824()) jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_321()
 {
    if (jj_3R_ExpressionList_4033_5_209()) return true;
    return false;
  }

  private boolean jj_3R_Execute_5407_11_751()
 {
    if (jj_scan_token(K_CALL)) return true;
    return false;
  }

  private boolean jj_3R_Execute_5406_11_750()
 {
    if (jj_scan_token(K_EXECUTE)) return true;
    return false;
  }

  private boolean jj_3R_Execute_5405_6_749()
 {
    if (jj_scan_token(K_EXEC)) return true;
    return false;
  }

  private boolean jj_3R_Execute_5405_5_700()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Execute_5405_6_749()) {
    jj_scanpos = xsp;
    if (jj_3R_Execute_5406_11_750()) {
    jj_scanpos = xsp;
    if (jj_3R_Execute_5407_11_751()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_LateralSubSelect_2321_5_644()
 {
    if (jj_scan_token(K_LATERAL)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_3R_Select_2141_5_124()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_83()
 {
    if (jj_scan_token(425)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_81()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(355)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) return true;
    }
    return false;
  }

  private boolean jj_3R_LateralViews_2308_7_853()
 {
    if (jj_3R_LateralView_2207_5_852()) return true;
    return false;
  }

  private boolean jj_3R_LateralViews_2307_5_827()
 {
    if (jj_3R_LateralView_2207_5_852()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_LateralViews_2308_7_853()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_80()
 {
    if (jj_scan_token(425)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_ForClause_2286_21_156()
 {
    if (jj_scan_token(K_ROOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_83()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_RowConstructor_5373_5_256()
 {
    if (jj_scan_token(K_ROW)) return true;
    if (jj_3R_ParenthesedExpressionList_4070_5_210()) return true;
    return false;
  }

  private boolean jj_3R_ForClause_2275_27_155()
 {
    if (jj_scan_token(K_ELEMENTS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_81()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ForClause_2274_27_154()
 {
    if (jj_scan_token(K_ROOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_80()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_82()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ForClause_2286_21_156()) {
    jj_scanpos = xsp;
    if (jj_scan_token(140)) {
    jj_scanpos = xsp;
    if (jj_scan_token(346)) return true;
    }
    }
    return false;
  }

  private boolean jj_3_77()
 {
    if (jj_scan_token(425)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_320()
 {
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    return false;
  }

  private boolean jj_3R_ForClause_2272_25_153()
 {
    if (jj_scan_token(K_BINARY)) return true;
    if (jj_scan_token(K_BASE64)) return true;
    return false;
  }

  private boolean jj_3R_WhenThenSearchCondition_5358_9_866()
 {
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3_78()
 {
    if (jj_scan_token(425)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_79()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ForClause_2272_25_153()) {
    jj_scanpos = xsp;
    if (jj_scan_token(313)) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2274_27_154()) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2275_27_155()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_75()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(355)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) return true;
    }
    return false;
  }

  private boolean jj_3_74()
 {
    if (jj_scan_token(425)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_ForClause_2281_9_419()
 {
    if (jj_scan_token(K_JSON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(223)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_82()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_WhenThenSearchCondition_5355_5_670()
 {
    if (jj_scan_token(K_WHEN)) return true;
    if (jj_3R_Expression_3587_5_122()) return true;
    if (jj_scan_token(K_THEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing) && !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_WhenThenSearchCondition_5358_9_866()) {
    jj_scanpos = xsp;
    if (jj_3_320()) return true;
    }
    return false;
  }

  private boolean jj_3R_ForClause_2261_27_152()
 {
    if (jj_scan_token(K_ROOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_77()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ForClause_2259_25_151()
 {
    if (jj_scan_token(K_BINARY)) return true;
    if (jj_scan_token(K_BASE64)) return true;
    return false;
  }

  private boolean jj_3_73()
 {
    if (jj_scan_token(425)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_319()
 {
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    return false;
  }

  private boolean jj_3R_ForClause_2267_13_858()
 {
    if (jj_scan_token(K_PATH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_78()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_79()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_5335_15_839()
 {
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3_76()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ForClause_2259_25_151()) {
    jj_scanpos = xsp;
    if (jj_scan_token(313)) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2261_27_152()) {
    jj_scanpos = xsp;
    if (jj_scan_token(352)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ForClause_2249_27_150()
 {
    if (jj_scan_token(K_ELEMENTS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_75()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ForClause_2248_27_149()
 {
    if (jj_scan_token(K_XMLSCHEMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_74()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ForClause_2246_27_148()
 {
    if (jj_scan_token(K_ROOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_73()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_5333_9_817()
 {
    if (jj_scan_token(K_ELSE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing) && !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_CaseWhenExpression_5335_15_839()) {
    jj_scanpos = xsp;
    if (jj_3_319()) return true;
    }
    return false;
  }

  private boolean jj_3R_ForClause_2244_25_147()
 {
    if (jj_scan_token(K_BINARY)) return true;
    if (jj_scan_token(K_BASE64)) return true;
    return false;
  }

  private boolean jj_3_71()
 {
    if (jj_scan_token(425)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_ForClause_2254_13_857()
 {
    if (jj_scan_token(K_EXPLICIT)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_76()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_5331_7_521()
 {
    if (jj_3R_WhenThenSearchCondition_5355_5_670()) return true;
    return false;
  }

  private boolean jj_3_318()
 {
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3_72()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ForClause_2244_25_147()) {
    jj_scanpos = xsp;
    if (jj_scan_token(313)) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2246_27_148()) {
    jj_scanpos = xsp;
    if (jj_scan_token(352)) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2248_27_149()) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2249_27_150()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_5329_5_275()
 {
    if (jj_scan_token(K_CASE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_318()) jj_scanpos = xsp;
    if (jj_3R_CaseWhenExpression_5331_7_521()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CaseWhenExpression_5331_7_521()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_CaseWhenExpression_5333_9_817()) jj_scanpos = xsp;
    if (jj_scan_token(K_END)) return true;
    return false;
  }

  private boolean jj_3R_ForClause_2240_19_878()
 {
    if (jj_scan_token(K_RAW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_71()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ForClause_2239_13_856()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ForClause_2240_19_878()) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_72()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CastExpression_5310_7_826()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_ForClause_2237_9_418()
 {
    if (jj_scan_token(K_XML)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ForClause_2239_13_856()) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2254_13_857()) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2267_13_858()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_CastExpression_5301_15_850()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_ColumnDefinition_5821_5_565()) return true;
    return false;
  }

  private boolean jj_3R_CastExpression_5305_9_825()
 {
    if (jj_3R_ColDataType_6190_5_297()) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_5218_91_895()
 {
    if (jj_scan_token(K_FOLLOWING)) return true;
    return false;
  }

  private boolean jj_3R_ForClause_2233_5_173()
 {
    if (jj_scan_token(K_FOR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2237_9_418()) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2281_9_419()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_ExtractExpression_5237_70_526()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_LateralView_2207_28_877()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3_317()
 {
    if (jj_scan_token(K_ROW)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_3R_ColumnDefinition_5821_5_565()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CastExpression_5301_15_850()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_5209_89_893()
 {
    if (jj_scan_token(K_FOLLOWING)) return true;
    return false;
  }

  private boolean jj_3_70()
 {
    if (jj_3R_RelObjectNameWithoutStart_1984_5_146()) return true;
    return false;
  }

  private boolean jj_3R_CastExpression_5281_5_286()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(266)) {
    jj_scanpos = xsp;
    if (jj_scan_token(311)) {
    jj_scanpos = xsp;
    if (jj_scan_token(147)) return true;
    }
    }
    }
    if (jj_scan_token(425)) return true;
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    if (jj_scan_token(K_AS)) return true;
    xsp = jj_scanpos;
    if (jj_3_317()) {
    jj_scanpos = xsp;
    if (jj_3R_CastExpression_5305_9_825()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_CastExpression_5310_7_826()) jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_5059_225_536()
 {
    if (jj_3R_Column_1932_5_253()) return true;
    return false;
  }

  private boolean jj_3R_LateralView_2207_5_852()
 {
    if (jj_scan_token(K_LATERAL)) return true;
    if (jj_scan_token(K_VIEW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_LateralView_2207_28_877()) jj_scanpos = xsp;
    if (jj_3R_Function_5488_5_248()) return true;
    xsp = jj_scanpos;
    if (jj_3_70()) jj_scanpos = xsp;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_RelObjectNameWithoutStart_1984_5_146()) return true;
    return false;
  }

  private boolean jj_3_69()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    return false;
  }

  private boolean jj_3R_ParenthesedSelect_2188_5_129()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_Select_2141_5_124()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_68()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3_67()
 {
    if (jj_scan_token(K_ORDER)) return true;
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3R_ImplicitCast_5256_6_277()
 {
    if (jj_3R_DataType_6140_5_334()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(423)) {
    jj_scanpos = xsp;
    if (jj_scan_token(397)) {
    jj_scanpos = xsp;
    if (jj_scan_token(396)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_WindowElement_5185_71_880()
 {
    if (jj_scan_token(K_RANGE)) return true;
    return false;
  }

  private boolean jj_3_308()
 {
    if (jj_3R_Function_5488_5_248()) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_5208_40_892()
 {
    if (jj_scan_token(K_PRECEDING)) return true;
    return false;
  }

  private boolean jj_3R_TableStatement_2172_5_694()
 {
    if (jj_scan_token(K_TABLE)) return true;
    return false;
  }

  private boolean jj_3R_ExtractExpression_5237_11_525()
 {
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_5218_26_894()
 {
    if (jj_scan_token(K_PRECEDING)) return true;
    return false;
  }

  private boolean jj_3_66()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_ISOLATION)) return true;
    return false;
  }

  private boolean jj_3_65()
 {
    if (jj_scan_token(K_FETCH)) return true;
    return false;
  }

  private boolean jj_3_64()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_5059_183_535()
 {
    if (jj_3R_Function_5488_5_248()) return true;
    return false;
  }

  private boolean jj_3_63()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3R_ExtractExpression_5235_5_280()
 {
    if (jj_scan_token(K_EXTRACT)) return true;
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExtractExpression_5237_11_525()) {
    jj_scanpos = xsp;
    if (jj_3R_ExtractExpression_5237_70_526()) return true;
    }
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_62()
 {
    if (jj_scan_token(K_ORDER)) return true;
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3R_Select_2156_7_376()
 {
    if (jj_3R_WithIsolation_3462_5_632()) return true;
    return false;
  }

  private boolean jj_3R_Select_2155_7_375()
 {
    if (jj_3R_Fetch_3414_5_631()) return true;
    return false;
  }

  private boolean jj_3R_Select_2154_7_374()
 {
    if (jj_3R_Offset_3392_5_630()) return true;
    return false;
  }

  private boolean jj_3R_Select_2153_7_373()
 {
    if (jj_3R_LimitWithOffset_3331_5_421()) return true;
    return false;
  }

  private boolean jj_3_316()
 {
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowOffset_5218_26_894()) {
    jj_scanpos = xsp;
    if (jj_3R_WindowOffset_5218_91_895()) return true;
    }
    return false;
  }

  private boolean jj_3R_Select_2151_7_372()
 {
    if (jj_3R_OrderByElements_3280_5_190()) return true;
    return false;
  }

  private boolean jj_3_315()
 {
    if (jj_scan_token(K_CURRENT)) return true;
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3_60()
 {
    if (jj_3R_ParenthesedSelect_2188_5_129()) return true;
    return false;
  }

  private boolean jj_3_61()
 {
    if (jj_3R_SetOperationList_2488_5_145()) return true;
    return false;
  }

  private boolean jj_3_59()
 {
    if (jj_3R_Values_1422_5_144()) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_5207_17_552()
 {
    if (jj_scan_token(K_UNBOUNDED)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowOffset_5208_40_892()) {
    jj_scanpos = xsp;
    if (jj_3R_WindowOffset_5209_89_893()) return true;
    }
    return false;
  }

  private boolean jj_3_58()
 {
    if (jj_3R_PlainSelect_2364_5_143()) return true;
    return false;
  }

  private boolean jj_3R_Select_2141_7_371()
 {
    if (jj_3R_WithList_2556_5_107()) return true;
    return false;
  }

  private boolean jj_3R_Select_2141_5_124()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Select_2141_7_371()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_58()) {
    jj_scanpos = xsp;
    if (jj_3_59()) {
    jj_scanpos = xsp;
    if (jj_3_60()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3_61()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Select_2151_7_372()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Select_2153_7_373()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Select_2154_7_374()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Select_2155_7_375()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Select_2156_7_376()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_IntervalExpression_5059_153_534()
 {
    if (jj_3R_JdbcNamedParameter_4613_5_278()) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_5206_5_306()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowOffset_5207_17_552()) {
    jj_scanpos = xsp;
    if (jj_3_315()) {
    jj_scanpos = xsp;
    if (jj_3_316()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_SelectWithWithItems_2125_5_356()
 {
    if (jj_3R_Select_2141_5_124()) return true;
    return false;
  }

  private boolean jj_3_314()
 {
    if (jj_3R_WindowOffset_5206_5_306()) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_5186_7_881()
 {
    if (jj_scan_token(K_BETWEEN)) return true;
    if (jj_3R_WindowOffset_5206_5_306()) return true;
    if (jj_scan_token(K_AND)) return true;
    if (jj_3R_WindowOffset_5206_5_306()) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_5185_6_879()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3_57()
 {
    if (jj_scan_token(K_SEED)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_3R_Number_2073_5_754()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_5185_5_861()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowElement_5185_6_879()) {
    jj_scanpos = xsp;
    if (jj_3R_WindowElement_5185_71_880()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_WindowElement_5186_7_881()) {
    jj_scanpos = xsp;
    if (jj_3_314()) return true;
    }
    return false;
  }

  private boolean jj_3_56()
 {
    if (jj_scan_token(K_REPEATABLE)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_3R_Number_2073_5_754()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_SampleClause_2099_15_651()
 {
    if (jj_scan_token(K_BLOCK)) return true;
    return false;
  }

  private boolean jj_3_313()
 {
    if (jj_3R_windowFun_5114_5_305()) return true;
    return false;
  }

  private boolean jj_3R_SampleClause_2102_9_430()
 {
    if (jj_scan_token(K_TABLESAMPLE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(294)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) return true;
    }
    return false;
  }

  private boolean jj_3R_AnalyticExpression_5170_11_520()
 {
    if (jj_3R_windowFun_5114_5_305()) return true;
    return false;
  }

  private boolean jj_3R_KeepExpression_5097_79_808()
 {
    if (jj_scan_token(K_LAST)) return true;
    return false;
  }

  private boolean jj_3R_SampleClause_2096_9_429()
 {
    if (jj_scan_token(K_SAMPLE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SampleClause_2099_15_651()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AnalyticExpression_5166_9_519()
 {
    if (jj_scan_token(K_FILTER)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_scan_token(K_WHERE)) return true;
    if (jj_3R_Expression_3587_5_122()) return true;
    if (jj_scan_token(426)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_313()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SampleClause_2095_5_200()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SampleClause_2096_9_429()) {
    jj_scanpos = xsp;
    if (jj_3R_SampleClause_2102_9_430()) return true;
    }
    if (jj_scan_token(425)) return true;
    if (jj_3R_Number_2073_5_754()) return true;
    if (jj_scan_token(426)) return true;
    xsp = jj_scanpos;
    if (jj_3_56()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_57()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_307()
 {
    if (jj_3R_JdbcParameter_3315_5_304()) return true;
    return false;
  }

  private boolean jj_3R_AnalyticExpression_5165_5_274()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AnalyticExpression_5166_9_519()) {
    jj_scanpos = xsp;
    if (jj_3R_AnalyticExpression_5170_11_520()) return true;
    }
    return false;
  }

  private boolean jj_3_312()
 {
    if (jj_3R_ComplexExpressionList_4126_5_249()) return true;
    return false;
  }

  private boolean jj_3_310()
 {
    if (jj_3R_ComplexExpressionList_4126_5_249()) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_5059_101_533()
 {
    if (jj_3R_JdbcParameter_3315_5_304()) return true;
    return false;
  }

  private boolean jj_3R_windowDefinition_5146_11_860()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_ComplexExpressionList_4126_5_249()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_Number_2076_9_784()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_windowDefinition_5145_10_859()
 {
    if (jj_3R_ComplexExpressionList_4126_5_249()) return true;
    return false;
  }

  private boolean jj_3R_windowDefinition_5149_6_830()
 {
    if (jj_3R_WindowElement_5185_5_861()) return true;
    return false;
  }

  private boolean jj_3R_windowDefinition_5148_6_829()
 {
    if (jj_3R_OrderByElements_3280_5_190()) return true;
    return false;
  }

  private boolean jj_3R_Number_2074_9_783()
 {
    if (jj_scan_token(S_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_5129_23_897()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_ComplexExpressionList_4126_5_249()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_5128_22_896()
 {
    if (jj_3R_ComplexExpressionList_4126_5_249()) return true;
    return false;
  }

  private boolean jj_3R_windowDefinition_5144_6_828()
 {
    if (jj_scan_token(K_PARTITION)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowDefinition_5145_10_859()) {
    jj_scanpos = xsp;
    if (jj_3R_windowDefinition_5146_11_860()) return true;
    }
    return false;
  }

  private boolean jj_3R_Number_2073_5_754()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Number_2074_9_783()) {
    jj_scanpos = xsp;
    if (jj_3R_Number_2076_9_784()) return true;
    }
    return false;
  }

  private boolean jj_3R_windowDefinition_5143_5_679()
 {
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowDefinition_5144_6_828()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowDefinition_5148_6_829()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowDefinition_5149_6_830()) jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_5127_17_891()
 {
    if (jj_scan_token(K_PARTITION)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_5128_22_896()) {
    jj_scanpos = xsp;
    if (jj_3R_windowFun_5129_23_897()) return true;
    }
    return false;
  }

  private boolean jj_3_55()
 {
    if (jj_3R_MySQLIndexHint_2744_9_142()) return true;
    return false;
  }

  private boolean jj_3_54()
 {
    if (jj_3R_Alias_2679_5_141()) return true;
    return false;
  }

  private boolean jj_3R_KeepExpression_5097_42_807()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3_311()
 {
    if (jj_scan_token(K_OVER)) return true;
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_5127_17_891()) jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_TableWithAliasAndMysqlIndexHint_2061_5_609()
 {
    if (jj_3R_Table_2034_5_176()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_54()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_55()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_windowFun_5123_9_551()
 {
    if (jj_3R_windowDefinition_5143_5_679()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_311()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_windowFun_5121_9_550()
 {
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    return false;
  }

  private boolean jj_3_53()
 {
    if (jj_3R_Alias_2679_5_141()) return true;
    return false;
  }

  private boolean jj_3R_windowFun_5117_9_549()
 {
    if (jj_scan_token(K_WITHIN)) return true;
    if (jj_scan_token(K_GROUP)) return true;
    return false;
  }

  private boolean jj_3R_TableWithAlias_2049_5_136()
 {
    if (jj_3R_Table_2034_5_176()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_53()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_windowFun_5115_9_548()
 {
    if (jj_scan_token(K_OVER)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_5114_5_305()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_5115_9_548()) {
    jj_scanpos = xsp;
    if (jj_3R_windowFun_5117_9_549()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_windowFun_5121_9_550()) {
    jj_scanpos = xsp;
    if (jj_3R_windowFun_5123_9_551()) return true;
    }
    return false;
  }

  private boolean jj_3R_Table_2034_5_176()
 {
    if (jj_3R_RelObjectNames_1914_5_422()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameExt2_2024_7_384()
 {
    if (jj_3R_RelObjectNameExt_2002_5_368()) return true;
    return false;
  }

  private boolean jj_3R_KeepExpression_5097_5_320()
 {
    if (jj_scan_token(K_KEEP)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_KeepExpression_5097_42_807()) {
    jj_scanpos = xsp;
    if (jj_3R_KeepExpression_5097_79_808()) return true;
    }
    if (jj_3R_OrderByElements_3280_5_190()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameExt2_2024_5_139()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectNameExt2_2024_7_384()) {
    jj_scanpos = xsp;
    if (jj_scan_token(118)) {
    jj_scanpos = xsp;
    if (jj_scan_token(272)) {
    jj_scanpos = xsp;
    if (jj_scan_token(65)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_RelObjectNames_1916_99_138()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(428)) {
    jj_scanpos = xsp;
    if (jj_scan_token(361)) return true;
    }
    return false;
  }

  private boolean jj_3R_IntervalExpressionWithoutInterval_5080_5_290()
 {
    if (jj_scan_token(K_DATE_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameExt_2002_7_624()
 {
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameExt_2002_5_368()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectNameExt_2002_7_624()) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(286)) {
    jj_scanpos = xsp;
    if (jj_scan_token(167)) {
    jj_scanpos = xsp;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(277)) {
    jj_scanpos = xsp;
    if (jj_scan_token(133)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(219)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) {
    jj_scanpos = xsp;
    if (jj_scan_token(208)) {
    jj_scanpos = xsp;
    if (jj_scan_token(230)) {
    jj_scanpos = xsp;
    if (jj_scan_token(231)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) {
    jj_scanpos = xsp;
    if (jj_scan_token(125)) {
    jj_scanpos = xsp;
    if (jj_scan_token(214)) {
    jj_scanpos = xsp;
    if (jj_scan_token(190)) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_IntervalExpression_5059_19_532()
 {
    if (jj_scan_token(454)) return true;
    return false;
  }

  private boolean jj_3_309()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(404)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) return true;
    }
    return false;
  }

  private boolean jj_3R_RelObjectNameWithoutStart_1984_6_397()
 {
    if (jj_3R_RelObjectNameWithoutValue_1960_5_131()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameWithoutStart_1984_5_146()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectNameWithoutStart_1984_6_397()) {
    jj_scanpos = xsp;
    if (jj_scan_token(307)) {
    jj_scanpos = xsp;
    if (jj_scan_token(332)) {
    jj_scanpos = xsp;
    if (jj_scan_token(333)) {
    jj_scanpos = xsp;
    if (jj_scan_token(149)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_305()
 {
    if (jj_3R_ComplexExpressionList_4126_5_249()) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_5058_1_285()
 {
    if (jj_scan_token(K_INTERVAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IntervalExpression_5059_19_532()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(397)) {
    jj_scanpos = xsp;
    if (jj_scan_token(396)) {
    jj_scanpos = xsp;
    if (jj_scan_token(423)) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_5059_101_533()) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_5059_153_534()) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_5059_183_535()) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_5059_225_536()) return true;
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_309()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_5032_19_875()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_ComplexExpressionList_4126_5_249()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_5031_18_874()
 {
    if (jj_3R_ComplexExpressionList_4126_5_249()) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_5035_14_849()
 {
    if (jj_3R_WindowElement_5185_5_861()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectName_1972_6_420()
 {
    if (jj_3R_RelObjectNameWithoutValue_1960_5_131()) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_5034_14_848()
 {
    if (jj_3R_OrderByElements_3280_5_190()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectName_1972_5_174()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectName_1972_6_420()) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) {
    jj_scanpos = xsp;
    if (jj_scan_token(149)) {
    jj_scanpos = xsp;
    if (jj_scan_token(209)) {
    jj_scanpos = xsp;
    if (jj_scan_token(287)) {
    jj_scanpos = xsp;
    if (jj_scan_token(307)) {
    jj_scanpos = xsp;
    if (jj_scan_token(332)) {
    jj_scanpos = xsp;
    if (jj_scan_token(333)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(296)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_scan_token(233)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_5030_14_847()
 {
    if (jj_scan_token(K_PARTITION)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_5031_18_874()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_5032_19_875()) return true;
    }
    return false;
  }

  private boolean jj_3_306()
 {
    if (jj_scan_token(K_OVER)) return true;
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_5030_14_847()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_5034_14_848()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_5035_14_849()) jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameWithoutValue_1960_5_131()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(373)) {
    jj_scanpos = xsp;
    if (jj_scan_token(404)) {
    jj_scanpos = xsp;
    if (jj_scan_token(424)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(329)) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) {
    jj_scanpos = xsp;
    if (jj_scan_token(303)) {
    jj_scanpos = xsp;
    if (jj_scan_token(3)) {
    jj_scanpos = xsp;
    if (jj_scan_token(4)) {
    jj_scanpos = xsp;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(6)) {
    jj_scanpos = xsp;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(337)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(429)) {
    jj_scanpos = xsp;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(430)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(79)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(97)) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(108)) {
    jj_scanpos = xsp;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(163)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(127)) {
    jj_scanpos = xsp;
    if (jj_scan_token(129)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(138)) {
    jj_scanpos = xsp;
    if (jj_scan_token(141)) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(146)) {
    jj_scanpos = xsp;
    if (jj_scan_token(147)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(153)) {
    jj_scanpos = xsp;
    if (jj_scan_token(155)) {
    jj_scanpos = xsp;
    if (jj_scan_token(160)) {
    jj_scanpos = xsp;
    if (jj_scan_token(161)) {
    jj_scanpos = xsp;
    if (jj_scan_token(162)) {
    jj_scanpos = xsp;
    if (jj_scan_token(164)) {
    jj_scanpos = xsp;
    if (jj_scan_token(166)) {
    jj_scanpos = xsp;
    if (jj_scan_token(172)) {
    jj_scanpos = xsp;
    if (jj_scan_token(170)) {
    jj_scanpos = xsp;
    if (jj_scan_token(171)) {
    jj_scanpos = xsp;
    if (jj_scan_token(173)) {
    jj_scanpos = xsp;
    if (jj_scan_token(174)) {
    jj_scanpos = xsp;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(177)) {
    jj_scanpos = xsp;
    if (jj_scan_token(178)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) {
    jj_scanpos = xsp;
    if (jj_scan_token(181)) {
    jj_scanpos = xsp;
    if (jj_scan_token(182)) {
    jj_scanpos = xsp;
    if (jj_scan_token(183)) {
    jj_scanpos = xsp;
    if (jj_scan_token(185)) {
    jj_scanpos = xsp;
    if (jj_scan_token(186)) {
    jj_scanpos = xsp;
    if (jj_scan_token(187)) {
    jj_scanpos = xsp;
    if (jj_scan_token(189)) {
    jj_scanpos = xsp;
    if (jj_scan_token(191)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) {
    jj_scanpos = xsp;
    if (jj_scan_token(194)) {
    jj_scanpos = xsp;
    if (jj_scan_token(195)) {
    jj_scanpos = xsp;
    if (jj_scan_token(196)) {
    jj_scanpos = xsp;
    if (jj_scan_token(197)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) {
    jj_scanpos = xsp;
    if (jj_scan_token(200)) {
    jj_scanpos = xsp;
    if (jj_scan_token(201)) {
    jj_scanpos = xsp;
    if (jj_scan_token(202)) {
    jj_scanpos = xsp;
    if (jj_scan_token(205)) {
    jj_scanpos = xsp;
    if (jj_scan_token(204)) {
    jj_scanpos = xsp;
    if (jj_scan_token(206)) {
    jj_scanpos = xsp;
    if (jj_scan_token(207)) {
    jj_scanpos = xsp;
    if (jj_scan_token(211)) {
    jj_scanpos = xsp;
    if (jj_scan_token(217)) {
    jj_scanpos = xsp;
    if (jj_scan_token(218)) {
    jj_scanpos = xsp;
    if (jj_scan_token(220)) {
    jj_scanpos = xsp;
    if (jj_scan_token(221)) {
    jj_scanpos = xsp;
    if (jj_scan_token(222)) {
    jj_scanpos = xsp;
    if (jj_scan_token(223)) {
    jj_scanpos = xsp;
    if (jj_scan_token(224)) {
    jj_scanpos = xsp;
    if (jj_scan_token(226)) {
    jj_scanpos = xsp;
    if (jj_scan_token(227)) {
    jj_scanpos = xsp;
    if (jj_scan_token(431)) {
    jj_scanpos = xsp;
    if (jj_scan_token(228)) {
    jj_scanpos = xsp;
    if (jj_scan_token(229)) {
    jj_scanpos = xsp;
    if (jj_scan_token(232)) {
    jj_scanpos = xsp;
    if (jj_scan_token(234)) {
    jj_scanpos = xsp;
    if (jj_scan_token(235)) {
    jj_scanpos = xsp;
    if (jj_scan_token(236)) {
    jj_scanpos = xsp;
    if (jj_scan_token(237)) {
    jj_scanpos = xsp;
    if (jj_scan_token(238)) {
    jj_scanpos = xsp;
    if (jj_scan_token(239)) {
    jj_scanpos = xsp;
    if (jj_scan_token(241)) {
    jj_scanpos = xsp;
    if (jj_scan_token(240)) {
    jj_scanpos = xsp;
    if (jj_scan_token(242)) {
    jj_scanpos = xsp;
    if (jj_scan_token(243)) {
    jj_scanpos = xsp;
    if (jj_scan_token(244)) {
    jj_scanpos = xsp;
    if (jj_scan_token(247)) {
    jj_scanpos = xsp;
    if (jj_scan_token(248)) {
    jj_scanpos = xsp;
    if (jj_scan_token(249)) {
    jj_scanpos = xsp;
    if (jj_scan_token(250)) {
    jj_scanpos = xsp;
    if (jj_scan_token(251)) {
    jj_scanpos = xsp;
    if (jj_scan_token(252)) {
    jj_scanpos = xsp;
    if (jj_scan_token(245)) {
    jj_scanpos = xsp;
    if (jj_scan_token(253)) {
    jj_scanpos = xsp;
    if (jj_scan_token(256)) {
    jj_scanpos = xsp;
    if (jj_scan_token(257)) {
    jj_scanpos = xsp;
    if (jj_scan_token(254)) {
    jj_scanpos = xsp;
    if (jj_scan_token(255)) {
    jj_scanpos = xsp;
    if (jj_scan_token(258)) {
    jj_scanpos = xsp;
    if (jj_scan_token(246)) {
    jj_scanpos = xsp;
    if (jj_scan_token(261)) {
    jj_scanpos = xsp;
    if (jj_scan_token(262)) {
    jj_scanpos = xsp;
    if (jj_scan_token(263)) {
    jj_scanpos = xsp;
    if (jj_scan_token(264)) {
    jj_scanpos = xsp;
    if (jj_scan_token(265)) {
    jj_scanpos = xsp;
    if (jj_scan_token(432)) {
    jj_scanpos = xsp;
    if (jj_scan_token(433)) {
    jj_scanpos = xsp;
    if (jj_scan_token(268)) {
    jj_scanpos = xsp;
    if (jj_scan_token(269)) {
    jj_scanpos = xsp;
    if (jj_scan_token(270)) {
    jj_scanpos = xsp;
    if (jj_scan_token(271)) {
    jj_scanpos = xsp;
    if (jj_scan_token(275)) {
    jj_scanpos = xsp;
    if (jj_scan_token(274)) {
    jj_scanpos = xsp;
    if (jj_scan_token(276)) {
    jj_scanpos = xsp;
    if (jj_scan_token(278)) {
    jj_scanpos = xsp;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(279)) {
    jj_scanpos = xsp;
    if (jj_scan_token(280)) {
    jj_scanpos = xsp;
    if (jj_scan_token(282)) {
    jj_scanpos = xsp;
    if (jj_scan_token(328)) {
    jj_scanpos = xsp;
    if (jj_scan_token(283)) {
    jj_scanpos = xsp;
    if (jj_scan_token(284)) {
    jj_scanpos = xsp;
    if (jj_scan_token(285)) {
    jj_scanpos = xsp;
    if (jj_scan_token(288)) {
    jj_scanpos = xsp;
    if (jj_scan_token(289)) {
    jj_scanpos = xsp;
    if (jj_scan_token(290)) {
    jj_scanpos = xsp;
    if (jj_scan_token(291)) {
    jj_scanpos = xsp;
    if (jj_scan_token(292)) {
    jj_scanpos = xsp;
    if (jj_scan_token(293)) {
    jj_scanpos = xsp;
    if (jj_scan_token(294)) {
    jj_scanpos = xsp;
    if (jj_scan_token(295)) {
    jj_scanpos = xsp;
    if (jj_scan_token(298)) {
    jj_scanpos = xsp;
    if (jj_scan_token(301)) {
    jj_scanpos = xsp;
    if (jj_scan_token(302)) {
    jj_scanpos = xsp;
    if (jj_scan_token(300)) {
    jj_scanpos = xsp;
    if (jj_scan_token(304)) {
    jj_scanpos = xsp;
    if (jj_scan_token(434)) {
    jj_scanpos = xsp;
    if (jj_scan_token(435)) {
    jj_scanpos = xsp;
    if (jj_scan_token(306)) {
    jj_scanpos = xsp;
    if (jj_scan_token(299)) {
    jj_scanpos = xsp;
    if (jj_scan_token(310)) {
    jj_scanpos = xsp;
    if (jj_scan_token(309)) {
    jj_scanpos = xsp;
    if (jj_scan_token(312)) {
    jj_scanpos = xsp;
    if (jj_scan_token(313)) {
    jj_scanpos = xsp;
    if (jj_scan_token(317)) {
    jj_scanpos = xsp;
    if (jj_scan_token(321)) {
    jj_scanpos = xsp;
    if (jj_scan_token(330)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(320)) {
    jj_scanpos = xsp;
    if (jj_scan_token(436)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) {
    jj_scanpos = xsp;
    if (jj_scan_token(331)) {
    jj_scanpos = xsp;
    if (jj_scan_token(334)) {
    jj_scanpos = xsp;
    if (jj_scan_token(335)) {
    jj_scanpos = xsp;
    if (jj_scan_token(336)) {
    jj_scanpos = xsp;
    if (jj_scan_token(338)) {
    jj_scanpos = xsp;
    if (jj_scan_token(344)) {
    jj_scanpos = xsp;
    if (jj_scan_token(345)) {
    jj_scanpos = xsp;
    if (jj_scan_token(347)) {
    jj_scanpos = xsp;
    if (jj_scan_token(348)) {
    jj_scanpos = xsp;
    if (jj_scan_token(351)) {
    jj_scanpos = xsp;
    if (jj_scan_token(352)) {
    jj_scanpos = xsp;
    if (jj_scan_token(353)) {
    jj_scanpos = xsp;
    if (jj_scan_token(354)) {
    jj_scanpos = xsp;
    if (jj_scan_token(355)) {
    jj_scanpos = xsp;
    if (jj_scan_token(356)) {
    jj_scanpos = xsp;
    if (jj_scan_token(357)) {
    jj_scanpos = xsp;
    if (jj_scan_token(358)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_304()
 {
    if (jj_scan_token(K_FILTER)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_scan_token(K_WHERE)) return true;
    if (jj_3R_Expression_3587_5_122()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_5014_15_873()
 {
    if (jj_scan_token(K_ABSENT)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_5010_15_846()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_303()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_5014_15_873()) return true;
    }
    return false;
  }

  private boolean jj_3_303()
 {
    if (jj_scan_token(K_NULL)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_5007_15_845()
 {
    if (jj_3R_OrderByElements_3280_5_190()) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_5006_15_844()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3_52()
 {
    if (jj_3R_ArrayConstructor_4686_5_140()) return true;
    return false;
  }

  private boolean jj_3R_Column_1935_7_539()
 {
    if (jj_scan_token(428)) return true;
    if (jj_scan_token(K_NEXTVAL)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_5002_11_531()
 {
    if (jj_scan_token(K_JSON_ARRAYAGG)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_3R_Expression_3587_5_122()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_5006_15_844()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_5007_15_845()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_5010_15_846()) jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_51()
 {
    if (jj_scan_token(K_COMMENT)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4995_15_872()
 {
    if (jj_scan_token(K_WITHOUT)) return true;
    if (jj_scan_token(K_UNIQUE)) return true;
    if (jj_scan_token(K_KEYS)) return true;
    return false;
  }

  private boolean jj_3R_Column_1932_5_253()
 {
    if (jj_3R_RelObjectNames_1914_5_422()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_51()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Column_1935_7_539()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_52()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4991_15_871()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_UNIQUE)) return true;
    if (jj_scan_token(K_KEYS)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4991_15_843()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4991_15_871()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_4995_15_872()) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4985_15_870()
 {
    if (jj_scan_token(K_ABSENT)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4981_15_842()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_302()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_4985_15_870()) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4975_21_840()
 {
    if (jj_scan_token(K_VALUE)) return true;
    return false;
  }

  private boolean jj_3_50()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(428)) {
    jj_scanpos = xsp;
    if (jj_scan_token(361)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_RelObjectNames_1916_99_138()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_RelObjectNameExt2_2024_5_139()) return true;
    return false;
  }

  private boolean jj_3_302()
 {
    if (jj_scan_token(K_NULL)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4892_101_888()
 {
    if (jj_scan_token(K_VALUE)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4978_15_841()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNames_1914_5_422()
 {
    if (jj_3R_RelObjectNameExt_2002_5_368()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_50()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4973_15_677()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4971_11_530()
 {
    if (jj_scan_token(K_JSON_OBJECTAGG)) return true;
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4973_15_677()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(372)) {
    jj_scanpos = xsp;
    if (jj_scan_token(396)) {
    jj_scanpos = xsp;
    if (jj_scan_token(397)) {
    jj_scanpos = xsp;
    if (jj_scan_token(399)) {
    jj_scanpos = xsp;
    if (jj_scan_token(423)) {
    jj_scanpos = xsp;
    if (jj_scan_token(404)) {
    jj_scanpos = xsp;
    if (jj_scan_token(424)) return true;
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(361)) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_4975_21_840()) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(404)) {
    jj_scanpos = xsp;
    if (jj_scan_token(424)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4978_15_841()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4981_15_842()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4991_15_843()) jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4871_104_303()
 {
    if (jj_scan_token(K_VALUE)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4969_5_283()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4971_11_530()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_5002_11_531()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_304()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_306()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_299()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4943_19_676()
 {
    if (jj_scan_token(K_ABSENT)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4936_25_890()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Expression_3587_5_122()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_299()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_298()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3_49()
 {
    if (jj_scan_token(K_DELETE)) return true;
    if (jj_scan_token(K_WHERE)) return true;
    return false;
  }

  private boolean jj_3_301()
 {
    if (jj_3R_Expression_3587_5_122()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_298()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JsonFunction_4936_25_890()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_300()
 {
    if (jj_scan_token(K_NULL)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3_297()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_300()) {
    jj_scanpos = xsp;
    if (jj_3_301()) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonFunction_4916_23_741()
 {
    if (jj_scan_token(K_WITHOUT)) return true;
    if (jj_scan_token(K_UNIQUE)) return true;
    if (jj_scan_token(K_KEYS)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4924_11_529()
 {
    if (jj_scan_token(K_JSON_ARRAY)) return true;
    if (jj_scan_token(425)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_297()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4943_19_676()) jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4912_23_675()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4912_23_740()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4916_23_741()) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonFunction_4912_23_740()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_UNIQUE)) return true;
    if (jj_scan_token(K_KEYS)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4892_41_887()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4896_35_889()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3R_MergeWhenMatched_1853_5_137()
 {
    if (jj_scan_token(K_WHEN)) return true;
    if (jj_scan_token(K_MATCHED)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4906_23_739()
 {
    if (jj_scan_token(K_ABSENT)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4890_37_886()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4902_23_674()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4902_23_738()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4906_23_739()) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonFunction_4902_23_738()
 {
    if (jj_scan_token(K_NULL)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4889_33_869()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4890_37_886()) jj_scanpos = xsp;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(361)) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4892_41_887()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4892_101_888()) return true;
    }
    }
    if (jj_3R_Expression_3587_5_122()) return true;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4896_35_889()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_48()
 {
    if (jj_3R_MergeWhenMatched_1853_5_137()) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4871_42_302()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4875_35_885()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3_46()
 {
    if (jj_3R_JoinsList_3000_5_128()) return true;
    return false;
  }

  private boolean jj_3_296()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(361)) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4871_42_302()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4871_104_303()) return true;
    }
    }
    if (jj_3R_Expression_3587_5_122()) return true;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4875_35_885()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Merge_1824_5_360()
 {
    if (jj_scan_token(K_MERGE)) return true;
    if (jj_scan_token(K_INTO)) return true;
    if (jj_3R_TableWithAlias_2049_5_136()) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4867_33_737()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4866_25_673()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4867_33_737()) jj_scanpos = xsp;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    xsp = jj_scanpos;
    if (jj_3_296()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JsonFunction_4889_33_869()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Delete_1787_20_135()
 {
    if (jj_3R_TableWithAlias_2049_5_136()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_Delete_1788_12_382()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_Delete_1789_7_383()) jj_scanpos = xsp;
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3R_Delete_1799_7_615()
 {
    if (jj_3R_ReturningClause_1438_5_717()) return true;
    return false;
  }

  private boolean jj_3R_Delete_1797_6_614()
 {
    if (jj_3R_PlainLimit_3354_5_716()) return true;
    return false;
  }

  private boolean jj_3R_Delete_1796_6_613()
 {
    if (jj_3R_OrderByElements_3280_5_190()) return true;
    return false;
  }

  private boolean jj_3R_Delete_1795_6_612()
 {
    if (jj_3R_WhereClause_3167_5_168()) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4861_11_528()
 {
    if (jj_scan_token(K_JSON_OBJECT)) return true;
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4866_25_673()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4902_23_674()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4912_23_675()) jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_Delete_1788_12_382()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_TableWithAlias_2049_5_136()) return true;
    return false;
  }

  private boolean jj_3R_Delete_1793_7_611()
 {
    if (jj_scan_token(K_USING)) return true;
    if (jj_3R_TableWithAlias_2049_5_136()) return true;
    return false;
  }

  private boolean jj_3_47()
 {
    if (jj_3R_TableWithAlias_2049_5_136()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_46()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Delete_1789_7_383()
 {
    if (jj_3R_OutputClause_1697_5_637()) return true;
    return false;
  }

  private boolean jj_3_44()
 {
    if (jj_scan_token(K_IGNORE)) return true;
    return false;
  }

  private boolean jj_3_45()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Delete_1787_20_135()) {
    jj_scanpos = xsp;
    if (jj_scan_token(118)) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonFunction_4859_5_282()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4861_11_528()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4924_11_529()) return true;
    }
    return false;
  }

  private boolean jj_3_43()
 {
    if (jj_scan_token(K_QUICK)) return true;
    return false;
  }

  private boolean jj_3_42()
 {
    if (jj_scan_token(K_LOW_PRIORITY)) return true;
    return false;
  }

  private boolean jj_3R_Delete_1783_5_359()
 {
    if (jj_scan_token(K_DELETE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_42()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_43()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_44()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_45()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_47()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Delete_1793_7_611()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Delete_1795_6_612()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Delete_1796_6_613()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Delete_1797_6_614()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Delete_1799_7_615()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JsonExpression_4833_17_301()
 {
    if (jj_scan_token(475)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4831_17_300()
 {
    if (jj_scan_token(474)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4829_17_299()
 {
    if (jj_scan_token(473)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(423)) {
    jj_scanpos = xsp;
    if (jj_scan_token(397)) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonExpression_4827_17_298()
 {
    if (jj_scan_token(472)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(423)) {
    jj_scanpos = xsp;
    if (jj_scan_token(397)) return true;
    }
    return false;
  }

  private boolean jj_3_295()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonExpression_4827_17_298()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_4829_17_299()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_4831_17_300()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_4833_17_301()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_Upsert_1747_9_365()
 {
    if (jj_3R_Select_2141_5_124()) return true;
    return false;
  }

  private boolean jj_3_294()
 {
    if (jj_scan_token(471)) return true;
    if (jj_3R_ColDataType_6190_5_297()) return true;
    return false;
  }

  private boolean jj_3R_Upsert_1742_9_364()
 {
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3_41()
 {
    if (jj_3R_ParenthesedColumnList_4114_5_134()) return true;
    return false;
  }

  private boolean jj_3_293()
 {
    Token xsp;
    if (jj_3_294()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_294()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_295()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_40()
 {
    if (jj_scan_token(K_INTO)) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4808_5_795()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_293()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Upsert_1732_9_363()
 {
    if (jj_scan_token(K_INSERT)) return true;
    if (jj_scan_token(K_OR)) return true;
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3R_Upsert_1730_9_362()
 {
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3R_Upsert_1728_9_361()
 {
    if (jj_scan_token(K_UPSERT)) return true;
    return false;
  }

  private boolean jj_3R_Upsert_1727_5_113()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Upsert_1728_9_361()) {
    jj_scanpos = xsp;
    if (jj_3R_Upsert_1730_9_362()) {
    jj_scanpos = xsp;
    if (jj_3R_Upsert_1732_9_363()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3_40()) jj_scanpos = xsp;
    if (jj_3R_Table_2034_5_176()) return true;
    xsp = jj_scanpos;
    if (jj_3_41()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Upsert_1742_9_364()) {
    jj_scanpos = xsp;
    if (jj_3R_Upsert_1747_9_365()) return true;
    }
    return false;
  }

  private boolean jj_3R_TrimFunction_7852_13_884()
 {
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3_39()
 {
    if (jj_3R_ColumnsNamesList_6495_5_133()) return true;
    return false;
  }

  private boolean jj_3_291()
 {
    if (jj_scan_token(471)) return true;
    if (jj_scan_token(K_STRUCT)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_3R_StructParameters_4715_5_296()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_TrimFunction_7849_9_868()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_3R_TrimFunction_7852_13_884()) return true;
    }
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3R_StructType_4766_17_851()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    if (jj_scan_token(DOUBLE_COLON)) return true;
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3R_TrimFunction_7841_13_352()
 {
    if (jj_scan_token(K_BOTH)) return true;
    return false;
  }

  private boolean jj_3_410()
 {
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3R_TrimFunction_7839_13_351()
 {
    if (jj_scan_token(K_TRAILING)) return true;
    return false;
  }

  private boolean jj_3R_OutputClause_1699_9_726()
 {
    if (jj_scan_token(K_INTO)) return true;
    return false;
  }

  private boolean jj_3R_TrimFunction_7837_13_350()
 {
    if (jj_scan_token(K_LEADING)) return true;
    return false;
  }

  private boolean jj_3_409()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_TrimFunction_7837_13_350()) {
    jj_scanpos = xsp;
    if (jj_3R_TrimFunction_7839_13_351()) {
    jj_scanpos = xsp;
    if (jj_3R_TrimFunction_7841_13_352()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_OutputClause_1697_5_637()
 {
    if (jj_scan_token(K_OUTPUT)) return true;
    if (jj_3R_SelectItemsList_2601_5_195()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OutputClause_1699_9_726()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_StructType_4760_9_538()
 {
    if (jj_scan_token(OPENING_CURLY_BRACKET)) return true;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    if (jj_scan_token(DOUBLE_COLON)) return true;
    if (jj_3R_Expression_3587_5_122()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_StructType_4766_17_851()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLOSING_CURLY_BRACKET)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_291()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_TrimFunction_7834_5_672()
 {
    if (jj_scan_token(K_TRIM)) return true;
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_409()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_410()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_TrimFunction_7849_9_868()) jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_StructType_4755_9_537()
 {
    if (jj_scan_token(K_STRUCT)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_3R_SelectItemsList_2601_5_195()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_292()
 {
    if (jj_scan_token(K_STRUCT)) return true;
    if (jj_scan_token(442)) return true;
    if (jj_3R_StructParameters_4715_5_296()) return true;
    if (jj_scan_token(441)) return true;
    if (jj_scan_token(425)) return true;
    if (jj_3R_SelectItemsList_2601_5_195()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_38()
 {
    if (jj_scan_token(K_DO)) return true;
    if (jj_scan_token(K_NOTHING)) return true;
    return false;
  }

  private boolean jj_3R_StructType_4748_5_288()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_292()) {
    jj_scanpos = xsp;
    if (jj_3R_StructType_4755_9_537()) {
    jj_scanpos = xsp;
    if (jj_3R_StructType_4760_9_538()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_408()
 {
    if (jj_3R_Expression_3587_5_122()) return true;
    if (jj_scan_token(K_USING)) return true;
    if (jj_3R_IdentifierChain_7755_5_518()) return true;
    return false;
  }

  private boolean jj_3_407()
 {
    if (jj_3R_ColDataType_6190_5_297()) return true;
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_TranscodingFunction_7804_15_883()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_ArrayConstructor_4697_51_294()
 {
    if (jj_3R_RangeExpression_4675_5_545()) return true;
    return false;
  }

  private boolean jj_3R_TranscodingFunction_7801_9_867()
 {
    if (jj_3R_ColDataType_6190_5_297()) return true;
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Expression_3587_5_122()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_TranscodingFunction_7804_15_883()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ArrayConstructor_4689_47_293()
 {
    if (jj_3R_RangeExpression_4675_5_545()) return true;
    return false;
  }

  private boolean jj_3_290()
 {
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    return false;
  }

  private boolean jj_3R_TranscodingFunction_7799_5_671()
 {
    if (jj_scan_token(K_CONVERT)) return true;
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_TranscodingFunction_7801_9_867()) {
    jj_scanpos = xsp;
    if (jj_3_408()) return true;
    }
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_StructParameters_4722_9_546()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_290()) jj_scanpos = xsp;
    if (jj_3R_ColDataType_6190_5_297()) return true;
    return false;
  }

  private boolean jj_3_289()
 {
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    return false;
  }

  private boolean jj_3R_StructParameters_4715_5_296()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_289()) jj_scanpos = xsp;
    if (jj_3R_ColDataType_6190_5_297()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_StructParameters_4722_9_546()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ArrayConstructor_4699_17_876()
 {
    if (jj_3R_ArrayConstructor_4686_5_140()) return true;
    return false;
  }

  private boolean jj_3_287()
 {
    if (jj_3R_Expression_3587_5_122()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayConstructor_4697_51_294()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CharacterPrimary_7771_9_523()
 {
    if (jj_3R_TrimFunction_7834_5_672()) return true;
    return false;
  }

  private boolean jj_3R_ArrayConstructor_4695_13_678()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_287()) {
    jj_scanpos = xsp;
    if (jj_3R_ArrayConstructor_4699_17_876()) return true;
    }
    return false;
  }

  private boolean jj_3R_CharacterPrimary_7769_9_522()
 {
    if (jj_3R_TranscodingFunction_7799_5_671()) return true;
    return false;
  }

  private boolean jj_3R_ArrayConstructor_4691_13_295()
 {
    if (jj_3R_ArrayConstructor_4686_5_140()) return true;
    return false;
  }

  private boolean jj_3_286()
 {
    if (jj_3R_Expression_3587_5_122()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayConstructor_4689_47_293()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CharacterPrimary_7768_5_276()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CharacterPrimary_7769_9_522()) {
    jj_scanpos = xsp;
    if (jj_3R_CharacterPrimary_7771_9_523()) return true;
    }
    return false;
  }

  private boolean jj_3_288()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_286()) {
    jj_scanpos = xsp;
    if (jj_3R_ArrayConstructor_4691_13_295()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ArrayConstructor_4695_13_678()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_IdentifierChain_7756_7_669()
 {
    if (jj_scan_token(428)) return true;
    if (jj_3R_RelObjectNameExt2_2024_5_139()) return true;
    return false;
  }

  private boolean jj_3R_ArrayConstructor_4686_5_140()
 {
    if (jj_scan_token(466)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_288()) jj_scanpos = xsp;
    if (jj_scan_token(467)) return true;
    return false;
  }

  private boolean jj_3R_Insert_1597_21_130()
 {
    if (jj_scan_token(K_AS)) return true;
    return false;
  }

  private boolean jj_3_37()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_DUPLICATE)) return true;
    return false;
  }

  private boolean jj_3R_IdentifierChain_7755_5_518()
 {
    if (jj_3R_RelObjectNameExt2_2024_5_139()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_IdentifierChain_7756_7_669()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Insert_1608_9_608()
 {
    if (jj_3R_Select_2141_5_124()) return true;
    return false;
  }

  private boolean jj_3R_Insert_1604_9_607()
 {
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3R_RangeExpression_4675_5_545()
 {
    if (jj_scan_token(DOUBLE_COLON)) return true;
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3R_Insert_1601_7_606()
 {
    if (jj_3R_OutputClause_1697_5_637()) return true;
    return false;
  }

  private boolean jj_3_36()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_ColumnList_4102_5_132()) return true;
    return false;
  }

  private boolean jj_3_35()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Insert_1597_21_130()) jj_scanpos = xsp;
    if (jj_3R_RelObjectNameWithoutValue_1960_5_131()) return true;
    return false;
  }

  private boolean jj_3_34()
 {
    if (jj_scan_token(K_INTO)) return true;
    return false;
  }

  private boolean jj_3_33()
 {
    if (jj_scan_token(K_IGNORE)) return true;
    return false;
  }

  private boolean jj_3R_DateTimeLiteralExpression_4665_5_287()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(423)) {
    jj_scanpos = xsp;
    if (jj_scan_token(424)) return true;
    }
    return false;
  }

  private boolean jj_3_32()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(175)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(130)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_Insert_1585_5_357()
 {
    if (jj_scan_token(K_INSERT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_32()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_33()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_34()) jj_scanpos = xsp;
    if (jj_3R_Table_2034_5_176()) return true;
    xsp = jj_scanpos;
    if (jj_3_35()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_36()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Insert_1601_7_606()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Insert_1604_9_607()) {
    jj_scanpos = xsp;
    if (jj_3R_Insert_1608_9_608()) return true;
    }
    return false;
  }

  private boolean jj_3R_NumericBind_4654_5_279()
 {
    if (jj_scan_token(DOUBLE_COLON)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_UserVariable_4641_12_517()
 {
    if (jj_scan_token(445)) return true;
    return false;
  }

  private boolean jj_3R_UserVariable_4641_5_258()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(476)) {
    jj_scanpos = xsp;
    if (jj_3R_UserVariable_4641_12_517()) return true;
    }
    if (jj_3R_IdentifierChain_7755_5_518()) return true;
    return false;
  }

  private boolean jj_3_31()
 {
    if (jj_3R_ParenthesedSelect_2188_5_129()) return true;
    return false;
  }

  private boolean jj_3R_OracleNamedFunctionParameter_4627_7_495()
 {
    if (jj_3R_RelObjectNameExt2_2024_5_139()) return true;
    return false;
  }

  private boolean jj_3R_OracleNamedFunctionParameter_4627_5_254()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OracleNamedFunctionParameter_4627_7_495()) {
    jj_scanpos = xsp;
    if (jj_scan_token(215)) return true;
    }
    if (jj_scan_token(K_ORACLE_NAMED_PARAMETER_ASSIGNMENT)) return true;
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3R_JdbcNamedParameter_4613_12_524()
 {
    if (jj_scan_token(460)) return true;
    return false;
  }

  private boolean jj_3R_JdbcNamedParameter_4613_5_278()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(361)) {
    jj_scanpos = xsp;
    if (jj_3R_JdbcNamedParameter_4613_12_524()) return true;
    }
    if (jj_3R_IdentifierChain_7755_5_518()) return true;
    return false;
  }

  private boolean jj_3_30()
 {
    if (jj_3R_ParenthesedSelect_2188_5_129()) return true;
    return false;
  }

  private boolean jj_3R_NextValExpression_4601_6_289()
 {
    if (jj_scan_token(K_NEXTVAL)) return true;
    if (jj_3R_RelObjectNames_1914_5_422()) return true;
    return false;
  }

  private boolean jj_3R_Update_1481_47_610()
 {
    if (jj_3R_JoinsList_3000_5_128()) return true;
    return false;
  }

  private boolean jj_3R_ConnectByRootOperator_4590_5_668()
 {
    if (jj_scan_token(K_CONNECT_BY_ROOT)) return true;
    if (jj_3R_Column_1932_5_253()) return true;
    return false;
  }

  private boolean jj_3_285()
 {
    if (jj_scan_token(K_AT)) return true;
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(K_ZONE)) return true;
    if (jj_3R_PrimaryExpression_4441_5_257()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4556_13_544()
 {
    if (jj_scan_token(475)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_29()
 {
    if (jj_3R_JoinsList_3000_5_128()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4554_13_543()
 {
    if (jj_scan_token(474)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4552_13_542()
 {
    if (jj_scan_token(473)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(423)) {
    jj_scanpos = xsp;
    if (jj_scan_token(397)) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4550_13_292()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_4550_13_541()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4552_13_542()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4554_13_543()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4556_13_544()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4550_13_541()
 {
    if (jj_scan_token(472)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(423)) {
    jj_scanpos = xsp;
    if (jj_scan_token(397)) return true;
    }
    return false;
  }

  private boolean jj_3_28()
 {
    if (jj_scan_token(K_IGNORE)) return true;
    return false;
  }

  private boolean jj_3_284()
 {
    Token xsp;
    if (jj_3R_PrimaryExpression_4550_13_292()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PrimaryExpression_4550_13_292()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_JsonExpression_4808_5_795()) return true;
    return false;
  }

  private boolean jj_3_27()
 {
    if (jj_scan_token(K_LOW_PRIORITY)) return true;
    return false;
  }

  private boolean jj_3R_Update_1478_4_358()
 {
    if (jj_scan_token(K_UPDATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_27()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_28()) jj_scanpos = xsp;
    if (jj_3R_TableWithAliasAndMysqlIndexHint_2061_5_609()) return true;
    xsp = jj_scanpos;
    if (jj_3R_Update_1481_47_610()) jj_scanpos = xsp;
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4538_7_760()
 {
    if (jj_scan_token(471)) return true;
    if (jj_3R_ColDataType_6190_5_297()) return true;
    return false;
  }

  private boolean jj_3_257()
 {
    if (jj_3R_AnalyticExpression_5165_5_274()) return true;
    return false;
  }

  private boolean jj_3_283()
 {
    if (jj_3R_ArrayExpression_4402_5_291()) return true;
    return false;
  }

  private boolean jj_3_282()
 {
    if (jj_3R_IntervalExpressionWithoutInterval_5080_5_290()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4524_14_794()
 {
    if (jj_scan_token(428)) return true;
    if (jj_3R_RelObjectNameExt_2002_5_368()) return true;
    return false;
  }

  private boolean jj_3_281()
 {
    if (jj_scan_token(K_COLLATE)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_280()
 {
    if (jj_3R_ParenthesedSelect_2188_5_129()) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1407_53_636()
 {
    if (jj_scan_token(K_WHERE)) return true;
    return false;
  }

  private boolean jj_3_406()
 {
    if (jj_3R_CreateView_6289_5_349()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4515_9_516()
 {
    if (jj_3R_ParenthesedExpressionList_4070_5_210()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_4524_14_794()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_405()
 {
    if (jj_3R_CreateTable_5925_5_348()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4512_11_515()
 {
    if (jj_3R_ParenthesedSelect_2188_5_129()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4510_11_514()
 {
    if (jj_scan_token(470)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(CLOSING_CURLY_BRACKET)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4508_11_513()
 {
    if (jj_scan_token(469)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(CLOSING_CURLY_BRACKET)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4506_11_512()
 {
    if (jj_scan_token(468)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(CLOSING_CURLY_BRACKET)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4504_11_511()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_ReturningClause_1438_5_717()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(259)) {
    jj_scanpos = xsp;
    if (jj_scan_token(258)) return true;
    }
    if (jj_3R_SelectItemsList_2601_5_195()) return true;
    return false;
  }

  private boolean jj_3_279()
 {
    if (jj_3R_Column_1932_5_253()) return true;
    return false;
  }

  private boolean jj_3_278()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_Create_7576_5_696()
 {
    if (jj_scan_token(K_CREATE)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4498_11_510()
 {
    if (jj_3R_ConnectByRootOperator_4590_5_668()) return true;
    return false;
  }

  private boolean jj_3_277()
 {
    if (jj_3R_NextValExpression_4601_6_289()) return true;
    return false;
  }

  private boolean jj_3_276()
 {
    if (jj_3R_ArrayConstructor_4686_5_140()) return true;
    return false;
  }

  private boolean jj_3_275()
 {
    if (jj_scan_token(K_ARRAY_LITERAL)) return true;
    if (jj_3R_ArrayConstructor_4686_5_140()) return true;
    return false;
  }

  private boolean jj_3_274()
 {
    if (jj_3R_StructType_4748_5_288()) return true;
    return false;
  }

  private boolean jj_3_273()
 {
    if (jj_3R_DateTimeLiteralExpression_4665_5_287()) return true;
    return false;
  }

  private boolean jj_3R_Values_1422_5_144()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(333)) {
    jj_scanpos = xsp;
    if (jj_scan_token(332)) return true;
    }
    if (jj_3R_ExpressionList_4033_5_209()) return true;
    return false;
  }

  private boolean jj_3_272()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(303)) {
    jj_scanpos = xsp;
    if (jj_scan_token(65)) return true;
    }
    return false;
  }

  private boolean jj_3_269()
 {
    if (jj_3R_Function_5488_5_248()) return true;
    return false;
  }

  private boolean jj_3R_AlterSequence_7560_5_722()
 {
    if (jj_scan_token(K_SEQUENCE)) return true;
    return false;
  }

  private boolean jj_3_271()
 {
    if (jj_3R_CastExpression_5281_5_286()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4480_11_509()
 {
    if (jj_scan_token(S_HEX)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4478_11_508()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4476_11_507()
 {
    if (jj_scan_token(S_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3_270()
 {
    if (jj_3R_IntervalExpression_5058_1_285()) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1407_6_635()
 {
    if (jj_scan_token(K_LIKE)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1407_5_380()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1407_6_635()) {
    jj_scanpos = xsp;
    if (jj_3R_ShowTables_1407_53_636()) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4472_11_506()
 {
    if (jj_3R_Function_5488_5_248()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_257()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_264()
 {
    if (jj_3R_ExtractExpression_5235_5_280()) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1403_7_634()
 {
    if (jj_scan_token(K_IN)) return true;
    return false;
  }

  private boolean jj_3_268()
 {
    if (jj_3R_FullTextSearch_5429_5_284()) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1402_7_633()
 {
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3_267()
 {
    if (jj_3R_JsonAggregateFunction_4969_5_283()) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1401_5_379()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1402_7_633()) {
    jj_scanpos = xsp;
    if (jj_3R_ShowTables_1403_7_634()) return true;
    }
    return false;
  }

  private boolean jj_3_266()
 {
    if (jj_3R_JsonFunction_4859_5_282()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4464_11_505()
 {
    if (jj_3R_XMLSerializeExpr_5681_5_667()) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1398_5_378()
 {
    if (jj_scan_token(K_FULL)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1397_5_377()
 {
    if (jj_scan_token(K_EXTENDED)) return true;
    return false;
  }

  private boolean jj_3_265()
 {
    if (jj_3R_MySQLGroupConcat_5705_5_281()) return true;
    return false;
  }

  private boolean jj_3_260()
 {
    if (jj_3R_ImplicitCast_5256_6_277()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4441_31_666()
 {
    if (jj_scan_token(439)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1397_3_127()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1397_5_377()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1398_5_378()) jj_scanpos = xsp;
    if (jj_scan_token(K_TABLES)) return true;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1401_5_379()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1407_5_380()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4460_11_504()
 {
    if (jj_3R_ExtractExpression_5235_5_280()) return true;
    return false;
  }

  private boolean jj_3_263()
 {
    if (jj_3R_NumericBind_4654_5_279()) return true;
    return false;
  }

  private boolean jj_3_262()
 {
    if (jj_3R_UserVariable_4641_5_258()) return true;
    return false;
  }

  private boolean jj_3_261()
 {
    if (jj_3R_JdbcNamedParameter_4613_5_278()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4452_11_503()
 {
    if (jj_3R_JdbcParameter_3315_5_304()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4450_11_502()
 {
    if (jj_3R_ImplicitCast_5256_6_277()) return true;
    return false;
  }

  private boolean jj_3_259()
 {
    if (jj_3R_CharacterPrimary_7768_5_276()) return true;
    return false;
  }

  private boolean jj_3_258()
 {
    if (jj_3R_CaseWhenExpression_5329_5_275()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4444_9_501()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4441_7_499()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_4441_7_665()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4441_31_666()) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4442_6_500()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(440)) {
    jj_scanpos = xsp;
    if (jj_scan_token(454)) {
    jj_scanpos = xsp;
    if (jj_scan_token(446)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4441_7_665()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_scan_token(K_CONCURRENTLY)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4441_5_257()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_4441_7_499()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_4442_6_500()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_4444_9_501()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_258()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_259()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_PrimaryExpression_4450_11_502()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4452_11_503()) {
    jj_scanpos = xsp;
    if (jj_3_261()) {
    jj_scanpos = xsp;
    if (jj_3_262()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_263()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_PrimaryExpression_4460_11_504()) {
    jj_scanpos = xsp;
    if (jj_3_265()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4464_11_505()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_266()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_267()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_268()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_PrimaryExpression_4472_11_506()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_270()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4476_11_507()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4478_11_508()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4480_11_509()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_271()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_272()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_273()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_274()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_275()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_276()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_277()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4498_11_510()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_278()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_279()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4504_11_511()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4506_11_512()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4508_11_513()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4510_11_514()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_PrimaryExpression_4512_11_515()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4515_9_516()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_281()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_282()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_283()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PrimaryExpression_4538_7_760()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_284()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_285()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_RefreshMaterializedView_1368_5_704()
 {
    if (jj_scan_token(K_REFRESH)) return true;
    return false;
  }

  private boolean jj_3R_ShowIndex_1355_5_126()
 {
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3_256()
 {
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    return false;
  }

  private boolean jj_3R_ArrayExpression_4414_15_273()
 {
    if (jj_scan_token(DOUBLE_COLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_256()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_255()
 {
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    return false;
  }

  private boolean jj_3R_ShowColumns_1345_5_125()
 {
    if (jj_scan_token(K_COLUMNS)) return true;
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3_254()
 {
    if (jj_scan_token(466)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_255()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayExpression_4414_15_273()) jj_scanpos = xsp;
    if (jj_scan_token(467)) return true;
    return false;
  }

  private boolean jj_3_253()
 {
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    return false;
  }

  private boolean jj_3R_ArrayExpression_4405_11_540()
 {
    if (jj_scan_token(DOUBLE_COLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_253()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_404()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_252()
 {
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    return false;
  }

  private boolean jj_3R_ArrayExpression_4402_5_291()
 {
    if (jj_scan_token(466)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_252()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayExpression_4405_11_540()) jj_scanpos = xsp;
    if (jj_scan_token(467)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_254()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_25()
 {
    if (jj_3R_ShowTables_1397_3_127()) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_3R_ShowIndex_1355_5_126()) return true;
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_3R_ShowColumns_1345_5_125()) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_4358_39_271()
 {
    if (jj_scan_token(464)) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_4357_39_270()
 {
    if (jj_scan_token(K_DIV)) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_4356_39_269()
 {
    if (jj_scan_token(463)) return true;
    return false;
  }

  private boolean jj_3R_Show_1318_5_703()
 {
    if (jj_scan_token(K_SHOW)) return true;
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_scan_token(K_SCHEMA)) return true;
    return false;
  }

  private boolean jj_3R_BitwiseXor_4382_9_769()
 {
    if (jj_scan_token(465)) return true;
    if (jj_3R_PrimaryExpression_4441_5_257()) return true;
    return false;
  }

  private boolean jj_3R_BitwiseXor_4380_5_272()
 {
    if (jj_3R_PrimaryExpression_4441_5_257()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_BitwiseXor_4382_9_769()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Use_1306_5_705()
 {
    if (jj_scan_token(K_USE)) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_4355_23_268()
 {
    if (jj_scan_token(437)) return true;
    return false;
  }

  private boolean jj_3R_AdditiveExpression_4329_39_266()
 {
    if (jj_scan_token(454)) return true;
    return false;
  }

  private boolean jj_3R_ExplainStatementOptions_1288_5_629()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_3R_ExplainFormatOption_1238_4_724()) return true;
    return false;
  }

  private boolean jj_3_251()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_MultiplicativeExpression_4355_23_268()) {
    jj_scanpos = xsp;
    if (jj_3R_MultiplicativeExpression_4356_39_269()) {
    jj_scanpos = xsp;
    if (jj_3R_MultiplicativeExpression_4357_39_270()) {
    jj_scanpos = xsp;
    if (jj_3R_MultiplicativeExpression_4358_39_271()) return true;
    }
    }
    }
    if (jj_3R_BitwiseXor_4380_5_272()) return true;
    return false;
  }

  private boolean jj_3R_ExplainStatementOptions_1280_5_628()
 {
    if (jj_scan_token(K_VERBOSE)) return true;
    if (jj_3R_ExplainOptionBoolean_1223_4_723()) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_4350_5_267()
 {
    if (jj_3R_BitwiseXor_4380_5_272()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_251()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ExplainStatementOptions_1272_5_627()
 {
    if (jj_scan_token(K_COSTS)) return true;
    if (jj_3R_ExplainOptionBoolean_1223_4_723()) return true;
    return false;
  }

  private boolean jj_3R_ExplainStatementOptions_1264_5_626()
 {
    if (jj_scan_token(K_BUFFERS)) return true;
    if (jj_3R_ExplainOptionBoolean_1223_4_723()) return true;
    return false;
  }

  private boolean jj_3R_AdditiveExpression_4328_10_265()
 {
    if (jj_scan_token(440)) return true;
    return false;
  }

  private boolean jj_3_250()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AdditiveExpression_4328_10_265()) {
    jj_scanpos = xsp;
    if (jj_3R_AdditiveExpression_4329_39_266()) return true;
    }
    if (jj_3R_MultiplicativeExpression_4350_5_267()) return true;
    return false;
  }

  private boolean jj_3R_ExplainStatementOptions_1256_5_370()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExplainStatementOptions_1256_5_625()) {
    jj_scanpos = xsp;
    if (jj_3R_ExplainStatementOptions_1264_5_626()) {
    jj_scanpos = xsp;
    if (jj_3R_ExplainStatementOptions_1272_5_627()) {
    jj_scanpos = xsp;
    if (jj_3R_ExplainStatementOptions_1280_5_628()) {
    jj_scanpos = xsp;
    if (jj_3R_ExplainStatementOptions_1288_5_629()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ExplainStatementOptions_1256_5_625()
 {
    if (jj_scan_token(K_ANALYZE)) return true;
    if (jj_3R_ExplainOptionBoolean_1223_4_723()) return true;
    return false;
  }

  private boolean jj_3R_AdditiveExpression_4326_5_264()
 {
    if (jj_3R_MultiplicativeExpression_4350_5_267()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_250()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ExplainStatementOptions_1255_3_123()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ExplainStatementOptions_1256_5_370()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_4303_25_263()
 {
    if (jj_scan_token(462)) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_4301_25_262()
 {
    if (jj_scan_token(461)) return true;
    return false;
  }

  private boolean jj_3R_Grant_7381_9_713()
 {
    if (jj_scan_token(K_GRANT)) return true;
    return false;
  }

  private boolean jj_3R_ExplainFormatOption_1238_5_753()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(348)) {
    jj_scanpos = xsp;
    if (jj_scan_token(155)) {
    jj_scanpos = xsp;
    if (jj_scan_token(356)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_ExplainFormatOption_1238_4_724()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExplainFormatOption_1238_5_753()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_4299_13_261()
 {
    if (jj_scan_token(460)) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_4297_13_260()
 {
    if (jj_scan_token(459)) return true;
    return false;
  }

  private boolean jj_3_249()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_BitwiseAndOr_4297_13_260()) {
    jj_scanpos = xsp;
    if (jj_3R_BitwiseAndOr_4299_13_261()) {
    jj_scanpos = xsp;
    if (jj_3R_BitwiseAndOr_4301_25_262()) {
    jj_scanpos = xsp;
    if (jj_3R_BitwiseAndOr_4303_25_263()) return true;
    }
    }
    }
    if (jj_3R_AdditiveExpression_4326_5_264()) return true;
    return false;
  }

  private boolean jj_3R_ExplainOptionBoolean_1223_5_752()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(310)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(209)) {
    jj_scanpos = xsp;
    if (jj_scan_token(207)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_4294_5_259()
 {
    if (jj_3R_AdditiveExpression_4326_5_264()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_249()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ExplainOptionBoolean_1223_4_723()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExplainOptionBoolean_1223_5_752()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Comment_7351_5_709()
 {
    if (jj_scan_token(K_COMMENT)) return true;
    return false;
  }

  private boolean jj_3_248()
 {
    if (jj_scan_token(OP_CONCAT)) return true;
    if (jj_3R_BitwiseAndOr_4294_5_259()) return true;
    return false;
  }

  private boolean jj_3R_ConcatExpression_4271_5_194()
 {
    if (jj_3R_BitwiseAndOr_4294_5_259()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_248()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_3R_ExplainStatementOptions_1255_3_123()) return true;
    if (jj_3R_Select_2141_5_124()) return true;
    return false;
  }

  private boolean jj_3R_Commit_7336_3_708()
 {
    if (jj_scan_token(K_COMMIT)) return true;
    return false;
  }

  private boolean jj_3R_Explain_1191_5_711()
 {
    if (jj_scan_token(K_EXPLAIN)) return true;
    return false;
  }

  private boolean jj_3_247()
 {
    if (jj_3R_UserVariable_4641_5_258()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(427)) {
    jj_scanpos = xsp;
    if (jj_scan_token(458)) return true;
    }
    return false;
  }

  private boolean jj_3R_Describe_1178_5_710()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) return true;
    }
    return false;
  }

  private boolean jj_3R_SimpleExpression_4243_11_440()
 {
    if (jj_3R_UserVariable_4641_5_258()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(427)) {
    jj_scanpos = xsp;
    if (jj_scan_token(458)) return true;
    }
    return false;
  }

  private boolean jj_3R_RollbackStatement_7315_5_707()
 {
    if (jj_scan_token(K_ROLLBACK)) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpression_4242_5_211()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SimpleExpression_4243_11_440()) jj_scanpos = xsp;
    if (jj_3R_ConcatExpression_4271_5_194()) return true;
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_4224_15_498()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_4223_15_497()
 {
    if (jj_scan_token(K_SOME)) return true;
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_4222_13_496()
 {
    if (jj_scan_token(K_ANY)) return true;
    return false;
  }

  private boolean jj_3R_SavepointStatement_7299_5_706()
 {
    if (jj_scan_token(K_SAVEPOINT)) return true;
    return false;
  }

  private boolean jj_3R_PurgeStatement_1150_5_714()
 {
    if (jj_scan_token(K_PURGE)) return true;
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_4220_5_255()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AnyComparisonExpression_4222_13_496()) {
    jj_scanpos = xsp;
    if (jj_3R_AnyComparisonExpression_4223_15_497()) {
    jj_scanpos = xsp;
    if (jj_3R_AnyComparisonExpression_4224_15_498()) return true;
    }
    }
    if (jj_3R_ParenthesedSelect_2188_5_129()) return true;
    return false;
  }

  private boolean jj_3R_Wait_7287_5_831()
 {
    if (jj_scan_token(K_WAIT)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_242()
 {
    if (jj_3R_AnyComparisonExpression_4220_5_255()) return true;
    return false;
  }

  private boolean jj_3R_NamedExpressionListExprFirst_4183_33_682()
 {
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    return false;
  }

  private boolean jj_3_246()
 {
    if (jj_3R_PrimaryExpression_4441_5_257()) return true;
    return false;
  }

  private boolean jj_3_245()
 {
    if (jj_3R_RowConstructor_5373_5_256()) return true;
    return false;
  }

  private boolean jj_3_244()
 {
    if (jj_3R_ParenthesedExpressionList_4070_5_210()) return true;
    return false;
  }

  private boolean jj_3_243()
 {
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    return false;
  }

  private boolean jj_3R_ComparisonItem_4202_5_475()
 {
    if (jj_3R_AnyComparisonExpression_4220_5_255()) return true;
    return false;
  }

  private boolean jj_3R_NamedExpressionListExprFirst_4180_25_555()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(114)) {
    jj_scanpos = xsp;
    if (jj_scan_token(118)) return true;
    }
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    xsp = jj_scanpos;
    if (jj_3R_NamedExpressionListExprFirst_4183_33_682()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ComparisonItem_4201_3_231()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ComparisonItem_4202_5_475()) {
    jj_scanpos = xsp;
    if (jj_3_243()) {
    jj_scanpos = xsp;
    if (jj_3_244()) {
    jj_scanpos = xsp;
    if (jj_3_245()) {
    jj_scanpos = xsp;
    if (jj_3_246()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_Set_1075_49_369()
 {
    if (jj_scan_token(427)) return true;
    return false;
  }

  private boolean jj_3_20()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_EXISTS)) return true;
    return false;
  }

  private boolean jj_3_19()
 {
    if (jj_scan_token(K_TABLE)) return true;
    return false;
  }

  private boolean jj_3R_RenameTableStatement_1111_5_695()
 {
    if (jj_scan_token(K_RENAME)) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(K_ZONE)) return true;
    return false;
  }

  private boolean jj_3R_NamedExpressionListExprFirst_4170_9_309()
 {
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(118)) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) {
    jj_scanpos = xsp;
    if (jj_scan_token(226)) return true;
    }
    }
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    xsp = jj_scanpos;
    if (jj_3R_NamedExpressionListExprFirst_4180_25_555()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Reset_1097_5_702()
 {
    if (jj_scan_token(K_RESET)) return true;
    return false;
  }

  private boolean jj_3_234()
 {
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3R_Set_1075_21_121()
 {
    if (jj_3R_RelObjectNameExt_2002_5_368()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Set_1075_49_369()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(K_ZONE)) return true;
    return false;
  }

  private boolean jj_3_241()
 {
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3_240()
 {
    if (jj_3R_LambdaExpression_5462_5_252()) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3R_Set_1075_21_121()) return true;
    }
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3_239()
 {
    if (jj_3R_OracleNamedFunctionParameter_4627_5_254()) return true;
    return false;
  }

  private boolean jj_3_238()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_239()) {
    jj_scanpos = xsp;
    if (jj_3_240()) {
    jj_scanpos = xsp;
    if (jj_3_241()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_237()
 {
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3_236()
 {
    if (jj_3R_OracleNamedFunctionParameter_4627_5_254()) return true;
    return false;
  }

  private boolean jj_3_233()
 {
    if (jj_3R_LambdaExpression_5462_5_252()) return true;
    return false;
  }

  private boolean jj_3R_ComplexExpressionList_4126_5_249()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_236()) {
    jj_scanpos = xsp;
    if (jj_3_237()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_238()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_AlterSystemStatement_7197_5_721()
 {
    if (jj_scan_token(K_SYSTEM)) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(K_ZONE)) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(170)) {
    jj_scanpos = xsp;
    if (jj_scan_token(276)) return true;
    }
    return false;
  }

  private boolean jj_3R_Set_1043_5_701()
 {
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3R_ParenthesedColumnList_4114_5_134()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_ColumnList_4102_5_132()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_235()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Column_1932_5_253()) return true;
    return false;
  }

  private boolean jj_3R_ColumnList_4102_5_132()
 {
    if (jj_3R_Column_1932_5_253()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_235()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_232()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_233()) {
    jj_scanpos = xsp;
    if (jj_3_234()) return true;
    }
    return false;
  }

  private boolean jj_3R_SimpleExpressionList_4088_5_250()
 {
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_232()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_3994_94_483()
 {
    if (jj_scan_token(K_FALSE)) return true;
    return false;
  }

  private boolean jj_3_230()
 {
    if (jj_3R_SimpleExpressionList_4088_5_250()) return true;
    return false;
  }

  private boolean jj_3R_ParenthesedExpressionList_4072_9_251()
 {
    if (jj_3R_ComplexExpressionList_4126_5_249()) return true;
    return false;
  }

  private boolean jj_3_231()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing) && !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_ParenthesedExpressionList_4072_9_251()) {
    jj_scanpos = xsp;
    if (jj_3_230()) return true;
    }
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_scan_token(K_TABLE)) return true;
    if (jj_scan_token(425)) return true;
    return false;
  }

  private boolean jj_3R_ParenthesedExpressionList_4070_5_210()
 {
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_231()) jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_Declare_997_5_712()
 {
    if (jj_scan_token(K_DECLARE)) return true;
    return false;
  }

  private boolean jj_3R_AlterSession_7131_5_719()
 {
    if (jj_scan_token(K_SESSION)) return true;
    return false;
  }

  private boolean jj_3R_Statements_923_63_120()
 {
    if (jj_3R_Block_823_5_354()) return true;
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_3994_55_482()
 {
    if (jj_scan_token(K_TRUE)) return true;
    return false;
  }

  private boolean jj_3_403()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_EXISTS)) return true;
    return false;
  }

  private boolean jj_3_229()
 {
    if (jj_3R_ParenthesedExpressionList_4070_5_210()) return true;
    return false;
  }

  private boolean jj_3_228()
 {
    if (jj_3R_SimpleExpressionList_4088_5_250()) return true;
    return false;
  }

  private boolean jj_3R_AlterTable_7110_5_718()
 {
    if (jj_scan_token(K_TABLE)) return true;
    return false;
  }

  private boolean jj_3_227()
 {
    if (jj_3R_ComplexExpressionList_4126_5_249()) return true;
    return false;
  }

  private boolean jj_3R_ExpressionList_4033_5_209()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing) && !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_227()) {
    jj_scanpos = xsp;
    if (jj_3_228()) {
    jj_scanpos = xsp;
    if (jj_3_229()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_Alter_7090_17_623()
 {
    if (true) { jj_la = 0; jj_scanpos = jj_lastpos; return false;}
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_scan_token(ST_SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_Alter_7088_17_622()
 {
    if (jj_3R_AlterView_6362_5_720()) return true;
    return false;
  }

  private boolean jj_3R_Statements_923_36_119()
 {
    if (jj_3R_SingleStatement_748_9_353()) return true;
    return false;
  }

  private boolean jj_3R_MemberOfExpression_4022_5_486()
 {
    if (jj_scan_token(K_MEMBER)) return true;
    if (jj_scan_token(K_OF)) return true;
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3R_Alter_7078_17_621()
 {
    if (true) { jj_la = 0; jj_scanpos = jj_lastpos; return false;}
    return false;
  }

  private boolean jj_3R_Alter_7085_9_367()
 {
    if (jj_scan_token(K_REPLACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alter_7088_17_622()) {
    jj_scanpos = xsp;
    if (jj_3R_Alter_7090_17_623()) return true;
    }
    return false;
  }

  private boolean jj_3R_Alter_7076_17_620()
 {
    if (jj_3R_AlterSequence_7560_5_722()) return true;
    return false;
  }

  private boolean jj_3R_Statements_922_27_118()
 {
    if (jj_scan_token(ST_SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_Alter_7074_17_619()
 {
    if (jj_3R_AlterSystemStatement_7197_5_721()) return true;
    return false;
  }

  private boolean jj_3R_Alter_7072_17_618()
 {
    if (jj_3R_AlterView_6362_5_720()) return true;
    return false;
  }

  private boolean jj_3R_AlterExpression_7004_84_345()
 {
    if (jj_scan_token(K_COLUMN)) return true;
    return false;
  }

  private boolean jj_3R_Alter_7070_17_617()
 {
    if (jj_3R_AlterSession_7131_5_719()) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Statements_922_27_118()) jj_scanpos = xsp;
    if (jj_scan_token(K_ELSE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_Statements_923_36_119()) {
    jj_scanpos = xsp;
    if (jj_3R_Statements_923_63_120()) return true;
    }
    return false;
  }

  private boolean jj_3R_ExistsExpression_4009_5_660()
 {
    if (jj_scan_token(K_EXISTS)) return true;
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    return false;
  }

  private boolean jj_3R_Alter_7068_17_616()
 {
    if (jj_3R_AlterTable_7110_5_718()) return true;
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_3994_19_481()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_Statements_873_65_117()
 {
    if (jj_3R_Block_823_5_354()) return true;
    return false;
  }

  private boolean jj_3R_Alter_7065_9_366()
 {
    if (jj_scan_token(K_ALTER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alter_7068_17_616()) {
    jj_scanpos = xsp;
    if (jj_3R_Alter_7070_17_617()) {
    jj_scanpos = xsp;
    if (jj_3R_Alter_7072_17_618()) {
    jj_scanpos = xsp;
    if (jj_3R_Alter_7074_17_619()) {
    jj_scanpos = xsp;
    if (jj_3R_Alter_7076_17_620()) {
    jj_scanpos = xsp;
    if (jj_3R_Alter_7078_17_621()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_3993_9_236()
 {
    if (jj_scan_token(K_IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsBooleanExpression_3994_19_481()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsBooleanExpression_3994_55_482()) {
    jj_scanpos = xsp;
    if (jj_3R_IsBooleanExpression_3994_94_483()) return true;
    }
    return false;
  }

  private boolean jj_3R_IsNullExpression_3980_19_662()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_Alter_7064_5_114()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alter_7065_9_366()) {
    jj_scanpos = xsp;
    if (jj_3R_Alter_7085_9_367()) return true;
    }
    return false;
  }

  private boolean jj_3R_IsNullExpression_3980_11_480()
 {
    if (jj_scan_token(K_IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsNullExpression_3980_19_662()) jj_scanpos = xsp;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_IsNullExpression_3979_11_479()
 {
    if (jj_scan_token(K_NOTNULL)) return true;
    return false;
  }

  private boolean jj_3R_IsNullExpression_3978_11_661()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_IsNullExpression_3978_9_478()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsNullExpression_3978_11_661()) jj_scanpos = xsp;
    if (jj_scan_token(K_ISNULL)) return true;
    return false;
  }

  private boolean jj_3R_IsNullExpression_3977_5_235()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsNullExpression_3978_9_478()) {
    jj_scanpos = xsp;
    if (jj_3R_IsNullExpression_3979_11_479()) {
    jj_scanpos = xsp;
    if (jj_3R_IsNullExpression_3980_11_480()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_Statements_873_37_116()
 {
    if (jj_3R_SingleStatement_748_9_353()) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_scan_token(ST_SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_IsDistinctExpression_3962_13_485()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpression_7020_26_571()
 {
    if (jj_scan_token(K_INDEX)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpression_7020_25_346()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpression_7020_26_571()) {
    jj_scanpos = xsp;
    if (jj_3R_AlterExpression_7021_23_572()) return true;
    }
    return false;
  }

  private boolean jj_3R_AlterExpression_7022_23_347()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpression_7021_23_572()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_Statements_872_28_115()
 {
    if (jj_scan_token(ST_SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_402()
 {
    if (jj_scan_token(K_TRUNCATE)) return true;
    if (jj_scan_token(K_PARTITION)) return true;
    return false;
  }

  private boolean jj_3R_IsDistinctExpression_3962_5_238()
 {
    if (jj_scan_token(K_IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsDistinctExpression_3962_13_485()) jj_scanpos = xsp;
    if (jj_scan_token(K_DISTINCT)) return true;
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Statements_872_28_115()) jj_scanpos = xsp;
    if (jj_scan_token(K_ELSE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_Statements_873_37_116()) {
    jj_scanpos = xsp;
    if (jj_3R_Statements_873_65_117()) return true;
    }
    return false;
  }

  private boolean jj_3_401()
 {
    if (jj_scan_token(K_RENAME)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpression_7020_25_346()) {
    jj_scanpos = xsp;
    if (jj_3R_AlterExpression_7022_23_347()) return true;
    }
    return false;
  }

  private boolean jj_3_226()
 {
    if (jj_scan_token(K_ESCAPE)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_SimilarToExpression_3944_6_663()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_SimilarToExpression_3944_5_487()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SimilarToExpression_3944_6_663()) jj_scanpos = xsp;
    if (jj_scan_token(K_SIMILAR)) return true;
    if (jj_scan_token(K_TO)) return true;
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    xsp = jj_scanpos;
    if (jj_3_226()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_400()
 {
    if (jj_scan_token(K_RENAME)) return true;
    if (jj_scan_token(K_TO)) return true;
    return false;
  }

  private boolean jj_3_224()
 {
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3_399()
 {
    if (jj_scan_token(K_RENAME)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpression_7004_84_345()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(404)) {
    jj_scanpos = xsp;
    if (jj_scan_token(424)) return true;
    }
    return false;
  }

  private boolean jj_3_223()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_scan_token(ST_SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_225()
 {
    if (jj_scan_token(K_ESCAPE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_223()) {
    jj_scanpos = xsp;
    if (jj_3_224()) return true;
    }
    return false;
  }

  private boolean jj_3_222()
 {
    if (jj_scan_token(K_BINARY)) return true;
    return false;
  }

  private boolean jj_3R_LikeExpression_3913_6_484()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_LikeExpression_3913_5_237()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_LikeExpression_3913_6_484()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(168)) {
    jj_scanpos = xsp;
    if (jj_scan_token(136)) {
    jj_scanpos = xsp;
    if (jj_scan_token(246)) {
    jj_scanpos = xsp;
    if (jj_scan_token(244)) {
    jj_scanpos = xsp;
    if (jj_scan_token(362)) return true;
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_222()) jj_scanpos = xsp;
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    xsp = jj_scanpos;
    if (jj_3_225()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_220()
 {
    if (jj_3R_RegularCondition_3710_5_229()) return true;
    return false;
  }

  private boolean jj_3_217()
 {
    if (jj_3R_RegularCondition_3710_5_229()) return true;
    return false;
  }

  private boolean jj_3_221()
 {
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    return false;
  }

  private boolean jj_3R_Between_3892_13_838()
 {
    if (jj_3R_RegularCondition_3710_5_229()) return true;
    return false;
  }

  private boolean jj_3_219()
 {
    if (jj_3R_ParenthesedSelect_2188_5_129()) return true;
    return false;
  }

  private boolean jj_3_398()
 {
    if (jj_scan_token(K_COLUMN)) return true;
    return false;
  }

  private boolean jj_3R_Block_823_5_354()
 {
    if (jj_scan_token(K_BEGIN)) return true;
    return false;
  }

  private boolean jj_3_218()
 {
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    return false;
  }

  private boolean jj_3R_Between_3883_13_477()
 {
    if (jj_3R_RegularCondition_3710_5_229()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_811_13_605()
 {
    if (jj_3R_PurgeStatement_1150_5_714()) return true;
    return false;
  }

  private boolean jj_3_216()
 {
    if (jj_3R_ParenthesedSelect_2188_5_129()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_809_13_604()
 {
    if (jj_3R_Grant_7381_9_713()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_807_13_603()
 {
    if (jj_3R_Declare_997_5_712()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_805_13_602()
 {
    if (jj_3R_Explain_1191_5_711()) return true;
    return false;
  }

  private boolean jj_3R_Between_3878_10_476()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_803_13_601()
 {
    if (jj_3R_Describe_1178_5_710()) return true;
    return false;
  }

  private boolean jj_3R_Between_3878_9_234()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Between_3878_10_476()) jj_scanpos = xsp;
    if (jj_scan_token(K_BETWEEN)) return true;
    xsp = jj_scanpos;
    if (jj_3_216()) {
    jj_scanpos = xsp;
    if (jj_3R_Between_3883_13_477()) {
    jj_scanpos = xsp;
    if (jj_3_218()) return true;
    }
    }
    if (jj_scan_token(K_AND)) return true;
    xsp = jj_scanpos;
    if (jj_3_219()) {
    jj_scanpos = xsp;
    if (jj_3R_Between_3892_13_838()) {
    jj_scanpos = xsp;
    if (jj_3_221()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_SingleStatement_801_13_600()
 {
    if (jj_3R_Comment_7351_5_709()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_799_13_599()
 {
    if (jj_3R_Commit_7336_3_708()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_797_13_598()
 {
    if (jj_3R_RollbackStatement_7315_5_707()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_795_13_597()
 {
    if (jj_3R_SavepointStatement_7299_5_706()) return true;
    return false;
  }

  private boolean jj_3_392()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_Expression_3587_5_122()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_793_13_596()
 {
    if (jj_3R_Use_1306_5_705()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_791_13_595()
 {
    if (jj_3R_RefreshMaterializedView_1368_5_704()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_789_13_594()
 {
    if (jj_3R_Show_1318_5_703()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_787_13_593()
 {
    if (jj_3R_Reset_1097_5_702()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_785_13_592()
 {
    if (jj_3R_Set_1043_5_701()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_783_13_591()
 {
    if (jj_3R_Execute_5405_5_700()) return true;
    return false;
  }

  private boolean jj_3R_ExcludesExpression_3862_5_232()
 {
    if (jj_scan_token(K_EXCLUDES)) return true;
    if (jj_3R_ParenthesedExpressionList_4070_5_210()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_781_13_590()
 {
    if (jj_3R_Truncate_6612_5_699()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_779_13_589()
 {
    if (jj_3R_Analyze_6254_5_698()) return true;
    return false;
  }

  private boolean jj_3_393()
 {
    if (jj_3R_IndexWithComment_6711_5_338()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_777_13_588()
 {
    if (jj_3R_Drop_6557_5_697()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_775_13_587()
 {
    if (jj_3R_Create_7576_5_696()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_773_13_586()
 {
    if (jj_3R_RenameTableStatement_1111_5_695()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_3R_Alter_7064_5_114()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_760_21_112()
 {
    if (jj_3R_Merge_1824_5_360()) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_Upsert_1727_5_113()) return true;
    return false;
  }

  private boolean jj_3R_IncludesExpression_3847_5_233()
 {
    if (jj_scan_token(K_INCLUDES)) return true;
    if (jj_3R_ParenthesedExpressionList_4070_5_210()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_758_21_111()
 {
    if (jj_3R_Delete_1783_5_359()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_766_13_585()
 {
    if (jj_3R_TableStatement_2172_5_694()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_756_21_110()
 {
    if (jj_3R_Update_1478_4_358()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_764_13_584()
 {
    if (jj_3R_Select_2141_5_124()) return true;
    return false;
  }

  private boolean jj_3_213()
 {
    if (jj_3R_ParenthesedSelect_2188_5_129()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_754_21_109()
 {
    if (jj_3R_Insert_1585_5_357()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_752_21_108()
 {
    if (jj_3R_SelectWithWithItems_2125_5_356()) return true;
    return false;
  }

  private boolean jj_3_388()
 {
    if (jj_3R_ColumnsNamesList_6495_5_133()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_WithList_2556_5_107()) return true;
    return false;
  }

  private boolean jj_3_215()
 {
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    return false;
  }

  private boolean jj_3_214()
 {
    if (jj_3R_ParenthesedExpressionList_4070_5_210()) return true;
    return false;
  }

  private boolean jj_3_391()
 {
    if (jj_3R_IndexWithComment_6711_5_338()) return true;
    return false;
  }

  private boolean jj_3R_InExpression_3827_11_491()
 {
    if (jj_3R_ParenthesedSelect_2188_5_129()) return true;
    return false;
  }

  private boolean jj_3_212()
 {
    if (jj_3R_Function_5488_5_248()) return true;
    return false;
  }

  private boolean jj_3R_Statement_702_61_106()
 {
    if (jj_3R_Block_823_5_354()) return true;
    return false;
  }

  private boolean jj_3_211()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_3()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SingleStatement_752_21_108()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_754_21_109()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_756_21_110()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_758_21_111()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_760_21_112()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_SingleStatement_748_9_353()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_764_13_584()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_766_13_585()) {
    jj_scanpos = xsp;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_773_13_586()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_775_13_587()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_777_13_588()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_779_13_589()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_781_13_590()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_783_13_591()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_785_13_592()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_787_13_593()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_789_13_594()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_791_13_595()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_793_13_596()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_795_13_597()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_797_13_598()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_799_13_599()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_801_13_600()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_803_13_601()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_805_13_602()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_807_13_603()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_809_13_604()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_811_13_605()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_InExpression_3822_6_490()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_InExpression_3821_6_489()
 {
    if (jj_scan_token(K_GLOBAL)) return true;
    return false;
  }

  private boolean jj_3R_InExpression_3819_7_488()
 {
    if (jj_scan_token(425)) return true;
    if (jj_scan_token(440)) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_206()
 {
    if (jj_3R_IsDistinctExpression_3962_5_238()) return true;
    return false;
  }

  private boolean jj_3R_InExpression_3818_5_246()
 {
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InExpression_3819_7_488()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_InExpression_3821_6_489()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_InExpression_3822_6_490()) jj_scanpos = xsp;
    if (jj_scan_token(K_IN)) return true;
    xsp = jj_scanpos;
    if (jj_3_211()) {
    jj_scanpos = xsp;
    if (jj_3_212()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_InExpression_3827_11_491()) {
    jj_scanpos = xsp;
    if (jj_3_214()) {
    jj_scanpos = xsp;
    if (jj_3_215()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_204()
 {
    if (jj_3R_IsBooleanExpression_3993_9_236()) return true;
    return false;
  }

  private boolean jj_3_390()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) return true;
    }
    return false;
  }

  private boolean jj_3_203()
 {
    if (jj_3R_IsNullExpression_3977_5_235()) return true;
    return false;
  }

  private boolean jj_3_389()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) return true;
    }
    return false;
  }

  private boolean jj_3R_SQLCondition_3800_17_245()
 {
    if (jj_3R_SimilarToExpression_3944_5_487()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3798_17_244()
 {
    if (jj_3R_IsDistinctExpression_3962_5_238()) return true;
    return false;
  }

  private boolean jj_3_385()
 {
    if (jj_3R_ColumnsNamesList_6495_5_133()) return true;
    return false;
  }

  private boolean jj_3_201()
 {
    if (jj_3R_IncludesExpression_3847_5_233()) return true;
    return false;
  }

  private boolean jj_3_205()
 {
    if (jj_3R_LikeExpression_3913_5_237()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3794_17_243()
 {
    if (jj_3R_IsBooleanExpression_3993_9_236()) return true;
    return false;
  }

  private boolean jj_3_200()
 {
    if (jj_3R_ExcludesExpression_3862_5_232()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3792_17_242()
 {
    if (jj_3R_IsNullExpression_3977_5_235()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3790_17_241()
 {
    if (jj_3R_MemberOfExpression_4022_5_486()) return true;
    return false;
  }

  private boolean jj_3R_Statement_702_33_105()
 {
    if (jj_3R_SingleStatement_748_9_353()) return true;
    return false;
  }

  private boolean jj_3_202()
 {
    if (jj_3R_Between_3878_9_234()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3786_17_240()
 {
    if (jj_3R_IncludesExpression_3847_5_233()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3784_17_239()
 {
    if (jj_3R_ExcludesExpression_3862_5_232()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(ST_SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_Statement_701_24_104()
 {
    if (jj_scan_token(ST_SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_209()
 {
    if (jj_3R_OverlapsCondition_3692_5_247()) return true;
    return false;
  }

  private boolean jj_3_207()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SQLCondition_3784_17_239()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_3786_17_240()) {
    jj_scanpos = xsp;
    if (jj_3_202()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_3790_17_241()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_3792_17_242()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_3794_17_243()) {
    jj_scanpos = xsp;
    if (jj_3_205()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_3798_17_244()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_3800_17_245()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_208()
 {
    if (jj_3R_InExpression_3818_5_246()) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Statement_701_24_104()) jj_scanpos = xsp;
    if (jj_scan_token(K_ELSE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_Statement_702_33_105()) {
    jj_scanpos = xsp;
    if (jj_3R_Statement_702_61_106()) return true;
    }
    return false;
  }

  private boolean jj_3_387()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) return true;
    }
    return false;
  }

  private boolean jj_3_386()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) return true;
    }
    return false;
  }

  private boolean jj_3_210()
 {
    if (jj_3R_SimpleExpression_4242_5_211()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_207()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SQLCondition_3779_7_474()
 {
    if (jj_3R_OverlapsCondition_3692_5_247()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3778_7_473()
 {
    if (jj_3R_InExpression_3818_5_246()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3777_5_472()
 {
    if (jj_3R_ExistsExpression_4009_5_660()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3776_5_230()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SQLCondition_3777_5_472()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_SQLCondition_3778_7_473()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_SQLCondition_3779_7_474()) {
    jj_scanpos = xsp;
    if (jj_3_210()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_384()
 {
    if (jj_3R_IndexWithComment_6711_5_338()) return true;
    return false;
  }

  private boolean jj_3R_AlterExpression_6805_25_344()
 {
    if (jj_3R_AlterExpressionColumnDropDefault_6665_5_570()) return true;
    return false;
  }

  private boolean jj_3_199()
 {
    if (jj_scan_token(425)) return true;
    if (jj_scan_token(440)) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpression_6791_37_340()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_AlterExpressionColumnDataType_6629_5_339()) return true;
    return false;
  }

  private boolean jj_3_383()
 {
    if (jj_3R_AlterExpressionColumnDropNotNull_6647_5_341()) return true;
    return false;
  }

  private boolean jj_3_198()
 {
    if (jj_3R_ComparisonItem_4201_3_231()) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3744_11_471()
 {
    if (jj_scan_token(457)) return true;
    return false;
  }

  private boolean jj_3_197()
 {
    if (jj_scan_token(K_PRIOR)) return true;
    if (jj_3R_ComparisonItem_4201_3_231()) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3743_11_470()
 {
    if (jj_scan_token(456)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3742_11_469()
 {
    if (jj_scan_token(455)) return true;
    return false;
  }

  private boolean jj_3_382()
 {
    if (jj_3R_AlterExpressionColumnDataType_6629_5_339()) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3741_11_468()
 {
    if (jj_scan_token(454)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3740_11_467()
 {
    if (jj_scan_token(OP_CONCAT)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3739_11_466()
 {
    if (jj_scan_token(453)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3738_11_465()
 {
    if (jj_scan_token(452)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3737_11_464()
 {
    if (jj_scan_token(438)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3736_11_463()
 {
    if (jj_scan_token(451)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3735_11_462()
 {
    if (jj_scan_token(450)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3733_11_461()
 {
    if (jj_scan_token(449)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3732_11_460()
 {
    if (jj_scan_token(448)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3731_11_459()
 {
    if (jj_scan_token(447)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3730_11_458()
 {
    if (jj_scan_token(446)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3729_11_457()
 {
    if (jj_scan_token(445)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3728_11_456()
 {
    if (jj_scan_token(OP_CONTAINEDBY)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3727_11_455()
 {
    if (jj_scan_token(OP_CONTAINS)) return true;
    return false;
  }

  private boolean jj_3_381()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_AlterExpressionColumnDataType_6629_5_339()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_AlterExpression_6791_37_340()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3726_11_454()
 {
    if (jj_scan_token(OP_DOUBLEAND)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3725_11_453()
 {
    if (jj_scan_token(444)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3724_11_452()
 {
    if (jj_scan_token(443)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3723_11_451()
 {
    if (jj_scan_token(OP_NOTEQUALSBANG)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpression_6782_23_343()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_NOT)) return true;
    if (jj_scan_token(K_EXISTS)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3722_11_450()
 {
    if (jj_scan_token(OP_NOTEQUALSSTANDARD)) return true;
    return false;
  }

  private boolean jj_3_380()
 {
    if (jj_scan_token(K_COLUMN)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3721_11_449()
 {
    if (jj_scan_token(OP_MINORTHANEQUALS)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3720_11_448()
 {
    if (jj_scan_token(OP_GREATERTHANEQUALS)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3719_11_447()
 {
    if (jj_scan_token(427)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3718_11_446()
 {
    if (jj_scan_token(442)) return true;
    return false;
  }

  private boolean jj_3_397()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_380()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpression_6782_23_343()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_381()) {
    jj_scanpos = xsp;
    if (jj_3_382()) {
    jj_scanpos = xsp;
    if (jj_3_383()) {
    jj_scanpos = xsp;
    if (jj_3R_AlterExpression_6805_25_344()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_196()
 {
    if (jj_scan_token(441)) return true;
    return false;
  }

  private boolean jj_3_379()
 {
    if (jj_3R_IndexWithComment_6711_5_338()) return true;
    return false;
  }

  private boolean jj_3_396()
 {
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    if (jj_scan_token(K_COMMENT)) return true;
    return false;
  }

  private boolean jj_3R_Condition_3676_45_228()
 {
    if (jj_scan_token(439)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3713_7_445()
 {
    if (jj_scan_token(425)) return true;
    if (jj_scan_token(440)) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3_195()
 {
    if (jj_scan_token(K_PRIOR)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3710_5_229()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_195()) jj_scanpos = xsp;
    if (jj_3R_ComparisonItem_4201_3_231()) return true;
    xsp = jj_scanpos;
    if (jj_3R_RegularCondition_3713_7_445()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_196()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3718_11_446()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3719_11_447()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3720_11_448()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3721_11_449()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3722_11_450()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3723_11_451()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3724_11_452()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3725_11_453()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3726_11_454()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3727_11_455()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3728_11_456()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3729_11_457()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3730_11_458()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3731_11_459()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3732_11_460()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3733_11_461()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3735_11_462()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3736_11_463()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3737_11_464()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3738_11_465()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3739_11_466()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3740_11_467()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3741_11_468()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3742_11_469()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3743_11_470()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3744_11_471()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_197()) {
    jj_scanpos = xsp;
    if (jj_3_198()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_199()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AlterExpression_6764_20_342()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3_395()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpression_6764_20_342()) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) return true;
    }
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    return false;
  }

  private boolean jj_3_394()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_OverlapsCondition_3692_5_247()
 {
    if (jj_3R_ParenthesedExpressionList_4070_5_210()) return true;
    if (jj_scan_token(K_OVERLAPS)) return true;
    if (jj_3R_ParenthesedExpressionList_4070_5_210()) return true;
    return false;
  }

  private boolean jj_3R_Condition_3676_21_227()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3_193()
 {
    if (jj_3R_RegularCondition_3710_5_229()) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3654_39_659()
 {
    if (jj_scan_token(439)) return true;
    return false;
  }

  private boolean jj_3_194()
 {
    if (jj_3R_SQLCondition_3776_5_230()) return true;
    return false;
  }

  private boolean jj_3R_Condition_3678_9_443()
 {
    if (jj_3R_RegularCondition_3710_5_229()) return true;
    return false;
  }

  private boolean jj_3_192()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Condition_3676_21_227()) {
    jj_scanpos = xsp;
    if (jj_3R_Condition_3676_45_228()) return true;
    }
    return false;
  }

  private boolean jj_3R_Condition_3676_5_223()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_192()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Condition_3678_9_443()) {
    jj_scanpos = xsp;
    if (jj_3_194()) return true;
    }
    return false;
  }

  private boolean jj_3R_AndExpression_3642_35_733()
 {
    if (jj_scan_token(439)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3649_21_224()
 {
    if (jj_scan_token(OP_DOUBLEAND)) return true;
    return false;
  }

  private boolean jj_3_191()
 {
    if (jj_3R_Condition_3676_5_223()) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3654_15_444()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_3654_15_658()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_3654_39_659()) return true;
    }
    return false;
  }

  private boolean jj_3R_AndExpression_3654_15_658()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3654_13_226()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_3654_15_444()) jj_scanpos = xsp;
    if (jj_scan_token(425)) return true;
    if (jj_3R_XorExpression_3597_5_193()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3651_9_225()
 {
    if (jj_3R_Condition_3676_5_223()) return true;
    return false;
  }

  private boolean jj_3_189()
 {
    if (jj_3R_Condition_3676_5_223()) return true;
    return false;
  }

  private boolean jj_3_190()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_3649_21_224()) return true;
    }
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_AndExpression_3651_9_225()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_3654_13_226()) return true;
    }
    return false;
  }

  private boolean jj_3R_AndExpression_3642_11_657()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_3642_11_732()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_3642_35_733()) return true;
    }
    return false;
  }

  private boolean jj_3R_AndExpression_3642_11_732()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3642_9_442()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_3642_11_657()) jj_scanpos = xsp;
    if (jj_scan_token(425)) return true;
    if (jj_3R_XorExpression_3597_5_193()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3639_9_441()
 {
    if (jj_3R_Condition_3676_5_223()) return true;
    return false;
  }

  private boolean jj_3R_IndexWithComment_6711_5_338()
 {
    if (jj_scan_token(K_COMMENT)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3638_5_222()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_AndExpression_3639_9_441()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_3642_9_442()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_190()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_188()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_3R_AndExpression_3638_5_222()) return true;
    return false;
  }

  private boolean jj_3R_OrExpression_3616_5_221()
 {
    if (jj_3R_AndExpression_3638_5_222()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_188()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_187()
 {
    if (jj_scan_token(K_XOR)) return true;
    if (jj_3R_OrExpression_3616_5_221()) return true;
    return false;
  }

  private boolean jj_3R_XorExpression_3597_5_193()
 {
    if (jj_3R_OrExpression_3616_5_221()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_187()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDropDefault_6665_5_570()
 {
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    if (jj_scan_token(K_DROP)) return true;
    if (jj_scan_token(K_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_Expression_3587_5_122()
 {
    if (jj_3R_XorExpression_3597_5_193()) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDropNotNull_6649_6_569()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_First_3574_9_405()
 {
    if (jj_3R_JdbcParameter_3315_5_304()) return true;
    return false;
  }

  private boolean jj_3R_First_3572_9_404()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDropNotNull_6647_5_341()
 {
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    if (jj_scan_token(K_DROP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpressionColumnDropNotNull_6649_6_569()) jj_scanpos = xsp;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_First_3570_9_403()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_First_3567_9_402()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3R_First_3565_9_401()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_First_3564_5_158()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_First_3565_9_401()) {
    jj_scanpos = xsp;
    if (jj_3R_First_3567_9_402()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_First_3570_9_403()) {
    jj_scanpos = xsp;
    if (jj_3R_First_3572_9_404()) {
    jj_scanpos = xsp;
    if (jj_3R_First_3574_9_405()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_378()
 {
    if (jj_3R_CreateParameter_6381_5_322()) return true;
    return false;
  }

  private boolean jj_3_377()
 {
    if (jj_3R_ColDataType_6190_5_297()) return true;
    return false;
  }

  private boolean jj_3_376()
 {
    if (jj_scan_token(K_TYPE)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDataType_6629_5_339()
 {
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_376()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_377()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_378()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_375()
 {
    if (jj_scan_token(K_TABLE)) return true;
    return false;
  }

  private boolean jj_3R_Skip_3532_19_400()
 {
    if (jj_3R_JdbcParameter_3315_5_304()) return true;
    return false;
  }

  private boolean jj_3R_Skip_3531_19_399()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_Truncate_6612_5_699()
 {
    if (jj_scan_token(K_TRUNCATE)) return true;
    return false;
  }

  private boolean jj_3R_Skip_3530_10_398()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_Skip_3528_5_157()
 {
    if (jj_scan_token(K_SKIP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Skip_3530_10_398()) {
    jj_scanpos = xsp;
    if (jj_3R_Skip_3531_19_399()) {
    jj_scanpos = xsp;
    if (jj_3R_Skip_3532_19_400()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_186()
 {
    if (jj_scan_token(K_WITH_TIES)) return true;
    return false;
  }

  private boolean jj_3_185()
 {
    if (jj_scan_token(K_PERCENT)) return true;
    return false;
  }

  private boolean jj_3_374()
 {
    if (jj_3R_FuncArgsList_6535_5_337()) return true;
    return false;
  }

  private boolean jj_3_373()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_EXISTS)) return true;
    return false;
  }

  private boolean jj_3_184()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_Top_3504_9_409()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_AdditiveExpression_4326_5_264()) return true;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_Top_3501_9_408()
 {
    if (jj_scan_token(DOUBLE_COLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_184()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Top_3499_9_407()
 {
    if (jj_3R_JdbcParameter_3315_5_304()) return true;
    return false;
  }

  private boolean jj_3R_Top_3497_9_406()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_Top_3495_5_159()
 {
    if (jj_scan_token(K_TOP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Top_3497_9_406()) {
    jj_scanpos = xsp;
    if (jj_3R_Top_3499_9_407()) {
    jj_scanpos = xsp;
    if (jj_3R_Top_3501_9_408()) {
    jj_scanpos = xsp;
    if (jj_3R_Top_3504_9_409()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_185()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_186()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Drop_6557_5_697()
 {
    if (jj_scan_token(K_DROP)) return true;
    return false;
  }

  private boolean jj_3R_OptimizeFor_3479_5_643()
 {
    if (jj_scan_token(K_OPTIMIZE)) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_FuncArgsList_6538_13_568()
 {
    if (jj_3R_FuncArgsListItem_6512_5_686()) return true;
    return false;
  }

  private boolean jj_3R_Offset_3398_76_217()
 {
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3R_FuncArgsList_6535_5_337()
 {
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FuncArgsList_6538_13_568()) jj_scanpos = xsp;
    if (jj_scan_token(426)) return true;
    return false;
  }

  private boolean jj_3R_WithIsolation_3462_5_632()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_ISOLATION)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_3445_21_806()
 {
    if (jj_scan_token(K_WITH_TIES)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_3443_21_805()
 {
    if (jj_scan_token(K_ONLY)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_3439_21_804()
 {
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_3437_21_803()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_FuncArgsListItem_6519_9_746()
 {
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    return false;
  }

  private boolean jj_3R_Fetch_3430_24_801()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3_372()
 {
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    return false;
  }

  private boolean jj_3R_Fetch_3434_15_802()
 {
    if (jj_scan_token(K_PERCENT)) return true;
    return false;
  }

  private boolean jj_3R_FuncArgsListItem_6512_5_686()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_372()) {
    jj_scanpos = xsp;
    if (jj_3R_FuncArgsListItem_6519_9_746()) return true;
    }
    return false;
  }

  private boolean jj_3R_Fetch_3425_17_800()
 {
    if (jj_scan_token(K_WITH_TIES)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_3423_17_799()
 {
    if (jj_scan_token(K_ONLY)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_3416_24_218()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_3429_9_725()
 {
    if (jj_scan_token(K_FETCH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Fetch_3430_24_801()) {
    jj_scanpos = xsp;
    if (jj_scan_token(189)) return true;
    }
    if (jj_3R_Expression_3587_5_122()) return true;
    xsp = jj_scanpos;
    if (jj_3R_Fetch_3434_15_802()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Fetch_3437_21_803()) {
    jj_scanpos = xsp;
    if (jj_3R_Fetch_3439_21_804()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_Fetch_3443_21_805()) {
    jj_scanpos = xsp;
    if (jj_3R_Fetch_3445_21_806()) return true;
    }
    return false;
  }

  private boolean jj_3R_Fetch_3420_17_220()
 {
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_3418_17_219()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_AList_6467_38_863()
 {
    if (jj_scan_token(427)) return true;
    return false;
  }

  private boolean jj_3R_ColumnsNamesList_6495_5_133()
 {
    if (jj_scan_token(425)) return true;
    if (jj_3R_ColumnsNamesListItem_6482_9_381()) return true;
    return false;
  }

  private boolean jj_3R_Offset_3398_30_216()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3_183()
 {
    if (jj_scan_token(K_FETCH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Fetch_3416_24_218()) {
    jj_scanpos = xsp;
    if (jj_scan_token(189)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_Fetch_3418_17_219()) {
    jj_scanpos = xsp;
    if (jj_3R_Fetch_3420_17_220()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_Fetch_3423_17_799()) {
    jj_scanpos = xsp;
    if (jj_3R_Fetch_3425_17_800()) return true;
    }
    return false;
  }

  private boolean jj_3_371()
 {
    if (jj_scan_token(425)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_ColumnsNamesListItem_6482_9_381()
 {
    if (jj_3R_RelObjectName_1972_5_174()) return true;
    return false;
  }

  private boolean jj_3R_Fetch_3414_5_631()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_183()) {
    jj_scanpos = xsp;
    if (jj_3R_Fetch_3429_9_725()) return true;
    }
    return false;
  }

  private boolean jj_3_182()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Offset_3398_30_216()) {
    jj_scanpos = xsp;
    if (jj_3R_Offset_3398_76_217()) return true;
    }
    return false;
  }

  private boolean jj_3R_AList_6466_12_778()
 {
    if (jj_3R_RelObjectNameWithoutValue_1960_5_131()) return true;
    return false;
  }

  private boolean jj_3R_AList_6467_10_862()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_AList_6467_9_832()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AList_6467_10_862()) {
    jj_scanpos = xsp;
    if (jj_3R_AList_6467_38_863(