/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.alipay;

import cn.hutool.crypto.SecureUtil;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import enums.SignType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AliPayCore {
    public static String buildRequestMySign(Map<String, String> params, String key, String signType) throws AlipayApiException {
        String preStr = AliPayCore.createLinkString(params);
        if (SignType.MD5.getType().equals(signType)) {
            return SecureUtil.md5((String)preStr.concat(key));
        }
        if (SignType.RSA2.getType().equals(signType)) {
            return AlipaySignature.rsa256Sign((String)preStr, (String)key, (String)"UTF-8");
        }
        if (SignType.RSA.getType().equals(signType)) {
            return AlipaySignature.rsaSign((String)preStr, (String)key, (String)"UTF-8");
        }
        return null;
    }

    public static Map<String, String> buildRequestPara(Map<String, String> params, String key, String signType) {
        String mySign;
        Map<String, String> tempMap = AliPayCore.paraFilter(params);
        try {
            mySign = AliPayCore.buildRequestMySign(params, key, signType);
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return null;
        }
        tempMap.put("sign", mySign);
        tempMap.put("sign_type", signType);
        return tempMap;
    }

    public static Map<String, String> paraFilter(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(params.size());
        if (params.size() <= 0) {
            return result;
        }
        for (String key : params.keySet()) {
            String value = params.get(key);
            if (value == null || "".equals(value) || "sign".equalsIgnoreCase(key) || "sign_type".equalsIgnoreCase(key)) continue;
            result.put(key, value);
        }
        return result;
    }

    public static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder content = new StringBuilder();
        for (String key : keys) {
            String value = params.get(key);
            content.append(key).append("=").append(value).append("&");
        }
        if (content.lastIndexOf("&") == content.length() - 1) {
            content.deleteCharAt(content.length() - 1);
        }
        return content.toString();
    }
}

