/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.OutParameter;
import org.apache.commons.dbutils.StatementConfiguration;

public abstract class AbstractQueryRunner {
    protected volatile boolean pmdKnownBroken = false;
    @Deprecated
    protected final DataSource ds;
    private final StatementConfiguration stmtConfig;

    public AbstractQueryRunner() {
        this.ds = null;
        this.stmtConfig = null;
    }

    public AbstractQueryRunner(boolean pmdKnownBroken) {
        this.pmdKnownBroken = pmdKnownBroken;
        this.ds = null;
        this.stmtConfig = null;
    }

    public AbstractQueryRunner(DataSource ds) {
        this.ds = ds;
        this.stmtConfig = null;
    }

    public AbstractQueryRunner(StatementConfiguration stmtConfig) {
        this.ds = null;
        this.stmtConfig = stmtConfig;
    }

    public AbstractQueryRunner(DataSource ds, boolean pmdKnownBroken) {
        this.pmdKnownBroken = pmdKnownBroken;
        this.ds = ds;
        this.stmtConfig = null;
    }

    public AbstractQueryRunner(DataSource ds, StatementConfiguration stmtConfig) {
        this.ds = ds;
        this.stmtConfig = stmtConfig;
    }

    public AbstractQueryRunner(DataSource ds, boolean pmdKnownBroken, StatementConfiguration stmtConfig) {
        this.pmdKnownBroken = pmdKnownBroken;
        this.ds = ds;
        this.stmtConfig = stmtConfig;
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    public boolean isPmdKnownBroken() {
        return this.pmdKnownBroken;
    }

    protected PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        try {
            this.configureStatement(ps);
        }
        catch (SQLException e) {
            ps.close();
            throw e;
        }
        return ps;
    }

    protected PreparedStatement prepareStatement(Connection conn, String sql, int returnedKeys) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql, returnedKeys);
        try {
            this.configureStatement(ps);
        }
        catch (SQLException e) {
            ps.close();
            throw e;
        }
        return ps;
    }

    private void configureStatement(Statement stmt) throws SQLException {
        if (this.stmtConfig != null) {
            if (this.stmtConfig.isFetchDirectionSet()) {
                stmt.setFetchDirection(this.stmtConfig.getFetchDirection());
            }
            if (this.stmtConfig.isFetchSizeSet()) {
                stmt.setFetchSize(this.stmtConfig.getFetchSize());
            }
            if (this.stmtConfig.isMaxFieldSizeSet()) {
                stmt.setMaxFieldSize(this.stmtConfig.getMaxFieldSize());
            }
            if (this.stmtConfig.isMaxRowsSet()) {
                stmt.setMaxRows(this.stmtConfig.getMaxRows());
            }
            if (this.stmtConfig.isQueryTimeoutSet()) {
                stmt.setQueryTimeout(this.stmtConfig.getQueryTimeout());
            }
        }
    }

    protected CallableStatement prepareCall(Connection conn, String sql) throws SQLException {
        return conn.prepareCall(sql);
    }

    protected Connection prepareConnection() throws SQLException {
        if (this.getDataSource() == null) {
            throw new SQLException("QueryRunner requires a DataSource to be invoked in this way, or a Connection should be passed in");
        }
        return this.getDataSource().getConnection();
    }

    public void fillStatement(PreparedStatement stmt, Object ... params) throws SQLException {
        ParameterMetaData pmd = null;
        if (!this.pmdKnownBroken) {
            try {
                pmd = stmt.getParameterMetaData();
                if (pmd == null) {
                    this.pmdKnownBroken = true;
                } else {
                    int paramsCount;
                    int stmtCount = pmd.getParameterCount();
                    int n = paramsCount = params == null ? 0 : params.length;
                    if (stmtCount != paramsCount) {
                        throw new SQLException("Wrong number of parameters: expected " + stmtCount + ", was given " + paramsCount);
                    }
                }
            }
            catch (SQLFeatureNotSupportedException ex) {
                this.pmdKnownBroken = true;
            }
        }
        if (params == null) {
            return;
        }
        CallableStatement call = null;
        if (stmt instanceof CallableStatement) {
            call = (CallableStatement)stmt;
        }
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != null) {
                if (call != null && params[i] instanceof OutParameter) {
                    ((OutParameter)params[i]).register(call, i + 1);
                    continue;
                }
                stmt.setObject(i + 1, params[i]);
                continue;
            }
            int sqlType = 12;
            if (!this.pmdKnownBroken) {
                try {
                    sqlType = pmd.getParameterType(i + 1);
                }
                catch (SQLException e) {
                    this.pmdKnownBroken = true;
                }
            }
            stmt.setNull(i + 1, sqlType);
        }
    }

    public void fillStatementWithBean(PreparedStatement stmt, Object bean, PropertyDescriptor[] properties) throws SQLException {
        Object[] params = new Object[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor property = properties[i];
            Object value = null;
            Method method = property.getReadMethod();
            if (method == null) {
                throw new RuntimeException("No read method for bean property " + bean.getClass() + " " + property.getName());
            }
            try {
                value = method.invoke(bean, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Couldn't invoke method: " + method, e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Couldn't invoke method with 0 arguments: " + method, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Couldn't invoke method: " + method, e);
            }
            params[i] = value;
        }
        this.fillStatement(stmt, params);
    }

    public void fillStatementWithBean(PreparedStatement stmt, Object bean, String ... propertyNames) throws SQLException {
        PropertyDescriptor[] descriptors;
        try {
            descriptors = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Couldn't introspect bean " + bean.getClass().toString(), e);
        }
        PropertyDescriptor[] sorted = new PropertyDescriptor[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (propertyName == null) {
                throw new NullPointerException("propertyName can't be null: " + i);
            }
            boolean found = false;
            for (int j = 0; j < descriptors.length; ++j) {
                PropertyDescriptor descriptor = descriptors[j];
                if (!propertyName.equals(descriptor.getName())) continue;
                sorted[i] = descriptor;
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("Couldn't find bean property: " + bean.getClass() + " " + propertyName);
        }
        this.fillStatementWithBean(stmt, bean, sorted);
    }

    protected void rethrow(SQLException cause, String sql, Object ... params) throws SQLException {
        String causeMessage = cause.getMessage();
        if (causeMessage == null) {
            causeMessage = "";
        }
        StringBuffer msg = new StringBuffer(causeMessage);
        msg.append(" Query: ");
        msg.append(sql);
        msg.append(" Parameters: ");
        if (params == null) {
            msg.append("[]");
        } else {
            msg.append(Arrays.deepToString(params));
        }
        SQLException e = new SQLException(msg.toString(), cause.getSQLState(), cause.getErrorCode());
        e.setNextException(cause);
        throw e;
    }

    protected ResultSet wrap(ResultSet rs) {
        return rs;
    }

    protected void close(Connection conn) throws SQLException {
        DbUtils.close(conn);
    }

    protected void close(Statement stmt) throws SQLException {
        DbUtils.close(stmt);
    }

    protected void close(ResultSet rs) throws SQLException {
        DbUtils.close(rs);
    }
}

