/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions.jfinal;

import com.github.drinkjava2.jtransactions.ConnectionManager;
import com.github.drinkjava2.jtransactions.TransactionsException;
import com.github.drinkjava2.jtransactions.TxResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;

public class JFinalTxConnectionManager
implements ConnectionManager {
    protected final Method getConfigMethod;
    protected final Method getConnectionMethod;
    protected final Method releaseConnectionMethod;
    protected final Method isInTransactionMethod;

    public JFinalTxConnectionManager() {
        Class<?> configClass;
        Class<?> dbKitClass;
        try {
            dbKitClass = Class.forName("com.jfinal.plugin.activerecord.DbKit");
            configClass = Class.forName("com.jfinal.plugin.activerecord.Config");
        }
        catch (ClassNotFoundException e) {
            throw new TransactionsException("Error: jfinal jar missing, fail to build JFinalTxManager.", e);
        }
        try {
            this.getConfigMethod = dbKitClass.getMethod("getConfig", new Class[0]);
            this.getConnectionMethod = configClass.getMethod("getConnection", new Class[0]);
            this.releaseConnectionMethod = configClass.getMethod("close", Connection.class);
            this.isInTransactionMethod = configClass.getMethod("isInTransaction", new Class[0]);
        }
        catch (Exception e) {
            throw new TransactionsException("Error: JFinalTxManager initialize failed.", e);
        }
        TransactionsException.assureNotNull(this.getConfigMethod, "Fail to get getConfigMethod method in JFinalTxManager.");
        TransactionsException.assureNotNull(this.releaseConnectionMethod, "Fail to get releaseConnectionMethod method in JFinalTxManager.");
        TransactionsException.assureNotNull(this.getConnectionMethod, "Fail to get getConnectionMethod method in JFinalTxManager.");
        TransactionsException.assureNotNull(this.isInTransactionMethod, "Fail to get isInTransactionMethod method in JFinalTxManager.");
    }

    public static final JFinalTxConnectionManager instance() {
        return JFinalTxConnectionManagerSingleton.INSTANCE;
    }

    private Object getConfig() throws IllegalAccessException, InvocationTargetException {
        Object config = this.getConfigMethod.invoke(null, new Object[0]);
        TransactionsException.assureNotNull(config, "Error: get a null jFinal config in JFinalTxManager.");
        return config;
    }

    @Override
    public boolean isInTransaction() {
        try {
            Object config = this.getConfig();
            return null != this.isInTransactionMethod.invoke(config, new Object[0]);
        }
        catch (Exception e) {
            throw new TransactionsException("Error: JFinalTxManager fail to get transaction status.", e);
        }
    }

    @Override
    public void startTransaction() {
        throw new TransactionsException("startTransaction method not implemented by current version, please use JFinal's method directly or submit a pull request");
    }

    @Override
    public void startTransaction(int txIsolationLevel) {
        throw new TransactionsException("startTransaction method not implemented by current version, please use JFinal's method directly or submit a pull request");
    }

    @Override
    public Connection getConnection(Object dsOrHolder) {
        try {
            Object config = this.getConfig();
            return (Connection)this.getConnectionMethod.invoke(config, new Object[0]);
        }
        catch (Exception e) {
            throw new TransactionsException("Error: JFinalTxManager fail to get connection.", e);
        }
    }

    @Override
    public void releaseConnection(Connection conn, Object dsOrHolder) {
        try {
            Object config = this.getConfig();
            this.releaseConnectionMethod.invoke(config, conn);
        }
        catch (Exception e) {
            throw new TransactionsException("Error: JFinalTxManager fail to release connection.", e);
        }
    }

    @Override
    public TxResult commitTransaction() throws Exception {
        throw new TransactionsException("commit method not implemented by current version, please use JFinal's method directly");
    }

    @Override
    public TxResult rollbackTransaction() {
        throw new TransactionsException("rollback method not implemented by current version, please use JFinal's method directly");
    }

    private static class JFinalTxConnectionManagerSingleton {
        private static final JFinalTxConnectionManager INSTANCE = new JFinalTxConnectionManager();

        private JFinalTxConnectionManagerSingleton() {
        }
    }
}

