/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions;

import java.io.PrintWriter;
import java.io.StringWriter;

public class TxResult {
    public static final String SUCESS = "SUCESS";
    public static final String FAIL = "FAIL";
    public static final String UNKNOW = "UNKNOW";
    public static final String START = "START";
    public static final String LOCKED = "LOCKED";
    public static final String LOCK_FAIL = "LOCK_FAIL";
    public static final String COMMIT_FAIL = "COMMIT_FAIL";
    public static final String UNLOCK_FAIL = "UNLOCK_FAIL";
    public static final String CLEANUP_FAIL = "CLEANUP_FAIL";
    private String result;
    private String stage;
    private int committed;
    private String gid;
    private Exception[] commitEx;
    private Exception[] rollbackEx;
    private Exception[] cleanupEx;

    public TxResult() {
    }

    public TxResult(String result) {
        this.result = result;
    }

    public static TxResult txSucess() {
        return new TxResult(SUCESS);
    }

    public static TxResult txFail() {
        return new TxResult(FAIL);
    }

    public TxResult(String result, Exception ... commitEx) {
        this.result = result;
        this.commitEx = commitEx;
    }

    public String getInfo() {
        return this.getInfoByRequire(false);
    }

    public String getDetailedInfo() {
        return this.getInfoByRequire(true);
    }

    private String getInfoByRequire(boolean detail) {
        StringBuilder sb = new StringBuilder();
        sb.append("TxResult:").append(this.result).append("\r");
        sb.append("TxId:").append(this.gid).append("\r");
        sb.append("TxMessage:").append(this.stage).append("\r");
        int i = 0;
        if (this.commitEx != null) {
            for (Exception e : this.commitEx) {
                sb.append("Commit Exception ").append(i++).append(": ").append(detail ? TxResult.getStackTrace(e) : e.getMessage()).append("\r");
            }
        }
        i = 0;
        if (this.rollbackEx != null) {
            for (Exception e : this.rollbackEx) {
                sb.append("Rollback Exception ").append(i++).append(": ").append(detail ? TxResult.getStackTrace(e) : e.getMessage()).append("\r");
            }
        }
        i = 0;
        if (this.cleanupEx != null) {
            for (Exception e : this.cleanupEx) {
                sb.append("Cleanup Exception ").append(i++).append(": ").append(detail ? TxResult.getStackTrace(e) : e.getMessage()).append("\r");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
            String string = sw.toString();
            return string;
        }
    }

    public TxResult addCommitEx(Exception e) {
        if (this.commitEx == null) {
            this.commitEx = new Exception[1];
        } else {
            for (Exception oldeX : this.commitEx) {
                if (oldeX != e) continue;
                return this;
            }
            Exception[] newArray = new Exception[this.commitEx.length + 1];
            System.arraycopy(this.commitEx, 0, newArray, 0, this.commitEx.length);
            this.commitEx = newArray;
        }
        this.commitEx[this.commitEx.length - 1] = e;
        return this;
    }

    public TxResult addRollbackEx(Exception e) {
        if (this.rollbackEx == null) {
            this.rollbackEx = new Exception[1];
        } else {
            for (Exception oldeX : this.rollbackEx) {
                if (oldeX != e) continue;
                return this;
            }
            Exception[] newArray = new Exception[this.rollbackEx.length + 1];
            System.arraycopy(this.rollbackEx, 0, newArray, 0, this.rollbackEx.length);
            this.rollbackEx = newArray;
        }
        this.rollbackEx[this.rollbackEx.length - 1] = e;
        return this;
    }

    public TxResult addCleanupEx(Exception e) {
        if (this.cleanupEx == null) {
            this.cleanupEx = new Exception[1];
        } else {
            for (Exception oldeX : this.cleanupEx) {
                if (oldeX != e) continue;
                return this;
            }
            Exception[] newArray = new Exception[this.cleanupEx.length + 1];
            System.arraycopy(this.cleanupEx, 0, newArray, 0, this.cleanupEx.length);
            this.cleanupEx = newArray;
        }
        this.cleanupEx[this.cleanupEx.length - 1] = e;
        return this;
    }

    public boolean isSuccess() {
        return SUCESS.equals(this.result);
    }

    public boolean isFail() {
        return FAIL.equals(this.result);
    }

    public boolean isUnknow() {
        return UNKNOW.equals(this.result);
    }

    public String getResult() {
        return this.result;
    }

    public TxResult setResult(String result) {
        this.result = result;
        return this;
    }

    public String getStage() {
        return this.stage;
    }

    public TxResult setStage(String stage) {
        this.stage = stage;
        return this;
    }

    public String getGid() {
        return this.gid;
    }

    public TxResult setGid(String gid) {
        this.gid = gid;
        return this;
    }

    public Exception[] getCommitEx() {
        return this.commitEx;
    }

    public void setCommitEx(Exception[] commitEx) {
        this.commitEx = commitEx;
    }

    public Exception[] getRollbackEx() {
        return this.rollbackEx;
    }

    public void setRollbackEx(Exception[] rollbackEx) {
        this.rollbackEx = rollbackEx;
    }

    public Exception[] getCleanupEx() {
        return this.cleanupEx;
    }

    public void setCleanupEx(Exception[] cleanupEx) {
        this.cleanupEx = cleanupEx;
    }

    public int getCommitted() {
        return this.committed;
    }

    public void setCommitted(int committed) {
        this.committed = committed;
    }
}

