/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions;

import com.github.drinkjava2.jtransactions.ConnectionManager;
import com.github.drinkjava2.jtransactions.TxInfo;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class ThreadConnectionManager
implements ConnectionManager {
    private ThreadLocal<TxInfo> threadedTxInfo = new ThreadLocal();

    @Override
    public boolean isInTransaction() {
        return this.threadedTxInfo.get() != null;
    }

    @Override
    public void releaseConnection(Connection conn, Object dsOwner) throws SQLException {
        if (!this.isInTransaction() && conn != null) {
            conn.close();
        }
    }

    @Override
    public void startTransaction() {
        this.threadedTxInfo.set(new TxInfo());
    }

    @Override
    public void startTransaction(int txIsolationLevel) {
        this.threadedTxInfo.set(new TxInfo(txIsolationLevel));
    }

    public TxInfo getThreadTxInfo() {
        return this.threadedTxInfo.get();
    }

    public void setThreadTxInfo(TxInfo txInfo) {
        this.threadedTxInfo.set(txInfo);
    }
}

