/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.sharding;

import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.DbException;
import com.github.drinkjava2.jsqlbox.sharding.ShardingTool;
import java.util.Collection;
import java.util.HashSet;

public class ShardingRangeTool
implements ShardingTool {
    @Override
    public Integer[] handleShardTable(TableModel model, Object ... shardkey) {
        ColumnModel col = model.getShardTableColumn();
        if (col == null) {
            return null;
        }
        if (!"RANGE".equalsIgnoreCase(col.getShardTable()[0])) {
            return null;
        }
        String rangeSize = col.getShardTable()[1];
        Object shardKey1 = null;
        Object shardkey2 = null;
        Class<?> entityOrClass = model.getEntityClass();
        DbException.assureNotNull(entityOrClass, new String[0]);
        if (shardkey == null || shardkey.length == 0) {
            throw new DbException("ShardTable key parameter needed");
        }
        if (shardkey.length == 1) {
            shardKey1 = shardkey[0];
        } else {
            shardKey1 = shardkey[0];
            shardkey2 = shardkey[1];
        }
        if (shardKey1 == null) {
            throw new DbException("ShardTable key value can not be null");
        }
        return this.doCalculate(rangeSize, shardKey1, shardkey2);
    }

    @Override
    public Integer[] handleShardDatabase(TableModel model, Object ... shardkey) {
        ColumnModel col = model.getShardDatabaseColumn();
        if (col == null) {
            return null;
        }
        if (!"RANGE".equalsIgnoreCase(col.getShardDatabase()[0])) {
            return null;
        }
        String rangeSize = col.getShardDatabase()[1];
        Object shardKey1 = null;
        Object shardkey2 = null;
        Class<?> entityOrClass = model.getEntityClass();
        DbException.assureNotNull(entityOrClass, new String[0]);
        if (shardkey == null || shardkey.length == 0) {
            throw new DbException("ShardDatabase key parameter needed");
        }
        if (shardkey.length == 1) {
            shardKey1 = shardkey[0];
        } else {
            shardKey1 = shardkey[0];
            shardkey2 = shardkey[1];
        }
        if (shardKey1 == null) {
            throw new DbException("ShardDatabase key value can not be null");
        }
        return this.doCalculate(rangeSize, shardKey1, shardkey2);
    }

    private Integer[] doCalculate(String rangeSizz, Object shardKey1, Object shardkey2) {
        if (shardkey2 != null) {
            return ShardingRangeTool.calculateRanges(shardKey1, shardkey2, rangeSizz);
        }
        HashSet<Integer> set = new HashSet<Integer>();
        if (shardKey1 instanceof Collection) {
            for (Object key : (Collection)shardKey1) {
                set.add(ShardingRangeTool.calcuteByOneValue(key, rangeSizz));
            }
            return set.toArray(new Integer[set.size()]);
        }
        if (shardKey1.getClass().isArray()) {
            for (Object key : (Object[])shardKey1) {
                set.add(ShardingRangeTool.calcuteByOneValue(key, rangeSizz));
            }
            return set.toArray(new Integer[set.size()]);
        }
        return new Integer[]{ShardingRangeTool.calcuteByOneValue(shardKey1, rangeSizz)};
    }

    private static Integer[] calculateRanges(Object firstKey, Object secondKey, String rangeSize) {
        int firstTable;
        long size;
        long from = Long.parseLong(String.valueOf(firstKey));
        long last = Long.parseLong(String.valueOf(secondKey));
        int lastTable = (int)(last / (size = Long.parseLong(String.valueOf(rangeSize))));
        if (lastTable < (firstTable = (int)(from / size))) {
            return new Integer[0];
        }
        Integer[] result = new Integer[lastTable - firstTable + 1];
        for (int i = firstTable; i <= lastTable; ++i) {
            result[i - firstTable] = i;
        }
        return result;
    }

    private static Integer calcuteByOneValue(Object keyValue, String rangeSize) {
        long shardKeyValue = Long.parseLong(String.valueOf(keyValue));
        long size = Long.parseLong(String.valueOf(rangeSize));
        return (int)(shardKeyValue / size);
    }
}

