/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.gtx;

import com.github.drinkjava2.jlogs.Log;
import com.github.drinkjava2.jlogs.LogFactory;
import com.github.drinkjava2.jsqlbox.DbContext;
import com.github.drinkjava2.jsqlbox.gtx.GtxInfo;
import com.github.drinkjava2.jsqlbox.gtx.GtxTag;
import com.github.drinkjava2.jsqlbox.gtx.GtxUtils;
import com.github.drinkjava2.jtransactions.ThreadConnectionManager;
import com.github.drinkjava2.jtransactions.TransactionsException;
import com.github.drinkjava2.jtransactions.TxInfo;
import com.github.drinkjava2.jtransactions.TxResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;

public class GtxConnectionManager
extends ThreadConnectionManager {
    protected static final Log logger = LogFactory.getLog(GtxConnectionManager.class);
    private DbContext lockCtx;

    public DbContext getLockCtx() {
        return this.lockCtx;
    }

    public void setLockCtx(DbContext lockCtx) {
        this.lockCtx = lockCtx;
    }

    public GtxConnectionManager(DbContext lockCtx) {
        this.lockCtx = lockCtx;
    }

    @Override
    public void startTransaction() {
        this.setThreadTxInfo(new GtxInfo());
    }

    @Override
    public void startTransaction(int txIsolationLevel) {
        GtxInfo gtxInfo = new GtxInfo();
        gtxInfo.setTxIsolationLevel(txIsolationLevel);
        this.setThreadTxInfo(gtxInfo);
    }

    @Override
    public Connection getConnection(Object dsHolder) throws SQLException {
        DbContext ctx = (DbContext)dsHolder;
        DataSource ds = ctx.getDataSource();
        TransactionsException.assureNotNull(dsHolder, "DataSource can not be null");
        if (this.isInTransaction()) {
            TxInfo tx = this.getThreadTxInfo();
            Connection conn = tx.getConnectionCache().get(ctx);
            if (conn == null) {
                conn = ds.getConnection();
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(tx.getTxIsolationLevel());
                tx.getConnectionCache().put(ctx, conn);
            }
            return conn;
        }
        return ds.getConnection();
    }

    @Override
    public TxResult commitTransaction() throws Exception {
        DbContext ctx;
        GtxInfo gtxInfo = (GtxInfo)this.getThreadTxInfo();
        if (gtxInfo == null) {
            throw new TransactionsException("GTX not started, can not commit");
        }
        TxResult result = gtxInfo.getTxResult().setStage("START");
        for (Object object : gtxInfo.getConnectionCache().keySet()) {
            ((DbContext)object).entityInsert(new GtxTag(gtxInfo.getGtxId().getGid()), new Object[0]);
        }
        try {
            GtxUtils.saveLockAndLog(this.lockCtx, gtxInfo);
        }
        catch (Exception e) {
            result.setStage("LOCK_FAIL");
            result.addCommitEx(e);
            throw e;
        }
        int committed = 0;
        try {
            for (Map.Entry<Object, Connection> entry : gtxInfo.getConnectionCache().entrySet()) {
                ctx = (DbContext)entry.getKey();
                int forceCommitFail = ctx.getForceCommitFail();
                if (forceCommitFail > 0 || forceCommitFail < 0) {
                    if (forceCommitFail > 0) {
                        ctx.setForceCommitFail(forceCommitFail - 1);
                    }
                    throw new IllegalArgumentException("ForceCommitFail=" + forceCommitFail + " in ctx '" + ctx.getName() + "', a non 0 value will force a commit fail, usually used for unit test.");
                }
                Connection conn = entry.getValue();
                conn.commit();
                ++committed;
            }
        }
        catch (Exception exception) {
            result.setCommitted(committed);
            result.setStage("COMMIT_FAIL");
            result.addCommitEx(exception);
            throw exception;
        }
        try {
            GtxUtils.deleteLockAndLog(this.lockCtx, gtxInfo);
        }
        catch (Exception exception) {
            result.setStage("UNLOCK_FAIL");
            result.addCommitEx(exception);
            throw exception;
        }
        for (Object key : gtxInfo.getConnectionCache().keySet()) {
            ctx = (DbContext)key;
            try {
                ctx.entityDelete(new GtxTag(gtxInfo.getGtxId().getGid()), new Object[0]);
            }
            catch (Exception e) {
                result.setStage("CLEANUP_FAIL");
                result.addCommitEx(e);
            }
        }
        this.setThreadTxInfo(null);
        this.cleanupConnections(gtxInfo);
        return result.setResult("SUCESS");
    }

    @Override
    public TxResult rollbackTransaction() {
        if (!this.isInTransaction()) {
            throw new TransactionsException("Gtx transaction not started, can not rollback");
        }
        GtxInfo gtxInfo = (GtxInfo)this.getThreadTxInfo();
        gtxInfo.getTxResult().setResult("FAIL");
        this.setThreadTxInfo(null);
        this.rollbackConnections(gtxInfo);
        return gtxInfo.getTxResult();
    }

    private void rollbackConnections(GtxInfo gtxInfo) {
        Collection<Connection> conns = gtxInfo.getConnectionCache().values();
        TxResult result = gtxInfo.getTxResult();
        int index = 0;
        for (Connection con : conns) {
            if (con == null) continue;
            try {
                if (index >= result.getCommitted()) {
                    con.rollback();
                }
            }
            catch (SQLException e) {
                result.addRollbackEx(e);
            }
            try {
                if (!con.getAutoCommit()) {
                    con.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                result.addRollbackEx(e);
            }
            try {
                if (!con.isClosed()) {
                    con.close();
                }
            }
            catch (SQLException e) {
                result.addRollbackEx(e);
            }
            ++index;
        }
        conns.clear();
    }

    private void cleanupConnections(GtxInfo gtxInfo) {
        Collection<Connection> conns = gtxInfo.getConnectionCache().values();
        for (Connection con : conns) {
            if (con == null) continue;
            try {
                if (!con.getAutoCommit()) {
                    con.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                gtxInfo.getTxResult().addCleanupEx(e);
            }
            try {
                if (con.isClosed()) continue;
                con.close();
            }
            catch (SQLException e) {
                gtxInfo.getTxResult().addCleanupEx(e);
            }
        }
        conns.clear();
    }
}

