/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdbpro.CustomizedSqlItem;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jsqlbox.AliasProxyUtil;
import com.github.drinkjava2.jsqlbox.DbException;

public interface LambdSqlItem
extends CustomizedSqlItem {
    @Override
    default public void doPrepare(PreparedSQL ps) {
        AliasProxyUtil.aliasItemInfo.remove();
        if (this instanceof ALIAS) {
            ((ALIAS)this).get();
            AliasProxyUtil.AliasItemInfo a = AliasProxyUtil.aliasItemInfo.get();
            if (StrUtils.isEmpty(a.colName)) {
                throw new DbException("Column name not found.");
            }
            if (StrUtils.isEmpty(a.alias)) {
                ps.addSql(a.colName);
            } else {
                ps.addSql(a.alias).append(".").append(a.colName).append(" as ").append(a.alias).append("_").append(a.colName);
            }
        } else if (this instanceof C_ALIAS) {
            ((C_ALIAS)this).get();
            AliasProxyUtil.AliasItemInfo a = AliasProxyUtil.aliasItemInfo.get();
            if (StrUtils.isEmpty(a.colName)) {
                throw new DbException("Column name not found.");
            }
            if (StrUtils.isEmpty(a.alias)) {
                ps.addSql(", " + a.colName);
            } else {
                ps.addSql(", ").append(a.alias).append(".").append(a.colName).append(" as ").append(a.alias).append("_").append(a.colName);
            }
        } else if (this instanceof COL) {
            ((COL)this).get();
            AliasProxyUtil.AliasItemInfo a = AliasProxyUtil.aliasItemInfo.get();
            if (StrUtils.isEmpty(a.colName)) {
                throw new DbException("Column name not found.");
            }
            if (StrUtils.isEmpty(a.alias)) {
                ps.addSql(a.colName);
            } else {
                ps.addSql(a.alias).append(".").append(a.colName);
            }
        } else {
            throw new DbException("Unsupported CustomizedSqlItem found.");
        }
    }

    public static interface COL
    extends LambdSqlItem {
        public Object get();
    }

    public static interface C_ALIAS
    extends LambdSqlItem {
        public Object get();
    }

    public static interface ALIAS
    extends LambdSqlItem {
        public Object get();
    }
}

