/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdbpro.DbPro;
import com.github.drinkjava2.jdbpro.DbProException;
import com.github.drinkjava2.jdbpro.ImprovedQueryRunner;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdbpro.template.BasicSqlTemplate;
import com.github.drinkjava2.jdbpro.template.SqlTemplateEngine;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jsqlbox.DbContext;
import com.github.drinkjava2.jsqlbox.DbException;
import com.github.drinkjava2.jsqlbox.TxBody;
import com.github.drinkjava2.jsqlbox.entitynet.EntityNet;
import com.github.drinkjava2.jsqlbox.handler.PaginHandler;
import com.github.drinkjava2.jtransactions.TxResult;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DB {
    public static final SqlOption EXECUTE = SqlOption.EXECUTE;
    public static final SqlOption UPDATE = SqlOption.UPDATE;
    public static final SqlOption INSERT = SqlOption.INSERT;
    public static final SqlOption QUERY = SqlOption.QUERY;
    public static final SqlOption USE_AUTO = SqlOption.USE_AUTO;
    public static final SqlOption USE_MASTER = SqlOption.USE_MASTER;
    public static final SqlOption USE_SLAVE = SqlOption.USE_SLAVE;
    public static final SqlOption USE_BOTH = SqlOption.USE_BOTH;
    public static final SqlOption IGNORE_NULL = SqlOption.IGNORE_NULL;
    public static final SqlOption IGNORE_EMPTY = SqlOption.IGNORE_EMPTY;
    public static final SqlOption AUTO_SQL = SqlOption.AUTO_SQL;
    public static final SqlItem TAIL = new SqlItem(SqlOption.TAIL, new Object[0]);
    public static final SqlTemplateEngine TEMPLATE = BasicSqlTemplate.instance();

    protected void ________SqlItem_Methods________() {
    }

    public static SqlItem par(Object ... parameters) {
        return new SqlItem(SqlOption.PARAM, parameters);
    }

    public static SqlItem que(Object ... parameters) {
        return new SqlItem(SqlOption.QUESTION_PARAM, parameters);
    }

    public static SqlItem param(Object ... parameters) {
        return new SqlItem(SqlOption.PARAM, parameters);
    }

    public static SqlItem ques(Object ... parameters) {
        return new SqlItem(SqlOption.QUESTION_PARAM, parameters);
    }

    public static SqlItem question(Object ... parameters) {
        return new SqlItem(SqlOption.QUESTION_PARAM, parameters);
    }

    public static Object notNull(Object ... items) {
        if (items.length < 2) {
            throw new DbProException("notNull method need at least 2 args");
        }
        Object lastObj = items[items.length - 1];
        if (items[items.length - 1] == null) {
            return "";
        }
        items[items.length - 1] = DB.par(lastObj);
        return items;
    }

    public static Object noNull(Object ... items) {
        if (items.length < 2) {
            throw new DbProException("noNull method need at least 2 args");
        }
        for (int i = 0; i <= items.length - 1; ++i) {
            if (items[i] != null) continue;
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= items.length - 1; ++i) {
            sb.append(items[i]);
        }
        return new Object[]{items[0], DB.par(sb.toString())};
    }

    public static Object notBlank(Object ... items) {
        Object lastObj = items[items.length - 1];
        if (StrUtils.isBlankObject(lastObj)) {
            return "";
        }
        items[items.length - 1] = DB.par(lastObj);
        return items;
    }

    public static Object noBlank(Object ... items) {
        if (items.length < 2) {
            throw new DbProException("noBlank method need at least 2 args");
        }
        for (int i = 0; i <= items.length - 1; ++i) {
            if (!StrUtils.isBlankObject(items[i])) continue;
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= items.length - 1; ++i) {
            sb.append(items[i]);
        }
        return new Object[]{items[0], DB.par(sb.toString())};
    }

    public static Object when(boolean condition, Object ... items) {
        return condition ? items : "";
    }

    public static SqlItem valuesQuestions() {
        return new SqlItem(SqlOption.VALUES_QUESTIONS, new Object[0]);
    }

    public static SqlItem other(Object ... otherInfos) {
        return new SqlItem(SqlOption.OTHER, otherInfos);
    }

    public static List<Object[]> getOthers() {
        return DB.gctx().getOthers();
    }

    public static SqlItem switchTo(DbPro dpPro) {
        return new SqlItem(SqlOption.SWITCHTO, dpPro);
    }

    public static SqlItem bind(Object ... parameters) {
        return new SqlItem(SqlOption.BIND, parameters);
    }

    public static SqlItem disableHandlers(Class<?> ... args) {
        return new SqlItem(SqlOption.DISABLE_HANDLERS, args);
    }

    public static DbContext gctx() {
        return DbContext.getGlobalDbContext();
    }

    public static boolean tx(TxBody txBody) {
        return DbContext.getGlobalDbContext().tryTx(txBody);
    }

    public static TxResult getLastTxResult() {
        return ImprovedQueryRunner.getLastTxResult();
    }

    public static SqlItem tail(Object ... tableName) {
        return new SqlItem(SqlOption.TAIL, tableName);
    }

    public static PaginHandler pagin(int pageNumber, int pageSize) {
        return new PaginHandler(pageNumber, pageSize);
    }

    public static SqlItem noPagin() {
        return new SqlItem(SqlOption.DISABLE_HANDLERS, PaginHandler.class);
    }

    public static SqlItem alias(String ... alias) {
        return new SqlItem(SqlOption.ALIAS, alias);
    }

    public static SqlItem give(String from, String to, String fieldName) {
        return new SqlItem(SqlOption.GIVE, from, to, fieldName);
    }

    public static SqlItem give(String from, String to) {
        return new SqlItem(SqlOption.GIVE, from, to);
    }

    public static SqlItem giveBoth(String from, String to) {
        return new SqlItem(SqlOption.GIVE_BOTH, from, to);
    }

    public static SqlItem shardTB(Object ... shardvalues) {
        if (shardvalues.length == 0) {
            throw new DbException("shardTB() method need at least 1 parameter");
        }
        if (shardvalues.length == 1) {
            return new SqlItem(SqlOption.SHARD_TABLE, shardvalues[0]);
        }
        if (shardvalues.length == 2) {
            return new SqlItem(SqlOption.SHARD_TABLE, shardvalues[0], shardvalues[1]);
        }
        throw new DbException("shardTB() method allow at most 2 parameter");
    }

    public static SqlItem shardDB(Object ... shardvalues) {
        if (shardvalues.length == 0) {
            throw new DbException("shardDB() method need at least 1 parameter");
        }
        if (shardvalues.length == 1) {
            return new SqlItem(SqlOption.SHARD_DATABASE, shardvalues[0]);
        }
        if (shardvalues.length == 2) {
            return new SqlItem(SqlOption.SHARD_DATABASE, shardvalues[0], shardvalues[1]);
        }
        throw new DbException("shardTB() method allow at most 2 parameter");
    }

    public static Object[] shard(Object ... shardvalues) {
        return new Object[]{DB.shardTB(shardvalues), DB.shardDB(shardvalues)};
    }

    protected void ________Entity_Methods________() {
    }

    public static <T> List<T> entityFind(Class<T> entityClass, Object ... items) {
        return DB.gctx().entityFind(entityClass, items);
    }

    public static <T> List<T> entityFindBySample(Object sampleBean, Object ... items) {
        return DB.gctx().entityFindBySample(sampleBean, items);
    }

    public static <T> List<T> entityFindBySql(Object ... items) {
        return DB.gctx().entityFindBySql(items);
    }

    public static <T> T entityFindOneBySQL(Object ... items) {
        return DB.gctx().entityFindOneBySQL(items);
    }

    public static <T> T entityLoad(T entity, Object ... items) {
        return DB.gctx().entityLoad(entity, items);
    }

    public static <T> T entityLoadById(Class<T> entityClass, Object entityId, Object ... items) {
        return DB.gctx().entityLoadById(entityClass, entityId, items);
    }

    public static <T> T entityLoadByIdTry(Class<T> entityClass, Object entityId, Object ... items) {
        return DB.gctx().entityLoadByIdTry(entityClass, entityId, items);
    }

    public static <T> T entityLoadBySql(Object ... items) {
        return DB.gctx().entityLoadBySql(items);
    }

    public static <T> T entityInsert(T entity, Object ... items) {
        return DB.gctx().entityInsert(entity, items);
    }

    public static <T> T entityUpdate(Object entity, Object ... items) {
        return DB.gctx().entityUpdate(entity, items);
    }

    public static boolean entityExist(Object entity, Object ... items) {
        return DB.gctx().entityExist(entity, items);
    }

    public static boolean entityExistById(Class<?> entityClass, Object id, Object ... items) {
        return DB.gctx().entityExistById(entityClass, id, items);
    }

    public static int entityCount(Class<?> entityClass, Object ... items) {
        return DB.gctx().entityCount(entityClass, items);
    }

    public static int entityDeleteByIdTry(Class<?> entityClass, Object id, Object ... items) {
        return DB.gctx().entityDeleteByIdTry(entityClass, id, items);
    }

    public static int entityDeleteTry(Object entity, Object ... items) {
        return DB.gctx().entityDeleteTry(entity, items);
    }

    public static int entityLoadTry(Object entity, Object ... items) {
        return DB.gctx().entityLoadTry(entity, items);
    }

    public static int entityUpdateTry(Object entity, Object ... items) {
        return DB.gctx().entityUpdateTry(entity, items);
    }

    public static void entityDelete(Object entity, Object ... items) {
        DB.gctx().entityDelete(entity, items);
    }

    public static void entityDeleteById(Class<?> entityClass, Object id, Object ... items) {
        DB.gctx().entityDeleteById(entityClass, id, items);
    }

    public static <T> T entityFindRelatedOne(Object entity, Object ... sqlItems) {
        return (T)DB.gctx().entityFindRelatedOne(entity, sqlItems);
    }

    public static <T> List<T> entityFindRelatedList(Object entityOrIterable, Object ... sqlItems) {
        return DB.gctx().entityFindRelatedList(entityOrIterable, sqlItems);
    }

    public static <T> Set<T> entityFindRelatedSet(Object entity, Object ... sqlItems) {
        return DB.gctx().entityFindRelatedSet(entity, sqlItems);
    }

    public static <T> Map<Object, T> entityFindRelatedMap(Object entity, Object ... sqlItems) {
        return DB.gctx().entityFindRelatedMap(entity, sqlItems);
    }

    public static EntityNet autoNet(Class<?> ... entityClass) {
        return DB.gctx().autoNet(entityClass);
    }

    protected void ________SQL_Methods________() {
    }

    public static <T> T qry(Object ... items) {
        return DB.gctx().qry(items);
    }

    public static <T> T qryObject(Object ... items) {
        return DB.gctx().qryObject(items);
    }

    public static long qryLongValue(Object ... items) {
        return DB.gctx().qryLongValue(items);
    }

    public static int qryIntValue(Object ... items) {
        return DB.gctx().qryIntValue(items);
    }

    public static String qryString(Object ... items) {
        return DB.gctx().qryString(items);
    }

    public static List<Map<String, Object>> qryMapList(Object ... items) {
        return DB.gctx().qryMapList(items);
    }

    public static Map<String, Object> qryMap(Object ... items) {
        return DB.gctx().qryMap(items);
    }

    public static <T> List<T> qryList(Object ... items) {
        return DB.gctx().qryList(items);
    }

    public static int upd(Object ... items) {
        return DB.gctx().upd(items);
    }

    public static <T> T ins(Object ... items) {
        return DB.gctx().ins(items);
    }

    public static <T> T exe(Object ... items) {
        return DB.gctx().exe(items);
    }

    public static <T> List<T> qryEntityList(Object ... items) {
        return DB.gctx().qryEntityList(items);
    }

    public static PreparedSQL prepare(Object ... items) {
        return DB.gctx().prepare(items);
    }
}

