/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdialects.ArrayUtils;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.DbContext;
import com.github.drinkjava2.jsqlbox.DbContextUtils;
import com.github.drinkjava2.jsqlbox.DbException;
import com.github.drinkjava2.jsqlbox.EntityType;
import com.github.drinkjava2.jsqlbox.TailType;
import com.github.drinkjava2.jsqlbox.entitynet.EntityNet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ActiveRecord<T>
implements TailType,
EntityType {
    static final ThreadLocal<String[]> forFieldsOrTails = new ThreadLocal();
    static final ThreadLocal<Boolean> isForfield = new ThreadLocal();
    private DbContext ctx;
    private Map<String, Object> tailsMap;

    protected void miscMethods__________________() {
    }

    public DbContext ctx() {
        if (this.ctx != null) {
            return this.ctx;
        }
        DbException.assureNotNull(DbContext.globalDbContext, "No default global DbContext found, need use method DbContext.setGlobalDbContext() to set a global default DbContext instance at the beginning of appication.");
        return DbContext.globalDbContext;
    }

    public TableModel model() {
        return DbContextUtils.findEntityOrClassTableModel(this).newCopy();
    }

    public T useContext(DbContext ctx) {
        this.ctx = ctx;
        return (T)this;
    }

    @Override
    public Map<String, Object> tails() {
        if (this.tailsMap == null) {
            this.tailsMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        }
        return this.tailsMap;
    }

    public <V> V getField(String fieldName) {
        return (V)ClassCacheUtils.readValueFromBeanField(this, fieldName);
    }

    public <V> V getTail(String columnName) {
        if (this.tailsMap == null) {
            return null;
        }
        return (V)this.tailsMap.get(columnName);
    }

    public T putTail(Object ... columAndValues) {
        DbException.assureTrue(columAndValues.length % 2 == 0, "Column and values should be paired");
        for (int i = 0; i < columAndValues.length / 2; ++i) {
            this.tails().put((String)columAndValues[i * 2], columAndValues[i * 2 + 1]);
        }
        return (T)this;
    }

    public T putField(Object ... fieldAndValues) {
        DbException.assureTrue(fieldAndValues.length % 2 == 0, "Field and values should be paired");
        for (int i = 0; i < fieldAndValues.length / 2; ++i) {
            ClassCacheUtils.writeValueToBeanField(this, (String)fieldAndValues[i * 2], fieldAndValues[i * 2 + 1]);
        }
        return (T)this;
    }

    public T forFields(String ... fieldNames) {
        forFieldsOrTails.set(fieldNames);
        isForfield.set(true);
        return (T)this;
    }

    public T forTails(String ... columnNames) {
        forFieldsOrTails.set(columnNames);
        isForfield.set(false);
        return (T)this;
    }

    public T putValues(Object ... values) {
        String[] fields = forFieldsOrTails.get();
        if (values.length == 0 || fields == null || fields.length == 0) {
            throw new DbException("putValues fields or values can not be empty");
        }
        if (values.length != fields.length) {
            throw new DbException("putValues quantity does not match forFields or forColumns");
        }
        for (int i = 0; i < fields.length; ++i) {
            if (Boolean.TRUE.equals(isForfield.get())) {
                ClassCacheUtils.writeValueToBeanField(this, fields[i], values[i]);
                continue;
            }
            this.tails().put(fields[i], values[i]);
        }
        return (T)this;
    }

    public String shardTB(Object ... items) {
        TableModel model = DbContextUtils.findTableModel(this.getClass(), items);
        ColumnModel col = model.getShardTableColumn();
        if (col == null || col.getShardTable() == null || col.getShardTable().length == 0) {
            throw new DbException("Not found ShardTable setting for '" + model.getEntityClass() + "'");
        }
        Object shardKey1 = DbContextUtils.readValueFromBeanFieldOrTail(col, this, false, false);
        return DbContextUtils.getShardedTB(this.ctx(), model.getEntityClass(), shardKey1);
    }

    public DbContext shardDB(Object ... items) {
        TableModel model = DbContextUtils.findTableModel(this.getClass(), items);
        ColumnModel col = model.getShardDatabaseColumn();
        if (col == null || col.getShardDatabase() == null || col.getShardDatabase().length == 0) {
            throw new DbException("Not found ShardTable setting for '" + model.getEntityClass() + "'");
        }
        Object shardKey1 = DbContextUtils.readValueFromBeanFieldOrTail(col, this, false, false);
        return DbContextUtils.getShardedDB(this.ctx(), model.getEntityClass(), shardKey1);
    }

    public Object[] shard(Object ... items) {
        return new Object[]{this.shardTB(items), this.shardDB(items)};
    }

    protected static Object[] insertThisClassIfNotHave(Object entity, Object ... items) {
        Object[] newItems = items;
        TableModel[] models = DbContextUtils.findAllModels(items);
        if (models.length == 0) {
            throw new DbException("No TableMode found for entity.");
        }
        TableModel model = models[0];
        if (!entity.getClass().equals(model.getEntityClass())) {
            model = TableModelUtils.entity2ReadOnlyModel(entity.getClass());
            newItems = ArrayUtils.insertArray(model, items);
        }
        return newItems;
    }

    protected void crudMethods__________________() {
    }

    public T insert(Object ... items) {
        return (T)this.ctx().entityInsert(this, items);
    }

    public T update(Object ... items) {
        return this.ctx().entityUpdate(this, items);
    }

    public int updateTry(Object ... items) {
        return this.ctx().entityUpdateTry(this, items);
    }

    public void delete(Object ... items) {
        this.ctx().entityDelete(this, items);
    }

    public int deleteTry(Object ... items) {
        return this.ctx().entityDeleteTry(this, items);
    }

    public void deleteById(Object id, Object ... items) {
        this.ctx().entityDeleteById(this.getClass(), id, items);
    }

    public int deleteByIdTry(Object id, Object ... items) {
        return this.ctx().entityDeleteByIdTry(this.getClass(), id, items);
    }

    public boolean existStrict(Object ... items) {
        return this.ctx().entityExistStrict(this, items);
    }

    public boolean existId(Object ... items) {
        return this.ctx().entityExist(this, items);
    }

    public boolean existById(Object id, Object ... items) {
        return this.ctx().entityExistById(this.getClass(), id, items);
    }

    public int countAll(Object ... items) {
        return this.ctx().entityCount(this.getClass(), items);
    }

    public T load(Object ... items) {
        return (T)this.ctx().entityLoad(this, items);
    }

    public int loadTry(Object ... items) {
        return this.ctx().entityLoadTry(this, items);
    }

    public T loadById(Object id, Object ... items) {
        return (T)this.ctx().entityLoadById(this.getClass(), id, items);
    }

    public T loadByIdTry(Object id, Object ... items) {
        return (T)this.ctx().entityLoadByIdTry(this.getClass(), id, items);
    }

    public T loadBySQL(Object ... items) {
        return this.ctx().entityLoadBySql(items);
    }

    public List<T> findAll(Object ... items) {
        return this.ctx().entityFind(this.getClass(), items);
    }

    public List<T> findBySQL(Object ... items) {
        return this.ctx().entityFindBySql(this.getClass(), items);
    }

    public List<T> findBySample(Object ... items) {
        return this.ctx().entityFindBySample(this, items);
    }

    public EntityNet autoNet(Class<?> ... entityClass) {
        return this.ctx().autoNet(entityClass);
    }

    public <E> E findRelatedOne(Object ... items) {
        Object[] newItems = ActiveRecord.insertThisClassIfNotHave(this, items);
        return this.ctx().entityFindRelatedOne(this, newItems);
    }

    public <E> List<E> findRelatedList(Object ... items) {
        Object[] newItems = ActiveRecord.insertThisClassIfNotHave(this, items);
        return this.ctx().entityFindRelatedList(this, newItems);
    }

    public <E> Set<E> findRelatedSet(Object ... items) {
        Object[] newItems = ActiveRecord.insertThisClassIfNotHave(this, items);
        return this.ctx().entityFindRelatedSet(this, newItems);
    }

    public <E> Map<Object, E> findRelatedMap(Object ... items) {
        Object[] newItems = ActiveRecord.insertThisClassIfNotHave(this, items);
        return this.ctx().entityFindRelatedMap(this, newItems);
    }
}

