/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdialects.ArrayUtils;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.ActiveRecord;
import com.github.drinkjava2.jsqlbox.DbContext;
import com.github.drinkjava2.jsqlbox.DbContextUtils;
import com.github.drinkjava2.jsqlbox.DbException;
import com.github.drinkjava2.jsqlbox.EntityType;
import com.github.drinkjava2.jsqlbox.entitynet.EntityNet;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ActiveEntity<T>
extends EntityType {
    default public void miscMethods__________________() {
    }

    default public DbContext ctx(Object ... optionItems) {
        for (Object item : optionItems) {
            if (item == null || !(item instanceof DbContext)) continue;
            return (DbContext)item;
        }
        DbException.assureNotNull(DbContext.getGlobalDbContext(), "No default global DbContext found, need use method DbContext.setGlobalDbContext() to set a global default DbContext instance at the beginning of appication.");
        return DbContext.getGlobalDbContext();
    }

    default public T putField(Object ... fieldAndValues) {
        for (int i = 0; i < fieldAndValues.length / 2; ++i) {
            String field = (String)fieldAndValues[i * 2];
            Object value = fieldAndValues[i * 2 + 1];
            Method writeMethod = ClassCacheUtils.getClassFieldWriteMethod(this.getClass(), field);
            try {
                writeMethod.invoke((Object)this, value);
                continue;
            }
            catch (Exception e) {
                throw new DbException(e);
            }
        }
        return (T)this;
    }

    default public T forFields(String ... fieldNames) {
        ActiveRecord.forFieldsOrTails.set(fieldNames);
        return (T)this;
    }

    default public T putValues(Object ... values) {
        String[] fields = ActiveRecord.forFieldsOrTails.get();
        if (values.length == 0 || fields == null || fields.length == 0) {
            throw new DbException("putValues fields or values can not be empty");
        }
        if (values.length != fields.length) {
            throw new DbException("putValues fields and values number not match");
        }
        for (int i = 0; i < fields.length; ++i) {
            Method writeMethod = ClassCacheUtils.getClassFieldWriteMethod(this.getClass(), fields[i]);
            if (writeMethod == null) {
                throw new DbException("Not found writeMethod for '" + this.getClass() + "' class's method '" + fields[i] + "'");
            }
            try {
                writeMethod.invoke((Object)this, values[i]);
                continue;
            }
            catch (Exception e) {
                throw new DbException(e);
            }
        }
        return (T)this;
    }

    default public SqlItem bind(Object ... parameters) {
        return new SqlItem(SqlOption.BIND, parameters);
    }

    default public String shardTB(Object ... optionItems) {
        TableModel model = DbContextUtils.findTableModel(this.getClass(), optionItems);
        ColumnModel col = model.getShardTableColumn();
        if (col == null || col.getShardTable() == null || col.getShardTable().length == 0) {
            throw new DbException("Not found ShardTable setting for '" + model.getEntityClass() + "'");
        }
        Object shardKey1 = DbContextUtils.readValueFromBeanFieldOrTail(col, this, false, false);
        return DbContextUtils.getShardedTB(this.ctx(new Object[0]), model.getEntityClass(), shardKey1);
    }

    default public DbContext shardDB(Object ... optionItems) {
        TableModel model = DbContextUtils.findTableModel(this.getClass(), optionItems);
        ColumnModel col = model.getShardDatabaseColumn();
        if (col == null || col.getShardDatabase() == null || col.getShardDatabase().length == 0) {
            throw new DbException("Not found ShardTable setting for '" + model.getEntityClass() + "'");
        }
        Object shardKey1 = DbContextUtils.readValueFromBeanFieldOrTail(col, this, false, false);
        return DbContextUtils.getShardedDB(this.ctx(new Object[0]), model.getEntityClass(), shardKey1);
    }

    default public Object[] shard(Object ... optionItems) {
        return new Object[]{this.shardTB(optionItems), this.shardDB(optionItems)};
    }

    public static Object[] insertThisClassIfNotHave(Object entity, Object ... optionItems) {
        Object[] items = optionItems;
        TableModel[] models = DbContextUtils.findAllModels(optionItems);
        if (models.length == 0) {
            throw new DbException("No TableMode found for entity.");
        }
        TableModel model = models[0];
        if (!entity.getClass().equals(model.getEntityClass())) {
            model = TableModelUtils.entity2ReadOnlyModel(entity.getClass());
            items = ArrayUtils.insertArray(model, items);
        }
        return items;
    }

    default public void crudMethods__________________() {
    }

    default public T insert(Object ... items) {
        return (T)this.ctx(items).entityInsert(this, items);
    }

    default public T update(Object ... items) {
        return this.ctx(items).entityUpdate(this, items);
    }

    default public int updateTry(Object ... items) {
        return this.ctx(items).entityUpdateTry(this, items);
    }

    default public void delete(Object ... items) {
        this.ctx(items).entityDelete(this, items);
    }

    default public int deleteTry(Object ... items) {
        return this.ctx(items).entityDeleteTry(this, items);
    }

    default public void deleteById(Object id, Object ... items) {
        this.ctx(items).entityDeleteById(this.getClass(), id, items);
    }

    default public int deleteByIdTry(Object id, Object ... items) {
        return this.ctx(items).entityDeleteByIdTry(this.getClass(), id, items);
    }

    default public boolean exist(Object ... items) {
        return this.ctx(items).entityExist(this, items);
    }

    default public boolean existById(Object id, Object ... items) {
        return this.ctx(items).entityExistById(this.getClass(), id, items);
    }

    default public int countAll(Object ... items) {
        return this.ctx(items).entityCount(this.getClass(), items);
    }

    default public T load(Object ... items) {
        return (T)this.ctx(items).entityLoad(this, items);
    }

    default public int loadTry(Object ... items) {
        return this.ctx(items).entityLoadTry(this, items);
    }

    default public T loadById(Object id, Object ... items) {
        return (T)this.ctx(items).entityLoadById(this.getClass(), id, items);
    }

    default public T loadByIdTry(Object id, Object ... items) {
        return (T)this.ctx(items).entityLoadByIdTry(this.getClass(), id, items);
    }

    default public T loadBySQL(Object ... items) {
        return this.ctx(items).entityLoadBySql(items);
    }

    default public List<T> findAll(Object ... items) {
        return this.ctx(items).entityFind(this.getClass(), items);
    }

    default public List<T> findBySQL(Object ... items) {
        return this.ctx(items).entityFindBySql(this.getClass(), items);
    }

    default public List<T> findBySample(Object sampleBean, Object ... items) {
        return this.ctx(items).entityFindBySample(sampleBean, items);
    }

    default public EntityNet autoNet(Class<?> ... entityClass) {
        return this.ctx(new Object[0]).autoNet(entityClass);
    }

    default public <E> E findRelatedOne(Object ... items) {
        Object[] newItems = ActiveEntity.insertThisClassIfNotHave(this, items);
        return this.ctx(items).entityFindRelatedOne(this, newItems);
    }

    default public <E> List<E> findRelatedList(Object ... items) {
        Object[] newItems = ActiveEntity.insertThisClassIfNotHave(this, items);
        return this.ctx(items).entityFindRelatedList(this, newItems);
    }

    default public <E> Set<E> findRelatedSet(Object ... items) {
        Object[] newItems = ActiveEntity.insertThisClassIfNotHave(this, items);
        return this.ctx(items).entityFindRelatedSet(this, newItems);
    }

    default public <E> Map<Object, E> findRelatedMap(Object ... items) {
        Object[] newItems = ActiveEntity.insertThisClassIfNotHave(this, items);
        return this.ctx(items).entityFindRelatedMap(this, newItems);
    }
}

