/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jbeanbox.ClassScanner;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class TableModelUtilsOfExcel {
    public static void entityPackage2Excel(String pkgName, String fileName) {
        List<Class> classes = ClassScanner.scanPackages(pkgName);
        Collections.sort(classes, new Comparator<Class>(){

            @Override
            public int compare(Class a, Class b) {
                if (a.getName().compareToIgnoreCase(b.getName()) > 0) {
                    return 1;
                }
                return -1;
            }
        });
        StringBuilder sb = new StringBuilder();
        for (Class claz : classes) {
            sb.append(TableModelUtilsOfExcel.model2CSVString(TableModelUtils.entity2Model(claz)));
            sb.append("\r\n");
        }
        TableModelUtilsOfExcel.writeToFile(fileName, sb);
    }

    public static void model2Excel(String fileName, TableModel ... models) {
        ArrayList<TableModel> tbList = new ArrayList<TableModel>();
        for (TableModel tb : models) {
            tbList.add(tb);
        }
        Collections.sort(tbList, new Comparator<TableModel>(){

            @Override
            public int compare(TableModel a, TableModel b) {
                if (a.getTableName().compareToIgnoreCase(b.getTableName()) > 0) {
                    return 1;
                }
                return -1;
            }
        });
        StringBuilder sb = new StringBuilder();
        for (TableModel tb : tbList) {
            sb.append(TableModelUtilsOfExcel.model2CSVString(tb));
            sb.append("\r\n");
        }
        TableModelUtilsOfExcel.writeToFile(fileName, sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(String fileName, StringBuilder sb) {
        BufferedWriter out = null;
        try {
            File writename = new File(fileName);
            writename.createNewFile();
            out = new BufferedWriter(new FileWriter(writename));
            out.write(sb.toString());
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String model2CSVString(TableModel t) {
        StringBuilder sb = new StringBuilder();
        Class<?> claz = t.getEntityClass();
        sb.append(claz == null ? "," : claz.getName() + ",");
        sb.append("Table,");
        sb.append("EntityField,");
        sb.append("EntityType,");
        sb.append("Pkey,");
        sb.append("Column,");
        sb.append("ColumnType,");
        sb.append("Definition,");
        sb.append("Length,");
        sb.append("Precision,");
        sb.append("Scale,");
        sb.append("Nullable,");
        sb.append("Check,");
        sb.append("Transient,");
        sb.append("Comment");
        sb.append("\r\n");
        for (ColumnModel c : t.getColumns()) {
            TableModelUtilsOfExcel.exportColInfo(sb, t, c, true);
        }
        for (ColumnModel c : t.getColumns()) {
            TableModelUtilsOfExcel.exportColInfo(sb, t, c, false);
        }
        sb.append("\r\n");
        return sb.toString();
    }

    private static void exportColInfo(StringBuilder sb, TableModel t, ColumnModel c, boolean isId) {
        if (isId && !c.getPkey().booleanValue()) {
            return;
        }
        if (!isId && c.getPkey().booleanValue()) {
            return;
        }
        sb.append(" ,");
        sb.append(t.getTableName() + ",");
        sb.append(c.getEntityField() == null ? "," : c.getEntityField() + ",");
        if (StrUtils.isEmpty(c.getEntityField())) {
            sb.append(",");
        } else {
            try {
                Method m = ClassCacheUtils.getClassFieldReadMethod(t.getEntityClass(), c.getEntityField());
                sb.append(m.getReturnType().getSimpleName() + ",");
            }
            catch (Exception e) {
                sb.append(",");
            }
        }
        sb.append(Boolean.TRUE.equals(c.getPkey()) ? "* ," : " ,");
        sb.append(c.getColumnName() + ",");
        sb.append(c.getColumnType() == null ? "," : (Object)((Object)c.getColumnType()) + ",");
        sb.append(TableModelUtilsOfExcel.transExcelCellStr(c.getColumnDefinition()) + ",");
        sb.append(c.getLength() + ",");
        sb.append(c.getPrecision() + ",");
        sb.append(c.getScale() + ",");
        sb.append(Boolean.TRUE.equals(c.getNullable()) ? "Y," : " ,");
        sb.append(c.getCheck() == null ? "," : c.getCheck() + " ,");
        sb.append(Boolean.TRUE.equals(c.getTransientable()) ? "T," : " ,");
        sb.append(TableModelUtilsOfExcel.transExcelCellStr(c.getComment()));
        sb.append("\r\n");
    }

    private static String transExcelCellStr(String colDef) {
        if (colDef == null) {
            colDef = "";
        }
        if (colDef.indexOf("\"") != -1 || colDef.indexOf(",") != -1) {
            colDef = colDef.replaceAll("\"", "\"\"");
            colDef = "\"" + colDef;
            colDef = colDef + "\"";
        }
        return colDef;
    }
}

