/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.DDLCreateUtils;
import com.github.drinkjava2.jdialects.DDLFeatures;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;
import com.github.drinkjava2.jdialects.id.AutoIdGenerator;
import com.github.drinkjava2.jdialects.id.IdGenerator;
import com.github.drinkjava2.jdialects.id.SequenceIdGenerator;
import com.github.drinkjava2.jdialects.id.TableIdGenerator;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyModel;
import com.github.drinkjava2.jdialects.model.IndexModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jdialects.model.UniqueModel;
import com.github.drinkjava2.jlogs.Log;
import com.github.drinkjava2.jlogs.LogFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DDLDropUtils {
    private static final Log logger = LogFactory.getLog(DDLDropUtils.class);

    public static String[] toDropDDL(Dialect dialect, TableModel ... tables) {
        ArrayList<Object> objectResultList = new ArrayList<Object>();
        for (TableModel table : tables) {
            DDLDropUtils.transferTableToObjectList(dialect, table, objectResultList);
        }
        boolean hasAutoIdGenerator = false;
        block1: for (TableModel table : tables) {
            for (ColumnModel column : table.getColumns()) {
                if (!GenerationType.AUTO.equals((Object)column.getIdGenerationType())) continue;
                hasAutoIdGenerator = true;
                break;
            }
            for (IdGenerator idGens : table.getIdGenerators()) {
                if (!hasAutoIdGenerator && !idGens.dependOnAutoIdGenerator().booleanValue()) continue;
                hasAutoIdGenerator = true;
                continue block1;
            }
        }
        ArrayList<String> stringResultList = new ArrayList<String>();
        ArrayList<TableIdGenerator> tbGeneratorList = new ArrayList<TableIdGenerator>();
        ArrayList<SequenceIdGenerator> sequenceList = new ArrayList<SequenceIdGenerator>();
        ArrayList<FKeyModel> fKeyConstraintList = new ArrayList<FKeyModel>();
        for (Object strOrObj : objectResultList) {
            if (StrUtils.isEmpty(strOrObj)) continue;
            if (strOrObj instanceof String) {
                stringResultList.add((String)strOrObj);
                continue;
            }
            if (strOrObj instanceof TableIdGenerator) {
                tbGeneratorList.add((TableIdGenerator)strOrObj);
                continue;
            }
            if (strOrObj instanceof SequenceIdGenerator) {
                sequenceList.add((SequenceIdGenerator)strOrObj);
                continue;
            }
            if (!(strOrObj instanceof FKeyModel)) continue;
            fKeyConstraintList.add((FKeyModel)strOrObj);
        }
        if (hasAutoIdGenerator) {
            IdGenerator realIdGen = AutoIdGenerator.INSTANCE.getSequenceOrTableIdGenerator(dialect);
            if (realIdGen instanceof TableIdGenerator) {
                tbGeneratorList.add((TableIdGenerator)realIdGen);
            } else if (realIdGen instanceof SequenceIdGenerator) {
                sequenceList.add((SequenceIdGenerator)realIdGen);
            } else {
                throw new DialectException("Unknow exception happen for realIdGen, please report this bug");
            }
        }
        DDLDropUtils.buildDropSequenceDDL(dialect, stringResultList, sequenceList);
        DDLDropUtils.buildDropTableGeneratorDDL(dialect, stringResultList, tbGeneratorList);
        DDLDropUtils.outputDropFKeyConstraintDDL(dialect, stringResultList, fKeyConstraintList);
        Object[] result = stringResultList.toArray(new String[stringResultList.size()]);
        if (Dialect.getGlobalAllowShowSql().booleanValue()) {
            logger.info("Drop DDL:\r" + StrUtils.arrayToString(result, "\r"));
        }
        return result;
    }

    private static void transferTableToObjectList(Dialect dialect, TableModel t, List<Object> objectResultList) {
        List<FKeyModel> list;
        List<UniqueModel> l2;
        StringBuilder buf = new StringBuilder();
        String tableName = t.getTableName();
        List<ColumnModel> columns = t.getColumns();
        dialect.checkNotEmptyReservedWords(tableName, "Table name", tableName);
        List<IndexModel> l = t.getIndexConsts();
        if (l != null && !l.isEmpty()) {
            for (IndexModel indexModel : l) {
                dialect.checkReservedWords(indexModel.getName());
            }
        }
        if ((l2 = t.getUniqueConsts()) != null && !l2.isEmpty()) {
            for (UniqueModel unique : l2) {
                dialect.checkReservedWords(unique.getName());
            }
        }
        if ((list = t.getFkeyConstraints()) != null && !list.isEmpty()) {
            for (FKeyModel fkey : list) {
                dialect.checkReservedWords(fkey.getFkeyName());
            }
        }
        for (ColumnModel col : columns) {
            if (col.getTransientable().booleanValue()) continue;
            dialect.checkNotEmptyReservedWords(col.getColumnName(), "Column name", tableName);
        }
        for (IdGenerator idGen : t.getIdGenerators()) {
            objectResultList.add(idGen);
        }
        for (FKeyModel fkey : t.getFkeyConstraints()) {
            objectResultList.add(fkey);
        }
        buf.append(dialect.dropTableDDL(tableName));
        objectResultList.add(buf.toString());
    }

    private static void buildDropSequenceDDL(Dialect dialect, List<String> stringResultList, List<SequenceIdGenerator> sequenceList) {
        HashSet<SequenceIdGenerator> notRepeatedSequences = new HashSet<SequenceIdGenerator>();
        for (SequenceIdGenerator seq : sequenceList) {
            DDLCreateUtils.checkAndInsertToNotRepeatSeq(notRepeatedSequences, seq);
        }
        DDLFeatures features = dialect.ddlFeatures;
        for (SequenceIdGenerator seq : notRepeatedSequences) {
            if (!features.supportBasicOrPooledSequence()) {
                DialectException.throwEX("Dialect \"" + dialect + "\" does not support sequence setting on sequence \"" + seq.getName() + "\"");
            }
            if (!"NOT_SUPPORT".equals(features.dropSequenceStrings) && !StrUtils.isEmpty(features.dropSequenceStrings)) {
                stringResultList.add(0, StrUtils.replace(features.dropSequenceStrings, "_SEQNAME", seq.getSequenceName()));
                continue;
            }
            DialectException.throwEX("Dialect \"" + dialect + "\" does not support drop sequence ddl, on sequence \"" + seq.getName() + "\"");
        }
    }

    private static void buildDropTableGeneratorDDL(Dialect dialect, List<String> stringResultList, List<TableIdGenerator> tbGeneratorList) {
        for (TableIdGenerator tg : tbGeneratorList) {
            DialectException.assureNotEmpty(tg.getName(), "TableGen name can not be empty");
            DialectException.assureNotEmpty(tg.getTable(), "TableGen tableName can not be empty of \"" + tg.getName() + "\"");
            DialectException.assureNotEmpty(tg.getPkColumnName(), "TableGen pkColumnName can not be empty of \"" + tg.getName() + "\"");
            DialectException.assureNotEmpty(tg.getPkColumnValue(), "TableGen pkColumnValue can not be empty of \"" + tg.getName() + "\"");
            DialectException.assureNotEmpty(tg.getValueColumnName(), "TableGen valueColumnName can not be empty of \"" + tg.getName() + "\"");
        }
        HashSet<String> tableExisted = new HashSet<String>();
        for (TableIdGenerator tg : tbGeneratorList) {
            String tableName = tg.getTable().toLowerCase();
            if (tableExisted.contains(tableName)) continue;
            stringResultList.add(0, dialect.dropTableDDL(tableName));
            tableExisted.add(tableName);
        }
    }

    private static void outputDropFKeyConstraintDDL(Dialect dialect, List<String> stringResultList, List<FKeyModel> trueList) {
        if ("NOT_SUPPORT".equals(dialect.ddlFeatures.addForeignKeyConstraintString)) {
            return;
        }
        for (FKeyModel t : trueList) {
            if (!t.getDdl().booleanValue()) continue;
            String dropStr = dialect.ddlFeatures.dropForeignKeyString;
            String constName = t.getFkeyName();
            if (StrUtils.isEmpty(constName)) {
                constName = "fk_" + t.getTableName().toLowerCase() + "_" + StrUtils.replace(StrUtils.listToString(t.getColumnNames()), ",", "_");
            }
            constName = StrUtils.clearQuote(constName);
            if ("NOT_SUPPORT".equals(dropStr)) {
                DialectException.throwEX("Dialect \"" + dialect + "\" does not support drop foreign key, for setting: \"fk_" + constName + "\"");
            }
            stringResultList.add(0, "alter table " + t.getTableName() + " " + dropStr + " " + constName);
        }
    }
}

