/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro.template;

import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.template.SqlTemplateEngine;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;

public class BasicSqlTemplate
implements SqlTemplateEngine {
    protected Boolean dollarKeyForDollarPlaceHolder = false;
    private boolean allowColonAsDelimiter = true;
    private String startDelimiter = "#{";
    private String endDelimiter = "}";
    private static final String DIRECT_REPLACE_START_DELIMITER = "${";
    private static final String DIRECT_REPLACE_END_DELIMITER = "}";

    public static BasicSqlTemplate instance() {
        return InnerBasicSqlTemplate.INSTANCE;
    }

    public BasicSqlTemplate() {
    }

    public BasicSqlTemplate(String startDelimiter, String endDelimiter, Boolean allowColonAsDelimiter, Boolean dollarKeyForDollarPlaceHolder) {
        if (BasicSqlTemplate.isEmpty(startDelimiter) || BasicSqlTemplate.isEmpty(endDelimiter) || startDelimiter.length() > 2 || endDelimiter.length() != 1) {
            throw new BasicSqlTemplateException("BasicSqlTemplate only support startDelimiter has 1 or 2 characters and endDelimiter has 1 character");
        }
        this.startDelimiter = startDelimiter;
        this.endDelimiter = endDelimiter;
        this.allowColonAsDelimiter = allowColonAsDelimiter;
        this.dollarKeyForDollarPlaceHolder = dollarKeyForDollarPlaceHolder;
    }

    private static boolean isParamChars(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '_' || c == '.';
    }

    @Override
    public PreparedSQL render(String sqlTemplate, Map<String, Object> paramMap, Object[] unbindParams) {
        if (paramMap == null) {
            throw new BasicSqlTemplateException("In BasicSqlTemplate, paramMap can not be null");
        }
        if (!paramMap.isEmpty() && unbindParams != null && unbindParams.length > 0) {
            throw new BasicSqlTemplateException("Can not use paramMap or unbindParams at same time in BasicSqlTemplate.");
        }
        String newSql = sqlTemplate;
        if (this.allowColonAsDelimiter) {
            newSql = this.translateColonToDelimiter(sqlTemplate);
        }
        return this.doRender(newSql, paramMap, unbindParams);
    }

    private PreparedSQL doRender(String template, Map<String, Object> paramMap, Object[] unbindParams) {
        boolean unbindMode;
        if (template == null) {
            throw new NullPointerException("Template can not be null");
        }
        int unbindParamPos = 0;
        ArrayList<Object> realUnbindParam = null;
        boolean bl = unbindMode = unbindParams != null && unbindParams.length > 0;
        if (unbindMode) {
            realUnbindParam = new ArrayList<Object>();
        }
        StringBuilder sql = new StringBuilder();
        StringBuilder keyNameSB = new StringBuilder();
        ArrayList<Object> paramList = new ArrayList<Object>();
        char[] chars = ("   " + template + "   ").toCharArray();
        int lg = this.startDelimiter.length();
        char start1 = this.startDelimiter.charAt(0);
        char start2 = '\u0000';
        if (lg == 2) {
            start2 = this.startDelimiter.charAt(1);
        }
        char e = this.endDelimiter.charAt(0);
        int drlg = DIRECT_REPLACE_START_DELIMITER.length();
        char drst1 = DIRECT_REPLACE_START_DELIMITER.charAt(0);
        char drst2 = '\u0000';
        if (drlg == 2) {
            drst2 = DIRECT_REPLACE_START_DELIMITER.charAt(1);
        }
        char eDirect = DIRECT_REPLACE_END_DELIMITER.charAt(0);
        int status = 0;
        boolean directRep = false;
        for (int i = 3; i < chars.length - 2; ++i) {
            char c = chars[i];
            char c1 = chars[i + 1];
            char cm1 = chars[i - 1];
            char cm2 = chars[i - 2];
            if (status == 0 && (lg == 1 && c == start1 || lg == 2 && c == start1 && c1 == start2)) {
                status = 1;
                keyNameSB.setLength(0);
                directRep = false;
            } else if (status == 0 && (drlg == 1 && c == drst1 || drlg == 2 && c == drst1 && c1 == drst2)) {
                status = 1;
                keyNameSB.setLength(0);
                directRep = true;
            } else if (status == 1 && (lg == 1 && cm1 == start1 || lg == 2 && cm2 == start1 && cm1 == start2)) {
                status = 2;
            } else if (status == 1 && (drlg == 1 && cm1 == drst1 || drlg == 2 && cm2 == drst1 && cm1 == drst2)) {
                status = 2;
            } else if (status == 3 && (cm1 == e && !directRep || cm1 == eDirect && directRep)) {
                status = 0;
            } else if (status == 2 && (c == e && !directRep || c == eDirect && directRep)) {
                String key;
                status = 3;
                if (keyNameSB.length() == 0) {
                    BasicSqlTemplate.throwEX("Empty parameter name '" + this.startDelimiter + this.endDelimiter + "' found in template: " + template, new Exception[0]);
                }
                if ((key = keyNameSB.toString()).indexOf(46) >= 0) {
                    String beanName = BasicSqlTemplate.substringBefore(key, ".");
                    String propertyName = BasicSqlTemplate.substringAfter(key, ".");
                    if (BasicSqlTemplate.isEmpty(beanName) || BasicSqlTemplate.isEmpty(propertyName)) {
                        BasicSqlTemplate.throwEX("illegal parameter name '" + key + "' found in template: " + template, new Exception[0]);
                    }
                    String paramKey = directRep && this.dollarKeyForDollarPlaceHolder != false ? "$" + beanName : beanName;
                    boolean hasValue = paramMap.containsKey(paramKey);
                    if (unbindMode) {
                        if (directRep) {
                            sql.append(unbindParams[unbindParamPos++]);
                        } else {
                            sql.append("?");
                            realUnbindParam.add(unbindParams[unbindParamPos++]);
                        }
                    } else {
                        if (!hasValue) {
                            BasicSqlTemplate.throwEX("Not found bean '" + paramKey + "' when render template: " + template, new Exception[0]);
                        }
                        Object bean = paramMap.get(paramKey);
                        PropertyDescriptor pd = null;
                        try {
                            pd = new PropertyDescriptor(propertyName, bean.getClass());
                        }
                        catch (IntrospectionException e1) {
                            BasicSqlTemplate.throwEX("IntrospectionException happen when get bean property '" + key + "' in template: " + template, e1);
                        }
                        Method method = pd.getReadMethod();
                        Object beanProperty = null;
                        try {
                            beanProperty = method.invoke(bean, new Object[0]);
                        }
                        catch (Exception e1) {
                            BasicSqlTemplate.throwEX("Exception happen when read bean property '" + key + "' in template: " + template, e1);
                        }
                        if (directRep) {
                            sql.append(beanProperty);
                        } else {
                            sql.append("?");
                            paramList.add(beanProperty);
                        }
                    }
                } else if (unbindMode) {
                    if (directRep) {
                        sql.append(unbindParams[unbindParamPos++]);
                    } else {
                        sql.append("?");
                        realUnbindParam.add(unbindParams[unbindParamPos++]);
                    }
                } else {
                    String paramKey;
                    String string = paramKey = directRep && this.dollarKeyForDollarPlaceHolder != false ? "$" + key : key;
                    if (!paramMap.containsKey(paramKey)) {
                        BasicSqlTemplate.throwEX("No parameter bind for '" + paramKey + "' in template: " + template, new Exception[0]);
                    }
                    if (directRep) {
                        sql.append(paramMap.get(paramKey));
                    } else {
                        sql.append("?");
                        paramList.add(paramMap.get(paramKey));
                    }
                }
                keyNameSB.setLength(0);
            }
            if (status == 0) {
                sql.append(c);
                continue;
            }
            if (status != 2) continue;
            keyNameSB.append(c);
        }
        if (status != 0) {
            BasicSqlTemplate.throwEX("Missing end delimiter '" + this.endDelimiter + "' in template: " + template, new Exception[0]);
        }
        PreparedSQL sp = new PreparedSQL();
        sql.setLength(sql.length() - 1);
        sp.setSql(sql.toString());
        if (unbindMode) {
            sp.setParams(realUnbindParam.toArray(new Object[realUnbindParam.size()]));
        } else {
            sp.setParams(paramList.toArray());
        }
        return sp;
    }

    private String translateColonToDelimiter(String sql) {
        StringBuilder sb = new StringBuilder();
        boolean status = false;
        for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (!status && c != ':') {
                sb.append(c);
                continue;
            }
            if (!status && c == ':') {
                sb.append(this.startDelimiter);
                status = true;
                continue;
            }
            if (status && BasicSqlTemplate.isParamChars(c)) {
                sb.append(c);
                continue;
            }
            sb.append(this.endDelimiter).append(c);
            status = false;
        }
        if (status) {
            sb.append(this.endDelimiter);
        }
        return sb.toString();
    }

    private static void throwEX(String message, Exception ... cause) {
        if (cause != null && cause.length > 0) {
            throw new BasicSqlTemplateException(message, cause[0]);
        }
        throw new BasicSqlTemplateException(message);
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static String substringBefore(String str, String separator) {
        if (BasicSqlTemplate.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.isEmpty()) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfter(String str, String separator) {
        if (BasicSqlTemplate.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static class BasicSqlTemplateException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public BasicSqlTemplateException(String msg) {
            super(msg);
        }

        public BasicSqlTemplateException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    private static class InnerBasicSqlTemplate {
        private static final BasicSqlTemplate INSTANCE = new BasicSqlTemplate();

        private InnerBasicSqlTemplate() {
        }
    }
}

