/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro.handler;

import com.github.drinkjava2.jdbpro.DefaultOrderSqlHandler;
import com.github.drinkjava2.jdbpro.ImprovedQueryRunner;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdialects.StrUtils;
import java.util.Arrays;

public class PrintSqlHandler
extends DefaultOrderSqlHandler {
    private static boolean allowPrint = true;

    public static boolean isAllowPrint() {
        return allowPrint;
    }

    public static void setAllowPrint(boolean allowPrint) {
        PrintSqlHandler.allowPrint = allowPrint;
    }

    @Override
    public Object handle(ImprovedQueryRunner runner, PreparedSQL ps) {
        StringBuffer sb = new StringBuffer();
        sb.append("======PrintSqlHandler=========\n");
        sb.append("| SQL:       " + ps.getSql()).append("\n");
        sb.append("| Param:     " + Arrays.deepToString(ps.getParams())).append("\n");
        if (ps.getParams() != null && ps.getParams().length > 0) {
            sb.append("| FullSQL:   ");
            String s = ps.getSql();
            for (int i = 0; i < 1000 && s.contains("?"); ++i) {
                Object o = ps.getParams()[i];
                s = o == null || o instanceof Number ? StrUtils.replaceFirst(s, "?", "" + o) : StrUtils.replaceFirst(s, "?", "'" + o + "'");
            }
            sb.append(s).append("\n");
        }
        if (allowPrint) {
            System.out.print(sb.toString());
        }
        sb.setLength(0);
        long start = System.currentTimeMillis();
        Object obj = runner.runPreparedSQL(ps);
        long end = System.currentTimeMillis();
        sb.append("| TimeUsed:  " + (end - start) + "ms\n");
        if (runner.getName() != null && runner.getName().length() > 0) {
            sb.append("| DB:        " + runner.getName()).append("\n");
        }
        sb.append("==============================");
        if (allowPrint) {
            System.out.println(sb.toString());
        }
        return obj;
    }
}

