/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro;

import com.github.drinkjava2.jdbpro.DbPro;
import com.github.drinkjava2.jdbpro.DbProException;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.SqlHandler;
import com.github.drinkjava2.jdbpro.SqlItemHandler;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdbpro.TenantGetter;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.converter.BasicJavaToJdbcConverter;
import com.github.drinkjava2.jdialects.converter.BasicJdbcToJavaConverter;
import com.github.drinkjava2.jdialects.converter.JavaToJdbcConverter;
import com.github.drinkjava2.jdialects.converter.JdbcToJavaConverter;
import com.github.drinkjava2.jlogs.Log;
import com.github.drinkjava2.jlogs.LogFactory;
import com.github.drinkjava2.jsqlbox.DbException;
import com.github.drinkjava2.jsqlbox.TxBody;
import com.github.drinkjava2.jtransactions.ConnectionManager;
import com.github.drinkjava2.jtransactions.DataSourceHolder;
import com.github.drinkjava2.jtransactions.TxResult;
import com.github.drinkjava2.jtransactions.tinytx.TinyTxConnectionManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.StatementConfiguration;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class ImprovedQueryRunner
extends QueryRunner
implements DataSourceHolder {
    protected static final Log logger = LogFactory.getLog(ImprovedQueryRunner.class);
    protected static Dialect globalNextDialect = null;
    protected static Boolean globalNextAllowShowSql = false;
    protected static SqlOption globalNextMasterSlaveOption = SqlOption.USE_AUTO;
    protected static ConnectionManager globalNextConnectionManager = TinyTxConnectionManager.instance();
    protected static JavaToJdbcConverter globalNextJavaToJdbcConverter = BasicJavaToJdbcConverter.instance;
    protected static JdbcToJavaConverter globalNextJdbcToJavaConverter = BasicJdbcToJavaConverter.instance;
    protected static TenantGetter globalNextTenantGetter = null;
    protected static SqlItemHandler globalNextSqlItemHandler = null;
    protected static Integer globalNextBatchSize = 300;
    protected static SqlHandler[] globalNextSqlHandlers = null;
    protected ConnectionManager connectionManager = globalNextConnectionManager;
    protected Boolean allowShowSQL = globalNextAllowShowSql;
    protected SqlOption masterSlaveOption = globalNextMasterSlaveOption;
    protected Integer batchSize = globalNextBatchSize;
    protected SqlHandler[] sqlHandlers = globalNextSqlHandlers;
    protected Dialect dialect = globalNextDialect;
    protected JavaToJdbcConverter javaToJdbcConverter = globalNextJavaToJdbcConverter;
    protected JdbcToJavaConverter jdbcToJavaConverter = globalNextJdbcToJavaConverter;
    protected TenantGetter tenantGetter = globalNextTenantGetter;
    protected SqlItemHandler sqlItemHandler = globalNextSqlItemHandler;
    protected DbPro[] slaves;
    protected DbPro[] masters;
    protected String name;
    protected Integer dbCode = 0;
    private static ThreadLocal<TxResult> lastTxResult = new ThreadLocal();
    private static ThreadLocal<SqlHandler[]> threadLocalSqlHandlers = new ThreadLocal();
    protected ThreadLocal<Integer> threadLocalForceCommitFail = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private ThreadLocal<Boolean> batchEnabled = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private ThreadLocal<ArrayList<PreparedSQL>> sqlBatchCache = new ThreadLocal<ArrayList<PreparedSQL>>(){

        @Override
        protected ArrayList<PreparedSQL> initialValue() {
            return new ArrayList<PreparedSQL>();
        }
    };
    private ThreadLocal<List<Object[]>> others = new ThreadLocal();

    public ImprovedQueryRunner() {
        this.dialect = globalNextDialect;
        this.pmdKnownBroken = true;
    }

    public ImprovedQueryRunner(DataSource ds) {
        super(ds);
        this.dialect = globalNextDialect != null ? globalNextDialect : Dialect.guessDialect(ds);
        this.pmdKnownBroken = true;
    }

    public ImprovedQueryRunner(DataSource ds, Dialect dialect) {
        super(ds);
        this.dialect = dialect;
        this.pmdKnownBroken = true;
    }

    public ImprovedQueryRunner(DataSource ds, StatementConfiguration stmtConfig) {
        super(ds, stmtConfig);
        this.dialect = globalNextDialect != null ? globalNextDialect : Dialect.guessDialect(ds);
        this.pmdKnownBroken = true;
    }

    public ImprovedQueryRunner(DataSource ds, Dialect dialect, StatementConfiguration stmtConfig) {
        super(ds, stmtConfig);
        this.dialect = dialect;
        this.pmdKnownBroken = true;
    }

    @Override
    public Object getHolder() {
        return this;
    }

    @Override
    public void close(Connection conn) throws SQLException {
        if (this.connectionManager == null) {
            super.close(conn);
        } else {
            this.connectionManager.releaseConnection(conn, this.getDataSource());
        }
    }

    @Override
    public Connection prepareConnection() throws SQLException {
        if (this.connectionManager == null) {
            return super.prepareConnection();
        }
        return this.connectionManager.getConnection(this);
    }

    protected String formatSqlForLoggerOutput(String sql) {
        return (this.name == null ? "" : this.name) + (this.dbCode <= 0 ? "" : this.dbCode + " ") + "SQL: " + sql;
    }

    protected String formatParametersForLoggerOutput(Object ... params) {
        return (this.name == null ? "" : this.name) + (this.dbCode <= 0 ? "" : this.dbCode + " ") + "PAR: " + Arrays.deepToString(params);
    }

    private <T> T addToCacheIfFullFlush(PreparedSQL ps) {
        PreparedSQL last;
        if (ps == null) {
            throw new DbProException("PreparedSQL can not be null.");
        }
        Integer result = null;
        List cached = this.sqlBatchCache.get();
        if (cached.size() >= this.batchSize) {
            result = (Integer)this.nBatchFlush();
        } else if (!(cached.isEmpty() || (last = (PreparedSQL)cached.get(cached.size() - 1)).getOperationType().equals((Object)ps.getOperationType()) && last.getConnection() == ps.getConnection() && last.getSql().equals(ps.getSql()) && last.getParamSize() == ps.getParamSize() && last.getResultSetHandler() == ps.getResultSetHandler())) {
            result = this.nBatchFlush();
        }
        this.sqlBatchCache.get().add(ps);
        switch (ps.getOperationType()) {
            case UPDATE: 
            case EXECUTE: {
                result = 0;
                break;
            }
            case INSERT: {
                result = null;
                break;
            }
            default: {
                throw new DbProException("Unknow batch sql operation type:" + (Object)((Object)ps.getOperationType()));
            }
        }
        return (T)result;
    }

    public <T> T nBatchFlush() {
        List psList = this.sqlBatchCache.get();
        if (psList.isEmpty()) {
            return null;
        }
        Integer result = null;
        PreparedSQL first = (PreparedSQL)psList.get(0);
        int paramLenth = first.getParamSize();
        Object[][] allParams = new Object[psList.size()][paramLenth];
        if (paramLenth > 0) {
            for (int i = 0; i < psList.size(); ++i) {
                allParams[i] = ((PreparedSQL)psList.get(i)).getParams();
            }
        }
        if (this.getAllowShowSQL().booleanValue()) {
            logger.info("Batch execute " + psList.size() + " SQLs");
            logger.info(this.formatSqlForLoggerOutput(first.getSql()));
            logger.info("First row " + this.formatParametersForLoggerOutput(allParams[0]));
            logger.info("Last row " + this.formatParametersForLoggerOutput(allParams[allParams.length - 1]));
        }
        if (this.batchEnabled.get().booleanValue()) {
            switch (first.getOperationType()) {
                case UPDATE: 
                case EXECUTE: {
                    try {
                        if (first.getConnection() != null) {
                            result = this.batch(first.getConnection(), first.getSql(), allParams).length;
                            break;
                        }
                        result = this.batch(first.getSql(), allParams).length;
                        break;
                    }
                    catch (SQLException e) {
                        throw new DbProException(e);
                    }
                }
                case INSERT: {
                    if (first.getResultSetHandler() == null) {
                        throw new DbProException("insertBatch need a ResultSetHandler.");
                    }
                    try {
                        if (first.getConnection() != null) {
                            result = this.insertBatch(first.getConnection(), first.getSql(), first.getResultSetHandler(), allParams);
                            break;
                        }
                        result = this.insertBatch(first.getSql(), first.getResultSetHandler(), allParams);
                        break;
                    }
                    catch (SQLException e) {
                        throw new DbProException(e);
                    }
                }
                default: {
                    throw new DbProException("Unknow batch sql operation type:" + (Object)((Object)first.getOperationType()));
                }
            }
        }
        this.sqlBatchCache.get().clear();
        return (T)result;
    }

    public void nBatchBegin() {
        if (!this.sqlBatchCache.get().isEmpty()) {
            this.nBatchFlush();
        }
        this.batchEnabled.set(true);
    }

    public void nBatchEnd() {
        try {
            if (!this.sqlBatchCache.get().isEmpty()) {
                this.nBatchFlush();
            }
        }
        finally {
            this.batchEnabled.set(false);
        }
    }

    public <T> T queryForObject(Connection conn, String sql, Object ... params) throws SQLException {
        return this.query(conn, sql, new ScalarHandler(1), params);
    }

    public long queryForLongValue(Connection conn, String sql, Object ... params) throws SQLException {
        return ((Number)this.queryForObject(conn, sql, params)).longValue();
    }

    public int queryForIntValue(Connection conn, String sql, Object ... params) throws SQLException {
        return ((Number)this.queryForObject(conn, sql, params)).intValue();
    }

    public <T> T queryForObject(String sql, Object ... params) throws SQLException {
        return this.query(sql, new ScalarHandler(1), params);
    }

    public long queryForLongValue(String sql, Object ... params) throws SQLException {
        return ((Number)this.queryForObject(sql, params)).longValue();
    }

    public int queryForIntValue(String sql, Object ... params) throws SQLException {
        return ((Number)this.queryForObject(sql, params)).intValue();
    }

    public Object runPreparedSQL(PreparedSQL ps) {
        if (this.tenantGetter != null) {
            ImprovedQueryRunner runner = this.tenantGetter.getTenant();
            if (runner == null) {
                throw new DbException("tenantGetter can not return a null Object");
            }
            return runner.runPreparedSQL(ps);
        }
        if (ps.getSwitchTo() != null) {
            DbPro pro = ps.getSwitchTo();
            ps.setSwitchTo(null);
            return pro.runPreparedSQL(ps);
        }
        if (ps.getParams().length > 0) {
            for (int i = 0; i < ps.getParams().length; ++i) {
                ps.getParams()[i] = this.javaToJdbcConverter.convert(ps.getParams()[i]);
            }
        }
        if (ps.getMasterSlaveOption() == null) {
            ps.setMasterSlaveOption(this.getMasterSlaveOption());
        }
        if (ps.getTemplateEngine() != null) {
            PreparedSQL rendered = ps.getTemplateEngine().render(ps.getSql(), ps.getTemplateParamMap(), ps.getParams());
            ps.setSql(rendered.getSql());
            ps.setParams(rendered.getParams());
            ps.setTemplateEngine(null);
        }
        while (ps.getSqlHandlers() != null && !ps.getSqlHandlers().isEmpty()) {
            SqlHandler handler = ps.getSqlHandlers().get(0);
            ps.getSqlHandlers().remove(0);
            if (ps.isDisabledHandler(handler)) continue;
            return this.jdbcToJavaConverter.convert(handler.handle(this, ps));
        }
        this.others.remove();
        if (ps.getOthers() != null) {
            this.others.set(ps.getOthers());
        }
        return this.jdbcToJavaConverter.convert(this.runRealSqlMethod(ps));
    }

    public Object runRealSqlMethod(PreparedSQL ps) {
        if (ps.getOperationType() == null) {
            throw new DbProException("PreparedSQL's type not set");
        }
        if (this.getAllowShowSQL().booleanValue() && !this.batchEnabled.get().booleanValue()) {
            logger.info(this.formatSqlForLoggerOutput(ps.getSql()));
            logger.info(this.formatParametersForLoggerOutput(ps.getParams()));
        }
        if (this.batchEnabled.get().booleanValue()) {
            switch (ps.getOperationType()) {
                case UPDATE: 
                case EXECUTE: 
                case INSERT: {
                    return this.addToCacheIfFullFlush(ps);
                }
            }
        }
        switch (ps.getOperationType()) {
            case UPDATE: 
            case EXECUTE: 
            case INSERT: {
                if (SqlOption.USE_MASTER.equals((Object)ps.getMasterSlaveOption()) || SqlOption.USE_AUTO.equals((Object)ps.getMasterSlaveOption())) {
                    return this.runWriteOperations(this, ps);
                }
                if (SqlOption.USE_BOTH.equals((Object)ps.getMasterSlaveOption())) {
                    if (this.getSlaves() != null) {
                        for (DbPro dbPro : this.getSlaves()) {
                            this.runWriteOperations(dbPro, ps);
                        }
                    }
                    return this.runWriteOperations(this, ps);
                }
                if (SqlOption.USE_SLAVE.equals((Object)ps.getMasterSlaveOption())) {
                    Object result = null;
                    if (this.getSlaves() == null || this.getSlaves().length == 0) {
                        throw new DbProException("Try to write slaves but slave list not found");
                    }
                    for (DbPro dbPro : this.getSlaves()) {
                        result = this.runWriteOperations(dbPro, ps);
                    }
                    return result;
                }
                throw new DbProException("Should never run to here");
            }
            case QUERY: {
                if (SqlOption.USE_MASTER.equals((Object)ps.getMasterSlaveOption()) || SqlOption.USE_BOTH.equals((Object)ps.getMasterSlaveOption())) {
                    return this.runQuery(ps);
                }
                if (SqlOption.USE_SLAVE.equals((Object)ps.getMasterSlaveOption())) {
                    DbPro db = this.chooseOneSlave();
                    if (db == null) {
                        throw new DbProException("Try to query on slave but slave list not found");
                    }
                    return db.runQuery(ps);
                }
                if (SqlOption.USE_AUTO.equals((Object)ps.getMasterSlaveOption())) {
                    DbPro db = this.autoChooseMasterOrSlaveQuery(ps);
                    return db.runQuery(ps);
                }
                throw new DbProException("Should never run to here");
            }
        }
        throw new DbProException("Unknow SQL operation type " + (Object)((Object)ps.getOperationType()));
    }

    private Object runReadOperation(PreparedSQL ps) {
        if (SqlOption.USE_MASTER.equals((Object)ps.getMasterSlaveOption()) || SqlOption.USE_BOTH.equals((Object)ps.getMasterSlaveOption())) {
            return this.runQuery(ps);
        }
        if (SqlOption.USE_SLAVE.equals((Object)ps.getMasterSlaveOption())) {
            DbPro db = this.chooseOneSlave();
            if (db == null) {
                throw new DbProException("Try to run a slave DbPro but slave list is null or empty");
            }
            return db.runQuery(ps);
        }
        if (SqlOption.USE_AUTO.equals((Object)ps.getMasterSlaveOption())) {
            DbPro db = this.autoChooseMasterOrSlaveQuery(ps);
            return db.runQuery(ps);
        }
        throw new DbProException("masterSlaveSelect property not set.");
    }

    private Object runWriteOperations(ImprovedQueryRunner dbPro, PreparedSQL ps) {
        switch (ps.getOperationType()) {
            case INSERT: {
                return dbPro.runInsert(ps);
            }
            case EXECUTE: {
                return dbPro.runExecute(ps);
            }
            case UPDATE: {
                return dbPro.runUpdate(ps);
            }
        }
        throw new DbProException("Should never run to here");
    }

    protected <T> T runQuery(PreparedSQL ps) {
        if (ps.getResultSetHandler() != null) {
            try {
                if (ps.getConnection() != null) {
                    if (ps.getParams() != null) {
                        return (T)this.query(ps.getConnection(), ps.getSql(), ps.getResultSetHandler(), ps.getParams());
                    }
                    return (T)this.query(ps.getConnection(), ps.getSql(), ps.getResultSetHandler());
                }
                if (ps.getParams() != null) {
                    return (T)this.query(ps.getSql(), ps.getResultSetHandler(), ps.getParams());
                }
                return (T)this.query(ps.getSql(), ps.getResultSetHandler());
            }
            catch (SQLException e) {
                throw new DbProException(e);
            }
        }
        throw new DbProException("A ResultSetHandler is required by query method");
    }

    private DbPro autoChooseMasterOrSlaveQuery(PreparedSQL ps) {
        if (this.getSlaves() == null || this.getSlaves().length == 0 || this.getConnectionManager() != null && this.getConnectionManager().isInTransaction()) {
            return (DbPro)this;
        }
        DbPro slave = this.chooseOneSlave();
        if (slave == null) {
            throw new DbProException("Try to run a slave DbPro but slave list is null or empty");
        }
        return slave;
    }

    private <T> T runMasterQuery(PreparedSQL ps) throws SQLException {
        if (ps.getParams() != null) {
            return (T)this.query(ps.getSql(), ps.getResultSetHandler(), ps.getParams());
        }
        return (T)this.query(ps.getSql(), ps.getResultSetHandler());
    }

    private DbPro chooseOneSlave() {
        if (this.slaves == null || this.slaves.length == 0) {
            return null;
        }
        return this.slaves[new Random().nextInt(this.slaves.length)];
    }

    protected <T> T runInsert(PreparedSQL ps) {
        if (ps.getResultSetHandler() != null) {
            try {
                if (ps.getConnection() != null) {
                    if (ps.getParams() != null) {
                        return (T)this.insert(ps.getConnection(), ps.getSql(), ps.getResultSetHandler(), ps.getParams());
                    }
                    return (T)this.insert(ps.getConnection(), ps.getSql(), ps.getResultSetHandler());
                }
                if (ps.getParams() != null) {
                    return (T)this.insert(ps.getSql(), ps.getResultSetHandler(), ps.getParams());
                }
                return (T)this.insert(ps.getSql(), ps.getResultSetHandler());
            }
            catch (SQLException e) {
                throw new DbProException(e);
            }
        }
        throw new DbProException("A ResultSetHandler is required by insert method");
    }

    protected <T> T runExecute(PreparedSQL ps) {
        try {
            if (ps.getResultSetHandler() != null) {
                if (ps.getConnection() != null) {
                    return (T)this.execute(ps.getConnection(), ps.getSql(), ps.getResultSetHandler(), ps.getParams());
                }
                return (T)this.execute(ps.getSql(), ps.getResultSetHandler(), ps.getParams());
            }
            if (ps.getConnection() != null) {
                return (T)Integer.valueOf(this.execute(ps.getConnection(), ps.getSql(), ps.getParams()));
            }
            return (T)Integer.valueOf(this.execute(ps.getSql(), ps.getParams()));
        }
        catch (SQLException e) {
            throw new DbProException(e);
        }
    }

    protected int runUpdate(PreparedSQL ps) {
        try {
            if (ps.getResultSetHandler() != null) {
                // empty if block
            }
            if (ps.getConnection() != null) {
                if (ps.getParams() != null) {
                    return this.update(ps.getConnection(), ps.getSql(), ps.getParams());
                }
                return this.update(ps.getConnection(), ps.getSql());
            }
            if (ps.getParams() != null) {
                return this.update(ps.getSql(), ps.getParams());
            }
            return this.update(ps.getSql());
        }
        catch (SQLException e) {
            throw new DbProException(e);
        }
    }

    private <T> T runQueryForScalar(PreparedSQL ps) {
        try {
            if (ps.getResultSetHandler() == null) {
                return this.query(ps.getSql(), new ScalarHandler(1), ps.getParams());
            }
            return (T)this.query(ps.getSql(), ps.getResultSetHandler(), ps.getParams());
        }
        catch (SQLException e) {
            throw new DbProException(e);
        }
    }

    public int[] nBatch(String sql, List<Object[]> params) {
        try {
            return this.batch(sql, ImprovedQueryRunner.objectsListToArray2D(params));
        }
        catch (SQLException e) {
            throw new DbProException(e);
        }
    }

    public int[] nBatch(Connection conn, String sql, List<Object[]> params) throws SQLException {
        try {
            return this.batch(conn, sql, ImprovedQueryRunner.objectsListToArray2D(params));
        }
        catch (SQLException e) {
            throw new DbProException(e);
        }
    }

    public <T> T nInsertBatch(String sql, ResultSetHandler<T> rsh, List<Object[]> params) {
        try {
            return this.insertBatch(sql, rsh, ImprovedQueryRunner.objectsListToArray2D(params));
        }
        catch (SQLException e) {
            throw new DbProException(e);
        }
    }

    public <T> T nInsertBatch(Connection conn, String sql, ResultSetHandler<T> rsh, List<Object[]> params) {
        try {
            return this.insertBatch(conn, sql, rsh, ImprovedQueryRunner.objectsListToArray2D(params));
        }
        catch (SQLException e) {
            throw new DbProException(e);
        }
    }

    private void specialMethods_____________________() {
    }

    public static Object[][] listListToArray2D(List<List<?>> paramList) {
        Object[][] array = new Object[paramList.size()][];
        int i = 0;
        for (List<?> item : paramList) {
            array[i++] = item.toArray(new Object[item.size()]);
        }
        return array;
    }

    public static Object[][] objectsListToArray2D(List<Object[]> paramList) {
        Object[][] array = new Object[paramList.size()][];
        int i = 0;
        for (Object[] item : paramList) {
            array[i++] = item;
        }
        return array;
    }

    public static SqlHandler[] getThreadLocalSqlHandlers() {
        return threadLocalSqlHandlers.get();
    }

    public List<Object[]> getOthers() {
        return this.others.get();
    }

    public static void setThreadLocalSqlHandlers(SqlHandler ... handlers) {
        threadLocalSqlHandlers.set(handlers);
    }

    public Integer getForceCommitFail() {
        return this.threadLocalForceCommitFail.get();
    }

    public void setForceCommitFail() {
        this.threadLocalForceCommitFail.set(-1);
    }

    public void setForceCommitFail(Integer failCount) {
        this.threadLocalForceCommitFail.set(failCount);
    }

    protected void connectionManagerWrapMethods_____________________() {
    }

    public boolean isIntrans() {
        return this.getConnectionManager().isInTransaction();
    }

    public void startTrans() {
        this.getConnectionManager().startTransaction();
    }

    public void startTrans(int txIsolationLevel) {
        this.getConnectionManager().startTransaction(txIsolationLevel);
    }

    public Connection getConnection() throws SQLException {
        return this.getConnectionManager().getConnection(this);
    }

    public void releaseConnection(Connection conn) throws SQLException {
        this.getConnectionManager().releaseConnection(conn, this);
    }

    public TxResult commitTrans() throws Exception {
        return this.getConnectionManager().commitTransaction();
    }

    public TxResult rollbackTrans() {
        return this.getConnectionManager().rollbackTransaction();
    }

    protected void txTemplateMethods______________________________() {
    }

    public boolean tryTx(TxBody txBody) {
        this.startTrans();
        try {
            txBody.run();
            lastTxResult.set(this.commitTrans());
            return true;
        }
        catch (Exception e) {
            lastTxResult.set(this.rollbackTrans().addCommitEx(e));
            return false;
        }
    }

    public void tx(TxBody txBody) {
        this.startTrans();
        try {
            txBody.run();
            lastTxResult.set(this.commitTrans());
        }
        catch (Exception e) {
            lastTxResult.set(this.rollbackTrans().addCommitEx(e));
            throw new DbException(e);
        }
    }

    public static TxResult getLastTxResult() {
        return lastTxResult.get();
    }

    protected void staticGlobalNextMethods_____________________() {
    }

    public static Dialect getGlobalNextDialect() {
        return globalNextDialect;
    }

    public static void setGlobalNextDialect(Dialect dialect) {
        globalNextDialect = dialect;
    }

    public static Integer getGlobalNextBatchSize() {
        return globalNextBatchSize;
    }

    public static void setGlobalNextBatchSize(Integer batchSize) {
        globalNextBatchSize = batchSize;
    }

    public static Boolean getGlobalNextAllowShowSql() {
        return globalNextAllowShowSql;
    }

    public static void setGlobalNextAllowShowSql(Boolean allowShowSql) {
        globalNextAllowShowSql = allowShowSql;
    }

    public static SqlOption getGlobalNextMasterSlaveOption() {
        return globalNextMasterSlaveOption;
    }

    public static void setGlobalNextMasterSlaveOption(SqlOption masterSlaveOption) {
        globalNextMasterSlaveOption = masterSlaveOption;
    }

    public static ConnectionManager getGlobalNextConnectionManager() {
        return globalNextConnectionManager;
    }

    public static void setGlobalNextConnectionManager(ConnectionManager connectionManager) {
        globalNextConnectionManager = connectionManager;
    }

    public static SqlHandler[] getGlobalNextSqlHandlers() {
        return globalNextSqlHandlers;
    }

    public static void setGlobalNextSqlHandlers(SqlHandler ... sqlHandlers) {
        globalNextSqlHandlers = sqlHandlers;
    }

    public static JavaToJdbcConverter getGlobalNextJavaToJdbcConverter() {
        return globalNextJavaToJdbcConverter;
    }

    public static void setGlobalNextJavaToJdbcConverter(JavaToJdbcConverter globalNextJavaToJdbcConverter) {
        ImprovedQueryRunner.globalNextJavaToJdbcConverter = globalNextJavaToJdbcConverter;
    }

    public static JdbcToJavaConverter getGlobalNextJdbcToJavaConverter() {
        return globalNextJdbcToJavaConverter;
    }

    public static void setGlobalNextJdbcToJavaConverter(JdbcToJavaConverter globalNextJdbcToJavaConverter) {
        ImprovedQueryRunner.globalNextJdbcToJavaConverter = globalNextJdbcToJavaConverter;
    }

    public static TenantGetter getGlobalNextTenantGetter() {
        return globalNextTenantGetter;
    }

    public static void setGlobalNextTenantGetter(TenantGetter globalNextTenantGetter) {
        ImprovedQueryRunner.globalNextTenantGetter = globalNextTenantGetter;
    }

    public static void setGlobalNextSqlItemHandler(SqlItemHandler globalNextSqlItemHandler) {
        ImprovedQueryRunner.globalNextSqlItemHandler = globalNextSqlItemHandler;
    }

    private void normalGetterSetters_____________________() {
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public Boolean getAllowShowSQL() {
        return this.allowShowSQL;
    }

    public void setAllowShowSQL(Boolean allowShowSQL) {
        this.allowShowSQL = allowShowSQL;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public SqlHandler[] getSqlHandlers() {
        return this.sqlHandlers;
    }

    public void setSqlHandlers(SqlHandler[] sqlHandlers) {
        this.sqlHandlers = sqlHandlers;
    }

    public DbPro[] getSlaves() {
        return this.slaves;
    }

    public void setSlaves(DbPro[] slaves) {
        this.slaves = slaves;
        for (DbPro dbPro : slaves) {
            if (dbPro == null) continue;
            dbPro.setConnectionManager(null);
        }
    }

    public DbPro[] getMasters() {
        return this.masters;
    }

    public void setMasters(DbPro[] masters) {
        this.masters = masters;
    }

    public SqlOption getMasterSlaveOption() {
        return this.masterSlaveOption;
    }

    public void setMasterSlaveOption(SqlOption masterSlaveOption) {
        this.masterSlaveOption = masterSlaveOption;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JavaToJdbcConverter getJavaToJdbcConverter() {
        return this.javaToJdbcConverter;
    }

    public void setJavaToJdbcConverter(JavaToJdbcConverter javaToJdbcConverter) {
        this.javaToJdbcConverter = javaToJdbcConverter;
    }

    public JdbcToJavaConverter getJdbcToJavaConverter() {
        return this.jdbcToJavaConverter;
    }

    public void setJdbcToJavaConverter(JdbcToJavaConverter jdbcToJavaConverter) {
        this.jdbcToJavaConverter = jdbcToJavaConverter;
    }

    public TenantGetter getTenantGetter() {
        return this.tenantGetter;
    }

    public void setTenantGetter(TenantGetter tenantGetter) {
        this.tenantGetter = tenantGetter;
    }

    public SqlItemHandler getSqlItemHandler() {
        return this.sqlItemHandler;
    }

    public void setSqlItemHandler(SqlItemHandler sqlItemHandler) {
        this.sqlItemHandler = sqlItemHandler;
    }

    public boolean isBatchEnabled() {
        return this.batchEnabled.get();
    }

    public ThreadLocal<ArrayList<PreparedSQL>> getSqlBatchCache() {
        return this.sqlBatchCache;
    }

    public Integer getDbCode() {
        return this.dbCode;
    }

    public void setDbCode(Integer dbCode) {
        this.dbCode = dbCode;
    }
}

