/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro;

import com.github.drinkjava2.jdbpro.CustomizedSqlItem;
import com.github.drinkjava2.jdbpro.DbProException;
import com.github.drinkjava2.jdbpro.ImprovedQueryRunner;
import com.github.drinkjava2.jdbpro.NormalJdbcTool;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.SingleTonHandlers;
import com.github.drinkjava2.jdbpro.SqlHandler;
import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdbpro.Text;
import com.github.drinkjava2.jdbpro.template.SqlTemplateEngine;
import com.github.drinkjava2.jdialects.Dialect;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.StatementConfiguration;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class DbPro
extends ImprovedQueryRunner
implements NormalJdbcTool {
    public DbPro() {
    }

    public DbPro(DataSource ds) {
        super(ds);
    }

    public DbPro(DataSource ds, Dialect dialect) {
        super(ds, dialect);
    }

    public DbPro(DataSource ds, StatementConfiguration stmtConfig) {
        super(ds, stmtConfig);
    }

    public DbPro(DataSource ds, Dialect dialect, StatementConfiguration stmtConfig) {
        super(ds, dialect, stmtConfig);
    }

    public int quiteExecute(String ... sqls) {
        int result = 0;
        for (String sql : sqls) {
            try {
                this.execute(sql, new Object[0]);
            }
            catch (Exception e) {
                result = -1;
            }
        }
        return result;
    }

    public void ________prepareMethods________() {
    }

    public PreparedSQL prepare(Object ... items) {
        return this.doPrepare(true, items);
    }

    private PreparedSQL doPrepare(boolean inlineStyle, Object ... items) {
        PreparedSQL ps = this.dealSqlItems(null, inlineStyle, items);
        ps.addGlobalAndThreadedHandlers(this);
        return ps;
    }

    public void preparedParamsToJdbc(PreparedSQL ps) {
    }

    public PreparedSQL dealSqlItems(PreparedSQL lastPreSql, boolean inlineStyle, Object ... items) {
        if (items == null || items.length == 0) {
            throw new DbProException("prepareSQL items can not be empty");
        }
        PreparedSQL predSQL = lastPreSql;
        if (predSQL == null) {
            predSQL = new PreparedSQL();
        }
        for (Object item : items) {
            if (item == null) {
                if (inlineStyle) {
                    throw new DbProException("null value can not append as SQL piece");
                }
                predSQL.addParam(null);
                continue;
            }
            if (this.dealOneSqlItem(inlineStyle, predSQL, item)) continue;
            if (item instanceof SqlItem) {
                throw new DbProException("One SqlItem did not find explainer, type=" + (Object)((Object)((SqlItem)item).getType()));
            }
            if (item.getClass().isArray()) {
                Object[] array = (Object[])item;
                if (array.length == 0) continue;
                this.dealSqlItems(predSQL, inlineStyle, (Object[])item);
                continue;
            }
            if (inlineStyle) {
                predSQL.addSql(item);
                continue;
            }
            predSQL.addParam(item);
        }
        predSQL.setSql(predSQL.getSqlBuilder().toString());
        return predSQL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean dealOneSqlItem(boolean inlineStyle, PreparedSQL predSQL, Object item) {
        if (item instanceof String) {
            predSQL.addSqlOrParam(inlineStyle, (String)item);
            return true;
        } else if (item instanceof PreparedSQL) {
            PreparedSQL psItem = (PreparedSQL)item;
            if (psItem.getSql() != null) {
                predSQL.addSql(psItem.getSql());
            }
            if (psItem.getParams() == null) return true;
            for (Object obj : psItem.getParams()) {
                predSQL.addParam(obj);
            }
            return true;
        } else if (item instanceof SqlTemplateEngine) {
            predSQL.setTemplateEngine((SqlTemplateEngine)item);
            return true;
        } else if (item instanceof Map) {
            predSQL.addTemplateMap((Map)item);
            return true;
        } else if (item instanceof SqlOption) {
            if (SqlOption.USE_MASTER.equals(item)) {
                predSQL.setMasterSlaveOption(SqlOption.USE_MASTER);
                return true;
            } else if (SqlOption.USE_SLAVE.equals(item)) {
                predSQL.setMasterSlaveOption(SqlOption.USE_SLAVE);
                return true;
            } else if (SqlOption.USE_AUTO.equals(item)) {
                predSQL.setMasterSlaveOption(SqlOption.USE_AUTO);
                return true;
            } else if (SqlOption.USE_BOTH.equals(item)) {
                predSQL.setMasterSlaveOption(SqlOption.USE_BOTH);
                return true;
            } else if (SqlOption.EXECUTE.equals(item)) {
                predSQL.setOperationType(SqlOption.EXECUTE);
                return true;
            } else if (SqlOption.UPDATE.equals(item)) {
                predSQL.setOperationType(SqlOption.UPDATE);
                return true;
            } else if (SqlOption.QUERY.equals(item)) {
                predSQL.setOperationType(SqlOption.QUERY);
                return true;
            } else {
                if (!SqlOption.INSERT.equals(item)) return false;
                predSQL.setOperationType(SqlOption.INSERT);
            }
            return true;
        } else if (item instanceof SqlItem) {
            SqlItem sqItem = (SqlItem)item;
            SqlOption sqlItemType = sqItem.getType();
            if (SqlOption.OTHER.equals((Object)sqlItemType)) {
                predSQL.addOther(sqItem);
                return true;
            } else if (SqlOption.PARAM.equals((Object)sqlItemType)) {
                if (sqItem.getParameters() == null) {
                    predSQL.addParam(null);
                    return true;
                } else {
                    for (Object pm : sqItem.getParameters()) {
                        predSQL.addParam(pm);
                    }
                }
                return true;
            } else if (SqlOption.BIND.equals((Object)sqlItemType)) {
                predSQL.addTemplateParam(sqItem);
                return true;
            } else if (SqlOption.SQL.equals((Object)sqlItemType)) {
                for (Object pm : sqItem.getParameters()) {
                    predSQL.addSql(pm);
                }
                return true;
            } else if (SqlOption.QUESTION_PARAM.equals((Object)sqlItemType)) {
                if (sqItem.getParameters() == null) {
                    predSQL.addParam(null);
                    predSQL.addSql("?");
                    return true;
                } else {
                    int i = 0;
                    for (Object pm : sqItem.getParameters()) {
                        predSQL.addParam(pm);
                        if (i > 0) {
                            predSQL.addSql(",");
                        }
                        predSQL.addSql("?");
                        ++i;
                    }
                }
                return true;
            } else if (SqlOption.VALUES_QUESTIONS.equals((Object)sqlItemType)) {
                predSQL.addSql(" values(");
                for (int i = 0; i < predSQL.getParamSize(); ++i) {
                    if (i > 0) {
                        predSQL.addSql(",");
                    }
                    predSQL.addSql("?");
                }
                predSQL.addSql(")");
                return true;
            } else if (SqlOption.ENABLE_HANDLERS.equals((Object)sqlItemType)) {
                predSQL.enableAllHandlers();
                return true;
            } else if (SqlOption.DISABLE_HANDLERS.equals((Object)sqlItemType)) {
                predSQL.disableHandlers(sqItem.getParameters());
                return true;
            } else {
                if (!SqlOption.SWITCHTO.equals((Object)sqlItemType)) return false;
                predSQL.setSwitchTo((DbPro)sqItem.getParameters()[0]);
            }
            return true;
        } else if (item instanceof Text) {
            predSQL.addSql(item.toString());
            return true;
        } else if (item instanceof Connection) {
            predSQL.setConnection((Connection)item);
            return true;
        } else if (item instanceof DbPro) {
            predSQL.setSwitchTo((DbPro)item);
            return true;
        } else if (item instanceof SqlHandler) {
            predSQL.addHandler((SqlHandler)item);
            return true;
        } else if (item instanceof ResultSetHandler) {
            predSQL.setResultSetHandler((ResultSetHandler)item);
            return true;
        } else {
            if (item instanceof Class) {
                if (!Text.class.isAssignableFrom((Class)item)) return false;
                String text = Text.classToString((Class)item);
                predSQL.addSqlOrParam(inlineStyle, text);
                return true;
            }
            if (item instanceof CustomizedSqlItem) {
                ((CustomizedSqlItem)item).doPrepare(predSQL);
                return true;
            } else {
                if (this.sqlItemHandler == null) return false;
                return this.sqlItemHandler.handle(predSQL, item);
            }
        }
    }

    public void ________3letter_inlineStyles________() {
    }

    public <T> T qry(Object ... inlineSQL) {
        PreparedSQL ps = this.prepare(inlineSQL);
        ps.ifNullSetType(SqlOption.QUERY);
        return (T)this.runPreparedSQL(ps);
    }

    public <T> T qryObject(Object ... inlineSQL) {
        PreparedSQL ps = this.prepare(inlineSQL);
        ps.ifNullSetType(SqlOption.QUERY);
        if (ps.getResultSetHandler() == null) {
            ps.setResultSetHandler(new ScalarHandler(1));
        }
        return (T)this.runPreparedSQL(ps);
    }

    public long qryLongValue(Object ... inlineSQL) {
        return ((Number)this.qryObject(inlineSQL)).longValue();
    }

    public int qryIntValue(Object ... inlineSQL) {
        return ((Number)this.qryObject(inlineSQL)).intValue();
    }

    public boolean qryBooleanValue(Object ... inlineSQL) {
        return (Boolean)this.qryObject(inlineSQL);
    }

    public String qryString(Object ... inlineSQL) {
        Object result = this.qryObject(inlineSQL);
        return result == null ? null : result.toString();
    }

    public List<Map<String, Object>> qryMapList(Object ... items) {
        PreparedSQL ps = this.prepare(items);
        ps.addHandler(new MapListHandler());
        ps.ifNullSetType(SqlOption.QUERY);
        return (List)this.runPreparedSQL(ps);
    }

    public Map<String, Object> qryMap(Object ... items) {
        List<Map<String, Object>> list = this.qryMapList(items);
        if (list.isEmpty()) {
            return new HashMap<String, Object>();
        }
        return list.get(0);
    }

    public <T> List<T> qryList(Object ... items) {
        return (List)this.qry(new ColumnListHandler(1), items);
    }

    public int upd(Object ... inlineSQL) {
        PreparedSQL ps = this.prepare(inlineSQL);
        ps.ifNullSetType(SqlOption.UPDATE);
        return (Integer)this.runPreparedSQL(ps);
    }

    public <T> T ins(Object ... inlineSQL) {
        PreparedSQL ps = this.prepare(inlineSQL);
        ps.ifNullSetType(SqlOption.INSERT);
        return (T)this.runPreparedSQL(ps);
    }

    public <T> T exe(Object ... inlineSQL) {
        PreparedSQL ps = this.prepare(inlineSQL);
        ps.ifNullSetType(SqlOption.EXECUTE);
        return (T)this.runPreparedSQL(ps);
    }

    public void ________jdbcMethods________() {
    }

    @Override
    public <T> T jdbcQueryForObject(String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.QUERY, null, SingleTonHandlers.scalarHandler, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (T)this.runPreparedSQL(ps);
    }

    @Override
    public int jdbcUpdate(String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.UPDATE, null, null, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (Integer)this.runPreparedSQL(ps);
    }

    @Override
    public int jdbcExecute(String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.EXECUTE, null, null, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (Integer)this.runPreparedSQL(ps);
    }
}

