/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jbeanbox;

import com.github.drinkjava2.jbeanbox.BeanBox;
import com.github.drinkjava2.jbeanbox.BeanBoxException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;

public class BeanBoxUtils {
    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... paramTypes) {
        try {
            return clazz.getConstructor(paramTypes);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Security exception found for Constructor: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Constructor not found: " + e.getMessage());
        }
    }

    public static void copyBoxValues(BeanBox from, BeanBox to) {
        to.setTarget(from.target);
        to.setPureValue(from.pureValue);
        to.setRequired(from.required);
        to.setQualifierAnno(from.qualifierAnno);
        to.setQualifierValue(from.qualifierValue);
        to.setType(from.type);
    }

    public static Annotation[] getAnnotations(Object targetClass) {
        if (targetClass instanceof Field) {
            return ((Field)targetClass).getAnnotations();
        }
        if (targetClass instanceof Method) {
            return ((Method)targetClass).getAnnotations();
        }
        if (targetClass instanceof Constructor) {
            return ((Constructor)targetClass).getAnnotations();
        }
        if (targetClass instanceof Class) {
            return ((Class)targetClass).getAnnotations();
        }
        return (Annotation[])BeanBoxException.throwEX("targetClass should be Field, Method, Constructor or Class");
    }

    public static Map<String, Object> getAnnoAsMap(Object targetClass, String annoFullName) {
        Annotation[] anno;
        for (Annotation a : anno = BeanBoxUtils.getAnnotations(targetClass)) {
            Class<? extends Annotation> type = a.annotationType();
            if (!annoFullName.equals(type.getName())) continue;
            return BeanBoxUtils.changeAnnotationValuesToMap(a);
        }
        return null;
    }

    public static boolean ifSameOrChildAnno(Class<? extends Annotation> annoType, Class<? extends Annotation> ... annoTypes) {
        for (Class<? extends Annotation> a : annoTypes) {
            if (!annoType.equals(a) && !annoType.isAnnotationPresent(a)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAnnoExist(Object targetClass, Class<?> annoClass) {
        Annotation[] anno;
        for (Annotation annotation : anno = BeanBoxUtils.getAnnotations(targetClass)) {
            Class<? extends Annotation> type = annotation.annotationType();
            if (!annoClass.equals(type)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> changeAnnotationValuesToMap(Annotation annotation) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Method method : annotation.annotationType().getDeclaredMethods()) {
            try {
                result.put(method.getName(), method.invoke((Object)annotation, (Object[])null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static Object checkAOP(Object aop) {
        if (aop instanceof MethodInterceptor) {
            return new BeanBox().setTarget(aop).setPureValue(true);
        }
        return aop;
    }

    public static BeanBox wrapParamToBox(Object param) {
        if (param != null) {
            if (param instanceof Class) {
                return new BeanBox().setTarget(param);
            }
            if (param instanceof BeanBox) {
                return (BeanBox)param;
            }
        }
        return new BeanBox().setAsValue(param);
    }
}

