/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jbeanbox;

import com.github.drinkjava2.jbeanbox.BeanBoxContext;
import com.github.drinkjava2.jbeanbox.BeanBoxException;
import com.github.drinkjava2.jbeanbox.BeanBoxUtils;
import com.github.drinkjava2.jbeanbox.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanBox {
    protected Object target;
    protected boolean pureValue = false;
    protected Class<?> type;
    protected boolean required = true;
    protected Class<? extends Annotation> qualifierAnno;
    protected Object qualifierValue;
    protected Class<?> beanClass;
    protected Boolean singleton = null;
    protected Constructor<?> constructor;
    protected BeanBox[] constructorParams;
    protected Method postConstruct;
    protected Method preDestroy;
    protected Map<Field, BeanBox> fieldInjects;
    protected Map<Method, BeanBox[]> methodInjects;
    protected Map<Method, List<Object>> methodAops;
    protected List<Object[]> aopRules;

    public Object getSingletonId() {
        if (this.singleton == null || !this.singleton.booleanValue() || this.pureValue || this.target != null) {
            return null;
        }
        return this;
    }

    public <T> T getBean() {
        return BeanBoxContext.globalBeanBoxContext.getBean(this);
    }

    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder("\r\n BeanBox properties:\r\n");
        sb.append("target=" + this.target).append("\r\n");
        sb.append("pureValue=" + this.pureValue).append("\r\n");
        sb.append("type=" + this.type).append("\r\n");
        sb.append("required=" + this.required).append("\r\n");
        sb.append("beanClass=" + this.beanClass).append("\r\n");
        sb.append("singleton=" + this.singleton).append("\r\n");
        sb.append("methodAops=" + this.methodAops).append("\r\n");
        sb.append("methodAopRules=" + this.aopRules).append("\r\n");
        sb.append("constructor=" + this.constructor).append("\r\n");
        sb.append("constructorParams=" + this.constructorParams).append("\r\n");
        sb.append("postConstructs=" + this.postConstruct).append("\r\n");
        sb.append("preDestorys=" + this.preDestroy).append("\r\n");
        sb.append("fieldInjects=" + this.fieldInjects).append("\r\n");
        sb.append("methodInjects=" + this.methodInjects).append("\r\n");
        sb.append("qualifierAnno=" + this.qualifierAnno).append("\r\n");
        sb.append("qualifierValue=" + this.qualifierValue);
        return sb.toString();
    }

    protected void checkOrCreateFieldInjects() {
        if (this.fieldInjects == null) {
            this.fieldInjects = new HashMap<Field, BeanBox>();
        }
    }

    protected void checkOrCreateMethodInjects() {
        if (this.methodInjects == null) {
            this.methodInjects = new HashMap<Method, BeanBox[]>();
        }
    }

    protected void checkOrCreateMethodAops() {
        if (this.methodAops == null) {
            this.methodAops = new HashMap<Method, List<Object>>();
        }
    }

    protected void checkOrCreateMethodAopRules() {
        if (this.aopRules == null) {
            this.aopRules = new ArrayList<Object[]>();
        }
    }

    protected Class<?> checkBeanClassExist() {
        Method mtd;
        Class<?> returnType;
        if (this.beanClass == null && (returnType = (mtd = ReflectionUtils.findMethod(this.getClass(), "create")).getReturnType()) != Object.class) {
            this.beanClass = returnType;
        }
        return this.beanClass;
    }

    protected BeanBox newCopy() {
        BeanBox box = new BeanBox();
        box.target = this.target;
        box.pureValue = this.pureValue;
        box.type = this.type;
        box.required = this.required;
        box.qualifierAnno = this.qualifierAnno;
        box.qualifierValue = this.qualifierValue;
        box.beanClass = this.beanClass;
        box.singleton = this.singleton;
        box.constructor = this.constructor;
        box.constructorParams = this.constructorParams;
        box.postConstruct = this.postConstruct;
        box.preDestroy = this.preDestroy;
        box.fieldInjects = this.fieldInjects;
        box.methodInjects = this.methodInjects;
        box.methodAops = this.methodAops;
        box.aopRules = this.aopRules;
        return box;
    }

    protected void belowAreJavaConfigMethods_______________() {
    }

    public BeanBox setAsValue(Object value) {
        this.pureValue = true;
        this.target = value;
        return this;
    }

    public BeanBox setPrototype(boolean isPrototype) {
        this.singleton = !isPrototype;
        return this;
    }

    public BeanBox injectConstruct(Class<?> clazz, Object ... configs) {
        this.beanClass = clazz;
        if (configs.length == 0) {
            this.constructor = BeanBoxUtils.getConstructor(clazz, new Class[0]);
        } else {
            int i;
            Class[] paramTypes = new Class[configs.length / 2];
            BeanBox[] params = new BeanBox[configs.length / 2];
            int mid = configs.length / 2;
            for (i = 0; i < mid; ++i) {
                paramTypes[i] = (Class)configs[i];
            }
            for (i = mid; i < configs.length; ++i) {
                params[i - mid] = BeanBoxUtils.wrapParamToBox(configs[i]);
                params[i - mid].setType(paramTypes[i - mid]);
            }
            this.constructor = BeanBoxUtils.getConstructor(clazz, paramTypes);
            this.constructorParams = params;
        }
        return this;
    }

    public BeanBox injectConstr(Class<?> clazz, Object ... configs) {
        Object[] newConfigs = new Object[configs.length * 2];
        for (int i = 0; i < configs.length; ++i) {
            newConfigs[i * 2] = configs[i].getClass();
            newConfigs[i * 2 + 1] = configs[i];
        }
        return this.injectConstruct(clazz, newConfigs);
    }

    public BeanBox injectMethod(String methodName, Object ... configs) {
        int i;
        this.checkOrCreateMethodInjects();
        Class[] paramTypes = new Class[configs.length / 2];
        BeanBox[] params = new BeanBox[configs.length / 2];
        int mid = configs.length / 2;
        for (i = 0; i < mid; ++i) {
            paramTypes[i] = (Class)configs[i];
        }
        for (i = mid; i < configs.length; ++i) {
            params[i - mid] = BeanBoxUtils.wrapParamToBox(configs[i]);
            params[i - mid].setType(paramTypes[i - mid]);
        }
        Method m = ReflectionUtils.findMethod(this.checkBeanClassExist(), methodName, paramTypes);
        if (m != null) {
            ReflectionUtils.makeAccessible(m);
        }
        this.getMethodInjects().put(m, params);
        return this;
    }

    public BeanBox injectMtd(String methodName, Object ... configs) {
        Object[] newConfigs = new Object[configs.length * 2];
        for (int i = 0; i < configs.length; ++i) {
            newConfigs[i * 2] = configs[i].getClass();
            newConfigs[i * 2 + 1] = configs[i];
        }
        return this.injectMethod(methodName, newConfigs);
    }

    public synchronized BeanBox addMethodAop(Object aop, Method method) {
        this.checkOrCreateMethodAops();
        List<Object> aops = this.methodAops.get(method);
        if (aops == null) {
            aops = new ArrayList<Object>();
            this.methodAops.put(method, aops);
        }
        aops.add(BeanBoxUtils.checkAOP(aop));
        return this;
    }

    public synchronized BeanBox addMethodAop(Object aop, String methodName, Class<?> ... paramTypes) {
        this.checkOrCreateMethodAops();
        Method m = ReflectionUtils.findMethod(this.checkBeanClassExist(), methodName, paramTypes);
        BeanBoxException.assureNotNull(m, "Not found method: '" + methodName + "'");
        this.addMethodAop(aop, m);
        return this;
    }

    public synchronized BeanBox addBeanAop(Object aop, String methodNameRegex) {
        this.checkOrCreateMethodAopRules();
        this.aopRules.add(new Object[]{BeanBoxUtils.checkAOP(aop), methodNameRegex});
        return this;
    }

    public BeanBox setPostConstruct(String methodName) {
        Method m = ReflectionUtils.findMethod(this.checkBeanClassExist(), methodName);
        this.setPostConstruct(m);
        return this;
    }

    public BeanBox setPreDestroy(String methodName) {
        Method m = ReflectionUtils.findMethod(this.checkBeanClassExist(), methodName);
        this.setPreDestroy(m);
        return this;
    }

    public BeanBox injectField(String fieldName, Object object) {
        BeanBox box = BeanBoxUtils.wrapParamToBox(object);
        this.checkOrCreateFieldInjects();
        Field f = ReflectionUtils.findField(this.checkBeanClassExist(), fieldName);
        box.setType(f.getType());
        ReflectionUtils.makeAccessible(f);
        this.getFieldInjects().put(f, box);
        return this;
    }

    public BeanBox setProperty(String fieldName, Object object) {
        return this.injectField(fieldName, object);
    }

    public BeanBox injectValue(String fieldName, Object constValue) {
        this.checkOrCreateFieldInjects();
        Field f = ReflectionUtils.findField(this.checkBeanClassExist(), fieldName);
        BeanBox inject = new BeanBox();
        inject.setTarget(constValue);
        inject.setType(f.getType());
        inject.setPureValue(true);
        ReflectionUtils.makeAccessible(f);
        this.getFieldInjects().put(f, inject);
        return this;
    }

    public Object create() {
        return null;
    }

    public Object create(BeanBoxContext context) {
        return null;
    }

    public Object create(BeanBoxContext context, Set<Object> history) {
        return null;
    }

    public void config(Object bean) {
    }

    public void config(Object bean, BeanBoxContext context) {
    }

    public void config(Object bean, BeanBoxContext context, Set<Object> history) {
    }

    protected void getterAndSetters_____________________() {
    }

    public Object getTarget() {
        return this.target;
    }

    public BeanBox setTarget(Object target) {
        this.target = target;
        return this;
    }

    public boolean isPureValue() {
        return this.pureValue;
    }

    public BeanBox setPureValue(boolean pureValue) {
        this.pureValue = pureValue;
        return this;
    }

    public Class<?> getType() {
        return this.type;
    }

    public BeanBox setType(Class<?> type) {
        this.type = type;
        return this;
    }

    public boolean isRequired() {
        return this.required;
    }

    public BeanBox setRequired(boolean required) {
        this.required = required;
        return this;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public BeanBox setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
        return this;
    }

    public boolean isSingleton() {
        return this.singleton != null && this.singleton != false;
    }

    public BeanBox setSingleton(boolean singleton) {
        this.singleton = singleton;
        return this;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public BeanBox setConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
        return this;
    }

    public BeanBox[] getConstructorParams() {
        return this.constructorParams;
    }

    public BeanBox setConstructorParams(BeanBox[] constructorParams) {
        this.constructorParams = constructorParams;
        return this;
    }

    public Method getPostConstruct() {
        return this.postConstruct;
    }

    public BeanBox setPostConstruct(Method postConstruct) {
        this.postConstruct = postConstruct;
        return this;
    }

    public Method getPreDestroy() {
        return this.preDestroy;
    }

    public BeanBox setPreDestroy(Method preDestroy) {
        this.preDestroy = preDestroy;
        return this;
    }

    public Map<Field, BeanBox> getFieldInjects() {
        return this.fieldInjects;
    }

    public BeanBox setFieldInjects(Map<Field, BeanBox> fieldInjects) {
        this.fieldInjects = fieldInjects;
        return this;
    }

    public Map<Method, BeanBox[]> getMethodInjects() {
        return this.methodInjects;
    }

    public BeanBox setMethodInjects(Map<Method, BeanBox[]> methodInjects) {
        this.methodInjects = methodInjects;
        return this;
    }

    public Map<Method, List<Object>> getMethodAops() {
        return this.methodAops;
    }

    public BeanBox setMethodAops(Map<Method, List<Object>> methodAops) {
        this.methodAops = methodAops;
        return this;
    }

    public List<Object[]> getAopRules() {
        return this.aopRules;
    }

    public BeanBox setAopRules(List<Object[]> aopRules) {
        this.aopRules = aopRules;
        return this;
    }

    public Class<? extends Annotation> getQualifierAnno() {
        return this.qualifierAnno;
    }

    public BeanBox setQualifierAnno(Class<? extends Annotation> qualifierAnno) {
        this.qualifierAnno = qualifierAnno;
        return this;
    }

    public Object getQualifierValue() {
        return this.qualifierValue;
    }

    public BeanBox setQualifierValue(Object qualifierValue) {
        this.qualifierValue = qualifierValue;
        return this;
    }
}

