/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jbeanbox;

import com.github.drinkjava2.cglib.proxy.Enhancer;
import com.github.drinkjava2.jbeanbox.BeanBox;
import com.github.drinkjava2.jbeanbox.BeanBoxContext;
import com.github.drinkjava2.jbeanbox.BeanBoxException;
import com.github.drinkjava2.jbeanbox.ProxyBean;

public class AopUtils {
    public static Object createProxyBean(Class<?> clazz, BeanBox box, BeanBoxContext ctx) {
        BeanBoxException.assureNotNull(clazz, "Try to create a proxy bean, but beanClass not found.");
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        if (box.getConstructorParams() != null && box.getConstructorParams().length > 0) {
            BeanBox[] boxes = box.getConstructorParams();
            Class[] argsTypes = new Class[boxes.length];
            Object[] realArgsValue = new Object[boxes.length];
            for (int i = 0; i < boxes.length; ++i) {
                argsTypes[i] = boxes[i].getType();
                Object realValue = ctx.getBean(boxes[i]);
                if (realValue instanceof String) {
                    realValue = ctx.getValueTranslator().translate((String)realValue, boxes[i].getType());
                }
                realArgsValue[i] = realValue;
            }
            enhancer.setCallback(new ProxyBean(box, ctx));
            return enhancer.create(argsTypes, realArgsValue);
        }
        enhancer.setCallback(new ProxyBean(box, ctx));
        return enhancer.create();
    }
}

