/*
 * Decompiled with CFR 0.152.
 */
package com.google.flatbuffers;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class Table {
    private static final ThreadLocal<CharsetDecoder> UTF8_DECODER = new ThreadLocal<CharsetDecoder>(){

        @Override
        protected CharsetDecoder initialValue() {
            return Charset.forName("UTF-8").newDecoder();
        }
    };
    private static final ThreadLocal<CharBuffer> CHAR_BUFFER = new ThreadLocal();
    protected int bb_pos;
    protected ByteBuffer bb;

    public ByteBuffer getByteBuffer() {
        return this.bb;
    }

    protected int __offset(int vtable_offset) {
        int vtable = this.bb_pos - this.bb.getInt(this.bb_pos);
        return vtable_offset < this.bb.getShort(vtable) ? (int)this.bb.getShort(vtable + vtable_offset) : 0;
    }

    protected int __indirect(int offset) {
        return offset + this.bb.getInt(offset);
    }

    protected String __string(int offset) {
        CharsetDecoder decoder = UTF8_DECODER.get();
        decoder.reset();
        offset += this.bb.getInt(offset);
        ByteBuffer src = this.bb.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        int length = src.getInt(offset);
        src.position(offset + 4);
        src.limit(offset + 4 + length);
        int required = (int)((float)length * decoder.maxCharsPerByte());
        CharBuffer dst = CHAR_BUFFER.get();
        if (dst == null || dst.capacity() < required) {
            dst = CharBuffer.allocate(required);
            CHAR_BUFFER.set(dst);
        }
        dst.clear();
        try {
            CoderResult cr = decoder.decode(src, dst, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        return dst.flip().toString();
    }

    protected int __vector_len(int offset) {
        offset += this.bb_pos;
        offset += this.bb.getInt(offset);
        return this.bb.getInt(offset);
    }

    protected int __vector(int offset) {
        return (offset += this.bb_pos) + this.bb.getInt(offset) + 4;
    }

    protected ByteBuffer __vector_as_bytebuffer(int vector_offset, int elem_size) {
        int o = this.__offset(vector_offset);
        if (o == 0) {
            return null;
        }
        ByteBuffer bb = this.bb.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        int vectorstart = this.__vector(o);
        bb.position(vectorstart);
        bb.limit(vectorstart + this.__vector_len(o) * elem_size);
        return bb;
    }

    protected Table __union(Table t, int offset) {
        t.bb_pos = (offset += this.bb_pos) + this.bb.getInt(offset);
        t.bb = this.bb;
        return t;
    }

    protected static boolean __has_identifier(ByteBuffer bb, String ident) {
        if (ident.length() != 4) {
            throw new AssertionError((Object)"FlatBuffers: file identifier must be length 4");
        }
        for (int i = 0; i < 4; ++i) {
            if (ident.charAt(i) == (char)bb.get(bb.position() + 4 + i)) continue;
            return false;
        }
        return true;
    }
}

