/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.extension.mybatis;

import com.gitee.starblues.extension.mybatis.configuration.SpringBootMybatisConfig;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.pipe.PluginPipeProcessorExtend;
import com.gitee.starblues.realize.BasePlugin;
import com.gitee.starblues.utils.OrderPriority;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.Alias;
import org.apache.ibatis.type.TypeAliasRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class PluginMybatisEntityProcessor
implements PluginPipeProcessorExtend {
    private static final Logger LOG = LoggerFactory.getLogger(PluginMybatisEntityProcessor.class);
    private static final String KEY = "PluginMybatisEntityProcessor";
    private static final String ALIAS_NAME_KEY = "mybatisAliasName";
    private final SqlSessionFactory sqlSessionFactory;

    PluginMybatisEntityProcessor(ApplicationContext mainApplicationContext) {
        this.sqlSessionFactory = (SqlSessionFactory)mainApplicationContext.getBean(SqlSessionFactory.class);
    }

    public String key() {
        return KEY;
    }

    public OrderPriority order() {
        return OrderPriority.getMiddlePriority();
    }

    public void initialize() throws Exception {
    }

    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        if (this.sqlSessionFactory == null) {
            LOG.warn("Mybatis SqlSessionFactory is null, Cannot register alias");
            return;
        }
        TypeAliasRegistry typeAliasRegistry = this.getTypeAliasRegistry();
        if (typeAliasRegistry == null) {
            return;
        }
        HashSet<String> mybatisAliasNames = (HashSet<String>)pluginRegistryInfo.getExtension(ALIAS_NAME_KEY);
        if (mybatisAliasNames == null) {
            mybatisAliasNames = new HashSet<String>();
            pluginRegistryInfo.addExtension(ALIAS_NAME_KEY, mybatisAliasNames);
        }
        this.processEntityClass(pluginRegistryInfo, typeAliasRegistry, mybatisAliasNames);
        this.processAliasMapping(pluginRegistryInfo, typeAliasRegistry, mybatisAliasNames);
    }

    private TypeAliasRegistry getTypeAliasRegistry() {
        Configuration configuration = this.sqlSessionFactory.getConfiguration();
        if (configuration == null) {
            LOG.warn("Mybatis Configuration is null, Cannot register alias");
            return null;
        }
        TypeAliasRegistry typeAliasRegistry = configuration.getTypeAliasRegistry();
        if (typeAliasRegistry == null) {
            LOG.warn("Mybatis TypeAliasRegistry is null, Cannot register alias");
            return null;
        }
        return typeAliasRegistry;
    }

    public void unRegistry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        TypeAliasRegistry typeAliasRegistry = this.getTypeAliasRegistry();
        if (typeAliasRegistry == null) {
            return;
        }
        Set mybatisAliasNames = (Set)pluginRegistryInfo.getExtension(ALIAS_NAME_KEY);
        if (mybatisAliasNames != null && !mybatisAliasNames.isEmpty()) {
            for (String mybatisAliasName : mybatisAliasNames) {
                Map<String, Class<?>> typeAliases = this.getTypeAliases(typeAliasRegistry);
                typeAliases.remove(mybatisAliasName);
            }
        }
    }

    private void processEntityClass(PluginRegistryInfo pluginRegistryInfo, TypeAliasRegistry typeAliasRegistry, Set<String> mybatisAliasNames) {
        List groupClasses = pluginRegistryInfo.getGroupClasses("plugin_mybatis_alias");
        if (groupClasses == null || groupClasses.isEmpty()) {
            return;
        }
        if (typeAliasRegistry == null) {
            return;
        }
        for (Class groupClass : groupClasses) {
            if (groupClass == null) continue;
            String aliasName = this.lowerFirstChar(groupClass.getSimpleName());
            Alias alias = groupClass.getAnnotation(Alias.class);
            if (alias != null && !StringUtils.isEmpty((Object)alias.value())) {
                aliasName = alias.value();
            }
            if (StringUtils.isEmpty((Object)aliasName)) continue;
            this.registerAlias(typeAliasRegistry, aliasName, groupClass);
            mybatisAliasNames.add(aliasName);
        }
    }

    private void processAliasMapping(PluginRegistryInfo pluginRegistryInfo, TypeAliasRegistry typeAliasRegistry, Set<String> mybatisAliasNames) {
        BasePlugin basePlugin = pluginRegistryInfo.getBasePlugin();
        if (basePlugin instanceof SpringBootMybatisConfig) {
            SpringBootMybatisConfig config = (SpringBootMybatisConfig)basePlugin;
            Map<String, Class> aliasMapping = config.aliasMapping();
            if (aliasMapping == null || aliasMapping.isEmpty()) {
                return;
            }
            aliasMapping.forEach((k, v) -> {
                this.registerAlias(typeAliasRegistry, (String)k, (Class<?>)v);
                mybatisAliasNames.add((String)k);
            });
        }
    }

    private void registerAlias(TypeAliasRegistry typeAliasRegistry, String alias, Class<?> value) {
        if (StringUtils.isEmpty((Object)alias)) {
            return;
        }
        Map<String, Class<?>> typeAliases = this.getTypeAliases(typeAliasRegistry);
        typeAliases.put(alias, value);
    }

    private Map<String, Class<?>> getTypeAliases(TypeAliasRegistry typeAliasRegistry) {
        if (typeAliasRegistry == null) {
            return null;
        }
        try {
            Field field = typeAliasRegistry.getClass().getDeclaredField("typeAliases");
            field.setAccessible(true);
            Object fieldObject = field.get(typeAliasRegistry);
            if (fieldObject instanceof Map) {
                return (Map)fieldObject;
            }
            LOG.warn("Not found TypeAliasRegistry typeAliases");
            return null;
        }
        catch (Exception e) {
            LOG.error("Found TypeAliasRegistry typeAliases exception. {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private String lowerFirstChar(String str) {
        char[] chars = str.toCharArray();
        chars[0] = (char)(chars[0] + 32);
        return String.valueOf(chars);
    }
}

