/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.extension.mybatis;

import com.gitee.starblues.extension.mybatis.configuration.SpringBootMybatisConfig;
import com.gitee.starblues.factory.process.pipe.classs.PluginClassGroupExtend;
import com.gitee.starblues.realize.BasePlugin;
import com.gitee.starblues.utils.AnnotationsUtils;
import java.util.Set;
import org.apache.ibatis.type.Alias;

public class PluginEntityAliasesGroup
implements PluginClassGroupExtend {
    public static final String KEY = "plugin_mybatis_alias";
    private Set<String> typeAliasesPackage;

    public String groupId() {
        return KEY;
    }

    public void initialize(BasePlugin basePlugin) {
        if (basePlugin instanceof SpringBootMybatisConfig) {
            SpringBootMybatisConfig config = (SpringBootMybatisConfig)basePlugin;
            this.typeAliasesPackage = config.typeAliasesPackage();
        }
    }

    public boolean filter(Class<?> aClass) {
        if (AnnotationsUtils.haveAnnotations(aClass, (boolean)false, (Class[])new Class[]{Alias.class})) {
            return true;
        }
        if (this.typeAliasesPackage == null || this.typeAliasesPackage.isEmpty()) {
            return false;
        }
        for (String packageName : this.typeAliasesPackage) {
            if (!aClass.getPackage().getName().equals(packageName)) continue;
            return true;
        }
        return false;
    }

    public String key() {
        return "PluginEntityAliasesGroup";
    }
}

