/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.plugins.cache.common.config;

import com.gccloud.starter.plugins.cache.common.config.StarterCacheTypeConfig;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="gc.starter.cache")
public class StarterCacheConfig {
    private static final Logger log = LoggerFactory.getLogger(StarterCacheConfig.class);
    private String prefix = "gc";
    private Boolean initLoad = true;
    private List<StarterCacheTypeConfig> typeConfigList = Lists.newArrayList();
    private final Map<String, StarterCacheTypeConfig> typeConfigMap = Maps.newHashMap();

    public void setTypeConfigList(List<StarterCacheTypeConfig> typeConfigList) {
        this.typeConfigList = typeConfigList;
        if (typeConfigList != null) {
            log.info("----------------------------------------");
            typeConfigList.forEach(typeConfig -> {
                log.info("{} \u7c7b\u578b\u7f13\u5b58\u914d\u7f6e: {}", (Object)typeConfig.getType(), typeConfig);
                this.typeConfigMap.put(typeConfig.getType(), (StarterCacheTypeConfig)typeConfig);
            });
            log.info("----------------------------------------");
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Boolean getInitLoad() {
        return this.initLoad;
    }

    public List<StarterCacheTypeConfig> getTypeConfigList() {
        return this.typeConfigList;
    }

    public Map<String, StarterCacheTypeConfig> getTypeConfigMap() {
        return this.typeConfigMap;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setInitLoad(Boolean initLoad) {
        this.initLoad = initLoad;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StarterCacheConfig)) {
            return false;
        }
        StarterCacheConfig other = (StarterCacheConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$initLoad = this.getInitLoad();
        Boolean other$initLoad = other.getInitLoad();
        if (this$initLoad == null ? other$initLoad != null : !((Object)this$initLoad).equals(other$initLoad)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        List<StarterCacheTypeConfig> this$typeConfigList = this.getTypeConfigList();
        List<StarterCacheTypeConfig> other$typeConfigList = other.getTypeConfigList();
        if (this$typeConfigList == null ? other$typeConfigList != null : !((Object)this$typeConfigList).equals(other$typeConfigList)) {
            return false;
        }
        Map<String, StarterCacheTypeConfig> this$typeConfigMap = this.getTypeConfigMap();
        Map<String, StarterCacheTypeConfig> other$typeConfigMap = other.getTypeConfigMap();
        return !(this$typeConfigMap == null ? other$typeConfigMap != null : !((Object)this$typeConfigMap).equals(other$typeConfigMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StarterCacheConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $initLoad = this.getInitLoad();
        result = result * 59 + ($initLoad == null ? 43 : ((Object)$initLoad).hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        List<StarterCacheTypeConfig> $typeConfigList = this.getTypeConfigList();
        result = result * 59 + ($typeConfigList == null ? 43 : ((Object)$typeConfigList).hashCode());
        Map<String, StarterCacheTypeConfig> $typeConfigMap = this.getTypeConfigMap();
        result = result * 59 + ($typeConfigMap == null ? 43 : ((Object)$typeConfigMap).hashCode());
        return result;
    }

    public String toString() {
        return "StarterCacheConfig(prefix=" + this.getPrefix() + ", initLoad=" + this.getInitLoad() + ", typeConfigList=" + this.getTypeConfigList() + ", typeConfigMap=" + this.getTypeConfigMap() + ")";
    }
}

