/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.plugins.cache.common;

import com.gccloud.starter.plugins.cache.common.CacheUtils;
import com.gccloud.starter.plugins.cache.common.config.StarterCacheConfig;
import com.gccloud.starter.plugins.cache.common.config.StarterCacheTypeConfig;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StarterL1Cache {
    @Autowired
    private StarterCacheConfig cacheConfig;
    private static final Cache<Serializable, Cache<Serializable, Object>> L1 = Caffeine.newBuilder().build();

    public void put(String type, Serializable key, Object val) {
        Cache cache = (Cache)L1.get((Object)type, k -> {
            StarterCacheTypeConfig typeConfig = this.cacheConfig.getTypeConfigMap().get(type);
            if (typeConfig == null || null == typeConfig.getTtl() || typeConfig.getTtl() <= 0) {
                Cache typeCache = Caffeine.newBuilder().build();
                return typeCache;
            }
            Integer ttl = typeConfig.getTtl();
            Cache typeCache = Caffeine.newBuilder().expireAfterWrite((long)ttl.intValue(), TimeUnit.SECONDS).build();
            return typeCache;
        });
        StarterCacheTypeConfig typeConfig = this.cacheConfig.getTypeConfigMap().get(type);
        if (typeConfig != null) {
            Object newVal = CacheUtils.convert(val, typeConfig.getClassName());
            cache.put((Object)key, newVal);
            return;
        }
        cache.put((Object)key, val);
    }

    public <T> T get(String type, Serializable key, Class<T> responseType) {
        Cache cache = (Cache)L1.getIfPresent((Object)type);
        if (cache == null) {
            return null;
        }
        Object val = cache.getIfPresent((Object)key);
        if (val == null) {
            return null;
        }
        return CacheUtils.convert(val, responseType);
    }

    public <T> List<T> getAll(String type, Class<T> responseType) {
        Cache cache = (Cache)L1.getIfPresent((Object)type);
        if (cache == null) {
            return Lists.newArrayList();
        }
        ArrayList respList = Lists.newArrayList();
        cache.asMap().forEach((k, val) -> {
            Object t = CacheUtils.convert(val, responseType);
            respList.add(t);
        });
        return respList;
    }

    public void invalidate(String type, Serializable key) {
        Cache cache = (Cache)L1.getIfPresent((Object)type);
        if (cache == null) {
            return;
        }
        cache.invalidate((Object)key);
    }

    public void invalidateAll(String type) {
        Cache cache = (Cache)L1.getIfPresent((Object)type);
        if (cache == null) {
            return;
        }
        cache.invalidateAll();
    }
}

