/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.plugins.cache.common;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUtils {
    private static final Logger log = LoggerFactory.getLogger(CacheUtils.class);
    private static final String LONG = "java.lang.Long";
    private static final String DOUBLE = "java.lang.Double";
    private static final String FLOAT = "java.lang.Float";
    private static final String INTEGER = "java.lang.Integer";
    private static final String BOOLEAN = "java.lang.Boolean";
    private static final String STRING = "java.lang.String";
    private static final Map<String, Class> CLASS_MAP = Maps.newHashMap();

    public static Class getClass(String targetClassName) {
        Class clazz = CLASS_MAP.computeIfAbsent(targetClassName, k -> {
            try {
                return Class.forName(targetClassName);
            }
            catch (ClassNotFoundException e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                return null;
            }
        });
        return clazz;
    }

    public static Object convert(Object val, String targetClassName) {
        String currentClassName = val.getClass().getName();
        if (currentClassName.equals(targetClassName)) {
            return val;
        }
        if (LONG.equals(targetClassName)) {
            return LONG.equals(currentClassName) ? val : Long.valueOf(val.toString());
        }
        if (DOUBLE.equals(targetClassName)) {
            return DOUBLE.equals(currentClassName) ? val : String.valueOf(val.toString());
        }
        if (FLOAT.equals(targetClassName)) {
            return FLOAT.equals(currentClassName) ? val : Float.valueOf(val.toString());
        }
        if (INTEGER.equals(targetClassName)) {
            return INTEGER.equals(currentClassName) ? val : Integer.valueOf(val.toString());
        }
        if (BOOLEAN.equals(targetClassName)) {
            return BOOLEAN.equals(currentClassName) ? val : Boolean.valueOf(val.toString());
        }
        if (STRING.equals(targetClassName)) {
            return STRING.equals(currentClassName) ? val : val.toString();
        }
        if (STRING.equals(currentClassName)) {
            Class targetClass = CacheUtils.getClass(targetClassName);
            Object newVal = JSON.parseObject((String)val.toString(), (Class)targetClass);
            return newVal;
        }
        return val;
    }

    public static <T> T convert(Object val, Class<T> targetClass) {
        String className = targetClass.getName();
        if (String.class.getName().equals(className)) {
            return (T)(val instanceof String ? val : val.toString());
        }
        if (Double.class.getName().equals(className)) {
            return (T)(val instanceof Double ? val : Double.valueOf(val.toString()));
        }
        if (Float.class.getName().equals(className)) {
            return (T)(val instanceof Float ? val : Float.valueOf(val.toString()));
        }
        if (Integer.class.getName().equals(className)) {
            return (T)(val instanceof Integer ? val : Integer.valueOf(val.toString()));
        }
        if (Long.class.getName().equals(className)) {
            return (T)(val instanceof Long ? val : Long.valueOf(val.toString()));
        }
        if (Boolean.class.getName().equals(className)) {
            return (T)(val instanceof Boolean ? val : Boolean.valueOf(val.toString()));
        }
        if (val instanceof String) {
            return (T)JSON.parseObject((String)val.toString(), targetClass);
        }
        return (T)val;
    }

    public static String toString(Object val) {
        String className = val.getClass().getName();
        if (String.class.getName().equals(className)) {
            return (String)val;
        }
        if (Double.class.getName().equals(className)) {
            return val.toString();
        }
        if (Float.class.getName().equals(className)) {
            return val.toString();
        }
        if (Integer.class.getName().equals(className)) {
            return val.toString();
        }
        if (Long.class.getName().equals(className)) {
            return val.toString();
        }
        if (Boolean.class.getName().equals(className)) {
            return val.toString();
        }
        return JSON.toJSONString((Object)val);
    }
}

