/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.service.impl.dataset;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.utils.JSON;
import com.gccloud.common.vo.PageVO;
import com.gccloud.dataset.constant.DatasetConstant;
import com.gccloud.dataset.dao.DatasetDao;
import com.gccloud.dataset.dto.DatasetParamDTO;
import com.gccloud.dataset.dto.TestExecuteDTO;
import com.gccloud.dataset.entity.DatasetEntity;
import com.gccloud.dataset.entity.DatasourceEntity;
import com.gccloud.dataset.entity.config.BaseDataSetConfig;
import com.gccloud.dataset.entity.config.OriginalDataSetConfig;
import com.gccloud.dataset.extend.dataset.DatasetExtendClient;
import com.gccloud.dataset.permission.DatasetPermissionClient;
import com.gccloud.dataset.service.IBaseDataSetService;
import com.gccloud.dataset.service.IBaseDatasourceService;
import com.gccloud.dataset.service.factory.DatasourceServiceFactory;
import com.gccloud.dataset.service.impl.datasource.BaseDatasourceServiceImpl;
import com.gccloud.dataset.vo.DataVO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="original")
public class OriginalDataSetServiceImpl
extends ServiceImpl<DatasetDao, DatasetEntity>
implements IBaseDataSetService {
    private static final Logger log = LoggerFactory.getLogger(OriginalDataSetServiceImpl.class);
    @Resource
    private DatasourceServiceFactory datasourceServiceFactory;
    @Resource
    private BaseDatasourceServiceImpl datasourceService;
    @Resource
    private DatasetPermissionClient datasetPermissionClient;
    @Resource
    private DatasetExtendClient datasetExtendClient;

    @Override
    public String add(DatasetEntity entity) {
        OriginalDataSetConfig config = (OriginalDataSetConfig)entity.getConfig();
        entity.setCode(config.getTableName());
        String id = IBaseDataSetService.super.add(entity);
        if (this.datasetPermissionClient.hasPermissionService()) {
            this.datasetPermissionClient.addPermission(id);
        }
        return id;
    }

    @Override
    public void delete(String id) {
        IBaseDataSetService.super.delete(id);
        if (this.datasetPermissionClient.hasPermissionService()) {
            this.datasetPermissionClient.deletePermission(id);
        }
    }

    public PageVO execute(String id, List<DatasetParamDTO> params, int current, int size) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new GlobalException("\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DatasetEntity entity = this.getByIdFromCache(id);
        if (entity == null) {
            throw new GlobalException("\u6570\u636e\u96c6\u4e0d\u5b58\u5728");
        }
        long startTime = System.currentTimeMillis();
        OriginalDataSetConfig config = (OriginalDataSetConfig)entity.getConfig();
        StringBuilder fieldInfo = new StringBuilder(config.getFieldInfo());
        if (StringUtils.isBlank((CharSequence)fieldInfo.toString())) {
            List<Map<String, Object>> fieldList = config.getFieldList();
            for (Map<String, Object> field : fieldList) {
                String fieldName = (String)field.get("fieldName");
                fieldInfo.append(fieldName).append(",");
            }
            fieldInfo.deleteCharAt(fieldInfo.length() - 1);
        }
        String dataSourceId = config.getSourceId();
        DatasourceEntity datasource = this.datasourceService.getInfoById(dataSourceId);
        String sourceType = datasource.getSourceType();
        fieldInfo = new StringBuilder(this.handleSpecialField(fieldInfo.toString(), sourceType));
        if (DatasetConstant.DataRepeat.NOT_REPEAT.equals(config.getRepeatStatus())) {
            fieldInfo.insert(0, "DISTINCT ");
        }
        String sql = "SELECT " + fieldInfo + " FROM " + config.getTableName();
        IBaseDatasourceService buildService = this.datasourceServiceFactory.build(datasource.getSourceType());
        log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u539f\u59cb\u3011\uff0cID:\u3010{}\u3011\uff09\uff0c URL\uff1a\u3010{}\u3011\uff0c \u6267\u884cSQL\uff1a\u3010{}\u3011", new Object[]{entity.getName(), entity.getId(), datasource.getUrl(), sql});
        DataVO dataVO = buildService.executeSqlPage(datasource, sql, current, size);
        PageVO data = (PageVO)dataVO.getData();
        List<Map<String, Object>> list = data.getList();
        list = this.datasetExtendClient.handleData(list, entity);
        data.setList(list);
        long endTime = System.currentTimeMillis();
        log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u539f\u59cb\u3011\uff0cID:\u3010{}\u3011\uff09\uff0c\u8017\u65f6\uff1a\u3010{}\u3011ms", new Object[]{entity.getName(), entity.getId(), endTime - startTime});
        return data;
    }

    @Override
    public Object execute(String id, List<DatasetParamDTO> params) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new GlobalException("\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DatasetEntity entity = this.getByIdFromCache(id);
        if (entity == null) {
            throw new GlobalException("\u6570\u636e\u96c6\u4e0d\u5b58\u5728");
        }
        if (DatasetConstant.DatasetCache.OPEN.equals(entity.getCache())) {
            CompletableFuture future = DATASET_CACHE.get((Object)id, key -> this.getData(entity));
            try {
                return future.get();
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u96c6\u7f13\u5b58\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return this.getData(entity);
    }

    private Object getData(DatasetEntity entity) {
        long startTime = System.currentTimeMillis();
        OriginalDataSetConfig config = (OriginalDataSetConfig)entity.getConfig();
        String fieldInfo = config.getFieldInfo();
        if (StringUtils.isBlank((CharSequence)fieldInfo)) {
            List<Map<String, Object>> fieldList = config.getFieldList();
            StringBuilder fieldInfoBuilder = new StringBuilder();
            for (Map<String, Object> field : fieldList) {
                String fieldName = (String)field.get("fieldName");
                fieldInfoBuilder.append(fieldName).append(",");
            }
            fieldInfo = fieldInfoBuilder.deleteCharAt(fieldInfoBuilder.length() - 1).toString();
        }
        String dataSourceId = config.getSourceId();
        DatasourceEntity datasource = this.datasourceService.getInfoById(dataSourceId);
        String sourceType = datasource.getSourceType();
        fieldInfo = this.handleSpecialField(fieldInfo, sourceType);
        if (DatasetConstant.DataRepeat.NOT_REPEAT.equals(config.getRepeatStatus())) {
            fieldInfo = "DISTINCT " + fieldInfo;
        }
        String sql = "SELECT " + fieldInfo + " FROM " + config.getTableName();
        log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u539f\u59cb\u3011\uff0cID:\u3010{}\u3011\uff09\uff0c URL\uff1a\u3010{}\u3011\uff0c \u6267\u884cSQL\uff1a\u3010{}\u3011", new Object[]{entity.getName(), entity.getId(), datasource.getUrl(), sql});
        IBaseDatasourceService buildService = this.datasourceServiceFactory.build(sourceType);
        DataVO dataVO = buildService.executeSql(datasource, sql);
        List<Map<String, Object>> list = (List<Map<String, Object>>)dataVO.getData();
        list = this.datasetExtendClient.handleData(list, entity);
        long endTime = System.currentTimeMillis();
        log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u539f\u59cb\u3011\uff0cID:\u3010{}\u3011\uff09\uff0c\u8017\u65f6\uff1a\u3010{}\u3011ms", new Object[]{entity.getName(), entity.getId(), endTime - startTime});
        return list;
    }

    @Override
    public DataVO execute(TestExecuteDTO executeDTO) {
        String jsonString = executeDTO.getScript();
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            throw new GlobalException("\u6570\u636e\u96c6\u914d\u7f6e\u5f02\u5e38");
        }
        long startTime = System.currentTimeMillis();
        JSONObject originalTest = JSON.parseObject((String)jsonString);
        JSONArray fieldArray = originalTest.getJSONArray("fieldInfo");
        String fieldInfo = "";
        for (Object o : fieldArray) {
            String field = (String)o;
            fieldInfo = fieldInfo + field + ",";
        }
        fieldInfo = StringUtils.isBlank((CharSequence)fieldInfo) ? "*" : fieldInfo.substring(0, fieldInfo.length() - 1);
        String dataSourceId = executeDTO.getDataSourceId();
        DatasourceEntity datasource = this.datasourceService.getInfoById(dataSourceId);
        String sourceType = datasource.getSourceType();
        fieldInfo = this.handleSpecialField(fieldInfo, sourceType);
        String sql = "SELECT ";
        if (DatasetConstant.DataRepeat.NOT_REPEAT.equals(originalTest.getInt("repeatStatus"))) {
            sql = sql + "DISTINCT ";
        }
        sql = sql + fieldInfo + " FROM " + originalTest.getString("tableName");
        IBaseDatasourceService buildService = this.datasourceServiceFactory.build(datasource.getSourceType());
        Integer current = executeDTO.getCurrent();
        Integer size = executeDTO.getSize();
        log.info("\u6d4b\u8bd5\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u539f\u59cb\u3011\uff09\uff0c URL\uff1a\u3010{}\u3011\uff0c \u6267\u884cSQL\uff1a\u3010{}\u3011", (Object)datasource.getUrl(), (Object)sql);
        DataVO dataVO = size != null && current != null ? buildService.executeSqlPage(datasource, sql, current, size) : buildService.executeSql(datasource, sql);
        long endTime = System.currentTimeMillis();
        log.info("\u6d4b\u8bd5\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u539f\u59cb\u3011\uff09\u7ed3\u675f\uff0c\u8017\u65f6\uff1a\u3010{}\u3011ms", (Object)(endTime - startTime));
        return dataVO;
    }

    private String handleSpecialField(String fieldInfo, String sourceType) {
        if ("*".equals(fieldInfo)) {
            return fieldInfo;
        }
        ArrayList fieldList = Lists.newArrayList((Object[])fieldInfo.split(","));
        StringBuilder fields = new StringBuilder();
        for (String field : fieldList) {
            if (field.matches("^[a-zA-Z0-9_]+$")) {
                fields.append(field).append(",");
                continue;
            }
            if (field.startsWith("`") && field.endsWith("`")) {
                fields.append(field).append(",");
                continue;
            }
            if (field.startsWith("\"") && field.endsWith("\"")) {
                fields.append(field).append(",");
                continue;
            }
            switch (sourceType.toLowerCase()) {
                case "mysql": 
                case "clickhouse": {
                    field = field.replace(field, "`" + field + "`");
                    break;
                }
                case "oracle": 
                case "postgresql": {
                    field = field.replace(field, "\"" + field + "\"");
                    break;
                }
            }
            fields.append(field).append(",");
        }
        return fields.substring(0, fields.length() - 1);
    }

    public List<DatasetEntity> getListByTableName(String tableName, String sourceId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DatasetEntity::getDatasetType, (Object)"original");
        queryWrapper.eq(DatasetEntity::getSourceId, (Object)sourceId);
        queryWrapper.like(DatasetEntity::getCode, (Object)tableName);
        List list = this.list((Wrapper)queryWrapper);
        list.removeIf(datasetEntity -> {
            BaseDataSetConfig config = datasetEntity.getConfig();
            if (!(config instanceof OriginalDataSetConfig)) {
                return true;
            }
            OriginalDataSetConfig originalConfig = (OriginalDataSetConfig)config;
            return !originalConfig.getSourceId().equals(sourceId) || !originalConfig.getTableName().equals(tableName);
        });
        return list;
    }
}

