/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.tools;

import com.sforce.ws.tools.wsdlc;
import java.io.File;
import java.io.FilenameFilter;
import org.stringtemplate.v4.STGroupDir;

public class WsdlcIterator {
    private static final String WsdlSuffix = ".wsdl";
    private static final String UniqueJarSuffix = ".apextest.jar";
    private static final FilenameFilter WsdlFilter = new FilenameFilter(){

        @Override
        public boolean accept(File unused, String name) {
            if (name == null) {
                return false;
            }
            return name.endsWith(WsdlcIterator.WsdlSuffix);
        }
    };

    public static void main(String[] args) {
        String packagePrefix = System.getProperty("package-prefix");
        boolean standAlone = Boolean.parseBoolean(System.getProperty("standalone-jar", "false"));
        boolean javaTime = Boolean.parseBoolean(System.getProperty("java-time", "false"));
        WsdlcIterator.consoleMessage("Beginning run of multiple calls to wsdlc");
        if (args.length != 4) {
            WsdlcIterator.showMainUsage();
            System.exit(2);
        }
        if (!"wsdldir".equalsIgnoreCase(args[0]) || !"jardir".equalsIgnoreCase(args[2])) {
            WsdlcIterator.showMainUsage();
            System.exit(2);
        }
        String wsdlDir = args[1];
        String jarDir = args[3];
        try {
            int ix;
            File wDir = new File(wsdlDir).getCanonicalFile();
            File jDir = new File(jarDir).getCanonicalFile();
            if (!wDir.exists() || !wDir.isDirectory()) {
                WsdlcIterator.consoleMessage("###  Input wsdldir '" + wsdlDir + "' does not exist or is not a directory");
                WsdlcIterator.showMainUsage();
                System.exit(1);
            }
            if (!jDir.exists() || !jDir.isDirectory()) {
                WsdlcIterator.consoleMessage("###  Input jardir '" + jarDir + "' does not exist or is not a directory");
                WsdlcIterator.showMainUsage();
                System.exit(1);
            }
            wsdlDir = wDir.getCanonicalPath();
            jarDir = jDir.getCanonicalPath();
            String[] wsdlFiles = wDir.list(WsdlFilter);
            if (wsdlFiles == null || wsdlFiles.length == 0) {
                WsdlcIterator.consoleMessage("###  Input wsdldir '" + wsdlDir + "' does not contain any " + WsdlSuffix + " files.");
                WsdlcIterator.showMainUsage();
                System.exit(1);
            }
            for (String aWsdl : wsdlFiles) {
                if (aWsdl.endsWith(WsdlSuffix)) continue;
                WsdlcIterator.consoleMessage("###  Software Error: Input wsdldir '" + wsdlDir + "' produced listing of non-wsdl file '" + aWsdl + "'");
                WsdlcIterator.showMainUsage();
                System.exit(1);
            }
            String[] jarFiles = new String[wsdlFiles.length];
            String[] wsdlPaths = new String[wsdlFiles.length];
            for (ix = 0; ix < wsdlFiles.length; ++ix) {
                String jarName = wsdlFiles[ix].replace(WsdlSuffix, UniqueJarSuffix);
                jarFiles[ix] = new File(jarDir, jarName).getCanonicalPath();
                wsdlPaths[ix] = new File(wDir, wsdlFiles[ix]).getCanonicalPath();
            }
            for (ix = 0; ix < wsdlFiles.length; ++ix) {
                File aJar = new File(jarFiles[ix]);
                if (!aJar.exists()) continue;
                WsdlcIterator.consoleMessage("Deleting existing " + aJar.getAbsolutePath());
                aJar.delete();
            }
            STGroupDir templates = new STGroupDir(wsdlc.TEMPLATE_DIR, '$', '$');
            for (int ix2 = 0; ix2 < wsdlFiles.length; ++ix2) {
                WsdlcIterator.consoleMessage("Running wsdlc on " + wsdlPaths[ix2] + "\n       to create " + jarFiles[ix2]);
                wsdlc.run(wsdlPaths[ix2], jarFiles[ix2], packagePrefix, javaTime, standAlone, templates, null, true);
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
            System.exit(1);
        }
    }

    private static final void consoleMessage(String message) {
        System.out.println("[WsdlcIterator]    " + message);
    }

    private static void showMainUsage() {
        System.out.println("Usage:  WsdlcIterator wsdldir <dir> jardir <dir>");
        System.out.println("        wsdldir = The directory into which ApexWebServiceTestExposer (or other source) has placed all the wsdl files it creates. This tool will pass all wsdl files therein to com.sforce.ws.tools.wsdlc,");
        System.out.println("        jardir  = The directory to which the resulting jars will be written.");
    }
}

