/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.wsdl.Attribute;
import com.sforce.ws.wsdl.Collection;
import com.sforce.ws.wsdl.Constants;
import com.sforce.ws.wsdl.ParserUtil;
import com.sforce.ws.wsdl.Schema;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class ComplexType
implements Constants {
    private String name;
    private Collection content;
    private QName base;
    private Schema schema;
    private boolean isHeader;
    private ArrayList<Attribute> attributes = new ArrayList();

    public ComplexType(Schema schema) {
        this.schema = schema;
    }

    public ComplexType(Schema schema, String name) {
        this.schema = schema;
        this.name = name;
    }

    public Collection getContent() {
        return this.content;
    }

    public QName getBase() {
        return this.base;
    }

    public boolean hasBaseClass() {
        return this.isHeader || this.base != null;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setHeader(boolean isHeader) {
        this.isHeader = isHeader;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public Iterator<Attribute> getAttributes() {
        return this.attributes.iterator();
    }

    public String toString() {
        return "ComplexType{name='" + this.name + '\'' + ", content=" + this.content + ", base=" + this.base + ", attributes=" + this.attributes + '}';
    }

    public void read(WsdlParser parser, String elementName) throws WsdlParseException {
        this.name = parser.getAttributeValue(null, "name");
        if (this.name == null) {
            this.name = elementName;
        }
        if (this.name == null) {
            throw new WsdlParseException("complexType->elementName can not be null. " + parser.getPositionDescription());
        }
        int eventType = parser.getEventType();
        while (true) {
            String namespace;
            String name;
            if (eventType == 2) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if (("sequence".equals(name) || "all".equals(name) || "choice".equals(name)) && "http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                    this.content = new Collection(this.schema, name);
                    this.content.read(parser);
                } else if ("extension".equals(name) && "http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                    name = parser.getAttributeValue(null, "base");
                    if (name != null) {
                        this.base = ParserUtil.toQName(name, parser);
                    }
                } else if ("attribute".equals(name) && "http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                    Attribute attribute = new Attribute(this.schema);
                    attribute.read(parser);
                    this.addAttribute(attribute);
                }
            } else if (eventType == 3) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if ("complexType".equals(name) && "http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                    return;
                }
            } else if (eventType == 1) {
                throw new WsdlParseException("Failed to find end tag for 'complexType'");
            }
            eventType = parser.next();
        }
    }

    private void addAttribute(Attribute attribute) throws WsdlParseException {
        String name = attribute.getName();
        for (Attribute att : this.attributes) {
            if (!name.equals(att.getName())) continue;
            throw new WsdlParseException("Two attributes cannot have the same name: " + name);
        }
        this.attributes.add(attribute);
    }

    public String getName() {
        return this.name;
    }
}

