/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.bulk;

import com.sforce.bulk.StreamException;
import com.sforce.bulk.StreamHandler;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.transport.Transport;
import com.sforce.ws.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LoginHelper {
    private StreamHandler handler;

    LoginHelper(StreamHandler handler) {
        this.handler = handler;
    }

    void doLogin() throws IOException, StreamException {
        Transport transport;
        this.handler.info("Calling login on: " + this.handler.getConfig().getAuthEndpoint());
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><env:Body><m:login xmlns:m=\"urn:partner.soap.sforce.com\" xmlns:sobj=\"urn:sobject.partner.soap.sforce.com\"><m:username>" + this.handler.getConfig().getUsername() + "</m:username><m:password>" + this.handler.getConfig().getPassword() + "</m:password></m:login></env:Body></env:Envelope>";
        try {
            transport = this.handler.getConfig().createTransport();
        }
        catch (ConnectionException x) {
            throw new IOException(String.format("Cannot create transport %s", this.handler.getConfig().getTransport()), x);
        }
        OutputStream out = transport.connect(this.handler.getConfig().getAuthEndpoint(), "");
        out.write(request.getBytes());
        out.close();
        InputStream input = transport.getContent();
        String response = new String(FileUtil.toBytes(input));
        String sessionId = this.getValueForTag("sessionId", response);
        this.handler.getConfig().setSessionId(sessionId);
        this.handler.info("Session Id: " + sessionId);
        String serverUrl = this.getValueForTag("serverUrl", response);
        if (sessionId == null || serverUrl == null) {
            throw new StreamException("Failed to login " + response);
        }
        this.setBulkUrl(response, serverUrl);
    }

    private void setBulkUrl(String response, String serverUrl) throws StreamException {
        String partnerTag = "/services/Soap/u/";
        int index = serverUrl.indexOf(partnerTag);
        if (index == -1) {
            throw new StreamException("Unknown serverUrl " + serverUrl + "in response " + response);
        }
        String bulkUrl = serverUrl.substring(0, index);
        int verIndex = index + partnerTag.length();
        String version = serverUrl.substring(verIndex, verIndex + 4);
        bulkUrl = bulkUrl + "/services/async/" + version + "/";
        this.handler.getConfig().setRestEndpoint(bulkUrl);
        this.handler.info("Bulk API Server Url :" + bulkUrl);
    }

    private String getValueForTag(String tag, String response) {
        int end;
        String value = null;
        int index = response.indexOf("<" + tag + ">");
        if (index != -1 && (end = response.indexOf("</" + tag + ">")) != -1) {
            value = response.substring(index + tag.length() + 2, end);
        }
        return value;
    }
}

