/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.spring.support.qiniu;

import com.baidu.ueditor.spring.EditorController;
import com.baidu.ueditor.spring.support.qiniu.Total;
import com.google.gson.Gson;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.common.ZoneReqInfo;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.util.Auth;
import com.qiniu.util.UrlSafeBase64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.springframework.web.multipart.MultipartFile;

public class QiniuUtils {
    public static String upload(MultipartFile file, String fileName) {
        String zoneStr = EditorController.properties.getQiniu().getZone();
        Zone zone = QiniuUtils.getByName(zoneStr);
        Configuration cfg = new Configuration(zone);
        UploadManager uploadManager = new UploadManager(cfg);
        String accessKey = EditorController.properties.getQiniu().getAccessKey();
        String secretKey = EditorController.properties.getQiniu().getSecretKey();
        String bucket = EditorController.properties.getQiniu().getBucket();
        try {
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(file.getBytes());
            Auth auth = Auth.create((String)accessKey, (String)secretKey);
            String upToken = auth.uploadToken(bucket);
            try {
                com.qiniu.http.Response response = uploadManager.put((InputStream)byteInputStream, fileName, upToken, null, null);
                DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
                return EditorController.properties.getQiniu().getCdn() + putRet.key;
            }
            catch (QiniuException ex) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(InputStream inputStream, String fileName) {
        String zoneStr = EditorController.properties.getQiniu().getZone();
        Zone zone = QiniuUtils.getByName(zoneStr);
        Configuration cfg = new Configuration(zone);
        UploadManager uploadManager = new UploadManager(cfg);
        String accessKey = EditorController.properties.getQiniu().getAccessKey();
        String secretKey = EditorController.properties.getQiniu().getSecretKey();
        String bucket = EditorController.properties.getQiniu().getBucket();
        try {
            Auth auth = Auth.create((String)accessKey, (String)secretKey);
            String upToken = auth.uploadToken(bucket);
            try {
                com.qiniu.http.Response response = uploadManager.put(inputStream, fileName, upToken, null, null);
                DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
                String string = EditorController.properties.getQiniu().getCdn() + putRet.key;
                return string;
            }
            catch (QiniuException ex) {
                String string = null;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return string;
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String upload(String content, String fileName) {
        String zoneStr = EditorController.properties.getQiniu().getZone();
        Zone zone = QiniuUtils.getByName(zoneStr);
        String accessKey = EditorController.properties.getQiniu().getAccessKey();
        String secretKey = EditorController.properties.getQiniu().getSecretKey();
        String bucket = EditorController.properties.getQiniu().getBucket();
        String url = zone.getUpBackupHttp(new ZoneReqInfo(accessKey, bucket)) + "/putb64/-1/key/" + UrlSafeBase64.encodeToString((String)fileName);
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        String upToken = auth.uploadToken(bucket);
        RequestBody rb = RequestBody.create(null, (String)content);
        Request request = new Request.Builder().url(url).addHeader("Content-Type", "application/octet-stream").addHeader("Authorization", "UpToken " + upToken).post(rb).build();
        OkHttpClient client = new OkHttpClient();
        Response response = null;
        try {
            response = client.newCall(request).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.body().charStream(), DefaultPutRet.class);
        if (putRet.key == null) {
            return null;
        }
        return EditorController.properties.getQiniu().getCdn() + putRet.key;
    }

    public static List<String> listFile(String prefix, int index, int size, Total total) {
        Configuration cfg = new Configuration(Zone.zone0());
        String accessKey = EditorController.properties.getQiniu().getAccessKey();
        String secretKey = EditorController.properties.getQiniu().getSecretKey();
        String bucket = EditorController.properties.getQiniu().getBucket();
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        BucketManager bucketManager = new BucketManager(auth, cfg);
        int limit = 1000;
        String delimiter = "";
        BucketManager.FileListIterator fileListIterator = bucketManager.createFileListIterator(bucket, prefix, limit, delimiter);
        FileInfo[] items = null;
        if (fileListIterator.hasNext()) {
            items = fileListIterator.next();
        }
        if (items == null) {
            return null;
        }
        total.setTotal(items.length);
        if (index < 0 || index > items.length) {
            return null;
        }
        return Arrays.stream(items).skip(index).limit(size).map(fileInfo -> EditorController.properties.getQiniu().getCdn() + fileInfo.key).collect(Collectors.toList());
    }

    static Zone getByName(String name) {
        Zone zone = null;
        switch (name) {
            case "zone0": {
                zone = Zone.zone0();
                break;
            }
            case "zone1": {
                zone = Zone.zone1();
                break;
            }
            case "zone2": {
                zone = Zone.zone2();
                break;
            }
            case "zoneNa0": {
                zone = Zone.zoneNa0();
                break;
            }
            case "zoneAs0": {
                zone = Zone.zoneAs0();
                break;
            }
            default: {
                throw new RuntimeException("\u767e\u5ea6\u7f16\u8f91\u4e03\u725b\u4e91zone\u914d\u7f6e\u9519\u8bef\uff0chttps://developer.qiniu.com/kodo/sdk/1239/java#server-upload");
            }
        }
        return zone;
    }
}

