/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.spring.support.qiniu;

import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.MIMEType;
import com.baidu.ueditor.define.MultiState;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.spring.EditorController;
import com.baidu.ueditor.spring.EditorUploader;
import com.baidu.ueditor.spring.support.qiniu.QiniuUtils;
import com.baidu.ueditor.spring.support.qiniu.Total;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.tomcat.util.codec.binary.Base64;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Component
public class QiniuUploader
implements EditorUploader {
    @Override
    public State binaryUpload(HttpServletRequest request, Map<String, Object> conf) {
        String fieldName = (String)conf.get("fieldName");
        MultiValueMap multiFileMap = ((MultipartHttpServletRequest)request).getMultiFileMap();
        MultipartFile file = (MultipartFile)multiFileMap.getFirst((Object)fieldName);
        assert (file != null);
        String originFileName = file.getOriginalFilename();
        assert (originFileName != null);
        String suffix = originFileName.substring(originFileName.lastIndexOf(".")).toLowerCase();
        if (!Arrays.asList((String[])conf.get("allowFiles")).contains(suffix)) {
            return new BaseState(false, 8);
        }
        long maxSize = (Long)conf.get("maxSize");
        if (maxSize < file.getSize()) {
            return new BaseState(false, 1);
        }
        String savePath = (String)conf.get("savePath");
        savePath = savePath + suffix;
        savePath = PathFormat.parse(savePath, originFileName);
        String url = QiniuUtils.upload(file, savePath);
        BaseState baseState = new BaseState();
        baseState.putInfo("url", url);
        return baseState;
    }

    @Override
    public State base64Upload(HttpServletRequest request, Map<String, Object> conf) {
        long maxSize;
        String filedName = (String)conf.get("fieldName");
        String content = request.getParameter(filedName);
        byte[] data = Base64.decodeBase64((String)content);
        if ((long)data.length > (maxSize = ((Long)conf.get("maxSize")).longValue())) {
            return new BaseState(false, 1);
        }
        String savePath = PathFormat.parse((String)conf.get("savePath"), (String)conf.get("filename"));
        savePath = savePath + ".jpg";
        String url = QiniuUtils.upload(content, savePath);
        BaseState baseState = new BaseState();
        baseState.putInfo("url", url);
        return baseState;
    }

    @Override
    public MultiState listImage(int index, Map<String, Object> conf) {
        return this.listFile(index, (Map)conf);
    }

    @Override
    public MultiState listFile(int index, Map<String, Object> conf) {
        int count = (Integer)conf.get("count");
        String dir = (String)conf.get("dir");
        Total total = new Total();
        List<String> listFile = QiniuUtils.listFile(dir, index, count, total);
        MultiState state = null;
        if (listFile == null) {
            state = new MultiState(true);
        } else {
            state = new MultiState(true);
            BaseState fileState = null;
            for (String key : listFile) {
                fileState = new BaseState(true);
                fileState.putInfo("url", key);
                state.addState(fileState);
            }
        }
        state.putInfo("start", index);
        state.putInfo("total", total.getTotal().intValue());
        return state;
    }

    @Override
    public State imageHunter(String[] list, Map<String, Object> conf) {
        List<String> allowTypes = Arrays.asList((String[])conf.get("allowFiles"));
        Long maxSize = (Long)conf.get("maxSize");
        String filename = (String)conf.get("filename");
        String savePath = (String)conf.get("savePath");
        List<String> filters = Arrays.asList((String[])conf.get("filter"));
        MultiState state = new MultiState(true);
        for (String source : list) {
            state.addState(this.saveRemoteImage(source, allowTypes, filters, maxSize, filename, savePath));
        }
        return state;
    }

    private State saveRemoteImage(String urlStr, List<String> allowTypes, List<String> filters, Long maxSize, String filename, String savePath) {
        HttpURLConnection connection = null;
        URL url = null;
        String suffix = null;
        try {
            url = new URL(urlStr);
            if (!this.validHost(url.getHost(), filters)) {
                return new BaseState(false, 201);
            }
            connection = (HttpURLConnection)url.openConnection();
            connection.setInstanceFollowRedirects(true);
            connection.setUseCaches(true);
            if (!this.validContentState(connection.getResponseCode())) {
                return new BaseState(false, 202);
            }
            suffix = MIMEType.getSuffix(connection.getContentType());
            if (!allowTypes.contains(suffix)) {
                return new BaseState(false, 8);
            }
            if ((long)connection.getContentLength() >= maxSize) {
                return new BaseState(false, 1);
            }
            savePath = savePath + suffix;
            savePath = PathFormat.parse(savePath, filename);
            String qiniuUrl = QiniuUtils.upload(connection.getInputStream(), savePath);
            BaseState baseState = new BaseState();
            baseState.putInfo("url", qiniuUrl);
            baseState.putInfo("source", urlStr);
            return baseState;
        }
        catch (Exception e) {
            return new BaseState(false, 203);
        }
    }

    private boolean validHost(String hostname, List<String> filters) {
        try {
            InetAddress ip = InetAddress.getByName(hostname);
            if (ip.isSiteLocalAddress()) {
                return false;
            }
        }
        catch (UnknownHostException e) {
            return false;
        }
        try {
            String cdn = EditorController.properties.getQiniu().getCdn();
            URL url = new URL(cdn);
            if (url.getHost().equals(hostname)) {
                return false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return !filters.contains(hostname);
    }

    private boolean validContentState(int code) {
        return 200 == code;
    }
}

