/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.hunter;

import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.MultiState;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.spring.EditorController;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class FileManager {
    private String dir;
    private String rootPath = PathFormat.format(EditorController.properties.getLocal().getPhysicalPath());
    private String[] allowFiles;
    private int count;
    private String contextPath;

    public FileManager(Map<String, Object> conf) {
        this.dir = (String)conf.get("dir");
        this.allowFiles = this.getAllowFiles(conf.get("allowFiles"));
        this.count = (Integer)conf.get("count");
        this.contextPath = (String)conf.get("contextPath");
    }

    public State listFile(int index) {
        State state;
        File dir = new File(PathFormat.format(this.rootPath + this.dir));
        if (!dir.exists()) {
            return new BaseState(false, 302);
        }
        if (!dir.isDirectory()) {
            return new BaseState(false, 301);
        }
        Collection list = FileUtils.listFiles((File)dir, (String[])this.allowFiles, (boolean)true);
        if (index < 0 || index > list.size()) {
            state = new MultiState(true);
        } else {
            Object[] fileList = Arrays.copyOfRange(list.toArray(), index, index + this.count);
            state = this.getMyState(fileList);
        }
        state.putInfo("start", index);
        state.putInfo("total", list.size());
        return state;
    }

    private State getMyState(Object[] files) {
        MultiState state = new MultiState(true);
        for (Object obj : files) {
            if (obj == null) break;
            File file = (File)obj;
            BaseState fileState = new BaseState(true);
            fileState.putInfo("url", PathFormat.format(this.contextPath + "/" + EditorController.properties.getLocal().getUrlPrefix() + "/" + PathFormat.format(file.getPath()).replaceFirst(this.rootPath, "")));
            state.addState(fileState);
        }
        return state;
    }

    private String[] getAllowFiles(Object fileExt) {
        if (fileExt == null) {
            return new String[0];
        }
        String[] exts = (String[])fileExt;
        int len = exts.length;
        for (int i = 0; i < len; ++i) {
            String ext = exts[i];
            exts[i] = ext.replace(".", "");
        }
        return exts;
    }
}

