/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathFormat {
    private static final String TIME = "time";
    private static final String FULL_YEAR = "yyyy";
    private static final String YEAR = "yy";
    private static final String MONTH = "mm";
    private static final String DAY = "dd";
    private static final String HOUR = "hh";
    private static final String MINUTE = "ii";
    private static final String SECOND = "ss";
    private static final String RAND = "rand";
    private static Date currentDate = null;
    private static Pattern pattern = Pattern.compile("\\{([^\\}]+)\\}", 2);

    public static String parse(String input) {
        Matcher matcher = pattern.matcher(input);
        currentDate = new Date();
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, PathFormat.getString(matcher.group(1)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String format(String input) {
        return input.replaceAll("/+|\\\\+", "/");
    }

    public static String parse(String input, String filename) {
        Matcher matcher = pattern.matcher(input);
        String matchStr = null;
        currentDate = new Date();
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matchStr = matcher.group(1);
            if (matchStr.contains("filename")) {
                filename = filename.replace("$", "\\$").replaceAll("[\\/:*?\"<>|]", "");
                matcher.appendReplacement(sb, filename);
                continue;
            }
            matcher.appendReplacement(sb, PathFormat.getString(matchStr));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String getString(String pattern) {
        if ((pattern = pattern.toLowerCase()).contains(TIME)) {
            return PathFormat.getTimestamp();
        }
        if (pattern.contains(FULL_YEAR)) {
            return PathFormat.getFullYear();
        }
        if (pattern.contains(YEAR)) {
            return PathFormat.getYear();
        }
        if (pattern.contains(MONTH)) {
            return PathFormat.getMonth();
        }
        if (pattern.contains(DAY)) {
            return PathFormat.getDay();
        }
        if (pattern.contains(HOUR)) {
            return PathFormat.getHour();
        }
        if (pattern.contains(MINUTE)) {
            return PathFormat.getMinute();
        }
        if (pattern.contains(SECOND)) {
            return PathFormat.getSecond();
        }
        if (pattern.contains(RAND)) {
            return PathFormat.getRandom(pattern);
        }
        return pattern;
    }

    private static String getTimestamp() {
        return System.currentTimeMillis() + "";
    }

    private static String getFullYear() {
        return new SimpleDateFormat(FULL_YEAR).format(currentDate);
    }

    private static String getYear() {
        return new SimpleDateFormat(YEAR).format(currentDate);
    }

    private static String getMonth() {
        return new SimpleDateFormat("MM").format(currentDate);
    }

    private static String getDay() {
        return new SimpleDateFormat(DAY).format(currentDate);
    }

    private static String getHour() {
        return new SimpleDateFormat("HH").format(currentDate);
    }

    private static String getMinute() {
        return new SimpleDateFormat(MONTH).format(currentDate);
    }

    private static String getSecond() {
        return new SimpleDateFormat(SECOND).format(currentDate);
    }

    private static String getRandom(String pattern) {
        int length = 0;
        pattern = pattern.split(":")[1].trim();
        length = Integer.parseInt(pattern);
        return (Math.random() + "").replace(".", "").substring(0, length);
    }
}

