/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor;

import com.baidu.ueditor.ConfigManager;
import com.baidu.ueditor.define.ActionMap;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.spring.EditorController;
import com.baidu.ueditor.spring.EditorUploader;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ActionEnter {
    private HttpServletRequest request = null;
    private String actionType = null;
    private ConfigManager configManager = null;

    public ActionEnter(HttpServletRequest request, String configFile) {
        this.request = request;
        this.actionType = request.getParameter("action");
        this.configManager = ConfigManager.getInstance(configFile);
    }

    public String exec() {
        String callbackName = this.request.getParameter("callback");
        if (callbackName != null) {
            if (!this.validCallbackName(callbackName)) {
                return new BaseState(false, 401).toJSONString();
            }
            return callbackName + "(" + this.invoke() + ");";
        }
        return this.invoke();
    }

    private String invoke() {
        if (this.actionType == null || !ActionMap.MAPPING.containsKey(this.actionType)) {
            return new BaseState(false, 101).toJSONString();
        }
        if (this.configManager == null || !this.configManager.valid()) {
            return new BaseState(false, 102).toJSONString();
        }
        State state = null;
        int actionCode = ActionMap.getType(this.actionType);
        Map<String, Object> conf = null;
        EditorUploader upload = EditorController.editorUploader;
        switch (actionCode) {
            case 0: {
                return this.configManager.getAllConfig().toString();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                conf = this.configManager.getConfig(actionCode);
                conf.put("contextPath", this.request.getContextPath());
                if ("true".equals(conf.get("isBase64"))) {
                    state = upload.base64Upload(this.request, conf);
                    break;
                }
                state = upload.binaryUpload(this.request, conf);
                break;
            }
            case 5: {
                conf = this.configManager.getConfig(actionCode);
                conf.put("contextPath", this.request.getContextPath());
                String[] list = this.request.getParameterValues((String)conf.get("fieldName"));
                state = upload.imageHunter(list, conf);
                break;
            }
            case 7: {
                conf = this.configManager.getConfig(actionCode);
                conf.put("contextPath", this.request.getContextPath());
                state = upload.listImage(this.getStartIndex(), conf);
                break;
            }
            case 6: {
                conf = this.configManager.getConfig(actionCode);
                conf.put("contextPath", this.request.getContextPath());
                state = upload.listFile(this.getStartIndex(), conf);
            }
        }
        assert (state != null);
        return state.toJSONString();
    }

    private int getStartIndex() {
        String start = this.request.getParameter("start");
        try {
            return Integer.parseInt(start);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private boolean validCallbackName(String name) {
        return name.matches("^[a-zA-Z_]+[\\w0-9_]*$");
    }
}

