/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditorspringbootstarter;

import com.baidu.ueditorspringbootstarter.UdeitorProperties;
import com.baidu.ueditorspringbootstarter.baidu.ueditor.ActionEnter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration
@Controller
@EnableConfigurationProperties(value={UdeitorProperties.class})
public class UeditorAutoConfigure
extends WebMvcConfigurerAdapter {
    @Autowired
    UdeitorProperties autoProperties;
    public static UdeitorProperties properties;

    public void addInterceptors(InterceptorRegistry registry) {
        properties = this.autoProperties;
        registry.addInterceptor((HandlerInterceptor)new HandlerInterceptorAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
                ServletOutputStream out = null;
                InputStream in = null;
                try {
                    out = response.getOutputStream();
                    if (request.getRequestURI().equals(UeditorAutoConfigure.this.autoProperties.getServerUrl())) {
                        out.print(new ActionEnter(request, UeditorAutoConfigure.this.autoProperties.getConfigFile()).exec());
                    } else if (request.getRequestURI().contains(UeditorAutoConfigure.this.autoProperties.getUrlPrefix())) {
                        String filename = request.getRequestURI().substring(UeditorAutoConfigure.this.autoProperties.getUrlPrefix().length(), request.getRequestURI().length());
                        in = new FileInputStream(filename);
                        int len = 0;
                        byte[] buffer = new byte[1024];
                        while ((len = in.read(buffer)) > 0) {
                            out.write(buffer, 0, len);
                        }
                    } else {
                        out.print(200);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                return false;
            }
        }).addPathPatterns(new String[]{this.autoProperties.getServerUrl(), this.autoProperties.getUrlPrefix() + "/**"});
    }
}

