/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.client.service;

import com.ctrip.framework.apollo.openapi.client.service.AbstractOpenApiService;
import com.ctrip.framework.apollo.openapi.dto.NamespaceReleaseDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenReleaseDTO;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class ReleaseOpenApiService
extends AbstractOpenApiService {
    public ReleaseOpenApiService(CloseableHttpClient client, String baseUrl, Gson gson) {
        super(client, baseUrl, gson);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OpenReleaseDTO publishNamespace(String appId, String env, String clusterName, String namespaceName, NamespaceReleaseDTO releaseDTO) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default";
        }
        if (Strings.isNullOrEmpty((String)namespaceName)) {
            namespaceName = "application";
        }
        this.checkNotEmpty(appId, "App id");
        this.checkNotEmpty(env, "Env");
        this.checkNotEmpty(releaseDTO.getReleaseTitle(), "Release title");
        this.checkNotEmpty(releaseDTO.getReleasedBy(), "Released by");
        String path = String.format("envs/%s/apps/%s/clusters/%s/namespaces/%s/releases", this.escapePath(env), this.escapePath(appId), this.escapePath(clusterName), this.escapePath(namespaceName));
        try (CloseableHttpResponse response = this.post(path, releaseDTO);){
            OpenReleaseDTO openReleaseDTO = (OpenReleaseDTO)this.gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), OpenReleaseDTO.class);
            return openReleaseDTO;
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Release namespace: %s for appId: %s, cluster: %s in env: %s failed", namespaceName, appId, clusterName, env), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OpenReleaseDTO getLatestActiveRelease(String appId, String env, String clusterName, String namespaceName) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default";
        }
        if (Strings.isNullOrEmpty((String)namespaceName)) {
            namespaceName = "application";
        }
        this.checkNotEmpty(appId, "App id");
        this.checkNotEmpty(env, "Env");
        String path = String.format("envs/%s/apps/%s/clusters/%s/namespaces/%s/releases/latest", this.escapePath(env), this.escapePath(appId), this.escapePath(clusterName), this.escapePath(namespaceName));
        try (CloseableHttpResponse response = this.get(path);){
            OpenReleaseDTO openReleaseDTO = (OpenReleaseDTO)this.gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), OpenReleaseDTO.class);
            return openReleaseDTO;
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Get latest active release for appId: %s, cluster: %s, namespace: %s in env: %s failed", appId, clusterName, namespaceName, env), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackRelease(String env, long releaseId, String operator) {
        this.checkNotEmpty(env, "Env");
        this.checkNotEmpty(operator, "Operator");
        String path = String.format("envs/%s/releases/%s/rollback?operator=%s", this.escapePath(env), releaseId, this.escapeParam(operator));
        try {
            CloseableHttpResponse ignored = this.put(path, null);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Rollback release: %s in env: %s failed", releaseId, env), ex);
        }
    }
}

