/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd;

import com.coreos.jetcd.Client;
import com.coreos.jetcd.common.exception.EtcdExceptionFactory;
import com.coreos.jetcd.data.ByteSequence;
import com.coreos.jetcd.internal.impl.ClientImpl;
import com.coreos.jetcd.resolver.URIResolverLoader;
import com.google.common.base.Preconditions;
import io.grpc.LoadBalancer;
import io.netty.handler.ssl.SslContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class ClientBuilder
implements Cloneable {
    private Set<String> endpoints = new HashSet<String>();
    private ByteSequence user;
    private ByteSequence password;
    private LoadBalancer.Factory loadBalancerFactory;
    private SslContext sslContext;
    private boolean lazyInitialization = false;
    private String authority;
    private URIResolverLoader uriResolverLoader;

    ClientBuilder() {
    }

    public Collection<String> endpoints() {
        return Collections.unmodifiableCollection(this.endpoints);
    }

    public ClientBuilder endpoints(Collection<String> endpoints) {
        Preconditions.checkNotNull(endpoints, (Object)"endpoints can't be null");
        for (String endpoint : endpoints) {
            Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint can't be null");
            String trimmedEndpoint = endpoint.trim();
            Preconditions.checkArgument((trimmedEndpoint.length() > 0 ? 1 : 0) != 0, (Object)("invalid endpoint: endpoint=" + endpoint));
            this.endpoints.add(trimmedEndpoint);
        }
        return this;
    }

    public ClientBuilder endpoints(String ... endpoints) {
        Preconditions.checkNotNull((Object)endpoints, (Object)"endpoints can't be null");
        return this.endpoints(Arrays.asList(endpoints));
    }

    public ByteSequence user() {
        return this.user;
    }

    public ClientBuilder user(ByteSequence user) {
        Preconditions.checkNotNull((Object)user, (Object)"user can't be null");
        this.user = user;
        return this;
    }

    public ByteSequence password() {
        return this.password;
    }

    public ClientBuilder password(ByteSequence password) {
        Preconditions.checkNotNull((Object)password, (Object)"password can't be null");
        this.password = password;
        return this;
    }

    public ClientBuilder loadBalancerFactory(LoadBalancer.Factory loadBalancerFactory) {
        Preconditions.checkNotNull((Object)loadBalancerFactory, (Object)"loadBalancerFactory can't be null");
        this.loadBalancerFactory = loadBalancerFactory;
        return this;
    }

    public LoadBalancer.Factory loadBalancerFactory() {
        return this.loadBalancerFactory;
    }

    public boolean lazyInitialization() {
        return this.lazyInitialization;
    }

    public ClientBuilder lazyInitialization(boolean lazyInitialization) {
        this.lazyInitialization = lazyInitialization;
        return this;
    }

    public SslContext sslContext() {
        return this.sslContext;
    }

    public ClientBuilder sslContext(SslContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public String authority() {
        return this.authority;
    }

    public ClientBuilder authority(String authority) {
        this.authority = authority;
        return this;
    }

    public URIResolverLoader uriResolverLoader() {
        return this.uriResolverLoader;
    }

    public ClientBuilder uriResolverLoader(URIResolverLoader loader) {
        this.uriResolverLoader = loader;
        return this;
    }

    public Client build() {
        Preconditions.checkState((!this.endpoints.isEmpty() ? 1 : 0) != 0, (Object)"please configure etcd server endpoints before build.");
        return new ClientImpl(this);
    }

    public ClientBuilder copy() {
        try {
            return (ClientBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw EtcdExceptionFactory.toEtcdException(e);
        }
    }
}

