/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.txmsg.transaction;

import com.codingapi.txlcn.common.exception.TxManagerException;
import com.codingapi.txlcn.tm.core.TransactionManager;
import com.codingapi.txlcn.tm.support.restapi.ao.WriteTxExceptionDTO;
import com.codingapi.txlcn.tm.support.service.TxExceptionService;
import com.codingapi.txlcn.tm.txmsg.RpcExecuteService;
import com.codingapi.txlcn.tm.txmsg.TransactionCmd;
import com.codingapi.txlcn.txmsg.RpcClient;
import com.codingapi.txlcn.txmsg.params.TxExceptionParams;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="rpc_write-exception")
public class WriteTxExceptionExecuteService
implements RpcExecuteService {
    private static final Logger log = LoggerFactory.getLogger(WriteTxExceptionExecuteService.class);
    private final TxExceptionService compensationService;
    private final RpcClient rpcClient;
    private final TransactionManager transactionManager;

    @Autowired
    public WriteTxExceptionExecuteService(TxExceptionService compensationService, RpcClient rpcClient, TransactionManager transactionManager) {
        this.compensationService = compensationService;
        this.rpcClient = rpcClient;
        this.transactionManager = transactionManager;
    }

    @Override
    public Serializable execute(TransactionCmd transactionCmd) throws TxManagerException {
        try {
            TxExceptionParams txExceptionParams = (TxExceptionParams)transactionCmd.getMsg().loadBean(TxExceptionParams.class);
            WriteTxExceptionDTO writeTxExceptionReq = new WriteTxExceptionDTO();
            writeTxExceptionReq.setModId(this.rpcClient.getAppName(transactionCmd.getRemoteKey()));
            int transactionState = this.transactionManager.transactionStateFromFastStorage(transactionCmd.getGroupId());
            writeTxExceptionReq.setTransactionState(transactionState == -1 ? txExceptionParams.getTransactionState() : transactionState);
            writeTxExceptionReq.setGroupId(txExceptionParams.getGroupId());
            writeTxExceptionReq.setUnitId(txExceptionParams.getUnitId());
            writeTxExceptionReq.setRegistrar(Objects.isNull(txExceptionParams.getRegistrar()) ? (short)-1 : txExceptionParams.getRegistrar());
            writeTxExceptionReq.setRemark(txExceptionParams.getRemark());
            this.compensationService.writeTxException(writeTxExceptionReq);
        }
        catch (Exception e) {
            throw new TxManagerException((Throwable)e);
        }
        return null;
    }
}

