/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseRecord;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.jdbc.AbstractResultSet;
import com.clickhouse.jdbc.ClickHouseArray;
import com.clickhouse.jdbc.ClickHouseConnection;
import com.clickhouse.jdbc.ClickHouseResultSetMetaData;
import com.clickhouse.jdbc.ClickHouseStatement;
import com.clickhouse.jdbc.ClickHouseStruct;
import com.clickhouse.jdbc.SqlExceptionUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class ClickHouseResultSet
extends AbstractResultSet {
    private ClickHouseRecord currentRow;
    private Iterator<ClickHouseRecord> rowCursor;
    private int rowNumber;
    private int lastReadColumn;
    private int fetchSize;
    protected final String database;
    protected final String table;
    protected final ClickHouseStatement statement;
    protected final ClickHouseResponse response;
    protected final ClickHouseConfig config;
    protected final boolean wrapObject;
    protected final List<ClickHouseColumn> columns;
    protected final Calendar defaultCalendar;
    protected final int maxRows;
    protected final boolean nullAsDefault;
    protected final ClickHouseResultSetMetaData metaData;
    protected final Map<String, Class<?>> defaultTypeMap;

    ClickHouseResultSet(String database, String table, ClickHouseResponse response) {
        this.database = database;
        this.table = table;
        this.statement = null;
        this.response = response;
        this.config = null;
        this.wrapObject = false;
        this.defaultCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        this.defaultTypeMap = Collections.emptyMap();
        this.currentRow = null;
        try {
            this.columns = response.getColumns();
            this.metaData = new ClickHouseResultSetMetaData(database, table, this.columns, this.defaultTypeMap);
            this.rowCursor = response.records().iterator();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.rowNumber = 0;
        this.lastReadColumn = 0;
        this.maxRows = 0;
        this.nullAsDefault = false;
        this.fetchSize = 0;
    }

    public ClickHouseResultSet(String database, String table, ClickHouseStatement statement, ClickHouseResponse response) throws SQLException {
        if (database == null || table == null || statement == null || response == null) {
            throw new IllegalArgumentException("Non-null database, table, statement, and response are required");
        }
        this.database = database;
        this.table = table;
        this.statement = statement;
        this.response = response;
        ClickHouseConnection conn = statement.getConnection();
        this.config = statement.getConfig();
        this.wrapObject = statement.getConnection().getJdbcConfig().useWrapperObject();
        this.defaultCalendar = conn.getDefaultCalendar();
        Map<String, Class<?>> typeMap = conn.getTypeMap();
        this.defaultTypeMap = typeMap != null && !typeMap.isEmpty() ? Collections.unmodifiableMap(typeMap) : Collections.emptyMap();
        this.currentRow = null;
        try {
            this.columns = response.getColumns();
            this.metaData = new ClickHouseResultSetMetaData(database, table, this.columns, this.defaultTypeMap);
            this.rowCursor = response.records().iterator();
        }
        catch (Exception e) {
            throw SqlExceptionUtils.handle(e, new Throwable[0]);
        }
        this.rowNumber = 0;
        this.lastReadColumn = 0;
        this.maxRows = statement.getMaxRows();
        this.nullAsDefault = statement.getNullAsDefault() > 1;
        this.fetchSize = statement.getFetchSize();
    }

    protected void ensureRead(int columnIndex) throws SQLException {
        this.ensureOpen();
        if (this.currentRow == null) {
            throw new SQLException("No data available for reading", "02000");
        }
        if (columnIndex < 1 || columnIndex > this.columns.size()) {
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Column index must between 1 and %d but we got %d", (Object[])new Object[]{this.columns.size(), columnIndex}));
        }
    }

    protected List<ClickHouseColumn> getColumns() {
        return this.metaData.getColumns();
    }

    protected ClickHouseValue getValue(int columnIndex) throws SQLException {
        this.ensureRead(columnIndex);
        ClickHouseValue v = this.currentRow.getValue(columnIndex - 1);
        if (this.nullAsDefault && v.isNullOrEmpty()) {
            v.resetToDefault();
        }
        this.lastReadColumn = columnIndex;
        return v;
    }

    protected boolean hasNext() throws SQLException {
        try {
            return (this.maxRows == 0 || this.rowNumber < this.maxRows) && this.rowCursor.hasNext();
        }
        catch (Exception e) {
            throw SqlExceptionUtils.handle(e, new Throwable[0]);
        }
    }

    public BigInteger getBigInteger(int columnIndex) throws SQLException {
        return this.getValue(columnIndex).asBigInteger();
    }

    public BigInteger getBigInteger(String columnLabel) throws SQLException {
        return this.getValue(this.findColumn(columnLabel)).asBigInteger();
    }

    public String[] getColumnNames() {
        String[] columnNames = new String[this.columns.size()];
        int index = 0;
        for (ClickHouseColumn c : this.getColumns()) {
            columnNames[index++] = c.getColumnName();
        }
        return columnNames;
    }

    @Override
    public void close() throws SQLException {
        this.response.close();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.ensureOpen();
        if (columnLabel == null || columnLabel.isEmpty()) {
            throw SqlExceptionUtils.clientError("Non-empty column label is required");
        }
        int index = 0;
        for (ClickHouseColumn c : this.columns) {
            ++index;
            if (!columnLabel.equalsIgnoreCase(c.getColumnName())) continue;
            return index;
        }
        throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Column [%s] does not exist in %d columns", (Object[])new Object[]{columnLabel, this.columns.size()}));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return new ClickHouseArray(this, columnIndex);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return new ClickHouseArray(this, this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        ClickHouseValue v = this.getValue(columnIndex);
        return v.isNullOrEmpty() ? null : new ByteArrayInputStream(v.asBinary(StandardCharsets.US_ASCII));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getValue(columnIndex).asBigDecimal();
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getValue(this.findColumn(columnLabel)).asBigDecimal();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getValue(columnIndex).asBigDecimal(scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getValue(this.findColumn(columnLabel)).asBigDecimal(scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        ClickHouseValue v = this.getValue(columnIndex);
        return v.isNullOrEmpty() ? null : new ByteArrayInputStream(v.asBinary());
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getValue(columnIndex).asBoolean();
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getValue(this.findColumn(columnLabel)).asBoolean();
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.getValue(columnIndex).asByte();
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getValue(this.findColumn(columnLabel)).asByte();
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getValue(columnIndex).asBinary();
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getValue(this.findColumn(columnLabel)).asBinary();
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        ClickHouseValue v = this.getValue(columnIndex);
        return v.isNullOrEmpty() ? null : new StringReader(v.asString());
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public String getCursorName() throws SQLException {
        this.ensureOpen();
        return null;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), null);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        ClickHouseValue value = this.getValue(columnIndex);
        if (value.isNullOrEmpty()) {
            return null;
        }
        LocalDate d = value.asDate();
        Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
        c.clear();
        c.set(d.getYear(), d.getMonthValue() - 1, d.getDayOfMonth(), 0, 0, 0);
        return new Date(c.getTimeInMillis());
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.getValue(columnIndex).asDouble();
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getValue(this.findColumn(columnLabel)).asDouble();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureOpen();
        return this.fetchSize;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.getValue(columnIndex).asFloat();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getValue(this.findColumn(columnLabel)).asFloat();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.getValue(columnIndex).asInteger();
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getValue(this.findColumn(columnLabel)).asInteger();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getValue(columnIndex).asLong();
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getValue(this.findColumn(columnLabel)).asLong();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.ensureOpen();
        return this.metaData;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getValue(columnIndex).asString();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getValue(this.findColumn(columnLabel)).asString();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, this.defaultTypeMap);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), this.defaultTypeMap);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        if (map == null) {
            map = this.defaultTypeMap;
        }
        ClickHouseValue v = this.getValue(columnIndex);
        ClickHouseColumn c = this.columns.get(columnIndex - 1);
        Class<?> javaType = null;
        if (!map.isEmpty() && (javaType = map.get(c.getOriginalTypeName())) == null) {
            javaType = map.get(c.getDataType().name());
        }
        Object value = !this.wrapObject ? (javaType != null ? v.asObject(javaType) : v.asObject()) : (c.isArray() ? new ClickHouseArray(this, columnIndex) : (c.isTuple() || c.isNested() ? new ClickHouseStruct(c.getDataType().name(), v.asArray()) : (javaType != null ? v.asObject(javaType) : v.asObject())));
        return value;
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return (T)this.getValue(columnIndex).asObject(type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return (T)this.getValue(this.findColumn(columnLabel)).asObject(type);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("getRef not implemented");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.findColumn(columnLabel));
    }

    @Override
    public int getRow() throws SQLException {
        this.ensureOpen();
        return this.rowNumber;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("getRowId not implemented");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("getSQLXML not implemented");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.getValue(columnIndex).asShort();
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getValue(this.findColumn(columnLabel)).asShort();
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.ensureOpen();
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getValue(columnIndex).asString();
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getValue(this.findColumn(columnLabel)).asString();
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, null);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), null);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        ClickHouseValue value = this.getValue(columnIndex);
        if (value.isNullOrEmpty()) {
            return null;
        }
        LocalTime lt = value.asTime();
        Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
        c.clear();
        c.set(1970, 0, 1, lt.getHour(), lt.getMinute(), lt.getSecond());
        return new Time(c.getTimeInMillis());
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        ClickHouseValue value = this.getValue(columnIndex);
        if (value.isNullOrEmpty()) {
            return null;
        }
        ClickHouseColumn column = this.columns.get(columnIndex - 1);
        TimeZone tz = column.getTimeZone();
        LocalDateTime dt = tz == null ? value.asDateTime(column.getScale()) : value.asOffsetDateTime(column.getScale()).toLocalDateTime();
        Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
        c.set(dt.getYear(), dt.getMonthValue() - 1, dt.getDayOfMonth(), dt.getHour(), dt.getMinute(), dt.getSecond());
        Timestamp timestamp = new Timestamp(c.getTimeInMillis());
        timestamp.setNanos(dt.getNano());
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        try {
            return new URL(this.getString(columnIndex));
        }
        catch (MalformedURLException e) {
            throw SqlExceptionUtils.clientError(e);
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        try {
            return new URL(this.getString(columnLabel));
        }
        catch (MalformedURLException e) {
            throw SqlExceptionUtils.clientError(e);
        }
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        ClickHouseValue v = this.getValue(columnIndex);
        return v.isNullOrEmpty() ? null : new ByteArrayInputStream(v.asBinary(StandardCharsets.UTF_8));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.ensureOpen();
        return this.currentRow == null && !this.hasNext();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.ensureOpen();
        return this.getRow() == 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.response.isClosed();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.ensureOpen();
        return this.getRow() == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.ensureOpen();
        return this.currentRow != null && !this.hasNext();
    }

    @Override
    public boolean next() throws SQLException {
        this.ensureOpen();
        this.lastReadColumn = 0;
        boolean hasNext = true;
        if (this.hasNext()) {
            try {
                this.currentRow = this.rowCursor.next();
            }
            catch (UncheckedIOException e) {
                throw SqlExceptionUtils.handle(e, new Throwable[0]);
            }
            ++this.rowNumber;
        } else {
            this.currentRow = null;
            hasNext = false;
        }
        return hasNext;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.ensureOpen();
        this.fetchSize = rows;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.ensureOpen();
        try {
            return this.currentRow != null && this.lastReadColumn > 0 && this.getColumns().get(this.lastReadColumn - 1).isNullable() && this.currentRow.getValue(this.lastReadColumn - 1).isNullOrEmpty();
        }
        catch (Exception e) {
            throw SqlExceptionUtils.handle(e, new Throwable[0]);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface == ClickHouseResponse.class || iface == ClickHouseRecord.class || super.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == ClickHouseResponse.class) {
            return iface.cast(this.response);
        }
        if (iface == ClickHouseRecord.class) {
            return iface.cast(this.currentRow);
        }
        return super.unwrap(iface);
    }
}

