/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.stalker.runner.executor;

import com.blinkfox.stalker.runner.executor.StalkerRejectedHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class StalkerExecutors {
    private static final int MAX_QUEUE_SIZE = 524280;
    public static final int MAX_POOL_SIZE = 1024;

    public static ThreadPoolExecutor newSingleThreadExecutor(String threadName) {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(2), r -> new Thread(r, threadName), new StalkerRejectedHandler());
    }

    public static ThreadPoolExecutor newFixedThreadExecutor(int corePoolSize, String threadName) {
        int fixedPoolSize = Math.min(corePoolSize, 1024);
        return new ThreadPoolExecutor(fixedPoolSize, fixedPoolSize, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(524280), r -> new Thread(r, threadName), new StalkerRejectedHandler());
    }

    public static ThreadPoolExecutor newThreadExecutor(int corePoolSize, int maxPoolSize, String threadName) {
        return new ThreadPoolExecutor(corePoolSize, maxPoolSize, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(524280), r -> new Thread(r, threadName), new StalkerRejectedHandler());
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String threadName) {
        return new ScheduledThreadPoolExecutor(corePoolSize, r -> new Thread(r, threadName), new StalkerRejectedHandler());
    }

    public static void shutdown(ExecutorService ... executorServices) {
        for (ExecutorService executorService : executorServices) {
            if (executorService == null || executorService.isShutdown()) continue;
            executorService.shutdown();
        }
    }

    public static void shutdownNow(ExecutorService ... executorServices) {
        for (ExecutorService executorService : executorServices) {
            if (executorService == null || executorService.isShutdown()) continue;
            executorService.shutdownNow();
        }
    }

    private StalkerExecutors() {
    }
}

