/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.stalker.runner;

import com.blinkfox.stalker.config.Options;
import com.blinkfox.stalker.config.RunDuration;
import com.blinkfox.stalker.result.MeasureResult;
import com.blinkfox.stalker.runner.SimpleMeasureRunner;
import com.blinkfox.stalker.runner.executor.StalkerExecutors;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleScheduledMeasureRunner
extends SimpleMeasureRunner {
    private static final Logger log = LoggerFactory.getLogger(SimpleScheduledMeasureRunner.class);
    private final ScheduledExecutorService scheduledExecutorService = StalkerExecutors.newScheduledThreadPool(1, "simple-scheduled-thread");
    protected Future<?> scheduledFuture;

    @Override
    public MeasureResult run(Options options, Runnable runnable) {
        boolean printErrorLog = options.isPrintErrorLog();
        this.executorService = StalkerExecutors.newSingleThreadExecutor("simple-scheduled-measure-thread");
        this.startNanoTime = System.nanoTime();
        this.measureFuture = this.executorService.submit(() -> {
            while (true) {
                try {
                    while (true) {
                        long eachStart = System.nanoTime();
                        runnable.run();
                        this.eachMeasures.offer(System.nanoTime() - eachStart);
                        this.success.increment();
                    }
                }
                catch (Exception e) {
                    this.failure.increment();
                    if (!printErrorLog) continue;
                    log.error("\u3010stalker \u9519\u8bef\u3011\u6d4b\u91cf\u65b9\u6cd5\u8017\u65f6\u4fe1\u606f\u51fa\u9519!", (Throwable)e);
                    continue;
                }
                break;
            }
        });
        RunDuration duration = options.getDuration();
        this.scheduledFuture = this.scheduledExecutorService.schedule(() -> {
            this.stop();
            this.canceled.compareAndSet(true, false);
        }, duration.getAmount(), duration.getTimeUnit());
        try {
            this.measureFuture.get();
        }
        catch (CancellationException e) {
            log.info("\u3010Stalker \u63d0\u793a\u3011\u5df2\u53d6\u6d88\u6216\u5b8c\u6210\u6307\u5b9a\u8fd0\u884c\u65f6\u95f4\u7684\u6d4b\u91cf\u4efb\u52a1.");
        }
        catch (Exception e) {
            log.error("\u3010Stalker \u9519\u8bef\u3011\u6267\u884c\u6d4b\u91cf\u4efb\u52a1\u53d1\u751f\u9519\u8bef\uff01", (Throwable)e);
        }
        super.setEndNanoTimeIfEmpty(System.nanoTime());
        this.completed.compareAndSet(false, true);
        StalkerExecutors.shutdown(this.executorService, this.scheduledExecutorService);
        return super.getMeasureResult();
    }

    @Override
    public void stop() {
        super.stop();
        StalkerExecutors.shutdown(this.scheduledExecutorService);
        if (this.scheduledFuture != null && !this.scheduledFuture.isDone()) {
            this.scheduledFuture.cancel(true);
        }
    }
}

