/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.stalker.runner;

import com.blinkfox.stalker.config.Options;
import com.blinkfox.stalker.result.MeasureResult;
import com.blinkfox.stalker.runner.AbstractMeasureRunner;
import com.blinkfox.stalker.runner.executor.StalkerExecutors;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMeasureRunner
extends AbstractMeasureRunner {
    private static final Logger log = LoggerFactory.getLogger(SimpleMeasureRunner.class);
    protected Future<?> measureFuture;

    @Override
    public MeasureResult run(Options options, Runnable runnable) {
        boolean printErrorLog = options.isPrintErrorLog();
        int totalCount = options.getThreads() * options.getRuns();
        this.executorService = StalkerExecutors.newSingleThreadExecutor("simple-measure-thread");
        this.startNanoTime = System.nanoTime();
        this.measureFuture = this.executorService.submit(() -> {
            for (int i = 0; i < totalCount; ++i) {
                try {
                    long eachStart = System.nanoTime();
                    runnable.run();
                    this.eachMeasures.offer(System.nanoTime() - eachStart);
                    this.success.increment();
                    continue;
                }
                catch (Exception e) {
                    this.failure.increment();
                    if (!printErrorLog) continue;
                    log.error("\u3010stalker \u9519\u8bef\u3011\u6d4b\u91cf\u65b9\u6cd5\u8017\u65f6\u4fe1\u606f\u51fa\u9519!", (Throwable)e);
                }
            }
        });
        try {
            this.measureFuture.get();
        }
        catch (CancellationException e) {
            log.info("\u3010Stalker \u63d0\u793a\u3011\u5df2\u53d6\u6d88\u6216\u5b8c\u6210\u6d4b\u91cf\u4efb\u52a1.");
        }
        catch (Exception e) {
            log.error("\u3010Stalker \u9519\u8bef\u3011\u6267\u884c\u6d4b\u91cf\u4efb\u52a1\u53d1\u751f\u9519\u8bef\uff01", (Throwable)e);
        }
        super.setEndNanoTimeIfEmpty(System.nanoTime());
        this.completed.compareAndSet(false, true);
        StalkerExecutors.shutdown(this.executorService);
        return super.getMeasureResult();
    }

    @Override
    public void stop() {
        if (!this.isCompleted()) {
            super.setEndNanoTimeIfEmpty(System.nanoTime());
            this.completed.compareAndSet(false, true);
            this.canceled.compareAndSet(false, true);
            StalkerExecutors.shutdownNow(this.executorService);
            if (this.measureFuture != null && !this.measureFuture.isDone()) {
                this.measureFuture.cancel(true);
            }
        }
    }
}

