/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.stalker.runner;

import com.blinkfox.stalker.config.Options;
import com.blinkfox.stalker.kit.StrKit;
import com.blinkfox.stalker.result.MeasureResult;
import com.blinkfox.stalker.result.StalkerFuture;
import com.blinkfox.stalker.runner.AbstractMeasureRunner;
import com.blinkfox.stalker.runner.ConcurrentMeasureRunner;
import com.blinkfox.stalker.runner.ConcurrentScheduledMeasureRunner;
import com.blinkfox.stalker.runner.SimpleMeasureRunner;
import com.blinkfox.stalker.runner.SimpleScheduledMeasureRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MeasureRunnerContext {
    private static final Logger log = LoggerFactory.getLogger(MeasureRunnerContext.class);
    private final Options options;

    public MeasureRunnerContext(Options options) {
        options.valid();
        this.options = options;
    }

    private static void warmup(Options options, Runnable runnable) {
        boolean printErrorLog = options.isPrintErrorLog();
        log.debug("\u3010stalker \u63d0\u793a\u3011\u9884\u70ed\u5f00\u59cb...");
        long start = System.nanoTime();
        int len = options.getWarmups();
        for (int i = 0; i < len; ++i) {
            try {
                runnable.run();
                continue;
            }
            catch (RuntimeException e) {
                if (!printErrorLog) continue;
                log.error("\u3010stalker \u9519\u8bef\u3011\u6d4b\u91cf\u65b9\u6cd5\u524d\u8fdb\u884c\u9884\u70ed\u65f6\u51fa\u9519!", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u3010stalker \u63d0\u793a\u3011\u9884\u70ed\u5b8c\u6bd5\uff0c\u9884\u70ed\u671f\u95f4\u8017\u65f6: {}.", (Object)StrKit.convertTime(System.nanoTime() - start));
        }
    }

    public MeasureResult run(Runnable runnable) {
        MeasureRunnerContext.warmup(this.options, runnable);
        if (this.options.getDuration() != null) {
            return this.options.getConcurrens() > 1 ? new ConcurrentScheduledMeasureRunner().run(this.options, runnable) : new SimpleScheduledMeasureRunner().run(this.options, runnable);
        }
        return this.options.getConcurrens() > 1 ? new ConcurrentMeasureRunner().run(this.options, runnable) : new SimpleMeasureRunner().run(this.options, runnable);
    }

    public static StalkerFuture submit(Options options, Runnable runnable) {
        MeasureRunnerContext.warmup(options, runnable);
        AbstractMeasureRunner measureRunner = options.getDuration() != null ? (options.getConcurrens() > 1 ? new ConcurrentScheduledMeasureRunner() : new SimpleScheduledMeasureRunner()) : (options.getConcurrens() > 1 ? new ConcurrentMeasureRunner() : new SimpleMeasureRunner());
        StalkerFuture stalkerFuture = new StalkerFuture(options, runnable, measureRunner);
        stalkerFuture.run();
        return stalkerFuture;
    }
}

