/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.stalker.runner;

import com.blinkfox.stalker.config.Options;
import com.blinkfox.stalker.config.RunDuration;
import com.blinkfox.stalker.result.MeasureResult;
import com.blinkfox.stalker.runner.ConcurrentMeasureRunner;
import com.blinkfox.stalker.runner.executor.StalkerExecutors;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentScheduledMeasureRunner
extends ConcurrentMeasureRunner {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentScheduledMeasureRunner.class);
    private final ScheduledExecutorService scheduledExecutorService = StalkerExecutors.newScheduledThreadPool(1, "concurrent-scheduled-thread");
    protected Future<?> scheduledFuture;

    public ConcurrentScheduledMeasureRunner() {
        this.executorService = StalkerExecutors.newFixedThreadExecutor(1024, "concurrent-measure-thread");
    }

    @Override
    public MeasureResult run(Options options, Runnable runnable) {
        int concurrens = options.getConcurrens();
        int runs = options.getRuns();
        boolean printErrorLog = options.isPrintErrorLog();
        Semaphore semaphore = new Semaphore(concurrens);
        RunDuration duration = options.getDuration();
        this.scheduledFuture = this.scheduledExecutorService.schedule(() -> {
            this.stop();
            this.canceled.compareAndSet(true, false);
        }, duration.getAmount(), duration.getTimeUnit());
        this.startNanoTime = System.nanoTime();
        long expectEndNanoTime = duration.getEndNanoTime(this.startNanoTime);
        block2: while (true) {
            try {
                while (true) {
                    semaphore.acquire();
                    if (this.executorService.isShutdown()) {
                        return super.getMeasureResult();
                    }
                    if (System.nanoTime() > expectEndNanoTime) break block2;
                    CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                        this.loopMeasure(runs, printErrorLog, runnable);
                        semaphore.release();
                    }, this.executorService);
                    this.runningFutures.add(future);
                    future.whenCompleteAsync((a, b) -> this.runningFutures.remove(future));
                }
            }
            catch (InterruptedException e) {
                log.error("\u3010Stalker \u9519\u8bef\u63d0\u793a\u3011\u5728\u591a\u7ebf\u7a0b\u5e76\u53d1\u60c5\u51b5\u4e0b\u6d4b\u91cf\u4efb\u52a1\u6267\u884c\u7684\u8017\u65f6\u4fe1\u606f\u7684\u7ebf\u7a0b\u5df2\u88ab\u4e2d\u65ad!", (Throwable)e);
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
        super.setEndNanoTimeIfEmpty(System.nanoTime());
        this.completed.compareAndSet(false, true);
        StalkerExecutors.shutdown(this.executorService, this.scheduledExecutorService);
        if (!this.scheduledFuture.isDone()) {
            this.scheduledFuture.cancel(true);
        }
        return super.getMeasureResult();
    }

    @Override
    public void stop() {
        super.stop();
        StalkerExecutors.shutdown(this.scheduledExecutorService);
        if (this.scheduledFuture != null && !this.scheduledFuture.isDone()) {
            this.scheduledFuture.cancel(true);
        }
    }
}

