/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.stalker.runner;

import com.blinkfox.stalker.config.Options;
import com.blinkfox.stalker.kit.ConcurrentHashSet;
import com.blinkfox.stalker.result.MeasureResult;
import com.blinkfox.stalker.runner.AbstractMeasureRunner;
import com.blinkfox.stalker.runner.executor.StalkerExecutors;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentMeasureRunner
extends AbstractMeasureRunner {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentMeasureRunner.class);
    protected final Set<CompletableFuture<Void>> runningFutures = new ConcurrentHashSet<CompletableFuture<Void>>();

    @Override
    public MeasureResult run(Options options, Runnable runnable) {
        int threads = options.getThreads();
        int concurrens = options.getConcurrens();
        int runs = options.getRuns();
        boolean printErrorLog = options.isPrintErrorLog();
        Semaphore semaphore = new Semaphore(concurrens);
        CountDownLatch countLatch = new CountDownLatch(threads);
        this.executorService = StalkerExecutors.newFixedThreadExecutor(threads, "concurrent-measure-thread");
        this.startNanoTime = System.nanoTime();
        for (int i = 0; i < threads; ++i) {
            try {
                semaphore.acquire();
                if (this.executorService.isShutdown()) {
                    return super.getMeasureResult();
                }
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                    this.loopMeasure(runs, printErrorLog, runnable);
                    semaphore.release();
                    countLatch.countDown();
                }, this.executorService);
                this.runningFutures.add(future);
                future.whenCompleteAsync((a, b) -> this.runningFutures.remove(future));
                continue;
            }
            catch (InterruptedException e) {
                log.error("\u3010Stalker \u9519\u8bef\u63d0\u793a\u3011\u5728\u591a\u7ebf\u7a0b\u5e76\u53d1\u60c5\u51b5\u4e0b\u6d4b\u91cf\u4efb\u52a1\u6267\u884c\u7684\u8017\u65f6\u4fe1\u606f\u7684\u7ebf\u7a0b\u5df2\u88ab\u4e2d\u65ad!", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        this.await(countLatch);
        super.setEndNanoTimeIfEmpty(System.nanoTime());
        this.completed.compareAndSet(false, true);
        StalkerExecutors.shutdown(this.executorService);
        return super.getMeasureResult();
    }

    protected void loopMeasure(int runs, boolean printErrorLog, Runnable runnable) {
        for (int j = 0; j < runs; ++j) {
            try {
                long eachStart = System.nanoTime();
                runnable.run();
                this.eachMeasures.offer(System.nanoTime() - eachStart);
                this.success.increment();
                continue;
            }
            catch (Exception e) {
                this.failure.increment();
                if (!printErrorLog) continue;
                log.error("\u6d4b\u91cf\u65b9\u6cd5\u8017\u65f6\u4fe1\u606f\u5728\u591a\u7ebf\u7a0b\u4e0b\u51fa\u9519!", (Throwable)e);
            }
        }
    }

    @Override
    public void stop() {
        if (!this.isCompleted()) {
            super.setEndNanoTimeIfEmpty(System.nanoTime());
            this.completed.compareAndSet(false, true);
            this.canceled.compareAndSet(false, true);
            StalkerExecutors.shutdownNow(this.executorService);
            for (CompletableFuture<Void> future : this.runningFutures) {
                this.runningFutures.remove(future);
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
    }

    private void await(CountDownLatch countLatch) {
        try {
            if (countLatch != null) {
                countLatch.await();
            }
        }
        catch (InterruptedException e) {
            log.error("\u3010Stalker \u9519\u8bef\u63d0\u793a\u3011\u5728\u5e76\u53d1\u6267\u884c\u4e0b\u7b49\u5f85\u4efb\u52a1\u6267\u884c\u7ed3\u675f\u65f6\u51fa\u9519!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

