/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.stalker.runner;

import com.blinkfox.stalker.result.MeasureResult;
import com.blinkfox.stalker.result.MeasureStatistician;
import com.blinkfox.stalker.runner.MeasureRunner;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMeasureRunner
implements MeasureRunner {
    private static final Logger log = LoggerFactory.getLogger(AbstractMeasureRunner.class);
    protected ExecutorService executorService;
    private final MeasureStatistician measureStatistician = new MeasureStatistician();
    private final Lock statisLock = new ReentrantLock();
    protected Queue<Long> eachMeasures = new ConcurrentLinkedQueue<Long>();
    protected LongAdder success = new LongAdder();
    protected LongAdder failure = new LongAdder();
    protected AtomicBoolean completed = new AtomicBoolean(false);
    protected AtomicBoolean canceled = new AtomicBoolean(false);
    protected long startNanoTime;
    protected long endNanoTime;
    private long beforeTotalCount;

    @Override
    public long getCosts() {
        return this.completed.get() && this.getTotal() <= this.beforeTotalCount && this.eachMeasures.isEmpty() ? this.endNanoTime - this.startNanoTime : (this.startNanoTime == 0L ? 0L : System.nanoTime() - this.startNanoTime);
    }

    @Override
    public long getTotal() {
        return this.success.longValue() + this.failure.longValue();
    }

    @Override
    public long getSuccess() {
        return this.success.longValue();
    }

    @Override
    public long getFailure() {
        return this.failure.longValue();
    }

    @Override
    public boolean isCompleted() {
        return this.completed.get();
    }

    @Override
    public boolean isCancelled() {
        return this.canceled.get();
    }

    public void setEndNanoTimeIfEmpty(long endNanoTime) {
        if (this.endNanoTime == 0L) {
            this.endNanoTime = endNanoTime;
        }
    }

    @Override
    public MeasureResult getMeasureResult() {
        return this.completed.get() && this.getTotal() <= this.beforeTotalCount && this.eachMeasures.isEmpty() ? this.measureStatistician.get() : this.getRunningMeasureResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MeasureResult getRunningMeasureResult() {
        try {
            this.statisLock.lockInterruptibly();
            long currCosts = this.completed.get() ? this.endNanoTime - this.startNanoTime : (this.startNanoTime == 0L ? 0L : System.nanoTime() - this.startNanoTime);
            long currFailure = this.getFailure();
            long currSuccess = this.getSuccess();
            long currTotal = currSuccess + currFailure;
            int newCount = (int)(currTotal - this.beforeTotalCount);
            if (newCount <= 0) {
                MeasureResult measureResult = this.measureStatistician.get();
                return measureResult;
            }
            ArrayList<Long> currEachCosts = new ArrayList<Long>(newCount);
            for (int i = 0; i < newCount; ++i) {
                Long cost = this.eachMeasures.poll();
                if (cost == null) continue;
                currEachCosts.add(cost);
            }
            this.beforeTotalCount = currTotal;
            MeasureResult measureResult = this.measureStatistician.updateAndGet(currSuccess, currFailure, currCosts, currEachCosts);
            return measureResult;
        }
        catch (InterruptedException e) {
            log.error("\u3010Stalker \u9519\u8bef\u63d0\u793a\u3011\u83b7\u53d6\u8fd0\u884c\u4e2d\u4efb\u52a1\u7684\u7edf\u8ba1\u7ed3\u679c\u6570\u636e\u7ebf\u7a0b\u88ab\u4e2d\u65ad\uff01", (Throwable)e);
            Thread.currentThread().interrupt();
            MeasureResult measureResult = this.measureStatistician.get();
            return measureResult;
        }
        catch (Exception e) {
            log.error("\u3010Stalker \u9519\u8bef\u63d0\u793a\u3011\u83b7\u53d6\u8fd0\u884c\u4e2d\u4efb\u52a1\u7684\u7edf\u8ba1\u7ed3\u679c\u6570\u636e\u65f6\u51fa\u9519\uff0c\u5c06\u76f4\u63a5\u8fd4\u56de\u4e4b\u524d\u7684\u6570\u636e.", (Throwable)e);
            MeasureResult measureResult = this.measureStatistician.get();
            return measureResult;
        }
        finally {
            this.statisLock.unlock();
        }
    }

    @Override
    public long getStartNanoTime() {
        return this.startNanoTime;
    }

    @Override
    public long getEndNanoTime() {
        return this.endNanoTime;
    }
}

