/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.stalker.result;

import com.blinkfox.stalker.config.Options;
import com.blinkfox.stalker.config.ScheduledUpdater;
import com.blinkfox.stalker.kit.StrKit;
import com.blinkfox.stalker.output.MeasureOutputContext;
import com.blinkfox.stalker.result.MeasureResult;
import com.blinkfox.stalker.runner.MeasureRunner;
import com.blinkfox.stalker.runner.executor.StalkerExecutors;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StalkerFuture
implements RunnableFuture<List<Object>> {
    private static final Logger log = LoggerFactory.getLogger(StalkerFuture.class);
    private static final ExecutorService executor = StalkerExecutors.newThreadExecutor(4, 16, "stalker-future-thread");
    private ScheduledExecutorService scheduledUpdateExecutor;
    private final Options options;
    private final Runnable runnable;
    private final MeasureRunner measureRunner;
    private CompletableFuture<Void> runFuture;
    private ScheduledFuture<?> scheduledUpdateFuture;

    public StalkerFuture(Options options, Runnable runnable, MeasureRunner measureRunner) {
        this.options = options;
        this.runnable = runnable;
        this.measureRunner = measureRunner;
        ScheduledUpdater scheduledUpdater = options.getScheduledUpdater();
        if (scheduledUpdater != null && scheduledUpdater.isEnabled()) {
            this.scheduledUpdateExecutor = StalkerExecutors.newScheduledThreadPool(1, "scheduled-update-thread");
            long delay = scheduledUpdater.getDelay();
            TimeUnit timeUnit = scheduledUpdater.getTimeUnit();
            this.scheduledUpdateFuture = this.scheduledUpdateExecutor.scheduleWithFixedDelay(() -> {
                if (log.isDebugEnabled()) {
                    log.debug("\u3010Stalker \u63d0\u793a\u3011\u5f00\u59cb\u4e86\u6bcf\u9694\u3010{}\u3011\u6267\u884c\u4e00\u6b21\u5b9a\u65f6\u66f4\u65b0\u7edf\u8ba1\u6570\u636e\u7684\u5b9a\u65f6\u4efb\u52a1.", (Object)StrKit.convertTimeUnit(delay, timeUnit));
                }
                this.measureRunner.getMeasureResult();
            }, scheduledUpdater.getInitialDelay(), delay, timeUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.runFuture != null) {
            return;
        }
        StalkerFuture stalkerFuture = this;
        synchronized (stalkerFuture) {
            if (this.runFuture == null) {
                this.runFuture = CompletableFuture.runAsync(() -> this.measureRunner.run(this.options, this.runnable), executor);
                this.runFuture.whenComplete((a, e) -> this.stopFutures());
            }
        }
    }

    public StalkerFuture waitDone() {
        return this.waitDone(null, 500L);
    }

    public StalkerFuture waitDone(long period) {
        return this.waitDone(null, period);
    }

    public StalkerFuture waitDone(Consumer<StalkerFuture> waitPeriodConsumer) {
        return this.waitDone(waitPeriodConsumer, 1000L);
    }

    public StalkerFuture waitDone(Consumer<StalkerFuture> waitPeriodConsumer, long period) {
        while (!this.isDone()) {
            if (waitPeriodConsumer != null) {
                waitPeriodConsumer.accept(this);
            }
            this.sleep(period);
        }
        return this;
    }

    public StalkerFuture done(Consumer<StalkerFuture> futureConsumer) {
        while (!this.isDone()) {
            this.sleep(200L);
        }
        if (futureConsumer != null) {
            futureConsumer.accept(this);
        }
        return this;
    }

    private void sleep(long time) {
        try {
            TimeUnit.MILLISECONDS.sleep(time);
        }
        catch (InterruptedException e) {
            log.error("\u3010Stalker \u9519\u8bef\u3011\u5728\u6bcf\u9694\u3010{} ms\u3011\u6267\u884c\u3010progressRunnable\u3011\u53ef\u8fd0\u884c\u4efb\u52a1\u65f6\u53d1\u751f\u4e2d\u65ad\uff0c\u4e2d\u65ad\u539f\u56e0\uff1a\u3010{}\u3011.", (Object)time, (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    public boolean cancel() {
        return this.cancel(true);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isCancelled()) {
            return true;
        }
        boolean flag = true;
        try {
            this.measureRunner.stop();
        }
        catch (Exception e) {
            log.error("\u3010Stalker \u9519\u8bef\u63d0\u793a\u3011\u53d6\u6d88\u6b63\u5728\u6267\u884c\u4e2d\u7684\u6d4b\u91cf\u4efb\u52a1\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
            flag = false;
        }
        this.stopFutures();
        return flag;
    }

    private void stopFutures() {
        if (this.runFuture != null && !this.runFuture.isDone()) {
            this.runFuture.cancel(true);
        }
        if (this.scheduledUpdateExecutor != null && !this.scheduledUpdateExecutor.isShutdown()) {
            this.scheduledUpdateExecutor.shutdown();
        }
        if (this.scheduledUpdateFuture != null && !this.scheduledUpdateFuture.isDone()) {
            this.scheduledUpdateFuture.cancel(false);
        }
        log.debug("\u3010Stalker \u63d0\u793a\u3011\u5df2\u5173\u95ed\u505c\u6b62\u4e86\u76f8\u5173\u7684\u7ebf\u7a0b\u6c60\u6216\u5f02\u6b65\u4efb\u52a1.");
    }

    @Override
    public boolean isCancelled() {
        return this.measureRunner.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.measureRunner.isCompleted();
    }

    public boolean isDoneSuccessfully() {
        return this.measureRunner.isCompleted() && !this.measureRunner.isCancelled();
    }

    public Object getFirst() {
        List<Object> results = new MeasureOutputContext().output(this.options, this.getMeasureResult());
        return results.size() > 0 ? results.get(0) : null;
    }

    @Override
    public List<Object> get() {
        return new MeasureOutputContext().output(this.options, this.getMeasureResult());
    }

    @Override
    public List<Object> get(long timeout, TimeUnit unit) {
        return this.get();
    }

    public MeasureResult getMeasureResult() {
        return this.measureRunner.getMeasureResult();
    }

    public long getCosts() {
        return this.measureRunner.getCosts();
    }

    public long getTotal() {
        return this.measureRunner.getTotal();
    }

    public long getSuccess() {
        return this.measureRunner.getSuccess();
    }

    public long getFailure() {
        return this.measureRunner.getFailure();
    }

    public long getStartNanoTime() {
        return this.measureRunner.getStartNanoTime();
    }

    public long getEndNanoTime() {
        return this.measureRunner.getEndNanoTime();
    }

    public MeasureRunner getMeasureRunner() {
        return this.measureRunner;
    }
}

